/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.partition;

import com.gemstone.gemfire.InternalGemFireError;
import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.PartitionAttributes;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.partition.PartitionManager;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.internal.cache.ForceReattemptException;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import dunit.AsyncInvocation;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.RMIException;
import dunit.SerializableRunnable;
import dunit.VM;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import junit.framework.TestCase;

public class PartitionManagerDUnitTest
extends CacheTestCase {
    private static final int BUCKET_ID = 5;
    protected static final long CONCURRENT_TIME = 10L;
    protected static final long MAX_WAIT = 60000L;

    public PartitionManagerDUnitTest(String name) {
        super(name);
    }

    public void testDestroyExistingRemote() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        SerializableRunnable createPrRegion = new SerializableRunnable("createRegion"){

            @Override
            public void run() {
                Cache cache = PartitionManagerDUnitTest.this.getCache();
                AttributesFactory attr = new AttributesFactory();
                PartitionAttributesFactory paf = new PartitionAttributesFactory();
                paf.setRedundantCopies(0);
                paf.setRecoveryDelay(-1L);
                paf.setStartupRecoveryDelay(-1L);
                PartitionAttributes prAttr = paf.create();
                attr.setPartitionAttributes(prAttr);
                cache.createRegion("region1", attr.create());
            }
        };
        vm0.invoke(createPrRegion);
        vm1.invoke(createPrRegion);
        this.createPrimaryBucket(vm0, true, false);
        this.assertNotPrimary(vm1);
        this.createPrimaryBucket(vm1, true, false);
        this.assertNotPrimary(vm0);
        vm1.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                Cache cache = PartitionManagerDUnitTest.this.getCache();
                PartitionedRegion region = (PartitionedRegion)cache.getRegion("region1");
                region.put((Object)5, (Object)"B");
            }
        });
        this.createPrimaryBucket(vm1, true, false);
        vm1.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                Cache cache = PartitionManagerDUnitTest.this.getCache();
                PartitionedRegion region = (PartitionedRegion)cache.getRegion("region1");
                TestCase.assertEquals((Object)"B", (Object)region.get((Object)5));
            }
        });
        this.createPrimaryBucket(vm0, true, false);
        vm1.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                Cache cache = PartitionManagerDUnitTest.this.getCache();
                PartitionedRegion region = (PartitionedRegion)cache.getRegion("region1");
                TestCase.assertEquals(null, (Object)region.get((Object)5));
            }
        });
    }

    public void testDestroyExistingBoth() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        SerializableRunnable createPrRegion = new SerializableRunnable("createRegion"){

            @Override
            public void run() {
                Cache cache = PartitionManagerDUnitTest.this.getCache();
                AttributesFactory attr = new AttributesFactory();
                PartitionAttributesFactory paf = new PartitionAttributesFactory();
                paf.setRedundantCopies(0);
                paf.setRecoveryDelay(-1L);
                paf.setStartupRecoveryDelay(-1L);
                PartitionAttributes prAttr = paf.create();
                attr.setPartitionAttributes(prAttr);
                cache.createRegion("region1", attr.create());
            }
        };
        vm0.invoke(createPrRegion);
        vm1.invoke(createPrRegion);
        this.createPrimaryBucket(vm0, true, true);
        this.createPrimaryBucket(vm1, true, true);
        vm1.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                Cache cache = PartitionManagerDUnitTest.this.getCache();
                PartitionedRegion region = (PartitionedRegion)cache.getRegion("region1");
                region.put((Object)5, (Object)"B");
            }
        });
        this.createPrimaryBucket(vm1, true, true);
        vm1.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                Cache cache = PartitionManagerDUnitTest.this.getCache();
                PartitionedRegion region = (PartitionedRegion)cache.getRegion("region1");
                TestCase.assertEquals(null, (Object)region.get((Object)5));
            }
        });
    }

    public void testDestroyExistingLocal() {
        VM vm1;
        VM vm0;
        block2: {
            Host host = Host.getHost(0);
            vm0 = host.getVM(0);
            vm1 = host.getVM(1);
            SerializableRunnable createPrRegion = new SerializableRunnable("createRegion"){

                @Override
                public void run() {
                    Cache cache = PartitionManagerDUnitTest.this.getCache();
                    AttributesFactory attr = new AttributesFactory();
                    PartitionAttributesFactory paf = new PartitionAttributesFactory();
                    paf.setRedundantCopies(0);
                    paf.setRecoveryDelay(-1L);
                    paf.setStartupRecoveryDelay(-1L);
                    PartitionAttributes prAttr = paf.create();
                    attr.setPartitionAttributes(prAttr);
                    cache.createRegion("region1", attr.create());
                }
            };
            vm0.invoke(createPrRegion);
            vm1.invoke(createPrRegion);
            this.createPrimaryBucket(vm0, false, true);
            try {
                this.createPrimaryBucket(vm1, false, false);
            }
            catch (RMIException e) {
                if (e.getCause() instanceof IllegalStateException) break block2;
                throw e;
            }
        }
        vm0.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                Cache cache = PartitionManagerDUnitTest.this.getCache();
                PartitionedRegion region = (PartitionedRegion)cache.getRegion("region1");
                region.put((Object)5, (Object)"B");
            }
        });
        this.createPrimaryBucket(vm0, false, true);
        vm1.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                Cache cache = PartitionManagerDUnitTest.this.getCache();
                PartitionedRegion region = (PartitionedRegion)cache.getRegion("region1");
                TestCase.assertEquals(null, (Object)region.get((Object)5));
            }
        });
    }

    public void testDestroyExistingNeither() {
        VM vm1;
        VM vm0;
        block5: {
            block4: {
                Host host = Host.getHost(0);
                vm0 = host.getVM(0);
                vm1 = host.getVM(1);
                SerializableRunnable createPrRegion = new SerializableRunnable("createRegion"){

                    @Override
                    public void run() {
                        Cache cache = PartitionManagerDUnitTest.this.getCache();
                        AttributesFactory attr = new AttributesFactory();
                        PartitionAttributesFactory paf = new PartitionAttributesFactory();
                        paf.setRedundantCopies(0);
                        paf.setRecoveryDelay(-1L);
                        paf.setStartupRecoveryDelay(-1L);
                        PartitionAttributes prAttr = paf.create();
                        attr.setPartitionAttributes(prAttr);
                        cache.createRegion("region1", attr.create());
                    }
                };
                vm0.invoke(createPrRegion);
                vm1.invoke(createPrRegion);
                this.createPrimaryBucket(vm0, false, false);
                try {
                    this.createPrimaryBucket(vm1, false, false);
                }
                catch (RMIException e) {
                    if (e.getCause() instanceof IllegalStateException) break block4;
                    throw e;
                }
            }
            try {
                this.createPrimaryBucket(vm0, false, false);
            }
            catch (RMIException e) {
                if (e.getCause() instanceof IllegalStateException) break block5;
                throw e;
            }
        }
        vm0.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                Cache cache = PartitionManagerDUnitTest.this.getCache();
                PartitionedRegion region = (PartitionedRegion)cache.getRegion("region1");
                region.put((Object)5, (Object)"B");
            }
        });
        this.createPrimaryBucket(vm0, false, true);
        vm1.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                Cache cache = PartitionManagerDUnitTest.this.getCache();
                PartitionedRegion region = (PartitionedRegion)cache.getRegion("region1");
                TestCase.assertEquals(null, (Object)region.get((Object)5));
            }
        });
    }

    private void createPrimaryBucket(VM vm0, final boolean destroyRemote, final boolean destroyLocal) {
        vm0.invoke(new SerializableRunnable("Move PR"){

            @Override
            public void run() {
                Cache cache = PartitionManagerDUnitTest.this.getCache();
                final PartitionedRegion region = (PartitionedRegion)cache.getRegion("region1");
                PartitionManager.createPrimaryBucket((Region)region, (int)5, (boolean)destroyRemote, (boolean)destroyLocal);
                DistributedTestCase.waitForCriterion(new DistributedTestCase.WaitCriterion(){

                    @Override
                    public boolean done() {
                        return region.getBucketPrimary(5) != null;
                    }

                    @Override
                    public String description() {
                        return null;
                    }
                }, 10000L, 100L, false);
                TestCase.assertEquals((Object)cache.getDistributedSystem().getDistributedMember(), (Object)region.getBucketPrimary(5));
                Set owners = region.getDataStore().getLocalBucketById(Integer.valueOf(5)).getBucketOwners();
                TestCase.assertEquals((int)1, (int)owners.size());
            }
        });
    }

    private void assertNotPrimary(VM vm0) {
        vm0.invoke(new SerializableRunnable("Move PR"){

            @Override
            public void run() {
                Cache cache = PartitionManagerDUnitTest.this.getCache();
                PartitionedRegion region = (PartitionedRegion)cache.getRegion("region1");
                TestCase.assertFalse((boolean)region.getBucketPrimary(5).equals((Object)cache.getDistributedSystem().getDistributedMember()));
            }
        });
    }

    public void testConcurrent() throws Throwable {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        SerializableRunnable createPrRegion = new SerializableRunnable("createRegion"){

            @Override
            public void run() {
                Cache cache = PartitionManagerDUnitTest.this.getCache();
                AttributesFactory attr = new AttributesFactory();
                PartitionAttributesFactory paf = new PartitionAttributesFactory();
                paf.setRedundantCopies(0);
                paf.setRecoveryDelay(-1L);
                paf.setStartupRecoveryDelay(-1L);
                PartitionAttributes prAttr = paf.create();
                attr.setPartitionAttributes(prAttr);
                cache.createRegion("region1", attr.create());
            }
        };
        vm0.invoke(createPrRegion);
        vm1.invoke(createPrRegion);
        SerializableRunnable hungryHungryPrimary = new SerializableRunnable("Try to grab the primary a lot"){

            @Override
            public void run() {
                Cache cache = PartitionManagerDUnitTest.this.getCache();
                PartitionedRegion region = (PartitionedRegion)cache.getRegion("region1");
                long start = System.nanoTime();
                while (TimeUnit.NANOSECONDS.toSeconds(System.nanoTime() - start) < 10L) {
                    PartitionManager.createPrimaryBucket((Region)region, (int)5, (boolean)true, (boolean)false);
                }
            }
        };
        SerializableRunnable lotsOfPuts = new SerializableRunnable("A bunch of puts"){

            @Override
            public void run() {
                Cache cache = PartitionManagerDUnitTest.this.getCache();
                PartitionedRegion region = (PartitionedRegion)cache.getRegion("region1");
                long start = System.nanoTime();
                while (TimeUnit.NANOSECONDS.toSeconds(System.nanoTime() - start) < 10L) {
                    try {
                        region.put((Object)5, (Object)"B");
                    }
                    catch (InternalGemFireError e) {
                        if (e.getMessage().contains("recordVersion invoked for a local version tag that is higher")) {
                            // empty if block
                        }
                    }
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException e) {
                        DistributedTestCase.fail("", e);
                    }
                }
            }
        };
        AsyncInvocation async0 = vm0.invokeAsync(hungryHungryPrimary);
        AsyncInvocation async1 = vm1.invokeAsync(hungryHungryPrimary);
        AsyncInvocation async0_2 = vm0.invokeAsync(lotsOfPuts);
        AsyncInvocation async1_2 = vm1.invokeAsync(lotsOfPuts);
        async0.getResult(60000L);
        async1.getResult(60000L);
        async0_2.getResult(60000L);
        async1_2.getResult(60000L);
        vm0.invoke(new SerializableRunnable("Check the number of owners"){

            @Override
            public void run() {
                Cache cache = PartitionManagerDUnitTest.this.getCache();
                PartitionedRegion region = (PartitionedRegion)cache.getRegion("region1");
                try {
                    List owners = region.getBucketOwnersForValidation(5);
                    TestCase.assertEquals((int)1, (int)owners.size());
                }
                catch (ForceReattemptException e) {
                    DistributedTestCase.fail("shouldn't have seen force reattempt", e);
                }
            }
        });
    }

    public void testConcurrentWithPuts() throws Throwable {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        SerializableRunnable createPrRegion = new SerializableRunnable("createRegion"){

            @Override
            public void run() {
                Cache cache = PartitionManagerDUnitTest.this.getCache();
                AttributesFactory attr = new AttributesFactory();
                PartitionAttributesFactory paf = new PartitionAttributesFactory();
                paf.setRedundantCopies(0);
                paf.setRecoveryDelay(-1L);
                paf.setStartupRecoveryDelay(-1L);
                PartitionAttributes prAttr = paf.create();
                attr.setPartitionAttributes(prAttr);
                cache.createRegion("region1", attr.create());
            }
        };
        vm0.invoke(createPrRegion);
        vm1.invoke(createPrRegion);
        SerializableRunnable lotsOfPuts = new SerializableRunnable("A bunch of puts"){

            @Override
            public void run() {
                Cache cache = PartitionManagerDUnitTest.this.getCache();
                PartitionedRegion region = (PartitionedRegion)cache.getRegion("region1");
                long start = System.nanoTime();
                while (TimeUnit.NANOSECONDS.toSeconds(System.nanoTime() - start) < 10L) {
                    region.put((Object)5, (Object)"B");
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException e) {
                        DistributedTestCase.fail("", e);
                    }
                }
            }
        };
        AsyncInvocation async0_2 = vm0.invokeAsync(lotsOfPuts);
        AsyncInvocation async1_2 = vm1.invokeAsync(lotsOfPuts);
        long start = System.nanoTime();
        while (TimeUnit.NANOSECONDS.toSeconds(System.nanoTime() - start) < 10L) {
            this.createPrimaryBucket(vm0, true, false);
            this.createPrimaryBucket(vm1, true, false);
        }
        async0_2.getResult(60000L);
        async1_2.getResult(60000L);
        vm0.invoke(new SerializableRunnable("Check the number of owners"){

            @Override
            public void run() {
                Cache cache = PartitionManagerDUnitTest.this.getCache();
                PartitionedRegion region = (PartitionedRegion)cache.getRegion("region1");
                try {
                    List owners = region.getBucketOwnersForValidation(5);
                    TestCase.assertEquals((int)1, (int)owners.size());
                }
                catch (ForceReattemptException e) {
                    DistributedTestCase.fail("shouldn't have seen force reattempt", e);
                }
            }
        });
    }
}

