/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.query.cq.dunit;

import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.query.CqAttributes;
import com.gemstone.gemfire.cache.query.CqAttributesFactory;
import com.gemstone.gemfire.cache.query.CqListener;
import com.gemstone.gemfire.cache.query.CqQuery;
import com.gemstone.gemfire.cache.query.QueryService;
import com.gemstone.gemfire.cache.query.cq.dunit.CqQueryDUnitTest;
import com.gemstone.gemfire.cache.query.cq.dunit.CqTimeTestListener;
import com.gemstone.gemfire.cache.query.internal.CqQueryImpl;
import com.gemstone.gemfire.cache.query.internal.CqService;
import com.gemstone.gemfire.cache.query.internal.DefaultQueryService;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.internal.AvailablePortHelper;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableRunnable;
import dunit.VM;
import java.util.ArrayList;
import java.util.HashMap;
import junit.framework.TestCase;

public class CqPerfDUnitTest
extends CacheTestCase {
    protected CqQueryDUnitTest cqDUnitTest = new CqQueryDUnitTest("CqPerfDUnitTest");

    public CqPerfDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.getSystem();
        CqPerfDUnitTest.invokeInEveryVM(new SerializableRunnable("getSystem"){

            @Override
            public void run() {
                CqPerfDUnitTest.this.getSystem();
            }
        });
    }

    public void perf_testCQPerf() throws Exception {
        Host host = Host.getHost(0);
        VM server = host.getVM(0);
        VM client = host.getVM(1);
        this.cqDUnitTest.createServer(server);
        int port = server.invokeInt(CqQueryDUnitTest.class, "getCacheServerPort");
        String host0 = CqPerfDUnitTest.getServerHostName(server.getHost());
        this.cqDUnitTest.createClient(client, port, host0);
        String cqName = "testCQPerf_0";
        client.invoke(new CacheSerializableRunnable("Create CQ :testCQPerf_0"){

            @Override
            public void run2() throws CacheException {
                DistributedTestCase.getLogWriter().info("### Create CQ. ###testCQPerf_0");
                QueryService cqService = null;
                try {
                    cqService = CqPerfDUnitTest.this.getCache().getQueryService();
                }
                catch (Exception cqe) {
                    cqe.printStackTrace();
                    TestCase.fail((String)"Failed to getCQService.");
                }
                CqAttributesFactory cqf = new CqAttributesFactory();
                CqListener[] cqListeners = new CqListener[]{new CqTimeTestListener(DistributedTestCase.getLogWriter())};
                ((CqTimeTestListener)cqListeners[0]).cqName = "testCQPerf_0";
                cqf.initCqListeners(cqListeners);
                CqAttributes cqa = cqf.create();
                try {
                    CqQuery cq1 = cqService.newCq("testCQPerf_0", CqPerfDUnitTest.this.cqDUnitTest.cqs[0], cqa);
                    TestCase.assertTrue((String)"newCq() state mismatch", (boolean)cq1.getState().isStopped());
                    cq1.execute();
                }
                catch (Exception ex) {
                    DistributedTestCase.getLogWriter().info("CqService is :" + cqService);
                    ex.printStackTrace();
                    AssertionError err = new AssertionError((Object)"Failed to create CQ testCQPerf_0 . ");
                    ((Throwable)((Object)err)).initCause(ex);
                    throw err;
                }
            }
        });
        int size = 50;
        this.cqDUnitTest.createValuesWithTime(client, this.cqDUnitTest.regions[0], 50);
        CqPerfDUnitTest.pause(5000);
        this.cqDUnitTest.createValuesWithTime(client, this.cqDUnitTest.regions[0], 50);
        client.invoke(new CacheSerializableRunnable("Validate CQs"){

            @Override
            public void run2() throws CacheException {
                DistributedTestCase.getLogWriter().info("### Validating CQ. ### testCQPerf_0");
                QueryService cqService = null;
                try {
                    cqService = CqPerfDUnitTest.this.getCache().getQueryService();
                }
                catch (Exception cqe) {
                    cqe.printStackTrace();
                    TestCase.fail((String)"Failed to getCqService.");
                }
                CqQuery cQuery = cqService.getCq("testCQPerf_0");
                if (cQuery == null) {
                    TestCase.fail((String)"Failed to get CqQuery for CQ : testCQPerf_0");
                }
            }
        });
        CqPerfDUnitTest.pause(600000);
        this.cqDUnitTest.closeClient(client);
        this.cqDUnitTest.closeServer(server);
    }

    public void testKeyMaintainance() throws Exception {
        Host host = Host.getHost(0);
        VM server = host.getVM(0);
        VM client = host.getVM(1);
        this.cqDUnitTest.createServer(server);
        int port = server.invokeInt(CqQueryDUnitTest.class, "getCacheServerPort");
        String host0 = CqPerfDUnitTest.getServerHostName(server.getHost());
        this.cqDUnitTest.createClient(client, port, host0);
        int cqSize = 2;
        this.cqDUnitTest.createCQ(client, "testKeyMaintainance_0", this.cqDUnitTest.cqs[0]);
        this.cqDUnitTest.executeCQ(client, "testKeyMaintainance_0", false, null);
        this.cqDUnitTest.createCQ(client, "testKeyMaintainance_1", this.cqDUnitTest.cqs[10]);
        this.cqDUnitTest.executeCQ(client, "testKeyMaintainance_1", false, null);
        this.cqDUnitTest.createValues(server, this.cqDUnitTest.regions[0], 1);
        this.cqDUnitTest.waitForCreated(client, "testKeyMaintainance_0", "key-1");
        server.invoke(new CacheSerializableRunnable("LookForCachedEventKeys1"){

            @Override
            public void run2() throws CacheException {
                CqQuery[] cqs;
                CqService cqService = null;
                try {
                    cqService = ((DefaultQueryService)CqPerfDUnitTest.this.getCache().getQueryService()).getCqService();
                }
                catch (Exception ex) {
                    DistributedTestCase.getLogWriter().info("Failed to get the internal CqService.", (Throwable)ex);
                    DistributedTestCase.fail("Failed to get the internal CqService.", ex);
                }
                for (CqQuery cq : cqs = cqService.getAllCqs()) {
                    CqQueryImpl cqQuery = (CqQueryImpl)cq;
                    String serverCqName = cqQuery.getServerCqName();
                    if (serverCqName.startsWith("testKeyMaintainance_0")) {
                        TestCase.assertEquals((String)"The number of keys cached for cq testKeyMaintainance_0 is wrong.", (int)1, (int)cqQuery.getCqResultKeysSize());
                        continue;
                    }
                    if (!serverCqName.startsWith("testKeyMaintainance_1")) continue;
                    TestCase.assertEquals((String)"The number of keys cached for cq testKeyMaintainance_1 is wrong.", (int)0, (int)cqQuery.getCqResultKeysSize());
                }
            }
        });
        this.cqDUnitTest.createValues(server, this.cqDUnitTest.regions[0], 10);
        this.cqDUnitTest.waitForCreated(client, "testKeyMaintainance_0", "key-10");
        server.invoke(new CacheSerializableRunnable("LookForCachedEventKeysAfterUpdate1"){

            @Override
            public void run2() throws CacheException {
                CqQuery[] cqs;
                CqService cqService = null;
                try {
                    cqService = ((DefaultQueryService)CqPerfDUnitTest.this.getCache().getQueryService()).getCqService();
                }
                catch (Exception ex) {
                    DistributedTestCase.getLogWriter().info("Failed to get the internal CqService.", (Throwable)ex);
                    DistributedTestCase.fail("Failed to get the internal CqService.", ex);
                }
                for (CqQuery cq : cqs = cqService.getAllCqs()) {
                    CqQueryImpl cqQuery = (CqQueryImpl)cq;
                    String serverCqName = cqQuery.getServerCqName();
                    if (serverCqName.startsWith("testKeyMaintainance_0")) {
                        TestCase.assertEquals((String)"The number of keys cached for cq testKeyMaintainance_0 is wrong.", (int)10, (int)cqQuery.getCqResultKeysSize());
                        continue;
                    }
                    if (!serverCqName.startsWith("testKeyMaintainance_1")) continue;
                    TestCase.assertEquals((String)"The number of keys cached for cq testKeyMaintainance_1 is wrong.", (int)5, (int)cqQuery.getCqResultKeysSize());
                }
            }
        });
        this.cqDUnitTest.createValues(server, this.cqDUnitTest.regions[0], 12);
        this.cqDUnitTest.waitForCreated(client, "testKeyMaintainance_0", "key-12");
        server.invoke(new CacheSerializableRunnable("LookForCachedEventKeysAfterUpdate2"){

            @Override
            public void run2() throws CacheException {
                CqQuery[] cqs;
                CqService cqService = null;
                try {
                    cqService = ((DefaultQueryService)CqPerfDUnitTest.this.getCache().getQueryService()).getCqService();
                }
                catch (Exception ex) {
                    DistributedTestCase.getLogWriter().info("Failed to get the internal CqService.", (Throwable)ex);
                    DistributedTestCase.fail("Failed to get the internal CqService.", ex);
                }
                for (CqQuery cq : cqs = cqService.getAllCqs()) {
                    CqQueryImpl cqQuery = (CqQueryImpl)cq;
                    String serverCqName = cqQuery.getServerCqName();
                    if (serverCqName.startsWith("testKeyMaintainance_0")) {
                        TestCase.assertEquals((String)"The number of keys cached for cq testKeyMaintainance_0 is wrong.", (int)12, (int)cqQuery.getCqResultKeysSize());
                        continue;
                    }
                    if (!serverCqName.startsWith("testKeyMaintainance_1")) continue;
                    TestCase.assertEquals((String)"The number of keys cached for cq testKeyMaintainance_1 is wrong.", (int)6, (int)cqQuery.getCqResultKeysSize());
                }
            }
        });
        this.cqDUnitTest.deleteValues(server, this.cqDUnitTest.regions[0], 6);
        this.cqDUnitTest.waitForDestroyed(client, "testKeyMaintainance_0", "key-6");
        server.invoke(new CacheSerializableRunnable("LookForCachedEventKeysAfterUpdate2"){

            @Override
            public void run2() throws CacheException {
                CqQuery[] cqs;
                CqService cqService = null;
                try {
                    cqService = ((DefaultQueryService)CqPerfDUnitTest.this.getCache().getQueryService()).getCqService();
                }
                catch (Exception ex) {
                    DistributedTestCase.getLogWriter().info("Failed to get the internal CqService.", (Throwable)ex);
                    DistributedTestCase.fail("Failed to get the internal CqService.", ex);
                }
                for (CqQuery cq : cqs = cqService.getAllCqs()) {
                    CqQueryImpl cqQuery = (CqQueryImpl)cq;
                    String serverCqName = cqQuery.getServerCqName();
                    if (serverCqName.startsWith("testKeyMaintainance_0")) {
                        TestCase.assertEquals((String)"The number of keys cached for cq testKeyMaintainance_0 is wrong.", (int)6, (int)cqQuery.getCqResultKeysSize());
                        continue;
                    }
                    if (!serverCqName.startsWith("testKeyMaintainance_1")) continue;
                    TestCase.assertEquals((String)"The number of keys cached for cq testKeyMaintainance_1 is wrong.", (int)3, (int)cqQuery.getCqResultKeysSize());
                }
            }
        });
        this.cqDUnitTest.stopCQ(client, "testKeyMaintainance_1");
        this.cqDUnitTest.createValues(server, this.cqDUnitTest.regions[0], 12);
        server.invoke(new CacheSerializableRunnable("LookForCachedEventKeysAfterUpdate2"){

            @Override
            public void run2() throws CacheException {
                CqQuery[] cqs;
                CqService cqService = null;
                try {
                    cqService = ((DefaultQueryService)CqPerfDUnitTest.this.getCache().getQueryService()).getCqService();
                }
                catch (Exception ex) {
                    DistributedTestCase.getLogWriter().info("Failed to get the internal CqService.", (Throwable)ex);
                    DistributedTestCase.fail("Failed to get the internal CqService.", ex);
                }
                for (CqQuery cq : cqs = cqService.getAllCqs()) {
                    CqQueryImpl cqQuery = (CqQueryImpl)cq;
                    String serverCqName = cqQuery.getServerCqName();
                    if (serverCqName.startsWith("testKeyMaintainance_0")) {
                        TestCase.assertEquals((String)"The number of keys cached for cq testKeyMaintainance_0 is wrong.", (int)12, (int)cqQuery.getCqResultKeysSize());
                        continue;
                    }
                    if (!serverCqName.startsWith("testKeyMaintainance_1")) continue;
                    TestCase.assertEquals((String)"The number of keys cached for cq testKeyMaintainance_1 is wrong.", (int)6, (int)cqQuery.getCqResultKeysSize());
                }
            }
        });
        this.cqDUnitTest.executeCQ(client, "testKeyMaintainance_1", false, null);
        this.cqDUnitTest.closeCQ(client, "testKeyMaintainance_1");
        server.invoke(new CacheSerializableRunnable("LookForCachedEventKeysAfterUpdate2"){

            @Override
            public void run2() throws CacheException {
                CqQuery[] cqs;
                CqService cqService = null;
                try {
                    cqService = ((DefaultQueryService)CqPerfDUnitTest.this.getCache().getQueryService()).getCqService();
                }
                catch (Exception ex) {
                    DistributedTestCase.getLogWriter().info("Failed to get the internal CqService.", (Throwable)ex);
                    DistributedTestCase.fail("Failed to get the internal CqService.", ex);
                }
                for (CqQuery cq : cqs = cqService.getAllCqs()) {
                    CqQueryImpl cqQuery = (CqQueryImpl)cq;
                    String serverCqName = cqQuery.getServerCqName();
                    if (serverCqName.startsWith("testKeyMaintainance_0")) {
                        TestCase.assertEquals((String)"The number of keys cached for cq testKeyMaintainance_0 is wrong.", (int)12, (int)cqQuery.getCqResultKeysSize());
                        continue;
                    }
                    if (!serverCqName.startsWith("testKeyMaintainance_1")) continue;
                    TestCase.fail((String)"The key maintainance should not be present for this CQ.");
                }
            }
        });
        this.cqDUnitTest.closeClient(client);
        this.cqDUnitTest.closeServer(server);
    }

    public void testMatchingCqs() throws Exception {
        Host host = Host.getHost(0);
        VM server = host.getVM(0);
        VM client = host.getVM(1);
        this.cqDUnitTest.createServer(server);
        int port = server.invokeInt(CqQueryDUnitTest.class, "getCacheServerPort");
        String host0 = CqPerfDUnitTest.getServerHostName(server.getHost());
        this.cqDUnitTest.createClient(client, port, host0);
        for (int i = 0; i < 4; ++i) {
            this.cqDUnitTest.createCQ(client, "testMatchingCqs_" + i, this.cqDUnitTest.cqs[0]);
            this.cqDUnitTest.executeCQ(client, "testMatchingCqs_" + i, false, null);
        }
        this.validateMatchingCqs(server, 1, this.cqDUnitTest.cqs[0], 4);
        int size = 1;
        this.cqDUnitTest.createValues(server, this.cqDUnitTest.regions[0], size);
        this.cqDUnitTest.waitForCreated(client, "testMatchingCqs_0", "key-" + size);
        this.cqDUnitTest.waitForCreated(client, "testMatchingCqs_3", "key-" + size);
        this.cqDUnitTest.closeCQ(client, "testMatchingCqs_0");
        this.validateMatchingCqs(server, 1, this.cqDUnitTest.cqs[0], 3);
        this.cqDUnitTest.createValues(server, this.cqDUnitTest.regions[0], size);
        this.cqDUnitTest.waitForUpdated(client, "testMatchingCqs_3", "key-" + size);
        this.cqDUnitTest.stopCQ(client, "testMatchingCqs_1");
        this.validateMatchingCqs(server, 1, this.cqDUnitTest.cqs[0], 2);
        this.cqDUnitTest.clearCQListenerEvents(client, "testMatchingCqs_3");
        this.cqDUnitTest.createValues(server, this.cqDUnitTest.regions[0], size);
        this.cqDUnitTest.waitForUpdated(client, "testMatchingCqs_3", "key-" + size);
        this.cqDUnitTest.validateCQ(client, "testMatchingCqs_1", CqQueryDUnitTest.noTest, size, size, 0, size, size, 0, size * 2);
        this.cqDUnitTest.executeCQ(client, "testMatchingCqs_1", false, null);
        this.cqDUnitTest.clearCQListenerEvents(client, "testMatchingCqs_3");
        this.cqDUnitTest.createValues(server, this.cqDUnitTest.regions[0], size);
        this.cqDUnitTest.waitForUpdated(client, "testMatchingCqs_3", "key-" + size);
        this.cqDUnitTest.validateCQ(client, "testMatchingCqs_1", CqQueryDUnitTest.noTest, size, size * 2, 0, size, size * 2, 0, size * 3);
        this.cqDUnitTest.createCQ(client, "testMatchingCqs_4", this.cqDUnitTest.cqs[1]);
        this.cqDUnitTest.executeCQ(client, "testMatchingCqs_4", false, null);
        this.cqDUnitTest.createCQ(client, "testMatchingCqs_5", this.cqDUnitTest.cqs[1]);
        this.cqDUnitTest.executeCQ(client, "testMatchingCqs_5", false, null);
        this.cqDUnitTest.createCQ(client, "testMatchingCqs_6", this.cqDUnitTest.cqs[2]);
        this.cqDUnitTest.executeCQ(client, "testMatchingCqs_6", false, null);
        this.validateMatchingCqs(server, 3, this.cqDUnitTest.cqs[1], 2);
        this.cqDUnitTest.closeCQ(client, "testMatchingCqs_6");
        this.validateMatchingCqs(server, 2, this.cqDUnitTest.cqs[1], 2);
        this.cqDUnitTest.closeCQ(client, "testMatchingCqs_5");
        this.cqDUnitTest.closeCQ(client, "testMatchingCqs_4");
        this.cqDUnitTest.closeCQ(client, "testMatchingCqs_3");
        this.cqDUnitTest.closeCQ(client, "testMatchingCqs_2");
        this.cqDUnitTest.closeCQ(client, "testMatchingCqs_1");
        this.validateMatchingCqs(server, 0, null, 0);
        this.cqDUnitTest.createValues(server, this.cqDUnitTest.regions[0], size);
        this.cqDUnitTest.closeClient(client);
        this.cqDUnitTest.closeServer(server);
    }

    public void testMatchingCQWithMultipleClients() throws Exception {
        int clientIndex;
        Host host = Host.getHost(0);
        VM server = host.getVM(0);
        VM client1 = host.getVM(1);
        VM client2 = host.getVM(2);
        VM client3 = host.getVM(3);
        VM[] clients = new VM[]{client1, client2, client3};
        this.cqDUnitTest.createServer(server);
        int port = server.invokeInt(CqQueryDUnitTest.class, "getCacheServerPort");
        String host0 = CqPerfDUnitTest.getServerHostName(server.getHost());
        for (int clientIndex2 = 0; clientIndex2 < 3; ++clientIndex2) {
            this.cqDUnitTest.createClient(clients[clientIndex2], port, host0);
            for (int i = 0; i < 4; ++i) {
                this.cqDUnitTest.createCQ(clients[clientIndex2], "testMatchingCQWithMultipleClients_" + i, this.cqDUnitTest.cqs[0]);
                this.cqDUnitTest.executeCQ(clients[clientIndex2], "testMatchingCQWithMultipleClients_" + i, false, null);
            }
        }
        this.validateMatchingCqs(server, 1, this.cqDUnitTest.cqs[0], clients.length * 4);
        int size = 1;
        this.cqDUnitTest.createValues(server, this.cqDUnitTest.regions[0], size);
        for (clientIndex = 0; clientIndex < 3; ++clientIndex) {
            this.cqDUnitTest.waitForCreated(clients[clientIndex], "testMatchingCQWithMultipleClients_0", "key-" + size);
            this.cqDUnitTest.waitForCreated(clients[clientIndex], "testMatchingCQWithMultipleClients_3", "key-" + size);
        }
        this.cqDUnitTest.closeCQ(client1, "testMatchingCQWithMultipleClients_0");
        this.validateMatchingCqs(server, 1, this.cqDUnitTest.cqs[0], clients.length * 4 - 1);
        this.cqDUnitTest.createValues(server, this.cqDUnitTest.regions[0], size);
        for (clientIndex = 0; clientIndex < 3; ++clientIndex) {
            this.cqDUnitTest.waitForUpdated(clients[clientIndex], "testMatchingCQWithMultipleClients_3", "key-" + size);
        }
        this.cqDUnitTest.stopCQ(client2, "testMatchingCQWithMultipleClients_1");
        this.validateMatchingCqs(server, 1, this.cqDUnitTest.cqs[0], clients.length * 4 - 2);
        for (clientIndex = 0; clientIndex < 3; ++clientIndex) {
            this.cqDUnitTest.clearCQListenerEvents(clients[clientIndex], "testMatchingCQWithMultipleClients_3");
        }
        this.cqDUnitTest.createValues(server, this.cqDUnitTest.regions[0], size);
        for (clientIndex = 0; clientIndex < 3; ++clientIndex) {
            this.cqDUnitTest.waitForUpdated(clients[clientIndex], "testMatchingCQWithMultipleClients_3", "key-" + size);
        }
        this.cqDUnitTest.validateCQ(client2, "testMatchingCQWithMultipleClients_1", CqQueryDUnitTest.noTest, size, size, 0, size, size, 0, size * 2);
        this.cqDUnitTest.executeCQ(client2, "testMatchingCQWithMultipleClients_1", false, null);
        for (clientIndex = 0; clientIndex < 3; ++clientIndex) {
            this.cqDUnitTest.clearCQListenerEvents(clients[clientIndex], "testMatchingCQWithMultipleClients_3");
        }
        this.validateMatchingCqs(server, 1, this.cqDUnitTest.cqs[0], clients.length * 4 - 1);
        this.cqDUnitTest.createValues(server, this.cqDUnitTest.regions[0], size);
        for (clientIndex = 0; clientIndex < 3; ++clientIndex) {
            this.cqDUnitTest.waitForUpdated(clients[clientIndex], "testMatchingCQWithMultipleClients_3", "key-" + size);
        }
        this.cqDUnitTest.validateCQ(client2, "testMatchingCQWithMultipleClients_1", CqQueryDUnitTest.noTest, size, size * 2, 0, size, size * 2, 0, size * 3);
        for (clientIndex = 0; clientIndex < 3; ++clientIndex) {
            this.cqDUnitTest.createCQ(clients[clientIndex], "testMatchingCQWithMultipleClients_4", this.cqDUnitTest.cqs[1]);
            this.cqDUnitTest.executeCQ(clients[clientIndex], "testMatchingCQWithMultipleClients_4", false, null);
            this.cqDUnitTest.createCQ(clients[clientIndex], "testMatchingCQWithMultipleClients_5", this.cqDUnitTest.cqs[1]);
            this.cqDUnitTest.executeCQ(clients[clientIndex], "testMatchingCQWithMultipleClients_5", false, null);
            this.cqDUnitTest.createCQ(clients[clientIndex], "testMatchingCQWithMultipleClients_6", this.cqDUnitTest.cqs[2]);
            this.cqDUnitTest.executeCQ(clients[clientIndex], "testMatchingCQWithMultipleClients_6", false, null);
        }
        this.validateMatchingCqs(server, 3, this.cqDUnitTest.cqs[1], 2 * clients.length);
        for (clientIndex = 0; clientIndex < 3; ++clientIndex) {
            this.cqDUnitTest.closeCQ(clients[clientIndex], "testMatchingCQWithMultipleClients_6");
        }
        this.validateMatchingCqs(server, 2, this.cqDUnitTest.cqs[1], 2 * clients.length);
        this.cqDUnitTest.createValues(server, this.cqDUnitTest.regions[0], size);
        this.cqDUnitTest.closeClient(client3);
        this.validateMatchingCqs(server, 2, this.cqDUnitTest.cqs[1], 2 * (clients.length - 1));
        for (clientIndex = 0; clientIndex < 2; ++clientIndex) {
            this.cqDUnitTest.closeCQ(clients[clientIndex], "testMatchingCQWithMultipleClients_5");
            this.cqDUnitTest.closeCQ(clients[clientIndex], "testMatchingCQWithMultipleClients_4");
            this.cqDUnitTest.closeCQ(clients[clientIndex], "testMatchingCQWithMultipleClients_3");
            this.cqDUnitTest.closeCQ(clients[clientIndex], "testMatchingCQWithMultipleClients_2");
            this.cqDUnitTest.closeCQ(clients[clientIndex], "testMatchingCQWithMultipleClients_1");
            if (clientIndex == 0) continue;
            this.cqDUnitTest.closeCQ(clients[clientIndex], "testMatchingCQWithMultipleClients_0");
        }
        this.validateMatchingCqs(server, 0, null, 0);
        this.cqDUnitTest.closeClient(client2);
        this.cqDUnitTest.closeClient(client1);
        this.cqDUnitTest.closeServer(server);
    }

    public void testMatchingCQsWithMultipleServers() throws Exception {
        int i;
        int i2;
        Host host = Host.getHost(0);
        VM server1 = host.getVM(0);
        VM server2 = host.getVM(1);
        VM client1 = host.getVM(2);
        VM client2 = host.getVM(3);
        this.cqDUnitTest.createServer(server1);
        VM[] clients = new VM[]{client1, client2};
        int port1 = server1.invokeInt(CqQueryDUnitTest.class, "getCacheServerPort");
        String host0 = CqPerfDUnitTest.getServerHostName(server1.getHost());
        int[] ports = AvailablePortHelper.getRandomAvailableTCPPorts(1);
        this.cqDUnitTest.createClient(client1, new int[]{port1, ports[0]}, host0, "-1");
        this.cqDUnitTest.createClient(client2, new int[]{port1, ports[0]}, host0, "-1");
        int numCQs = 3;
        for (i2 = 0; i2 < numCQs; ++i2) {
            this.cqDUnitTest.createCQ(client1, "testMatchingCQsWithMultipleServers_" + i2, this.cqDUnitTest.cqs[i2]);
            this.cqDUnitTest.executeCQ(client1, "testMatchingCQsWithMultipleServers_" + i2, false, null);
            this.cqDUnitTest.createCQ(client2, "testMatchingCQsWithMultipleServers_" + i2, this.cqDUnitTest.cqs[i2]);
            this.cqDUnitTest.executeCQ(client2, "testMatchingCQsWithMultipleServers_" + i2, false, null);
        }
        this.validateMatchingCqs(server1, numCQs, this.cqDUnitTest.cqs[0], 1 * clients.length);
        this.validateMatchingCqs(server1, numCQs, this.cqDUnitTest.cqs[1], 1 * clients.length);
        CqPerfDUnitTest.pause(1000);
        this.cqDUnitTest.createValues(server1, this.cqDUnitTest.regions[0], 10);
        this.cqDUnitTest.createValues(server1, this.cqDUnitTest.regions[1], 10);
        for (i2 = 1; i2 <= 10; ++i2) {
            this.cqDUnitTest.waitForCreated(client1, "testMatchingCQsWithMultipleServers_0", "key-" + i2);
        }
        CqPerfDUnitTest.pause(1000);
        this.cqDUnitTest.createServer(server2, ports[0]);
        int port2 = server2.invokeInt(CqQueryDUnitTest.class, "getCacheServerPort");
        System.out.println("### Port on which server1 running : " + port1 + " Server2 running : " + port2);
        CqPerfDUnitTest.pause(3000);
        for (int k = 0; k < numCQs; ++k) {
            this.cqDUnitTest.clearCQListenerEvents(client1, "testMatchingCQsWithMultipleServers_" + k);
            this.cqDUnitTest.clearCQListenerEvents(client2, "testMatchingCQsWithMultipleServers_" + k);
        }
        this.cqDUnitTest.createValues(server1, this.cqDUnitTest.regions[0], 10);
        this.cqDUnitTest.createValues(server1, this.cqDUnitTest.regions[1], 10);
        for (int i3 = 1; i3 <= 10; ++i3) {
            this.cqDUnitTest.waitForUpdated(client1, "testMatchingCQsWithMultipleServers_0", "key-" + i3);
            this.cqDUnitTest.waitForUpdated(client2, "testMatchingCQsWithMultipleServers_0", "key-" + i3);
        }
        this.cqDUnitTest.waitForUpdated(client1, "testMatchingCQsWithMultipleServers_2", "key-4");
        this.cqDUnitTest.waitForUpdated(client2, "testMatchingCQsWithMultipleServers_2", "key-4");
        int[] resultsCnt = new int[]{10, 1, 2};
        for (i = 0; i < numCQs; ++i) {
            this.cqDUnitTest.validateCQ(client1, "testMatchingCQsWithMultipleServers_" + i, CqQueryDUnitTest.noTest, resultsCnt[i], resultsCnt[i], CqQueryDUnitTest.noTest);
            this.cqDUnitTest.validateCQ(client2, "testMatchingCQsWithMultipleServers_" + i, CqQueryDUnitTest.noTest, resultsCnt[i], resultsCnt[i], CqQueryDUnitTest.noTest);
        }
        this.cqDUnitTest.closeServer(server1);
        CqPerfDUnitTest.pause(5000);
        this.validateMatchingCqs(server2, numCQs, this.cqDUnitTest.cqs[0], 1 * clients.length);
        for (i = 0; i < numCQs; ++i) {
            this.cqDUnitTest.validateCQ(client1, "testMatchingCQsWithMultipleServers_" + i, CqQueryDUnitTest.noTest, resultsCnt[i], resultsCnt[i], CqQueryDUnitTest.noTest);
            this.cqDUnitTest.validateCQ(client2, "testMatchingCQsWithMultipleServers_" + i, CqQueryDUnitTest.noTest, resultsCnt[i], resultsCnt[i], CqQueryDUnitTest.noTest);
        }
        for (int k = 0; k < numCQs; ++k) {
            this.cqDUnitTest.clearCQListenerEvents(client1, "testMatchingCQsWithMultipleServers_" + k);
            this.cqDUnitTest.clearCQListenerEvents(client2, "testMatchingCQsWithMultipleServers_" + k);
        }
        this.cqDUnitTest.createValues(server2, this.cqDUnitTest.regions[0], 10);
        this.cqDUnitTest.createValues(server2, this.cqDUnitTest.regions[1], 10);
        for (i = 1; i <= resultsCnt[0]; ++i) {
            this.cqDUnitTest.waitForUpdated(client1, "testMatchingCQsWithMultipleServers_0", "key-" + i);
            this.cqDUnitTest.waitForUpdated(client2, "testMatchingCQsWithMultipleServers_0", "key-" + i);
        }
        this.cqDUnitTest.waitForUpdated(client1, "testMatchingCQsWithMultipleServers_2", "key-4");
        this.cqDUnitTest.waitForUpdated(client2, "testMatchingCQsWithMultipleServers_2", "key-4");
        for (i = 0; i < numCQs; ++i) {
            this.cqDUnitTest.validateCQ(client1, "testMatchingCQsWithMultipleServers_" + i, CqQueryDUnitTest.noTest, resultsCnt[i], resultsCnt[i] * 2, CqQueryDUnitTest.noTest);
            this.cqDUnitTest.validateCQ(client2, "testMatchingCQsWithMultipleServers_" + i, CqQueryDUnitTest.noTest, resultsCnt[i], resultsCnt[i] * 2, CqQueryDUnitTest.noTest);
        }
        this.cqDUnitTest.closeClient(client1);
        this.validateMatchingCqs(server2, numCQs, this.cqDUnitTest.cqs[0], 1 * (clients.length - 1));
        this.cqDUnitTest.closeClient(client2);
        this.cqDUnitTest.closeServer(server2);
    }

    public void perf_testPerformanceForMatchingCQs() throws Exception {
        int j;
        int i;
        Host host = Host.getHost(0);
        VM server1 = host.getVM(0);
        VM server2 = host.getVM(1);
        VM client1 = host.getVM(2);
        VM client2 = host.getVM(3);
        this.cqDUnitTest.createServer(server1);
        this.cqDUnitTest.createServer(server2);
        int port1 = server1.invokeInt(CqQueryDUnitTest.class, "getCacheServerPort");
        int port2 = server2.invokeInt(CqQueryDUnitTest.class, "getCacheServerPort");
        String host0 = CqPerfDUnitTest.getServerHostName(server1.getHost());
        this.cqDUnitTest.createClient(client1, new int[]{port1}, host0, "-1");
        this.cqDUnitTest.createClient(client2, new int[]{port2}, host0, "-1");
        boolean uniqueQueries = false;
        String[] matchingCqs = this.generateCqQueries(uniqueQueries);
        for (i = 0; i < matchingCqs.length; ++i) {
            this.cqDUnitTest.createCQ(client1, "testPerformanceForMatchingCQs_" + i, matchingCqs[i]);
            this.cqDUnitTest.executeCQ(client1, "testPerformanceForMatchingCQs_" + i, false, null);
        }
        uniqueQueries = true;
        matchingCqs = this.generateCqQueries(uniqueQueries);
        for (i = 0; i < matchingCqs.length; ++i) {
            this.cqDUnitTest.createCQ(client2, "testPerformanceForMatchingCQs_" + i, matchingCqs[i]);
            this.cqDUnitTest.executeCQ(client2, "testPerformanceForMatchingCQs_" + i, false, null);
        }
        CqPerfDUnitTest.pause(1000);
        int size = 1000;
        this.cqDUnitTest.createValues(server1, this.cqDUnitTest.regions[0], size);
        this.cqDUnitTest.createValues(server2, this.cqDUnitTest.regions[1], size);
        for (j = 0; j < 5; ++j) {
            this.cqDUnitTest.createValues(server1, this.cqDUnitTest.regions[0], size - 1);
            this.cqDUnitTest.createValues(server2, this.cqDUnitTest.regions[1], size - 1);
        }
        for (j = 0; j < 4; ++j) {
            this.cqDUnitTest.createValues(server2, this.cqDUnitTest.regions[0], size - 1);
            this.cqDUnitTest.createValues(server1, this.cqDUnitTest.regions[1], size - 1);
        }
        this.cqDUnitTest.createValues(server2, this.cqDUnitTest.regions[0], size);
        this.cqDUnitTest.createValues(server1, this.cqDUnitTest.regions[1], size);
        for (int k = 1; k <= size; ++k) {
            this.cqDUnitTest.waitForUpdated(client1, "testPerformanceForMatchingCQs_0", "key-" + k);
        }
        CqPerfDUnitTest.pause(1000);
        this.printCqQueryExecutionTime(server1);
        this.printCqQueryExecutionTime(server2);
        this.cqDUnitTest.closeClient(client1);
        this.cqDUnitTest.closeClient(client2);
        this.cqDUnitTest.closeServer(server2);
        this.cqDUnitTest.closeServer(server1);
    }

    public void validateMatchingCqs(VM server, final int mapSize, final String query, final int numCqSize) {
        server.invoke(new CacheSerializableRunnable("validateMatchingCqs"){

            @Override
            public void run2() throws CacheException {
                CqService cqService = null;
                try {
                    cqService = ((DefaultQueryService)CqPerfDUnitTest.this.getCache().getQueryService()).getCqService();
                }
                catch (Exception ex) {
                    DistributedTestCase.getLogWriter().info("Failed to get the internal CqService.", (Throwable)ex);
                    DistributedTestCase.fail("Failed to get the internal CqService.", ex);
                }
                HashMap matchedCqMap = cqService.getMatchingCqMap();
                TestCase.assertEquals((String)"The number of matched cq is not as expected.", (int)mapSize, (int)matchedCqMap.size());
                if (query != null) {
                    if (!matchedCqMap.containsKey(query)) {
                        TestCase.fail((String)("Query not found in the matched cq map. Query:" + query));
                    }
                    ArrayList cqs = (ArrayList)matchedCqMap.get(query);
                    TestCase.assertEquals((String)"Number of matched cqs are not equal to the expected matched cqs", (int)numCqSize, (int)cqs.size());
                }
            }
        });
    }

    public void printCqQueryExecutionTime(VM server) {
        server.invoke(new CacheSerializableRunnable("printCqQueryExecutionTime"){

            @Override
            public void run2() throws CacheException {
                CqService cqService = null;
                try {
                    cqService = ((DefaultQueryService)CqPerfDUnitTest.this.getCache().getQueryService()).getCqService();
                }
                catch (Exception ex) {
                    DistributedTestCase.getLogWriter().info("Failed to get the internal CqService.", (Throwable)ex);
                    DistributedTestCase.fail("Failed to get the internal CqService.", ex);
                }
                long timeTaken = cqService.getCqServiceVsdStats().getCqQueryExecutionTime();
                DistributedTestCase.getLogWriter().info("Total Time taken to Execute CQ Query :" + timeTaken);
            }
        });
    }

    public String[] generateCqQueries(boolean uniqueQueries) {
        ArrayList<String> initQueries = new ArrayList<String>();
        String[] names = new String[]{"aaa", "bbb", "ccc", "ddd"};
        int nameIndex = 0;
        for (int i = 0; i < 3; ++i) {
            for (int cnt = 0; cnt < 5; ++cnt) {
                String query = this.cqDUnitTest.cqs[i];
                if (cnt > 0) {
                    nameIndex = cnt % names.length;
                    query = query + " or p.names[" + nameIndex + "] = '" + names[nameIndex] + cnt + "'";
                }
                initQueries.add(query);
            }
        }
        int numMatchedQueries = 10;
        ArrayList<String> cqQueries = new ArrayList<String>();
        for (String query : initQueries) {
            for (int cnt = 0; cnt < numMatchedQueries; ++cnt) {
                if (uniqueQueries) {
                    query = query + " ";
                }
                cqQueries.add(query);
            }
        }
        String[] queries = new String[cqQueries.size()];
        cqQueries.toArray(queries);
        return queries;
    }
}

