/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.query.cq.dunit;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.EvictionAction;
import com.gemstone.gemfire.cache.EvictionAttributes;
import com.gemstone.gemfire.cache.MirrorType;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.client.internal.ConnectionImpl;
import com.gemstone.gemfire.cache.query.CqAttributes;
import com.gemstone.gemfire.cache.query.CqAttributesFactory;
import com.gemstone.gemfire.cache.query.CqAttributesMutator;
import com.gemstone.gemfire.cache.query.CqClosedException;
import com.gemstone.gemfire.cache.query.CqExistsException;
import com.gemstone.gemfire.cache.query.CqListener;
import com.gemstone.gemfire.cache.query.CqQuery;
import com.gemstone.gemfire.cache.query.CqResults;
import com.gemstone.gemfire.cache.query.Query;
import com.gemstone.gemfire.cache.query.QueryService;
import com.gemstone.gemfire.cache.query.RegionNotFoundException;
import com.gemstone.gemfire.cache.query.cq.dunit.CqQueryTestListener;
import com.gemstone.gemfire.cache.query.data.Portfolio;
import com.gemstone.gemfire.cache.query.internal.CqStateImpl;
import com.gemstone.gemfire.cache.query.internal.DefaultQueryService;
import com.gemstone.gemfire.cache.util.BridgeServer;
import com.gemstone.gemfire.cache30.BridgeTestCase;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.cache30.CertifiableTestCacheListener;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.AvailablePortHelper;
import com.gemstone.gemfire.internal.cache.DistributedRegion;
import com.gemstone.gemfire.internal.cache.DistributedTombstoneOperation;
import com.gemstone.gemfire.internal.cache.EventID;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.RMIException;
import dunit.SerializableRunnable;
import dunit.VM;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Set;
import junit.framework.TestCase;

public class CqQueryDUnitTest
extends CacheTestCase {
    private static int bridgeServerPort;
    protected static int port;
    protected static int port2;
    public static int noTest;
    public final String[] regions = new String[]{"regionA", "regionB"};
    private static final int CREATE = 0;
    private static final int UPDATE = 1;
    private static final int DESTROY = 2;
    private static final int INVALIDATE = 3;
    private static final int CLOSE = 4;
    private static final int REGION_CLEAR = 5;
    private static final int REGION_INVALIDATE = 6;
    public static final String KEY = "key-";
    private static final String WAIT_PROPERTY = "CqQueryTest.maxWaitTime";
    private static final int WAIT_DEFAULT = 20000;
    public static final long MAX_TIME;
    public final String[] cqs = new String[]{"SELECT ALL * FROM /root/" + this.regions[0] + " p where p.ID > 0", "SELECT ALL * FROM /root/" + this.regions[0] + " p where p.ID = 2 and p.status='active'", "SELECT ALL * FROM /root/" + this.regions[1] + " p where p.ID < 5 and p.status='active'", "SELECT * FROM /root/" + this.regions[0] + " ;", "SELECT ALL * FROM /root/" + this.regions[0], "import com.gemstone.gemfire.cache.\"query\".data.Portfolio; SELECT ALL * FROM /root/" + this.regions[0] + " TYPE Portfolio", "import com.gemstone.gemfire.cache.\"query\".data.Portfolio; SELECT ALL * FROM /root/" + this.regions[0] + " p TYPE Portfolio", "SELECT ALL * FROM /root/" + this.regions[1] + " p where p.ID < 5 and p.status='active';", "SELECT ALL * FROM /root/" + this.regions[0] + "  ;", "SELECT ALL * FROM /root/" + this.regions[0] + " p where p.description = NULL", "SELECT ALL * FROM /root/" + this.regions[0] + " p where p.ID > 0 and p.status='active'", "SELECT ALL * FROM /root/" + this.regions[0] + " p where p.ID > 0", "SELECT ALL * FROM /root/" + this.regions[1] + " p where p.ID > 0"};
    private String[] invalidCQs = new String[]{"SELECT ALL * FROM /root/invalidRegion p where p.ID > 0"};
    private String[] shortTypeCQs = new String[]{"SELECT ALL * FROM /root/" + this.regions[0] + " p where p.shortID IN SET(1,2,3,4,5)"};

    public CqQueryDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.getSystem();
        CqQueryDUnitTest.invokeInEveryVM(new SerializableRunnable("getSystem"){

            @Override
            public void run() {
                CqQueryDUnitTest.this.getSystem();
            }
        });
    }

    static int getCacheServerPort() {
        return bridgeServerPort;
    }

    public void createServer(VM server) {
        this.createServer(server, 0);
    }

    public void createServer(VM server, int p) {
        this.createServer(server, p, false);
    }

    public void createServer(VM server, int thePort, boolean eviction) {
        MirrorType mirrorType = MirrorType.KEYS_VALUES;
        this.createServer(server, thePort, eviction, mirrorType);
    }

    public void createServer(VM server, final int thePort, final boolean eviction, final MirrorType mirrorType) {
        CacheSerializableRunnable createServer = new CacheSerializableRunnable("Create Cache Server"){

            @Override
            public void run2() throws CacheException {
                DistributedTestCase.getLogWriter().info("### Create Cache Server. ###");
                AttributesFactory factory = new AttributesFactory();
                factory.setScope(Scope.DISTRIBUTED_ACK);
                factory.setMirrorType(mirrorType);
                if (eviction) {
                    EvictionAttributes evictAttrs = EvictionAttributes.createLRUEntryAttributes((int)100000, (EvictionAction)EvictionAction.OVERFLOW_TO_DISK);
                    factory.setEvictionAttributes(evictAttrs);
                }
                for (int i = 0; i < CqQueryDUnitTest.this.regions.length; ++i) {
                    CqQueryDUnitTest.this.createRegion(CqQueryDUnitTest.this.regions[i], factory.createRegionAttributes());
                }
                DistributedTestCase.pause(2000);
                try {
                    CqQueryDUnitTest.this.startBridgeServer(thePort, true);
                }
                catch (Exception ex) {
                    DistributedTestCase.fail("While starting CacheServer", ex);
                }
                DistributedTestCase.pause(2000);
            }
        };
        server.invoke(createServer);
    }

    public void closeServer(VM server) {
        server.invoke(new SerializableRunnable("Close CacheServer"){

            @Override
            public void run() {
                DistributedTestCase.getLogWriter().info("### Close CacheServer. ###");
                CqQueryDUnitTest.this.stopBridgeServer(CqQueryDUnitTest.this.getCache());
            }
        });
        CqQueryDUnitTest.pause(2000);
    }

    public void crashServer(VM server) {
        server.invoke(new SerializableRunnable("Crash CacheServer"){

            @Override
            public void run() {
                ConnectionImpl.setTEST_DURABLE_CLIENT_CRASH((boolean)true);
                DistributedTestCase.getLogWriter().info("### Crashing CacheServer. ###");
                CqQueryDUnitTest.this.stopBridgeServer(CqQueryDUnitTest.this.getCache());
            }
        });
        CqQueryDUnitTest.pause(2000);
    }

    public void closeCrashServer(VM server) {
        server.invoke(new SerializableRunnable("Close CacheServer"){

            @Override
            public void run() {
                ConnectionImpl.setTEST_DURABLE_CLIENT_CRASH((boolean)false);
                DistributedTestCase.getLogWriter().info("### Crashing CacheServer. ###");
                CqQueryDUnitTest.this.stopBridgeServer(CqQueryDUnitTest.this.getCache());
            }
        });
        CqQueryDUnitTest.pause(2000);
    }

    public void createClient(VM client, int serverPort, String serverHost) {
        int[] serverPorts = new int[]{serverPort};
        this.createClient(client, serverPorts, serverHost, null);
    }

    public void createClient(VM client, final int[] serverPorts, final String serverHost, final String redundancyLevel) {
        CacheSerializableRunnable createQService = new CacheSerializableRunnable("Create Client"){

            @Override
            public void run2() throws CacheException {
                DistributedTestCase.getLogWriter().info("### Create Client. ###");
                try {
                    CqQueryDUnitTest.this.getCache().getQueryService();
                }
                catch (Exception cqe) {
                    cqe.printStackTrace();
                    TestCase.fail((String)"Failed to getCQService.");
                }
                AttributesFactory regionFactory = new AttributesFactory();
                regionFactory.setScope(Scope.LOCAL);
                if (redundancyLevel != null) {
                    BridgeTestCase.configureConnectionPool(regionFactory, serverHost, serverPorts, true, Integer.parseInt(redundancyLevel), -1, null);
                } else {
                    BridgeTestCase.configureConnectionPool(regionFactory, serverHost, serverPorts, true, -1, -1, null);
                }
                for (int i = 0; i < CqQueryDUnitTest.this.regions.length; ++i) {
                    CqQueryDUnitTest.this.createRegion(CqQueryDUnitTest.this.regions[i], regionFactory.createRegionAttributes());
                    DistributedTestCase.getLogWriter().info("### Successfully Created Region on Client :" + CqQueryDUnitTest.this.regions[i]);
                }
            }
        };
        client.invoke(createQService);
    }

    public void createClientWith2Pools(VM client, final int[] serverPorts1, final int[] serverPorts2, final String serverHost, final String redundancyLevel) {
        CacheSerializableRunnable createQService = new CacheSerializableRunnable("Create Client"){

            @Override
            public void run2() throws CacheException {
                DistributedTestCase.getLogWriter().info("### Create Client. ###");
                try {
                    CqQueryDUnitTest.this.getCache().getQueryService();
                }
                catch (Exception cqe) {
                    cqe.printStackTrace();
                    TestCase.fail((String)"Failed to getCQService.");
                }
                AttributesFactory regionFactory0 = new AttributesFactory();
                AttributesFactory regionFactory1 = new AttributesFactory();
                regionFactory0.setScope(Scope.LOCAL);
                regionFactory1.setScope(Scope.LOCAL);
                if (redundancyLevel != null) {
                    BridgeTestCase.configureConnectionPoolWithName(regionFactory0, serverHost, serverPorts1, true, Integer.parseInt(redundancyLevel), -1, null, "testPoolA");
                    BridgeTestCase.configureConnectionPoolWithName(regionFactory1, serverHost, serverPorts2, true, Integer.parseInt(redundancyLevel), -1, null, "testPoolB");
                } else {
                    BridgeTestCase.configureConnectionPoolWithName(regionFactory0, serverHost, serverPorts1, true, -1, -1, null, "testPoolA");
                    BridgeTestCase.configureConnectionPoolWithName(regionFactory1, serverHost, serverPorts2, true, -1, -1, null, "testPoolB");
                }
                CqQueryDUnitTest.this.createRegion(CqQueryDUnitTest.this.regions[0], regionFactory0.createRegionAttributes());
                CqQueryDUnitTest.this.createRegion(CqQueryDUnitTest.this.regions[1], regionFactory1.createRegionAttributes());
                DistributedTestCase.getLogWriter().info("### Successfully Created Region on Client :" + CqQueryDUnitTest.this.regions[0]);
                DistributedTestCase.getLogWriter().info("### Successfully Created Region on Client :" + CqQueryDUnitTest.this.regions[1]);
            }
        };
        client.invoke(createQService);
    }

    public void closeClient(VM client) {
        CacheSerializableRunnable closeCQService = new CacheSerializableRunnable("Close Client"){

            @Override
            public void run2() throws CacheException {
                DistributedTestCase.getLogWriter().info("### Close Client. ###");
                try {
                    ((DefaultQueryService)CqQueryDUnitTest.this.getCache().getQueryService()).closeCqService();
                }
                catch (Exception ex) {
                    DistributedTestCase.getLogWriter().info("### Failed to get CqService during ClientClose() ###");
                }
            }
        };
        client.invoke(closeCQService);
        CqQueryDUnitTest.pause(2000);
    }

    public void createValues(VM vm, final String regionName, final int size) {
        vm.invoke(new CacheSerializableRunnable("Create values"){

            @Override
            public void run2() throws CacheException {
                Region region1 = CqQueryDUnitTest.this.getRootRegion().getSubregion(regionName);
                for (int i = 1; i <= size; ++i) {
                    region1.put((Object)(CqQueryDUnitTest.KEY + i), (Object)new Portfolio(i));
                }
                DistributedTestCase.getLogWriter().info("### Number of Entries in Region :" + region1.keys().size());
            }
        });
    }

    public void createValuesWithTime(VM vm, final String regionName, final int size) {
        vm.invoke(new CacheSerializableRunnable("Create values"){

            @Override
            public void run2() throws CacheException {
                Region region1 = CqQueryDUnitTest.this.getRootRegion().getSubregion(regionName);
                for (int i = 1; i <= size; ++i) {
                    Portfolio portfolio = new Portfolio(i);
                    portfolio.createTime = System.currentTimeMillis();
                    region1.put((Object)(CqQueryDUnitTest.KEY + i), (Object)portfolio);
                }
                DistributedTestCase.getLogWriter().info("### Number of Entries in Region :" + region1.keys().size());
            }
        });
    }

    public void createValuesWithShort(VM vm, final String regionName, final int size) {
        vm.invoke(new CacheSerializableRunnable("Create values"){

            @Override
            public void run2() throws CacheException {
                Region region1 = CqQueryDUnitTest.this.getRootRegion().getSubregion(regionName);
                for (int i = 1; i <= size; ++i) {
                    Portfolio portfolio = new Portfolio(i);
                    portfolio.shortID = new Short("" + i);
                    region1.put((Object)(CqQueryDUnitTest.KEY + i), (Object)portfolio);
                }
                DistributedTestCase.getLogWriter().info("### Number of Entries in Region :" + region1.keys().size());
            }
        });
    }

    public void createValuesAsPrimitives(VM vm, final String regionName, final int size) {
        vm.invoke(new CacheSerializableRunnable("Create values"){

            @Override
            public void run2() throws CacheException {
                Region region1 = CqQueryDUnitTest.this.getRootRegion().getSubregion(regionName);
                block7: for (int i = 1; i <= size; ++i) {
                    switch (i % 5) {
                        case 0: {
                            region1.put((Object)("key" + i), (Object)"seeded");
                            continue block7;
                        }
                        case 1: {
                            region1.put((Object)("key" + i), (Object)"seeding");
                            continue block7;
                        }
                        case 2: {
                            region1.put((Object)("key" + i), (Object)new Double(i));
                            continue block7;
                        }
                        case 3: {
                            region1.put((Object)("key" + i), (Object)i);
                            continue block7;
                        }
                        case 4: {
                            region1.put((Object)("key" + i), (Object)new Portfolio(i));
                            continue block7;
                        }
                        default: {
                            region1.put((Object)("key" + i), (Object)i);
                        }
                    }
                }
                DistributedTestCase.getLogWriter().info("### Number of Entries in Region :" + region1.keys().size());
            }
        });
    }

    public void updateValuesAsPrimitives(VM vm, final String regionName, final int size) {
        vm.invoke(new CacheSerializableRunnable("Create values"){

            @Override
            public void run2() throws CacheException {
                Region region1 = CqQueryDUnitTest.this.getRootRegion().getSubregion(regionName);
                block7: for (int i = 1; i <= size; ++i) {
                    switch (i % 5) {
                        case 0: {
                            region1.put((Object)("key" + i), (Object)"seeding");
                            continue block7;
                        }
                        case 1: {
                            region1.put((Object)("key" + i), (Object)"seeded");
                            continue block7;
                        }
                        case 2: {
                            region1.put((Object)("key" + i), (Object)i);
                            continue block7;
                        }
                        case 3: {
                            region1.put((Object)("key" + i), (Object)new Portfolio(i));
                            continue block7;
                        }
                        case 4: {
                            region1.put((Object)("key" + i), (Object)new Double(i));
                            continue block7;
                        }
                        default: {
                            region1.put((Object)("key" + i), (Object)i);
                        }
                    }
                }
                DistributedTestCase.getLogWriter().info("### Number of Entries in Region :" + region1.keys().size());
            }
        });
    }

    public void createValuesAsPortfolios(VM vm, final String regionName, final int size) {
        vm.invoke(new CacheSerializableRunnable("Create values"){

            @Override
            public void run2() throws CacheException {
                Region region1 = CqQueryDUnitTest.this.getRootRegion().getSubregion(regionName);
                for (int i = 1; i <= size; ++i) {
                    region1.put((Object)("key" + i), (Object)new Portfolio(i));
                }
                DistributedTestCase.getLogWriter().info("### Number of Entries in Region :" + region1.keys().size());
            }
        });
    }

    public void createIndex(VM vm, final String indexName, final String indexedExpression, final String regionPath) {
        vm.invoke(new CacheSerializableRunnable("Create values"){

            @Override
            public void run2() throws CacheException {
                try {
                    QueryService qs = CqQueryDUnitTest.this.getCache().getQueryService();
                    qs.createIndex(indexName, indexedExpression, regionPath);
                }
                catch (Exception e) {
                    throw new CacheException(e){};
                }
            }
        });
    }

    public void deleteValues(VM vm, final String regionName, final int size) {
        vm.invoke(new CacheSerializableRunnable("Delete values"){

            @Override
            public void run2() throws CacheException {
                Region region1 = CqQueryDUnitTest.this.getRootRegion().getSubregion(regionName);
                for (int i = 1; i <= size; ++i) {
                    region1.destroy((Object)(CqQueryDUnitTest.KEY + i));
                }
                DistributedTestCase.getLogWriter().info("### Number of Entries In Region after Delete :" + region1.keys().size());
            }
        });
    }

    public void invalidateValues(VM vm, final String regionName, final int size) {
        vm.invoke(new CacheSerializableRunnable("Create values"){

            @Override
            public void run2() throws CacheException {
                Region region1 = CqQueryDUnitTest.this.getRootRegion().getSubregion(regionName);
                for (int i = 1; i <= size; ++i) {
                    region1.invalidate((Object)(CqQueryDUnitTest.KEY + i));
                }
                DistributedTestCase.getLogWriter().info("### Number of Entries In Region after Delete :" + region1.keys().size());
            }
        });
    }

    public void createCQ(VM vm, String cqName, String queryStr) {
        this.createCQ(vm, cqName, queryStr, false);
    }

    public void createCQ(VM vm, final String cqName, final String queryStr, boolean isBridgeMemberTest) {
        vm.invoke(new CacheSerializableRunnable("Create CQ :" + cqName){

            @Override
            public void run2() throws CacheException {
                DistributedTestCase.getLogWriter().info("### Create CQ. ###" + cqName);
                QueryService cqService = null;
                try {
                    cqService = CqQueryDUnitTest.this.getCache().getQueryService();
                }
                catch (Exception cqe) {
                    cqe.printStackTrace();
                    TestCase.fail((String)"Failed to getCQService.");
                }
                CqAttributesFactory cqf = new CqAttributesFactory();
                CqListener[] cqListeners = new CqListener[]{new CqQueryTestListener(DistributedTestCase.getLogWriter())};
                cqf.initCqListeners(cqListeners);
                CqAttributes cqa = cqf.create();
                try {
                    CqQuery cq1 = cqService.newCq(cqName, queryStr, cqa);
                    TestCase.assertTrue((String)"newCq() state mismatch", (boolean)cq1.getState().isStopped());
                }
                catch (Exception ex) {
                    AssertionError err = new AssertionError((Object)("Failed to create CQ " + cqName + " . "));
                    ((Throwable)((Object)err)).initCause(ex);
                    DistributedTestCase.getLogWriter().info("CqService is :" + cqService, (Throwable)((Object)err));
                    throw err;
                }
            }
        });
    }

    public void createAndExecCQNoName(VM vm, final String queryStr) {
        vm.invoke(new CacheSerializableRunnable("Create CQ with no name:"){

            @Override
            public void run2() throws CacheException {
                DistributedTestCase.getLogWriter().info("### DEBUG CREATE CQ START ####");
                DistributedTestCase.getLogWriter().info("### Create CQ with no name. ###");
                QueryService cqService = null;
                CqQuery cq1 = null;
                String cqName = null;
                try {
                    cqService = CqQueryDUnitTest.this.getCache().getQueryService();
                }
                catch (Exception cqe) {
                    cqe.printStackTrace();
                    TestCase.fail((String)"Failed to getCQService.");
                }
                CqResults cqResults = null;
                for (int i = 0; i < 20; ++i) {
                    CqAttributesFactory cqf = new CqAttributesFactory();
                    CqListener[] cqListeners = new CqListener[]{new CqQueryTestListener(DistributedTestCase.getLogWriter())};
                    cqf.initCqListeners(cqListeners);
                    CqAttributes cqa = cqf.create();
                    try {
                        cq1 = cqService.newCq(queryStr, cqa);
                        ((CqQueryTestListener)cqListeners[0]).cqName = cq1.getName();
                    }
                    catch (Exception ex) {
                        DistributedTestCase.getLogWriter().info("CQService is :" + cqService);
                        ex.printStackTrace();
                        TestCase.fail((String)("Failed to create CQ with no name . " + ex.getMessage()));
                    }
                    if (cq1 == null) {
                        DistributedTestCase.getLogWriter().info("Failed to get CqQuery object for CQ with no name.");
                    } else {
                        cqName = cq1.getName();
                        DistributedTestCase.getLogWriter().info("Created CQ with no name, generated CQ name: " + cqName + " CQ state:" + cq1.getState());
                        TestCase.assertTrue((String)"Create CQ with no name illegal state", (boolean)cq1.getState().isStopped());
                    }
                    if (i % 2 == 0) {
                        try {
                            cqResults = cq1.executeWithInitialResults();
                        }
                        catch (Exception ex) {
                            DistributedTestCase.getLogWriter().info("CqService is :" + cqService);
                            ex.printStackTrace();
                            TestCase.fail((String)("Failed to execute CQ with initial results, cq name: " + cqName + " . " + ex.getMessage()));
                        }
                        DistributedTestCase.getLogWriter().info("initial result size = " + cqResults.size());
                        DistributedTestCase.getLogWriter().info("CQ state after execute with initial results = " + cq1.getState());
                        TestCase.assertTrue((String)"executeWithInitialResults() state mismatch", (boolean)cq1.getState().isRunning());
                    } else {
                        try {
                            cq1.execute();
                        }
                        catch (Exception ex) {
                            DistributedTestCase.getLogWriter().info("CQService is :" + cqService);
                            ex.printStackTrace();
                            TestCase.fail((String)("Failed to execute CQ " + cqName + " . " + ex.getMessage()));
                        }
                        DistributedTestCase.getLogWriter().info("CQ state after execute = " + cq1.getState());
                        TestCase.assertTrue((String)"execute() state mismatch", (boolean)cq1.getState().isRunning());
                    }
                    try {
                        cq1.close();
                    }
                    catch (Exception ex) {
                        DistributedTestCase.getLogWriter().info("CqService is :" + cqService, (Throwable)ex);
                        TestCase.fail((String)("Failed to close CQ " + cqName + " . " + ex.getMessage()));
                    }
                    TestCase.assertTrue((String)"closeCq() state mismatch", (boolean)cq1.getState().isClosed());
                }
            }
        });
    }

    public void executeCQ(VM vm, String cqName, boolean initialResults, String expectedErr) {
        this.executeCQ(vm, cqName, initialResults, noTest, expectedErr);
    }

    private void executeCQ(VM vm, final String cqName, final boolean initialResults, final int expectedResultsSize, final String expectedErr) {
        vm.invoke(new CacheSerializableRunnable("Execute CQ :" + cqName){

            private void work() throws CacheException {
                DistributedTestCase.getLogWriter().info("### DEBUG EXECUTE CQ START ####");
                QueryService cqService = null;
                CqQuery cq1 = null;
                cqService = CqQueryDUnitTest.this.getCache().getQueryService();
                try {
                    cq1 = cqService.getCq(cqName);
                    if (cq1 == null) {
                        DistributedTestCase.getLogWriter().info("Failed to get CqQuery object for CQ name: " + cqName);
                        TestCase.fail((String)("Failed to get CQ " + cqName));
                    } else {
                        DistributedTestCase.getLogWriter().info("Obtained CQ, CQ name: " + cq1.getName());
                        TestCase.assertTrue((String)"newCq() state mismatch", (boolean)cq1.getState().isStopped());
                    }
                }
                catch (Exception ex) {
                    DistributedTestCase.getLogWriter().info("CqService is :" + cqService);
                    DistributedTestCase.getLogWriter().error((Throwable)ex);
                    AssertionError err = new AssertionError((Object)("Failed to execute  CQ " + cqName));
                    ((Throwable)((Object)err)).initCause(ex);
                    throw err;
                }
                if (initialResults) {
                    CqResults cqResults = null;
                    try {
                        cqResults = cq1.executeWithInitialResults();
                    }
                    catch (Exception ex) {
                        DistributedTestCase.getLogWriter().info("CqService is :" + cqService);
                        ex.printStackTrace();
                        AssertionError err = new AssertionError((Object)("Failed to execute  CQ " + cqName));
                        ((Throwable)((Object)err)).initCause(ex);
                        throw err;
                    }
                    DistributedTestCase.getLogWriter().info("initial result size = " + cqResults.size());
                    TestCase.assertTrue((String)"executeWithInitialResults() state mismatch", (boolean)cq1.getState().isRunning());
                    if (expectedResultsSize >= 0) {
                        TestCase.assertEquals((String)"unexpected results size", (int)expectedResultsSize, (int)cqResults.size());
                    }
                } else {
                    try {
                        cq1.execute();
                    }
                    catch (Exception ex) {
                        AssertionError err = new AssertionError((Object)("Failed to execute  CQ " + cqName));
                        ((Throwable)((Object)err)).initCause(ex);
                        if (expectedErr == null) {
                            DistributedTestCase.getLogWriter().info("CqService is :" + cqService, (Throwable)((Object)err));
                        }
                        throw err;
                    }
                    TestCase.assertTrue((String)"execute() state mismatch", (boolean)cq1.getState().isRunning());
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run2() throws CacheException {
                if (expectedErr != null) {
                    CqQueryDUnitTest.this.getCache().getLogger().info("<ExpectedException action=add>" + expectedErr + "</ExpectedException>");
                }
                try {
                    this.work();
                }
                finally {
                    if (expectedErr != null) {
                        CqQueryDUnitTest.this.getCache().getLogger().info("<ExpectedException action=remove>" + expectedErr + "</ExpectedException>");
                    }
                }
            }
        });
    }

    public void stopCQ(VM vm, final String cqName) throws Exception {
        vm.invoke(new CacheSerializableRunnable("Stop CQ :" + cqName){

            @Override
            public void run2() throws CacheException {
                DistributedTestCase.getLogWriter().info("### Stop CQ. ###" + cqName);
                QueryService cqService = null;
                try {
                    cqService = CqQueryDUnitTest.this.getCache().getQueryService();
                }
                catch (Exception cqe) {
                    cqe.printStackTrace();
                    TestCase.fail((String)"Failed to getCQService.");
                }
                CqQuery cq1 = null;
                try {
                    cq1 = cqService.getCq(cqName);
                    cq1.stop();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    TestCase.fail((String)("Failed to stop CQ " + cqName + " . " + ex.getMessage()));
                }
                TestCase.assertTrue((String)"Stop CQ state mismatch", (boolean)cq1.getState().isStopped());
            }
        });
    }

    private void stopExecCQ(VM vm, final String cqName, final int count) throws Exception {
        vm.invoke(new CacheSerializableRunnable("Stop CQ :" + cqName){

            @Override
            public void run2() throws CacheException {
                CqQuery cq1 = null;
                DistributedTestCase.getLogWriter().info("### Stop and Exec CQ. ###" + cqName);
                QueryService cqService = null;
                try {
                    cqService = CqQueryDUnitTest.this.getCache().getQueryService();
                }
                catch (Exception cqe) {
                    cqe.printStackTrace();
                    TestCase.fail((String)"Failed to getCqService.");
                }
                try {
                    cq1 = cqService.getCq(cqName);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    TestCase.fail((String)("Failed to get CQ " + cqName + " . " + ex.getMessage()));
                }
                for (int i = 0; i < count; ++i) {
                    try {
                        cq1.stop();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        TestCase.fail((String)("Count = " + i + "Failed to stop CQ " + cqName + " . " + ex.getMessage()));
                    }
                    TestCase.assertTrue((String)("Stop CQ state mismatch, count = " + i), (boolean)cq1.getState().isStopped());
                    DistributedTestCase.getLogWriter().info("After stop in Stop and Execute loop, ran successfully, loop count: " + i);
                    DistributedTestCase.getLogWriter().info("CQ state: " + cq1.getState());
                    try {
                        cq1.execute();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        TestCase.fail((String)("Count = " + i + "Failed to execute CQ " + cqName + " . " + ex.getMessage()));
                    }
                    TestCase.assertTrue((String)("Execute CQ state mismatch, count = " + i), (boolean)cq1.getState().isRunning());
                    DistributedTestCase.getLogWriter().info("After execute in Stop and Execute loop, ran successfully, loop count: " + i);
                    DistributedTestCase.getLogWriter().info("CQ state: " + cq1.getState());
                }
            }
        });
    }

    public void closeCQ(VM vm, final String cqName) throws Exception {
        vm.invoke(new CacheSerializableRunnable("Close CQ :" + cqName){

            @Override
            public void run2() throws CacheException {
                DistributedTestCase.getLogWriter().info("### Close CQ. ###" + cqName);
                QueryService cqService = null;
                try {
                    cqService = CqQueryDUnitTest.this.getCache().getQueryService();
                }
                catch (Exception cqe) {
                    cqe.printStackTrace();
                    TestCase.fail((String)"Failed to getCqService.");
                }
                CqQuery cq1 = null;
                try {
                    cq1 = cqService.getCq(cqName);
                    cq1.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    TestCase.fail((String)("Failed to close CQ " + cqName + " . " + ex.getMessage()));
                }
                TestCase.assertTrue((String)"Close CQ state mismatch", (boolean)cq1.getState().isClosed());
            }
        });
    }

    private void registerInterestListCQ(VM vm, final String regionName, final int keySize) {
        vm.invoke(new CacheSerializableRunnable("Register InterestList and CQ"){

            @Override
            public void run2() throws CacheException {
                Region region = null;
                try {
                    region = CqQueryDUnitTest.this.getRootRegion().getSubregion(regionName);
                    region.getAttributesMutator().setCacheListener((CacheListener)new CertifiableTestCacheListener(DistributedTestCase.getLogWriter()));
                }
                catch (Exception cqe) {
                    AssertionError err = new AssertionError((Object)"Failed to get Region.");
                    ((Throwable)((Object)err)).initCause(cqe);
                    throw err;
                }
                try {
                    ArrayList<String> list = new ArrayList<String>();
                    for (int i = 1; i <= keySize; ++i) {
                        list.add(CqQueryDUnitTest.KEY + i);
                    }
                    region.registerInterest(list);
                }
                catch (Exception ex) {
                    AssertionError err = new AssertionError((Object)"Failed to Register InterestList");
                    ((Throwable)((Object)err)).initCause(ex);
                    throw err;
                }
            }
        });
    }

    public void executeAndCloseAndExecuteIRMultipleTimes(VM vm, final String cqName, final String queryStr) {
        vm.invoke(new CacheSerializableRunnable("Create CQ :" + cqName){

            @Override
            public void run2() throws CacheException {
                CqQuery cq1;
                DistributedTestCase.getLogWriter().info("### Create CQ. ###" + cqName);
                QueryService cqService = null;
                try {
                    cqService = CqQueryDUnitTest.this.getCache().getQueryService();
                }
                catch (Exception cqe) {
                    cqe.printStackTrace();
                    TestCase.fail((String)"Failed to getCQService.");
                }
                CqAttributesFactory cqf = new CqAttributesFactory();
                CqListener[] cqListeners = new CqListener[]{new CqQueryTestListener(DistributedTestCase.getLogWriter())};
                cqf.initCqListeners(cqListeners);
                CqAttributes cqa = cqf.create();
                try {
                    cq1 = cqService.newCq(cqName, queryStr, cqa);
                    TestCase.assertTrue((String)"newCq() state mismatch", (boolean)cq1.getState().isStopped());
                }
                catch (Exception ex) {
                    AssertionError err = new AssertionError((Object)("Failed to create CQ " + cqName + " . "));
                    ((Throwable)((Object)err)).initCause(ex);
                    DistributedTestCase.getLogWriter().info("CqService is :" + cqService, (Throwable)((Object)err));
                    throw err;
                }
                try {
                    cq1.executeWithInitialResults();
                    try {
                        cq1.executeWithInitialResults();
                    }
                    catch (IllegalStateException ex) {
                        // empty catch block
                    }
                    cq1.close();
                    try {
                        cq1.executeWithInitialResults();
                    }
                    catch (CqClosedException e) {
                        return;
                    }
                    TestCase.fail((String)"should have received cqClosedException");
                }
                catch (Exception e) {
                    TestCase.fail((String)("exception not expected here " + e));
                }
            }
        });
    }

    public void validateCQCount(VM vm, final int cqCnt) throws Exception {
        vm.invoke(new CacheSerializableRunnable("validate cq count"){

            @Override
            public void run2() throws CacheException {
                QueryService cqService = null;
                try {
                    cqService = CqQueryDUnitTest.this.getCache().getQueryService();
                }
                catch (Exception cqe) {
                    cqe.printStackTrace();
                    TestCase.fail((String)"Failed to getCQService.");
                }
                int numCqs = 0;
                try {
                    numCqs = cqService.getCqs().length;
                }
                catch (Exception ex) {
                    TestCase.fail((String)"Failed to get the CQ Count.");
                }
                TestCase.assertEquals((String)"Number of cqs mismatch.", (int)cqCnt, (int)numCqs);
            }
        });
    }

    private void failIfCQExists(VM vm, final String cqName) {
        vm.invoke(new CacheSerializableRunnable("Fail if CQ exists"){

            @Override
            public void run2() throws CacheException {
                DistributedTestCase.getLogWriter().info("### Fail if CQ Exists. ### " + cqName);
                QueryService cqService = null;
                try {
                    cqService = CqQueryDUnitTest.this.getCache().getQueryService();
                }
                catch (Exception cqe) {
                    cqe.printStackTrace();
                    TestCase.fail((String)"Failed to getCQService.");
                }
                CqQuery cQuery = cqService.getCq(cqName);
                if (cQuery != null) {
                    TestCase.fail((String)("Unexpectedly found CqQuery for CQ : " + cqName));
                }
            }
        });
    }

    private void validateCQError(VM vm, final String cqName, final int numError) {
        vm.invoke(new CacheSerializableRunnable("Validate CQs"){

            @Override
            public void run2() throws CacheException {
                DistributedTestCase.getLogWriter().info("### Validating CQ. ### " + cqName);
                QueryService cqService = null;
                try {
                    cqService = CqQueryDUnitTest.this.getCache().getQueryService();
                }
                catch (Exception cqe) {
                    cqe.printStackTrace();
                    TestCase.fail((String)"Failed to getCQService.");
                }
                CqQuery cQuery = cqService.getCq(cqName);
                if (cQuery == null) {
                    TestCase.fail((String)("Failed to get CqQuery for CQ : " + cqName));
                }
                CqAttributes cqAttr = cQuery.getCqAttributes();
                CqListener cqListener = cqAttr.getCqListener();
                CqQueryTestListener listener = (CqQueryTestListener)cqListener;
                listener.printInfo(false);
                if (numError != noTest) {
                    listener.printInfo(true);
                    TestCase.assertEquals((String)"Total Event Count mismatch", (int)numError, (int)listener.getErrorEventCount());
                }
            }
        });
    }

    public void validateCQ(VM vm, String cqName, int resultSize, int creates, int updates, int deletes) {
        this.validateCQ(vm, cqName, resultSize, creates, updates, deletes, noTest, noTest, noTest, noTest);
    }

    public void validateCQ(VM vm, final String cqName, final int resultSize, final int creates, final int updates, final int deletes, final int queryInserts, final int queryUpdates, final int queryDeletes, final int totalEvents) {
        vm.invoke(new CacheSerializableRunnable("Validate CQs"){

            @Override
            public void run2() throws CacheException {
                DistributedTestCase.getLogWriter().info("### Validating CQ. ### " + cqName);
                QueryService cqService = null;
                try {
                    cqService = CqQueryDUnitTest.this.getCache().getQueryService();
                }
                catch (Exception cqe) {
                    cqe.printStackTrace();
                    TestCase.fail((String)"Failed to getCQService.");
                }
                CqQuery cQuery = cqService.getCq(cqName);
                if (cQuery == null) {
                    TestCase.fail((String)("Failed to get CqQuery for CQ : " + cqName));
                }
                CqAttributes cqAttr = cQuery.getCqAttributes();
                CqListener[] cqListeners = cqAttr.getCqListeners();
                CqQueryTestListener listener = (CqQueryTestListener)cqListeners[0];
                listener.printInfo(false);
                if (totalEvents != noTest) {
                    listener.printInfo(true);
                    TestCase.assertEquals((String)"Total Event Count mismatch", (int)totalEvents, (int)listener.getTotalEventCount());
                }
                if (resultSize != noTest) {
                    TestCase.fail((String)"test for event counts instead of results size");
                }
                if (creates != noTest) {
                    listener.printInfo(true);
                    TestCase.assertEquals((String)"Create Event mismatch", (int)creates, (int)listener.getCreateEventCount());
                }
                if (updates != noTest) {
                    listener.printInfo(true);
                    TestCase.assertEquals((String)"Update Event mismatch", (int)updates, (int)listener.getUpdateEventCount());
                }
                if (deletes != noTest) {
                    listener.printInfo(true);
                    TestCase.assertEquals((String)"Delete Event mismatch", (int)deletes, (int)listener.getDeleteEventCount());
                }
                if (queryInserts != noTest) {
                    listener.printInfo(true);
                    TestCase.assertEquals((String)"Query Insert Event mismatch", (int)queryInserts, (int)listener.getQueryInsertEventCount());
                }
                if (queryUpdates != noTest) {
                    listener.printInfo(true);
                    TestCase.assertEquals((String)"Query Update Event mismatch", (int)queryUpdates, (int)listener.getQueryUpdateEventCount());
                }
                if (queryDeletes != noTest) {
                    listener.printInfo(true);
                    TestCase.assertEquals((String)"Query Delete Event mismatch", (int)queryDeletes, (int)listener.getQueryDeleteEventCount());
                }
            }
        });
    }

    public void waitForCreated(VM vm, String cqName, String key) {
        this.waitForEvent(vm, 0, cqName, key);
    }

    public void waitForUpdated(VM vm, String cqName, String key) {
        this.waitForEvent(vm, 1, cqName, key);
    }

    public void waitForDestroyed(VM vm, String cqName, String key) {
        this.waitForEvent(vm, 2, cqName, key);
    }

    public void waitForInvalidated(VM vm, String cqName, String key) {
        this.waitForEvent(vm, 3, cqName, key);
    }

    public void waitForClose(VM vm, String cqName) {
        this.waitForEvent(vm, 4, cqName, null);
    }

    public void waitForRegionClear(VM vm, String cqName) {
        this.waitForEvent(vm, 5, cqName, null);
    }

    public void waitForRegionInvalidate(VM vm, String cqName) {
        this.waitForEvent(vm, 6, cqName, null);
    }

    private void waitForError(VM vm, final String cqName, final String errorMessage) {
        vm.invoke(new CacheSerializableRunnable("validate cq count"){

            @Override
            public void run2() throws CacheException {
                QueryService cqService = null;
                try {
                    cqService = CqQueryDUnitTest.this.getCache().getQueryService();
                }
                catch (Exception cqe) {
                    cqe.printStackTrace();
                    TestCase.fail((String)"Failed to getCQService.");
                }
                CqQuery cQuery = cqService.getCq(cqName);
                if (cQuery == null) {
                    TestCase.fail((String)("Failed to get CqQuery for CQ : " + cqName));
                }
                CqAttributes cqAttr = cQuery.getCqAttributes();
                CqListener[] cqListener = cqAttr.getCqListeners();
                CqQueryTestListener listener = (CqQueryTestListener)cqListener[0];
                listener.waitForError(errorMessage);
            }
        });
    }

    private void waitForCqsDisconnected(VM vm, final String cqName, final int count) {
        vm.invoke(new CacheSerializableRunnable("validate cq disconnected count"){

            @Override
            public void run2() throws CacheException {
                QueryService cqService = null;
                try {
                    cqService = CqQueryDUnitTest.this.getCache().getQueryService();
                }
                catch (Exception cqe) {
                    cqe.printStackTrace();
                    TestCase.fail((String)"Failed to getCQService.");
                }
                CqQuery cQuery = cqService.getCq(cqName);
                if (cQuery == null) {
                    TestCase.fail((String)("Failed to get CqQuery for CQ : " + cqName));
                }
                CqAttributes cqAttr = cQuery.getCqAttributes();
                CqListener[] cqListener = cqAttr.getCqListeners();
                CqQueryTestListener listener = (CqQueryTestListener)cqListener[0];
                listener.waitForCqsDisconnectedEvents(count);
            }
        });
    }

    private void waitForCqsConnected(VM vm, final String cqName, final int count) {
        vm.invoke(new CacheSerializableRunnable("validate cq connected count"){

            @Override
            public void run2() throws CacheException {
                QueryService cqService = null;
                try {
                    cqService = CqQueryDUnitTest.this.getCache().getQueryService();
                }
                catch (Exception cqe) {
                    cqe.printStackTrace();
                    TestCase.fail((String)"Failed to getCQService.");
                }
                CqQuery cQuery = cqService.getCq(cqName);
                if (cQuery == null) {
                    TestCase.fail((String)("Failed to get CqQuery for CQ : " + cqName));
                }
                CqAttributes cqAttr = cQuery.getCqAttributes();
                CqListener[] cqListener = cqAttr.getCqListeners();
                CqQueryTestListener listener = (CqQueryTestListener)cqListener[0];
                listener.waitForCqsConnectedEvents(count);
            }
        });
    }

    private void waitForEvent(VM vm, final int event, final String cqName, final String key) {
        vm.invoke(new CacheSerializableRunnable("waitForEvent(" + event + ", " + cqName + ", " + key + ")"){

            @Override
            public void run2() throws CacheException {
                QueryService cqService = null;
                try {
                    cqService = CqQueryDUnitTest.this.getCache().getQueryService();
                }
                catch (Exception cqe) {
                    cqe.printStackTrace();
                    TestCase.fail((String)"Failed to getCQService.");
                }
                CqQuery cQuery = cqService.getCq(cqName);
                if (cQuery == null) {
                    TestCase.fail((String)("Failed to get CqQuery for CQ : " + cqName));
                }
                CqAttributes cqAttr = cQuery.getCqAttributes();
                CqListener[] cqListener = cqAttr.getCqListeners();
                CqQueryTestListener listener = (CqQueryTestListener)cqListener[0];
                switch (event) {
                    case 0: {
                        listener.waitForCreated(key);
                        break;
                    }
                    case 1: {
                        listener.waitForUpdated(key);
                        break;
                    }
                    case 2: {
                        listener.waitForDestroyed(key);
                        break;
                    }
                    case 3: {
                        listener.waitForInvalidated(key);
                        break;
                    }
                    case 4: {
                        listener.waitForClose();
                        break;
                    }
                    case 5: {
                        listener.waitForRegionClear();
                        break;
                    }
                    case 6: {
                        listener.waitForRegionInvalidate();
                    }
                }
            }
        });
    }

    public void waitForCqState(VM vm, final String cqName, final int state) {
        vm.invoke(new CacheSerializableRunnable("Wait For cq State"){

            @Override
            public void run2() throws CacheException {
                QueryService cqService = null;
                try {
                    cqService = CqQueryDUnitTest.this.getCache().getQueryService();
                }
                catch (Exception cqe) {
                    cqe.printStackTrace();
                    TestCase.fail((String)"Failed to getCQService.");
                }
                CqQuery cQuery = cqService.getCq(cqName);
                if (cQuery == null) {
                    TestCase.fail((String)("Failed to get CqQuery for CQ : " + cqName));
                }
                final CqStateImpl cqState = (CqStateImpl)cQuery.getState();
                DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

                    @Override
                    public boolean done() {
                        return cqState.getState() == state;
                    }

                    @Override
                    public String description() {
                        return "cqState never became " + state;
                    }
                };
                DistributedTestCase.waitForCriterion(ev, MAX_TIME, 200L, true);
            }
        });
    }

    public void clearCQListenerEvents(VM vm, final String cqName) {
        vm.invoke(new CacheSerializableRunnable("validate cq count"){

            @Override
            public void run2() throws CacheException {
                QueryService cqService = null;
                try {
                    cqService = CqQueryDUnitTest.this.getCache().getQueryService();
                }
                catch (Exception cqe) {
                    cqe.printStackTrace();
                    TestCase.fail((String)"Failed to getCQService.");
                }
                CqQuery cQuery = cqService.getCq(cqName);
                if (cQuery == null) {
                    TestCase.fail((String)("Failed to get CqQuery for CQ : " + cqName));
                }
                CqAttributes cqAttr = cQuery.getCqAttributes();
                CqListener cqListener = cqAttr.getCqListener();
                CqQueryTestListener listener = (CqQueryTestListener)cqListener;
                listener.getEventHistory();
            }
        });
    }

    private void validateQuery(VM vm, final String query, int resultSize) {
        vm.invoke(new CacheSerializableRunnable("Validate Query"){

            @Override
            public void run2() throws CacheException {
                DistributedTestCase.getLogWriter().info("### Validating Query. ###");
                QueryService qs = CqQueryDUnitTest.this.getCache().getQueryService();
                Query q = qs.newQuery(query);
                try {
                    Object r = q.execute();
                    if (r instanceof Collection) {
                        int rSize = ((Collection)r).size();
                        DistributedTestCase.getLogWriter().info("### Result Size is :" + rSize);
                        TestCase.assertEquals((int)rSize, (int)rSize);
                    }
                }
                catch (Exception e) {
                    TestCase.fail((String)("Failed to execute the query " + e.getMessage()));
                }
            }
        });
    }

    private Properties getConnectionProps(String[] hosts, int[] ports, Properties newProps) {
        Properties props = new Properties();
        String endPoints = "";
        String host = hosts[0];
        for (int i = 0; i < ports.length; ++i) {
            if (hosts.length > 1) {
                host = hosts[i];
            }
            endPoints = endPoints + "server" + i + "=" + host + ":" + ports[i];
            if (ports.length <= i + 1) continue;
            endPoints = endPoints + ",";
        }
        props.setProperty("endpoints", endPoints);
        props.setProperty("retryAttempts", "1");
        if (newProps != null) {
            Enumeration<Object> e = newProps.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                props.setProperty(key, newProps.getProperty(key));
            }
        }
        return props;
    }

    private void mutateCQAttributes(VM vm, final String cqName, final int mutator_function) throws Exception {
        vm.invoke(new CacheSerializableRunnable("Stop CQ :" + cqName){

            @Override
            public void run2() throws CacheException {
                CqQuery cq1 = null;
                DistributedTestCase.getLogWriter().info("### CQ attributes mutator for ###" + cqName);
                QueryService cqService = null;
                try {
                    cqService = CqQueryDUnitTest.this.getCache().getQueryService();
                }
                catch (Exception cqe) {
                    cqe.printStackTrace();
                    TestCase.fail((String)"Failed to getCQService.");
                }
                try {
                    cq1 = cqService.getCq(cqName);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    TestCase.fail((String)("Failed to get CQ " + cqName + " . " + ex.getMessage()));
                }
                CqAttributesMutator cqAttrMutator = cq1.getCqAttributesMutator();
                CqAttributes cqAttr = cq1.getCqAttributes();
                switch (mutator_function) {
                    case 0: {
                        CqListener[] cqListenersArray = new CqListener[]{new CqQueryTestListener(CqQueryDUnitTest.this.getCache().getLogger()), new CqQueryTestListener(CqQueryDUnitTest.this.getCache().getLogger())};
                        cqAttrMutator.initCqListeners(cqListenersArray);
                        CqListener[] cqListeners = cqAttr.getCqListeners();
                        TestCase.assertEquals((String)"CqListener count mismatch", (int)cqListeners.length, (int)2);
                        break;
                    }
                    case 1: {
                        CqQueryTestListener newListener1 = new CqQueryTestListener(CqQueryDUnitTest.this.getCache().getLogger());
                        CqQueryTestListener newListener2 = new CqQueryTestListener(CqQueryDUnitTest.this.getCache().getLogger());
                        cqAttrMutator.addCqListener((CqListener)newListener1);
                        cqAttrMutator.addCqListener((CqListener)newListener2);
                        CqListener[] cqListeners = cqAttr.getCqListeners();
                        TestCase.assertEquals((String)"CqListener count mismatch", (int)cqListeners.length, (int)3);
                        break;
                    }
                    case 2: {
                        CqListener[] cqListeners = cqAttr.getCqListeners();
                        cqAttrMutator.removeCqListener(cqListeners[0]);
                        cqListeners = cqAttr.getCqListeners();
                        TestCase.assertEquals((String)"CqListener count mismatch", (int)cqListeners.length, (int)2);
                        cqAttrMutator.removeCqListener(cqListeners[0]);
                        cqListeners = cqAttr.getCqListeners();
                        TestCase.assertEquals((String)"CqListener count mismatch", (int)cqListeners.length, (int)1);
                    }
                }
            }
        });
    }

    private void performGC(VM server, final String regionName) {
        CacheSerializableRunnable task = new CacheSerializableRunnable("perform GC"){

            @Override
            public void run2() throws CacheException {
                Region subregion = CqQueryDUnitTest.this.getCache().getRegion("root/" + regionName);
                DistributedTombstoneOperation gc = DistributedTombstoneOperation.gc((DistributedRegion)((DistributedRegion)subregion), (EventID)new EventID(CqQueryDUnitTest.this.getCache().getDistributedSystem()));
                gc.distribute();
            }
        };
        server.invoke(task);
    }

    private void ensureCQExists(VM server, String regionName, final String cqName) {
        CacheSerializableRunnable task = new CacheSerializableRunnable("check CQs"){

            @Override
            public void run2() throws CacheException {
                CqQuery[] queries = CqQueryDUnitTest.this.getCache().getQueryService().getCqs();
                TestCase.assertTrue((String)"expected to find a CQ but found none", (queries.length > 0 ? 1 : 0) != 0);
                System.out.println("found query " + queries[0]);
                TestCase.assertTrue((String)("Couldn't find query " + cqName), (boolean)queries[0].getName().startsWith(cqName));
                TestCase.assertTrue((String)("expected the CQ to be open: " + queries[0]), (!queries[0].isClosed() ? 1 : 0) != 0);
            }
        };
        server.invoke(task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCQRemainsWhenServerGCs() throws Exception {
        Host host = Host.getHost(0);
        VM server = host.getVM(0);
        VM client = host.getVM(1);
        VM server2 = host.getVM(2);
        this.createServer(server);
        this.createServer(server2);
        int thePort = server.invokeInt(CqQueryDUnitTest.class, "getCacheServerPort");
        String host0 = CqQueryDUnitTest.getServerHostName(server.getHost());
        this.createClient(client, thePort, host0);
        try {
            int size = 5;
            this.createValuesWithShort(server, this.regions[0], size);
            CqQueryDUnitTest.pause(500);
            String cqName = "testCQResultSet_0";
            this.createCQ(client, "testCQResultSet_0", this.shortTypeCQs[0]);
            this.executeCQ(client, "testCQResultSet_0", true, 5, null);
            this.performGC(server, this.regions[0]);
            this.ensureCQExists(server, this.regions[0], "testCQResultSet_0");
        }
        finally {
            this.closeClient(client);
            this.closeServer(server);
            this.closeServer(server2);
        }
    }

    public void testInterestListAndCQs() throws Exception {
        int i;
        Host host = Host.getHost(0);
        VM server = host.getVM(0);
        VM client = host.getVM(1);
        this.createServer(server);
        int thePort = server.invokeInt(CqQueryDUnitTest.class, "getCacheServerPort");
        String host0 = CqQueryDUnitTest.getServerHostName(server.getHost());
        this.createClient(client, thePort, host0);
        this.createCQ(client, "testInterestListAndCQs_0", this.cqs[0]);
        this.validateCQCount(client, 1);
        int size = 10;
        this.executeCQ(client, "testInterestListAndCQs_0", false, null);
        this.registerInterestListCQ(client, this.regions[0], 10);
        this.createValues(server, this.regions[0], 10);
        for (i = 1; i <= 10; ++i) {
            this.waitForCreated(client, "testInterestListAndCQs_0", KEY + i);
        }
        this.validateCQ(client, "testInterestListAndCQs_0", noTest, 10, noTest, noTest, 10, 0, 0, 10);
        client.invoke(new CacheSerializableRunnable("validate updates"){

            @Override
            public void run2() throws CacheException {
                Region region = CqQueryDUnitTest.this.getRootRegion().getSubregion(CqQueryDUnitTest.this.regions[0]);
                TestCase.assertNotNull((Object)region);
                Set keys = region.entrySet();
                TestCase.assertEquals((String)"Mismatch, number of keys in local region is not equal to the interest list size", (int)10, (int)keys.size());
                CertifiableTestCacheListener ctl = (CertifiableTestCacheListener)region.getAttributes().getCacheListener();
                for (int i = 1; i <= 10; ++i) {
                    ctl.waitForCreated(CqQueryDUnitTest.KEY + i);
                    TestCase.assertNotNull((Object)region.getEntry((Object)(CqQueryDUnitTest.KEY + i)));
                }
            }
        });
        this.createValues(server, this.regions[0], 10);
        for (i = 1; i <= 10; ++i) {
            this.waitForUpdated(client, "testInterestListAndCQs_0", KEY + i);
        }
        client.invoke(new CacheSerializableRunnable("validate updates"){

            @Override
            public void run2() throws CacheException {
                Region region = CqQueryDUnitTest.this.getRootRegion().getSubregion(CqQueryDUnitTest.this.regions[0]);
                TestCase.assertNotNull((Object)region);
                Set keys = region.entrySet();
                TestCase.assertEquals((String)"Mismatch, number of keys in local region is not equal to the interest list size", (int)10, (int)keys.size());
                CertifiableTestCacheListener ctl = (CertifiableTestCacheListener)region.getAttributes().getCacheListener();
                for (int i = 1; i <= 10; ++i) {
                    ctl.waitForUpdated(CqQueryDUnitTest.KEY + i);
                    TestCase.assertNotNull((Object)region.getEntry((Object)(CqQueryDUnitTest.KEY + i)));
                }
            }
        });
        server.invoke(new CacheSerializableRunnable("Invalidate values"){

            @Override
            public void run2() throws CacheException {
                Region region1 = CqQueryDUnitTest.this.getRootRegion().getSubregion(CqQueryDUnitTest.this.regions[0]);
                for (int i = 1; i <= 10; ++i) {
                    region1.invalidate((Object)(CqQueryDUnitTest.KEY + i));
                }
            }
        });
        this.waitForInvalidated(client, "testInterestListAndCQs_0", "key-10");
        client.invoke(new CacheSerializableRunnable("validate invalidates"){

            @Override
            public void run2() throws CacheException {
                Region region = CqQueryDUnitTest.this.getRootRegion().getSubregion(CqQueryDUnitTest.this.regions[0]);
                TestCase.assertNotNull((Object)region);
                Set keys = region.entrySet();
                TestCase.assertEquals((String)"Mismatch, number of keys in local region is not equal to the interest list size", (int)10, (int)keys.size());
                CertifiableTestCacheListener ctl = (CertifiableTestCacheListener)region.getAttributes().getCacheListener();
                for (int i = 1; i <= 10; ++i) {
                    ctl.waitForInvalidated(CqQueryDUnitTest.KEY + i);
                    TestCase.assertNotNull((Object)region.getEntry((Object)(CqQueryDUnitTest.KEY + i)));
                }
            }
        });
        this.validateCQ(client, "testInterestListAndCQs_0", noTest, 10, 10, noTest, 10, 10, 10, 30);
        server.invoke(new CacheSerializableRunnable("Invalidate values"){

            @Override
            public void run2() throws CacheException {
                Region region1 = CqQueryDUnitTest.this.getRootRegion().getSubregion(CqQueryDUnitTest.this.regions[0]);
                for (int i = 1; i <= 10; ++i) {
                    region1.destroy((Object)(CqQueryDUnitTest.KEY + i));
                }
            }
        });
        client.invoke(new CacheSerializableRunnable("validate destroys"){

            @Override
            public void run2() throws CacheException {
                Region region = CqQueryDUnitTest.this.getRootRegion().getSubregion(CqQueryDUnitTest.this.regions[0]);
                TestCase.assertNotNull((Object)region);
                CertifiableTestCacheListener ctl = (CertifiableTestCacheListener)region.getAttributes().getCacheListener();
                for (int i = 1; i <= 10; ++i) {
                    ctl.waitForDestroyed(CqQueryDUnitTest.KEY + i);
                }
            }
        });
        this.validateCQ(client, "testInterestListAndCQs_0", noTest, 10, 10, noTest, 10, 10, 10, 30);
        this.closeClient(client);
        this.closeServer(server);
    }

    public void testCQStopExecute() throws Exception {
        Host host = Host.getHost(0);
        VM server = host.getVM(0);
        VM client = host.getVM(1);
        this.createServer(server);
        int thePort = server.invokeInt(CqQueryDUnitTest.class, "getCacheServerPort");
        String host0 = CqQueryDUnitTest.getServerHostName(server.getHost());
        this.createClient(client, thePort, host0);
        this.createCQ(client, "testCQStopExecute_0", this.cqs[0]);
        this.validateCQCount(client, 1);
        this.executeCQ(client, "testCQStopExecute_0", false, null);
        int size = 10;
        this.createValues(server, this.regions[0], size);
        this.waitForCreated(client, "testCQStopExecute_0", KEY + size);
        this.validateQuery(server, this.cqs[0], 10);
        this.validateCQ(client, "testCQStopExecute_0", noTest, size, 0, 0, size, 0, 0, size);
        this.stopCQ(client, "testCQStopExecute_0");
        this.executeCQ(client, "testCQStopExecute_0", false, null);
        this.createValues(server, this.regions[0], 20);
        this.waitForCreated(client, "testCQStopExecute_0", "key-20");
        size = 30;
        this.validateQuery(server, this.cqs[0], 20);
        this.validateCQ(client, "testCQStopExecute_0", noTest, 20, 10, 0, 20, 10, 0, size);
        this.stopExecCQ(client, "testCQStopExecute_0", 20);
        this.closeCQ(client, "testCQStopExecute_0");
        this.closeClient(client);
        this.closeServer(server);
    }

    public void testCQAttributesMutator() throws Exception {
        Host host = Host.getHost(0);
        VM server = host.getVM(0);
        VM client = host.getVM(1);
        this.createServer(server);
        int thePort = server.invokeInt(CqQueryDUnitTest.class, "getCacheServerPort");
        String host0 = CqQueryDUnitTest.getServerHostName(server.getHost());
        this.createClient(client, thePort, host0);
        String cqName = new String("testCQAttributesMutator_0");
        this.createCQ(client, cqName, this.cqs[0]);
        this.validateCQCount(client, 1);
        this.executeCQ(client, cqName, false, null);
        int size = 10;
        this.createValues(server, this.regions[0], size);
        this.waitForCreated(client, cqName, KEY + size);
        this.validateCQ(client, cqName, noTest, size, 0, 0, size, 0, 0, size);
        this.mutateCQAttributes(client, cqName, 1);
        this.createValues(server, this.regions[0], size * 2);
        this.waitForCreated(client, cqName, KEY + size * 2);
        this.validateCQ(client, cqName, noTest, 20, 10, 0, 20, 10, 0, 30);
        this.mutateCQAttributes(client, cqName, 2);
        this.validateCQ(client, cqName, noTest, 10, 10, 0, 10, 10, 0, 20);
        this.mutateCQAttributes(client, cqName, 0);
        this.deleteValues(server, this.regions[0], 20);
        this.waitForDestroyed(client, cqName, KEY + size * 2);
        this.validateCQ(client, cqName, noTest, 0, 0, 20, 0, 0, 20, 20);
        this.closeCQ(client, cqName);
        this.closeClient(client);
        this.closeServer(server);
    }

    public void testCQCreateClose() throws Exception {
        VM client;
        VM server;
        block7: {
            Throwable causeCause;
            Throwable cause;
            Host host = Host.getHost(0);
            server = host.getVM(0);
            client = host.getVM(1);
            this.createServer(server);
            int thePort = server.invokeInt(CqQueryDUnitTest.class, "getCacheServerPort");
            String host0 = CqQueryDUnitTest.getServerHostName(server.getHost());
            this.createClient(client, thePort, host0);
            this.createCQ(client, "testCQCreateClose_0", this.cqs[0]);
            this.validateCQCount(client, 1);
            this.executeCQ(client, "testCQCreateClose_0", false, null);
            int size = 10;
            this.createValues(server, this.regions[0], size);
            this.waitForCreated(client, "testCQCreateClose_0", KEY + size);
            this.validateQuery(server, this.cqs[0], 10);
            this.validateCQ(client, "testCQCreateClose_0", noTest, size, 0, 0, size, 0, 0, size);
            this.stopCQ(client, "testCQCreateClose_0");
            this.executeCQ(client, "testCQCreateClose_0", false, null);
            this.closeCQ(client, "testCQCreateClose_0");
            this.createAndExecCQNoName(client, this.cqs[0]);
            this.failIfCQExists(client, "testCQCreateClose_0");
            this.createCQ(client, "testCQCreateClose_0", this.cqs[0]);
            this.validateCQCount(client, 1);
            try {
                this.createCQ(client, "testCQCreateClose_0", this.cqs[0]);
                CqQueryDUnitTest.fail((String)"Trying to create CQ with same name. Should have thrown CQExistsException");
            }
            catch (RMIException rmiExc) {
                cause = rmiExc.getCause();
                CqQueryDUnitTest.assertTrue((String)("unexpected cause: " + cause.getClass().getName()), (boolean)(cause instanceof AssertionError));
                causeCause = cause.getCause();
                CqQueryDUnitTest.assertTrue((String)("Got wrong exception: " + causeCause.getClass().getName()), (boolean)(causeCause instanceof CqExistsException));
            }
            this.failIfCQExists(client, "testCQCreateClose_NO");
            try {
                this.createCQ(server, "testCQCreateClose_1", this.cqs[0]);
                CqQueryDUnitTest.fail((String)"Trying to create CQ on Cache Server. Should have thrown Exception.");
            }
            catch (RMIException rmiExc) {
                cause = rmiExc.getCause();
                CqQueryDUnitTest.assertTrue((String)("unexpected cause: " + cause.getClass().getName()), (boolean)(cause instanceof AssertionError));
                causeCause = cause.getCause();
                CqQueryDUnitTest.assertTrue((String)("Got wrong exception: " + causeCause.getClass().getName()), (boolean)(causeCause instanceof IllegalStateException));
            }
            this.createCQ(client, "testCQCreateClose_2", this.invalidCQs[0]);
            try {
                this.executeCQ(client, "testCQCreateClose_2", false, "RegionNotFoundException");
                CqQueryDUnitTest.fail((String)"Trying to create CQ on non-existing Region. Should have thrown Exception.");
            }
            catch (RMIException rmiExc) {
                cause = rmiExc.getCause();
                if (!(cause instanceof AssertionError)) {
                    CqQueryDUnitTest.getLogWriter().severe("Expected to see an AssertionError.", cause);
                    CqQueryDUnitTest.fail((String)"wrong error");
                }
                if ((causeCause = cause.getCause()) instanceof RegionNotFoundException) break block7;
                CqQueryDUnitTest.getLogWriter().severe("Expected cause to be RegionNotFoundException", cause);
                CqQueryDUnitTest.fail((String)"wrong cause");
            }
        }
        this.validateCQCount(client, 2);
        this.createCQ(client, "testCQCreateClose_3", this.cqs[2]);
        this.validateCQCount(client, 3);
        client.invoke(new CacheSerializableRunnable("CloseAll CQ :"){

            @Override
            public void run2() throws CacheException {
                DistributedTestCase.getLogWriter().info("### Close All CQ. ###");
                QueryService cqService = null;
                try {
                    cqService = CqQueryDUnitTest.this.getCache().getQueryService();
                }
                catch (Exception cqe) {
                    cqe.printStackTrace();
                    DistributedTestCase.getLogWriter().info("Failed to getCQService.", (Throwable)cqe);
                    TestCase.fail((String)"Failed to getCQService.");
                }
                try {
                    cqService.closeCqs();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    DistributedTestCase.getLogWriter().info("Failed to close All CQ.", (Throwable)ex);
                    TestCase.fail((String)("Failed to close All CQ. " + ex.getMessage()));
                }
            }
        });
        this.validateCQCount(client, 0);
        this.createCQ(client, "testCQCreateClose_2", this.cqs[1]);
        this.createCQ(client, "testCQCreateClose_4", this.cqs[1]);
        this.createCQ(client, "testCQCreateClose_5", this.cqs[1]);
        this.executeCQ(client, "testCQCreateClose_4", false, null);
        this.executeCQ(client, "testCQCreateClose_5", false, null);
        client.invoke(new CacheSerializableRunnable("CloseAll CQ 2 :"){

            @Override
            public void run2() throws CacheException {
                DistributedTestCase.getLogWriter().info("### Close All CQ 2. ###");
                QueryService cqService = null;
                try {
                    cqService = CqQueryDUnitTest.this.getCache().getQueryService();
                }
                catch (Exception cqe) {
                    cqe.printStackTrace();
                    TestCase.fail((String)"Failed to getCQService.");
                }
                try {
                    cqService.closeCqs();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    TestCase.fail((String)("Failed to close All CQ  . " + ex.getMessage()));
                }
            }
        });
        this.closeClient(client);
        this.closeServer(server);
    }

    public void testRegionDestroy() throws Exception {
        Host host = Host.getHost(0);
        VM server = host.getVM(0);
        VM client = host.getVM(1);
        this.createServer(server);
        int thePort = server.invokeInt(CqQueryDUnitTest.class, "getCacheServerPort");
        String host0 = CqQueryDUnitTest.getServerHostName(server.getHost());
        this.createClient(client, thePort, host0);
        this.createCQ(client, "testRegionDestroy_0", this.cqs[0]);
        this.createCQ(client, "testRegionDestroy_1", this.cqs[0]);
        this.createCQ(client, "testRegionDestroy_2", this.cqs[0]);
        this.executeCQ(client, "testRegionDestroy_0", false, null);
        this.executeCQ(client, "testRegionDestroy_1", false, null);
        this.executeCQ(client, "testRegionDestroy_2", false, null);
        int size = 10;
        this.registerInterestListCQ(client, this.regions[0], 10);
        this.createValues(server, this.regions[0], 10);
        this.waitForCreated(client, "testRegionDestroy_0", "key-10");
        this.validateCQ(client, "testRegionDestroy_0", noTest, 10, noTest, noTest, 10, 0, 0, 10);
        client.invoke(new CacheSerializableRunnable("validate updates"){

            @Override
            public void run2() throws CacheException {
                Region region = CqQueryDUnitTest.this.getRootRegion().getSubregion(CqQueryDUnitTest.this.regions[0]);
                TestCase.assertNotNull((Object)region);
                Set keys = region.entrySet();
                TestCase.assertEquals((String)"Mismatch, number of keys in local region is not equal to the interest list size", (int)10, (int)keys.size());
                CertifiableTestCacheListener ctl = (CertifiableTestCacheListener)region.getAttributes().getCacheListener();
                for (int i = 1; i <= 10; ++i) {
                    ctl.waitForCreated(CqQueryDUnitTest.KEY + i);
                    TestCase.assertNotNull((Object)region.getEntry((Object)(CqQueryDUnitTest.KEY + i)));
                }
            }
        });
        server.invoke(new CacheSerializableRunnable("Destroy Region"){

            @Override
            public void run2() throws CacheException {
                Region region1 = CqQueryDUnitTest.this.getRootRegion().getSubregion(CqQueryDUnitTest.this.regions[0]);
                region1.destroyRegion();
            }
        });
        CqQueryDUnitTest.pause(4000);
        this.validateCQCount(client, 0);
        this.closeClient(client);
        this.closeServer(server);
    }

    public void testCQWithMultipleClients() throws Exception {
        Host host = Host.getHost(0);
        VM server = host.getVM(0);
        VM client1 = host.getVM(1);
        VM client2 = host.getVM(2);
        VM client3 = host.getVM(3);
        this.createServer(server);
        int thePort = server.invokeInt(CqQueryDUnitTest.class, "getCacheServerPort");
        String host0 = CqQueryDUnitTest.getServerHostName(server.getHost());
        this.createClient(client1, thePort, host0);
        this.createClient(client2, thePort, host0);
        this.createCQ(client1, "testCQWithMultipleClients_0", this.cqs[0]);
        this.executeCQ(client1, "testCQWithMultipleClients_0", false, null);
        this.createCQ(client2, "testCQWithMultipleClients_0", this.cqs[0]);
        this.executeCQ(client2, "testCQWithMultipleClients_0", false, null);
        int size = 10;
        this.createValues(server, this.regions[0], size);
        this.waitForCreated(client1, "testCQWithMultipleClients_0", "key-10");
        this.validateCQ(client1, "testCQWithMultipleClients_0", noTest, size, 0, 0, size, 0, 0, size);
        this.waitForCreated(client2, "testCQWithMultipleClients_0", "key-10");
        this.validateCQ(client2, "testCQWithMultipleClients_0", noTest, size, 0, 0, size, 0, 0, size);
        this.closeCQ(client1, "testCQWithMultipleClients_0");
        this.validateCQ(client2, "testCQWithMultipleClients_0", noTest, size, 0, 0, size, 0, 0, size);
        this.createClient(client3, thePort, host0);
        this.createCQ(client3, "testCQWithMultipleClients_0", this.cqs[0]);
        this.createCQ(client3, "testCQWithMultipleClients_1", this.cqs[1]);
        this.executeCQ(client3, "testCQWithMultipleClients_0", false, null);
        this.executeCQ(client3, "testCQWithMultipleClients_1", false, null);
        this.createValues(server, this.regions[0], size);
        this.waitForUpdated(client3, "testCQWithMultipleClients_0", "key-10");
        this.validateCQ(client3, "testCQWithMultipleClients_0", noTest, 0, size, 0, 0, size, 0, size);
        this.validateCQ(client3, "testCQWithMultipleClients_1", noTest, 0, 1, 0, 0, 1, 0, 1);
        this.validateCQCount(client1, 0);
        this.validateCQCount(client2, 1);
        this.validateCQCount(client3, 2);
        this.closeClient(client1);
        this.clearCQListenerEvents(client2, "testCQWithMultipleClients_0");
        this.clearCQListenerEvents(client3, "testCQWithMultipleClients_1");
        this.createValues(server, this.regions[0], size);
        this.waitForUpdated(client2, "testCQWithMultipleClients_0", "key-10");
        this.validateCQ(client2, "testCQWithMultipleClients_0", noTest, size, size * 2, 0, size, size * 2, 0, size * 3);
        this.waitForUpdated(client3, "testCQWithMultipleClients_1", "key-2");
        this.validateCQ(client3, "testCQWithMultipleClients_1", noTest, 0, 2, 0, 0, 2, 0, 2);
        this.closeClient(client2);
        this.closeClient(client3);
        this.closeServer(server);
    }

    public void testCQResultSet() throws Exception {
        Host host = Host.getHost(0);
        VM server = host.getVM(0);
        VM client = host.getVM(1);
        this.createServer(server);
        int thePort = server.invokeInt(CqQueryDUnitTest.class, "getCacheServerPort");
        String host0 = CqQueryDUnitTest.getServerHostName(server.getHost());
        this.createClient(client, thePort, host0);
        int size = 10;
        this.createValues(server, this.regions[0], size);
        CqQueryDUnitTest.pause(500);
        this.createCQ(client, "testCQResultSet_0", this.cqs[0]);
        this.executeCQ(client, "testCQResultSet_0", true, 10, null);
        this.createCQ(client, "testCQResultSet_1", this.cqs[2]);
        this.executeCQ(client, "testCQResultSet_1", true, 0, null);
        this.stopCQ(client, "testCQResultSet_1");
        this.createValues(server, this.regions[1], 5);
        this.validateQuery(server, this.cqs[2], 2);
        this.executeCQ(client, "testCQResultSet_1", true, 2, null);
        this.closeClient(client);
        this.closeServer(server);
    }

    public void testCQEvents() throws Exception {
        Host host = Host.getHost(0);
        VM server = host.getVM(0);
        VM client = host.getVM(1);
        this.createServer(server);
        int thePort = server.invokeInt(CqQueryDUnitTest.class, "getCacheServerPort");
        String host0 = CqQueryDUnitTest.getServerHostName(server.getHost());
        this.createClient(client, thePort, host0);
        this.createCQ(client, "testCQEvents_0", this.cqs[0]);
        this.executeCQ(client, "testCQEvents_0", false, null);
        int size = 10;
        this.createValues(server, this.regions[0], size);
        this.waitForCreated(client, "testCQEvents_0", KEY + size);
        this.validateCQ(client, "testCQEvents_0", noTest, size, 0, 0, size, 0, 0, size);
        this.createValues(server, this.regions[0], 5);
        this.createValues(server, this.regions[0], 10);
        this.waitForUpdated(client, "testCQEvents_0", KEY + size);
        this.validateCQ(client, "testCQEvents_0", noTest, size, 15, 0, size, 15, 0, size + 15);
        this.deleteValues(server, this.regions[0], 5);
        this.waitForDestroyed(client, "testCQEvents_0", "key-5");
        this.validateCQ(client, "testCQEvents_0", noTest, size, 15, 5, size, 15, 5, size + 15 + 5);
        server.invoke(new CacheSerializableRunnable("Create values"){

            @Override
            public void run2() throws CacheException {
                Region region1 = CqQueryDUnitTest.this.getRootRegion().getSubregion(CqQueryDUnitTest.this.regions[0]);
                for (int i = -1; i >= -5; --i) {
                    region1.put((Object)(CqQueryDUnitTest.KEY + i), (Object)(CqQueryDUnitTest.KEY + i));
                }
            }
        });
        CqQueryDUnitTest.pause(1000);
        this.validateCQ(client, "testCQEvents_0", noTest, size, 15, 5, size, 15, 5, size + 15 + 5);
        this.closeClient(client);
        this.closeServer(server);
    }

    public void testEnableDisableCQ() throws Exception {
        Host host = Host.getHost(0);
        VM server = host.getVM(0);
        VM client = host.getVM(1);
        this.createServer(server);
        int thePort = server.invokeInt(CqQueryDUnitTest.class, "getCacheServerPort");
        String host0 = CqQueryDUnitTest.getServerHostName(server.getHost());
        this.createClient(client, thePort, host0);
        this.createCQ(client, "testEnableDisable_0", this.cqs[0]);
        this.executeCQ(client, "testEnableDisable_0", false, null);
        client.invoke(new CacheSerializableRunnable("Client disableCQs()"){

            @Override
            public void run2() throws CacheException {
                QueryService cqService = null;
                try {
                    cqService = CqQueryDUnitTest.this.getCache().getQueryService();
                    cqService.stopCqs();
                }
                catch (Exception cqe) {
                    cqe.printStackTrace();
                    TestCase.fail((String)"Failed to getCQService.");
                }
            }
        });
        CqQueryDUnitTest.pause(1000);
        int size = 10;
        this.createValues(server, this.regions[0], size);
        CqQueryDUnitTest.pause(500);
        this.validateCQ(client, "testEnableDisable_0", noTest, 0, 0, 0, 0, 0, 0, 0);
        client.invoke(new CacheSerializableRunnable("Client enableCQs()"){

            @Override
            public void run2() throws CacheException {
                QueryService cqService = null;
                try {
                    cqService = CqQueryDUnitTest.this.getCache().getQueryService();
                    cqService.executeCqs();
                }
                catch (Exception cqe) {
                    cqe.printStackTrace();
                    TestCase.fail((String)"Failed to getCQService.");
                }
            }
        });
        CqQueryDUnitTest.pause(1000);
        this.createValues(server, this.regions[0], size);
        this.waitForUpdated(client, "testEnableDisable_0", KEY + size);
        this.validateCQ(client, "testEnableDisable_0", noTest, 0, size, 0, 0, size, 0, size);
        client.invoke(new CacheSerializableRunnable("Client disableCQs()"){

            @Override
            public void run2() throws CacheException {
                QueryService cqService = null;
                try {
                    cqService = CqQueryDUnitTest.this.getCache().getQueryService();
                    cqService.stopCqs("/root/" + CqQueryDUnitTest.this.regions[0]);
                }
                catch (Exception cqe) {
                    cqe.printStackTrace();
                    TestCase.fail((String)"Failed to getCQService.");
                }
            }
        });
        CqQueryDUnitTest.pause(2000);
        this.deleteValues(server, this.regions[0], size / 2);
        CqQueryDUnitTest.pause(500);
        this.validateCQ(client, "testEnableDisable_0", noTest, 0, size, 0, 0, size, 0, size);
        client.invoke(new CacheSerializableRunnable("Client enableCQs()"){

            @Override
            public void run2() throws CacheException {
                QueryService cqService = null;
                try {
                    cqService = CqQueryDUnitTest.this.getCache().getQueryService();
                    cqService.executeCqs("/root/" + CqQueryDUnitTest.this.regions[0]);
                }
                catch (Exception cqe) {
                    cqe.printStackTrace();
                    TestCase.fail((String)"Failed to getCQService.");
                }
            }
        });
        CqQueryDUnitTest.pause(1000);
        this.createValues(server, this.regions[0], size / 2);
        this.waitForCreated(client, "testEnableDisable_0", KEY + size / 2);
        this.validateCQ(client, "testEnableDisable_0", noTest, size / 2, size, 0, size / 2, size, 0, size * 3 / 2);
        this.closeClient(client);
        this.closeServer(server);
    }

    public void testQuery() throws Exception {
        Host host = Host.getHost(0);
        VM server = host.getVM(0);
        VM client = host.getVM(1);
        this.createServer(server);
        int thePort = server.invokeInt(CqQueryDUnitTest.class, "getCacheServerPort");
        String host0 = CqQueryDUnitTest.getServerHostName(server.getHost());
        this.createClient(client, thePort, host0);
        this.createCQ(client, "testQuery_3", this.cqs[3]);
        this.executeCQ(client, "testQuery_3", true, null);
        this.createCQ(client, "testQuery_4", this.cqs[4]);
        this.executeCQ(client, "testQuery_4", true, null);
        this.createCQ(client, "testQuery_5", this.cqs[5]);
        this.executeCQ(client, "testQuery_5", true, null);
        this.createCQ(client, "testQuery_6", this.cqs[6]);
        this.executeCQ(client, "testQuery_6", true, null);
        this.createCQ(client, "testQuery_7", this.cqs[7]);
        this.executeCQ(client, "testQuery_7", true, null);
        this.createCQ(client, "testQuery_8", this.cqs[8]);
        this.executeCQ(client, "testQuery_8", true, null);
        this.closeClient(client);
        this.closeServer(server);
    }

    public void testCQFailOver() throws Exception {
        int i;
        Host host = Host.getHost(0);
        VM server1 = host.getVM(0);
        VM server2 = host.getVM(1);
        VM client = host.getVM(2);
        this.createServer(server1);
        int port1 = server1.invokeInt(CqQueryDUnitTest.class, "getCacheServerPort");
        String host0 = CqQueryDUnitTest.getServerHostName(server1.getHost());
        int[] ports = AvailablePortHelper.getRandomAvailableTCPPorts(1);
        this.createClient(client, new int[]{port1, ports[0]}, host0, "-1");
        int numCQs = 1;
        for (int i2 = 0; i2 < numCQs; ++i2) {
            this.createCQ(client, "testCQFailOver_" + i2, this.cqs[i2]);
            this.executeCQ(client, "testCQFailOver_" + i2, false, null);
        }
        CqQueryDUnitTest.pause(1000);
        this.createValues(server1, this.regions[0], 10);
        this.createValues(server1, this.regions[1], 10);
        this.waitForCreated(client, "testCQFailOver_0", "key-10");
        CqQueryDUnitTest.pause(1000);
        this.createServer(server2, ports[0]);
        int thePort2 = server2.invokeInt(CqQueryDUnitTest.class, "getCacheServerPort");
        System.out.println("### Port on which server1 running : " + port1 + " Server2 running : " + thePort2);
        CqQueryDUnitTest.pause(3000);
        CqQueryDUnitTest.pause(5000);
        this.createValues(server1, this.regions[0], 10);
        this.createValues(server1, this.regions[1], 10);
        this.waitForUpdated(client, "testCQFailOver_0", "key-10");
        int[] resultsCnt = new int[]{10, 1, 2};
        for (i = 0; i < numCQs; ++i) {
            this.validateCQ(client, "testCQFailOver_" + i, noTest, resultsCnt[i], resultsCnt[i], noTest);
        }
        this.closeServer(server1);
        CqQueryDUnitTest.pause(3000);
        for (i = 0; i < numCQs; ++i) {
            this.validateCQ(client, "testCQFailOver_" + i, noTest, resultsCnt[i], resultsCnt[i], noTest);
        }
        this.clearCQListenerEvents(client, "testCQFailOver_0");
        this.createValues(server2, this.regions[0], 10);
        this.createValues(server2, this.regions[1], 10);
        for (i = 1; i <= 10; ++i) {
            this.waitForUpdated(client, "testCQFailOver_0", KEY + i);
        }
        for (i = 0; i < numCQs; ++i) {
            this.validateCQ(client, "testCQFailOver_" + i, noTest, resultsCnt[i], resultsCnt[i] * 2, noTest);
        }
        this.closeClient(client);
        this.closeServer(server2);
    }

    public void testCQHA() throws Exception {
        int i;
        Host host = Host.getHost(0);
        VM server1 = host.getVM(0);
        VM server2 = host.getVM(1);
        VM server3 = host.getVM(2);
        VM client = host.getVM(3);
        this.createServer(server1);
        int port1 = server1.invokeInt(CqQueryDUnitTest.class, "getCacheServerPort");
        String host0 = CqQueryDUnitTest.getServerHostName(server1.getHost());
        int[] ports = AvailablePortHelper.getRandomAvailableTCPPorts(2);
        this.createServer(server2, ports[0]);
        int thePort2 = server2.invokeInt(CqQueryDUnitTest.class, "getCacheServerPort");
        this.createServer(server3, ports[1]);
        int port3 = server3.invokeInt(CqQueryDUnitTest.class, "getCacheServerPort");
        System.out.println("### Port on which server1 running : " + port1 + " server2 running : " + thePort2 + " Server3 running : " + port3);
        this.createClient(client, new int[]{port1, thePort2, port3}, host0, "1");
        int numCQs = 1;
        for (int i2 = 0; i2 < numCQs; ++i2) {
            this.createCQ(client, "testCQHA_" + i2, this.cqs[i2]);
            this.executeCQ(client, "testCQHA_" + i2, false, null);
        }
        CqQueryDUnitTest.pause(1000);
        this.createValues(server1, this.regions[0], 10);
        this.createValues(server1, this.regions[1], 10);
        this.waitForCreated(client, "testCQHA_0", "key-10");
        int[] resultsCnt = new int[]{10, 1, 2};
        this.closeServer(server1);
        CqQueryDUnitTest.pause(3000);
        this.createValues(server2, this.regions[0], 10);
        this.createValues(server2, this.regions[1], 10);
        this.waitForUpdated(client, "testCQHA_0", "key-10");
        for (i = 0; i < numCQs; ++i) {
            this.validateCQ(client, "testCQHA_" + i, noTest, resultsCnt[i], resultsCnt[i], noTest);
        }
        this.closeServer(server2);
        CqQueryDUnitTest.pause(2000);
        this.clearCQListenerEvents(client, "testCQHA_0");
        this.createValues(server3, this.regions[0], 10);
        this.createValues(server3, this.regions[1], 10);
        this.waitForUpdated(client, "testCQHA_0", "key-10");
        for (i = 0; i < numCQs; ++i) {
            this.validateCQ(client, "testCQHA_" + i, noTest, resultsCnt[i], resultsCnt[i] * 2, noTest);
        }
        this.closeClient(client);
        this.closeServer(server3);
    }

    public void testWithoutCQs() throws Exception {
        Host host = Host.getHost(0);
        VM server1 = host.getVM(0);
        VM server2 = host.getVM(1);
        VM client = host.getVM(2);
        this.createServer(server1);
        this.createServer(server2);
        final int port1 = server1.invokeInt(CqQueryDUnitTest.class, "getCacheServerPort");
        final String host0 = CqQueryDUnitTest.getServerHostName(server1.getHost());
        final int thePort2 = server2.invokeInt(CqQueryDUnitTest.class, "getCacheServerPort");
        CacheSerializableRunnable createConnectionPool = new CacheSerializableRunnable("Create region"){

            @Override
            public void run2() throws CacheException {
                CqQueryDUnitTest.this.getCache();
                AttributesFactory regionFactory = new AttributesFactory();
                regionFactory.setScope(Scope.LOCAL);
                BridgeTestCase.configureConnectionPool(regionFactory, host0, port1, thePort2, true, -1, -1, null);
                CqQueryDUnitTest.this.createRegion(CqQueryDUnitTest.this.regions[0], regionFactory.createRegionAttributes());
            }
        };
        client.invoke(createConnectionPool);
        server1.invoke(new CacheSerializableRunnable("Create values"){

            @Override
            public void run2() throws CacheException {
                Region region1 = CqQueryDUnitTest.this.getRootRegion().getSubregion(CqQueryDUnitTest.this.regions[0]);
                for (int i = 0; i < 20; ++i) {
                    region1.put((Object)("key-string-" + i), (Object)("value-" + i));
                }
            }
        });
        client.invoke(new CacheSerializableRunnable("Put values client"){

            @Override
            public void run2() throws CacheException {
                Region region1 = CqQueryDUnitTest.this.getRootRegion().getSubregion(CqQueryDUnitTest.this.regions[0]);
                for (int i = 0; i < 10; ++i) {
                    region1.put((Object)("key-string-" + i), (Object)("client-value-" + i));
                }
            }
        });
        CqQueryDUnitTest.pause(2000);
        this.closeServer(server1);
        this.closeServer(server2);
    }

    public void testGetCQsForARegionName() throws Exception {
        Host host = Host.getHost(0);
        VM server = host.getVM(0);
        VM client = host.getVM(1);
        this.createServer(server);
        int thePort = server.invokeInt(CqQueryDUnitTest.class, "getCacheServerPort");
        String host0 = CqQueryDUnitTest.getServerHostName(server.getHost());
        this.createClient(client, thePort, host0);
        this.createCQ(client, "testQuery_3", this.cqs[3]);
        this.executeCQ(client, "testQuery_3", true, null);
        this.createCQ(client, "testQuery_4", this.cqs[4]);
        this.executeCQ(client, "testQuery_4", true, null);
        this.createCQ(client, "testQuery_5", this.cqs[5]);
        this.executeCQ(client, "testQuery_5", true, null);
        this.createCQ(client, "testQuery_6", this.cqs[6]);
        this.executeCQ(client, "testQuery_6", true, null);
        this.createCQ(client, "testQuery_7", this.cqs[7]);
        this.executeCQ(client, "testQuery_7", true, null);
        this.createCQ(client, "testQuery_8", this.cqs[8]);
        this.executeCQ(client, "testQuery_8", true, null);
        client.invoke(new CacheSerializableRunnable("Client disableCQs()"){

            @Override
            public void run2() throws CacheException {
                QueryService cqService = null;
                try {
                    cqService = CqQueryDUnitTest.this.getCache().getQueryService();
                    CqQuery[] cq = cqService.getCqs("/root/" + CqQueryDUnitTest.this.regions[0]);
                    TestCase.assertNotNull((String)("CQservice should not return null for cqs on this region : /root/" + CqQueryDUnitTest.this.regions[0]), (Object)cq);
                    CqQueryDUnitTest.this.getCache().getLogger().info("cqs for region: /root/" + CqQueryDUnitTest.this.regions[0] + " : " + cq.length);
                    cq[0].close();
                    cq = cqService.getCqs("/root/" + CqQueryDUnitTest.this.regions[0]);
                    TestCase.assertNotNull((String)("CQservice should not return null for cqs on this region : /root/" + CqQueryDUnitTest.this.regions[0]), (Object)cq);
                    CqQueryDUnitTest.this.getCache().getLogger().info("cqs for region: /root/" + CqQueryDUnitTest.this.regions[0] + " after closeing one of the cqs : " + cq.length);
                    cq = cqService.getCqs("/root/" + CqQueryDUnitTest.this.regions[1]);
                    CqQueryDUnitTest.this.getCache().getLogger().info("cqs for region: /root/" + CqQueryDUnitTest.this.regions[1] + " : " + cq.length);
                    TestCase.assertNotNull((String)("CQservice should not return null for cqs on this region : /root/" + CqQueryDUnitTest.this.regions[1]), (Object)cq);
                }
                catch (Exception cqe) {
                    DistributedTestCase.fail("Failed to getCQService", cqe);
                }
            }
        });
        this.closeClient(client);
        this.closeServer(server);
    }

    public void testQueryWithNULLInWhereClause() throws Exception {
        int i;
        Host host = Host.getHost(0);
        VM server = host.getVM(0);
        VM client = host.getVM(1);
        VM producer = host.getVM(2);
        this.createServer(server);
        int thePort = server.invokeInt(CqQueryDUnitTest.class, "getCacheServerPort");
        String host0 = CqQueryDUnitTest.getServerHostName(server.getHost());
        this.createClient(client, thePort, host0);
        this.createClient(producer, thePort, host0);
        int size = 50;
        this.createValues(producer, this.regions[0], 50);
        this.createCQ(client, "testQuery_9", this.cqs[9]);
        this.executeCQ(client, "testQuery_9", true, null);
        this.createValues(producer, this.regions[0], 100);
        for (i = 1; i <= 50; ++i) {
            if (i % 2 != 0) continue;
            this.waitForUpdated(client, "testQuery_9", KEY + i);
        }
        for (i = 51; i <= 100; ++i) {
            if (i % 2 != 0) continue;
            this.waitForCreated(client, "testQuery_9", KEY + i);
        }
        this.validateCQ(client, "testQuery_9", noTest, 25, 25, noTest);
        this.closeClient(client);
        this.closeServer(server);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void testForSupportedRegionAttributes() throws Exception {
        Host host = Host.getHost(0);
        VM server1 = host.getVM(0);
        VM server2 = host.getVM(1);
        VM client = host.getVM(2);
        CacheSerializableRunnable createServer = new CacheSerializableRunnable("Create Cache Server"){

            @Override
            public void run2() throws CacheException {
                DistributedTestCase.getLogWriter().info("### Create Cache Server. ###");
                AttributesFactory factory1 = new AttributesFactory();
                factory1.setScope(Scope.GLOBAL);
                factory1.setMirrorType(MirrorType.KEYS_VALUES);
                CqQueryDUnitTest.this.createRegion(CqQueryDUnitTest.this.regions[0], factory1.createRegionAttributes());
                AttributesFactory factory2 = new AttributesFactory();
                factory2.setScope(Scope.DISTRIBUTED_NO_ACK);
                factory2.setMirrorType(MirrorType.KEYS_VALUES);
                CqQueryDUnitTest.this.createRegion(CqQueryDUnitTest.this.regions[1], factory2.createRegionAttributes());
                DistributedTestCase.pause(2000);
                try {
                    CqQueryDUnitTest.this.startBridgeServer(port, true);
                }
                catch (Exception ex) {
                    DistributedTestCase.fail("While starting CacheServer", ex);
                }
                DistributedTestCase.pause(2000);
            }
        };
        server1.invoke(createServer);
        server2.invoke(createServer);
        int port1 = server1.invokeInt(CqQueryDUnitTest.class, "getCacheServerPort");
        String host0 = CqQueryDUnitTest.getServerHostName(server1.getHost());
        int thePort2 = server2.invokeInt(CqQueryDUnitTest.class, "getCacheServerPort");
        this.createClient(client, new int[]{port1, thePort2}, host0, "-1");
        this.createCQ(client, "testForSupportedRegionAttributes_0", this.cqs[0]);
        this.executeCQ(client, "testForSupportedRegionAttributes_0", false, null);
        int size = 5;
        this.createValues(server1, this.regions[0], size);
        for (int i = 1; i <= size; ++i) {
            this.waitForCreated(client, "testForSupportedRegionAttributes_0", KEY + i);
        }
        this.createCQ(client, "testForSupportedRegionAttributes_1", this.cqs[2]);
        String errMsg = "The replicated region  specified in CQ creation does not have scope supported by CQ. The CQ supported scopes are DISTRIBUTED_ACK and GLOBAL.";
        String expectedErr = "Cq not registered on primary";
        client.invoke(new CacheSerializableRunnable("Set expect"){

            @Override
            public void run2() {
                CqQueryDUnitTest.this.getCache().getLogger().info("<ExpectedException action=add>Cq not registered on primary</ExpectedException>");
            }
        });
        try {
            this.executeCQ(client, "testForSupportedRegionAttributes_1", false, "CqException");
            CqQueryDUnitTest.fail((String)("The test should have failed with exception, " + errMsg));
            client.invoke(new CacheSerializableRunnable("Remove expect"){

                @Override
                public void run2() {
                    CqQueryDUnitTest.this.getCache().getLogger().info("<ExpectedException action=remove>Cq not registered on primary</ExpectedException>");
                }
            });
        }
        catch (Exception exception) {
            client.invoke(new /* invalid duplicate definition of identical inner class */);
            catch (Throwable throwable) {
                client.invoke(new /* invalid duplicate definition of identical inner class */);
                throw throwable;
            }
        }
        this.closeClient(client);
        this.closeServer(server1);
        this.closeServer(server2);
    }

    public void testCQWhereCondOnShort() throws Exception {
        Host host = Host.getHost(0);
        VM server = host.getVM(0);
        VM client = host.getVM(1);
        this.createServer(server);
        int thePort = server.invokeInt(CqQueryDUnitTest.class, "getCacheServerPort");
        String host0 = CqQueryDUnitTest.getServerHostName(server.getHost());
        this.createClient(client, thePort, host0);
        int size = 5;
        this.createValuesWithShort(server, this.regions[0], size);
        CqQueryDUnitTest.pause(500);
        this.createCQ(client, "testCQResultSet_0", this.shortTypeCQs[0]);
        this.executeCQ(client, "testCQResultSet_0", true, 5, null);
        this.closeClient(client);
        this.closeServer(server);
    }

    public void testCQEquals() throws Exception {
        Host host = Host.getHost(0);
        VM server = host.getVM(0);
        VM client = host.getVM(1);
        this.createServer(server);
        int thePort = server.invokeInt(CqQueryDUnitTest.class, "getCacheServerPort");
        String host0 = CqQueryDUnitTest.getServerHostName(server.getHost());
        this.createClient(client, thePort, host0);
        int size = 10;
        this.createValuesAsPrimitives(server, this.regions[0], size);
        CqQueryDUnitTest.pause(500);
        this.createCQ(client, "equalsQuery1", "select * from /root/regionA p where p.equals('seeded')");
        this.executeCQ(client, "equalsQuery1", true, 2, null);
        this.createCQ(client, "equalsQuery2", "select * from /root/regionA p where p='seeded'");
        this.executeCQ(client, "equalsQuery2", true, 2, null);
        this.createCQ(client, "equalsStatusQuery1", "select * from /root/regionA p where p.status.equals('inactive')");
        this.executeCQ(client, "equalsStatusQuery1", true, 1, null);
        this.createCQ(client, "equalsStatusQuery2", "select * from /root/regionA p where p.status='inactive'");
        this.executeCQ(client, "equalsStatusQuery2", true, 1, null);
        this.closeClient(client);
        this.closeServer(server);
    }

    public void testCQEqualsWithIndex() throws Exception {
        Host host = Host.getHost(0);
        VM server = host.getVM(0);
        VM client = host.getVM(1);
        this.createServer(server);
        int thePort = server.invokeInt(CqQueryDUnitTest.class, "getCacheServerPort");
        String host0 = CqQueryDUnitTest.getServerHostName(server.getHost());
        this.createClient(client, thePort, host0);
        int size = 10;
        this.createIndex(server, "index1", "p.status", "/root/regionA p");
        this.createValuesAsPrimitives(server, this.regions[0], size);
        CqQueryDUnitTest.pause(500);
        this.createCQ(client, "equalsQuery1", "select * from /root/regionA p where p.equals('seeded')");
        this.executeCQ(client, "equalsQuery1", true, 2, null);
        this.createCQ(client, "equalsQuery2", "select * from /root/regionA p where p='seeded'");
        this.executeCQ(client, "equalsQuery2", true, 2, null);
        this.createCQ(client, "equalsStatusQuery1", "select * from /root/regionA p where p.status.equals('inactive')");
        this.executeCQ(client, "equalsStatusQuery1", true, 1, null);
        this.createCQ(client, "equalsStatusQuery2", "select * from /root/regionA p where p.status='inactive'");
        this.executeCQ(client, "equalsStatusQuery2", true, 1, null);
        this.closeClient(client);
        this.closeServer(server);
    }

    public void testCQAllServersCrash() throws Exception {
        Host host = Host.getHost(0);
        VM server1 = host.getVM(0);
        VM server2 = host.getVM(1);
        VM client = host.getVM(2);
        this.createServer(server1);
        int port1 = server1.invokeInt(CqQueryDUnitTest.class, "getCacheServerPort");
        String host0 = CqQueryDUnitTest.getServerHostName(server1.getHost());
        int[] ports = AvailablePortHelper.getRandomAvailableTCPPorts(1);
        this.createClient(client, new int[]{port1, ports[0]}, host0, "-1");
        boolean numCQs = true;
        this.createCQ(client, "testCQAllServersLeave_11", this.cqs[11], true);
        this.executeCQ(client, "testCQAllServersLeave_11", false, null);
        CqQueryDUnitTest.pause(5000);
        this.waitForCqsConnected(client, "testCQAllServersLeave_11", 1);
        this.createValues(server1, this.regions[0], 10);
        this.waitForCreated(client, "testCQAllServersLeave_11", "key-10");
        this.createServer(server2, ports[0]);
        int thePort2 = server2.invokeInt(CqQueryDUnitTest.class, "getCacheServerPort");
        CqQueryDUnitTest.pause(8000);
        this.crashServer(server1);
        CqQueryDUnitTest.pause(3000);
        this.crashServer(server2);
        CqQueryDUnitTest.pause(3000);
        this.waitForCqsDisconnected(client, "testCQAllServersLeave_11", 1);
        this.closeClient(client);
        this.closeCrashServer(server1);
        this.closeCrashServer(server2);
    }

    public void testCQAllServersLeave() throws Exception {
        Host host = Host.getHost(0);
        VM server1 = host.getVM(0);
        VM server2 = host.getVM(1);
        VM client = host.getVM(2);
        this.createServer(server1);
        int port1 = server1.invokeInt(CqQueryDUnitTest.class, "getCacheServerPort");
        String host0 = CqQueryDUnitTest.getServerHostName(server1.getHost());
        int[] ports = AvailablePortHelper.getRandomAvailableTCPPorts(1);
        this.createClient(client, new int[]{port1, ports[0]}, host0, "-1");
        CqQueryDUnitTest.pause(5000);
        this.createCQ(client, "testCQAllServersLeave_11", this.cqs[11], true);
        this.executeCQ(client, "testCQAllServersLeave_11", false, null);
        CqQueryDUnitTest.pause(5000);
        this.waitForCqsConnected(client, "testCQAllServersLeave_11", 1);
        this.createValues(server1, this.regions[0], 10);
        this.waitForCreated(client, "testCQAllServersLeave_11", "key-10");
        this.createServer(server2, ports[0]);
        int thePort2 = server2.invokeInt(CqQueryDUnitTest.class, "getCacheServerPort");
        CqQueryDUnitTest.pause(10000);
        this.closeServer(server1);
        CqQueryDUnitTest.pause(10000);
        this.waitForCqsDisconnected(client, "testCQAllServersLeave_11", 0);
        this.closeServer(server2);
        CqQueryDUnitTest.pause(10000);
        this.waitForCqsDisconnected(client, "testCQAllServersLeave_11", 1);
        this.closeClient(client);
    }

    public void testCQAllServersLeaveAndRejoin() throws Exception {
        Host host = Host.getHost(0);
        VM server1 = host.getVM(0);
        VM server2 = host.getVM(1);
        VM client = host.getVM(2);
        this.createServer(server1);
        int port1 = server1.invokeInt(CqQueryDUnitTest.class, "getCacheServerPort");
        String host0 = CqQueryDUnitTest.getServerHostName(server1.getHost());
        int[] ports = AvailablePortHelper.getRandomAvailableTCPPorts(1);
        this.createClient(client, new int[]{port1, ports[0]}, host0, "-1");
        this.createCQ(client, "testCQAllServersLeave_11", this.cqs[11], true);
        this.executeCQ(client, "testCQAllServersLeave_11", false, null);
        CqQueryDUnitTest.pause(5000);
        this.waitForCqsConnected(client, "testCQAllServersLeave_11", 1);
        this.createValues(server1, this.regions[0], 10);
        this.waitForCreated(client, "testCQAllServersLeave_11", "key-10");
        this.createServer(server2, ports[0]);
        int thePort2 = server2.invokeInt(CqQueryDUnitTest.class, "getCacheServerPort");
        CqQueryDUnitTest.pause(8000);
        this.closeServer(server1);
        CqQueryDUnitTest.pause(10000);
        this.waitForCqsDisconnected(client, "testCQAllServersLeave_11", 0);
        this.closeServer(server2);
        CqQueryDUnitTest.pause(10000);
        this.waitForCqsDisconnected(client, "testCQAllServersLeave_11", 1);
        this.restartBridgeServer(server1, port1);
        CqQueryDUnitTest.pause(10000);
        this.waitForCqsConnected(client, "testCQAllServersLeave_11", 2);
        CqQueryDUnitTest.pause(10000);
        this.closeServer(server1);
        this.waitForCqsDisconnected(client, "testCQAllServersLeave_11", 2);
        this.closeClient(client);
    }

    public void testCQPrimaryLeaves() throws Exception {
        Host host = Host.getHost(0);
        VM server1 = host.getVM(0);
        VM server2 = host.getVM(1);
        VM client = host.getVM(2);
        this.createServer(server1);
        int port1 = server1.invokeInt(CqQueryDUnitTest.class, "getCacheServerPort");
        String host0 = CqQueryDUnitTest.getServerHostName(server1.getHost());
        int[] ports = AvailablePortHelper.getRandomAvailableTCPPorts(1);
        this.createClient(client, new int[]{port1, ports[0]}, host0, "-1");
        this.createCQ(client, "testCQAllServersLeave_11", this.cqs[11], true);
        this.executeCQ(client, "testCQAllServersLeave_11", false, null);
        CqQueryDUnitTest.pause(5000);
        this.waitForCqsConnected(client, "testCQAllServersLeave_11", 1);
        this.createValues(server1, this.regions[0], 10);
        this.waitForCreated(client, "testCQAllServersLeave_11", "key-10");
        this.createServer(server2, ports[0]);
        int thePort2 = server2.invokeInt(CqQueryDUnitTest.class, "getCacheServerPort");
        CqQueryDUnitTest.pause(8000);
        this.closeServer(server1);
        CqQueryDUnitTest.pause(10000);
        this.waitForCqsDisconnected(client, "testCQAllServersLeave_11", 0);
        this.closeServer(server2);
        CqQueryDUnitTest.pause(10000);
        this.waitForCqsDisconnected(client, "testCQAllServersLeave_11", 1);
        this.closeClient(client);
        this.closeServer(server1);
    }

    public void testCQAllServersLeaveMultiplePool() throws Exception {
        Host host = Host.getHost(0);
        VM server1 = host.getVM(0);
        VM server2 = host.getVM(1);
        VM client = host.getVM(2);
        this.createServer(server1);
        int port1 = server1.invokeInt(CqQueryDUnitTest.class, "getCacheServerPort");
        String host0 = CqQueryDUnitTest.getServerHostName(server1.getHost());
        int[] ports = AvailablePortHelper.getRandomAvailableTCPPorts(1);
        this.createServer(server2, ports[0]);
        int thePort2 = server2.invokeInt(CqQueryDUnitTest.class, "getCacheServerPort");
        CqQueryDUnitTest.pause(8000);
        this.createClientWith2Pools(client, new int[]{port1}, new int[]{thePort2}, host0, "-1");
        this.createCQ(client, "testCQAllServersLeave_11", this.cqs[11], true);
        this.executeCQ(client, "testCQAllServersLeave_11", false, null);
        this.createCQ(client, "testCQAllServersLeave_12", this.cqs[12], true);
        this.executeCQ(client, "testCQAllServersLeave_12", false, null);
        CqQueryDUnitTest.pause(5000);
        this.waitForCqsConnected(client, "testCQAllServersLeave_11", 1);
        this.waitForCqsConnected(client, "testCQAllServersLeave_12", 1);
        this.createValues(server2, this.regions[0], 10);
        this.createValues(server2, this.regions[1], 10);
        this.waitForCreated(client, "testCQAllServersLeave_11", "key-10");
        this.closeServer(server1);
        this.waitForCqsDisconnected(client, "testCQAllServersLeave_11", 1);
        this.createValues(server2, this.regions[1], 20);
        this.waitForCreated(client, "testCQAllServersLeave_12", "key-19");
        this.closeServer(server2);
        this.waitForCqsDisconnected(client, "testCQAllServersLeave_12", 1);
        this.closeClient(client);
    }

    public void testCqCloseAndExecuteWithInitialResults() throws Exception {
        Host host = Host.getHost(0);
        VM server = host.getVM(0);
        VM client = host.getVM(1);
        this.createServer(server);
        int thePort = server.invokeInt(CqQueryDUnitTest.class, "getCacheServerPort");
        String host0 = CqQueryDUnitTest.getServerHostName(server.getHost());
        this.createClient(client, thePort, host0);
        int size = 5;
        this.createValuesWithShort(server, this.regions[0], size);
        CqQueryDUnitTest.pause(500);
        this.executeAndCloseAndExecuteIRMultipleTimes(client, "testCQResultSet_0", this.shortTypeCQs[0]);
        this.closeClient(client);
        this.closeServer(server);
    }

    private void validateServerClientRegionEntries(VM server, VM client, final String regionName) {
        server.invoke(new CacheSerializableRunnable("Server Region Entries"){

            @Override
            public void run2() throws CacheException {
                Region region = CqQueryDUnitTest.this.getRootRegion().getSubregion(regionName);
                DistributedTestCase.getLogWriter().info("### Entries in Server :" + region.keys().size());
            }
        });
        client.invoke(new CacheSerializableRunnable("Client Region Entries"){

            @Override
            public void run2() throws CacheException {
                Region region = CqQueryDUnitTest.this.getRootRegion().getSubregion(regionName);
                DistributedTestCase.getLogWriter().info("### Entries in Client :" + region.keys().size());
            }
        });
    }

    public void restartBridgeServer(VM server, int port) {
        server.invoke(new CacheSerializableRunnable("Start bridge server"){

            @Override
            public void run2() {
                try {
                    CqQueryDUnitTest.this.restartBridgeServers(CqQueryDUnitTest.this.getCache());
                }
                catch (IOException e) {
                    throw new CacheException(e){};
                }
            }
        });
    }

    public void startBridgeServer(int port) throws IOException {
        this.startBridgeServer(port, true);
    }

    public void startBridgeServer(int port, boolean notifyBySubscription) throws IOException {
        Cache cache = this.getCache();
        BridgeServer bridge = cache.addBridgeServer();
        bridge.setPort(port);
        bridge.setNotifyBySubscription(notifyBySubscription);
        bridge.start();
        bridgeServerPort = bridge.getPort();
    }

    protected void stopBridgeServer(Cache cache) {
        BridgeServer bridge = (BridgeServer)cache.getBridgeServers().iterator().next();
        bridge.stop();
        CqQueryDUnitTest.assertFalse((boolean)bridge.isRunning());
    }

    private void stopBridgeServers(Cache cache) {
        BridgeServer bridge2 = null;
        for (BridgeServer bridge2 : cache.getBridgeServers()) {
            bridge2.stop();
            CqQueryDUnitTest.assertFalse((boolean)bridge2.isRunning());
        }
    }

    private void restartBridgeServers(Cache cache) throws IOException {
        BridgeServer bridge2 = null;
        for (BridgeServer bridge2 : cache.getBridgeServers()) {
            bridge2.start();
            CqQueryDUnitTest.assertTrue((boolean)bridge2.isRunning());
        }
    }

    private InternalDistributedSystem createLonerDS() {
        CqQueryDUnitTest.disconnectFromDS();
        Properties lonerProps = new Properties();
        lonerProps.setProperty("mcast-port", "0");
        lonerProps.setProperty("locators", "");
        InternalDistributedSystem ds = this.getSystem(lonerProps);
        CqQueryDUnitTest.assertEquals((int)0, (int)ds.getDistributionManager().getOtherDistributionManagerIds().size());
        return ds;
    }

    protected RegionAttributes getRegionAttributes() {
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.LOCAL);
        return factory.createRegionAttributes();
    }

    static {
        port = 0;
        port2 = 0;
        noTest = -1;
        MAX_TIME = Integer.getInteger(WAIT_PROPERTY, 20000).intValue();
    }
}

