/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.query.cq.dunit;

import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.cache.Operation;
import com.gemstone.gemfire.cache.client.Pool;
import com.gemstone.gemfire.cache.query.CqEvent;
import com.gemstone.gemfire.cache.query.CqStatusListener;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.concurrent.CFactory;
import com.gemstone.gemfire.internal.concurrent.CLQ;
import dunit.DistributedTestCase;
import hydra.PoolHelper;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import security.PerUserRequestSecurityTest;
import security.SecurityClientBB;

public class CqQueryTestListener
implements CqStatusListener {
    protected final LogWriter logger;
    protected volatile int eventCreateCount = 0;
    protected volatile int eventUpdateCount = 0;
    protected volatile int eventDeleteCount = 0;
    protected volatile int eventInvalidateCount = 0;
    protected volatile int eventErrorCount = 0;
    protected volatile int totalEventCount = 0;
    protected volatile int eventQueryInsertCount = 0;
    protected volatile int eventQueryUpdateCount = 0;
    protected volatile int eventQueryDeleteCount = 0;
    protected volatile int eventQueryInvalidateCount = 0;
    protected volatile int cqsConnectedCount = 0;
    protected volatile int cqsDisconnectedCount = 0;
    protected volatile boolean eventClose = false;
    protected volatile boolean eventRegionClear = false;
    protected volatile boolean eventRegionInvalidate = false;
    public final Set destroys = Collections.synchronizedSet(new HashSet());
    public final Set creates = Collections.synchronizedSet(new HashSet());
    public final Set invalidates = Collections.synchronizedSet(new HashSet());
    public final Set updates = Collections.synchronizedSet(new HashSet());
    public final Set errors = Collections.synchronizedSet(new HashSet());
    private static final String WAIT_PROPERTY = "CqQueryTestListener.maxWaitTime";
    private static final int WAIT_DEFAULT = 20000;
    public static final long MAX_TIME = Integer.getInteger("CqQueryTestListener.maxWaitTime", 20000).intValue();
    public String cqName;
    public String userName;
    public static boolean usedForUnitTests = true;
    public CLQ events = CFactory.createCLQ();
    public CLQ cqEvents = CFactory.createCLQ();

    public CqQueryTestListener(LogWriter logger) {
        this.logger = logger;
    }

    public void onEvent(CqEvent cqEvent) {
        ++this.totalEventCount;
        Operation baseOperation = cqEvent.getBaseOperation();
        Operation queryOperation = cqEvent.getQueryOperation();
        Object key = cqEvent.getKey();
        if (key != null) {
            this.events.add(key);
            this.cqEvents.add((Object)cqEvent);
        }
        if (baseOperation.isUpdate()) {
            ++this.eventUpdateCount;
            this.updates.add(key);
        } else if (baseOperation.isCreate()) {
            ++this.eventCreateCount;
            this.creates.add(key);
        } else if (baseOperation.isDestroy()) {
            ++this.eventDeleteCount;
            this.destroys.add(key);
        } else if (baseOperation.isInvalidate()) {
            ++this.eventDeleteCount;
            this.invalidates.add(key);
        }
        if (queryOperation.isUpdate()) {
            ++this.eventQueryUpdateCount;
        } else if (queryOperation.isCreate()) {
            ++this.eventQueryInsertCount;
        } else if (queryOperation.isDestroy()) {
            ++this.eventQueryDeleteCount;
        } else if (queryOperation.isInvalidate()) {
            ++this.eventQueryInvalidateCount;
        } else if (queryOperation.isClear()) {
            this.eventRegionClear = true;
        } else if (queryOperation.isRegionInvalidate()) {
            this.eventRegionInvalidate = true;
        }
        Pool pool = PoolHelper.getPool("brloader");
        if (!usedForUnitTests && PerUserRequestSecurityTest.writeToBB.booleanValue() && cqEvent.getCq().isDurable() && pool.getMultiuserAuthentication()) {
            Long latestValue = (Long)cqEvent.getNewValue();
            boolean isDuplicate = false;
            if (latestValue != 0L) {
                isDuplicate = this.validateIncrementByOne((String)key, latestValue, baseOperation);
            }
            if (!isDuplicate) {
                String VmDurableId = InternalDistributedSystem.getAnyInstance().getConfig().getDurableClientId();
                HashMap userMap = (HashMap)SecurityClientBB.getBB().getSharedMap().get(VmDurableId);
                HashMap[] mapArray = (HashMap[])userMap.get(this.userName);
                HashMap opEventCntMap = mapArray[0];
                Long totalCnt = (Long)opEventCntMap.get("TotalEventCount");
                if (totalCnt == null) {
                    opEventCntMap.put("TotalEventCount", 1L);
                } else {
                    opEventCntMap.put("TotalEventCount", totalCnt + 1L);
                }
                Long opCnt = (Long)opEventCntMap.get(cqEvent.getQueryOperation().toString());
                if (opCnt == null) {
                    opEventCntMap.put(cqEvent.getQueryOperation().toString(), 1L);
                } else {
                    opEventCntMap.put(cqEvent.getQueryOperation().toString(), opCnt + 1L);
                }
                mapArray[0] = opEventCntMap;
                mapArray[1].put((String)key, latestValue);
                userMap.put(this.userName, mapArray);
                SecurityClientBB.getBB().getSharedMap().put(VmDurableId, userMap);
            } else {
                this.logger.info("Event is duplicate");
            }
        }
    }

    public void onError(CqEvent cqEvent) {
        ++this.eventErrorCount;
        this.errors.add(cqEvent.getThrowable().getMessage());
    }

    public void onCqDisconnected() {
        ++this.cqsDisconnectedCount;
    }

    public void onCqConnected() {
        ++this.cqsConnectedCount;
    }

    public int getErrorEventCount() {
        return this.eventErrorCount;
    }

    public int getTotalEventCount() {
        return this.totalEventCount;
    }

    public int getCreateEventCount() {
        return this.eventCreateCount;
    }

    public int getUpdateEventCount() {
        return this.eventUpdateCount;
    }

    public int getDeleteEventCount() {
        return this.eventDeleteCount;
    }

    public int getInvalidateEventCount() {
        return this.eventInvalidateCount;
    }

    public int getQueryInsertEventCount() {
        return this.eventQueryInsertCount;
    }

    public int getQueryUpdateEventCount() {
        return this.eventQueryUpdateCount;
    }

    public int getQueryDeleteEventCount() {
        return this.eventQueryDeleteCount;
    }

    public int getQueryInvalidateEventCount() {
        return this.eventQueryInvalidateCount;
    }

    public Object[] getEvents() {
        return this.cqEvents.toArray();
    }

    public void close() {
        this.eventClose = true;
    }

    public void printInfo(boolean printKeys) {
        this.logger.info("####" + this.cqName + ": " + " Events Total :" + this.getTotalEventCount() + " Events Created :" + this.eventCreateCount + " Events Updated :" + this.eventUpdateCount + " Events Deleted :" + this.eventDeleteCount + " Events Invalidated :" + this.eventInvalidateCount + " Query Inserts :" + this.eventQueryInsertCount + " Query Updates :" + this.eventQueryUpdateCount + " Query Deletes :" + this.eventQueryDeleteCount + " Query Invalidates :" + this.eventQueryInvalidateCount + " Total Events :" + this.totalEventCount);
        if (printKeys) {
            this.logger.fine("Number of Insert for key : " + this.creates.size() + " and updates : " + this.updates.size() + " and number of destroys : " + this.destroys.size() + " and number of invalidates : " + this.invalidates.size());
            this.logger.fine("Keys in created sets : " + this.creates.toString());
            this.logger.fine("Key in updates sets : " + this.updates.toString());
            this.logger.fine("Key in destorys sets : " + this.destroys.toString());
            this.logger.fine("Key in invalidates sets : " + this.invalidates.toString());
        }
    }

    public boolean waitForCreated(final Object key) {
        DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                return CqQueryTestListener.this.creates.contains(key);
            }

            @Override
            public String description() {
                return "never got create event for CQ " + CqQueryTestListener.this.cqName + " key " + key;
            }
        };
        DistributedTestCase.waitForCriterion(ev, MAX_TIME, 200L, true);
        return true;
    }

    public boolean waitForTotalEvents(final int total) {
        DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                return CqQueryTestListener.this.totalEventCount == total;
            }

            @Override
            public String description() {
                return "Did not receive expected number of events " + CqQueryTestListener.this.cqName + " expected: " + total + " receieved: " + CqQueryTestListener.this.totalEventCount;
            }
        };
        DistributedTestCase.waitForCriterion(ev, MAX_TIME, 200L, true);
        return true;
    }

    public boolean waitForDestroyed(final Object key) {
        DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                return CqQueryTestListener.this.destroys.contains(key);
            }

            @Override
            public String description() {
                return "never got destroy event for key " + key + " in CQ " + CqQueryTestListener.this.cqName;
            }
        };
        DistributedTestCase.waitForCriterion(ev, MAX_TIME, 200L, true);
        return true;
    }

    public boolean waitForInvalidated(final Object key) {
        DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                return CqQueryTestListener.this.invalidates.contains(key);
            }

            @Override
            public String description() {
                return "never got invalidate event for CQ " + CqQueryTestListener.this.cqName;
            }
        };
        DistributedTestCase.waitForCriterion(ev, MAX_TIME, 200L, true);
        return true;
    }

    public boolean waitForUpdated(final Object key) {
        DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                return CqQueryTestListener.this.updates.contains(key);
            }

            @Override
            public String description() {
                return "never got update event for CQ " + CqQueryTestListener.this.cqName;
            }
        };
        DistributedTestCase.waitForCriterion(ev, MAX_TIME, 200L, true);
        return true;
    }

    public boolean waitForClose() {
        DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                return CqQueryTestListener.this.eventClose;
            }

            @Override
            public String description() {
                return "never got close event for CQ " + CqQueryTestListener.this.cqName;
            }
        };
        DistributedTestCase.waitForCriterion(ev, MAX_TIME, 200L, true);
        return true;
    }

    public boolean waitForRegionClear() {
        DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                return CqQueryTestListener.this.eventRegionClear;
            }

            @Override
            public String description() {
                return "never got region clear event for CQ " + CqQueryTestListener.this.cqName;
            }
        };
        DistributedTestCase.waitForCriterion(ev, MAX_TIME, 200L, true);
        return true;
    }

    public boolean waitForRegionInvalidate() {
        DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                return CqQueryTestListener.this.eventRegionInvalidate;
            }

            @Override
            public String description() {
                return "never got region invalidate event for CQ " + CqQueryTestListener.this.cqName;
            }
        };
        DistributedTestCase.waitForCriterion(ev, MAX_TIME, 200L, true);
        return true;
    }

    public boolean waitForError(final String expectedMessage) {
        DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                for (String errorMessage : CqQueryTestListener.this.errors) {
                    if (errorMessage.equals(expectedMessage)) {
                        return true;
                    }
                    CqQueryTestListener.this.logger.fine("errors that exist:" + errorMessage);
                }
                return false;
            }

            @Override
            public String description() {
                return "never got create error for CQ " + CqQueryTestListener.this.cqName + " messaged " + expectedMessage;
            }
        };
        DistributedTestCase.waitForCriterion(ev, MAX_TIME, 200L, true);
        return true;
    }

    public boolean waitForCqsDisconnectedEvents(final int total) {
        DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                return CqQueryTestListener.this.cqsDisconnectedCount == total;
            }

            @Override
            public String description() {
                return "Did not receive expected number of calls to cqsDisconnected() " + CqQueryTestListener.this.cqName + " expected: " + total + " received: " + CqQueryTestListener.this.cqsDisconnectedCount;
            }
        };
        DistributedTestCase.waitForCriterion(ev, MAX_TIME, 200L, true);
        return true;
    }

    public boolean waitForCqsConnectedEvents(final int total) {
        DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                return CqQueryTestListener.this.cqsConnectedCount == total;
            }

            @Override
            public String description() {
                return "Did not receive expected number of calls to cqsConnected() " + CqQueryTestListener.this.cqName + " expected: " + total + " receieved: " + CqQueryTestListener.this.cqsConnectedCount;
            }
        };
        DistributedTestCase.waitForCriterion(ev, MAX_TIME, 200L, true);
        return true;
    }

    private boolean validateIncrementByOne(String key, Long newValue, Operation baseOperation) {
        boolean isDuplicate = false;
        String VmDurableId = InternalDistributedSystem.getAnyInstance().getConfig().getDurableClientId();
        HashMap userMap = (HashMap)SecurityClientBB.getBB().getSharedMap().get(VmDurableId);
        HashMap[] mapArray = (HashMap[])userMap.get(this.userName);
        HashMap latestValueMap = mapArray[1];
        try {
            if (latestValueMap == null) {
                this.logger.info("latestValueMap is null for " + VmDurableId + " : " + this.userName + " for key " + key);
            } else {
                Long oldValue = (Long)latestValueMap.get(key);
                if (oldValue == null && !baseOperation.isCreate()) {
                    throw new Exception("oldValue in latestValues cannot be null: key = " + key + " & newVal = " + newValue);
                }
                if (oldValue == null) {
                    return false;
                }
                long diff = newValue - oldValue;
                if (diff > 1L) {
                    throw new Exception("Difference expected in newValue and oldValue is 1, but is was " + diff + " for key = " + key + " & newVal = " + newValue + " vm is " + VmDurableId + " : " + this.userName);
                }
                if (diff < 1L) {
                    isDuplicate = true;
                }
            }
        }
        catch (Exception ex) {
            this.logger.error("Error in CQ Listener while checking for duplicate event" + ex.getMessage());
        }
        return isDuplicate;
    }

    public void getEventHistory() {
        this.destroys.clear();
        this.creates.clear();
        this.invalidates.clear();
        this.updates.clear();
        this.eventClose = false;
    }
}

