/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.query.dunit;

import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.query.QueryTestUtils;
import com.gemstone.gemfire.cache.query.data.Portfolio;
import com.gemstone.gemfire.cache.query.internal.index.IndexManager;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import dunit.AsyncInvocation;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableRunnable;
import dunit.VM;
import java.util.Properties;
import junit.framework.TestCase;

public class CompactRangeIndexDUnitTest
extends DistributedTestCase {
    QueryTestUtils utils;
    VM vm0;

    public CompactRangeIndexDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        this.getSystem();
        CompactRangeIndexDUnitTest.invokeInEveryVM(new SerializableRunnable("getSystem"){

            @Override
            public void run() {
                CompactRangeIndexDUnitTest.this.getSystem();
            }
        });
        Host host = Host.getHost(0);
        this.vm0 = host.getVM(0);
        this.utils = new QueryTestUtils();
        CompactRangeIndexDUnitTest.createServer(this.vm0, null, this.utils);
        CompactRangeIndexDUnitTest.createReplicateRegion("exampleRegion", this.vm0, this.utils);
        CompactRangeIndexDUnitTest.createIndex(this.vm0, "type", "\"type\"", "/exampleRegion", this.utils);
    }

    public static void createServer(VM server, final Properties prop, final QueryTestUtils utils) {
        SerializableRunnable createCacheServer = new SerializableRunnable("Create Cache Server"){
            private static final long serialVersionUID = 1L;

            @Override
            public void run() throws CacheException {
                utils.createCache(prop);
            }
        };
        server.invoke(createCacheServer);
    }

    public static void createIndex(VM vm, final String name, final String field, final String region, final QueryTestUtils utils) throws CacheException {
        vm.invoke(new SerializableRunnable("Create Index"){

            @Override
            public void run() throws CacheException {
                utils.createIndex(name, field, region);
            }
        });
    }

    public static void createPartitionRegion(final String name, final Class constraint, VM vm, final QueryTestUtils utils) {
        vm.invoke(new SerializableRunnable("Create Partition region"){
            private static final long serialVersionUID = 1L;

            @Override
            public void run() throws CacheException {
                utils.createPartitionRegion(name, constraint);
            }
        });
    }

    public static void createReplicateRegion(final String name, VM vm, final QueryTestUtils utils) {
        vm.invoke(new SerializableRunnable("Create Replicated region"){
            private static final long serialVersionUID = 1L;

            @Override
            public void run() throws CacheException {
                utils.getLogger().fine("### Create replicated region. ###");
                utils.createReplicateRegion(name);
            }
        });
    }

    public static void closeServer(VM server, final QueryTestUtils utils) {
        server.invoke(new SerializableRunnable("Closing Cache Server"){
            private static final long serialVersionUID = 1L;

            @Override
            public void run() throws CacheException {
                utils.getLogger().fine("### Close Cache Server. ###");
                utils.closeCache();
            }
        });
    }

    public void testIndexInvalidDueToExpressionOnPartitionedRegion() throws Exception {
        Host host = Host.getHost(0);
        CompactRangeIndexDUnitTest.createPartitionRegion("examplePartitionedRegion", Portfolio.class, this.vm0, this.utils);
        this.vm0.invoke(new CacheSerializableRunnable("Putting values"){

            @Override
            public void run2() {
                CompactRangeIndexDUnitTest.this.utils.createValuesStringKeys("examplePartitionedRegion", 100);
            }
        });
        try {
            CompactRangeIndexDUnitTest.createIndex(this.vm0, "partitionedIndex", "\"albs\"", "/examplePartitionedRegion", this.utils);
        }
        catch (Exception e) {
            CompactRangeIndexDUnitTest.assertTrue((boolean)e.getCause().toString().contains("albs"));
        }
    }

    public void testCompactRangeIndexForIndexElemArray() throws Exception {
        this.doPut(200);
        this.doQuery();
        this.doUpdate(10);
        this.doQuery();
        this.doDestroy(200);
        this.doQuery();
        Thread.sleep(5000L);
    }

    public void testCompactRangeIndexForConcurrentHashSet() throws Exception {
        this.doPut(333);
        this.doQuery();
        this.doUpdate(10);
        this.doQuery();
        this.doDestroy(200);
        this.doQuery();
    }

    public void testNoSuchElemException() throws Exception {
        this.setHook();
        this.doPutSync(300);
        this.doDestroy(298);
        this.doQuery();
    }

    public void doPut(final int entries) {
        this.vm0.invokeAsync(new CacheSerializableRunnable("Putting values"){

            @Override
            public void run2() {
                CompactRangeIndexDUnitTest.this.utils.createValuesStringKeys("exampleRegion", entries);
            }
        });
    }

    public void doPutSync(final int entries) {
        this.vm0.invoke(new CacheSerializableRunnable("Putting values"){

            @Override
            public void run2() {
                CompactRangeIndexDUnitTest.this.utils.createValuesStringKeys("exampleRegion", entries);
            }
        });
    }

    public void doUpdate(final int entries) {
        this.vm0.invokeAsync(new CacheSerializableRunnable("Updating values"){

            @Override
            public void run2() {
                CompactRangeIndexDUnitTest.this.utils.createDiffValuesStringKeys("exampleRegion", entries);
            }
        });
    }

    public void doQuery() throws InterruptedException {
        final String[] qarr = new String[]{"1", "519", "181"};
        AsyncInvocation as0 = this.vm0.invokeAsync(new CacheSerializableRunnable("Executing query"){

            @Override
            public void run2() throws CacheException {
                for (int i = 0; i < 50; ++i) {
                    try {
                        CompactRangeIndexDUnitTest.this.utils.executeQueries(qarr);
                        continue;
                    }
                    catch (Exception e) {
                        throw new CacheException(e){};
                    }
                }
            }
        });
        as0.join();
        if (as0.exceptionOccurred()) {
            CompactRangeIndexDUnitTest.fail("Query execution failed.", as0.getException());
        }
    }

    public void doDestroy(final int entries) throws Exception {
        this.vm0.invokeAsync(new CacheSerializableRunnable("Destroying values"){

            @Override
            public void run2() {
                try {
                    Thread.sleep(500L);
                    CompactRangeIndexDUnitTest.this.utils.destroyRegion("exampleRegion", entries);
                }
                catch (Exception e) {
                    TestCase.fail((String)"Destroy failed.");
                }
            }
        });
    }

    @Override
    public void tearDown2() throws Exception {
        Thread.sleep(5000L);
        this.removeHook();
        CompactRangeIndexDUnitTest.closeServer(this.vm0, this.utils);
    }

    public void setHook() {
        this.vm0.invoke(new CacheSerializableRunnable("Setting hook"){

            @Override
            public void run2() {
                IndexManager.testHook = new CompactRangeIndexTestHook();
            }
        });
    }

    public void removeHook() {
        this.vm0.invoke(new CacheSerializableRunnable("Removing hook"){

            @Override
            public void run2() {
                IndexManager.testHook = null;
            }
        });
    }

    private static class CompactRangeIndexTestHook
    implements IndexManager.TestHook {
        private CompactRangeIndexTestHook() {
        }

        public void hook(int spot) throws RuntimeException {
            if (spot == 11) {
                DistributedTestCase.pause(10);
            }
        }
    }
}

