/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.query.dunit;

import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.query.QueryTestUtils;
import com.gemstone.gemfire.cache.query.dunit.CompactRangeIndexDUnitTest;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableRunnable;
import dunit.VM;

public class HashIndexDUnitTest
extends DistributedTestCase {
    QueryTestUtils utils;
    VM vm0;

    public HashIndexDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        this.getSystem();
        HashIndexDUnitTest.invokeInEveryVM(new SerializableRunnable("getSystem"){

            @Override
            public void run() {
                HashIndexDUnitTest.this.getSystem();
            }
        });
        Host host = Host.getHost(0);
        this.vm0 = host.getVM(0);
        this.utils = new QueryTestUtils();
        CompactRangeIndexDUnitTest.createServer(this.vm0, null, this.utils);
        CompactRangeIndexDUnitTest.createReplicateRegion("exampleRegion", this.vm0, this.utils);
        HashIndexDUnitTest.createHashIndex(this.vm0, "ID", "r.ID", "/exampleRegion r", this.utils);
    }

    public static void createHashIndex(VM vm, final String name, final String field, final String region, final QueryTestUtils utils) {
        vm.invoke(new SerializableRunnable("Create Replicated region"){

            @Override
            public void run() throws CacheException {
                utils.createHashIndex(name, field, region);
            }
        });
    }

    public void testHashIndexForIndexElemArray() throws Exception {
        this.doPut(200);
        this.doQuery();
        this.doUpdate(200);
        this.doQuery();
        this.doDestroy(200);
        this.doQuery();
        Thread.sleep(5000L);
    }

    public void testHashIndexForConcurrentHashSet() throws Exception {
        this.doPut(333);
        this.doQuery();
        this.doUpdate(333);
        this.doQuery();
        this.doDestroy(200);
        this.doQuery();
    }

    public void doPut(final int entries) {
        this.vm0.invokeAsync(new CacheSerializableRunnable("Putting values"){

            @Override
            public void run2() {
                HashIndexDUnitTest.this.utils.createValuesStringKeys("exampleRegion", entries);
            }
        });
    }

    public void doUpdate(final int entries) {
        this.vm0.invokeAsync(new CacheSerializableRunnable("Updating values"){

            @Override
            public void run2() {
                HashIndexDUnitTest.this.utils.createDiffValuesStringKeys("exampleRegion", entries);
            }
        });
    }

    public void doQuery() throws Exception {
        final String[] qarr = new String[]{"173", "174", "176", "180"};
        this.vm0.invokeAsync(new CacheSerializableRunnable("Executing query"){

            @Override
            public void run2() throws CacheException {
                try {
                    for (int i = 0; i < 50; ++i) {
                        HashIndexDUnitTest.this.utils.executeQueries(qarr);
                    }
                }
                catch (Exception e) {
                    throw new CacheException(e){};
                }
            }
        });
    }

    public void doDestroy(final int entries) {
        this.vm0.invokeAsync(new CacheSerializableRunnable("Destroying values"){

            @Override
            public void run2() throws CacheException {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                try {
                    HashIndexDUnitTest.this.utils.destroyRegion("exampleRegion", entries);
                }
                catch (Exception e) {
                    throw new CacheException(e){};
                }
            }
        });
    }

    @Override
    public void tearDown2() throws Exception {
        Thread.sleep(5000L);
        CompactRangeIndexDUnitTest.closeServer(this.vm0, this.utils);
    }
}

