/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.query.dunit;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.PartitionAttributes;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionShortcut;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.client.ClientCache;
import com.gemstone.gemfire.cache.client.ClientCacheFactory;
import com.gemstone.gemfire.cache.client.ClientRegionShortcut;
import com.gemstone.gemfire.cache.client.PoolFactory;
import com.gemstone.gemfire.cache.client.PoolManager;
import com.gemstone.gemfire.cache.query.SelectResults;
import com.gemstone.gemfire.cache.query.Struct;
import com.gemstone.gemfire.cache.query.data.PortfolioPdx;
import com.gemstone.gemfire.cache.query.internal.DefaultQuery;
import com.gemstone.gemfire.cache.query.types.CollectionType;
import com.gemstone.gemfire.cache.query.types.ObjectType;
import com.gemstone.gemfire.cache.server.CacheServer;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.internal.AvailablePortHelper;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableCallable;
import dunit.VM;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import junit.framework.TestCase;

public class PdxStringQueryDUnitTest
extends CacheTestCase {
    private static int bridgeServerPort;
    private final String rootRegionName = "root";
    private final String regionName = "PdxTest";
    private final String regName = "/root/PdxTest";
    private final String[] queryString = new String[]{"SELECT pos.secId FROM /root/PdxTest p, p.positions.values pos WHERE pos.secId LIKE '%L'", "SELECT pos.secId FROM /root/PdxTest p, p.positions.values pos where pos.secId = 'IBM'", "SELECT pos.secId, p.status FROM /root/PdxTest p, p.positions.values pos where pos.secId > 'APPL'", "SELECT pos.secId FROM /root/PdxTest p, p.positions.values pos WHERE pos.secId > 'APPL' and pos.secId < 'SUN'", "select pos.secId from /root/PdxTest p, p.positions.values pos where pos.secId  IN SET ('YHOO', 'VMW')", "select pos.secId from /root/PdxTest p, p.positions.values pos where NOT (pos.secId = 'VMW')", "select pos.secId from /root/PdxTest p, p.positions.values pos where NOT (pos.secId IN SET('SUN', 'ORCL')) ", "SELECT distinct pos.secId FROM /root/PdxTest p, p.positions.values pos order by pos.secId", "SELECT distinct pos.secId FROM /root/PdxTest p, p.positions.values pos WHERE p.ID > 1 order by pos.secId limit 5"};
    private final String[] queryString2 = new String[]{"SELECT pos.secIdIndexed FROM /root/PdxTest p, p.positions.values pos WHERE pos.secIdIndexed LIKE '%L'", "SELECT pos.secIdIndexed FROM /root/PdxTest p, p.positions.values pos where pos.secIdIndexed = 'IBM'", "SELECT pos.secIdIndexed, p.status FROM /root/PdxTest p, p.positions.values pos where pos.secIdIndexed > 'APPL'", "SELECT pos.secIdIndexed FROM /root/PdxTest p, p.positions.values pos WHERE pos.secIdIndexed > 'APPL' and pos.secIdIndexed < 'SUN'", "select pos.secIdIndexed from /root/PdxTest p, p.positions.values pos where pos.secIdIndexed  IN SET ('YHOO', 'VMW')", "select pos.secIdIndexed from /root/PdxTest p, p.positions.values pos where NOT (pos.secIdIndexed = 'VMW')", "select pos.secIdIndexed from /root/PdxTest p, p.positions.values pos where NOT (pos.secIdIndexed IN SET('SUN', 'ORCL')) ", "SELECT distinct pos.secIdIndexed FROM /root/PdxTest p, p.positions.values pos order by pos.secIdIndexed", "SELECT distinct pos.secIdIndexed FROM /root/PdxTest p, p.positions.values pos WHERE p.ID > 1 order by pos.secIdIndexed limit 5"};

    public PdxStringQueryDUnitTest(String name) {
        super(name);
    }

    private void compareResultsOrder(SelectResults[][] r, boolean isPr) {
        for (int j = 0; j < r.length; ++j) {
            Object[] r2;
            Object[] r1 = r[j][0].toArray();
            if (r1.length != (r2 = r[j][1].toArray()).length) {
                PdxStringQueryDUnitTest.fail((String)("Size of results not equal: " + r1.length + " vs " + r2.length));
            }
            int i = 0;
            for (int k = 0; i < r1.length && k < r2.length; ++i, ++k) {
                System.out.println("r1: " + r1[i] + " r2: " + r2[k]);
                if (r1[i].equals(r2[k])) continue;
                PdxStringQueryDUnitTest.fail((String)("Order not equal: " + r1[i] + " : " + r2[k] + " isPR: " + isPr));
            }
        }
    }

    private void checkForPdxString(List results, String query) {
        for (Object o : results) {
            if (o instanceof Struct) {
                Object o1 = ((Struct)o).getFieldValues()[0];
                Object o2 = ((Struct)o).getFieldValues()[1];
                if (!(o1 instanceof String)) {
                    PdxStringQueryDUnitTest.fail((String)("Returned instance of " + o1.getClass() + " instead of String for query: " + query));
                }
                if (o2 instanceof String) continue;
                PdxStringQueryDUnitTest.fail((String)("Returned instance of " + o2.getClass() + " instead of String for query: " + query));
                continue;
            }
            if (o instanceof String) continue;
            PdxStringQueryDUnitTest.fail((String)("Returned instance of " + o.getClass() + " instead of String for query: " + query));
        }
    }

    public boolean compareResultsOfWithAndWithoutIndex(SelectResults[][] r) {
        boolean ok = true;
        Set set1 = null;
        Set set2 = null;
        Iterator itert1 = null;
        Iterator itert2 = null;
        block0: for (int j = 0; j < r.length; ++j) {
            CollectionType collType1 = r[j][0].getCollectionType();
            CollectionType collType2 = r[j][1].getCollectionType();
            ObjectType type1 = collType1.getElementType();
            ObjectType type2 = collType2.getElementType();
            if (r[j][0].size() != r[j][1].size()) {
                System.out.println("FAILED4: SelectResults size is different in both the cases. Size1=" + r[j][0].size() + " Size2 = " + r[j][1].size());
                ok = false;
                break;
            }
            System.out.println("Both SelectResults are of Same Size i.e.  Size= " + r[j][1].size());
            set2 = r[j][1].asSet();
            set1 = r[j][0].asSet();
            boolean pass = true;
            for (Object p1 : set1) {
                itert2 = set2.iterator();
                boolean exactMatch = false;
                while (itert2.hasNext()) {
                    Object p2 = itert2.next();
                    if (p1 instanceof Struct) {
                        Object[] values2;
                        Object[] values1 = ((Struct)p1).getFieldValues();
                        if (values1.length != (values2 = ((Struct)p2).getFieldValues()).length) {
                            ok = false;
                            break block0;
                        }
                        boolean elementEqual = true;
                        for (int i = 0; i < values1.length; ++i) {
                            elementEqual = elementEqual && (values1[i] == values2[i] || values1[i].equals(values2[i]));
                        }
                        exactMatch = elementEqual;
                    } else {
                        boolean bl = exactMatch = p2 == p1 || p2.equals(p1);
                    }
                    if (!exactMatch) continue;
                    break;
                }
                if (exactMatch) continue;
                System.out.println("FAILED5: Atleast one element in the pair of SelectResults supposedly identical, is not equal ");
                ok = false;
                break block0;
            }
        }
        return ok;
    }

    public void testPRQueryForDuplicates() throws CacheException {
        String regionName = "exampleRegion";
        Host host = Host.getHost(0);
        final VM vm0 = host.getVM(0);
        final VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        String name = "/exampleRegion";
        final String[] qs = new String[]{"select distinct pkid from /exampleRegion", "select distinct pkid, status from /exampleRegion"};
        final int port1 = (Integer)vm0.invoke(new SerializableCallable("Create Server1"){

            public Object call() throws Exception {
                Region r1 = PdxStringQueryDUnitTest.this.getCache().createRegionFactory(RegionShortcut.PARTITION).create("exampleRegion");
                CacheServer server = PdxStringQueryDUnitTest.this.getCache().addCacheServer();
                int port = AvailablePortHelper.getRandomAvailablePortForDUnitSite();
                server.setPort(port);
                server.start();
                return port;
            }
        });
        final int port2 = (Integer)vm1.invoke(new SerializableCallable("Create Server1"){

            public Object call() throws Exception {
                Region r1 = PdxStringQueryDUnitTest.this.getCache().createRegionFactory(RegionShortcut.PARTITION).create("exampleRegion");
                CacheServer server = PdxStringQueryDUnitTest.this.getCache().addCacheServer();
                int port = AvailablePortHelper.getRandomAvailablePortForDUnitSite();
                server.setPort(port);
                server.start();
                return port;
            }
        });
        vm2.invoke(new SerializableCallable("Create client"){

            public Object call() throws Exception {
                ClientCacheFactory cf = new ClientCacheFactory();
                cf.addPoolServer(DistributedTestCase.getServerHostName(vm0.getHost()), port1);
                cf.addPoolServer(DistributedTestCase.getServerHostName(vm1.getHost()), port2);
                ClientCache cache = PdxStringQueryDUnitTest.this.getClientCache(cf);
                Region region = cache.createClientRegionFactory(ClientRegionShortcut.PROXY).create("exampleRegion");
                for (int set = 1; set <= 2; ++set) {
                    for (int current = 1; current <= 5; ++current) {
                        region.put((Object)("key-" + set + "_" + current), (Object)new PortfolioPdx(set, current));
                    }
                }
                for (int i = 0; i < qs.length; ++i) {
                    SelectResults sr = (SelectResults)cache.getQueryService().newQuery(qs[i]).execute();
                    TestCase.assertEquals((String)("Did not get expected result from query: " + qs[i] + " "), (int)2, (int)sr.size());
                }
                return null;
            }
        });
        vm0.invoke(new SerializableCallable("Create server"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object call() throws Exception {
                DefaultQuery.setPdxReadSerialized((boolean)true);
                try {
                    for (int i = 0; i < qs.length; ++i) {
                        SelectResults sr = (SelectResults)PdxStringQueryDUnitTest.this.getCache().getQueryService().newQuery(qs[i]).execute();
                        TestCase.assertEquals((String)("Did not get expected result from query: " + qs[i] + " "), (int)2, (int)sr.size());
                    }
                }
                finally {
                    DefaultQuery.setPdxReadSerialized((boolean)false);
                }
                return null;
            }
        });
        PdxStringQueryDUnitTest.invokeInEveryVM(DistributedTestCase.class, "disconnectFromDS");
    }

    protected void configAndStartBridgeServer(boolean isPr, boolean isAccessor, boolean asyncIndex) {
        AttributesFactory factory = new AttributesFactory();
        if (isPr) {
            PartitionAttributesFactory paf = new PartitionAttributesFactory();
            if (isAccessor) {
                paf.setLocalMaxMemory(0);
            }
            PartitionAttributes prAttr = paf.setTotalNumBuckets(20).setRedundantCopies(0).create();
            factory.setPartitionAttributes(prAttr);
        } else {
            factory.setScope(Scope.DISTRIBUTED_ACK);
            factory.setDataPolicy(DataPolicy.REPLICATE);
        }
        if (asyncIndex) {
            factory.setIndexMaintenanceSynchronous(!asyncIndex);
        }
        this.createRegion(this.regionName, this.rootRegionName, factory.create());
        try {
            this.startBridgeServer(0, false);
        }
        catch (Exception ex) {
            PdxStringQueryDUnitTest.fail("While starting CacheServer", ex);
        }
    }

    protected void startBridgeServer(int port, boolean notifyBySubscription) throws IOException {
        Cache cache = this.getCache();
        CacheServer server = cache.addCacheServer();
        server.setPort(port);
        server.start();
        bridgeServerPort = server.getPort();
    }

    protected void stopBridgeServer(Cache cache) {
        CacheServer server = (CacheServer)cache.getCacheServers().iterator().next();
        server.stop();
        PdxStringQueryDUnitTest.assertFalse((boolean)server.isRunning());
    }

    public void closeClient(VM client) {
        CacheSerializableRunnable closeCache = new CacheSerializableRunnable("Close Client"){

            @Override
            public void run2() throws CacheException {
                DistributedTestCase.getLogWriter().info("### Close Client. ###");
                try {
                    CacheTestCase.closeCache();
                    CacheTestCase.disconnectFromDS();
                }
                catch (Exception ex) {
                    DistributedTestCase.getLogWriter().info("### Failed to get close client. ###");
                }
            }
        };
        client.invoke(closeCache);
    }

    public void createPool(VM vm, String poolName, String server, int port, boolean subscriptionEnabled) {
        this.createPool(vm, poolName, new String[]{server}, new int[]{port}, subscriptionEnabled);
    }

    public void createPool(VM vm, String poolName, String server, int port) {
        this.createPool(vm, poolName, new String[]{server}, new int[]{port}, false);
    }

    public void createPool(VM vm, String poolName, String[] servers, int[] ports, boolean subscriptionEnabled) {
        this.createPool(vm, poolName, servers, ports, subscriptionEnabled, 0);
    }

    public void createPool(VM vm, final String poolName, final String[] servers, final int[] ports, final boolean subscriptionEnabled, final int redundancy) {
        vm.invoke(new CacheSerializableRunnable("createPool :" + poolName){

            @Override
            public void run2() throws CacheException {
                Properties props = new Properties();
                props.setProperty("mcast-port", "0");
                props.setProperty("locators", "");
                PdxStringQueryDUnitTest.this.getSystem(props);
                PdxStringQueryDUnitTest.this.getCache();
                PoolFactory cpf = PoolManager.createFactory();
                cpf.setSubscriptionEnabled(subscriptionEnabled);
                cpf.setSubscriptionRedundancy(redundancy);
                for (int i = 0; i < servers.length; ++i) {
                    DistributedTestCase.getLogWriter().info("### Adding to Pool. ### Server : " + servers[i] + " Port : " + ports[i]);
                    cpf.addServer(servers[i], ports[i]);
                }
                cpf.create(poolName);
            }
        });
    }

    private static int getCacheServerPort() {
        return bridgeServerPort;
    }
}

