/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.query.dunit;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.EvictionAction;
import com.gemstone.gemfire.cache.EvictionAttributes;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.query.Index;
import com.gemstone.gemfire.cache.query.IndexExistsException;
import com.gemstone.gemfire.cache.query.IndexNameConflictException;
import com.gemstone.gemfire.cache.query.IndexType;
import com.gemstone.gemfire.cache.query.Query;
import com.gemstone.gemfire.cache.query.QueryException;
import com.gemstone.gemfire.cache.query.QueryService;
import com.gemstone.gemfire.cache.query.SelectResults;
import com.gemstone.gemfire.cache.query.data.Portfolio;
import com.gemstone.gemfire.cache.query.functional.StructSetOrResultsSet;
import com.gemstone.gemfire.cache.query.internal.QueryObserver;
import com.gemstone.gemfire.cache.query.internal.QueryObserverAdapter;
import com.gemstone.gemfire.cache.query.internal.QueryObserverHolder;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import dunit.AsyncInvocation;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.VM;
import hydra.Log;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import junit.framework.TestCase;
import util.CacheUtil;

public class QueryIndexDUnitTest
extends DistributedTestCase {
    public QueryIndexDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() {
        int hostCount = Host.getHostCount();
        Log.getLogWriter().info("Number of hosts = " + hostCount);
        for (int i = 0; i < hostCount; ++i) {
            Host host = Host.getHost(i);
            int vmCount = host.getVMCount();
            Log.getLogWriter().info("Host number :" + i + "contains " + vmCount + "Vms");
            for (int j = 0; j < vmCount; ++j) {
                VM vm = host.getVM(j);
                vm.invoke(QueryIndexDUnitTest.class, "createRegion");
            }
        }
    }

    @Override
    public void tearDown2() {
        int hostCount = Host.getHostCount();
        Log.getLogWriter().info("Number of hosts = " + hostCount);
        for (int i = 0; i < hostCount; ++i) {
            Host host = Host.getHost(i);
            int vmCount = host.getVMCount();
            Log.getLogWriter().info("Host number :" + i + "contains " + vmCount + "Vms");
            for (int j = 0; j < vmCount; ++j) {
                VM vm = host.getVM(j);
                vm.invoke(QueryIndexDUnitTest.class, "destroyRegion");
                vm.invoke(QueryIndexDUnitTest.class, "closeCache");
            }
        }
    }

    public void testIndexCreationAndUpdates() throws InterruptedException {
        Object[] intArr = new Object[2];
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        AsyncInvocation ai1 = null;
        AsyncInvocation ai2 = null;
        vm0.invoke(QueryIndexDUnitTest.class, "createIndex");
        vm0.invoke(QueryIndexDUnitTest.class, "validateIndexUsage");
        VM vm3 = host.getVM(3);
        vm0.invoke(QueryIndexDUnitTest.class, "removeIndex");
        ai1 = vm3.invokeAsync(QueryIndexDUnitTest.class, "doPut");
        ai2 = vm0.invokeAsync(QueryIndexDUnitTest.class, "createIndex");
        DistributedTestCase.join(ai1, 30000L, QueryIndexDUnitTest.getLogWriter());
        DistributedTestCase.join(ai2, 30000L, QueryIndexDUnitTest.getLogWriter());
        intArr[0] = new Integer(3);
        intArr[1] = new Integer(2);
        vm0.invoke(QueryIndexDUnitTest.class, "validateIndexUpdate", intArr);
        vm0.invoke(QueryIndexDUnitTest.class, "removeIndex");
        ai1 = vm0.invokeAsync(QueryIndexDUnitTest.class, "doDestroy");
        ai2 = vm0.invokeAsync(QueryIndexDUnitTest.class, "createIndex");
        DistributedTestCase.join(ai1, 30000L, QueryIndexDUnitTest.getLogWriter());
        DistributedTestCase.join(ai2, 30000L, QueryIndexDUnitTest.getLogWriter());
        intArr[0] = new Integer(1);
        intArr[1] = new Integer(1);
        vm0.invoke(QueryIndexDUnitTest.class, "validateIndexUpdate", intArr);
        vm0.invoke(QueryIndexDUnitTest.class, "removeIndex");
        ai1 = vm0.invokeAsync(QueryIndexDUnitTest.class, "doPut");
        ai2 = vm0.invokeAsync(QueryIndexDUnitTest.class, "createIndex");
        DistributedTestCase.join(ai1, 30000L, QueryIndexDUnitTest.getLogWriter());
        DistributedTestCase.join(ai2, 30000L, QueryIndexDUnitTest.getLogWriter());
        intArr[0] = new Integer(3);
        intArr[1] = new Integer(2);
        vm0.invoke(QueryIndexDUnitTest.class, "validateIndexUpdate", intArr);
        vm0.invoke(QueryIndexDUnitTest.class, "removeIndex");
        ai1 = vm3.invokeAsync(QueryIndexDUnitTest.class, "doDestroy");
        ai2 = vm0.invokeAsync(QueryIndexDUnitTest.class, "createIndex");
        DistributedTestCase.join(ai1, 30000L, QueryIndexDUnitTest.getLogWriter());
        DistributedTestCase.join(ai2, 30000L, QueryIndexDUnitTest.getLogWriter());
        intArr[0] = new Integer(1);
        intArr[1] = new Integer(1);
        vm0.invoke(QueryIndexDUnitTest.class, "validateIndexUpdate", intArr);
        vm0.invoke(QueryIndexDUnitTest.class, "removeIndex");
        ai1 = vm0.invokeAsync(QueryIndexDUnitTest.class, "doPut");
        ai2 = vm0.invokeAsync(QueryIndexDUnitTest.class, "createIndex");
        DistributedTestCase.join(ai1, 30000L, QueryIndexDUnitTest.getLogWriter());
        DistributedTestCase.join(ai2, 30000L, QueryIndexDUnitTest.getLogWriter());
        intArr[0] = new Integer(3);
        intArr[1] = new Integer(2);
        vm0.invoke(QueryIndexDUnitTest.class, "validateIndexUpdate", intArr);
        try {
            Thread.sleep(2000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Object[] str = new String[]{"To get Update in synch thread."};
        vm0.invoke(QueryIndexDUnitTest.class, "doInPlaceUpdate", str);
        intArr[0] = new Integer(5);
        intArr[1] = new Integer(0);
        vm0.invoke(QueryIndexDUnitTest.class, "validateIndexUpdate", intArr);
    }

    public void testIndexCreationonOverflowRegions() throws InterruptedException {
        int i;
        Host host = Host.getHost(0);
        VM[] vms = new VM[]{host.getVM(0), host.getVM(1), host.getVM(2), host.getVM(3)};
        QueryIndexDUnitTest.pause(1000);
        for (i = 0; i < vms.length; ++i) {
            vms[i].invoke(QueryIndexDUnitTest.class, "createAndLoadOverFlowRegions", new Object[]{"testOfvm" + i, new Boolean(true), new Boolean(true)});
        }
        QueryIndexDUnitTest.pause(1000);
        for (i = 0; i < vms.length; ++i) {
            vms[i].invoke(QueryIndexDUnitTest.class, "createIndexOnOverFlowRegions");
        }
        for (i = 0; i < vms.length; ++i) {
            vms[i].invoke(QueryIndexDUnitTest.class, "executeQueriesUsingIndexOnOverflowRegions");
        }
        for (i = 0; i < vms.length; ++i) {
            vms[i].invoke(QueryIndexDUnitTest.class, "createAndLoadOverFlowRegions", new Object[]{"testOfvm" + i, new Boolean(false), new Boolean(true)});
        }
        for (i = 0; i < vms.length; ++i) {
            vms[i].invoke(QueryIndexDUnitTest.class, "executeQueriesUsingIndexOnOverflowRegions");
        }
    }

    public void testIndexCreationonOverflowRegionsValidateResults() throws Exception {
        Host host = Host.getHost(0);
        VM[] vms = new VM[]{host.getVM(0), host.getVM(1)};
        QueryIndexDUnitTest.pause(1000);
        for (int i = 0; i < vms.length; ++i) {
            vms[i].invoke(QueryIndexDUnitTest.class, "createAndLoadOverFlowRegions", new Object[]{"testOfValidvm" + i, new Boolean(true), new Boolean(false)});
        }
        QueryIndexDUnitTest.pause(1000);
        vms[0].invoke(new CacheSerializableRunnable("Execute query validate results"){

            @Override
            public void run2() throws CacheException {
                int i;
                String queryStr2;
                Cache cache = null;
                String[] regionNames = new String[]{"replicateOverFlowRegion", "replicatePersistentOverFlowRegion", "prOverFlowRegion", "prPersistentOverFlowRegion"};
                try {
                    cache = CacheUtil.getCache();
                    if (cache == null) {
                        QueryIndexDUnitTest qidt = new QueryIndexDUnitTest("temp");
                        cache = qidt.createCache();
                    }
                }
                catch (Exception ex) {
                    TestCase.fail((String)"Failed to create cache");
                }
                QueryService qs = cache.getQueryService();
                Region region = null;
                int numObjects = 10;
                for (int i2 = 0; i2 < regionNames.length; ++i2) {
                    region = cache.getRegion(regionNames[i2]);
                    for (int cnt = 1; cnt < numObjects; ++cnt) {
                        region.put((Object)new Portfolio(cnt), (Object)new Portfolio(cnt));
                    }
                }
                String[] qString = new String[]{"SELECT * FROM /REGION_NAME pf WHERE pf.ID = 1", "SELECT ID FROM /REGION_NAME pf WHERE pf.ID = 1", "SELECT * FROM /REGION_NAME pf WHERE pf.ID > 5", "SELECT ID FROM /REGION_NAME pf WHERE pf.ID > 5", "SELECT * FROM /REGION_NAME.keys key WHERE key.ID = 1", "SELECT ID FROM /REGION_NAME.keys key WHERE key.ID = 1", "SELECT * FROM /REGION_NAME.keys key WHERE key.ID > 5", "SELECT ID FROM /REGION_NAME.keys key WHERE key.ID > 5"};
                SelectResults[] srWithoutIndex = new SelectResults[qString.length * regionNames.length];
                String[] queryString = new String[qString.length * regionNames.length];
                int r = 0;
                try {
                    for (int q = 0; q < qString.length; ++q) {
                        for (int i3 = 0; i3 < regionNames.length; ++i3) {
                            queryStr2 = qString[q].replace("REGION_NAME", regionNames[i3]);
                            Query query = qs.newQuery(queryStr2);
                            queryString[r] = queryStr2;
                            srWithoutIndex[r] = (SelectResults)query.execute();
                            ++r;
                        }
                    }
                }
                catch (Exception ex) {
                    Log.getLogWriter().info("Failed to Execute query", (Throwable)ex);
                    TestCase.fail((String)"Failed to Execute query.");
                }
                try {
                    for (int i4 = 0; i4 < regionNames.length; ++i4) {
                        region = cache.getRegion(regionNames[i4]);
                        String indexName = "idIndex" + regionNames[i4];
                        cache.getLogger().fine("createIndexOnOverFlowRegions() checking for index: " + indexName);
                        try {
                            if (qs.getIndex(region, indexName) == null) {
                                cache.getLogger().fine("createIndexOnOverFlowRegions() Index doesn't exist, creating index: " + indexName);
                                queryStr2 = qs.createIndex(indexName, IndexType.FUNCTIONAL, "pf.ID", "/" + regionNames[i4] + " pf");
                            }
                            if (qs.getIndex(region, indexName = "keyIdIndex" + regionNames[i4]) != null) continue;
                            cache.getLogger().fine("createIndexOnOverFlowRegions() Index doesn't exist, creating index: " + indexName);
                            queryStr2 = qs.createIndex(indexName, IndexType.FUNCTIONAL, "key.ID", "/" + regionNames[i4] + ".keys key");
                            continue;
                        }
                        catch (IndexNameConflictException queryStr2) {
                            // empty catch block
                        }
                    }
                }
                catch (Exception ex) {
                    Log.getLogWriter().info("Failed to create index", (Throwable)ex);
                    TestCase.fail((String)"Failed to create index.");
                }
                SelectResults[] srWithIndex = new SelectResults[qString.length * regionNames.length];
                try {
                    r = 0;
                    for (int q = 0; q < qString.length; ++q) {
                        for (int i5 = 0; i5 < regionNames.length; ++i5) {
                            QueryObserverImpl observer = new QueryObserverImpl();
                            QueryObserverHolder.setInstance((QueryObserver)observer);
                            String queryStr3 = qString[q].replace("REGION_NAME", regionNames[i5]);
                            Query query = qs.newQuery(queryStr3);
                            srWithIndex[r++] = (SelectResults)query.execute();
                            if (observer.isIndexesUsed) continue;
                            TestCase.fail((String)("Index not used for query. " + queryStr3));
                        }
                    }
                }
                catch (Exception ex) {
                    Log.getLogWriter().info("Failed to Execute query", (Throwable)ex);
                    TestCase.fail((String)"Failed to Execute query.");
                }
                StructSetOrResultsSet ssORrs = new StructSetOrResultsSet();
                Object[][] sr = new SelectResults[1][2];
                for (i = 0; i < srWithIndex.length; ++i) {
                    sr[0][0] = srWithoutIndex[i];
                    sr[0][1] = srWithIndex[i];
                    Log.getLogWriter().info("Comparing the result for the query : " + queryString[i] + " Index in ResultSet is: " + i);
                    ssORrs.CompareQueryResultsWithoutAndWithIndexes(sr, 1, queryString);
                }
                for (i = 0; i < regionNames.length; ++i) {
                    int cnt;
                    region = cache.getRegion(regionNames[i]);
                    for (cnt = 1; cnt < numObjects; ++cnt) {
                        if (cnt % 2 != 0) continue;
                        region.destroy((Object)new Portfolio(cnt));
                    }
                    for (cnt = 10; cnt < numObjects; ++cnt) {
                        if (cnt % 2 != 0) continue;
                        region.put((Object)new Portfolio(cnt), (Object)new Portfolio(cnt));
                    }
                }
                srWithIndex = new SelectResults[qString.length * regionNames.length];
                try {
                    r = 0;
                    for (int q = 0; q < qString.length; ++q) {
                        for (int i6 = 0; i6 < regionNames.length; ++i6) {
                            QueryObserverImpl observer = new QueryObserverImpl();
                            QueryObserverHolder.setInstance((QueryObserver)observer);
                            String queryStr4 = qString[q].replace("REGION_NAME", regionNames[i6]);
                            Query query = qs.newQuery(queryStr4);
                            srWithIndex[r++] = (SelectResults)query.execute();
                            if (observer.isIndexesUsed) continue;
                            TestCase.fail((String)("Index not used for query. " + queryStr4));
                        }
                    }
                }
                catch (Exception ex) {
                    Log.getLogWriter().info("Failed to Execute query", (Throwable)ex);
                    TestCase.fail((String)"Failed to Execute query.");
                }
            }
        });
    }

    public void testIndexCreationonOverflowRegionsValidateResults2() throws Exception {
        Host host = Host.getHost(0);
        VM[] vms = new VM[]{host.getVM(0), host.getVM(1)};
        QueryIndexDUnitTest.pause(1000);
        for (int i = 0; i < vms.length; ++i) {
            vms[i].invoke(QueryIndexDUnitTest.class, "createAndLoadOverFlowRegions", new Object[]{"testOfValid2vm" + i, new Boolean(true), new Boolean(false)});
        }
        QueryIndexDUnitTest.pause(1000);
        vms[0].invoke(new CacheSerializableRunnable("Execute query validate results"){

            @Override
            public void run2() throws CacheException {
                int i;
                String queryStr2;
                int i2;
                Cache cache = null;
                String[] regionNames = new String[]{"replicateOverFlowRegion", "replicatePersistentOverFlowRegion", "prOverFlowRegion", "prPersistentOverFlowRegion"};
                try {
                    cache = CacheUtil.getCache();
                    if (cache == null) {
                        QueryIndexDUnitTest qidt = new QueryIndexDUnitTest("temp");
                        cache = qidt.createCache();
                    }
                }
                catch (Exception ex) {
                    TestCase.fail((String)"Failed to create cache");
                }
                QueryService qs = cache.getQueryService();
                Region region = null;
                int numObjects = 10;
                for (int i3 = 0; i3 < regionNames.length; ++i3) {
                    region = cache.getRegion(regionNames[i3]);
                    for (int cnt = 1; cnt < numObjects; ++cnt) {
                        region.put((Object)new Portfolio(cnt), (Object)new String("XX" + cnt));
                    }
                }
                String[] qString = new String[]{"SELECT * FROM /REGION_NAME pf WHERE pf = 'XX1'", "SELECT * FROM /REGION_NAME pf WHERE pf IN SET( 'XX5', 'XX6', 'XX7')", "SELECT * FROM /REGION_NAME.values pf WHERE pf IN SET( 'XX5', 'XX6', 'XX7')", "SELECT * FROM /REGION_NAME.keys k WHERE k.ID = 1", "SELECT key.ID FROM /REGION_NAME.keys key WHERE key.ID = 1", "SELECT ID, status FROM /REGION_NAME.keys WHERE ID = 1", "SELECT k.ID, k.status FROM /REGION_NAME.keys k WHERE k.ID = 1 and k.status = 'active'", "SELECT * FROM /REGION_NAME.keys key WHERE key.ID > 5", "SELECT key.ID FROM /REGION_NAME.keys key WHERE key.ID > 5 and key.status = 'active'"};
                SelectResults[] srWithoutIndex = new SelectResults[qString.length * regionNames.length];
                String[] queryString = new String[qString.length * regionNames.length];
                int r = 0;
                try {
                    for (int q = 0; q < qString.length; ++q) {
                        for (i2 = 0; i2 < regionNames.length; ++i2) {
                            queryStr2 = qString[q].replace("REGION_NAME", regionNames[i2]);
                            Query query = qs.newQuery(queryStr2);
                            queryString[r] = queryStr2;
                            srWithoutIndex[r] = (SelectResults)query.execute();
                            ++r;
                        }
                    }
                }
                catch (Exception ex) {
                    Log.getLogWriter().info("Failed to Execute query", (Throwable)ex);
                    TestCase.fail((String)"Failed to Execute query.");
                }
                String indexName = "";
                try {
                    for (i2 = 0; i2 < regionNames.length; ++i2) {
                        region = cache.getRegion(regionNames[i2]);
                        indexName = "idIndex" + regionNames[i2];
                        cache.getLogger().fine("createIndexOnOverFlowRegions() checking for index: " + indexName);
                        try {
                            if (qs.getIndex(region, indexName) == null) {
                                cache.getLogger().fine("createIndexOnOverFlowRegions() Index doesn't exist, creating index: " + indexName);
                                queryStr2 = qs.createIndex(indexName, IndexType.FUNCTIONAL, "pf", "/" + regionNames[i2] + " pf");
                            }
                            if (qs.getIndex(region, indexName = "valueIndex" + regionNames[i2]) == null) {
                                cache.getLogger().fine("createIndexOnOverFlowRegions() Index doesn't exist, creating index: " + indexName);
                                queryStr2 = qs.createIndex(indexName, IndexType.FUNCTIONAL, "pf", "/" + regionNames[i2] + ".values pf");
                            }
                            if (qs.getIndex(region, indexName = "keyIdIndex" + regionNames[i2]) == null) {
                                cache.getLogger().fine("createIndexOnOverFlowRegions() Index doesn't exist, creating index: " + indexName);
                                queryStr2 = qs.createIndex(indexName, IndexType.FUNCTIONAL, "key.ID", "/" + regionNames[i2] + ".keys key");
                            }
                            indexName = "keyIdIndex2" + regionNames[i2];
                            continue;
                        }
                        catch (IndexNameConflictException queryStr2) {
                            // empty catch block
                        }
                    }
                }
                catch (Exception ex) {
                    Log.getLogWriter().info("Failed to create index", (Throwable)ex);
                    TestCase.fail((String)("Failed to create index." + indexName));
                }
                SelectResults[] srWithIndex = new SelectResults[qString.length * regionNames.length];
                try {
                    r = 0;
                    for (int q = 0; q < qString.length; ++q) {
                        for (int i4 = 0; i4 < regionNames.length; ++i4) {
                            QueryObserverImpl observer = new QueryObserverImpl();
                            QueryObserverHolder.setInstance((QueryObserver)observer);
                            String queryStr3 = qString[q].replace("REGION_NAME", regionNames[i4]);
                            Query query = qs.newQuery(queryStr3);
                            srWithIndex[r++] = (SelectResults)query.execute();
                            if (observer.isIndexesUsed) continue;
                            TestCase.fail((String)("Index not used for query. " + queryStr3));
                        }
                    }
                }
                catch (Exception ex) {
                    Log.getLogWriter().info("Failed to Execute query", (Throwable)ex);
                    TestCase.fail((String)"Failed to Execute query.");
                }
                StructSetOrResultsSet ssORrs = new StructSetOrResultsSet();
                Object[][] sr = new SelectResults[1][2];
                for (i = 0; i < srWithIndex.length; ++i) {
                    sr[0][0] = srWithoutIndex[i];
                    sr[0][1] = srWithIndex[i];
                    Log.getLogWriter().info("Comparing the result for the query : " + queryString[i] + " Index in ResultSet is: " + i);
                    ssORrs.CompareQueryResultsWithoutAndWithIndexes(sr, 1, queryString);
                }
                for (i = 0; i < regionNames.length; ++i) {
                    int cnt;
                    region = cache.getRegion(regionNames[i]);
                    for (cnt = 1; cnt < numObjects; ++cnt) {
                        if (cnt % 2 != 0) continue;
                        region.destroy((Object)new Portfolio(cnt));
                    }
                    for (cnt = 10; cnt < numObjects; ++cnt) {
                        if (cnt % 2 != 0) continue;
                        region.put((Object)new Portfolio(cnt), (Object)new String("XX" + cnt));
                    }
                }
                srWithIndex = new SelectResults[qString.length * regionNames.length];
                try {
                    r = 0;
                    for (int q = 0; q < qString.length; ++q) {
                        for (int i5 = 0; i5 < regionNames.length; ++i5) {
                            QueryObserverImpl observer = new QueryObserverImpl();
                            QueryObserverHolder.setInstance((QueryObserver)observer);
                            String queryStr4 = qString[q].replace("REGION_NAME", regionNames[i5]);
                            Query query = qs.newQuery(queryStr4);
                            srWithIndex[r++] = (SelectResults)query.execute();
                            if (observer.isIndexesUsed) continue;
                            TestCase.fail((String)("Index not used for query. " + queryStr4));
                        }
                    }
                }
                catch (Exception ex) {
                    Log.getLogWriter().info("Failed to Execute query", (Throwable)ex);
                    TestCase.fail((String)"Failed to Execute query.");
                }
            }
        });
    }

    public void testIndexCreationonOverflowRegionsValidateResultsUseParams() throws Exception {
        Host host = Host.getHost(0);
        VM[] vms = new VM[]{host.getVM(0), host.getVM(1)};
        QueryIndexDUnitTest.pause(1000);
        for (int i = 0; i < vms.length; ++i) {
            vms[i].invoke(QueryIndexDUnitTest.class, "createAndLoadOverFlowRegions", new Object[]{"testOfValidUseParamsvm" + i, new Boolean(true), new Boolean(false)});
        }
        QueryIndexDUnitTest.pause(1000);
        vms[0].invoke(new CacheSerializableRunnable("Execute query validate results"){

            @Override
            public void run2() throws CacheException {
                int i;
                String queryStr2;
                int i2;
                Cache cache = null;
                String[] regionNames = new String[]{"replicateOverFlowRegion", "replicatePersistentOverFlowRegion", "prOverFlowRegion", "prPersistentOverFlowRegion"};
                try {
                    cache = CacheUtil.getCache();
                    if (cache == null) {
                        QueryIndexDUnitTest qidt = new QueryIndexDUnitTest("temp");
                        cache = qidt.createCache();
                    }
                }
                catch (Exception ex) {
                    TestCase.fail((String)"Failed to create cache");
                }
                QueryService qs = cache.getQueryService();
                Region region = null;
                int numObjects = 10;
                for (int i3 = 0; i3 < regionNames.length; ++i3) {
                    region = cache.getRegion(regionNames[i3]);
                    for (int cnt = 1; cnt < numObjects; ++cnt) {
                        region.put((Object)new Portfolio(cnt), (Object)new Integer(cnt + 100));
                    }
                }
                String[] qString = new String[]{"SELECT * FROM /REGION_NAME pf WHERE pf = $1", "SELECT * FROM /REGION_NAME pf WHERE pf > $1", "SELECT * FROM /REGION_NAME.values pf WHERE pf < $1", "SELECT * FROM /REGION_NAME.keys k WHERE k.ID = $1", "SELECT key.ID FROM /REGION_NAME.keys key WHERE key.ID = $1", "SELECT ID, status FROM /REGION_NAME.keys WHERE ID = $1", "SELECT k.ID, k.status FROM /REGION_NAME.keys k WHERE k.ID = $1 and k.status = $2", "SELECT * FROM /REGION_NAME.keys key WHERE key.ID > $1", "SELECT key.ID FROM /REGION_NAME.keys key WHERE key.ID > $1 and key.status = $2"};
                SelectResults[] srWithoutIndex = new SelectResults[qString.length * regionNames.length];
                String[] queryString = new String[qString.length * regionNames.length];
                int r = 0;
                try {
                    for (int q = 0; q < qString.length; ++q) {
                        for (i2 = 0; i2 < regionNames.length; ++i2) {
                            queryStr2 = qString[q].replace("REGION_NAME", regionNames[i2]);
                            Query query = qs.newQuery(queryStr2);
                            queryString[r] = queryStr2;
                            srWithoutIndex[r] = (SelectResults)query.execute(new Object[]{new Integer(5), "active"});
                            ++r;
                        }
                    }
                }
                catch (Exception ex) {
                    Log.getLogWriter().info("Failed to Execute query", (Throwable)ex);
                    TestCase.fail((String)"Failed to Execute query.");
                }
                String indexName = "";
                try {
                    for (i2 = 0; i2 < regionNames.length; ++i2) {
                        region = cache.getRegion(regionNames[i2]);
                        indexName = "idIndex" + regionNames[i2];
                        cache.getLogger().fine("createIndexOnOverFlowRegions() checking for index: " + indexName);
                        try {
                            if (qs.getIndex(region, indexName) == null) {
                                cache.getLogger().fine("createIndexOnOverFlowRegions() Index doesn't exist, creating index: " + indexName);
                                queryStr2 = qs.createIndex(indexName, IndexType.FUNCTIONAL, "pf", "/" + regionNames[i2] + " pf");
                            }
                            if (qs.getIndex(region, indexName = "valueIndex" + regionNames[i2]) == null) {
                                cache.getLogger().fine("createIndexOnOverFlowRegions() Index doesn't exist, creating index: " + indexName);
                                queryStr2 = qs.createIndex(indexName, IndexType.FUNCTIONAL, "pf", "/" + regionNames[i2] + ".values pf");
                            }
                            if (qs.getIndex(region, indexName = "keyIdIndex" + regionNames[i2]) != null) continue;
                            cache.getLogger().fine("createIndexOnOverFlowRegions() Index doesn't exist, creating index: " + indexName);
                            queryStr2 = qs.createIndex(indexName, IndexType.FUNCTIONAL, "key.ID", "/" + regionNames[i2] + ".keys key");
                            continue;
                        }
                        catch (IndexNameConflictException queryStr2) {
                            // empty catch block
                        }
                    }
                }
                catch (Exception ex) {
                    Log.getLogWriter().info("Failed to create index", (Throwable)ex);
                    TestCase.fail((String)("Failed to create index." + indexName));
                }
                SelectResults[] srWithIndex = new SelectResults[qString.length * regionNames.length];
                try {
                    r = 0;
                    for (int q = 0; q < qString.length; ++q) {
                        for (int i4 = 0; i4 < regionNames.length; ++i4) {
                            QueryObserverImpl observer = new QueryObserverImpl();
                            QueryObserverHolder.setInstance((QueryObserver)observer);
                            String queryStr3 = qString[q].replace("REGION_NAME", regionNames[i4]);
                            Query query = qs.newQuery(queryStr3);
                            srWithIndex[r++] = (SelectResults)query.execute(new Object[]{new Integer(5), "active"});
                            if (observer.isIndexesUsed) continue;
                            TestCase.fail((String)("Index not used for query. " + queryStr3));
                        }
                    }
                }
                catch (Exception ex) {
                    Log.getLogWriter().info("Failed to Execute query", (Throwable)ex);
                    TestCase.fail((String)"Failed to Execute query.");
                }
                StructSetOrResultsSet ssORrs = new StructSetOrResultsSet();
                Object[][] sr = new SelectResults[1][2];
                for (i = 0; i < srWithIndex.length; ++i) {
                    sr[0][0] = srWithoutIndex[i];
                    sr[0][1] = srWithIndex[i];
                    Log.getLogWriter().info("Comparing the result for the query : " + queryString[i] + " Index in ResultSet is: " + i);
                    ssORrs.CompareQueryResultsWithoutAndWithIndexes(sr, 1, queryString);
                }
                for (i = 0; i < regionNames.length; ++i) {
                    int cnt;
                    region = cache.getRegion(regionNames[i]);
                    for (cnt = 1; cnt < numObjects; ++cnt) {
                        if (cnt % 2 != 0) continue;
                        region.destroy((Object)new Portfolio(cnt));
                    }
                    for (cnt = 1; cnt < numObjects; ++cnt) {
                        if (cnt % 2 != 0) continue;
                        region.put((Object)new Portfolio(cnt), (Object)new Integer(cnt + 100));
                    }
                }
                srWithIndex = new SelectResults[qString.length * regionNames.length];
                try {
                    r = 0;
                    for (int q = 0; q < qString.length; ++q) {
                        for (int i5 = 0; i5 < regionNames.length; ++i5) {
                            QueryObserverImpl observer = new QueryObserverImpl();
                            QueryObserverHolder.setInstance((QueryObserver)observer);
                            String queryStr4 = qString[q].replace("REGION_NAME", regionNames[i5]);
                            Query query = qs.newQuery(queryStr4);
                            srWithIndex[r++] = (SelectResults)query.execute(new Object[]{new Integer(5), "active"});
                            if (observer.isIndexesUsed) continue;
                            TestCase.fail((String)("Index not used for query. " + queryStr4));
                        }
                    }
                }
                catch (Exception ex) {
                    Log.getLogWriter().info("Failed to Execute query", (Throwable)ex);
                    TestCase.fail((String)"Failed to Execute query.");
                }
                for (int i6 = 0; i6 < srWithIndex.length; ++i6) {
                    sr[0][0] = srWithoutIndex[i6];
                    sr[0][1] = srWithIndex[i6];
                    Log.getLogWriter().info("Comparing the result for the query : " + queryString[i6] + " Index in ResultSet is: " + i6);
                    ssORrs.CompareQueryResultsWithoutAndWithIndexes(sr, 1, queryString);
                }
            }
        });
    }

    public static void doDestroy() {
        Region region = CacheUtil.getRegion("portfolios");
        if (region == null) {
            Log.getLogWriter().info("REGION IS NULL");
        }
        try {
            region.destroy((Object)"2");
            region.destroy((Object)"3");
            region.destroy((Object)"4");
        }
        catch (Exception e) {
            QueryIndexDUnitTest.fail("Caught exception while trying to do put operation", e);
        }
    }

    public static void validateIndexUpdate(Integer a, Integer b) {
        int actual;
        Object r;
        QueryService qs = CacheUtil.getQueryService();
        Query q = qs.newQuery("SELECT DISTINCT * FROM /portfolios where status = 'active'");
        QueryObserverImpl observer = new QueryObserverImpl();
        QueryObserverHolder.setInstance((QueryObserver)observer);
        try {
            r = q.execute();
            actual = ((Collection)r).size();
            if (actual != a) {
                QueryIndexDUnitTest.fail((String)("Active NOT of the expected size, found " + actual + ", expected " + a));
            }
        }
        catch (Exception e) {
            QueryIndexDUnitTest.fail("Caught exception while trying to query", e);
        }
        if (!observer.isIndexesUsed) {
            QueryIndexDUnitTest.fail((String)"Index not used for query");
        }
        q = qs.newQuery("SELECT DISTINCT * FROM /portfolios where status = 'inactive'");
        observer = new QueryObserverImpl();
        QueryObserverHolder.setInstance((QueryObserver)observer);
        try {
            r = q.execute();
            actual = ((Collection)r).size();
            if (actual != b) {
                QueryIndexDUnitTest.fail((String)("Inactive NOT of the expected size, found " + actual + ", expected " + b));
            }
        }
        catch (Exception e) {
            QueryIndexDUnitTest.fail("Caught exception while trying to query", e);
        }
        if (!observer.isIndexesUsed) {
            QueryIndexDUnitTest.fail((String)"Index not used for query");
        }
    }

    public static void doPut() {
        Region region = CacheUtil.getRegion("portfolios");
        if (region == null) {
            Log.getLogWriter().info("REGION IS NULL");
        }
        try {
            region.put((Object)"1", (Object)new Portfolio(1));
            region.put((Object)"2", (Object)new Portfolio(2));
            region.put((Object)"3", (Object)new Portfolio(3));
            region.put((Object)"4", (Object)new Portfolio(4));
        }
        catch (Exception e) {
            QueryIndexDUnitTest.fail("Caught exception while trying to do put operation", e);
        }
    }

    public static void doInPlaceUpdate(String str) {
        Region region = CacheUtil.getRegion("portfolios");
        Portfolio p = null;
        if (region == null) {
            Log.getLogWriter().info("REGION IS NULL");
        }
        try {
            for (int i = 0; i <= 4; ++i) {
                p = (Portfolio)region.get((Object)("" + i));
                p.status = "active";
                region.put((Object)("" + i), (Object)p);
            }
        }
        catch (Exception e) {
            QueryIndexDUnitTest.fail("Caught exception while trying to do put operation", e);
        }
    }

    public static void validateIndexUsage() {
        QueryService qs = CacheUtil.getQueryService();
        Query q = qs.newQuery("SELECT DISTINCT * FROM /portfolios where status = 'active'");
        QueryObserverImpl observer = new QueryObserverImpl();
        QueryObserverHolder.setInstance((QueryObserver)observer);
        try {
            Object r = q.execute();
            int actual = ((Collection)r).size();
            if (actual != 1) {
                QueryIndexDUnitTest.fail((String)("Active NOT of the expected size, found " + actual + ", expected 1"));
            }
        }
        catch (Exception e) {
            QueryIndexDUnitTest.fail("Caught exception while trying to query", e);
        }
        if (!observer.isIndexesUsed) {
            QueryIndexDUnitTest.fail((String)"Index not used for query");
        }
    }

    public static void createIndex() {
        Region region = CacheUtil.getRegion("portfolios");
        if (region == null) {
            Log.getLogWriter().info("The region is not created properly");
        } else if (!region.isDestroyed()) {
            Log.getLogWriter().info("Obtained the region with name :portfolios");
            QueryService qs = CacheUtil.getQueryService();
            if (qs != null) {
                try {
                    qs.createIndex("statusIndex", IndexType.FUNCTIONAL, "status", "/portfolios");
                    Log.getLogWriter().info("Index statusIndex Created successfully");
                }
                catch (IndexNameConflictException e) {
                    QueryIndexDUnitTest.fail("Caught IndexNameConflictException", e);
                }
                catch (IndexExistsException e) {
                    QueryIndexDUnitTest.fail("Caught IndexExistsException", e);
                }
                catch (QueryException e) {
                    QueryIndexDUnitTest.fail("Caught exception while trying to create index", e);
                }
            } else {
                QueryIndexDUnitTest.fail((String)"Hey !!!!! Could not obtain QueryService for the cache ");
            }
        } else {
            QueryIndexDUnitTest.fail((String)"Hey !!!!! Region.isDestroyed() returned true for region : /portfolios");
        }
    }

    private Cache createCache() throws Exception {
        Cache cache = null;
        InternalDistributedSystem ds = this.getSystem();
        try {
            cache = CacheFactory.create((DistributedSystem)ds);
            if (cache == null) {
                QueryIndexDUnitTest.fail((String)"CacheFactory.create() returned null ");
            }
            CacheUtil.setCache(cache);
        }
        catch (Exception e) {
            String s = "Unable to create cache using: " + ds;
            QueryIndexDUnitTest.fail(s, e);
        }
        return cache;
    }

    public static void createAndLoadOverFlowRegions(String vmName, Boolean createRegions, Boolean loadRegions) throws Exception {
        Cache cache = null;
        String[] regionNames = new String[]{"replicateOverFlowRegion", "replicatePersistentOverFlowRegion", "prOverFlowRegion", "prPersistentOverFlowRegion"};
        cache = CacheUtil.getCache();
        if (cache == null) {
            QueryIndexDUnitTest qidt = new QueryIndexDUnitTest("temp");
            cache = qidt.createCache();
        }
        Log.getLogWriter().info("CreateAndLoadOverFlowRegions() with vmName " + vmName + " createRegions: " + createRegions + " And LoadRegions: " + loadRegions);
        if (createRegions.booleanValue()) {
            for (int i = 0; i < regionNames.length; ++i) {
                Log.getLogWriter().info("Started creating region :" + regionNames[i]);
                String diskStore = regionNames[i] + vmName + "DiskStore";
                Log.getLogWriter().info("Setting disk store to: " + diskStore);
                cache.createDiskStoreFactory().create(diskStore);
                try {
                    AttributesFactory attributesFactory = new AttributesFactory();
                    attributesFactory.setDiskStoreName(diskStore);
                    attributesFactory.setEvictionAttributes(EvictionAttributes.createLRUEntryAttributes((int)10, (EvictionAction)EvictionAction.OVERFLOW_TO_DISK));
                    if (i == 0) {
                        attributesFactory.setDataPolicy(DataPolicy.REPLICATE);
                    } else if (i == 1) {
                        attributesFactory.setDataPolicy(DataPolicy.PERSISTENT_REPLICATE);
                    } else if (i == 2) {
                        attributesFactory.setDataPolicy(DataPolicy.PARTITION);
                    } else {
                        attributesFactory.setDataPolicy(DataPolicy.PERSISTENT_REPLICATE);
                    }
                    cache.createRegion(regionNames[i], attributesFactory.create());
                    Log.getLogWriter().info("Completed creating region :" + regionNames[i]);
                    continue;
                }
                catch (Exception e) {
                    QueryIndexDUnitTest.fail("Could not create region" + regionNames[i], e);
                }
            }
        }
        Region region = null;
        int numObjects = 50;
        if (loadRegions.booleanValue()) {
            for (int i = 0; i < regionNames.length; ++i) {
                int cnt;
                region = cache.getRegion(regionNames[i]);
                if (!createRegions.booleanValue()) {
                    Log.getLogWriter().info("Started destroying region entries:" + regionNames[i]);
                    for (cnt = 0; cnt < numObjects / 3; ++cnt) {
                        region.destroy((Object)new Portfolio(cnt * 2));
                    }
                }
                Log.getLogWriter().info("Started Loading region :" + regionNames[i]);
                for (cnt = 0; cnt < numObjects; ++cnt) {
                    region.put((Object)new Portfolio(cnt), (Object)new Portfolio(cnt));
                }
                Log.getLogWriter().info("Completed loading region :" + regionNames[i]);
            }
        }
    }

    public static void createIndexOnOverFlowRegions() throws Exception {
        Cache cache = null;
        String[] regionNames = new String[]{"replicateOverFlowRegion", "replicatePersistentOverFlowRegion", "prOverFlowRegion", "prPersistentOverFlowRegion"};
        cache = CacheUtil.getCache();
        if (cache == null) {
            QueryIndexDUnitTest qidt = new QueryIndexDUnitTest("temp");
            cache = qidt.createCache();
        }
        cache.getLogger().fine("createIndexOnOverFlowRegions()");
        QueryService qs = cache.getQueryService();
        Region region = null;
        for (int i = 0; i < regionNames.length; ++i) {
            region = cache.getRegion(regionNames[i]);
            String indexName = "idIndex" + regionNames[i];
            cache.getLogger().fine("createIndexOnOverFlowRegions() checking for index: " + indexName);
            try {
                Index index;
                if (qs.getIndex(region, indexName) == null) {
                    cache.getLogger().fine("createIndexOnOverFlowRegions() Index doesn't exist, creating index: " + indexName);
                    index = qs.createIndex(indexName, IndexType.FUNCTIONAL, "pf.ID", "/" + regionNames[i] + " pf");
                }
                if (qs.getIndex(region, indexName = "keyIdIndex" + regionNames[i]) == null) {
                    cache.getLogger().fine("createIndexOnOverFlowRegions() Index doesn't exist, creating index: " + indexName);
                    index = qs.createIndex(indexName, IndexType.FUNCTIONAL, "key.ID", "/" + regionNames[i] + ".keys key");
                }
                if (qs.getIndex(region, indexName = "entryIdIndex" + regionNames[i]) == null) {
                    cache.getLogger().fine("createIndexOnOverFlowRegions() Index doesn't exist, creating index: " + indexName);
                    index = qs.createIndex(indexName, IndexType.FUNCTIONAL, "entry.value.ID", "/" + regionNames[i] + ".entries entry");
                }
                if (qs.getIndex(region, indexName = "entryMethodIndex" + regionNames[i]) == null) {
                    cache.getLogger().fine("createIndexOnOverFlowRegions() Index doesn't exist, creating index: " + indexName);
                    index = qs.createIndex(indexName, IndexType.FUNCTIONAL, "entry.getValue().getID()", "/" + regionNames[i] + ".entries entry");
                }
                if (qs.getIndex(region, indexName = "entryMethodWithArgIndex" + regionNames[i]) != null) continue;
                cache.getLogger().fine("createIndexOnOverFlowRegions() Index doesn't exist, creating index: " + indexName);
                index = qs.createIndex(indexName, IndexType.FUNCTIONAL, "entry.getValue().boolFunction('active')", "/" + regionNames[i] + ".entries entry");
                continue;
            }
            catch (IndexNameConflictException indexNameConflictException) {
                // empty catch block
            }
        }
    }

    public static void executeQueriesUsingIndexOnOverflowRegions() throws Exception {
        Cache cache = null;
        String[] regionNames = new String[]{"replicateOverFlowRegion", "replicatePersistentOverFlowRegion", "prOverFlowRegion", "prPersistentOverFlowRegion"};
        cache = CacheUtil.getCache();
        if (cache == null) {
            QueryIndexDUnitTest qidt = new QueryIndexDUnitTest("temp");
            cache = qidt.createCache();
        }
        QueryService qs = cache.getQueryService();
        Object region = null;
        String[] qString = new String[]{"SELECT * FROM /REGION_NAME pf WHERE pf.ID = 1", "SELECT ID FROM /REGION_NAME pf WHERE pf.ID = 1", "SELECT * FROM /REGION_NAME pf WHERE pf.ID > 10", "SELECT ID FROM /REGION_NAME pf WHERE pf.ID > 10", "SELECT * FROM /REGION_NAME.keys key WHERE key.ID = 1", "SELECT ID FROM /REGION_NAME.keys key WHERE key.ID = 1", "SELECT * FROM /REGION_NAME.keys key WHERE key.ID > 10", "SELECT ID FROM /REGION_NAME.keys key WHERE key.ID > 10", "SELECT entry.value FROM /REGION_NAME.entries entry WHERE entry.value.ID = 1", "SELECT entry.key FROM /REGION_NAME.entries entry WHERE entry.value.ID > 10", "SELECT entry.getValue() FROM /REGION_NAME.entries entry WHERE entry.getValue().getID() = 1", "SELECT entry.getKey() FROM /REGION_NAME.entries entry WHERE entry.getValue().getID() > 10", "SELECT entry.getValue() FROM /REGION_NAME.entries entry WHERE entry.getValue().boolFunction('active') = false"};
        for (int q = 0; q < qString.length; ++q) {
            for (int i = 0; i < regionNames.length; ++i) {
                QueryObserverImpl observer = new QueryObserverImpl();
                QueryObserverHolder.setInstance((QueryObserver)observer);
                String queryStr = qString[q].replace("REGION_NAME", regionNames[i]);
                Query query = qs.newQuery(queryStr);
                SelectResults results = (SelectResults)query.execute();
                Log.getLogWriter().info("Executed query :" + queryStr + " Result size: " + results.asList().size());
                if (observer.isIndexesUsed) continue;
                QueryIndexDUnitTest.fail((String)("Index not used for query. " + queryStr));
            }
        }
    }

    public static synchronized void createRegion() throws Exception {
        Region region;
        Cache cache = null;
        cache = CacheUtil.getCache();
        if (cache == null) {
            QueryIndexDUnitTest qidt = new QueryIndexDUnitTest("temp");
            cache = qidt.createCache();
        }
        if ((region = CacheUtil.getRegion("portfolios")) == null) {
            try {
                AttributesFactory attributesFactory = new AttributesFactory();
                attributesFactory.setValueConstraint(Portfolio.class);
                attributesFactory.setDataPolicy(DataPolicy.REPLICATE);
                attributesFactory.setIndexMaintenanceSynchronous(true);
                attributesFactory.setScope(Scope.GLOBAL);
                RegionAttributes regionAttributes = attributesFactory.create();
                region = cache.createRegion("portfolios", regionAttributes);
                region.put((Object)"0", (Object)new Portfolio(0));
            }
            catch (Exception e) {
                QueryIndexDUnitTest.fail("Could not create region", e);
            }
        }
    }

    public static synchronized void destroyRegion() {
        try {
            Region region = CacheUtil.getRegion("portfolios");
            if (region != null) {
                region.destroyRegion();
            }
        }
        catch (Exception e) {
            QueryIndexDUnitTest.fail("Could not destroy region", e);
        }
    }

    public static void closeCache() {
        try {
            CacheUtil.closeCache();
        }
        catch (Exception e) {
            QueryIndexDUnitTest.fail("Could not close cache", e);
        }
    }

    public static void removeIndex() {
        Region region = CacheUtil.getRegion("portfolios");
        if (region == null) {
            QueryIndexDUnitTest.fail((String)"The region is not created properly");
        } else {
            Log.getLogWriter().info("Obtained the region with name :portfolios");
            QueryService qs = CacheUtil.getQueryService();
            if (qs != null) {
                try {
                    Collection indexes = qs.getIndexes(region);
                    if (indexes == null) {
                        return;
                    }
                    if (indexes.size() == 0) {
                        return;
                    }
                    Iterator iter = indexes.iterator();
                    if (iter.hasNext()) {
                        Index idx = (Index)iter.next();
                        String name = idx.getName();
                        qs.removeIndex(idx);
                        Log.getLogWriter().info("Index " + name + " removed successfully");
                    }
                }
                catch (Exception e) {
                    QueryIndexDUnitTest.fail("Caught exception while trying to remove index", e);
                }
            } else {
                QueryIndexDUnitTest.fail((String)"Hey !!!!! Could not obtain QueryService for the cache ");
            }
        }
    }

    public static class QueryObserverImpl
    extends QueryObserverAdapter {
        boolean isIndexesUsed = false;
        ArrayList indexesUsed = new ArrayList();

        public void beforeIndexLookup(Index index, int oper, Object key) {
            this.indexesUsed.add(index.getName());
        }

        public void afterIndexLookup(Collection results) {
            if (results != null) {
                this.isIndexesUsed = true;
            }
        }
    }
}

