/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.query.dunit;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.MirrorType;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.query.Query;
import com.gemstone.gemfire.cache.query.QueryService;
import com.gemstone.gemfire.cache.query.SelectResults;
import com.gemstone.gemfire.cache.query.cq.dunit.CqQueryUsingPoolDUnitTest;
import com.gemstone.gemfire.cache.query.data.Portfolio;
import com.gemstone.gemfire.cache.query.dunit.QueryIndexDUnitTest;
import com.gemstone.gemfire.cache.query.internal.QueryObserver;
import com.gemstone.gemfire.cache.query.internal.QueryObserverHolder;
import com.gemstone.gemfire.cache.util.BridgeServer;
import com.gemstone.gemfire.cache30.BridgeTestCase;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.cache30.CertifiableTestCacheListener;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableRunnable;
import dunit.VM;
import java.io.IOException;
import java.util.ArrayList;
import junit.framework.TestCase;

public class QueryIndexUpdateRIDUnitTest
extends CacheTestCase {
    private static int bridgeServerPort;
    private final String region = "regionA";
    private final int KEYS = 1;
    private final int REGEX = 2;
    private final String rootQ = "SELECT ALL * FROM /root p where p.ID > 0";
    private final String incompleteQ = "SELECT ALL * FROM /root/regionA p where ";
    public static final String KEY = "key-";
    public static final String REGULAR_EXPRESSION = ".*1+?.*";
    private static final String ROOT = "root";

    public QueryIndexUpdateRIDUnitTest(String name) {
        super(name);
    }

    public void testClientIndexUpdateWithRIOnKeys() throws Exception {
        CqQueryUsingPoolDUnitTest cqDUnitTest = new CqQueryUsingPoolDUnitTest("CqRegisterInterestIndexUpdateDunitTest");
        Host host = Host.getHost(0);
        VM server = host.getVM(0);
        VM client = host.getVM(1);
        this.createServer(server, 0, false);
        int port = server.invokeInt(QueryIndexUpdateRIDUnitTest.class, "getCacheServerPort");
        String host0 = QueryIndexUpdateRIDUnitTest.getServerHostName(server.getHost());
        int size = 10;
        this.createValues(server, cqDUnitTest.regions[0], 10);
        String poolName = "testClientIndexUpdateWithRegisterInterest";
        cqDUnitTest.createPool(client, poolName, host0, port);
        cqDUnitTest.createClient(client, port, host0);
        cqDUnitTest.createFunctionalIndex(client, "IdIndex", "p.ID", "/root/regionA p");
        this.registerInterestList(client, cqDUnitTest.regions[0], 4, 1);
        QueryIndexUpdateRIDUnitTest.pause(5000);
        this.validateQueryOnIndex(client, cqDUnitTest.cqs[0], 4);
        cqDUnitTest.closeClient(client);
        cqDUnitTest.closeServer(server);
    }

    public void testClientIndexUpdateWithRIOnOverlapKeys() throws Exception {
        CqQueryUsingPoolDUnitTest cqDUnitTest = new CqQueryUsingPoolDUnitTest("CqRegisterInterestIndexUpdateDunitTest");
        Host host = Host.getHost(0);
        VM server = host.getVM(0);
        VM client = host.getVM(1);
        this.createServer(server, 0, false);
        int port = server.invokeInt(QueryIndexUpdateRIDUnitTest.class, "getCacheServerPort");
        String host0 = QueryIndexUpdateRIDUnitTest.getServerHostName(server.getHost());
        String poolName = "testClientIndexUpdateWithRegisterInterest";
        cqDUnitTest.createPool(client, poolName, host0, port);
        cqDUnitTest.createClient(client, port, host0);
        cqDUnitTest.createFunctionalIndex(client, "IdIndex", "p.ID", "/root/regionA p");
        int size = 10;
        this.createValues(client, cqDUnitTest.regions[0], 10, 1);
        QueryIndexUpdateRIDUnitTest.pause(5000);
        this.validateQueryOnIndex(client, "SELECT ALL * FROM /root/regionA p where p.ID > 0", 10);
        this.createValues(server, cqDUnitTest.regions[0], 10, 4);
        this.registerInterestList(client, cqDUnitTest.regions[0], 10, 1, 4);
        QueryIndexUpdateRIDUnitTest.pause(5000);
        this.validateQueryOnIndex(client, "SELECT ALL * FROM /root/regionA p where p.ID < 16", 3);
        this.validateQueryOnIndex(client, "SELECT ALL * FROM /root/regionA p where p.ID >= 16", 7);
        cqDUnitTest.closeClient(client);
        cqDUnitTest.closeServer(server);
    }

    public void testClientIndexUpdateWithRIOnRegion() throws Exception {
        CqQueryUsingPoolDUnitTest cqDUnitTest = new CqQueryUsingPoolDUnitTest("CqRegisterInterestIndexUpdateDunitTest");
        Host host = Host.getHost(0);
        VM server = host.getVM(0);
        VM client = host.getVM(1);
        this.createServer(server, 0, false);
        int port = server.invokeInt(QueryIndexUpdateRIDUnitTest.class, "getCacheServerPort");
        String host0 = QueryIndexUpdateRIDUnitTest.getServerHostName(server.getHost());
        int size = 10;
        this.createValues(server, cqDUnitTest.regions[0], 10);
        String poolName = "testClientIndexUpdateWithRegisterInterest";
        cqDUnitTest.createPool(client, poolName, host0, port);
        cqDUnitTest.createClient(client, port, host0);
        cqDUnitTest.createFunctionalIndex(client, "IdIndex", "p.ID", "/root/regionA p");
        cqDUnitTest.registerInterestListCQ(client, cqDUnitTest.regions[0], 10, true);
        QueryIndexUpdateRIDUnitTest.pause(5000);
        this.validateQueryOnIndex(client, cqDUnitTest.cqs[0], 10);
        cqDUnitTest.closeClient(client);
        cqDUnitTest.closeServer(server);
    }

    public void testClientIndexUpdateWithRIOnRegEx() throws Exception {
        CqQueryUsingPoolDUnitTest cqDUnitTest = new CqQueryUsingPoolDUnitTest("QueryIndexUpdateRIDunitTest");
        Host host = Host.getHost(0);
        VM server = host.getVM(0);
        VM client = host.getVM(1);
        this.createServer(server, 0, false);
        int port = server.invokeInt(QueryIndexUpdateRIDUnitTest.class, "getCacheServerPort");
        String host0 = QueryIndexUpdateRIDUnitTest.getServerHostName(server.getHost());
        int size = 10;
        this.createValues(server, cqDUnitTest.regions[0], 10);
        String poolName = "testClientIndexUpdateWithRegisterInterest";
        cqDUnitTest.createPool(client, poolName, host0, port);
        cqDUnitTest.createClient(client, port, host0);
        cqDUnitTest.createFunctionalIndex(client, "IdIndex", "p.ID", "/root/regionA p");
        this.registerInterestList(client, cqDUnitTest.regions[0], 2, 2);
        QueryIndexUpdateRIDUnitTest.pause(5000);
        this.validateQueryOnIndex(client, cqDUnitTest.cqs[0], 2);
        cqDUnitTest.closeClient(client);
        cqDUnitTest.closeServer(server);
    }

    public void testClientIndexUpdateWithRIOnClearedRegion() throws Exception {
        CqQueryUsingPoolDUnitTest cqDUnitTest = new CqQueryUsingPoolDUnitTest("QueryIndexUpdateRIDunitTest");
        Host host = Host.getHost(0);
        VM server = host.getVM(0);
        VM client = host.getVM(1);
        this.createServer(server, 0, false);
        int port = server.invokeInt(QueryIndexUpdateRIDUnitTest.class, "getCacheServerPort");
        String host0 = QueryIndexUpdateRIDUnitTest.getServerHostName(server.getHost());
        int size = 1000;
        this.createValues(server, cqDUnitTest.regions[0], 1000);
        String poolName = "testClientIndexUpdateWithRegisterInterest";
        cqDUnitTest.createPool(client, poolName, host0, port);
        cqDUnitTest.createClient(client, port, host0);
        cqDUnitTest.createFunctionalIndex(client, "IdIndex", "p.ID", "/root/regionA p");
        this.createValues(client, cqDUnitTest.regions[0], 1000);
        this.registerInterestList(client, cqDUnitTest.regions[0], 1000, -1);
        client.invoke(this.getSRClearRegion(cqDUnitTest.regions[0]));
        this.validateQueryOnIndexWithRegion(client, cqDUnitTest.cqs[0], 0, "regionA");
        cqDUnitTest.closeClient(client);
        cqDUnitTest.closeServer(server);
    }

    public void testClientIndexUpdateWithRIOnPRRegion() throws Exception {
        CqQueryUsingPoolDUnitTest cqDUnitTest = new CqQueryUsingPoolDUnitTest("QueryIndexUpdateRIDunitTest");
        Host host = Host.getHost(0);
        VM server = host.getVM(0);
        VM client = host.getVM(1);
        this.createServer(server, 0, true);
        int port = server.invokeInt(QueryIndexUpdateRIDUnitTest.class, "getCacheServerPort");
        String host0 = QueryIndexUpdateRIDUnitTest.getServerHostName(server.getHost());
        int size = 10;
        this.createValues(server, ROOT, 10);
        String poolName = "testClientIndexUpdateWithRegisterInterest";
        cqDUnitTest.createPool(client, poolName, host0, port);
        this.createClient(client, port, host0);
        cqDUnitTest.createFunctionalIndex(client, "IdIndex", "p.ID", "/root p");
        this.registerInterestList(client, ROOT, 10, 0);
        QueryIndexUpdateRIDUnitTest.pause(5000);
        this.validateQueryOnIndex(client, this.rootQ, 10);
        cqDUnitTest.closeClient(client);
        cqDUnitTest.closeServer(server);
    }

    public void testClientIndexUpdateWithRIOnPRKeys() throws Exception {
        CqQueryUsingPoolDUnitTest cqDUnitTest = new CqQueryUsingPoolDUnitTest("QueryIndexUpdateRIDunitTest");
        Host host = Host.getHost(0);
        VM server = host.getVM(0);
        VM client = host.getVM(1);
        this.createServer(server, 0, true);
        int port = server.invokeInt(QueryIndexUpdateRIDUnitTest.class, "getCacheServerPort");
        String host0 = QueryIndexUpdateRIDUnitTest.getServerHostName(server.getHost());
        int size = 10;
        this.createValues(server, ROOT, 10);
        String poolName = "testClientIndexUpdateWithRegisterInterest";
        cqDUnitTest.createPool(client, poolName, host0, port);
        this.createClient(client, port, host0);
        cqDUnitTest.createFunctionalIndex(client, "IdIndex", "p.ID", "/root p");
        this.registerInterestList(client, ROOT, 4, 1);
        QueryIndexUpdateRIDUnitTest.pause(5000);
        this.validateQueryOnIndex(client, this.rootQ, 4);
        cqDUnitTest.closeClient(client);
        cqDUnitTest.closeServer(server);
    }

    public void testClientIndexUpdateWithRIOnPRRegEx() throws Exception {
        CqQueryUsingPoolDUnitTest cqDUnitTest = new CqQueryUsingPoolDUnitTest("QueryIndexUpdateRIDunitTest");
        Host host = Host.getHost(0);
        VM server = host.getVM(0);
        VM client = host.getVM(1);
        this.createServer(server, 0, true);
        int port = server.invokeInt(QueryIndexUpdateRIDUnitTest.class, "getCacheServerPort");
        String host0 = QueryIndexUpdateRIDUnitTest.getServerHostName(server.getHost());
        int size = 10;
        this.createValues(server, ROOT, 10);
        String poolName = "testClientIndexUpdateWithRegisterInterest";
        cqDUnitTest.createPool(client, poolName, host0, port);
        this.createClient(client, port, host0);
        cqDUnitTest.createFunctionalIndex(client, "IdIndex", "p.ID", "/root p");
        this.registerInterestList(client, ROOT, 2, 2);
        QueryIndexUpdateRIDUnitTest.pause(5000);
        this.validateQueryOnIndex(client, this.rootQ, 2);
        cqDUnitTest.closeClient(client);
        cqDUnitTest.closeServer(server);
    }

    public void registerInterestList(VM vm, String regionName, int keySize, int policy) {
        this.registerInterestList(vm, regionName, keySize, policy, 0);
    }

    public void registerInterestList(VM vm, final String regionName, final int keySize, final int policy, final int start) {
        vm.invoke(new CacheSerializableRunnable("Register InterestList"){

            @Override
            public void run2() throws CacheException {
                Region region = null;
                try {
                    region = QueryIndexUpdateRIDUnitTest.ROOT.equals(regionName) ? QueryIndexUpdateRIDUnitTest.this.getRootRegion() : QueryIndexUpdateRIDUnitTest.this.getRootRegion().getSubregion(regionName);
                    region.getAttributesMutator().setCacheListener((CacheListener)new CertifiableTestCacheListener(DistributedTestCase.getLogWriter()));
                }
                catch (Exception cqe) {
                    AssertionError err = new AssertionError((Object)"Failed to get Region.");
                    ((Throwable)((Object)err)).initCause(cqe);
                    throw err;
                }
                try {
                    switch (policy) {
                        case 2: {
                            region.registerInterestRegex(QueryIndexUpdateRIDUnitTest.REGULAR_EXPRESSION);
                            break;
                        }
                        case 1: {
                            int i;
                            ArrayList<String> list = new ArrayList<String>();
                            int n = i = start != 0 ? start : 1;
                            while (i <= keySize) {
                                list.add(QueryIndexUpdateRIDUnitTest.KEY + i);
                                ++i;
                            }
                            region.registerInterest(list);
                            break;
                        }
                        default: {
                            region.registerInterest((Object)"ALL_KEYS");
                            break;
                        }
                    }
                }
                catch (Exception ex) {
                    AssertionError err = new AssertionError((Object)"Failed to Register InterestList");
                    ((Throwable)((Object)err)).initCause(ex);
                    throw err;
                }
            }
        });
    }

    public void asyncRegisterInterestList(VM vm, final String regionName, final int keySize, final int policy, final int start) {
        vm.invokeAsync(new CacheSerializableRunnable("Register InterestList"){

            @Override
            public void run2() throws CacheException {
                Region region = null;
                try {
                    region = QueryIndexUpdateRIDUnitTest.ROOT.equals(regionName) ? QueryIndexUpdateRIDUnitTest.this.getRootRegion() : QueryIndexUpdateRIDUnitTest.this.getRootRegion().getSubregion(regionName);
                    region.getAttributesMutator().setCacheListener((CacheListener)new CertifiableTestCacheListener(DistributedTestCase.getLogWriter()));
                }
                catch (Exception cqe) {
                    AssertionError err = new AssertionError((Object)"Failed to get Region.");
                    ((Throwable)((Object)err)).initCause(cqe);
                    throw err;
                }
                try {
                    switch (policy) {
                        case 2: {
                            region.registerInterestRegex(QueryIndexUpdateRIDUnitTest.REGULAR_EXPRESSION);
                            break;
                        }
                        case 1: {
                            int i;
                            ArrayList<String> list = new ArrayList<String>();
                            int n = i = start != 0 ? start : 1;
                            while (i <= keySize) {
                                list.add(QueryIndexUpdateRIDUnitTest.KEY + i);
                                ++i;
                            }
                            region.registerInterest(list);
                            break;
                        }
                        default: {
                            region.registerInterest((Object)"ALL_KEYS");
                            break;
                        }
                    }
                }
                catch (Exception ex) {
                    AssertionError err = new AssertionError((Object)"Failed to Register InterestList");
                    ((Throwable)((Object)err)).initCause(ex);
                    throw err;
                }
            }
        });
    }

    public void createServer(VM server, final int thePort, final boolean partitioned) {
        CacheSerializableRunnable createServer = new CacheSerializableRunnable("Create Cache Server"){

            @Override
            public void run2() throws CacheException {
                DistributedTestCase.getLogWriter().info("### Create Cache Server. ###");
                AttributesFactory factory = new AttributesFactory();
                if (partitioned) {
                    factory.setDataPolicy(DataPolicy.PARTITION);
                    QueryIndexUpdateRIDUnitTest.this.createRootRegion(factory.createRegionAttributes());
                } else {
                    factory.setMirrorType(MirrorType.KEYS_VALUES);
                    factory.setScope(Scope.DISTRIBUTED_ACK);
                    QueryIndexUpdateRIDUnitTest.this.createRegion("regionA", factory.createRegionAttributes());
                }
                DistributedTestCase.pause(2000);
                try {
                    QueryIndexUpdateRIDUnitTest.this.startBridgeServer(thePort, true);
                }
                catch (Exception ex) {
                    DistributedTestCase.fail("While starting CacheServer", ex);
                }
                DistributedTestCase.pause(2000);
            }
        };
        server.invoke(createServer);
    }

    public void startBridgeServer(int port, boolean notifyBySubscription) throws IOException {
        Cache cache = this.getCache();
        BridgeServer bridge = cache.addBridgeServer();
        bridge.setPort(port);
        bridge.setNotifyBySubscription(notifyBySubscription);
        bridge.start();
        bridgeServerPort = bridge.getPort();
    }

    public void createValues(VM vm, String regionName, int size) {
        this.createValues(vm, regionName, size, 0);
    }

    public void createValues(VM vm, final String regionName, final int size, final int start) {
        vm.invoke(new CacheSerializableRunnable("Create values"){

            @Override
            public void run2() throws CacheException {
                int i;
                Region region1 = !QueryIndexUpdateRIDUnitTest.ROOT.equals(regionName) ? QueryIndexUpdateRIDUnitTest.this.getRootRegion().getSubregion(regionName) : QueryIndexUpdateRIDUnitTest.this.getRootRegion();
                int n = i = start != 0 ? start : 1;
                while (i <= size) {
                    region1.put((Object)(QueryIndexUpdateRIDUnitTest.KEY + i), (Object)new Portfolio((start != 0 ? start : 1) * i, i));
                    ++i;
                }
                DistributedTestCase.getLogWriter().info("### Number of Entries in Region :" + region1.keys().size());
            }
        });
    }

    static int getCacheServerPort() {
        return bridgeServerPort;
    }

    public void createClient(VM client, int serverPort, String serverHost) {
        int[] serverPorts = new int[]{serverPort};
        this.createClient(client, serverPorts, serverHost, null, null);
    }

    public void createClient(VM client, final int[] serverPorts, final String serverHost, final String redundancyLevel, final String poolName) {
        CacheSerializableRunnable createQService = new CacheSerializableRunnable("Create Client"){

            @Override
            public void run2() throws CacheException {
                DistributedTestCase.getLogWriter().info("### Create Client. ###");
                try {
                    QueryIndexUpdateRIDUnitTest.this.getCache().getQueryService();
                }
                catch (Exception cqe) {
                    DistributedTestCase.fail("Failed to getCQService.", cqe);
                }
                AttributesFactory regionFactory = new AttributesFactory();
                regionFactory.setScope(Scope.LOCAL);
                if (poolName != null) {
                    regionFactory.setPoolName(poolName);
                } else if (redundancyLevel != null) {
                    BridgeTestCase.configureConnectionPool(regionFactory, serverHost, serverPorts, true, Integer.parseInt(redundancyLevel), -1, null);
                } else {
                    BridgeTestCase.configureConnectionPool(regionFactory, serverHost, serverPorts, true, -1, -1, null);
                }
                QueryIndexUpdateRIDUnitTest.this.createRootRegion(regionFactory.createRegionAttributes());
                DistributedTestCase.getLogWriter().info("### Successfully Created Root Region on Client");
            }
        };
        client.invoke(createQService);
    }

    public void validateQueryOnIndex(VM vm, String query, int resultSize) {
        this.validateQueryOnIndexWithRegion(vm, query, resultSize, null);
    }

    public void validateQueryOnIndexWithRegion(VM vm, final String query, final int resultSize, final String region) {
        vm.invoke(new CacheSerializableRunnable("Validate Query"){

            @Override
            public void run2() throws CacheException {
                DistributedTestCase.getLogWriter().info("### Validating Query. ###");
                QueryService qs = QueryIndexUpdateRIDUnitTest.this.getCache().getQueryService();
                Query q = qs.newQuery(query);
                QueryIndexDUnitTest.QueryObserverImpl observer = new QueryIndexDUnitTest.QueryObserverImpl();
                QueryObserverHolder.setInstance((QueryObserver)observer);
                try {
                    Object r = q.execute();
                    if (r instanceof SelectResults) {
                        Region reg;
                        int rSize = ((SelectResults)r).asSet().size();
                        DistributedTestCase.getLogWriter().info("### Result Size is :" + rSize);
                        if (region == null) {
                            TestCase.assertEquals((int)resultSize, (int)rSize);
                        } else if (region != null && (reg = QueryIndexUpdateRIDUnitTest.this.getCache().getRegion("/root/" + region)) != null) {
                            TestCase.assertEquals((int)rSize, (int)reg.size());
                            for (Object value : reg.values()) {
                                if (((SelectResults)r).asSet().contains((Portfolio)value)) continue;
                                TestCase.fail((String)("Query resultset mismatch with region values for value: " + value));
                            }
                        }
                    }
                }
                catch (Exception e) {
                    DistributedTestCase.fail("Failed to execute the query.", e);
                }
                if (!observer.isIndexesUsed) {
                    TestCase.fail((String)"Index not used for query");
                }
            }
        });
    }

    public void asyncClearRegion(VM vm, final String regionName) {
        vm.invokeAsync(new CacheSerializableRunnable("Destroy entries"){

            @Override
            public void run2() throws CacheException {
                DistributedTestCase.getLogWriter().info("### Clearing Region. ###");
                Region region1 = !QueryIndexUpdateRIDUnitTest.ROOT.equals(regionName) ? QueryIndexUpdateRIDUnitTest.this.getRootRegion().getSubregion(regionName) : QueryIndexUpdateRIDUnitTest.this.getRootRegion();
                region1.clear();
                DistributedTestCase.getLogWriter().info("### Number of Entries in Region :" + region1.keys().size());
            }
        });
    }

    private SerializableRunnable getSRClearRegion(final String regionName) {
        CacheSerializableRunnable sr = new CacheSerializableRunnable("Destroy entries"){

            @Override
            public void run2() throws CacheException {
                DistributedTestCase.getLogWriter().info("### Clearing Region. ###");
                Region region1 = !QueryIndexUpdateRIDUnitTest.ROOT.equals(regionName) ? QueryIndexUpdateRIDUnitTest.this.getRootRegion().getSubregion(regionName) : QueryIndexUpdateRIDUnitTest.this.getRootRegion();
                region1.clear();
                DistributedTestCase.getLogWriter().info("### Number of Entries in Region :" + region1.keys().size());
            }
        };
        return sr;
    }

    private SerializableRunnable getSRRegisterInterestList(final String regionName, final int keySize, final int policy, final int start) {
        CacheSerializableRunnable sr = new CacheSerializableRunnable("Register InterestList"){

            @Override
            public void run2() throws CacheException {
                Region region = null;
                try {
                    region = QueryIndexUpdateRIDUnitTest.ROOT.equals(regionName) ? QueryIndexUpdateRIDUnitTest.this.getRootRegion() : QueryIndexUpdateRIDUnitTest.this.getRootRegion().getSubregion(regionName);
                    region.getAttributesMutator().setCacheListener((CacheListener)new CertifiableTestCacheListener(DistributedTestCase.getLogWriter()));
                }
                catch (Exception cqe) {
                    AssertionError err = new AssertionError((Object)"Failed to get Region.");
                    ((Throwable)((Object)err)).initCause(cqe);
                    throw err;
                }
                try {
                    switch (policy) {
                        case 2: {
                            region.registerInterestRegex(QueryIndexUpdateRIDUnitTest.REGULAR_EXPRESSION);
                            break;
                        }
                        case 1: {
                            int i;
                            ArrayList<String> list = new ArrayList<String>();
                            int n = i = start != 0 ? start : 1;
                            while (i <= keySize) {
                                list.add(QueryIndexUpdateRIDUnitTest.KEY + i);
                                ++i;
                            }
                            region.registerInterest(list);
                            break;
                        }
                        default: {
                            region.registerInterest((Object)"ALL_KEYS");
                            break;
                        }
                    }
                }
                catch (Exception ex) {
                    AssertionError err = new AssertionError((Object)"Failed to Register InterestList");
                    ((Throwable)((Object)err)).initCause(ex);
                    throw err;
                }
            }
        };
        return sr;
    }
}

