/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.query.dunit;

import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheExistsException;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.query.Index;
import com.gemstone.gemfire.cache.query.Query;
import com.gemstone.gemfire.cache.query.QueryService;
import com.gemstone.gemfire.cache.query.SelectResults;
import com.gemstone.gemfire.cache.query.data.Portfolio;
import com.gemstone.gemfire.cache.query.functional.StructSetOrResultsSet;
import com.gemstone.gemfire.cache.query.internal.QueryObserver;
import com.gemstone.gemfire.cache.query.internal.QueryObserverAdapter;
import com.gemstone.gemfire.cache.query.internal.QueryObserverHolder;
import com.gemstone.gemfire.cache.query.internal.index.IndexManager;
import com.gemstone.gemfire.cache.query.internal.index.PartitionedIndex;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.FileUtil;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import dunit.AsyncInvocation;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.VM;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import junit.framework.TestCase;

public class QueryIndexUsingXMLDUnitTest
extends CacheTestCase {
    private static final String WAIT_PROPERTY = "QueryIndexBuckets.maxWaitTime";
    private static final int WAIT_DEFAULT = 20000;
    public static final long MAX_TIME = Integer.getInteger("QueryIndexBuckets.maxWaitTime", 20000).intValue();
    final String name = "PartionedPortfolios";
    final String repRegName = "Portfolios";
    final String persistentRegName = "PersistentPrPortfolios";
    final String nameWithRange = "PartitionedPortfoliosWithRange";
    final String nameWithHash = "PartionedPortfoliosWithHash";
    final String repRegNameWithRange = "PortfoliosWithRange";
    final String repRegNameWithHash = "PortfoliosWithHash";
    final String persistentRegNameWithRange = "PersistentPrPortfoliosWithRange";
    final String persistentRegNameWithHash = "PersistentPrPortfoliosWithHash";
    final String noIndexRepReg = "PortfoliosNoIndex";
    final String statusIndex = "statusIndex";
    final String idIndex = "idIndex";
    String[][] queryStr = new String[][]{{"Select * from /PartionedPortfolios where ID > 10", "Select * from /Portfolios where ID > 10", "Select * from /PersistentPrPortfolios where ID > 10"}, {"Select * from /PartionedPortfolios where ID = 5", "Select * from /Portfolios where ID = 5", "Select * from /PersistentPrPortfolios where ID = 5", "Select * from /PartionedPortfoliosWithHash where ID = 5", "Select * from /PortfoliosWithHash where ID = 5", "Select * from /PersistentPrPortfoliosWithHash where ID = 5"}, {"Select * from /PartionedPortfolios where status = 'active'", "Select * from /Portfolios where status = 'active'", "Select * from /PersistentPrPortfolios where status = 'active'", "Select * from /PartionedPortfoliosWithHash where status = 'active'", "Select * from /PortfoliosWithHash where status = 'active'", "Select * from /PersistentPrPortfoliosWithHash where status = 'active'"}};
    String[] queryStrNoIndex = new String[]{"Select * from /PortfoliosNoIndex where ID > 10", "Select * from /PortfoliosNoIndex where ID = 5", "Select * from /PortfoliosNoIndex where status = 'active'"};
    String queryStrValid = "Select * from /PortfoliosNoIndex where ID > 10";
    private String persistentOverFlowRegName = "PersistentOverflowPortfolios";

    public QueryIndexUsingXMLDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() {
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
        GemFireCacheImpl cache = (GemFireCacheImpl)this.getCache();
        String diskStoreName = cache.getDefaultDiskStoreName();
        QueryIndexUsingXMLDUnitTest.invokeInEveryVM(this.resetTestHook());
        QueryIndexUsingXMLDUnitTest.closeCache();
        QueryIndexUsingXMLDUnitTest.disconnectFromDS();
        File diskDir = new File(diskStoreName).getAbsoluteFile();
        FileUtil.delete((File)diskDir);
    }

    public void testCreateIndexThroughXML() throws Exception {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        String fileName = "IndexCreation.xml";
        QueryIndexUsingXMLDUnitTest.getLogWriter().info("Creating index using an xml file name : IndexCreation.xml");
        AsyncInvocation asyInvk0 = vm0.invokeAsync(this.createIndexThrougXML("vm0testCreateIndexThroughXML", "PartionedPortfolios", "IndexCreation.xml"));
        AsyncInvocation asyInvk1 = vm1.invokeAsync(this.createIndexThrougXML("vm1testCreateIndexThroughXML", "PartionedPortfolios", "IndexCreation.xml"));
        DistributedTestCase.join(asyInvk1, 30000L, QueryIndexUsingXMLDUnitTest.getLogWriter());
        if (asyInvk1.exceptionOccurred()) {
            QueryIndexUsingXMLDUnitTest.fail("asyInvk1 failed", asyInvk1.getException());
        }
        DistributedTestCase.join(asyInvk0, 30000L, QueryIndexUsingXMLDUnitTest.getLogWriter());
        if (asyInvk0.exceptionOccurred()) {
            QueryIndexUsingXMLDUnitTest.fail("asyInvk0 failed", asyInvk0.getException());
        }
        vm0.invoke(this.prIndexCreationCheck("PartionedPortfolios", "statusIndex", -1));
        vm1.invoke(this.prIndexCreationCheck("PartionedPortfolios", "statusIndex", -1));
        vm0.invoke(this.prIndexCreationCheck("PartionedPortfolios", "idIndex", -1));
        vm1.invoke(this.prIndexCreationCheck("PartionedPortfolios", "idIndex", -1));
        vm0.invoke(this.prIndexCreationCheck("PartionedPortfolios", "secIndex", -1));
        vm1.invoke(this.prIndexCreationCheck("PartionedPortfolios", "secIndex", -1));
        vm0.invoke(this.indexCreationCheck("Portfolios", "statusIndex"));
        vm1.invoke(this.indexCreationCheck("Portfolios", "statusIndex"));
        vm0.invoke(this.prIndexCreationCheck("PersistentPrPortfolios", "statusIndex", -1));
        vm1.invoke(this.prIndexCreationCheck("PersistentPrPortfolios", "statusIndex", -1));
        vm0.invoke(this.prIndexCreationCheck("PartitionedPortfoliosWithRange", "statusIndex", -1));
        vm1.invoke(this.prIndexCreationCheck("PartitionedPortfoliosWithRange", "statusIndex", -1));
        vm0.invoke(this.prIndexCreationCheck("PartitionedPortfoliosWithRange", "idIndex", -1));
        vm1.invoke(this.prIndexCreationCheck("PartitionedPortfoliosWithRange", "idIndex", -1));
        vm0.invoke(this.indexCreationCheck("PortfoliosWithRange", "statusIndex"));
        vm1.invoke(this.indexCreationCheck("PortfoliosWithRange", "statusIndex"));
        vm0.invoke(this.prIndexCreationCheck("PersistentPrPortfoliosWithRange", "statusIndex", -1));
        vm1.invoke(this.prIndexCreationCheck("PersistentPrPortfoliosWithRange", "statusIndex", -1));
        vm0.invoke(this.prIndexCreationCheck("PartionedPortfoliosWithHash", "statusIndex", -1));
        vm1.invoke(this.prIndexCreationCheck("PartionedPortfoliosWithHash", "statusIndex", -1));
        vm0.invoke(this.prIndexCreationCheck("PartionedPortfoliosWithHash", "idIndex", -1));
        vm1.invoke(this.prIndexCreationCheck("PartionedPortfoliosWithHash", "idIndex", -1));
        vm0.invoke(this.indexCreationCheck("PortfoliosWithHash", "statusIndex"));
        vm1.invoke(this.indexCreationCheck("PortfoliosWithHash", "statusIndex"));
        vm0.invoke(this.prIndexCreationCheck("PersistentPrPortfoliosWithHash", "statusIndex", -1));
        vm1.invoke(this.prIndexCreationCheck("PersistentPrPortfoliosWithHash", "statusIndex", -1));
        vm0.invoke(this.close());
        vm1.invoke(this.close());
    }

    public void testCreateIndexWhileDoingGII() throws Exception {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        String fileName = "IndexCreation.xml";
        QueryIndexUsingXMLDUnitTest.getLogWriter().info("Creating index using an xml file name : IndexCreation.xml");
        vm0.invoke(this.createIndexThrougXML("vm0testCreateIndexWhileDoingGII", "PartionedPortfolios", "IndexCreation.xml"));
        vm0.invoke(this.loadRegion("PartionedPortfolios"));
        vm0.invoke(this.loadRegion("PartionedPortfoliosWithHash"));
        vm0.invoke(this.loadRegion("PartitionedPortfoliosWithRange"));
        vm0.invoke(this.prIndexCreationCheck("PartionedPortfolios", "statusIndex", -1));
        vm0.invoke(this.prIndexCreationCheck("PartionedPortfoliosWithHash", "statusIndex", -1));
        vm0.invoke(this.prIndexCreationCheck("PartitionedPortfoliosWithRange", "statusIndex", -1));
        vm1.invoke(this.setTestHook());
        vm1.invoke(this.createIndexThrougXML("vm1testCreateIndexWhileDoingGII", "PartionedPortfolios", "IndexCreation.xml"));
        vm0.invoke(this.prIndexCreationCheck("PartionedPortfolios", "statusIndex", 50));
        vm1.invoke(this.prIndexCreationCheck("PartionedPortfolios", "statusIndex", 50));
        vm0.invoke(this.prIndexCreationCheck("PartionedPortfolios", "idIndex", 50));
        vm1.invoke(this.prIndexCreationCheck("PartionedPortfolios", "idIndex", 50));
        vm0.invoke(this.prIndexCreationCheck("PartionedPortfolios", "secIndex", 50));
        vm1.invoke(this.prIndexCreationCheck("PartionedPortfolios", "secIndex", 50));
        vm0.invoke(this.prIndexCreationCheck("PartitionedPortfoliosWithRange", "statusIndex", 50));
        vm1.invoke(this.prIndexCreationCheck("PartitionedPortfoliosWithRange", "statusIndex", 50));
        vm0.invoke(this.prIndexCreationCheck("PartitionedPortfoliosWithRange", "idIndex", 50));
        vm1.invoke(this.prIndexCreationCheck("PartitionedPortfoliosWithRange", "idIndex", 50));
        vm0.invoke(this.prIndexCreationCheck("PartionedPortfoliosWithHash", "statusIndex", 50));
        vm1.invoke(this.prIndexCreationCheck("PartionedPortfoliosWithHash", "statusIndex", 50));
        vm0.invoke(this.prIndexCreationCheck("PartionedPortfoliosWithHash", "idIndex", 50));
        vm1.invoke(this.prIndexCreationCheck("PartionedPortfoliosWithHash", "idIndex", 50));
        vm0.invoke(this.executeQuery("PartionedPortfolios"));
        vm1.invoke(this.executeQuery("PartionedPortfolios"));
        vm1.invoke(this.resetTestHook());
        vm0.invoke(this.close());
        vm1.invoke(this.close());
    }

    public void testReplicatedRegionCreateIndexWhileDoingGII() throws Exception {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        String fileName = "IndexCreation.xml";
        QueryIndexUsingXMLDUnitTest.getLogWriter().info("Creating index using an xml file name : IndexCreation.xml");
        vm0.invoke(this.createIndexThrougXML("vm0testRRegionCreateIndexWhileDoingGII", "Portfolios", "IndexCreation.xml"));
        vm0.invoke(this.loadRegion("Portfolios"));
        vm0.invoke(this.loadRegion("PortfoliosWithHash"));
        vm0.invoke(this.loadRegion("PortfoliosNoIndex"));
        vm0.invoke(this.indexCreationCheck("Portfolios", "statusIndex"));
        vm0.invoke(this.indexCreationCheck("PortfoliosWithHash", "statusIndex"));
        vm1.invoke(this.setTestHook());
        vm1.invoke(this.createIndexThrougXML("vm1testRRegionCreateIndexWhileDoingGII", "Portfolios", "IndexCreation.xml"));
        vm0.invoke(this.indexCreationCheck("Portfolios", "statusIndex"));
        vm1.invoke(this.indexCreationCheck("Portfolios", "statusIndex"));
        vm0.invoke(this.indexCreationCheck("Portfolios", "idIndex"));
        vm1.invoke(this.indexCreationCheck("Portfolios", "idIndex"));
        vm0.invoke(this.indexCreationCheck("Portfolios", "secIndex"));
        vm1.invoke(this.indexCreationCheck("Portfolios", "secIndex"));
        vm0.invoke(this.indexCreationCheck("PortfoliosWithHash", "statusIndex"));
        vm1.invoke(this.indexCreationCheck("PortfoliosWithHash", "statusIndex"));
        vm0.invoke(this.indexCreationCheck("PortfoliosWithHash", "idIndex"));
        vm1.invoke(this.indexCreationCheck("PortfoliosWithHash", "idIndex"));
        vm0.invoke(this.indexCreationCheck("PortfoliosWithHash", "secIndex"));
        vm1.invoke(this.indexCreationCheck("PortfoliosWithHash", "secIndex"));
        vm0.invoke(this.executeQuery("Portfolios"));
        vm1.invoke(this.executeQuery("Portfolios"));
        vm1.invoke(this.resetTestHook());
        vm0.invoke(this.close());
        vm1.invoke(this.close());
    }

    public void testPersistentPRRegionCreateIndexWhileDoingGII() throws Exception {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        String fileName = "IndexCreation.xml";
        QueryIndexUsingXMLDUnitTest.getLogWriter().info("Creating index using an xml file name : IndexCreation.xml");
        vm0.invoke(this.createIndexThrougXML("vm0testPersistentPRRegion", "PersistentPrPortfolios", "IndexCreation.xml"));
        vm0.invoke(this.loadRegion(this.persistentRegName));
        vm0.invoke(this.loadRegion("PortfoliosNoIndex"));
        vm0.invoke(this.loadRegion("PersistentPrPortfoliosWithHash"));
        vm0.invoke(this.prIndexCreationCheck("PersistentPrPortfolios", "statusIndex", -1));
        vm0.invoke(this.prIndexCreationCheck("PersistentPrPortfoliosWithHash", "statusIndex", -1));
        vm1.invoke(this.setTestHook());
        vm1.invoke(this.createIndexThrougXML("vm1testPersistentPRRegion", "PersistentPrPortfolios", "IndexCreation.xml"));
        vm0.invoke(this.prIndexCreationCheck("PersistentPrPortfolios", "statusIndex", 50));
        vm1.invoke(this.prIndexCreationCheck("PersistentPrPortfolios", "statusIndex", 50));
        vm0.invoke(this.prIndexCreationCheck("PersistentPrPortfolios", "idIndex", 50));
        vm1.invoke(this.prIndexCreationCheck("PersistentPrPortfolios", "idIndex", 50));
        vm0.invoke(this.prIndexCreationCheck("PersistentPrPortfolios", "secIndex", 50));
        vm1.invoke(this.prIndexCreationCheck("PersistentPrPortfolios", "secIndex", 50));
        vm0.invoke(this.prIndexCreationCheck("PersistentPrPortfoliosWithHash", "statusIndex", 50));
        vm1.invoke(this.prIndexCreationCheck("PersistentPrPortfoliosWithHash", "statusIndex", 50));
        vm0.invoke(this.prIndexCreationCheck("PersistentPrPortfoliosWithHash", "idIndex", 50));
        vm1.invoke(this.prIndexCreationCheck("PersistentPrPortfoliosWithHash", "idIndex", 50));
        vm0.invoke(this.prIndexCreationCheck("PersistentPrPortfoliosWithHash", "secIndex", 50));
        vm1.invoke(this.prIndexCreationCheck("PersistentPrPortfoliosWithHash", "secIndex", 50));
        vm0.invoke(this.executeQuery("PersistentPrPortfolios"));
        vm1.invoke(this.executeQuery("PersistentPrPortfolios"));
        vm1.invoke(this.resetTestHook());
        vm1.invoke(this.close());
        vm1.invoke(this.setTestHook());
        vm1.invoke(this.createIndexThrougXML("vm1testPersistentPRRegion", "PersistentPrPortfolios", "IndexCreation.xml"));
        vm1.invoke(this.prIndexCreationCheck("PersistentPrPortfolios", "statusIndex", 50));
        vm1.invoke(this.resetTestHook());
        vm0.invoke(this.close());
        vm1.invoke(this.close());
    }

    public void testCreateIndexWhileDoingGIIWithEmptyPRRegion() throws Exception {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        String fileName = "IndexCreation.xml";
        QueryIndexUsingXMLDUnitTest.getLogWriter().info("### in testCreateIndexWhileDoingGIIWithEmptyPRRegion.");
        vm0.invoke(this.createIndexThrougXML("vm0testGIIWithEmptyPRRegion", "PartionedPortfolios", "IndexCreation.xml"));
        vm0.invoke(this.prIndexCreationCheck("PartionedPortfolios", "statusIndex", -1));
        vm0.invoke(this.prIndexCreationCheck("PartionedPortfoliosWithHash", "statusIndex", -1));
        vm1.invoke(this.setTestHook());
        vm1.invoke(this.createIndexThrougXML("vm1testGIIWithEmptyPRRegion", "PartionedPortfolios", "IndexCreation.xml"));
        vm1.invoke(this.prIndexCreationCheck("PartionedPortfolios", "statusIndex", -1));
        vm1.invoke(this.prIndexCreationCheck("PartionedPortfoliosWithHash", "statusIndex", -1));
        vm0.invoke(this.loadRegion("PartionedPortfolios"));
        vm0.invoke(this.loadRegion("PartionedPortfoliosWithHash"));
        vm0.invoke(this.prIndexCreationCheck("PartionedPortfolios", "statusIndex", 50));
        vm1.invoke(this.prIndexCreationCheck("PartionedPortfolios", "statusIndex", 50));
        vm0.invoke(this.prIndexCreationCheck("PartionedPortfoliosWithHash", "statusIndex", 50));
        vm1.invoke(this.prIndexCreationCheck("PartionedPortfoliosWithHash", "statusIndex", 50));
        vm1.invoke(this.resetTestHook());
        vm0.invoke(this.close());
        vm1.invoke(this.close());
    }

    public void testCreateAsyncIndexWhileDoingGII() throws Exception {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        String fileName = "IndexCreation.xml";
        QueryIndexUsingXMLDUnitTest.getLogWriter().info("Creating index using an xml file name : IndexCreation.xml");
        AsyncInvocation asyInvk0 = vm0.invokeAsync(this.createIndexThrougXML("vm0testAsyncIndexWhileDoingGII", "PartionedPortfolios", "IndexCreation.xml"));
        DistributedTestCase.join(asyInvk0, 30000L, QueryIndexUsingXMLDUnitTest.getLogWriter());
        if (asyInvk0.exceptionOccurred()) {
            QueryIndexUsingXMLDUnitTest.fail("asyInvk0 failed", asyInvk0.getException());
        }
        asyInvk0 = vm0.invokeAsync(this.loadRegion("PartionedPortfolios"));
        vm1.invoke(this.setTestHook());
        AsyncInvocation asyInvk1 = vm1.invokeAsync(this.createIndexThrougXML("vm1testAsyncIndexWhileDoingGII", "PartionedPortfolios", "IndexCreation.xml"));
        vm0.invoke(this.prIndexCreationCheck("PartionedPortfolios", "statusIndex", 50));
        DistributedTestCase.join(asyInvk1, 30000L, QueryIndexUsingXMLDUnitTest.getLogWriter());
        if (asyInvk1.exceptionOccurred()) {
            QueryIndexUsingXMLDUnitTest.fail("asyInvk1 failed", asyInvk1.getException());
        }
        vm1.invoke(this.prIndexCreationCheck("PartionedPortfolios", "statusIndex", 50));
        DistributedTestCase.join(asyInvk0, 30000L, QueryIndexUsingXMLDUnitTest.getLogWriter());
        if (asyInvk0.exceptionOccurred()) {
            QueryIndexUsingXMLDUnitTest.fail("asyInvk0 failed", asyInvk0.getException());
        }
        vm1.invoke(this.resetTestHook());
        vm0.invoke(this.close());
        vm1.invoke(this.close());
    }

    public void testCreateIndexWhileDoingGIIAndCompareQueryResults() throws Exception {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        String fileName = "IndexCreation.xml";
        QueryIndexUsingXMLDUnitTest.getLogWriter().info("Creating index using an xml file name : IndexCreation.xml");
        vm0.invoke(this.createIndexThrougXML("vm0testIndexCompareQResults", "PartionedPortfolios", "IndexCreation.xml"));
        vm0.invoke(this.loadRegion("PartionedPortfolios"));
        vm0.invoke(this.loadRegion("Portfolios"));
        vm0.invoke(this.loadRegion("PersistentPrPortfolios"));
        vm0.invoke(this.loadRegion("PortfoliosNoIndex"));
        vm0.invoke(this.loadRegion("PartionedPortfoliosWithHash"));
        vm0.invoke(this.loadRegion("PortfoliosWithHash"));
        vm0.invoke(this.loadRegion("PersistentPrPortfoliosWithHash"));
        vm0.invoke(this.prIndexCreationCheck("PartionedPortfolios", "statusIndex", -1));
        vm1.invoke(this.setTestHook());
        vm1.invoke(this.createIndexThrougXML("vm1testIndexCompareQResults", "PartionedPortfolios", "IndexCreation.xml"));
        vm0.invoke(this.prIndexCreationCheck("PartionedPortfolios", "statusIndex", 50));
        vm1.invoke(this.prIndexCreationCheck("PartionedPortfolios", "statusIndex", 50));
        vm0.invoke(this.prIndexCreationCheck("PartionedPortfolios", "idIndex", 50));
        vm1.invoke(this.prIndexCreationCheck("PartionedPortfolios", "idIndex", 50));
        vm0.invoke(this.prIndexCreationCheck("PartionedPortfolios", "secIndex", 50));
        vm1.invoke(this.prIndexCreationCheck("PartionedPortfolios", "secIndex", 50));
        vm0.invoke(this.prIndexCreationCheck("PartionedPortfoliosWithHash", "statusIndex", 50));
        vm1.invoke(this.prIndexCreationCheck("PartionedPortfoliosWithHash", "statusIndex", 50));
        vm0.invoke(this.prIndexCreationCheck("PartionedPortfoliosWithHash", "idIndex", 50));
        vm1.invoke(this.prIndexCreationCheck("PartionedPortfoliosWithHash", "idIndex", 50));
        vm0.invoke(this.prIndexCreationCheck("PartionedPortfoliosWithHash", "secIndex", 50));
        vm1.invoke(this.prIndexCreationCheck("PartionedPortfoliosWithHash", "secIndex", 50));
        vm0.invoke(this.prIndexCreationCheck("PersistentPrPortfolios", "secIndex", 50));
        vm0.invoke(this.indexCreationCheck("Portfolios", "secIndex"));
        vm0.invoke(this.prIndexCreationCheck("PersistentPrPortfoliosWithHash", "secIndex", 50));
        vm0.invoke(this.indexCreationCheck("PortfoliosWithHash", "secIndex"));
        vm1.invoke(this.prIndexCreationCheck("PersistentPrPortfolios", "secIndex", 50));
        vm1.invoke(this.indexCreationCheck("Portfolios", "secIndex"));
        vm1.invoke(this.prIndexCreationCheck("PersistentPrPortfoliosWithHash", "secIndex", 50));
        vm1.invoke(this.indexCreationCheck("PortfoliosWithHash", "secIndex"));
        vm0.invoke(this.executeQueryAndCompareResult("PartionedPortfolios", true));
        vm1.invoke(this.executeQueryAndCompareResult("PartionedPortfolios", true));
        vm1.invoke(this.resetTestHook());
        vm0.invoke(this.close());
        vm1.invoke(this.close());
    }

    public void testCreateAsyncIndexWhileDoingGIIAndQuery() throws Exception {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        String fileName = "IndexCreation.xml";
        QueryIndexUsingXMLDUnitTest.getLogWriter().info("Creating index using an xml file name : IndexCreation.xml");
        AsyncInvocation asyInvk0 = vm0.invokeAsync(this.createIndexThrougXML("vm0testCreateAsyncIndexGIIAndQuery", "PartionedPortfolios", "IndexCreation.xml"));
        DistributedTestCase.join(asyInvk0, 30000L, QueryIndexUsingXMLDUnitTest.getLogWriter());
        if (asyInvk0.exceptionOccurred()) {
            QueryIndexUsingXMLDUnitTest.fail("asyInvk0 failed", asyInvk0.getException());
        }
        asyInvk0 = vm0.invokeAsync(this.loadRegion("PartionedPortfolios"));
        vm1.invoke(this.setTestHook());
        AsyncInvocation asyInvk1 = vm1.invokeAsync(this.createIndexThrougXML("vm1testCreateAsyncIndexGIIAndQuery", "PartionedPortfolios", "IndexCreation.xml"));
        DistributedTestCase.join(asyInvk1, 30000L, QueryIndexUsingXMLDUnitTest.getLogWriter());
        if (asyInvk1.exceptionOccurred()) {
            QueryIndexUsingXMLDUnitTest.fail("asyInvk1 failed", asyInvk1.getException());
        }
        DistributedTestCase.join(asyInvk0, 30000L, QueryIndexUsingXMLDUnitTest.getLogWriter());
        if (asyInvk0.exceptionOccurred()) {
            QueryIndexUsingXMLDUnitTest.fail("asyInvk0 failed", asyInvk0.getException());
        }
        vm0.invoke(this.prIndexCreationCheck("PartionedPortfolios", "statusIndex", 50));
        vm1.invoke(this.prIndexCreationCheck("PartionedPortfolios", "statusIndex", 50));
        vm0.invoke(this.executeQuery("PartionedPortfolios"));
        vm1.invoke(this.executeQuery("PartionedPortfolios"));
        vm1.invoke(this.resetTestHook());
        vm0.invoke(this.close());
        vm1.invoke(this.close());
    }

    public void testCreateAsyncIndexWhileDoingGIIAndCompareQueryResults() throws Exception {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        String fileName = "IndexCreation.xml";
        QueryIndexUsingXMLDUnitTest.getLogWriter().info("Creating index using an xml file name : IndexCreation.xml");
        vm0.invoke(this.createIndexThrougXML("vm0testAsyncIndexAndCompareQResults", "PartionedPortfolios", "IndexCreation.xml"));
        vm0.invoke(this.loadRegion("PartionedPortfolios"));
        vm0.invoke(this.loadRegion("Portfolios"));
        vm0.invoke(this.loadRegion("PersistentPrPortfolios"));
        vm0.invoke(this.loadRegion("PortfoliosNoIndex"));
        vm0.invokeAsync(this.loadRegion("PartionedPortfolios", 500));
        vm0.invokeAsync(this.loadRegion("Portfolios", 500));
        AsyncInvocation asyInvk0 = vm0.invokeAsync(this.loadRegion("PersistentPrPortfolios", 500));
        vm0.invokeAsync(this.loadRegion("PortfoliosNoIndex", 500));
        vm1.invoke(this.setTestHook());
        vm1.invoke(this.createIndexThrougXML("vm1testAsyncIndexAndCompareQResults", "PartionedPortfolios", "IndexCreation.xml"));
        DistributedTestCase.join(asyInvk0, 30000L, QueryIndexUsingXMLDUnitTest.getLogWriter());
        if (asyInvk0.exceptionOccurred()) {
            QueryIndexUsingXMLDUnitTest.fail("asyInvk0 failed", asyInvk0.getException());
        }
        vm1.invoke(this.prIndexCreationCheck("PersistentPrPortfolios", "secIndex", 50));
        vm1.invoke(this.indexCreationCheck("Portfolios", "secIndex"));
        vm0.invoke(this.executeQueryAndCompareResult("PartionedPortfolios", false));
        vm1.invoke(this.executeQueryAndCompareResult("PartionedPortfolios", false));
        vm1.invoke(this.resetTestHook());
        vm0.invoke(this.close());
        vm1.invoke(this.close());
    }

    public void testIndexCreationForReplicatedPersistentOverFlowRegionOnRestart() throws Exception {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        String fileName = "IndexCreation.xml";
        QueryIndexUsingXMLDUnitTest.getLogWriter().info("Creating index using an xml file name : IndexCreation.xml");
        vm0.invoke(this.createIndexThrougXML("vm0testIndexCreationForReplicatedPersistentOverFlowRegionOnRestart", this.persistentOverFlowRegName, "IndexCreation.xml"));
        vm0.invoke(this.indexCreationCheck(this.persistentOverFlowRegName, "statusIndex"));
        vm0.invoke(this.loadRegion(this.persistentOverFlowRegName));
        vm0.invoke(this.closeWithoutDeletingDiskStore());
        vm0.invoke(this.createIndexThrougXML("vm0testIndexCreationForReplicatedPersistentOverFlowRegionOnRestart", this.persistentOverFlowRegName, "IndexCreation.xml"));
        vm0.invoke(this.indexCreationCheck(this.persistentOverFlowRegName, "statusIndex"));
        vm0.invoke(this.close());
    }

    public CacheSerializableRunnable setTestHook() {
        CacheSerializableRunnable sr = new CacheSerializableRunnable("TestHook"){

            @Override
            public void run2() {
                class IndexTestHook
                implements IndexManager.TestHook {
                    public boolean indexCreatedAsPartOfGII;

                    IndexTestHook() {
                    }

                    public void hook(int spot) throws RuntimeException {
                        GemFireCacheImpl.getInstance().getLogger().fine("In IndexTestHook.hook(). hook() argument value is : " + spot);
                        if (spot == 1) {
                            throw new RuntimeException("Index is not created as part of Region GII.");
                        }
                    }
                }
                IndexManager.testHook = new IndexTestHook();
            }
        };
        return sr;
    }

    public CacheSerializableRunnable resetTestHook() {
        CacheSerializableRunnable sr = new CacheSerializableRunnable("TestHook"){

            @Override
            public void run2() {
                IndexManager.testHook = null;
            }
        };
        return sr;
    }

    public CacheSerializableRunnable createIndexThrougXML(String vmid, final String regionName, final String xmlFileName) {
        CacheSerializableRunnable sr = new CacheSerializableRunnable("RegionCreator"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run2() {
                try {
                    File file;
                    GemFireCacheImpl.testCacheXml = file = QueryIndexUsingXMLDUnitTest.this.findFile(xmlFileName);
                    QueryIndexUsingXMLDUnitTest.this.getSystem();
                    Cache cache = QueryIndexUsingXMLDUnitTest.this.getCache();
                    Region region = cache.getRegion(regionName);
                    if (region == null) {
                        TestCase.fail((String)("Region not found." + regionName));
                    }
                }
                finally {
                    GemFireCacheImpl.testCacheXml = null;
                }
            }
        };
        return sr;
    }

    public CacheSerializableRunnable prIndexCreationCheck(final String regionName, final String indexName, final int bucketCount) {
        CacheSerializableRunnable sr = new CacheSerializableRunnable("pr IndexCreationCheck" + regionName + " indexName :" + indexName){

            @Override
            public void run2() {
                Cache cache = QueryIndexUsingXMLDUnitTest.this.getCache();
                LogWriter logger = cache.getLogger();
                PartitionedRegion region = (PartitionedRegion)cache.getRegion(regionName);
                Map indexMap = region.getIndex();
                PartitionedIndex index = (PartitionedIndex)region.getIndex().get(indexName);
                if (index == null) {
                    TestCase.fail((String)("Index " + indexName + " Not Found for region " + regionName));
                }
                logger.info("Current number of buckets indexed : " + index.getNumberOfIndexedBuckets());
                if (bucketCount >= 0) {
                    QueryIndexUsingXMLDUnitTest.this.waitForIndexedBuckets(index, bucketCount);
                }
            }
        };
        return sr;
    }

    public CacheSerializableRunnable indexCreationCheck(final String regionName, final String indexName) {
        CacheSerializableRunnable sr = new CacheSerializableRunnable("IndexCreationCheck region: " + regionName + " indexName :" + indexName){

            @Override
            public void run2() {
                Cache cache = QueryIndexUsingXMLDUnitTest.this.getCache();
                LogWriter logger = cache.getLogger();
                LocalRegion region = (LocalRegion)cache.getRegion(regionName);
                Index index = region.getIndexManager().getIndex(indexName);
                if (index == null) {
                    TestCase.fail((String)("Index " + indexName + " Not Found for region name:" + regionName));
                }
            }
        };
        return sr;
    }

    public boolean waitForIndexedBuckets(final PartitionedIndex index, final int bucketCount) {
        DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                return index.getNumberOfIndexedBuckets() >= bucketCount;
            }

            @Override
            public String description() {
                return "Number of Indexed Bucket is less than the expected number. " + bucketCount;
            }
        };
        DistributedTestCase.waitForCriterion(ev, MAX_TIME, 200L, true);
        return true;
    }

    public CacheSerializableRunnable loadRegion(final String name) {
        CacheSerializableRunnable sr = new CacheSerializableRunnable("load region on " + name){

            @Override
            public void run2() {
                Cache cache = QueryIndexUsingXMLDUnitTest.this.getCache();
                LogWriter logger = cache.getLogger();
                Region region = cache.getRegion(name);
                for (int i = 0; i < 100; ++i) {
                    region.put((Object)("" + i), (Object)new Portfolio(i));
                }
            }
        };
        return sr;
    }

    public CacheSerializableRunnable loadRegion(final String name, final int size) {
        CacheSerializableRunnable sr = new CacheSerializableRunnable("LoadRegion: " + name + " size :" + size){

            @Override
            public void run2() {
                Cache cache = QueryIndexUsingXMLDUnitTest.this.getCache();
                LogWriter logger = cache.getLogger();
                Region region = cache.getRegion(name);
                for (int i = 0; i < size; ++i) {
                    region.put((Object)("" + i), (Object)new Portfolio(i));
                }
            }
        };
        return sr;
    }

    public CacheSerializableRunnable executeQuery(final String rname) {
        CacheSerializableRunnable sr = new CacheSerializableRunnable("execute query on " + rname){

            @Override
            public void run2() {
                QueryService qs = QueryIndexUsingXMLDUnitTest.this.getCache().getQueryService();
                QueryObserverImpl observer = new QueryObserverImpl();
                QueryObserverHolder.setInstance((QueryObserver)observer);
                String queryStr = "Select * from /" + rname + " where ID > 10";
                Query query = qs.newQuery(queryStr);
                try {
                    query.execute();
                }
                catch (Exception ex) {
                    TestCase.fail((String)"Failed to execute the query.");
                }
                if (!observer.isIndexesUsed) {
                    TestCase.fail((String)("Index not used for query. " + queryStr));
                }
            }
        };
        return sr;
    }

    public CacheSerializableRunnable executeQueryAndCompareResult(String rname, final boolean compareHash) {
        CacheSerializableRunnable sr = new CacheSerializableRunnable("execute query and compare results."){

            @Override
            public void run2() {
                QueryService qs = QueryIndexUsingXMLDUnitTest.this.getCache().getQueryService();
                StructSetOrResultsSet ssORrs = new StructSetOrResultsSet();
                Object[][] sr = new SelectResults[1][2];
                String[] s = new String[2];
                for (int j = 0; j < QueryIndexUsingXMLDUnitTest.this.queryStr.length; ++j) {
                    String[] queryArray = QueryIndexUsingXMLDUnitTest.this.queryStr[j];
                    int numQueriesToCheck = compareHash ? queryArray.length : 3;
                    for (int i = 0; i < numQueriesToCheck; ++i) {
                        QueryObserverImpl observer = new QueryObserverImpl();
                        QueryObserverHolder.setInstance((QueryObserver)observer);
                        s[0] = QueryIndexUsingXMLDUnitTest.this.queryStr[j][i];
                        Query query = qs.newQuery(s[0]);
                        try {
                            sr[0][0] = (SelectResults)query.execute();
                        }
                        catch (Exception ex) {
                            TestCase.fail((String)"Failed to execute the query.");
                        }
                        if (!observer.isIndexesUsed) {
                            TestCase.fail((String)("Index not used for query. " + s[0]));
                        }
                        s[1] = QueryIndexUsingXMLDUnitTest.this.queryStrNoIndex[j];
                        try {
                            query = qs.newQuery(s[1]);
                            sr[0][1] = (SelectResults)query.execute();
                        }
                        catch (Exception ex) {
                            TestCase.fail((String)"Failed to execute the query on no index region.");
                        }
                        DistributedTestCase.getLogWriter().info("Execute query : \n queryStr with index: " + s[0] + " \n queryStr without index: " + s[1]);
                        ssORrs.CompareQueryResultsWithoutAndWithIndexes(sr, 1, s);
                    }
                }
            }
        };
        return sr;
    }

    public CacheSerializableRunnable closeWithoutDeletingDiskStore() {
        CacheSerializableRunnable sr = new CacheSerializableRunnable("close"){

            @Override
            public void run2() {
                IndexManager.testHook = null;
                CacheTestCase.closeCache();
                CacheTestCase.disconnectFromDS();
            }
        };
        return sr;
    }

    public CacheSerializableRunnable close() {
        CacheSerializableRunnable sr = new CacheSerializableRunnable("close"){

            @Override
            public void run2() {
                IndexManager.testHook = null;
                GemFireCacheImpl cache = (GemFireCacheImpl)QueryIndexUsingXMLDUnitTest.this.getCache();
                String diskStoreName = cache.getDefaultDiskStoreName();
                CacheTestCase.closeCache();
                CacheTestCase.disconnectFromDS();
                File diskDir = new File(diskStoreName).getAbsoluteFile();
                try {
                    FileUtil.delete((File)diskDir);
                }
                catch (Exception ex) {
                    TestCase.fail((String)"Failed to delete the disDir");
                }
            }
        };
        return sr;
    }

    protected File findFile(String fileName) {
        File dir = new File(System.getProperty("JTESTS"));
        if (!dir.exists()) {
            String s = "Could not find JTESTS";
            throw new IllegalStateException(s);
        }
        String[] subdirs = new String[]{"com", "gemstone", "gemfire", "cache", "query", "dunit"};
        for (int i = 0; i < subdirs.length; ++i) {
            if ((dir = new File(dir, subdirs[i])).exists()) continue;
            String s = "Could not find " + dir;
            throw new IllegalStateException(s);
        }
        File file = new File(dir, fileName);
        return file;
    }

    public final InternalDistributedSystem getSystem(String diskStoreId) {
        new Exception("TEST DEBUG###" + diskStoreId).printStackTrace();
        if (system == null || !system.isConnected()) {
            Properties p = this.getAllDistributedSystemProperties(this.getDistributedSystemProperties());
            system = (InternalDistributedSystem)DistributedSystem.connect((Properties)p);
        }
        return system;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Cache getCache(InternalDistributedSystem system) {
        Cache cache = QueryIndexUsingXMLDUnitTest.basicGetCache();
        if (cache == null) {
            try {
                System.setProperty("gemfire.DISABLE_DISCONNECT_DS_ON_CACHE_CLOSE", "true");
                cache = CacheFactory.create((DistributedSystem)system);
            }
            catch (CacheExistsException e) {
                QueryIndexUsingXMLDUnitTest.fail("the cache already exists", e);
            }
            catch (RuntimeException ex) {
                throw ex;
            }
            catch (Exception ex) {
                QueryIndexUsingXMLDUnitTest.fail("Checked exception while initializing cache??", ex);
            }
            finally {
                System.clearProperty("gemfire.DISABLE_DISCONNECT_DS_ON_CACHE_CLOSE");
            }
        }
        return cache;
    }

    public static class QueryObserverImpl
    extends QueryObserverAdapter {
        boolean isIndexesUsed = false;
        ArrayList indexesUsed = new ArrayList();

        public void beforeIndexLookup(Index index, int oper, Object key) {
            this.indexesUsed.add(index.getName());
        }

        public void afterIndexLookup(Collection results) {
            if (results != null) {
                this.isIndexesUsed = true;
            }
        }
    }
}

