/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.query.dunit;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.PartitionResolver;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionService;
import com.gemstone.gemfire.cache.RegionShortcut;
import com.gemstone.gemfire.cache.client.ClientCache;
import com.gemstone.gemfire.cache.client.ClientCacheFactory;
import com.gemstone.gemfire.cache.client.ClientRegionShortcut;
import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.FunctionAdapter;
import com.gemstone.gemfire.cache.execute.FunctionContext;
import com.gemstone.gemfire.cache.execute.FunctionException;
import com.gemstone.gemfire.cache.execute.FunctionService;
import com.gemstone.gemfire.cache.execute.RegionFunctionContext;
import com.gemstone.gemfire.cache.execute.ResultCollector;
import com.gemstone.gemfire.cache.query.Query;
import com.gemstone.gemfire.cache.query.QueryInvocationTargetException;
import com.gemstone.gemfire.cache.query.QueryService;
import com.gemstone.gemfire.cache.query.SelectResults;
import com.gemstone.gemfire.cache.query.dunit.QueryAPITestPartitionResolver;
import com.gemstone.gemfire.cache.query.functional.StructSetOrResultsSet;
import com.gemstone.gemfire.cache.query.internal.DefaultQuery;
import com.gemstone.gemfire.cache.query.internal.IndexTrackingQueryObserver;
import com.gemstone.gemfire.cache.query.internal.QueryObserver;
import com.gemstone.gemfire.cache.query.internal.QueryObserverHolder;
import com.gemstone.gemfire.cache.query.partitioned.PRQueryDUnitHelper;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.internal.cache.BucketRegion;
import com.gemstone.gemfire.internal.cache.LocalDataSet;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.execute.PRClientServerTestBase;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableRunnable;
import dunit.VM;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import junit.framework.TestCase;

public class QueryUsingFunctionContextDUnitTest
extends CacheTestCase {
    private static final int cnt = 0;
    private static final int cntDest = 100;
    static VM server1 = null;
    static VM server2 = null;
    static VM server3 = null;
    static VM client = null;
    static Cache cache = null;
    static Function function = null;
    static String PartitionedRegionName1 = "TestPartitionedRegion1";
    static String PartitionedRegionName2 = "TestPartitionedRegion2";
    static String PartitionedRegionName3 = "TestPartitionedRegion3";
    static String PartitionedRegionName4 = "TestPartitionedRegion4";
    static String PartitionedRegionName5 = "TestPartitionedRegion5";
    static String repRegionName = "TestRepRegion";
    static String localRegionName = "TestLocalRegion";
    static Integer serverPort1 = null;
    static Integer serverPort2 = null;
    static Integer serverPort3 = null;
    public static int numOfBuckets = 20;
    public static String[] queries = new String[]{"select * from /" + PartitionedRegionName1 + " where ID>=0", "Select * from /" + PartitionedRegionName1 + " r1, /" + PartitionedRegionName2 + " r2 where r1.ID = r2.ID", "Select * from /" + PartitionedRegionName1 + " r1, /" + PartitionedRegionName2 + " r2 where r1.ID = r2.ID AND r1.status = r2.status", "Select * from /" + PartitionedRegionName1 + " r1, /" + PartitionedRegionName2 + " r2, /" + PartitionedRegionName3 + " r3 where r1.ID = r2.ID and r2.ID = r3.ID", "Select * from /" + PartitionedRegionName1 + " r1, /" + PartitionedRegionName2 + " r2, /" + PartitionedRegionName3 + " r3  , /" + repRegionName + " r4 where r1.ID = r2.ID and r2.ID = r3.ID and r3.ID = r4.ID", "Select * from /" + PartitionedRegionName4 + " r4 , /" + PartitionedRegionName5 + " r5 where r4.ID = r5.ID"};
    public static String[] nonColocatedQueries = new String[]{"Select * from /" + PartitionedRegionName1 + " r1, /" + PartitionedRegionName4 + " r4 where r1.ID = r4.ID", "Select * from /" + PartitionedRegionName1 + " r1, /" + PartitionedRegionName4 + " r4 , /" + PartitionedRegionName5 + " r5 where r1.ID = r42.ID and r4.ID = r5.ID"};
    public static String[] queriesForRR = new String[]{"<trace> select * from /" + repRegionName + " where ID>=0"};
    private static PRQueryDUnitHelper PRQHelp = new PRQueryDUnitHelper("");

    public QueryUsingFunctionContextDUnitTest(String name) {
        super(name);
    }

    @Override
    public void tearDown2() throws Exception {
        QueryUsingFunctionContextDUnitTest.invokeInEveryVM(CacheTestCase.class, "disconnectFromDS");
        super.tearDown2();
        QueryUsingFunctionContextDUnitTest.invokeInEveryVM(QueryObserverHolder.class, "reset");
        cache = null;
        QueryUsingFunctionContextDUnitTest.invokeInEveryVM(new SerializableRunnable(){

            @Override
            public void run() {
                cache = null;
            }
        });
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        Host host = Host.getHost(0);
        server1 = host.getVM(0);
        server2 = host.getVM(1);
        server3 = host.getVM(2);
        client = host.getVM(3);
        this.createServersWithRegions();
        this.fillValuesInRegions();
        this.registerFunctionOnServers();
    }

    public void testQueriesWithFilterKeysOnReplicatedRegion() {
        Object[][] r = new Object[queriesForRR.length][2];
        client.invoke(new CacheSerializableRunnable("Run function on RR"){

            @Override
            public void run2() throws CacheException {
                ResultCollector rcollector = null;
                for (int i = 0; i < queriesForRR.length; ++i) {
                    try {
                        function = new TestQueryFunction("queryFunctionOnRR");
                        rcollector = FunctionService.onRegion((Region)CacheFactory.getAnyInstance().getRegion(repRegionName)).withArgs((Object)queriesForRR[i]).execute(function);
                        TestCase.fail((String)"Function call did not fail for query with function context");
                        continue;
                    }
                    catch (FunctionException ex) {
                        if (ex.getCause() instanceof IllegalArgumentException) continue;
                        TestCase.fail((String)"Should have received an IllegalArgumentException");
                    }
                }
            }
        });
    }

    public void testQueriesWithFilterKeysOnPRLocal() {
        client.invoke(new CacheSerializableRunnable("Test query on client and server"){

            @Override
            public void run2() throws CacheException {
                HashSet<Integer> filter = new HashSet<Integer>();
                filter.add(0);
                for (int i = 0; i < queries.length; ++i) {
                    ArrayList queryResults1;
                    Object[][] r = new Object[1][2];
                    TestServerQueryFunction func = new TestServerQueryFunction("LDS Server function-1");
                    QueryUsingFunctionContextDUnitTest test = new QueryUsingFunctionContextDUnitTest("test");
                    function = new TestQueryFunction("queryFunction-1");
                    ArrayList queryResults2 = test.runQueryOnClientUsingFunc(function, PartitionedRegionName1, filter, queries[i]);
                    if (queryResults2 == null) {
                        TestCase.fail((String)(queries[i] + "result is null from client function"));
                    }
                    if ((queryResults1 = test.runLDSQueryOnClientUsingFunc((Function)func, filter, queries[i])) == null) {
                        TestCase.fail((String)(queries[i] + "result is null from LDS function"));
                    }
                    r[0][0] = queryResults1;
                    r[0][1] = queryResults2;
                    StructSetOrResultsSet ssORrs = new StructSetOrResultsSet();
                    ssORrs.CompareQueryResultsAsListWithoutAndWithIndexes(r, 1, false, new String[]{queries[i]});
                }
            }
        });
    }

    public void testQueriesWithFilterKeysOnPRLocalAndRemote() {
        client.invoke(new CacheSerializableRunnable("Test query on client and server"){

            @Override
            public void run2() throws CacheException {
                Set filter = QueryUsingFunctionContextDUnitTest.this.getFilter(0, 1);
                TestServerQueryFunction func = new TestServerQueryFunction("LDS Server function-1");
                function = new TestQueryFunction("queryFunction-2");
                for (int i = 0; i < queries.length; ++i) {
                    ArrayList queryResults1;
                    Object[][] r = new Object[1][2];
                    QueryUsingFunctionContextDUnitTest test = new QueryUsingFunctionContextDUnitTest("test");
                    ArrayList queryResults2 = test.runQueryOnClientUsingFunc(function, PartitionedRegionName1, filter, queries[i]);
                    if (queryResults2 == null) {
                        TestCase.fail((String)(queries[i] + "result is null from client function"));
                    }
                    if ((queryResults1 = test.runLDSQueryOnClientUsingFunc((Function)func, filter, queries[i])) == null) {
                        TestCase.fail((String)(queries[i] + "result is null from LDS function"));
                    }
                    r[0][0] = queryResults1;
                    r[0][1] = queryResults2;
                    StructSetOrResultsSet ssORrs = new StructSetOrResultsSet();
                    ssORrs.CompareQueryResultsAsListWithoutAndWithIndexes(r, 1, false, new String[]{queries[i]});
                }
            }
        });
    }

    public void testQueriesWithFilterKeysOnPRLocalAndRemoteWithBucketDestroy() {
        server1.invoke(new CacheSerializableRunnable("Set QueryObserver in cache on server1"){

            @Override
            public void run2() throws CacheException {
                class MyQueryObserver
                extends IndexTrackingQueryObserver {
                    MyQueryObserver() {
                    }

                    public void startQuery(Query query) {
                        if (query.getQueryString().contains("ID>=0")) {
                            Region pr = CacheFactory.getAnyInstance().getRegion(PartitionedRegionName1);
                            BucketRegion KeyRegion = null;
                            for (int i = 3; i < 7; ++i) {
                                KeyRegion = ((PartitionedRegion)pr).getBucketRegion((Object)i);
                                if (KeyRegion == null) continue;
                                KeyRegion.destroyRegion();
                            }
                        }
                    }
                }
                QueryObserverHolder.setInstance((QueryObserver)new MyQueryObserver());
            }
        });
        client.invoke(new CacheSerializableRunnable("Test query on client and server"){

            @Override
            public void run2() throws CacheException {
                Set filter = QueryUsingFunctionContextDUnitTest.this.getFilter(0, 2);
                TestServerQueryFunction func = new TestServerQueryFunction("LDS Server function-2");
                function = new TestQueryFunction("queryFunction");
                for (int i = 0; i < queries.length; ++i) {
                    QueryUsingFunctionContextDUnitTest test = new QueryUsingFunctionContextDUnitTest("test");
                    ArrayList queryResults2 = test.runQueryOnClientUsingFunc(function, PartitionedRegionName1, filter, queries[i]);
                    if (i != 0 || queryResults2.size() == 15) continue;
                    TestCase.fail((String)("Result size should have been 15 but was" + queryResults2.size()));
                }
            }
        });
        server1.invoke(new CacheSerializableRunnable("Reset Query Observer on server1"){

            @Override
            public void run2() throws CacheException {
                QueryObserverHolder.reset();
            }
        });
    }

    public void BUG46757WORKAROUNDtestQueriesWithFilterKeysOnPRWithBucketDestroy() {
        Object[][] r = new Object[queries.length][2];
        HashSet filter = new HashSet();
        server1.invoke(new CacheSerializableRunnable("Set QueryObserver in cache on server1"){

            @Override
            public void run2() throws CacheException {
                class MyQueryObserver
                extends IndexTrackingQueryObserver {
                    MyQueryObserver() {
                    }

                    public void startQuery(Query query) {
                        Region pr = CacheFactory.getAnyInstance().getRegion(PartitionedRegionName1);
                        BucketRegion KeyRegion = null;
                        for (int i = 0; i < 7; ++i) {
                            KeyRegion = ((PartitionedRegion)pr).getBucketRegion((Object)i);
                            if (KeyRegion == null) continue;
                            KeyRegion.destroyRegion();
                        }
                    }
                }
                QueryObserverHolder.setInstance((QueryObserver)new MyQueryObserver());
            }
        });
        client.invoke(new CacheSerializableRunnable("Run function on PR"){

            @Override
            public void run2() throws CacheException {
                HashSet filter = new HashSet();
                ResultCollector rcollector = null;
                filter.addAll(QueryUsingFunctionContextDUnitTest.this.getFilter(0, 19));
                for (int i = 0; i < queries.length; ++i) {
                    try {
                        function = new TestQueryFunction("queryFunctionBucketDestroy");
                        rcollector = FunctionService.onRegion((Region)CacheFactory.getAnyInstance().getRegion(PartitionedRegionName1)).withArgs((Object)queries[i]).withFilter(filter).execute(function);
                        TestCase.fail((String)"Function call did not fail for query with function context");
                        continue;
                    }
                    catch (FunctionException ex) {
                        if (ex.getCause() instanceof QueryInvocationTargetException) continue;
                        TestCase.fail((String)("Should have received an QueryInvocationTargetException but recieved" + ex.getMessage()));
                    }
                }
            }
        });
        server1.invoke(new CacheSerializableRunnable("Reset Query Observer on server1"){

            @Override
            public void run2() throws CacheException {
                QueryObserverHolder.reset();
            }
        });
    }

    public void testQueriesWithFilterKeysOnPRWithRebalancing() {
        Object[][] r = new Object[queries.length][2];
        HashSet filter = new HashSet();
        server1.invoke(new CacheSerializableRunnable("Set QueryObserver in cache on server1"){

            @Override
            public void run2() throws CacheException {
                class MyQueryObserver
                extends IndexTrackingQueryObserver {
                    MyQueryObserver() {
                    }

                    public void startQuery(Query query) {
                        Region pr = CacheFactory.getAnyInstance().getRegion(PartitionedRegionName1);
                        BucketRegion KeyRegion = null;
                        for (int i = 6; i < 9; ++i) {
                            KeyRegion = ((PartitionedRegion)pr).getBucketRegion((Object)i);
                            if (KeyRegion == null) continue;
                            KeyRegion.destroyRegion();
                        }
                    }
                }
                QueryObserverHolder.setInstance((QueryObserver)new MyQueryObserver());
            }
        });
        client.invoke(new CacheSerializableRunnable("Run function on PR"){

            @Override
            public void run2() throws CacheException {
                HashSet filter = new HashSet();
                ResultCollector rcollector = null;
                filter.addAll(QueryUsingFunctionContextDUnitTest.this.getFilter(6, 9));
                for (int i = 0; i < queries.length; ++i) {
                    try {
                        function = new TestQueryFunction("queryFunction");
                        rcollector = FunctionService.onRegion((Region)CacheFactory.getAnyInstance().getRegion(PartitionedRegionName1)).withArgs((Object)queries[i]).withFilter(filter).execute(function);
                        TestCase.fail((String)"Function call did not fail for query with function context");
                        continue;
                    }
                    catch (FunctionException ex) {
                        if (ex.getCause() instanceof QueryInvocationTargetException) continue;
                        TestCase.fail((String)("Should have received an QueryInvocationTargetException but recieved" + ex.getMessage()));
                    }
                }
            }
        });
        server1.invoke(new CacheSerializableRunnable("Reset Query Observer on server1"){

            @Override
            public void run2() throws CacheException {
                QueryObserverHolder.reset();
            }
        });
    }

    public void testNonColocatedRegionQueries() {
        client.invoke(new CacheSerializableRunnable("Test query on non-colocated regions on server"){

            @Override
            public void run2() throws CacheException {
                HashSet<Integer> filter = new HashSet<Integer>();
                filter.add(0);
                for (int i = 0; i < nonColocatedQueries.length; ++i) {
                    function = new TestQueryFunction("queryFunction-1");
                    QueryUsingFunctionContextDUnitTest test = new QueryUsingFunctionContextDUnitTest("test");
                    try {
                        ArrayList queryResults2 = test.runQueryOnClientUsingFunc(function, PartitionedRegionName1, filter, nonColocatedQueries[i]);
                        TestCase.fail((String)"Function call did not fail for query with function context");
                        continue;
                    }
                    catch (FunctionException e) {
                        if (e.getCause() instanceof UnsupportedOperationException) continue;
                        TestCase.fail((String)("Should have received an UnsupportedOperationException but received" + e.getMessage()));
                    }
                }
            }
        });
    }

    public void testJoinQueryPRWithMultipleIndexes() {
        server1.invoke(new CacheSerializableRunnable("Test query with indexes"){

            @Override
            public void run2() throws CacheException {
                int i;
                Set filter = QueryUsingFunctionContextDUnitTest.this.getFilter(0, 1);
                function = new TestQueryFunction("queryFunction-2");
                Object[][] r = new Object[2][2];
                QueryUsingFunctionContextDUnitTest test = new QueryUsingFunctionContextDUnitTest("test");
                int j = 0;
                for (i = 3; i < 5; ++i) {
                    ArrayList queryResults2 = test.runQueryOnClientUsingFunc(function, PartitionedRegionName1, filter, queries[i]);
                    if (queryResults2 == null) {
                        TestCase.fail((String)(queries[i] + "result is null from client function"));
                    }
                    r[j++][1] = queryResults2;
                }
                QueryUsingFunctionContextDUnitTest.this.createIndex();
                j = 0;
                for (i = 3; i < 5; ++i) {
                    ArrayList queryResults1 = test.runQueryOnClientUsingFunc(function, PartitionedRegionName1, filter, queries[i]);
                    if (queryResults1 == null) {
                        TestCase.fail((String)(queries[i] + "result is null from client function"));
                    }
                    r[j++][0] = queryResults1;
                }
                StructSetOrResultsSet ssORrs = new StructSetOrResultsSet();
                ssORrs.CompareQueryResultsAsListWithoutAndWithIndexes(r, 2, false, queries);
            }
        });
    }

    public void fillValuesInRegions() {
        Object[] portfolio = PRQHelp.createPortfoliosAndPositions(100);
        server1.invoke(this.getCacheSerializableRunnableForPRPuts(localRegionName, portfolio, 0, 100));
        server1.invoke(this.getCacheSerializableRunnableForPRPuts(repRegionName, portfolio, 0, 100));
        server1.invoke(this.getCacheSerializableRunnableForPRPuts(PartitionedRegionName1, portfolio, 0, 100));
        server1.invoke(this.getCacheSerializableRunnableForPRPuts(PartitionedRegionName2, portfolio, 0, 100));
        server1.invoke(this.getCacheSerializableRunnableForPRPuts(PartitionedRegionName3, portfolio, 0, 100));
        server1.invoke(this.getCacheSerializableRunnableForPRPuts(PartitionedRegionName4, portfolio, 0, 100));
        server1.invoke(this.getCacheSerializableRunnableForPRPuts(PartitionedRegionName5, portfolio, 0, 100));
    }

    private void registerFunctionOnServers() {
        function = new TestQueryFunction("queryFunction");
        server1.invoke(PRClientServerTestBase.class, "registerFunction", new Object[]{function});
        server2.invoke(PRClientServerTestBase.class, "registerFunction", new Object[]{function});
        server3.invoke(PRClientServerTestBase.class, "registerFunction", new Object[]{function});
    }

    private void createServersWithRegions() {
        Properties props = new Properties();
        server1.invoke(PRClientServerTestBase.class, "createCacheInVm", new Object[]{props});
        server2.invoke(PRClientServerTestBase.class, "createCacheInVm", new Object[]{props});
        server3.invoke(PRClientServerTestBase.class, "createCacheInVm", new Object[]{props});
        Integer port1 = (Integer)server1.invoke(PRClientServerTestBase.class, "createCacheServer");
        Integer port2 = (Integer)server2.invoke(PRClientServerTestBase.class, "createCacheServer");
        Integer port3 = (Integer)server3.invoke(PRClientServerTestBase.class, "createCacheServer");
        serverPort1 = port1;
        serverPort2 = port2;
        serverPort3 = port3;
        client.invoke(QueryUsingFunctionContextDUnitTest.class, "createCacheClientWithoutRegion", new Object[]{QueryUsingFunctionContextDUnitTest.getServerHostName(server1.getHost()), port1, port2, port3});
        client.invoke(QueryUsingFunctionContextDUnitTest.class, "createProxyRegions");
        server1.invoke(QueryUsingFunctionContextDUnitTest.class, "createLocalRegion");
        server1.invoke(QueryUsingFunctionContextDUnitTest.class, "createReplicatedRegion");
        server2.invoke(QueryUsingFunctionContextDUnitTest.class, "createReplicatedRegion");
        server3.invoke(QueryUsingFunctionContextDUnitTest.class, "createReplicatedRegion");
        server1.invoke(QueryUsingFunctionContextDUnitTest.class, "createColocatedPR");
        server2.invoke(QueryUsingFunctionContextDUnitTest.class, "createColocatedPR");
        server3.invoke(QueryUsingFunctionContextDUnitTest.class, "createColocatedPR");
    }

    public static void createProxyRegions() {
        new QueryUsingFunctionContextDUnitTest("temp").createProxyRegs();
    }

    private void createProxyRegs() {
        ClientCache cache = (ClientCache)CacheFactory.getAnyInstance();
        cache.createClientRegionFactory(ClientRegionShortcut.PROXY).create(repRegionName);
        cache.createClientRegionFactory(ClientRegionShortcut.PROXY).create(localRegionName);
        cache.createClientRegionFactory(ClientRegionShortcut.PROXY).create(PartitionedRegionName1);
        cache.createClientRegionFactory(ClientRegionShortcut.PROXY).create(PartitionedRegionName2);
        cache.createClientRegionFactory(ClientRegionShortcut.PROXY).create(PartitionedRegionName3);
        cache.createClientRegionFactory(ClientRegionShortcut.PROXY).create(PartitionedRegionName4);
        cache.createClientRegionFactory(ClientRegionShortcut.PROXY).create(PartitionedRegionName5);
    }

    public static void createLocalRegion() {
        new QueryUsingFunctionContextDUnitTest("temp").createLocalReg();
    }

    public void createLocalReg() {
        cache = CacheFactory.getAnyInstance();
        cache.createRegionFactory(RegionShortcut.LOCAL).create(localRegionName);
    }

    public static void createReplicatedRegion() {
        new QueryUsingFunctionContextDUnitTest("temp").createRR();
    }

    public void createRR() {
        cache = CacheFactory.getAnyInstance();
        cache.createRegionFactory(RegionShortcut.REPLICATE).create(repRegionName);
    }

    public static void createColocatedPR() {
        new QueryUsingFunctionContextDUnitTest("temp").createColoPR();
    }

    public void createColoPR() {
        QueryAPITestPartitionResolver testKeyBasedResolver = new QueryAPITestPartitionResolver();
        cache = CacheFactory.getAnyInstance();
        cache.createRegionFactory(RegionShortcut.PARTITION).setPartitionAttributes(new PartitionAttributesFactory().setTotalNumBuckets(numOfBuckets).setPartitionResolver((PartitionResolver)testKeyBasedResolver).create()).create(PartitionedRegionName1);
        cache.createRegionFactory(RegionShortcut.PARTITION).setPartitionAttributes(new PartitionAttributesFactory().setTotalNumBuckets(numOfBuckets).setPartitionResolver((PartitionResolver)testKeyBasedResolver).setColocatedWith(PartitionedRegionName1).create()).create(PartitionedRegionName2);
        cache.createRegionFactory(RegionShortcut.PARTITION).setPartitionAttributes(new PartitionAttributesFactory().setTotalNumBuckets(numOfBuckets).setPartitionResolver((PartitionResolver)testKeyBasedResolver).setColocatedWith(PartitionedRegionName2).create()).create(PartitionedRegionName3);
        cache.createRegionFactory(RegionShortcut.PARTITION).setPartitionAttributes(new PartitionAttributesFactory().setTotalNumBuckets(numOfBuckets).setPartitionResolver((PartitionResolver)testKeyBasedResolver).create()).create(PartitionedRegionName4);
        cache.createRegionFactory(RegionShortcut.PARTITION).setPartitionAttributes(new PartitionAttributesFactory().setTotalNumBuckets(numOfBuckets).setPartitionResolver((PartitionResolver)testKeyBasedResolver).setColocatedWith(PartitionedRegionName4).create()).create(PartitionedRegionName5);
    }

    public static void createCacheClientWithoutRegion(String host, Integer port1, Integer port2, Integer port3) {
        new QueryUsingFunctionContextDUnitTest("temp").createCacheClientWithoutReg(host, port1, port2, port3);
    }

    private void createCacheClientWithoutReg(String host, Integer port1, Integer port2, Integer port3) {
        this.disconnectFromDS();
        ClientCache cache = new ClientCacheFactory().addPoolServer(host, port1.intValue()).addPoolServer(host, port2.intValue()).addPoolServer(host, port3.intValue()).create();
    }

    public static ArrayList runQueryOnServerLocalDataSet(String query, Set filter) {
        return new QueryUsingFunctionContextDUnitTest("temp").runQueryOnServerLDS(query, filter);
    }

    protected ArrayList runQueryOnServerLDS(String queryStr, Set filter) {
        Set buckets = this.getBucketsForFilter(filter);
        LocalDataSet localDataSet = new LocalDataSet((PartitionedRegion)CacheFactory.getAnyInstance().getRegion(PartitionedRegionName1), buckets, null);
        QueryService qservice = CacheFactory.getAnyInstance().getQueryService();
        Query query = qservice.newQuery(queryStr);
        try {
            SelectResults results = (SelectResults)localDataSet.executeQuery((DefaultQuery)query, null, buckets);
            return (ArrayList)results.asList();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static ArrayList runQueryOnServerRegion(String query) {
        return new QueryUsingFunctionContextDUnitTest("temp").runQueryOnServerReg(query);
    }

    protected ArrayList runQueryOnServerReg(String queryStr) {
        QueryService qservice = CacheFactory.getAnyInstance().getQueryService();
        Query query = qservice.newQuery(queryStr);
        SelectResults results = null;
        try {
            results = (SelectResults)query.execute();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return results != null ? (ArrayList)results.asList() : null;
    }

    public static ArrayList runQueryOnClientUsingFunction(Function function, String regionName, Set filter, String query) {
        return new QueryUsingFunctionContextDUnitTest("temp").runQueryOnClientUsingFunc(function, regionName, filter, query);
    }

    private ArrayList runQueryOnClientUsingFunc(Function func, String regionName, Set filter, String query) {
        ResultCollector rcollector = null;
        rcollector = filter != null ? FunctionService.onRegion((Region)CacheFactory.getAnyInstance().getRegion(regionName)).withArgs((Object)query).withFilter(filter).execute(func) : FunctionService.onRegion((Region)CacheFactory.getAnyInstance().getRegion(regionName)).withArgs((Object)query).execute(func);
        Object result = rcollector.getResult();
        QueryUsingFunctionContextDUnitTest.assertTrue((boolean)(result instanceof ArrayList));
        ArrayList resultList = (ArrayList)result;
        resultList.trimToSize();
        ArrayList queryResults = null;
        if (resultList.size() != 0 && resultList.get(0) instanceof ArrayList) {
            queryResults = new ArrayList();
            for (Object obj : resultList) {
                if (obj == null) continue;
                queryResults.addAll((ArrayList)obj);
            }
        }
        return queryResults;
    }

    private ArrayList runLDSQueryOnClientUsingFunc(Function func, Set filter, String query) {
        ResultCollector rcollector = null;
        rcollector = FunctionService.onServer((RegionService)ClientCacheFactory.getAnyInstance()).withArgs((Object)new Object[]{query, filter}).execute(func);
        Object result = rcollector.getResult();
        QueryUsingFunctionContextDUnitTest.assertTrue((boolean)(result instanceof ArrayList));
        ArrayList resultList = (ArrayList)result;
        resultList.trimToSize();
        ArrayList queryResults = new ArrayList();
        if (resultList.size() != 0 && resultList.get(0) instanceof ArrayList) {
            for (Object obj : resultList) {
                if (obj == null) continue;
                queryResults.addAll((ArrayList)obj);
            }
        }
        return queryResults;
    }

    private Set getFilter(int start, int end) {
        HashSet<Integer> filter = new HashSet<Integer>();
        for (int j = start; j <= end; ++j) {
            filter.add(j);
        }
        return filter;
    }

    private Set getBucketsForFilter(Set filter) {
        HashSet<Integer> bucketids = new HashSet<Integer>();
        for (Object key : filter) {
            int intKey = (Integer)key;
            bucketids.add(intKey % numOfBuckets);
        }
        return bucketids;
    }

    public CacheSerializableRunnable getCacheSerializableRunnableForPRPuts(final String regionName, final Object[] portfolio, final int from, final int to) {
        CacheSerializableRunnable puts = new CacheSerializableRunnable("Region Puts"){

            @Override
            public void run2() throws CacheException {
                Cache cache = CacheFactory.getAnyInstance();
                Region region = cache.getRegion(regionName);
                for (int j = from; j < to; ++j) {
                    region.put((Object)new Integer(j), portfolio[j]);
                }
                DistributedTestCase.getLogWriter().info("PRQueryDUnitHelper#getCacheSerializableRunnableForPRPuts: Inserted Portfolio data on Region " + regionName);
            }
        };
        return puts;
    }

    public void createIndex() {
        QueryService qs = CacheFactory.getAnyInstance().getQueryService();
        try {
            qs.createIndex("ID1", "ID", "/" + PartitionedRegionName1);
            qs.createIndex("ID2", "ID", "/" + PartitionedRegionName2);
            qs.createIndex("ID3", "ID", "/" + PartitionedRegionName3);
        }
        catch (Exception e) {
            QueryUsingFunctionContextDUnitTest.fail((String)("Index creation failed " + e));
        }
    }

    public class TestServerQueryFunction
    extends FunctionAdapter {
        private final String id;

        public boolean hasResult() {
            return true;
        }

        public boolean isHA() {
            return false;
        }

        public TestServerQueryFunction(String id) {
            this.id = id;
        }

        public void execute(FunctionContext context) {
            Cache cache = CacheFactory.getAnyInstance();
            QueryService queryService = cache.getQueryService();
            ArrayList allQueryResults = new ArrayList();
            Object[] args = (Object[])context.getArguments();
            Set buckets = this.getBucketsForFilter((Set)args[1]);
            LocalDataSet localDataSet = new LocalDataSet((PartitionedRegion)CacheFactory.getAnyInstance().getRegion(PartitionedRegionName1), buckets, null);
            try {
                Query query = queryService.newQuery((String)args[0]);
                context.getResultSender().lastResult((Object)((ArrayList)((SelectResults)localDataSet.executeQuery((DefaultQuery)query, null, buckets)).asList()));
            }
            catch (Exception e) {
                throw new FunctionException((Throwable)e);
            }
        }

        public String getId() {
            return this.id;
        }

        private Set getBucketsForFilter(Set filter) {
            HashSet<Integer> bucketids = new HashSet<Integer>();
            for (Object key : filter) {
                int intKey = (Integer)key;
                bucketids.add(intKey % numOfBuckets);
            }
            return bucketids;
        }
    }

    public class TestQueryFunction
    extends FunctionAdapter {
        private final String id;

        public boolean hasResult() {
            return true;
        }

        public boolean isHA() {
            return false;
        }

        public TestQueryFunction(String id) {
            this.id = id;
        }

        public void execute(FunctionContext context) {
            Cache cache = CacheFactory.getAnyInstance();
            QueryService queryService = cache.getQueryService();
            ArrayList allQueryResults = new ArrayList();
            String qstr = (String)context.getArguments();
            try {
                Query query = queryService.newQuery(qstr);
                context.getResultSender().lastResult((Object)((ArrayList)((SelectResults)query.execute((RegionFunctionContext)context)).asList()));
            }
            catch (Exception e) {
                throw new FunctionException((Throwable)e);
            }
        }

        public String getId() {
            return this.id;
        }
    }
}

