/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.query.dunit;

import cacheRunner.Portfolio;
import cacheRunner.Position;
import com.gemstone.gemfire.DataSerializable;
import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.client.PoolFactory;
import com.gemstone.gemfire.cache.client.PoolManager;
import com.gemstone.gemfire.cache.query.IndexType;
import com.gemstone.gemfire.cache.query.Query;
import com.gemstone.gemfire.cache.query.QueryService;
import com.gemstone.gemfire.cache.query.SelectResults;
import com.gemstone.gemfire.cache.query.Struct;
import com.gemstone.gemfire.cache.query.internal.DefaultQuery;
import com.gemstone.gemfire.cache.query.internal.QueryObserver;
import com.gemstone.gemfire.cache.query.internal.QueryObserverAdapter;
import com.gemstone.gemfire.cache.query.internal.QueryObserverHolder;
import com.gemstone.gemfire.cache.query.types.ObjectType;
import com.gemstone.gemfire.cache.util.BridgeServer;
import com.gemstone.gemfire.cache30.BridgeTestCase;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheClientNotifier;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableRunnable;
import dunit.VM;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import junit.framework.TestCase;

public class QueryUsingPoolDUnitTest
extends CacheTestCase {
    private static int bridgeServerPort;
    final String rootRegionName = "root";
    private final String regionName = this.getName();
    private final String regName = "/root/" + this.regionName;
    private final String[] queryString = new String[]{"SELECT itr.value FROM " + this.regName + ".entries itr where itr.key = $1", "SELECT DISTINCT * FROM " + this.regName + " WHERE id < $1 ORDER BY id", "SELECT DISTINCT * FROM " + this.regName + " WHERE id < $1 ORDER BY $2", "(SELECT DISTINCT * FROM " + this.regName + " WHERE id < $1).size", "SELECT * FROM " + this.regName + " WHERE id = $1 and Ticker = $2", "SELECT * FROM " + this.regName + " WHERE id < $1 and Ticker = $2"};

    public QueryUsingPoolDUnitTest(String name) {
        super(name);
    }

    public static void caseSetUp() throws Exception {
        QueryUsingPoolDUnitTest.disconnectAllFromDS();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tearDown2() throws Exception {
        try {
            super.tearDown2();
        }
        finally {
            QueryUsingPoolDUnitTest.disconnectAllFromDS();
        }
    }

    public void createPool(VM vm, String poolName, String server, int port, boolean subscriptionEnabled) {
        this.createPool(vm, poolName, new String[]{server}, new int[]{port}, subscriptionEnabled);
    }

    public void createPool(VM vm, String poolName, String server, int port) {
        this.createPool(vm, poolName, new String[]{server}, new int[]{port}, false);
    }

    public void createPool(VM vm, final String poolName, final String[] servers, final int[] ports, final boolean subscriptionEnabled) {
        vm.invoke(new CacheSerializableRunnable("createPool :" + poolName){

            @Override
            public void run2() throws CacheException {
                QueryUsingPoolDUnitTest.this.getCache();
                PoolFactory cpf = PoolManager.createFactory();
                cpf.setSubscriptionEnabled(subscriptionEnabled);
                for (int i = 0; i < servers.length; ++i) {
                    DistributedTestCase.getLogWriter().info("### Adding to Pool. ### Server : " + servers[i] + " Port : " + ports[i]);
                    cpf.addServer(servers[i], ports[i]);
                }
                cpf.create(poolName);
            }
        });
    }

    public void validateCompiledQuery(VM vm, final long compiledQueryCount) {
        vm.invoke(new CacheSerializableRunnable("validate compiled query."){

            @Override
            public void run2() throws CacheException {
                long count = 0L;
                for (int i = 0; i < 100 && (count = CacheClientNotifier.getInstance().getStats().getCompiledQueryCount()) != compiledQueryCount; ++i) {
                    DistributedTestCase.pause(100);
                }
                TestCase.assertEquals((long)compiledQueryCount, (long)count);
            }
        });
    }

    public void testRemoteImportQueries() throws CacheException {
        final String name = this.getName();
        String rootRegionName = "root";
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        int numberOfEntries = 100;
        vm0.invoke(new CacheSerializableRunnable("Create Bridge Server"){

            @Override
            public void run2() throws CacheException {
                Properties config = new Properties();
                int unusedPort = AvailablePort.getRandomAvailablePort((int)1);
                config.setProperty("mcast-port", String.valueOf(unusedPort));
                DistributedTestCase.system = (InternalDistributedSystem)DistributedSystem.connect((Properties)config);
                AttributesFactory factory = new AttributesFactory();
                factory.setScope(Scope.LOCAL);
                QueryUsingPoolDUnitTest.this.createRegion(name, "root", factory.create());
                DistributedTestCase.pause(1000);
                try {
                    QueryUsingPoolDUnitTest.this.startBridgeServer(0, false);
                }
                catch (Exception ex) {
                    DistributedTestCase.fail("While starting CacheServer", ex);
                }
            }
        });
        vm0.invoke(new CacheSerializableRunnable("Create Bridge Server"){

            @Override
            public void run2() throws CacheException {
                Region region = QueryUsingPoolDUnitTest.this.getRootRegion().getSubregion(name);
                for (int i = 0; i < 100; ++i) {
                    region.put((Object)("key-" + i), (Object)new TestObject(i, "ibm"));
                }
            }
        });
        int port = vm0.invokeInt(QueryUsingPoolDUnitTest.class, "getCacheServerPort");
        String host0 = QueryUsingPoolDUnitTest.getServerHostName(vm0.getHost());
        final String regionName = "/root/" + name;
        String poolName = "testRemoteImportQueries";
        this.createPool(vm1, "testRemoteImportQueries", host0, port);
        vm1.invoke(new CacheSerializableRunnable("Execute queries"){

            @Override
            public void run2() throws CacheException {
                Query query;
                String queryString = null;
                SelectResults results = null;
                QueryService qService = null;
                try {
                    qService = PoolManager.find((String)"testRemoteImportQueries").getQueryService();
                }
                catch (Exception e) {
                    DistributedTestCase.fail("Failed to get QueryService.", e);
                }
                queryString = "import com.gemstone.gemfire.admin.QueryUsingPoolDUnitTest.TestObject; select distinct * from " + regionName;
                try {
                    query = qService.newQuery(queryString);
                    results = (SelectResults)query.execute();
                }
                catch (Exception e) {
                    DistributedTestCase.fail("Failed executing " + queryString, e);
                }
                TestCase.assertEquals((int)100, (int)results.size());
                TestCase.assertTrue((!results.getCollectionType().allowsDuplicates() ? 1 : 0) != 0);
                queryString = "import com.gemstone.gemfire.admin.QueryUsingPoolDUnitTest.TestObject; select distinct * from " + regionName + " where ticker = 'ibm'";
                try {
                    query = qService.newQuery(queryString);
                    results = (SelectResults)query.execute();
                }
                catch (Exception e) {
                    DistributedTestCase.fail("Failed executing " + queryString, e);
                }
                TestCase.assertEquals((int)100, (int)results.size());
                TestCase.assertTrue((!results.getCollectionType().allowsDuplicates() ? 1 : 0) != 0);
                queryString = "import com.gemstone.gemfire.admin.QueryUsingPoolDUnitTest.TestObject; select distinct * from " + regionName + " where ticker = 'IBM'";
                try {
                    query = qService.newQuery(queryString);
                    results = (SelectResults)query.execute();
                }
                catch (Exception e) {
                    DistributedTestCase.fail("Failed executing " + queryString, e);
                }
                TestCase.assertEquals((int)0, (int)results.size());
                TestCase.assertTrue((!results.getCollectionType().allowsDuplicates() ? 1 : 0) != 0);
                queryString = "import com.gemstone.gemfire.admin.QueryUsingPoolDUnitTest.TestObject; select distinct * from " + regionName + " where price > 49";
                try {
                    query = qService.newQuery(queryString);
                    results = (SelectResults)query.execute();
                }
                catch (Exception e) {
                    DistributedTestCase.fail("Failed executing " + queryString, e);
                }
                TestCase.assertEquals((int)50, (int)results.size());
                TestCase.assertTrue((!results.getCollectionType().allowsDuplicates() ? 1 : 0) != 0);
                queryString = "import com.gemstone.gemfire.admin.QueryUsingPoolDUnitTest.TestObject; select distinct * from " + regionName + " where price = 50";
                try {
                    query = qService.newQuery(queryString);
                    results = (SelectResults)query.execute();
                }
                catch (Exception e) {
                    DistributedTestCase.fail("Failed executing " + queryString, e);
                }
                TestCase.assertEquals((int)1, (int)results.size());
                TestCase.assertTrue((!results.getCollectionType().allowsDuplicates() ? 1 : 0) != 0);
                queryString = "import com.gemstone.gemfire.admin.QueryUsingPoolDUnitTest.TestObject; select distinct * from " + regionName + " where ticker = 'ibm' and price = 50";
                try {
                    query = qService.newQuery(queryString);
                    results = (SelectResults)query.execute();
                }
                catch (Exception e) {
                    DistributedTestCase.fail("Failed executing " + queryString, e);
                }
                TestCase.assertEquals((int)1, (int)results.size());
                TestCase.assertTrue((!results.getCollectionType().allowsDuplicates() ? 1 : 0) != 0);
            }
        });
        vm0.invoke(new SerializableRunnable("Stop CacheServer"){

            @Override
            public void run() {
                QueryUsingPoolDUnitTest.this.stopBridgeServer(QueryUsingPoolDUnitTest.this.getCache());
            }
        });
    }

    public void testRemoteStructQueries() throws CacheException {
        final String name = this.getName();
        String rootRegionName = "root";
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        int numberOfEntries = 100;
        vm0.invoke(new CacheSerializableRunnable("Create Bridge Server"){

            @Override
            public void run2() throws CacheException {
                Properties config = new Properties();
                int unusedPort = AvailablePort.getRandomAvailablePort((int)1);
                config.setProperty("mcast-port", String.valueOf(unusedPort));
                DistributedTestCase.system = (InternalDistributedSystem)DistributedSystem.connect((Properties)config);
                AttributesFactory factory = new AttributesFactory();
                factory.setScope(Scope.LOCAL);
                QueryUsingPoolDUnitTest.this.createRegion(name, factory.create());
                DistributedTestCase.pause(1000);
                try {
                    QueryUsingPoolDUnitTest.this.startBridgeServer(0, false);
                }
                catch (Exception ex) {
                    DistributedTestCase.fail("While starting CacheServer", ex);
                }
            }
        });
        vm0.invoke(new CacheSerializableRunnable("Create Bridge Server"){

            @Override
            public void run2() throws CacheException {
                Region region = QueryUsingPoolDUnitTest.this.getRootRegion().getSubregion(name);
                for (int i = 0; i < 100; ++i) {
                    region.put((Object)("key-" + i), (Object)new TestObject(i, "ibm"));
                }
            }
        });
        int port = vm0.invokeInt(QueryUsingPoolDUnitTest.class, "getCacheServerPort");
        String host0 = QueryUsingPoolDUnitTest.getServerHostName(vm0.getHost());
        final String regionName = "/root/" + name;
        String poolName = "testRemoteStructQueries";
        this.createPool(vm1, "testRemoteStructQueries", host0, port);
        vm1.invoke(new CacheSerializableRunnable("Execute queries"){

            @Override
            public void run2() throws CacheException {
                Query query;
                String queryString = null;
                SelectResults results = null;
                QueryService qService = null;
                try {
                    qService = PoolManager.find((String)"testRemoteStructQueries").getQueryService();
                }
                catch (Exception e) {
                    DistributedTestCase.fail("Failed to get QueryService.", e);
                }
                queryString = "import com.gemstone.gemfire.admin.QueryUsingPoolDUnitTest.TestObject; select distinct ticker, price from " + regionName;
                try {
                    query = qService.newQuery(queryString);
                    results = (SelectResults)query.execute();
                }
                catch (Exception e) {
                    DistributedTestCase.fail("Failed executing " + queryString, e);
                }
                TestCase.assertEquals((int)100, (int)results.size());
                TestCase.assertTrue((!results.getCollectionType().allowsDuplicates() && results.getCollectionType().getElementType().isStructType() ? 1 : 0) != 0);
                queryString = "import com.gemstone.gemfire.admin.QueryUsingPoolDUnitTest.TestObject; select distinct ticker, price from " + regionName + " where ticker = 'ibm'";
                try {
                    query = qService.newQuery(queryString);
                    results = (SelectResults)query.execute();
                }
                catch (Exception e) {
                    DistributedTestCase.fail("Failed executing " + queryString, e);
                }
                TestCase.assertEquals((int)100, (int)results.size());
                TestCase.assertTrue((!results.getCollectionType().allowsDuplicates() && results.getCollectionType().getElementType().isStructType() ? 1 : 0) != 0);
                queryString = "import com.gemstone.gemfire.admin.QueryUsingPoolDUnitTest.TestObject; select distinct ticker, price from " + regionName + " where ticker = 'IBM'";
                try {
                    query = qService.newQuery(queryString);
                    results = (SelectResults)query.execute();
                }
                catch (Exception e) {
                    DistributedTestCase.fail("Failed executing " + queryString, e);
                }
                TestCase.assertEquals((int)0, (int)results.size());
                TestCase.assertTrue((!results.getCollectionType().allowsDuplicates() && results.getCollectionType().getElementType().isStructType() ? 1 : 0) != 0);
                queryString = "import com.gemstone.gemfire.admin.QueryUsingPoolDUnitTest.TestObject; select distinct ticker, price from " + regionName + " where price > 49";
                try {
                    query = qService.newQuery(queryString);
                    results = (SelectResults)query.execute();
                }
                catch (Exception e) {
                    DistributedTestCase.fail("Failed executing " + queryString, e);
                }
                TestCase.assertEquals((int)50, (int)results.size());
                TestCase.assertTrue((!results.getCollectionType().allowsDuplicates() && results.getCollectionType().getElementType().isStructType() ? 1 : 0) != 0);
                queryString = "import com.gemstone.gemfire.admin.QueryUsingPoolDUnitTest.TestObject; select distinct ticker, price from " + regionName + " where price = 50";
                try {
                    query = qService.newQuery(queryString);
                    results = (SelectResults)query.execute();
                }
                catch (Exception e) {
                    DistributedTestCase.fail("Failed executing " + queryString, e);
                }
                TestCase.assertEquals((int)1, (int)results.size());
                TestCase.assertTrue((!results.getCollectionType().allowsDuplicates() && results.getCollectionType().getElementType().isStructType() ? 1 : 0) != 0);
                queryString = "import com.gemstone.gemfire.admin.QueryUsingPoolDUnitTest.TestObject; select distinct ticker, price from " + regionName + " where ticker = 'ibm' and price = 50";
                try {
                    query = qService.newQuery(queryString);
                    results = (SelectResults)query.execute();
                }
                catch (Exception e) {
                    DistributedTestCase.fail("Failed executing " + queryString, e);
                }
                TestCase.assertEquals((int)1, (int)results.size());
                TestCase.assertTrue((!results.getCollectionType().allowsDuplicates() && results.getCollectionType().getElementType().isStructType() ? 1 : 0) != 0);
            }
        });
        vm0.invoke(new SerializableRunnable("Stop CacheServer"){

            @Override
            public void run() {
                QueryUsingPoolDUnitTest.this.stopBridgeServer(QueryUsingPoolDUnitTest.this.getCache());
            }
        });
    }

    public void __testRemoteComplexQueries() throws CacheException {
        final String name = this.getName();
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        vm0.invoke(new CacheSerializableRunnable("Create Bridge Server"){

            @Override
            public void run2() throws CacheException {
                Properties config = new Properties();
                int unusedPort = AvailablePort.getRandomAvailablePort((int)1);
                config.setProperty("mcast-port", String.valueOf(unusedPort));
                DistributedTestCase.system = (InternalDistributedSystem)DistributedSystem.connect((Properties)config);
                AttributesFactory factory = new AttributesFactory();
                factory.setScope(Scope.LOCAL);
                QueryUsingPoolDUnitTest.this.createRegion(name, factory.create());
                DistributedTestCase.pause(1000);
                try {
                    QueryUsingPoolDUnitTest.this.startBridgeServer(0, false);
                }
                catch (Exception ex) {
                    DistributedTestCase.fail("While starting CacheServer", ex);
                }
            }
        });
        vm0.invoke(new CacheSerializableRunnable("Create Bridge Server"){

            @Override
            public void run2() throws CacheException {
                Region region = QueryUsingPoolDUnitTest.this.getRootRegion().getSubregion(name);
                Portfolio portfolio = null;
                Position position1 = null;
                Position position2 = null;
                Properties portfolioProperties = null;
                Properties position1Properties = null;
                Properties position2Properties = null;
                portfolio = new Portfolio();
                portfolioProperties = new Properties();
                portfolioProperties.put("id", new Integer(1));
                portfolioProperties.put("type", "type1");
                portfolioProperties.put("status", "active");
                position1 = new Position();
                position1Properties = new Properties();
                position1Properties.put("secId", "SUN");
                position1Properties.put("qty", new Double(34000.0));
                position1Properties.put("mktValue", new Double(24.42));
                position1.init(position1Properties);
                portfolioProperties.put("position1", position1);
                position2 = new Position();
                position2Properties = new Properties();
                position2Properties.put("secId", "IBM");
                position2Properties.put("qty", new Double(8765.0));
                position2Properties.put("mktValue", new Double(34.29));
                position2.init(position2Properties);
                portfolioProperties.put("position2", position2);
                portfolio.init(portfolioProperties);
                region.put((Object)new Integer(1), (Object)portfolio);
                portfolio = new Portfolio();
                portfolioProperties = new Properties();
                portfolioProperties.put("id", new Integer(2));
                portfolioProperties.put("type", "type2");
                portfolioProperties.put("status", "inactive");
                position1 = new Position();
                position1Properties = new Properties();
                position1Properties.put("secId", "YHOO");
                position1Properties.put("qty", new Double(9834.0));
                position1Properties.put("mktValue", new Double(12.925));
                position1.init(position1Properties);
                portfolioProperties.put("position1", position1);
                position2 = new Position();
                position2Properties = new Properties();
                position2Properties.put("secId", "GOOG");
                position2Properties.put("qty", new Double(12176.0));
                position2Properties.put("mktValue", new Double(21.972));
                position2.init(position2Properties);
                portfolioProperties.put("position2", position2);
                portfolio.init(portfolioProperties);
                region.put((Object)new Integer(2), (Object)portfolio);
                portfolio = new Portfolio();
                portfolioProperties = new Properties();
                portfolioProperties.put("id", new Integer(3));
                portfolioProperties.put("type", "type3");
                portfolioProperties.put("status", "active");
                position1 = new Position();
                position1Properties = new Properties();
                position1Properties.put("secId", "MSFT");
                position1Properties.put("qty", new Double(98327.0));
                position1Properties.put("mktValue", new Double(23.32));
                position1.init(position1Properties);
                portfolioProperties.put("position1", position1);
                position2 = new Position();
                position2Properties = new Properties();
                position2Properties.put("secId", "AOL");
                position2Properties.put("qty", new Double(978.0));
                position2Properties.put("mktValue", new Double(40.373));
                position2.init(position2Properties);
                portfolioProperties.put("position2", position2);
                portfolio.init(portfolioProperties);
                region.put((Object)new Integer(3), (Object)portfolio);
                portfolio = new Portfolio();
                portfolioProperties = new Properties();
                portfolioProperties.put("id", new Integer(4));
                portfolioProperties.put("type", "type1");
                portfolioProperties.put("status", "inactive");
                position1 = new Position();
                position1Properties = new Properties();
                position1Properties.put("secId", "APPL");
                position1Properties.put("qty", new Double(90.0));
                position1Properties.put("mktValue", new Double(67.356572));
                position1.init(position1Properties);
                portfolioProperties.put("position1", position1);
                position2 = new Position();
                position2Properties = new Properties();
                position2Properties.put("secId", "ORCL");
                position2Properties.put("qty", new Double(376.0));
                position2Properties.put("mktValue", new Double(101.34));
                position2.init(position2Properties);
                portfolioProperties.put("position2", position2);
                portfolio.init(portfolioProperties);
                region.put((Object)new Integer(4), (Object)portfolio);
            }
        });
        final int port = vm0.invokeInt(QueryUsingPoolDUnitTest.class, "getCacheServerPort");
        final String host0 = QueryUsingPoolDUnitTest.getServerHostName(vm0.getHost());
        vm1.invoke(new CacheSerializableRunnable("Create region"){

            @Override
            public void run2() throws CacheException {
                Properties config = new Properties();
                config.setProperty("mcast-port", "0");
                DistributedTestCase.system = (InternalDistributedSystem)DistributedSystem.connect((Properties)config);
                QueryUsingPoolDUnitTest.this.getCache();
                AttributesFactory factory = new AttributesFactory();
                factory.setScope(Scope.LOCAL);
                BridgeTestCase.configureConnectionPool(factory, host0, port, -1, true, -1, -1, null);
                QueryUsingPoolDUnitTest.this.createRegion(name, factory.create());
            }
        });
        vm1.invoke(new CacheSerializableRunnable("Execute queries"){

            @Override
            public void run2() throws CacheException {
                Region region = QueryUsingPoolDUnitTest.this.getRootRegion().getSubregion(name);
                String queryString = null;
                SelectResults results = null;
                queryString = "IMPORT cacheRunner.Position; SELECT DISTINCT id, status FROM " + region.getFullPath() + "WHERE NOT (SELECT DISTINCT * FROM positions.values posnVal TYPE Position " + "WHERE posnVal.secId='AOL' OR posnVal.secId='SAP').isEmpty";
                try {
                    results = region.query(queryString);
                }
                catch (Exception e) {
                    DistributedTestCase.fail("Failed executing " + queryString, e);
                }
                DistributedTestCase.getLogWriter().fine("size: " + results.size());
                TestCase.assertTrue((!results.getCollectionType().allowsDuplicates() && results.getCollectionType().getElementType().isStructType() ? 1 : 0) != 0);
            }
        });
        vm0.invoke(new SerializableRunnable("Stop CacheServer"){

            @Override
            public void run() {
                QueryUsingPoolDUnitTest.this.stopBridgeServer(QueryUsingPoolDUnitTest.this.getCache());
            }
        });
    }

    public void testRemoteFullRegionQueries() throws CacheException {
        final String name = this.getName();
        String rootRegionName = "root";
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        int numberOfEntries = 100;
        vm0.invoke(new CacheSerializableRunnable("Create Bridge Server"){

            @Override
            public void run2() throws CacheException {
                Properties config = new Properties();
                int unusedPort = AvailablePort.getRandomAvailablePort((int)1);
                config.setProperty("mcast-port", String.valueOf(unusedPort));
                DistributedTestCase.system = (InternalDistributedSystem)DistributedSystem.connect((Properties)config);
                AttributesFactory factory = new AttributesFactory();
                factory.setScope(Scope.LOCAL);
                QueryUsingPoolDUnitTest.this.createRegion(name, factory.create());
                DistributedTestCase.pause(1000);
                try {
                    QueryUsingPoolDUnitTest.this.startBridgeServer(0, false);
                }
                catch (Exception ex) {
                    DistributedTestCase.fail("While starting CacheServer", ex);
                }
            }
        });
        vm0.invoke(new CacheSerializableRunnable("Create Bridge Server"){

            @Override
            public void run2() throws CacheException {
                Region region = QueryUsingPoolDUnitTest.this.getRootRegion().getSubregion(name);
                for (int i = 0; i < 100; ++i) {
                    region.put((Object)("key-" + i), (Object)new TestObject(i, "ibm"));
                }
            }
        });
        int port = vm0.invokeInt(QueryUsingPoolDUnitTest.class, "getCacheServerPort");
        String host0 = QueryUsingPoolDUnitTest.getServerHostName(vm0.getHost());
        final String regionName = "/root/" + name;
        String poolName = "testRemoteFullRegionQueries";
        this.createPool(vm1, "testRemoteFullRegionQueries", host0, port);
        vm1.invoke(new CacheSerializableRunnable("Execute queries"){

            @Override
            public void run2() throws CacheException {
                Query query;
                String queryString = null;
                SelectResults results = null;
                Comparator comparator = null;
                Object[] resultsArray = null;
                QueryService qService = null;
                try {
                    qService = PoolManager.find((String)"testRemoteFullRegionQueries").getQueryService();
                }
                catch (Exception e) {
                    DistributedTestCase.fail("Failed to get QueryService.", e);
                }
                queryString = "SELECT DISTINCT itr.value FROM " + regionName + ".entries itr where itr.key = 'key-1'";
                try {
                    query = qService.newQuery(queryString);
                    results = (SelectResults)query.execute();
                }
                catch (Exception e) {
                    DistributedTestCase.fail("Failed executing " + queryString, e);
                }
                TestCase.assertEquals((int)1, (int)results.size());
                TestCase.assertTrue((!results.getCollectionType().allowsDuplicates() ? 1 : 0) != 0);
                TestCase.assertTrue((boolean)(results.asList().get(0) instanceof TestObject));
                queryString = "SELECT DISTINCT itr.key FROM " + regionName + ".entries itr where itr.key = 'key-1'";
                try {
                    query = qService.newQuery(queryString);
                    results = (SelectResults)query.execute();
                }
                catch (Exception e) {
                    DistributedTestCase.fail("Failed executing " + queryString, e);
                }
                TestCase.assertEquals((int)1, (int)results.size());
                TestCase.assertTrue((!results.getCollectionType().allowsDuplicates() ? 1 : 0) != 0);
                TestCase.assertEquals((Object)"key-1", results.asList().get(0));
                queryString = "SELECT DISTINCT * FROM " + regionName + " WHERE id < 101 ORDER BY id";
                try {
                    query = qService.newQuery(queryString);
                    results = (SelectResults)query.execute();
                }
                catch (Exception e) {
                    DistributedTestCase.fail("Failed executing " + queryString, e);
                }
                TestCase.assertEquals((int)100, (int)results.size());
                TestCase.assertTrue((boolean)results.getCollectionType().isOrdered());
                comparator = new IdComparator();
                resultsArray = results.toArray();
                for (int i = 0; i < resultsArray.length; ++i) {
                    if (i + 1 == resultsArray.length) continue;
                    TestCase.assertTrue((String)("The id for " + resultsArray[i] + " should be less than the id for " + resultsArray[i + 1]), (comparator.compare(resultsArray[i], resultsArray[i + 1]) == -1 ? 1 : 0) != 0);
                }
                queryString = "SELECT DISTINCT id, ticker, price FROM " + regionName + " WHERE id < 101 ORDER BY id";
                try {
                    Query query2 = qService.newQuery(queryString);
                    results = (SelectResults)query2.execute();
                }
                catch (Exception e) {
                    DistributedTestCase.fail("Failed executing " + queryString, e);
                }
                TestCase.assertEquals((int)100, (int)results.size());
                TestCase.assertTrue((boolean)results.getCollectionType().isOrdered());
                comparator = new StructIdComparator();
                resultsArray = results.toArray();
                for (int i = 0; i < resultsArray.length; ++i) {
                    if (i + 1 == resultsArray.length) continue;
                    TestCase.assertTrue((String)("The id for " + resultsArray[i] + " should be less than the id for " + resultsArray[i + 1]), (comparator.compare(resultsArray[i], resultsArray[i + 1]) == -1 ? 1 : 0) != 0);
                }
                queryString = "(SELECT DISTINCT * FROM " + regionName + " WHERE id < 101).size";
                try {
                    Query query3 = qService.newQuery(queryString);
                    results = (SelectResults)query3.execute();
                }
                catch (Exception e) {
                    DistributedTestCase.fail("Failed executing " + queryString, e);
                }
                TestCase.assertEquals((int)1, (int)results.size());
                Object result = results.iterator().next();
                TestCase.assertTrue((boolean)(result instanceof Integer));
                int resultInt = (Integer)result;
                TestCase.assertEquals((int)resultInt, (int)100);
                queryString = " SELECT DISTINCT itr.key FROM " + regionName + ".entries itr where itr.key = 'key-1' ";
                try {
                    Query query4 = qService.newQuery(queryString);
                    results = (SelectResults)query4.execute();
                }
                catch (Exception e) {
                    DistributedTestCase.fail("Failed executing " + queryString, e);
                }
                TestCase.assertEquals((int)1, (int)results.size());
                TestCase.assertEquals((Object)"key-1", results.asList().get(0));
            }
        });
        vm0.invoke(new SerializableRunnable("Stop CacheServer"){

            @Override
            public void run() {
                QueryUsingPoolDUnitTest.this.stopBridgeServer(QueryUsingPoolDUnitTest.this.getCache());
            }
        });
    }

    public void testClientServerQueriesWithParams() throws CacheException {
        String name = this.getName();
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        int numberOfEntries = 100;
        final Object[][] params = new Object[][]{{"key-1"}, {101}, {101, "id"}, {101}, {50, "ibm"}, {50, "ibm"}};
        final int[] expectedResults = new int[]{1, 100, 100, 1, 1, 50};
        vm0.invoke(new CacheSerializableRunnable("Create Bridge Server"){

            @Override
            public void run2() throws CacheException {
                QueryUsingPoolDUnitTest.this.configAndStartBridgeServer();
            }
        });
        vm0.invoke(new CacheSerializableRunnable("Create and populate region"){

            @Override
            public void run2() throws CacheException {
                Region region = QueryUsingPoolDUnitTest.this.getRootRegion().getSubregion(QueryUsingPoolDUnitTest.this.regionName);
                for (int i = 0; i < 100; ++i) {
                    region.put((Object)("key-" + i), (Object)new TestObject(i, "ibm"));
                }
            }
        });
        int port = vm0.invokeInt(QueryUsingPoolDUnitTest.class, "getCacheServerPort");
        String host0 = QueryUsingPoolDUnitTest.getServerHostName(vm0.getHost());
        String regionName = "/" + this.rootRegionName + "/" + this.regionName;
        String poolName = "testClientServerQueriesWithParams";
        this.createPool(vm1, "testClientServerQueriesWithParams", host0, port);
        vm1.invoke(new CacheSerializableRunnable("Execute queries"){

            @Override
            public void run2() throws CacheException {
                SelectResults results = null;
                Object comparator = null;
                Object resultsArray = null;
                QueryService qService = null;
                try {
                    qService = PoolManager.find((String)"testClientServerQueriesWithParams").getQueryService();
                }
                catch (Exception e) {
                    DistributedTestCase.fail("Failed to get QueryService.", e);
                }
                for (int i = 0; i < QueryUsingPoolDUnitTest.this.queryString.length; ++i) {
                    try {
                        DistributedTestCase.getLogWriter().info("### Executing Query :" + QueryUsingPoolDUnitTest.this.queryString[i]);
                        Query query = qService.newQuery(QueryUsingPoolDUnitTest.this.queryString[i]);
                        results = (SelectResults)query.execute(params[i]);
                    }
                    catch (Exception e) {
                        DistributedTestCase.fail("Failed executing " + QueryUsingPoolDUnitTest.this.queryString[i], e);
                    }
                    try {
                        TestCase.assertEquals((int)expectedResults[i], (int)results.size());
                        continue;
                    }
                    catch (Throwable th) {
                        TestCase.fail((String)("Result mismatch for query= " + QueryUsingPoolDUnitTest.this.queryString[i] + " expected = " + expectedResults[i] + " actual=" + results.size()));
                    }
                }
            }
        });
        final int useMaintainedCompiledQueries = this.queryString.length;
        vm1.invoke(new CacheSerializableRunnable("Execute queries"){

            @Override
            public void run2() throws CacheException {
                SelectResults results = null;
                Object comparator = null;
                Object resultsArray = null;
                QueryService qService = null;
                try {
                    qService = PoolManager.find((String)"testClientServerQueriesWithParams").getQueryService();
                }
                catch (Exception e) {
                    DistributedTestCase.fail("Failed to get QueryService.", e);
                }
                for (int x = 0; x < useMaintainedCompiledQueries; ++x) {
                    for (int i = 0; i < QueryUsingPoolDUnitTest.this.queryString.length; ++i) {
                        try {
                            DistributedTestCase.getLogWriter().info("### Executing Query :" + QueryUsingPoolDUnitTest.this.queryString[i]);
                            Query query = qService.newQuery(QueryUsingPoolDUnitTest.this.queryString[i]);
                            results = (SelectResults)query.execute(params[i]);
                        }
                        catch (Exception e) {
                            DistributedTestCase.fail("Failed executing " + QueryUsingPoolDUnitTest.this.queryString[i], e);
                        }
                        try {
                            TestCase.assertEquals((int)expectedResults[i], (int)results.size());
                            continue;
                        }
                        catch (Throwable th) {
                            TestCase.fail((String)("Result mismatch for query= " + QueryUsingPoolDUnitTest.this.queryString[i] + " expected = " + expectedResults[i] + " actual=" + results.size()));
                        }
                    }
                }
            }
        });
        vm0.invoke(new CacheSerializableRunnable("validate compiled query."){

            @Override
            public void run2() throws CacheException {
                long compiledQueryCount = CacheClientNotifier.getInstance().getStats().getCompiledQueryCount();
                TestCase.assertEquals((long)QueryUsingPoolDUnitTest.this.queryString.length, (long)compiledQueryCount);
            }
        });
        vm0.invoke(new CacheSerializableRunnable("validate compiled query."){

            @Override
            public void run2() throws CacheException {
                long compiledQueryUsedCount = CacheClientNotifier.getInstance().getStats().getCompiledQueryUsedCount();
                int numTimesUsed = (useMaintainedCompiledQueries + 1) * QueryUsingPoolDUnitTest.this.queryString.length;
                TestCase.assertEquals((long)numTimesUsed, (long)compiledQueryUsedCount);
            }
        });
        vm0.invoke(new SerializableRunnable("Stop CacheServer"){

            @Override
            public void run() {
                QueryUsingPoolDUnitTest.this.stopBridgeServer(QueryUsingPoolDUnitTest.this.getCache());
            }
        });
    }

    public void testMulitipleClientServerQueriesWithParams() throws CacheException {
        String name = this.getName();
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        VM vm3 = host.getVM(3);
        int numberOfEntries = 100;
        final Object[][] params = new Object[][]{{"key-1"}, {101}, {101, "id"}, {101}, {50, "ibm"}, {50, "ibm"}};
        final int[] expectedResults = new int[]{1, 100, 100, 1, 1, 50};
        vm0.invoke(new CacheSerializableRunnable("Create Bridge Server"){

            @Override
            public void run2() throws CacheException {
                QueryUsingPoolDUnitTest.this.configAndStartBridgeServer();
                Region region = QueryUsingPoolDUnitTest.this.getRootRegion().getSubregion(QueryUsingPoolDUnitTest.this.regionName);
                for (int i = 0; i < 100; ++i) {
                    region.put((Object)("key-" + i), (Object)new TestObject(i, "ibm"));
                }
            }
        });
        vm1.invoke(new CacheSerializableRunnable("Create Bridge Server"){

            @Override
            public void run2() throws CacheException {
                QueryUsingPoolDUnitTest.this.configAndStartBridgeServer();
                Region region = QueryUsingPoolDUnitTest.this.getRootRegion().getSubregion(QueryUsingPoolDUnitTest.this.regionName);
                for (int i = 0; i < 100; ++i) {
                    region.put((Object)("key-" + i), (Object)new TestObject(i, "ibm"));
                }
            }
        });
        int port0 = vm0.invokeInt(QueryUsingPoolDUnitTest.class, "getCacheServerPort");
        int port1 = vm1.invokeInt(QueryUsingPoolDUnitTest.class, "getCacheServerPort");
        String host0 = QueryUsingPoolDUnitTest.getServerHostName(vm0.getHost());
        String regionName = "/" + this.rootRegionName + "/" + this.regionName;
        String poolName = "testClientServerQueriesWithParams";
        this.createPool(vm2, "testClientServerQueriesWithParams", new String[]{host0}, new int[]{port0}, true);
        this.createPool(vm3, "testClientServerQueriesWithParams", new String[]{host0}, new int[]{port1}, true);
        CacheSerializableRunnable executeQueries = new CacheSerializableRunnable("Execute queries"){

            @Override
            public void run2() throws CacheException {
                SelectResults results = null;
                Object comparator = null;
                Object resultsArray = null;
                QueryService qService = null;
                try {
                    qService = PoolManager.find((String)"testClientServerQueriesWithParams").getQueryService();
                }
                catch (Exception e) {
                    DistributedTestCase.fail("Failed to get QueryService.", e);
                }
                for (int j = 0; j < QueryUsingPoolDUnitTest.this.queryString.length; ++j) {
                    for (int i = 0; i < QueryUsingPoolDUnitTest.this.queryString.length; ++i) {
                        try {
                            DistributedTestCase.getLogWriter().info("### Executing Query :" + QueryUsingPoolDUnitTest.this.queryString[i]);
                            Query query = qService.newQuery(QueryUsingPoolDUnitTest.this.queryString[i]);
                            results = (SelectResults)query.execute(params[i]);
                        }
                        catch (Exception e) {
                            DistributedTestCase.fail("Failed executing " + QueryUsingPoolDUnitTest.this.queryString[i], e);
                        }
                        try {
                            TestCase.assertEquals((int)expectedResults[i], (int)results.size());
                            continue;
                        }
                        catch (Throwable th) {
                            TestCase.fail((String)("Result mismatch for query= " + QueryUsingPoolDUnitTest.this.queryString[i] + " expected = " + expectedResults[i] + " actual=" + results.size()));
                        }
                    }
                }
            }
        };
        vm2.invoke(executeQueries);
        vm3.invoke(executeQueries);
        vm0.invoke(new CacheSerializableRunnable("validate compiled query."){

            @Override
            public void run2() throws CacheException {
                long compiledQueryCount = CacheClientNotifier.getInstance().getStats().getCompiledQueryCount();
                TestCase.assertEquals((long)QueryUsingPoolDUnitTest.this.queryString.length, (long)compiledQueryCount);
            }
        });
        this.closeClient(vm2);
        this.closeClient(vm3);
        vm0.invoke(new CacheSerializableRunnable("validate compiled query."){

            @Override
            public void run2() throws CacheException {
                long compiledQueryCount = CacheClientNotifier.getInstance().getStats().getCompiledQueryCount();
                TestCase.assertEquals((long)QueryUsingPoolDUnitTest.this.queryString.length, (long)compiledQueryCount);
            }
        });
        vm1.invoke(new CacheSerializableRunnable("validate compiled query."){

            @Override
            public void run2() throws CacheException {
                long compiledQueryCount = CacheClientNotifier.getInstance().getStats().getCompiledQueryCount();
                TestCase.assertEquals((long)QueryUsingPoolDUnitTest.this.queryString.length, (long)compiledQueryCount);
            }
        });
        this.createPool(vm2, "testClientServerQueriesWithParams", new String[]{host0, host0}, new int[]{port1, port0}, true);
        this.createPool(vm3, "testClientServerQueriesWithParams", new String[]{host0, host0}, new int[]{port0, port1}, true);
        vm2.invoke(executeQueries);
        vm3.invoke(executeQueries);
        vm0.invoke(new CacheSerializableRunnable("validate compiled query."){

            @Override
            public void run2() throws CacheException {
                long compiledQueryCount = CacheClientNotifier.getInstance().getStats().getCompiledQueryCount();
                TestCase.assertEquals((long)QueryUsingPoolDUnitTest.this.queryString.length, (long)compiledQueryCount);
            }
        });
        vm1.invoke(new CacheSerializableRunnable("validate compiled query."){

            @Override
            public void run2() throws CacheException {
                long compiledQueryCount = CacheClientNotifier.getInstance().getStats().getCompiledQueryCount();
                TestCase.assertEquals((long)QueryUsingPoolDUnitTest.this.queryString.length, (long)compiledQueryCount);
            }
        });
        vm0.invoke(new SerializableRunnable("Stop CacheServer"){

            @Override
            public void run() {
                QueryUsingPoolDUnitTest.this.stopBridgeServer(QueryUsingPoolDUnitTest.this.getCache());
            }
        });
        vm1.invoke(new SerializableRunnable("Stop CacheServer"){

            @Override
            public void run() {
                QueryUsingPoolDUnitTest.this.stopBridgeServer(QueryUsingPoolDUnitTest.this.getCache());
            }
        });
    }

    public void testClientServerCompiledQueryRegisterAndCleanup() throws CacheException {
        final String name = this.getName();
        String rootRegionName = "root";
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        int numberOfEntries = 100;
        final Object[][] params = new Object[][]{{"key-1"}, {101}, {101, "id"}, {101}, {50, "ibm"}, {50, "ibm"}};
        vm0.invoke(new CacheSerializableRunnable("Create Bridge Server"){

            @Override
            public void run2() throws CacheException {
                QueryUsingPoolDUnitTest.this.configAndStartBridgeServer();
            }
        });
        vm0.invoke(new CacheSerializableRunnable("Create and populate region."){

            @Override
            public void run2() throws CacheException {
                Region region = QueryUsingPoolDUnitTest.this.getRootRegion().getSubregion(name);
                for (int i = 0; i < 100; ++i) {
                    region.put((Object)("key-" + i), (Object)new TestObject(i, "ibm"));
                }
            }
        });
        int port = vm0.invokeInt(QueryUsingPoolDUnitTest.class, "getCacheServerPort");
        String host0 = QueryUsingPoolDUnitTest.getServerHostName(vm0.getHost());
        String regionName = "/" + this.rootRegionName + "/" + this.regionName;
        String poolName = "testClientServerQueriesWithParams";
        this.createPool(vm1, "testClientServerQueriesWithParams", host0, port);
        this.createPool(vm2, "testClientServerQueriesWithParams", host0, port);
        vm1.invoke(new CacheSerializableRunnable("Execute queries"){

            @Override
            public void run2() throws CacheException {
                QueryUsingPoolDUnitTest.this.executeCompiledQueries("testClientServerQueriesWithParams", params);
            }
        });
        vm2.invoke(new CacheSerializableRunnable("Execute queries"){

            @Override
            public void run2() throws CacheException {
                QueryUsingPoolDUnitTest.this.executeCompiledQueries("testClientServerQueriesWithParams", params);
            }
        });
        vm0.invoke(new CacheSerializableRunnable("validate compiled query."){

            @Override
            public void run2() throws CacheException {
                long compiledQueryCount = CacheClientNotifier.getInstance().getStats().getCompiledQueryCount();
                TestCase.assertEquals((long)QueryUsingPoolDUnitTest.this.queryString.length, (long)compiledQueryCount);
            }
        });
        this.closeClient(vm1);
        vm0.invoke(new CacheSerializableRunnable("validate compiled query."){

            @Override
            public void run2() throws CacheException {
                long compiledQueryCount = CacheClientNotifier.getInstance().getStats().getCompiledQueryCount();
                TestCase.assertEquals((long)QueryUsingPoolDUnitTest.this.queryString.length, (long)compiledQueryCount);
            }
        });
        vm0.invoke(new SerializableRunnable("Stop CacheServer"){

            @Override
            public void run() {
                QueryUsingPoolDUnitTest.this.stopBridgeServer(QueryUsingPoolDUnitTest.this.getCache());
            }
        });
    }

    public void testClientServerCompiledQueryTimeBasedCleanup() throws CacheException {
        final String name = this.getName();
        String rootRegionName = "root";
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        int numberOfEntries = 100;
        final Object[][] params = new Object[][]{{"key-1"}, {101}, {101, "id"}, {101}, {50, "ibm"}, {50, "ibm"}};
        vm0.invoke(new CacheSerializableRunnable("Create Bridge Server"){

            @Override
            public void run2() throws CacheException {
                QueryUsingPoolDUnitTest.this.configAndStartBridgeServer();
            }
        });
        vm0.invoke(new CacheSerializableRunnable("Create and populate region."){

            @Override
            public void run2() throws CacheException {
                Region region = QueryUsingPoolDUnitTest.this.getRootRegion().getSubregion(name);
                for (int i = 0; i < 100; ++i) {
                    region.put((Object)("key-" + i), (Object)new TestObject(i, "ibm"));
                }
                QueryService qs = QueryUsingPoolDUnitTest.this.getCache().getQueryService();
                DefaultQuery query = (DefaultQuery)qs.newQuery("Select * from " + QueryUsingPoolDUnitTest.this.regName);
                DefaultQuery.setTestCompiledQueryClearTime((int)2000);
            }
        });
        int port = vm0.invokeInt(QueryUsingPoolDUnitTest.class, "getCacheServerPort");
        String host0 = QueryUsingPoolDUnitTest.getServerHostName(vm0.getHost());
        String regionName = "/" + this.rootRegionName + "/" + this.regionName;
        String poolName = "testClientServerQueriesWithParams";
        this.createPool(vm1, "testClientServerQueriesWithParams", host0, port);
        this.createPool(vm2, "testClientServerQueriesWithParams", host0, port);
        vm1.invoke(new CacheSerializableRunnable("Execute queries"){

            @Override
            public void run2() throws CacheException {
                QueryUsingPoolDUnitTest.this.executeCompiledQueries("testClientServerQueriesWithParams", params);
            }
        });
        vm2.invoke(new CacheSerializableRunnable("Execute queries"){

            @Override
            public void run2() throws CacheException {
                QueryUsingPoolDUnitTest.this.executeCompiledQueries("testClientServerQueriesWithParams", params);
            }
        });
        this.validateCompiledQuery(vm0, 0L);
        vm1.invoke(new CacheSerializableRunnable("Execute queries"){

            @Override
            public void run2() throws CacheException {
                QueryUsingPoolDUnitTest.this.executeCompiledQueries("testClientServerQueriesWithParams", params);
            }
        });
        vm2.invokeAsync(new CacheSerializableRunnable("Execute queries"){

            @Override
            public void run2() throws CacheException {
                for (int i = 0; i < 10; ++i) {
                    DistributedTestCase.pause(200);
                    QueryUsingPoolDUnitTest.this.executeCompiledQueries("testClientServerQueriesWithParams", params);
                }
            }
        });
        this.validateCompiledQuery(vm0, this.queryString.length);
        QueryUsingPoolDUnitTest.pause(2000);
        this.validateCompiledQuery(vm0, 0L);
        this.closeClient(vm2);
        this.closeClient(vm1);
        vm0.invoke(new CacheSerializableRunnable("validate compiled query"){

            @Override
            public void run2() throws CacheException {
                long compiledQueryCount = CacheClientNotifier.getInstance().getStats().getCompiledQueryCount();
                TestCase.assertEquals((long)0L, (long)compiledQueryCount);
            }
        });
        vm0.invoke(new SerializableRunnable("Stop CacheServer"){

            @Override
            public void run() {
                QueryUsingPoolDUnitTest.this.stopBridgeServer(QueryUsingPoolDUnitTest.this.getCache());
            }
        });
    }

    public void testClientServerCompiledQueryCleanup() throws CacheException {
        final String name = this.getName();
        String rootRegionName = "root";
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        int numberOfEntries = 100;
        final Object[][] params = new Object[][]{{"key-1"}, {101}, {101, "id"}, {101}, {50, "ibm"}, {50, "ibm"}};
        vm0.invoke(new CacheSerializableRunnable("Create Bridge Server"){

            @Override
            public void run2() throws CacheException {
                QueryUsingPoolDUnitTest.this.configAndStartBridgeServer();
            }
        });
        vm0.invoke(new CacheSerializableRunnable("Create and populate region."){

            @Override
            public void run2() throws CacheException {
                Region region = QueryUsingPoolDUnitTest.this.getRootRegion().getSubregion(name);
                for (int i = 0; i < 100; ++i) {
                    region.put((Object)("key-" + i), (Object)new TestObject(i, "ibm"));
                }
                QueryService qs = QueryUsingPoolDUnitTest.this.getCache().getQueryService();
                DefaultQuery query = (DefaultQuery)qs.newQuery("Select * from " + QueryUsingPoolDUnitTest.this.regName);
                DefaultQuery.setTestCompiledQueryClearTime((int)2000);
            }
        });
        int port = vm0.invokeInt(QueryUsingPoolDUnitTest.class, "getCacheServerPort");
        String host0 = QueryUsingPoolDUnitTest.getServerHostName(vm0.getHost());
        String regionName = "/" + this.rootRegionName + "/" + this.regionName;
        String poolName = "testClientServerQueriesWithParams";
        boolean subscriptiuonEnabled = false;
        this.createPool(vm1, "testClientServerQueriesWithParams", host0, port, false);
        this.createPool(vm2, "testClientServerQueriesWithParams", host0, port, false);
        vm1.invoke(new CacheSerializableRunnable("Execute queries"){

            @Override
            public void run2() throws CacheException {
                QueryUsingPoolDUnitTest.this.executeCompiledQueries("testClientServerQueriesWithParams", params);
            }
        });
        vm2.invoke(new CacheSerializableRunnable("Execute queries"){

            @Override
            public void run2() throws CacheException {
                QueryUsingPoolDUnitTest.this.executeCompiledQueries("testClientServerQueriesWithParams", params);
            }
        });
        this.validateCompiledQuery(vm0, 0L);
        vm1.invoke(new CacheSerializableRunnable("Execute queries"){

            @Override
            public void run2() throws CacheException {
                QueryUsingPoolDUnitTest.this.executeCompiledQueries("testClientServerQueriesWithParams", params);
            }
        });
        vm2.invokeAsync(new CacheSerializableRunnable("Execute queries"){

            @Override
            public void run2() throws CacheException {
                for (int i = 0; i < 10; ++i) {
                    DistributedTestCase.pause(10);
                    QueryUsingPoolDUnitTest.this.executeCompiledQueries("testClientServerQueriesWithParams", params);
                }
            }
        });
        this.validateCompiledQuery(vm0, this.queryString.length);
        this.validateCompiledQuery(vm0, 0L);
        vm1.invoke(new CacheSerializableRunnable("Execute queries"){

            @Override
            public void run2() throws CacheException {
                QueryUsingPoolDUnitTest.this.executeCompiledQueries("testClientServerQueriesWithParams", params);
            }
        });
        vm0.invoke(new CacheSerializableRunnable("validate compiled query."){

            @Override
            public void run2() throws CacheException {
                long compiledQueryCount = CacheClientNotifier.getInstance().getStats().getCompiledQueryCount();
                TestCase.assertEquals((long)QueryUsingPoolDUnitTest.this.queryString.length, (long)compiledQueryCount);
            }
        });
        this.closeClient(vm2);
        this.closeClient(vm1);
        this.validateCompiledQuery(vm0, 0L);
        vm0.invoke(new SerializableRunnable("Stop CacheServer"){

            @Override
            public void run() {
                QueryUsingPoolDUnitTest.this.stopBridgeServer(QueryUsingPoolDUnitTest.this.getCache());
            }
        });
    }

    public void testBindParamsWithMulitipleClients() throws CacheException {
        String name = this.getName();
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        VM vm3 = host.getVM(3);
        int numberOfEntries = 100;
        final Object[][] params = new Object[][]{{"key-1"}, {101}, {101, "id"}, {101}, {50, "ibm"}, {50, "ibm"}};
        final String[] querys = new String[]{"SELECT itr.value FROM " + this.regName + ".entries itr where itr.key = 'key-1'", "SELECT DISTINCT * FROM " + this.regName + " WHERE id < 101 ORDER BY id", "SELECT DISTINCT * FROM " + this.regName + " WHERE id < 101 ORDER BY id", "(SELECT DISTINCT * FROM " + this.regName + " WHERE id < 101).size", "SELECT * FROM " + this.regName + " WHERE id = 50 and Ticker = 'ibm'", "SELECT * FROM " + this.regName + " WHERE id < 50 and Ticker = 'ibm'"};
        int[] expectedResults = new int[]{1, 100, 100, 1, 1, 50};
        vm0.invoke(new CacheSerializableRunnable("Create Bridge Server"){

            @Override
            public void run2() throws CacheException {
                QueryUsingPoolDUnitTest.this.configAndStartBridgeServer();
                Region region = QueryUsingPoolDUnitTest.this.getRootRegion().getSubregion(QueryUsingPoolDUnitTest.this.regionName);
                for (int i = 0; i < 100; ++i) {
                    region.put((Object)("key-" + i), (Object)new TestObject(i, "ibm"));
                }
            }
        });
        int port0 = vm0.invokeInt(QueryUsingPoolDUnitTest.class, "getCacheServerPort");
        String host0 = QueryUsingPoolDUnitTest.getServerHostName(vm0.getHost());
        String regionName = "/" + this.rootRegionName + "/" + this.regionName;
        String poolName = "testClientServerQueriesWithParams";
        this.createPool(vm1, "testClientServerQueriesWithParams", new String[]{host0}, new int[]{port0}, true);
        this.createPool(vm2, "testClientServerQueriesWithParams", new String[]{host0}, new int[]{port0}, true);
        this.createPool(vm3, "testClientServerQueriesWithParams", new String[]{host0}, new int[]{port0}, true);
        CacheSerializableRunnable executeSameQueries = new CacheSerializableRunnable("Execute queries"){

            @Override
            public void run2() throws CacheException {
                QueryService qService = null;
                Object[][] rs = new SelectResults[1][2];
                try {
                    qService = PoolManager.find((String)"testClientServerQueriesWithParams").getQueryService();
                }
                catch (Exception e) {
                    DistributedTestCase.fail("Failed to get QueryService.", e);
                }
                for (int j = 0; j < 5; ++j) {
                    for (int i = 0; i < 2; ++i) {
                        try {
                            DistributedTestCase.getLogWriter().info("### Executing Query :" + QueryUsingPoolDUnitTest.this.queryString[i]);
                            Query query = qService.newQuery(QueryUsingPoolDUnitTest.this.queryString[i]);
                            rs[0][0] = (SelectResults)query.execute(params[i]);
                            Query query2 = qService.newQuery(querys[i]);
                            rs[0][1] = (SelectResults)query2.execute();
                        }
                        catch (Exception e) {
                            DistributedTestCase.fail("Failed executing " + QueryUsingPoolDUnitTest.this.queryString[i], e);
                        }
                        DistributedTestCase.getLogWriter().info("### Comparing results for Query :" + (i + 1) * (j + 1) + " : " + QueryUsingPoolDUnitTest.this.queryString[i]);
                        QueryUsingPoolDUnitTest.this.compareQueryResultsWithoutAndWithIndexes(rs, 1);
                        DistributedTestCase.getLogWriter().info("### Done Comparing results for Query :" + (i + 1) * (j + 1) + " : " + QueryUsingPoolDUnitTest.this.queryString[i]);
                    }
                }
            }
        };
        vm1.invokeAsync(executeSameQueries);
        vm2.invokeAsync(executeSameQueries);
        vm3.invokeAsync(executeSameQueries);
        vm0.invoke(new CacheSerializableRunnable("validate compiled query."){

            @Override
            public void run2() throws CacheException {
                long compiledQueryUsedCount = -1L;
                while (true) {
                    DistributedTestCase.getLogWriter().info("### CompiledQueryUsedCount :" + compiledQueryUsedCount);
                    if (compiledQueryUsedCount == CacheClientNotifier.getInstance().getStats().getCompiledQueryUsedCount()) {
                        DistributedTestCase.getLogWriter().info("### previous and current CompiledQueryUsedCounts are same :" + compiledQueryUsedCount);
                        break;
                    }
                    compiledQueryUsedCount = CacheClientNotifier.getInstance().getStats().getCompiledQueryUsedCount();
                    try {
                        Thread.currentThread();
                        Thread.sleep(3000L);
                    }
                    catch (Exception ex) {
                        break;
                    }
                }
            }
        });
        CacheSerializableRunnable executeQueries = new CacheSerializableRunnable("Execute queries"){

            @Override
            public void run2() throws CacheException {
                Object results = null;
                Object results2 = null;
                Object comparator = null;
                Object resultsArray = null;
                QueryService qService = null;
                Object[][] rs = new SelectResults[1][2];
                try {
                    qService = PoolManager.find((String)"testClientServerQueriesWithParams").getQueryService();
                }
                catch (Exception e) {
                    DistributedTestCase.fail("Failed to get QueryService.", e);
                }
                for (int j = 0; j < QueryUsingPoolDUnitTest.this.queryString.length; ++j) {
                    for (int i = 0; i < QueryUsingPoolDUnitTest.this.queryString.length; ++i) {
                        try {
                            DistributedTestCase.getLogWriter().info("### Executing Query :" + QueryUsingPoolDUnitTest.this.queryString[i]);
                            Query query = qService.newQuery(QueryUsingPoolDUnitTest.this.queryString[i]);
                            rs[0][0] = (SelectResults)query.execute(params[i]);
                            Query query2 = qService.newQuery(querys[i]);
                            rs[0][1] = (SelectResults)query2.execute();
                            QueryUsingPoolDUnitTest.this.compareQueryResultsWithoutAndWithIndexes(rs, 1);
                            continue;
                        }
                        catch (Exception e) {
                            DistributedTestCase.fail("Failed executing " + QueryUsingPoolDUnitTest.this.queryString[i], e);
                        }
                    }
                }
            }
        };
        vm1.invokeAsync(executeQueries);
        vm2.invokeAsync(executeQueries);
        vm3.invokeAsync(executeQueries);
        vm0.invoke(new CacheSerializableRunnable("validate compiled query."){

            @Override
            public void run2() throws CacheException {
                long compiledQueryUsedCount = -1L;
                while (true) {
                    DistributedTestCase.getLogWriter().info("### previous CompiledQueryUsedCount :" + compiledQueryUsedCount);
                    if (compiledQueryUsedCount == CacheClientNotifier.getInstance().getStats().getCompiledQueryUsedCount()) {
                        DistributedTestCase.getLogWriter().info("### previous and current CompiledQueryUsedCounts are same :" + compiledQueryUsedCount);
                        break;
                    }
                    compiledQueryUsedCount = CacheClientNotifier.getInstance().getStats().getCompiledQueryUsedCount();
                    try {
                        Thread.currentThread();
                        Thread.sleep(3000L);
                    }
                    catch (Exception ex) {
                        break;
                    }
                }
            }
        });
        this.closeClient(vm1);
        this.closeClient(vm2);
        this.closeClient(vm3);
        vm0.invoke(new SerializableRunnable("Stop CacheServer"){

            @Override
            public void run() {
                QueryUsingPoolDUnitTest.this.stopBridgeServer(QueryUsingPoolDUnitTest.this.getCache());
            }
        });
    }

    public void testRemoteJoinRegionQueries() throws CacheException {
        final String name = this.getName();
        String rootRegionName = "root";
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        int numberOfEntries = 100;
        vm0.invoke(new CacheSerializableRunnable("Create Bridge Server"){

            @Override
            public void run2() throws CacheException {
                Properties config = new Properties();
                int unusedPort = AvailablePort.getRandomAvailablePort((int)1);
                config.setProperty("mcast-port", String.valueOf(unusedPort));
                DistributedTestCase.system = (InternalDistributedSystem)DistributedSystem.connect((Properties)config);
                AttributesFactory factory = new AttributesFactory();
                factory.setScope(Scope.LOCAL);
                QueryUsingPoolDUnitTest.this.createRegion(name + "1", factory.create());
                QueryUsingPoolDUnitTest.this.createRegion(name + "2", factory.create());
                DistributedTestCase.pause(1000);
                try {
                    QueryUsingPoolDUnitTest.this.startBridgeServer(0, false);
                }
                catch (Exception ex) {
                    DistributedTestCase.fail("While starting CacheServer", ex);
                }
            }
        });
        vm0.invoke(new CacheSerializableRunnable("Create Bridge Server"){

            @Override
            public void run2() throws CacheException {
                Region region1 = QueryUsingPoolDUnitTest.this.getRootRegion().getSubregion(name + "1");
                for (int i = 0; i < 100; ++i) {
                    region1.put((Object)("key-" + i), (Object)new TestObject(i, "ibm"));
                }
                Region region2 = QueryUsingPoolDUnitTest.this.getRootRegion().getSubregion(name + "2");
                for (int i = 0; i < 100; ++i) {
                    region2.put((Object)("key-" + i), (Object)new TestObject(i, "ibm"));
                }
            }
        });
        int port = vm0.invokeInt(QueryUsingPoolDUnitTest.class, "getCacheServerPort");
        String host0 = QueryUsingPoolDUnitTest.getServerHostName(vm0.getHost());
        final String regionName1 = "/root/" + name + "1";
        final String regionName2 = "/root/" + name + "2";
        String poolName = "testRemoteJoinRegionQueries";
        this.createPool(vm1, "testRemoteJoinRegionQueries", host0, port);
        vm1.invoke(new CacheSerializableRunnable("Execute queries"){

            @Override
            public void run2() throws CacheException {
                Query query;
                String queryString = null;
                SelectResults results = null;
                QueryService qService = null;
                try {
                    qService = PoolManager.find((String)"testRemoteJoinRegionQueries").getQueryService();
                }
                catch (Exception e) {
                    DistributedTestCase.fail("Failed to get QueryService.", e);
                }
                queryString = "select distinct a, b.price from " + regionName1 + " a, " + regionName2 + " b where a.price = b.price";
                try {
                    query = qService.newQuery(queryString);
                    results = (SelectResults)query.execute();
                }
                catch (Exception e) {
                    DistributedTestCase.fail("Failed executing " + queryString, e);
                }
                TestCase.assertEquals((int)100, (int)results.size());
                TestCase.assertTrue((!results.getCollectionType().allowsDuplicates() && results.getCollectionType().getElementType().isStructType() ? 1 : 0) != 0);
                queryString = "select distinct a, b.price from " + regionName1 + " a, " + regionName2 + " b where a.price = b.price and a.price = 50";
                try {
                    query = qService.newQuery(queryString);
                    results = (SelectResults)query.execute();
                }
                catch (Exception e) {
                    DistributedTestCase.fail("Failed executing " + queryString, e);
                }
                TestCase.assertEquals((int)1, (int)results.size());
                TestCase.assertTrue((!results.getCollectionType().allowsDuplicates() && results.getCollectionType().getElementType().isStructType() ? 1 : 0) != 0);
            }
        });
        vm0.invoke(new SerializableRunnable("Stop CacheServer"){

            @Override
            public void run() {
                QueryUsingPoolDUnitTest.this.stopBridgeServer(QueryUsingPoolDUnitTest.this.getCache());
            }
        });
    }

    public void testRemoteBridgeClientQueries() throws CacheException {
        final String name = this.getName();
        String rootRegionName = "root";
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        int numberOfEntries = 100;
        vm0.invoke(new CacheSerializableRunnable("Create Bridge Server"){

            @Override
            public void run2() throws CacheException {
                Properties config = new Properties();
                int unusedPort = AvailablePort.getRandomAvailablePort((int)1);
                config.setProperty("mcast-port", String.valueOf(unusedPort));
                DistributedTestCase.system = (InternalDistributedSystem)DistributedSystem.connect((Properties)config);
                AttributesFactory factory = new AttributesFactory();
                factory.setScope(Scope.LOCAL);
                QueryUsingPoolDUnitTest.this.createRegion(name, factory.create());
                DistributedTestCase.pause(1000);
                try {
                    QueryUsingPoolDUnitTest.this.startBridgeServer(0, false);
                }
                catch (Exception ex) {
                    DistributedTestCase.fail("While starting CacheServer", ex);
                }
            }
        });
        vm0.invoke(new CacheSerializableRunnable("Create Bridge Server"){

            @Override
            public void run2() throws CacheException {
                Region region = QueryUsingPoolDUnitTest.this.getRootRegion().getSubregion(name);
                for (int i = 0; i < 100; ++i) {
                    region.put((Object)("key-" + i), (Object)new TestObject(i, "ibm"));
                }
            }
        });
        int port = vm0.invokeInt(QueryUsingPoolDUnitTest.class, "getCacheServerPort");
        String host0 = QueryUsingPoolDUnitTest.getServerHostName(vm0.getHost());
        final String regionName = "/root/" + name;
        String poolName1 = "testRemoteBridgeClientQueries1";
        String poolName2 = "testRemoteBridgeClientQueries2";
        this.createPool(vm1, "testRemoteBridgeClientQueries1", host0, port);
        this.createPool(vm2, "testRemoteBridgeClientQueries2", host0, port);
        vm1.invoke(new CacheSerializableRunnable("Execute queries"){

            @Override
            public void run2() throws CacheException {
                Query query;
                String queryString = null;
                SelectResults results = null;
                QueryService qService = null;
                try {
                    qService = PoolManager.find((String)"testRemoteBridgeClientQueries1").getQueryService();
                }
                catch (Exception e) {
                    DistributedTestCase.fail("Failed to get QueryService.", e);
                }
                queryString = "SELECT DISTINCT itr.value FROM " + regionName + ".entries itr where itr.key = 'key-1'";
                try {
                    query = qService.newQuery(queryString);
                    results = (SelectResults)query.execute();
                }
                catch (Exception e) {
                    DistributedTestCase.fail("Failed executing " + queryString, e);
                }
                TestCase.assertEquals((int)1, (int)results.size());
                TestCase.assertTrue((!results.getCollectionType().allowsDuplicates() && !results.getCollectionType().getElementType().isStructType() ? 1 : 0) != 0);
                TestCase.assertTrue((boolean)(results.asList().get(0) instanceof TestObject));
                queryString = "SELECT DISTINCT itr.key FROM " + regionName + ".entries itr where itr.key = 'key-1'";
                try {
                    query = qService.newQuery(queryString);
                    results = (SelectResults)query.execute();
                }
                catch (Exception e) {
                    DistributedTestCase.fail("Failed executing " + queryString, e);
                }
                TestCase.assertEquals((int)1, (int)results.size());
                TestCase.assertTrue((!results.getCollectionType().allowsDuplicates() && !results.getCollectionType().getElementType().isStructType() ? 1 : 0) != 0);
                TestCase.assertEquals((Object)"key-1", results.asList().get(0));
            }
        });
        vm2.invoke(new CacheSerializableRunnable("Execute queries"){

            @Override
            public void run2() throws CacheException {
                Query query;
                String queryString = null;
                SelectResults results = null;
                QueryService qService = null;
                try {
                    qService = PoolManager.find((String)"testRemoteBridgeClientQueries2").getQueryService();
                }
                catch (Exception e) {
                    DistributedTestCase.fail("Failed to get QueryService.", e);
                }
                queryString = "SELECT DISTINCT itr.value FROM " + regionName + ".entries itr where itr.key = 'key-1'";
                try {
                    query = qService.newQuery(queryString);
                    results = (SelectResults)query.execute();
                }
                catch (Exception e) {
                    DistributedTestCase.fail("Failed executing " + queryString, e);
                }
                TestCase.assertEquals((int)1, (int)results.size());
                TestCase.assertTrue((!results.getCollectionType().allowsDuplicates() && !results.getCollectionType().getElementType().isStructType() ? 1 : 0) != 0);
                TestCase.assertTrue((boolean)(results.asList().get(0) instanceof TestObject));
                queryString = "SELECT DISTINCT itr.key FROM " + regionName + ".entries itr where itr.key = 'key-1'";
                try {
                    query = qService.newQuery(queryString);
                    results = (SelectResults)query.execute();
                }
                catch (Exception e) {
                    DistributedTestCase.fail("Failed executing " + queryString, e);
                }
                TestCase.assertEquals((int)1, (int)results.size());
                TestCase.assertTrue((!results.getCollectionType().allowsDuplicates() && !results.getCollectionType().getElementType().isStructType() ? 1 : 0) != 0);
                TestCase.assertEquals((Object)"key-1", results.asList().get(0));
            }
        });
        vm0.invoke(new SerializableRunnable("Stop CacheServer"){

            @Override
            public void run() {
                QueryUsingPoolDUnitTest.this.stopBridgeServer(QueryUsingPoolDUnitTest.this.getCache());
            }
        });
    }

    public void testBug36969() throws Exception {
        final String name = this.getName();
        String rootRegionName = "root";
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        int numberOfEntries = 100;
        vm0.invoke(new CacheSerializableRunnable("Create Bridge Server"){

            @Override
            public void run2() throws CacheException {
                Properties config = new Properties();
                int unusedPort = AvailablePort.getRandomAvailablePort((int)1);
                config.setProperty("mcast-port", String.valueOf(unusedPort));
                DistributedTestCase.system = (InternalDistributedSystem)DistributedSystem.connect((Properties)config);
                DistributedTestCase.pause(1000);
                try {
                    QueryUsingPoolDUnitTest.this.startBridgeServer(0, false);
                }
                catch (Exception ex) {
                    DistributedTestCase.fail("While starting CacheServer", ex);
                }
            }
        });
        vm0.invoke(new CacheSerializableRunnable("Create two regions"){

            @Override
            public void run2() throws CacheException {
                AttributesFactory factory = new AttributesFactory();
                factory.setScope(Scope.LOCAL);
                final Region region1 = QueryUsingPoolDUnitTest.this.createRegion(name, factory.createRegionAttributes());
                Region region2 = QueryUsingPoolDUnitTest.this.createRegion(name + "_2", factory.createRegionAttributes());
                QueryObserverHolder.setInstance((QueryObserver)new QueryObserverAdapter(){

                    public void afterQueryEvaluation(Object result) {
                        region1.close();
                    }
                });
                DistributedTestCase.pause(1000);
                for (int i = 0; i < 100; ++i) {
                    region1.put((Object)("key-" + i), (Object)new TestObject(i, "ibm"));
                    region2.put((Object)("key-" + i), (Object)new TestObject(i, "ibm"));
                }
            }
        });
        int port = vm0.invokeInt(QueryUsingPoolDUnitTest.class, "getCacheServerPort");
        String host0 = QueryUsingPoolDUnitTest.getServerHostName(vm0.getHost());
        final String regionName1 = "/root/" + name;
        final String regionName2 = "/root/" + name + "_2";
        String poolName = "testBug36969";
        this.createPool(vm1, "testBug36969", host0, port);
        vm1.invoke(new CacheSerializableRunnable("Execute queries"){

            @Override
            public void run2() throws CacheException {
                String queryString = "select distinct * from " + regionName1 + ", " + regionName2;
                QueryService qService = null;
                try {
                    qService = PoolManager.find((String)"testBug36969").getQueryService();
                }
                catch (Exception e) {
                    DistributedTestCase.fail("Failed to get QueryService.", e);
                }
                try {
                    Query query = qService.newQuery(queryString);
                    query.execute();
                    TestCase.fail((String)"The query should have experienced RegionDestroyedException");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        vm0.invoke(new SerializableRunnable("Stop CacheServer"){

            @Override
            public void run() {
                QueryObserverHolder.setInstance((QueryObserver)new QueryObserverAdapter());
                QueryUsingPoolDUnitTest.this.stopBridgeServer(QueryUsingPoolDUnitTest.this.getCache());
            }
        });
    }

    public void testRemoteSortQueriesUsingIndex() throws CacheException {
        final String name = this.getName();
        String rootRegionName = "root";
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        int numberOfEntries = 100;
        vm0.invoke(new CacheSerializableRunnable("Create Bridge Server"){

            @Override
            public void run2() throws CacheException {
                Properties config = new Properties();
                int unusedPort = AvailablePort.getRandomAvailablePort((int)1);
                config.setProperty("mcast-port", String.valueOf(unusedPort));
                DistributedTestCase.system = (InternalDistributedSystem)DistributedSystem.connect((Properties)config);
                AttributesFactory factory = new AttributesFactory();
                factory.setScope(Scope.LOCAL);
                QueryUsingPoolDUnitTest.this.createRegion(name, factory.create());
                DistributedTestCase.pause(1000);
                try {
                    QueryUsingPoolDUnitTest.this.startBridgeServer(0, false);
                }
                catch (Exception ex) {
                    DistributedTestCase.fail("While starting CacheServer", ex);
                }
            }
        });
        vm0.invoke(new CacheSerializableRunnable("Create Bridge Server"){

            @Override
            public void run2() throws CacheException {
                Region region = QueryUsingPoolDUnitTest.this.getRootRegion().getSubregion(name);
                for (int i = 0; i < 100; ++i) {
                    region.put((Object)("key-" + i), (Object)new TestObject(i, "ibm"));
                }
                try {
                    QueryService qService = region.getCache().getQueryService();
                    qService.createIndex("idIndex", IndexType.FUNCTIONAL, "id", region.getFullPath());
                }
                catch (Exception e) {
                    DistributedTestCase.fail("Failed to create index.", e);
                }
            }
        });
        int port = vm0.invokeInt(QueryUsingPoolDUnitTest.class, "getCacheServerPort");
        String host0 = QueryUsingPoolDUnitTest.getServerHostName(vm0.getHost());
        final String regionName = "/root/" + name;
        String poolName = "testRemoteFullRegionQueries";
        this.createPool(vm1, "testRemoteFullRegionQueries", host0, port);
        vm1.invoke(new CacheSerializableRunnable("Execute queries"){

            @Override
            public void run2() throws CacheException {
                String queryString = null;
                SelectResults results = null;
                Comparator comparator = null;
                Object[] resultsArray = null;
                QueryService qService = null;
                Integer v1 = 0;
                Integer v2 = 0;
                try {
                    qService = PoolManager.find((String)"testRemoteFullRegionQueries").getQueryService();
                }
                catch (Exception e) {
                    DistributedTestCase.fail("Failed to get QueryService.", e);
                }
                String[] qString = new String[]{"SELECT DISTINCT * FROM " + regionName + " WHERE id < 101 ORDER BY id", "SELECT DISTINCT id FROM " + regionName + " WHERE id < 101 ORDER BY id"};
                for (int cnt = 0; cnt < qString.length; ++cnt) {
                    queryString = qString[cnt];
                    try {
                        Query query = qService.newQuery(queryString);
                        results = (SelectResults)query.execute();
                    }
                    catch (Exception e) {
                        DistributedTestCase.fail("Failed executing " + queryString, e);
                    }
                    TestCase.assertEquals((int)100, (int)results.size());
                    TestCase.assertTrue((boolean)results.getCollectionType().isOrdered());
                    comparator = new IdValueComparator();
                    resultsArray = results.toArray();
                    for (int i = 0; i < resultsArray.length; ++i) {
                        if (i + 1 == resultsArray.length) continue;
                        if (resultsArray[i] instanceof TestObject) {
                            v1 = ((TestObject)resultsArray[i]).getId();
                            v2 = ((TestObject)resultsArray[i + 1]).getId();
                        } else {
                            v1 = (Integer)resultsArray[i];
                            v2 = (Integer)resultsArray[i + 1];
                        }
                        TestCase.assertTrue((String)("The id for " + resultsArray[i] + " should be less than the id for " + resultsArray[i + 1]), (comparator.compare(v1, v2) == -1 ? 1 : 0) != 0);
                    }
                }
                String[] qString2 = new String[]{"SELECT DISTINCT id, ticker, price FROM " + regionName + " WHERE id < 101 ORDER BY id", "SELECT DISTINCT ticker, id FROM " + regionName + " WHERE id < 101  ORDER BY id", "SELECT DISTINCT id, ticker FROM " + regionName + " WHERE id < 101  ORDER BY id asc"};
                for (int cnt = 0; cnt < qString2.length; ++cnt) {
                    queryString = qString2[cnt];
                    try {
                        Query query = qService.newQuery(queryString);
                        results = (SelectResults)query.execute();
                    }
                    catch (Exception e) {
                        DistributedTestCase.fail("Failed executing " + queryString, e);
                    }
                    TestCase.assertEquals((int)100, (int)results.size());
                    TestCase.assertTrue((boolean)results.getCollectionType().isOrdered());
                    comparator = new StructIdComparator();
                    resultsArray = results.toArray();
                    for (int i = 0; i < resultsArray.length; ++i) {
                        if (i + 1 == resultsArray.length) continue;
                        TestCase.assertTrue((String)("The id for " + resultsArray[i] + " should be less than the id for " + resultsArray[i + 1]), (comparator.compare(resultsArray[i], resultsArray[i + 1]) == -1 ? 1 : 0) != 0);
                    }
                }
            }
        });
        vm0.invoke(new SerializableRunnable("Stop CacheServer"){

            @Override
            public void run() {
                QueryUsingPoolDUnitTest.this.stopBridgeServer(QueryUsingPoolDUnitTest.this.getCache());
            }
        });
    }

    public void testUnSupportedOps() throws Exception {
        final String name = this.getName();
        String rootRegionName = "root";
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        int numberOfEntries = 100;
        vm0.invoke(new CacheSerializableRunnable("Create Bridge Server"){

            @Override
            public void run2() throws CacheException {
                Properties config = new Properties();
                int unusedPort = AvailablePort.getRandomAvailablePort((int)1);
                config.setProperty("mcast-port", String.valueOf(unusedPort));
                DistributedTestCase.system = (InternalDistributedSystem)DistributedSystem.connect((Properties)config);
                DistributedTestCase.pause(1000);
                try {
                    QueryUsingPoolDUnitTest.this.startBridgeServer(0, false);
                }
                catch (Exception ex) {
                    DistributedTestCase.fail("While starting CacheServer", ex);
                }
            }
        });
        vm0.invoke(new CacheSerializableRunnable("Create two regions"){

            @Override
            public void run2() throws CacheException {
                AttributesFactory factory = new AttributesFactory();
                factory.setScope(Scope.LOCAL);
                Region region1 = QueryUsingPoolDUnitTest.this.createRegion(name, factory.createRegionAttributes());
                Region region2 = QueryUsingPoolDUnitTest.this.createRegion(name + "_2", factory.createRegionAttributes());
                for (int i = 0; i < 100; ++i) {
                    region1.put((Object)("key-" + i), (Object)new TestObject(i, "ibm"));
                    region2.put((Object)("key-" + i), (Object)new TestObject(i, "ibm"));
                }
            }
        });
        int port = vm0.invokeInt(QueryUsingPoolDUnitTest.class, "getCacheServerPort");
        String host0 = QueryUsingPoolDUnitTest.getServerHostName(vm0.getHost());
        final String regionName1 = "/root/" + name;
        String poolName = "testUnSupportedOps";
        this.createPool(vm1, "testUnSupportedOps", host0, port);
        vm1.invoke(new CacheSerializableRunnable("Execute queries"){

            @Override
            public void run2() throws CacheException {
                AttributesFactory factory = new AttributesFactory();
                factory.setScope(Scope.LOCAL);
                Region region1 = QueryUsingPoolDUnitTest.this.createRegion(name, factory.createRegionAttributes());
                String queryString = "select distinct * from " + regionName1 + " where ticker = $1";
                Object[] params = new Object[]{new String("ibm")};
                QueryService qService = null;
                try {
                    qService = PoolManager.find((String)"testUnSupportedOps").getQueryService();
                }
                catch (Exception e) {
                    DistributedTestCase.fail("Failed to get QueryService.", e);
                }
                try {
                    Query query = qService.newQuery(queryString);
                    query.execute(params);
                }
                catch (UnsupportedOperationException query) {
                }
                catch (Exception e) {
                    DistributedTestCase.fail("Failed with UnExpected Exception.", e);
                }
                try {
                    qService.createIndex("test", IndexType.FUNCTIONAL, "ticker", regionName1);
                }
                catch (UnsupportedOperationException e) {
                }
                catch (Exception e) {
                    DistributedTestCase.fail("Failed with UnExpected Exception.", e);
                }
                try {
                    String importString = "import com.gemstone.gemfire.admin.QueryUsingPoolDUnitTest.TestObject;";
                    qService.createIndex("test", IndexType.FUNCTIONAL, "ticker", regionName1, importString);
                }
                catch (UnsupportedOperationException importString) {
                }
                catch (Exception e) {
                    DistributedTestCase.fail("Failed with UnExpected Exception.", e);
                }
                try {
                    qService.getIndex(region1, "test");
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    // empty catch block
                }
                try {
                    qService.getIndexes(region1);
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    // empty catch block
                }
                try {
                    qService.getIndexes(region1, IndexType.FUNCTIONAL);
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    // empty catch block
                }
                try {
                    qService.removeIndexes(region1);
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    // empty catch block
                }
                try {
                    qService.removeIndexes();
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    // empty catch block
                }
            }
        });
        vm0.invoke(new SerializableRunnable("Stop CacheServer"){

            @Override
            public void run() {
                QueryObserverHolder.setInstance((QueryObserver)new QueryObserverAdapter());
                QueryUsingPoolDUnitTest.this.stopBridgeServer(QueryUsingPoolDUnitTest.this.getCache());
            }
        });
    }

    private void compareQueryResultsWithoutAndWithIndexes(Object[][] r, int len) {
        Set set1 = null;
        Set set2 = null;
        Iterator itert1 = null;
        Iterator itert2 = null;
        for (int j = 0; j < len; ++j) {
            ObjectType type1 = ((SelectResults)r[j][0]).getCollectionType().getElementType();
            ObjectType type2 = ((SelectResults)r[j][1]).getCollectionType().getElementType();
            if (type1.getClass().getName().equals(type2.getClass().getName())) {
                QueryUsingPoolDUnitTest.getLogWriter().info("Both SelectResults are of the same Type i.e.--> " + ((SelectResults)r[j][0]).getCollectionType().getElementType());
            } else {
                QueryUsingPoolDUnitTest.getLogWriter().info("Classes are : " + type1.getClass().getName() + " " + type2.getClass().getName());
                QueryUsingPoolDUnitTest.fail((String)"FAILED:Select result Type is different in both the cases");
            }
            if (((SelectResults)r[j][0]).size() == ((SelectResults)r[j][1]).size()) {
                QueryUsingPoolDUnitTest.getLogWriter().info("Both SelectResults are of Same Size i.e.  Size= " + ((SelectResults)r[j][1]).size());
            } else {
                QueryUsingPoolDUnitTest.fail((String)("FAILED:SelectResults size is different in both the cases. Size1=" + ((SelectResults)r[j][0]).size() + " Size2 = " + ((SelectResults)r[j][1]).size()));
            }
            set2 = ((SelectResults)r[j][1]).asSet();
            set1 = ((SelectResults)r[j][0]).asSet();
            QueryUsingPoolDUnitTest.getLogWriter().info(" SIZE1 = " + set1.size() + " SIZE2 = " + set2.size());
            for (Object p1 : set1) {
                itert2 = set2.iterator();
                boolean exactMatch = false;
                while (itert2.hasNext()) {
                    QueryUsingPoolDUnitTest.getLogWriter().info("### Comparing results..");
                    Object p2 = itert2.next();
                    if (p1 instanceof Struct) {
                        QueryUsingPoolDUnitTest.getLogWriter().info("ITS a Set");
                        Object[] values1 = ((Struct)p1).getFieldValues();
                        Object[] values2 = ((Struct)p2).getFieldValues();
                        QueryUsingPoolDUnitTest.assertEquals((int)values1.length, (int)values2.length);
                        boolean elementEqual = true;
                        for (int i = 0; i < values1.length; ++i) {
                            elementEqual = elementEqual && (values1[i] == values2[i] || values1[i].equals(values2[i]));
                        }
                        exactMatch = elementEqual;
                    } else {
                        QueryUsingPoolDUnitTest.getLogWriter().info("Not a Set p2:" + p2 + " p1: " + p1);
                        if (p2 instanceof TestObject) {
                            QueryUsingPoolDUnitTest.getLogWriter().info("An instance of TestObject");
                            exactMatch = p2.equals(p1);
                        } else {
                            QueryUsingPoolDUnitTest.getLogWriter().info("Not an instance of TestObject" + p2.getClass().getCanonicalName());
                            exactMatch = p2.equals(p1);
                        }
                    }
                    if (!exactMatch) continue;
                    QueryUsingPoolDUnitTest.getLogWriter().info("Exact MATCH");
                    break;
                }
                if (exactMatch) continue;
                QueryUsingPoolDUnitTest.getLogWriter().info("NOT A MATCH");
                QueryUsingPoolDUnitTest.fail((String)"Atleast one element in the pair of SelectResults supposedly identical, is not equal ");
            }
            QueryUsingPoolDUnitTest.getLogWriter().info("### Done Comparing results..");
        }
    }

    protected void configAndStartBridgeServer() {
        Properties config = new Properties();
        int unusedPort = AvailablePort.getRandomAvailablePort((int)1);
        config.setProperty("mcast-port", String.valueOf(unusedPort));
        system = (InternalDistributedSystem)DistributedSystem.connect((Properties)config);
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.LOCAL);
        this.createRegion(this.regionName, this.rootRegionName, factory.create());
        QueryUsingPoolDUnitTest.pause(1000);
        try {
            this.startBridgeServer(0, false);
        }
        catch (Exception ex) {
            QueryUsingPoolDUnitTest.fail("While starting CacheServer", ex);
        }
    }

    protected void executeCompiledQueries(String poolName, Object[][] params) {
        SelectResults results = null;
        Object comparator = null;
        Object resultsArray = null;
        QueryService qService = null;
        try {
            qService = PoolManager.find((String)poolName).getQueryService();
        }
        catch (Exception e) {
            QueryUsingPoolDUnitTest.fail("Failed to get QueryService.", e);
        }
        for (int i = 0; i < this.queryString.length; ++i) {
            try {
                QueryUsingPoolDUnitTest.getLogWriter().info("### Executing Query :" + this.queryString[i]);
                Query query = qService.newQuery(this.queryString[i]);
                results = (SelectResults)query.execute(params[i]);
                continue;
            }
            catch (Exception e) {
                QueryUsingPoolDUnitTest.fail("Failed executing " + this.queryString[i], e);
            }
        }
    }

    protected void startBridgeServer(int port, boolean notifyBySubscription) throws IOException {
        Cache cache = this.getCache();
        BridgeServer bridge = cache.addBridgeServer();
        bridge.setPort(port);
        bridge.setNotifyBySubscription(notifyBySubscription);
        bridge.start();
        bridgeServerPort = bridge.getPort();
    }

    protected void stopBridgeServer(Cache cache) {
        BridgeServer bridge = (BridgeServer)cache.getBridgeServers().iterator().next();
        bridge.stop();
        QueryUsingPoolDUnitTest.assertFalse((boolean)bridge.isRunning());
    }

    public void closeClient(VM client) {
        CacheSerializableRunnable closeCache = new CacheSerializableRunnable("Close Client"){

            @Override
            public void run2() throws CacheException {
                DistributedTestCase.getLogWriter().info("### Close Client. ###");
                try {
                    CacheTestCase.closeCache();
                }
                catch (Exception ex) {
                    DistributedTestCase.getLogWriter().info("### Failed to get close client. ###");
                }
            }
        };
        client.invoke(closeCache);
        QueryUsingPoolDUnitTest.pause(2000);
    }

    private static int getCacheServerPort() {
        return bridgeServerPort;
    }

    public static class StructIdComparator
    implements Comparator {
        public int compare(Object obj1, Object obj2) {
            int obj2Id;
            int obj1Id = (Integer)((Struct)obj1).get("id");
            if (obj1Id > (obj2Id = ((Integer)((Struct)obj2).get("id")).intValue())) {
                return 1;
            }
            if (obj1Id < obj2Id) {
                return -1;
            }
            return 0;
        }
    }

    public static class IdValueComparator
    implements Comparator {
        public int compare(Object obj1, Object obj2) {
            int obj2Id;
            int obj1Id = (Integer)obj1;
            if (obj1Id > (obj2Id = ((Integer)obj2).intValue())) {
                return 1;
            }
            if (obj1Id < obj2Id) {
                return -1;
            }
            return 0;
        }
    }

    public static class IdComparator
    implements Comparator {
        public int compare(Object obj1, Object obj2) {
            int obj2Id;
            int obj1Id = ((TestObject)obj1).getId();
            if (obj1Id > (obj2Id = ((TestObject)obj2).getId())) {
                return 1;
            }
            if (obj1Id < obj2Id) {
                return -1;
            }
            return 0;
        }
    }

    public static class TestObject
    implements DataSerializable {
        protected String _ticker;
        protected int _price;
        public int id;
        public int important;
        public int selection;
        public int select;

        public TestObject() {
        }

        public TestObject(int id, String ticker) {
            this.id = id;
            this._ticker = ticker;
            this._price = id;
            this.important = id;
            this.selection = id;
            this.select = id;
        }

        public int getId() {
            return this.id;
        }

        public String getTicker() {
            return this._ticker;
        }

        public int getPrice() {
            return this._price;
        }

        public void toData(DataOutput out) throws IOException {
            out.writeInt(this.id);
            DataSerializer.writeString((String)this._ticker, (DataOutput)out);
            out.writeInt(this._price);
        }

        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            this.id = in.readInt();
            this._ticker = DataSerializer.readString((DataInput)in);
            this._price = in.readInt();
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append("TestObject [").append("id=").append(this.id).append("; ticker=").append(this._ticker).append("; price=").append(this._price).append("]");
            return buffer.toString();
        }

        public boolean equals(Object o) {
            TestObject other = (TestObject)o;
            return this.id == other.id && this._ticker.equals(other._ticker);
        }

        public int hashCode() {
            return this.id;
        }
    }
}

