/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.query.dunit;

import cacheRunner.Portfolio;
import cacheRunner.Position;
import com.gemstone.gemfire.DataSerializable;
import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheLoader;
import com.gemstone.gemfire.cache.CacheWriter;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.query.QueryInvocationTargetException;
import com.gemstone.gemfire.cache.query.SelectResults;
import com.gemstone.gemfire.cache.query.Struct;
import com.gemstone.gemfire.cache.query.internal.QueryObserver;
import com.gemstone.gemfire.cache.query.internal.QueryObserverAdapter;
import com.gemstone.gemfire.cache.query.internal.QueryObserverHolder;
import com.gemstone.gemfire.cache.query.internal.ResultsBag;
import com.gemstone.gemfire.cache.util.BridgeClient;
import com.gemstone.gemfire.cache.util.BridgeServer;
import com.gemstone.gemfire.cache30.BridgeTestCase;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.AvailablePort;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableRunnable;
import dunit.VM;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Comparator;
import java.util.Properties;
import junit.framework.TestCase;

public class RemoteQueryDUnitTest
extends CacheTestCase {
    private static int bridgeServerPort;

    public RemoteQueryDUnitTest(String name) {
        super(name);
    }

    public static void caseSetUp() throws Exception {
        RemoteQueryDUnitTest.disconnectAllFromDS();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tearDown2() throws Exception {
        try {
            super.tearDown2();
        }
        finally {
            RemoteQueryDUnitTest.disconnectAllFromDS();
        }
    }

    public void testRemotePredicateQueries() throws CacheException {
        final String name = this.getName();
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        int numberOfEntries = 100;
        vm0.invoke(new CacheSerializableRunnable("Create Bridge Server"){

            @Override
            public void run2() throws CacheException {
                Properties config = new Properties();
                int unusedPort = AvailablePort.getRandomAvailablePort((int)1);
                config.setProperty("mcast-port", String.valueOf(unusedPort));
                DistributedTestCase.system = (InternalDistributedSystem)DistributedSystem.connect((Properties)config);
                AttributesFactory factory = new AttributesFactory();
                factory.setScope(Scope.LOCAL);
                RemoteQueryDUnitTest.this.createRegion(name, factory.create());
                DistributedTestCase.pause(1000);
                try {
                    RemoteQueryDUnitTest.this.startBridgeServer(0, false);
                }
                catch (Exception ex) {
                    DistributedTestCase.fail("While starting CacheServer", ex);
                }
            }
        });
        vm0.invoke(new CacheSerializableRunnable("Create Bridge Server"){

            @Override
            public void run2() throws CacheException {
                Region region = RemoteQueryDUnitTest.this.getRootRegion().getSubregion(name);
                for (int i = 0; i < 100; ++i) {
                    region.put((Object)("key-" + i), (Object)new TestObject(i, "ibm"));
                }
            }
        });
        final int port = vm0.invokeInt(RemoteQueryDUnitTest.class, "getCacheServerPort");
        final String host0 = RemoteQueryDUnitTest.getServerHostName(vm0.getHost());
        vm1.invoke(new CacheSerializableRunnable("Create region"){

            @Override
            public void run2() throws CacheException {
                Properties config = new Properties();
                config.setProperty("mcast-port", "0");
                DistributedTestCase.system = (InternalDistributedSystem)DistributedSystem.connect((Properties)config);
                RemoteQueryDUnitTest.this.getCache();
                AttributesFactory factory = new AttributesFactory();
                factory.setScope(Scope.LOCAL);
                BridgeTestCase.configureConnectionPool(factory, host0, port, -1, true, -1, -1, null);
                RemoteQueryDUnitTest.this.createRegion(name, factory.create());
            }
        });
        vm1.invoke(new CacheSerializableRunnable("Execute queries"){

            @Override
            public void run2() throws CacheException {
                Region region = RemoteQueryDUnitTest.this.getRootRegion().getSubregion(name);
                String queryString = null;
                SelectResults results = null;
                queryString = "ticker = 'ibm'";
                try {
                    results = region.query(queryString);
                }
                catch (Exception e) {
                    DistributedTestCase.fail("Failed executing " + queryString, e);
                }
                TestCase.assertEquals((int)100, (int)results.size());
                TestCase.assertTrue((results.getClass() == ResultsBag.class ? 1 : 0) != 0);
                TestCase.assertTrue((results.getCollectionType().allowsDuplicates() && !results.getCollectionType().getElementType().isStructType() ? 1 : 0) != 0);
                queryString = "ticker = 'IBM'";
                try {
                    results = region.query(queryString);
                }
                catch (Exception e) {
                    DistributedTestCase.fail("Failed executing " + queryString, e);
                }
                TestCase.assertEquals((int)0, (int)results.size());
                TestCase.assertTrue((results.getClass() == ResultsBag.class ? 1 : 0) != 0);
                TestCase.assertTrue((results.getCollectionType().allowsDuplicates() && !results.getCollectionType().getElementType().isStructType() ? 1 : 0) != 0);
                queryString = "price > 49";
                try {
                    results = region.query(queryString);
                }
                catch (Exception e) {
                    DistributedTestCase.fail("Failed executing " + queryString, e);
                }
                TestCase.assertEquals((int)50, (int)results.size());
                TestCase.assertTrue((results.getClass() == ResultsBag.class ? 1 : 0) != 0);
                TestCase.assertTrue((results.getCollectionType().allowsDuplicates() && !results.getCollectionType().getElementType().isStructType() ? 1 : 0) != 0);
                queryString = "price = 50";
                try {
                    results = region.query(queryString);
                }
                catch (Exception e) {
                    DistributedTestCase.fail("Failed executing " + queryString, e);
                }
                TestCase.assertEquals((int)1, (int)results.size());
                TestCase.assertTrue((results.getClass() == ResultsBag.class ? 1 : 0) != 0);
                TestCase.assertTrue((results.getCollectionType().allowsDuplicates() && !results.getCollectionType().getElementType().isStructType() ? 1 : 0) != 0);
                queryString = "ticker = 'ibm' and price = 50";
                try {
                    results = region.query(queryString);
                }
                catch (Exception e) {
                    DistributedTestCase.fail("Failed executing " + queryString, e);
                }
                TestCase.assertEquals((int)1, (int)results.size());
                TestCase.assertTrue((results.getClass() == ResultsBag.class ? 1 : 0) != 0);
                TestCase.assertTrue((results.getCollectionType().allowsDuplicates() && !results.getCollectionType().getElementType().isStructType() ? 1 : 0) != 0);
            }
        });
        vm0.invoke(new SerializableRunnable("Stop CacheServer"){

            @Override
            public void run() {
                RemoteQueryDUnitTest.this.stopBridgeServer(RemoteQueryDUnitTest.this.getCache());
            }
        });
    }

    public void testRemoteImportQueries() throws CacheException {
        final String name = this.getName();
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        int numberOfEntries = 100;
        vm0.invoke(new CacheSerializableRunnable("Create Bridge Server"){

            @Override
            public void run2() throws CacheException {
                Properties config = new Properties();
                int unusedPort = AvailablePort.getRandomAvailablePort((int)1);
                config.setProperty("mcast-port", String.valueOf(unusedPort));
                DistributedTestCase.system = (InternalDistributedSystem)DistributedSystem.connect((Properties)config);
                AttributesFactory factory = new AttributesFactory();
                factory.setScope(Scope.LOCAL);
                RemoteQueryDUnitTest.this.createRegion(name, factory.create());
                DistributedTestCase.pause(1000);
                try {
                    RemoteQueryDUnitTest.this.startBridgeServer(0, false);
                }
                catch (Exception ex) {
                    DistributedTestCase.fail("While starting CacheServer", ex);
                }
            }
        });
        vm0.invoke(new CacheSerializableRunnable("Create Bridge Server"){

            @Override
            public void run2() throws CacheException {
                Region region = RemoteQueryDUnitTest.this.getRootRegion().getSubregion(name);
                for (int i = 0; i < 100; ++i) {
                    region.put((Object)("key-" + i), (Object)new TestObject(i, "ibm"));
                }
            }
        });
        final int port = vm0.invokeInt(RemoteQueryDUnitTest.class, "getCacheServerPort");
        final String host0 = RemoteQueryDUnitTest.getServerHostName(vm0.getHost());
        vm1.invoke(new CacheSerializableRunnable("Create region"){

            @Override
            public void run2() throws CacheException {
                Properties config = new Properties();
                config.setProperty("mcast-port", "0");
                DistributedTestCase.system = (InternalDistributedSystem)DistributedSystem.connect((Properties)config);
                RemoteQueryDUnitTest.this.getCache();
                AttributesFactory factory = new AttributesFactory();
                factory.setScope(Scope.LOCAL);
                BridgeTestCase.configureConnectionPool(factory, host0, port, -1, true, -1, -1, null);
                RemoteQueryDUnitTest.this.createRegion(name, factory.create());
            }
        });
        vm1.invoke(new CacheSerializableRunnable("Execute queries"){

            @Override
            public void run2() throws CacheException {
                Region region = RemoteQueryDUnitTest.this.getRootRegion().getSubregion(name);
                String queryString = null;
                SelectResults results = null;
                queryString = "import com.gemstone.gemfire.admin.RemoteQueryDUnitTest.TestObject; select distinct * from " + region.getFullPath();
                try {
                    results = region.query(queryString);
                }
                catch (Exception e) {
                    DistributedTestCase.fail("Failed executing " + queryString, e);
                }
                TestCase.assertEquals((int)100, (int)results.size());
                TestCase.assertTrue((!results.getCollectionType().allowsDuplicates() ? 1 : 0) != 0);
                queryString = "import com.gemstone.gemfire.admin.RemoteQueryDUnitTest.TestObject; select distinct * from " + region.getFullPath() + " where ticker = 'ibm'";
                try {
                    results = region.query(queryString);
                }
                catch (Exception e) {
                    DistributedTestCase.fail("Failed executing " + queryString, e);
                }
                TestCase.assertEquals((int)100, (int)results.size());
                TestCase.assertTrue((!results.getCollectionType().allowsDuplicates() ? 1 : 0) != 0);
                queryString = "import com.gemstone.gemfire.admin.RemoteQueryDUnitTest.TestObject; select distinct * from " + region.getFullPath() + " where ticker = 'IBM'";
                try {
                    results = region.query(queryString);
                }
                catch (Exception e) {
                    DistributedTestCase.fail("Failed executing " + queryString, e);
                }
                TestCase.assertEquals((int)0, (int)results.size());
                TestCase.assertTrue((!results.getCollectionType().allowsDuplicates() ? 1 : 0) != 0);
                queryString = "import com.gemstone.gemfire.admin.RemoteQueryDUnitTest.TestObject; select distinct * from " + region.getFullPath() + " where price > 49";
                try {
                    results = region.query(queryString);
                }
                catch (Exception e) {
                    DistributedTestCase.fail("Failed executing " + queryString, e);
                }
                TestCase.assertEquals((int)50, (int)results.size());
                TestCase.assertTrue((!results.getCollectionType().allowsDuplicates() ? 1 : 0) != 0);
                queryString = "import com.gemstone.gemfire.admin.RemoteQueryDUnitTest.TestObject; select distinct * from " + region.getFullPath() + " where price = 50";
                try {
                    results = region.query(queryString);
                }
                catch (Exception e) {
                    DistributedTestCase.fail("Failed executing " + queryString, e);
                }
                TestCase.assertEquals((int)1, (int)results.size());
                TestCase.assertTrue((!results.getCollectionType().allowsDuplicates() ? 1 : 0) != 0);
                queryString = "import com.gemstone.gemfire.admin.RemoteQueryDUnitTest.TestObject; select distinct * from " + region.getFullPath() + " where ticker = 'ibm' and price = 50";
                try {
                    results = region.query(queryString);
                }
                catch (Exception e) {
                    DistributedTestCase.fail("Failed executing " + queryString, e);
                }
                TestCase.assertEquals((int)1, (int)results.size());
                TestCase.assertTrue((!results.getCollectionType().allowsDuplicates() ? 1 : 0) != 0);
            }
        });
        vm0.invoke(new SerializableRunnable("Stop CacheServer"){

            @Override
            public void run() {
                RemoteQueryDUnitTest.this.stopBridgeServer(RemoteQueryDUnitTest.this.getCache());
            }
        });
    }

    public void testRemoteStructQueries() throws CacheException {
        final String name = this.getName();
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        int numberOfEntries = 100;
        vm0.invoke(new CacheSerializableRunnable("Create Bridge Server"){

            @Override
            public void run2() throws CacheException {
                Properties config = new Properties();
                int unusedPort = AvailablePort.getRandomAvailablePort((int)1);
                config.setProperty("mcast-port", String.valueOf(unusedPort));
                DistributedTestCase.system = (InternalDistributedSystem)DistributedSystem.connect((Properties)config);
                AttributesFactory factory = new AttributesFactory();
                factory.setScope(Scope.LOCAL);
                RemoteQueryDUnitTest.this.createRegion(name, factory.create());
                DistributedTestCase.pause(1000);
                try {
                    RemoteQueryDUnitTest.this.startBridgeServer(0, false);
                }
                catch (Exception ex) {
                    DistributedTestCase.fail("While starting CacheServer", ex);
                }
            }
        });
        vm0.invoke(new CacheSerializableRunnable("Create Bridge Server"){

            @Override
            public void run2() throws CacheException {
                Region region = RemoteQueryDUnitTest.this.getRootRegion().getSubregion(name);
                for (int i = 0; i < 100; ++i) {
                    region.put((Object)("key-" + i), (Object)new TestObject(i, "ibm"));
                }
            }
        });
        final int port = vm0.invokeInt(RemoteQueryDUnitTest.class, "getCacheServerPort");
        final String host0 = RemoteQueryDUnitTest.getServerHostName(vm0.getHost());
        vm1.invoke(new CacheSerializableRunnable("Create region"){

            @Override
            public void run2() throws CacheException {
                Properties config = new Properties();
                config.setProperty("mcast-port", "0");
                DistributedTestCase.system = (InternalDistributedSystem)DistributedSystem.connect((Properties)config);
                RemoteQueryDUnitTest.this.getCache();
                AttributesFactory factory = new AttributesFactory();
                factory.setScope(Scope.LOCAL);
                BridgeTestCase.configureConnectionPool(factory, host0, port, -1, true, -1, -1, null);
                RemoteQueryDUnitTest.this.createRegion(name, factory.create());
            }
        });
        vm1.invoke(new CacheSerializableRunnable("Execute queries"){

            @Override
            public void run2() throws CacheException {
                Region region = RemoteQueryDUnitTest.this.getRootRegion().getSubregion(name);
                String queryString = null;
                SelectResults results = null;
                queryString = "import com.gemstone.gemfire.admin.RemoteQueryDUnitTest.TestObject; select distinct ticker, price from " + region.getFullPath();
                try {
                    results = region.query(queryString);
                }
                catch (Exception e) {
                    DistributedTestCase.fail("Failed executing " + queryString, e);
                }
                TestCase.assertEquals((int)100, (int)results.size());
                TestCase.assertTrue((!results.getCollectionType().allowsDuplicates() && results.getCollectionType().getElementType().isStructType() ? 1 : 0) != 0);
                queryString = "import com.gemstone.gemfire.admin.RemoteQueryDUnitTest.TestObject; select distinct ticker, price from " + region.getFullPath() + " where ticker = 'ibm'";
                try {
                    results = region.query(queryString);
                }
                catch (Exception e) {
                    DistributedTestCase.fail("Failed executing " + queryString, e);
                }
                TestCase.assertEquals((int)100, (int)results.size());
                TestCase.assertTrue((!results.getCollectionType().allowsDuplicates() && results.getCollectionType().getElementType().isStructType() ? 1 : 0) != 0);
                queryString = "import com.gemstone.gemfire.admin.RemoteQueryDUnitTest.TestObject; select distinct ticker, price from " + region.getFullPath() + " where ticker = 'IBM'";
                try {
                    results = region.query(queryString);
                }
                catch (Exception e) {
                    DistributedTestCase.fail("Failed executing " + queryString, e);
                }
                TestCase.assertEquals((int)0, (int)results.size());
                TestCase.assertTrue((!results.getCollectionType().allowsDuplicates() && results.getCollectionType().getElementType().isStructType() ? 1 : 0) != 0);
                queryString = "import com.gemstone.gemfire.admin.RemoteQueryDUnitTest.TestObject; select distinct ticker, price from " + region.getFullPath() + " where price > 49";
                try {
                    results = region.query(queryString);
                }
                catch (Exception e) {
                    DistributedTestCase.fail("Failed executing " + queryString, e);
                }
                TestCase.assertEquals((int)50, (int)results.size());
                TestCase.assertTrue((!results.getCollectionType().allowsDuplicates() && results.getCollectionType().getElementType().isStructType() ? 1 : 0) != 0);
                queryString = "import com.gemstone.gemfire.admin.RemoteQueryDUnitTest.TestObject; select distinct ticker, price from " + region.getFullPath() + " where price = 50";
                try {
                    results = region.query(queryString);
                }
                catch (Exception e) {
                    DistributedTestCase.fail("Failed executing " + queryString, e);
                }
                TestCase.assertEquals((int)1, (int)results.size());
                TestCase.assertTrue((!results.getCollectionType().allowsDuplicates() && results.getCollectionType().getElementType().isStructType() ? 1 : 0) != 0);
                queryString = "import com.gemstone.gemfire.admin.RemoteQueryDUnitTest.TestObject; select distinct ticker, price from " + region.getFullPath() + " where ticker = 'ibm' and price = 50";
                try {
                    results = region.query(queryString);
                }
                catch (Exception e) {
                    DistributedTestCase.fail("Failed executing " + queryString, e);
                }
                TestCase.assertEquals((int)1, (int)results.size());
                TestCase.assertTrue((!results.getCollectionType().allowsDuplicates() && results.getCollectionType().getElementType().isStructType() ? 1 : 0) != 0);
            }
        });
        vm0.invoke(new SerializableRunnable("Stop CacheServer"){

            @Override
            public void run() {
                RemoteQueryDUnitTest.this.stopBridgeServer(RemoteQueryDUnitTest.this.getCache());
            }
        });
    }

    public void __testRemoteComplexQueries() throws CacheException {
        final String name = this.getName();
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        vm0.invoke(new CacheSerializableRunnable("Create Bridge Server"){

            @Override
            public void run2() throws CacheException {
                Properties config = new Properties();
                int unusedPort = AvailablePort.getRandomAvailablePort((int)1);
                config.setProperty("mcast-port", String.valueOf(unusedPort));
                DistributedTestCase.system = (InternalDistributedSystem)DistributedSystem.connect((Properties)config);
                AttributesFactory factory = new AttributesFactory();
                factory.setScope(Scope.LOCAL);
                RemoteQueryDUnitTest.this.createRegion(name, factory.create());
                DistributedTestCase.pause(1000);
                try {
                    RemoteQueryDUnitTest.this.startBridgeServer(0, false);
                }
                catch (Exception ex) {
                    DistributedTestCase.fail("While starting CacheServer", ex);
                }
            }
        });
        vm0.invoke(new CacheSerializableRunnable("Create Bridge Server"){

            @Override
            public void run2() throws CacheException {
                Region region = RemoteQueryDUnitTest.this.getRootRegion().getSubregion(name);
                Portfolio portfolio = null;
                Position position1 = null;
                Position position2 = null;
                Properties portfolioProperties = null;
                Properties position1Properties = null;
                Properties position2Properties = null;
                portfolio = new Portfolio();
                portfolioProperties = new Properties();
                portfolioProperties.put("id", new Integer(1));
                portfolioProperties.put("type", "type1");
                portfolioProperties.put("status", "active");
                position1 = new Position();
                position1Properties = new Properties();
                position1Properties.put("secId", "SUN");
                position1Properties.put("qty", new Double(34000.0));
                position1Properties.put("mktValue", new Double(24.42));
                position1.init(position1Properties);
                portfolioProperties.put("position1", position1);
                position2 = new Position();
                position2Properties = new Properties();
                position2Properties.put("secId", "IBM");
                position2Properties.put("qty", new Double(8765.0));
                position2Properties.put("mktValue", new Double(34.29));
                position2.init(position2Properties);
                portfolioProperties.put("position2", position2);
                portfolio.init(portfolioProperties);
                region.put((Object)new Integer(1), (Object)portfolio);
                portfolio = new Portfolio();
                portfolioProperties = new Properties();
                portfolioProperties.put("id", new Integer(2));
                portfolioProperties.put("type", "type2");
                portfolioProperties.put("status", "inactive");
                position1 = new Position();
                position1Properties = new Properties();
                position1Properties.put("secId", "YHOO");
                position1Properties.put("qty", new Double(9834.0));
                position1Properties.put("mktValue", new Double(12.925));
                position1.init(position1Properties);
                portfolioProperties.put("position1", position1);
                position2 = new Position();
                position2Properties = new Properties();
                position2Properties.put("secId", "GOOG");
                position2Properties.put("qty", new Double(12176.0));
                position2Properties.put("mktValue", new Double(21.972));
                position2.init(position2Properties);
                portfolioProperties.put("position2", position2);
                portfolio.init(portfolioProperties);
                region.put((Object)new Integer(2), (Object)portfolio);
                portfolio = new Portfolio();
                portfolioProperties = new Properties();
                portfolioProperties.put("id", new Integer(3));
                portfolioProperties.put("type", "type3");
                portfolioProperties.put("status", "active");
                position1 = new Position();
                position1Properties = new Properties();
                position1Properties.put("secId", "MSFT");
                position1Properties.put("qty", new Double(98327.0));
                position1Properties.put("mktValue", new Double(23.32));
                position1.init(position1Properties);
                portfolioProperties.put("position1", position1);
                position2 = new Position();
                position2Properties = new Properties();
                position2Properties.put("secId", "AOL");
                position2Properties.put("qty", new Double(978.0));
                position2Properties.put("mktValue", new Double(40.373));
                position2.init(position2Properties);
                portfolioProperties.put("position2", position2);
                portfolio.init(portfolioProperties);
                region.put((Object)new Integer(3), (Object)portfolio);
                portfolio = new Portfolio();
                portfolioProperties = new Properties();
                portfolioProperties.put("id", new Integer(4));
                portfolioProperties.put("type", "type1");
                portfolioProperties.put("status", "inactive");
                position1 = new Position();
                position1Properties = new Properties();
                position1Properties.put("secId", "APPL");
                position1Properties.put("qty", new Double(90.0));
                position1Properties.put("mktValue", new Double(67.356572));
                position1.init(position1Properties);
                portfolioProperties.put("position1", position1);
                position2 = new Position();
                position2Properties = new Properties();
                position2Properties.put("secId", "ORCL");
                position2Properties.put("qty", new Double(376.0));
                position2Properties.put("mktValue", new Double(101.34));
                position2.init(position2Properties);
                portfolioProperties.put("position2", position2);
                portfolio.init(portfolioProperties);
                region.put((Object)new Integer(4), (Object)portfolio);
            }
        });
        final int port = vm0.invokeInt(RemoteQueryDUnitTest.class, "getCacheServerPort");
        final String host0 = RemoteQueryDUnitTest.getServerHostName(vm0.getHost());
        vm1.invoke(new CacheSerializableRunnable("Create region"){

            @Override
            public void run2() throws CacheException {
                Properties config = new Properties();
                config.setProperty("mcast-port", "0");
                DistributedTestCase.system = (InternalDistributedSystem)DistributedSystem.connect((Properties)config);
                RemoteQueryDUnitTest.this.getCache();
                AttributesFactory factory = new AttributesFactory();
                factory.setScope(Scope.LOCAL);
                BridgeTestCase.configureConnectionPool(factory, host0, port, -1, true, -1, -1, null);
                RemoteQueryDUnitTest.this.createRegion(name, factory.create());
            }
        });
        vm1.invoke(new CacheSerializableRunnable("Execute queries"){

            @Override
            public void run2() throws CacheException {
                Region region = RemoteQueryDUnitTest.this.getRootRegion().getSubregion(name);
                String queryString = null;
                SelectResults results = null;
                queryString = "IMPORT cacheRunner.Position; SELECT DISTINCT id, status FROM " + region.getFullPath() + "WHERE NOT (SELECT DISTINCT * FROM positions.values posnVal TYPE Position " + "WHERE posnVal.secId='AOL' OR posnVal.secId='SAP').isEmpty";
                try {
                    results = region.query(queryString);
                }
                catch (Exception e) {
                    DistributedTestCase.fail("Failed executing " + queryString, e);
                }
                DistributedTestCase.getLogWriter().fine("size: " + results.size());
                TestCase.assertTrue((!results.getCollectionType().allowsDuplicates() && results.getCollectionType().getElementType().isStructType() ? 1 : 0) != 0);
            }
        });
        vm0.invoke(new SerializableRunnable("Stop CacheServer"){

            @Override
            public void run() {
                RemoteQueryDUnitTest.this.stopBridgeServer(RemoteQueryDUnitTest.this.getCache());
            }
        });
    }

    public void testRemoteFullRegionQueries() throws CacheException {
        final String name = this.getName();
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        int numberOfEntries = 100;
        vm0.invoke(new CacheSerializableRunnable("Create Bridge Server"){

            @Override
            public void run2() throws CacheException {
                Properties config = new Properties();
                int unusedPort = AvailablePort.getRandomAvailablePort((int)1);
                config.setProperty("mcast-port", String.valueOf(unusedPort));
                DistributedTestCase.system = (InternalDistributedSystem)DistributedSystem.connect((Properties)config);
                AttributesFactory factory = new AttributesFactory();
                factory.setScope(Scope.LOCAL);
                RemoteQueryDUnitTest.this.createRegion(name, factory.create());
                DistributedTestCase.pause(1000);
                try {
                    RemoteQueryDUnitTest.this.startBridgeServer(0, false);
                }
                catch (Exception ex) {
                    DistributedTestCase.fail("While starting CacheServer", ex);
                }
            }
        });
        vm0.invoke(new CacheSerializableRunnable("Create Bridge Server"){

            @Override
            public void run2() throws CacheException {
                Region region = RemoteQueryDUnitTest.this.getRootRegion().getSubregion(name);
                for (int i = 0; i < 100; ++i) {
                    region.put((Object)("key-" + i), (Object)new TestObject(i, "ibm"));
                }
            }
        });
        final int port = vm0.invokeInt(RemoteQueryDUnitTest.class, "getCacheServerPort");
        final String host0 = RemoteQueryDUnitTest.getServerHostName(vm0.getHost());
        vm1.invoke(new CacheSerializableRunnable("Create region"){

            @Override
            public void run2() throws CacheException {
                Properties config = new Properties();
                config.setProperty("mcast-port", "0");
                DistributedTestCase.system = (InternalDistributedSystem)DistributedSystem.connect((Properties)config);
                RemoteQueryDUnitTest.this.getCache();
                AttributesFactory factory = new AttributesFactory();
                factory.setScope(Scope.LOCAL);
                BridgeTestCase.configureConnectionPool(factory, host0, port, -1, true, -1, -1, null);
                RemoteQueryDUnitTest.this.createRegion(name, factory.create());
            }
        });
        vm1.invoke(new CacheSerializableRunnable("Execute queries"){

            @Override
            public void run2() throws CacheException {
                Region region = RemoteQueryDUnitTest.this.getRootRegion().getSubregion(name);
                String queryString = null;
                SelectResults results = null;
                Comparator comparator = null;
                Object[] resultsArray = null;
                queryString = "SELECT DISTINCT itr.value FROM " + region.getFullPath() + ".entries itr where itr.key = 'key-1'";
                try {
                    results = region.query(queryString);
                }
                catch (Exception e) {
                    DistributedTestCase.fail("Failed executing " + queryString, e);
                }
                TestCase.assertEquals((int)1, (int)results.size());
                TestCase.assertTrue((!results.getCollectionType().allowsDuplicates() ? 1 : 0) != 0);
                TestCase.assertTrue((boolean)(results.asList().get(0) instanceof TestObject));
                queryString = "SELECT DISTINCT itr.key FROM " + region.getFullPath() + ".entries itr where itr.key = 'key-1'";
                try {
                    results = region.query(queryString);
                }
                catch (Exception e) {
                    DistributedTestCase.fail("Failed executing " + queryString, e);
                }
                TestCase.assertEquals((int)1, (int)results.size());
                TestCase.assertTrue((!results.getCollectionType().allowsDuplicates() ? 1 : 0) != 0);
                TestCase.assertEquals((Object)"key-1", results.asList().get(0));
                queryString = "SELECT DISTINCT * FROM " + region.getFullPath() + " WHERE id < 101 ORDER BY id";
                try {
                    results = region.query(queryString);
                }
                catch (Exception e) {
                    DistributedTestCase.fail("Failed executing " + queryString, e);
                }
                TestCase.assertEquals((int)100, (int)results.size());
                TestCase.assertTrue((boolean)results.getCollectionType().isOrdered());
                comparator = new IdComparator();
                resultsArray = results.toArray();
                for (int i = 0; i < resultsArray.length; ++i) {
                    if (i + 1 == resultsArray.length) continue;
                    TestCase.assertTrue((String)("The id for " + resultsArray[i] + " should be less than the id for " + resultsArray[i + 1]), (comparator.compare(resultsArray[i], resultsArray[i + 1]) == -1 ? 1 : 0) != 0);
                }
                queryString = "SELECT DISTINCT id, ticker, price FROM " + region.getFullPath() + " WHERE id < 101 ORDER BY id";
                try {
                    results = region.query(queryString);
                }
                catch (Exception e) {
                    DistributedTestCase.fail("Failed executing " + queryString, e);
                }
                TestCase.assertEquals((int)100, (int)results.size());
                TestCase.assertTrue((boolean)results.getCollectionType().isOrdered());
                comparator = new StructIdComparator();
                resultsArray = results.toArray();
                for (int i = 0; i < resultsArray.length; ++i) {
                    if (i + 1 == resultsArray.length) continue;
                    TestCase.assertTrue((String)("The id for " + resultsArray[i] + " should be less than the id for " + resultsArray[i + 1]), (comparator.compare(resultsArray[i], resultsArray[i + 1]) == -1 ? 1 : 0) != 0);
                }
                queryString = "(SELECT DISTINCT * FROM " + region.getFullPath() + " WHERE id < 101).size";
                try {
                    results = region.query(queryString);
                }
                catch (Exception e) {
                    DistributedTestCase.fail("Failed executing " + queryString, e);
                }
                TestCase.assertEquals((int)1, (int)results.size());
                Object result = results.iterator().next();
                TestCase.assertTrue((boolean)(result instanceof Integer));
                int resultInt = (Integer)result;
                TestCase.assertEquals((int)resultInt, (int)100);
                queryString = " SELECT DISTINCT itr.key FROM " + region.getFullPath() + ".entries itr where itr.key = 'key-1' ";
                try {
                    results = region.query(queryString);
                }
                catch (Exception e) {
                    DistributedTestCase.fail("Failed executing " + queryString, e);
                }
                TestCase.assertEquals((int)1, (int)results.size());
                TestCase.assertEquals((Object)"key-1", results.asList().get(0));
            }
        });
        vm0.invoke(new SerializableRunnable("Stop CacheServer"){

            @Override
            public void run() {
                RemoteQueryDUnitTest.this.stopBridgeServer(RemoteQueryDUnitTest.this.getCache());
            }
        });
    }

    public void testRemoteJoinRegionQueries() throws CacheException {
        final String name = this.getName();
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        int numberOfEntries = 100;
        vm0.invoke(new CacheSerializableRunnable("Create Bridge Server"){

            @Override
            public void run2() throws CacheException {
                Properties config = new Properties();
                int unusedPort = AvailablePort.getRandomAvailablePort((int)1);
                config.setProperty("mcast-port", String.valueOf(unusedPort));
                DistributedTestCase.system = (InternalDistributedSystem)DistributedSystem.connect((Properties)config);
                AttributesFactory factory = new AttributesFactory();
                factory.setScope(Scope.LOCAL);
                RemoteQueryDUnitTest.this.createRegion(name + "1", factory.create());
                RemoteQueryDUnitTest.this.createRegion(name + "2", factory.create());
                DistributedTestCase.pause(1000);
                try {
                    RemoteQueryDUnitTest.this.startBridgeServer(0, false);
                }
                catch (Exception ex) {
                    DistributedTestCase.fail("While starting CacheServer", ex);
                }
            }
        });
        vm0.invoke(new CacheSerializableRunnable("Create Bridge Server"){

            @Override
            public void run2() throws CacheException {
                Region region1 = RemoteQueryDUnitTest.this.getRootRegion().getSubregion(name + "1");
                for (int i = 0; i < 100; ++i) {
                    region1.put((Object)("key-" + i), (Object)new TestObject(i, "ibm"));
                }
                Region region2 = RemoteQueryDUnitTest.this.getRootRegion().getSubregion(name + "2");
                for (int i = 0; i < 100; ++i) {
                    region2.put((Object)("key-" + i), (Object)new TestObject(i, "ibm"));
                }
            }
        });
        final int port = vm0.invokeInt(RemoteQueryDUnitTest.class, "getCacheServerPort");
        final String host0 = RemoteQueryDUnitTest.getServerHostName(vm0.getHost());
        vm1.invoke(new CacheSerializableRunnable("Create region"){

            @Override
            public void run2() throws CacheException {
                Properties config = new Properties();
                config.setProperty("mcast-port", "0");
                DistributedTestCase.system = (InternalDistributedSystem)DistributedSystem.connect((Properties)config);
                RemoteQueryDUnitTest.this.getCache();
                AttributesFactory factory = new AttributesFactory();
                factory.setScope(Scope.LOCAL);
                BridgeTestCase.configureConnectionPool(factory, host0, port, -1, true, -1, -1, null);
                RemoteQueryDUnitTest.this.createRegion(name + "1", factory.create());
                RemoteQueryDUnitTest.this.createRegion(name + "2", factory.create());
            }
        });
        vm1.invoke(new CacheSerializableRunnable("Execute queries"){

            @Override
            public void run2() throws CacheException {
                Region region1 = RemoteQueryDUnitTest.this.getRootRegion().getSubregion(name + "1");
                Region region2 = RemoteQueryDUnitTest.this.getRootRegion().getSubregion(name + "2");
                String queryString = null;
                SelectResults results = null;
                queryString = "select distinct a, b.price from " + region1.getFullPath() + " a, " + region2.getFullPath() + " b where a.price = b.price";
                try {
                    results = region1.query(queryString);
                }
                catch (Exception e) {
                    DistributedTestCase.fail("Failed executing " + queryString, e);
                }
                TestCase.assertEquals((int)100, (int)results.size());
                TestCase.assertTrue((!results.getCollectionType().allowsDuplicates() && results.getCollectionType().getElementType().isStructType() ? 1 : 0) != 0);
                queryString = "select distinct a, b.price from " + region1.getFullPath() + " a, " + region2.getFullPath() + " b where a.price = b.price and a.price = 50";
                try {
                    results = region1.query(queryString);
                }
                catch (Exception e) {
                    DistributedTestCase.fail("Failed executing " + queryString, e);
                }
                TestCase.assertEquals((int)1, (int)results.size());
                TestCase.assertTrue((!results.getCollectionType().allowsDuplicates() && results.getCollectionType().getElementType().isStructType() ? 1 : 0) != 0);
            }
        });
        vm0.invoke(new SerializableRunnable("Stop CacheServer"){

            @Override
            public void run() {
                RemoteQueryDUnitTest.this.stopBridgeServer(RemoteQueryDUnitTest.this.getCache());
            }
        });
    }

    public void testRemoteBridgeClientQueries() throws CacheException {
        final String name = this.getName();
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        int numberOfEntries = 100;
        vm0.invoke(new CacheSerializableRunnable("Create Bridge Server"){

            @Override
            public void run2() throws CacheException {
                Properties config = new Properties();
                int unusedPort = AvailablePort.getRandomAvailablePort((int)1);
                config.setProperty("mcast-port", String.valueOf(unusedPort));
                DistributedTestCase.system = (InternalDistributedSystem)DistributedSystem.connect((Properties)config);
                AttributesFactory factory = new AttributesFactory();
                factory.setScope(Scope.LOCAL);
                RemoteQueryDUnitTest.this.createRegion(name, factory.create());
                DistributedTestCase.pause(1000);
                try {
                    RemoteQueryDUnitTest.this.startBridgeServer(0, false);
                }
                catch (Exception ex) {
                    DistributedTestCase.fail("While starting CacheServer", ex);
                }
            }
        });
        vm0.invoke(new CacheSerializableRunnable("Create Bridge Server"){

            @Override
            public void run2() throws CacheException {
                Region region = RemoteQueryDUnitTest.this.getRootRegion().getSubregion(name);
                for (int i = 0; i < 100; ++i) {
                    region.put((Object)("key-" + i), (Object)new TestObject(i, "ibm"));
                }
            }
        });
        final int port = vm0.invokeInt(RemoteQueryDUnitTest.class, "getCacheServerPort");
        final String host0 = RemoteQueryDUnitTest.getServerHostName(vm0.getHost());
        vm1.invoke(new CacheSerializableRunnable("Create region"){

            @Override
            public void run2() throws CacheException {
                Properties config = new Properties();
                config.setProperty("mcast-port", "0");
                DistributedTestCase.system = (InternalDistributedSystem)DistributedSystem.connect((Properties)config);
                RemoteQueryDUnitTest.this.getCache();
                AttributesFactory factory = new AttributesFactory();
                factory.setScope(Scope.LOCAL);
                BridgeClient writer = new BridgeClient();
                Properties props = new Properties();
                props.setProperty("endpoints", "server=" + host0 + ":" + port);
                props.setProperty("establishCallbackConnection", "true");
                writer.init(props);
                factory.setCacheWriter((CacheWriter)writer);
                RemoteQueryDUnitTest.this.createRegion(name, factory.create());
            }
        });
        vm2.invoke(new CacheSerializableRunnable("Create region"){

            @Override
            public void run2() throws CacheException {
                Properties config = new Properties();
                config.setProperty("mcast-port", "0");
                DistributedTestCase.system = (InternalDistributedSystem)DistributedSystem.connect((Properties)config);
                RemoteQueryDUnitTest.this.getCache();
                AttributesFactory factory = new AttributesFactory();
                factory.setScope(Scope.LOCAL);
                BridgeClient loader = new BridgeClient();
                Properties props = new Properties();
                props.setProperty("endpoints", "server=" + host0 + ":" + port);
                props.setProperty("establishCallbackConnection", "true");
                loader.init(props);
                factory.setCacheLoader((CacheLoader)loader);
                RemoteQueryDUnitTest.this.createRegion(name, factory.create());
            }
        });
        vm1.invoke(new CacheSerializableRunnable("Execute queries"){

            @Override
            public void run2() throws CacheException {
                Region region = RemoteQueryDUnitTest.this.getRootRegion().getSubregion(name);
                String queryString = null;
                SelectResults results = null;
                queryString = "SELECT DISTINCT itr.value FROM " + region.getFullPath() + ".entries itr where itr.key = 'key-1'";
                try {
                    results = region.query(queryString);
                }
                catch (Exception e) {
                    DistributedTestCase.fail("Failed executing " + queryString, e);
                }
                TestCase.assertEquals((int)1, (int)results.size());
                TestCase.assertTrue((!results.getCollectionType().allowsDuplicates() && !results.getCollectionType().getElementType().isStructType() ? 1 : 0) != 0);
                TestCase.assertTrue((boolean)(results.asList().get(0) instanceof TestObject));
                queryString = "SELECT DISTINCT itr.key FROM " + region.getFullPath() + ".entries itr where itr.key = 'key-1'";
                try {
                    results = region.query(queryString);
                }
                catch (Exception e) {
                    DistributedTestCase.fail("Failed executing " + queryString, e);
                }
                TestCase.assertEquals((int)1, (int)results.size());
                TestCase.assertTrue((!results.getCollectionType().allowsDuplicates() && !results.getCollectionType().getElementType().isStructType() ? 1 : 0) != 0);
                TestCase.assertEquals((Object)"key-1", results.asList().get(0));
            }
        });
        vm2.invoke(new CacheSerializableRunnable("Execute queries"){

            @Override
            public void run2() throws CacheException {
                Region region = RemoteQueryDUnitTest.this.getRootRegion().getSubregion(name);
                String queryString = null;
                SelectResults results = null;
                queryString = "SELECT DISTINCT itr.value FROM " + region.getFullPath() + ".entries itr where itr.key = 'key-1'";
                try {
                    results = region.query(queryString);
                }
                catch (Exception e) {
                    DistributedTestCase.fail("Failed executing " + queryString, e);
                }
                TestCase.assertEquals((int)1, (int)results.size());
                TestCase.assertTrue((!results.getCollectionType().allowsDuplicates() && !results.getCollectionType().getElementType().isStructType() ? 1 : 0) != 0);
                TestCase.assertTrue((boolean)(results.asList().get(0) instanceof TestObject));
                queryString = "SELECT DISTINCT itr.key FROM " + region.getFullPath() + ".entries itr where itr.key = 'key-1'";
                try {
                    results = region.query(queryString);
                }
                catch (Exception e) {
                    DistributedTestCase.fail("Failed executing " + queryString, e);
                }
                TestCase.assertEquals((int)1, (int)results.size());
                TestCase.assertTrue((!results.getCollectionType().allowsDuplicates() && !results.getCollectionType().getElementType().isStructType() ? 1 : 0) != 0);
                TestCase.assertEquals((Object)"key-1", results.asList().get(0));
            }
        });
        vm1.invoke(new CacheSerializableRunnable("Close client"){

            @Override
            public void run2() throws CacheException {
                Region region = RemoteQueryDUnitTest.this.getRootRegion().getSubregion(name);
                BridgeClient writer = (BridgeClient)region.getAttributes().getCacheWriter();
                writer.close();
                region.getAttributesMutator().setCacheWriter(null);
            }
        });
        vm2.invoke(new CacheSerializableRunnable("Close client"){

            @Override
            public void run2() throws CacheException {
                Region region = RemoteQueryDUnitTest.this.getRootRegion().getSubregion(name);
                BridgeClient loader = (BridgeClient)region.getAttributes().getCacheLoader();
                loader.close();
                region.getAttributesMutator().setCacheLoader(null);
            }
        });
        vm0.invoke(new SerializableRunnable("Stop CacheServer"){

            @Override
            public void run() {
                RemoteQueryDUnitTest.this.stopBridgeServer(RemoteQueryDUnitTest.this.getCache());
            }
        });
    }

    public void testBug36434() throws Exception {
        final String name = this.getName();
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        int numberOfEntries = 100;
        vm0.invoke(new CacheSerializableRunnable("Create Bridge Server"){

            @Override
            public void run2() throws CacheException {
                Properties config = new Properties();
                int unusedPort = AvailablePort.getRandomAvailablePort((int)1);
                config.setProperty("mcast-port", String.valueOf(unusedPort));
                DistributedTestCase.system = (InternalDistributedSystem)DistributedSystem.connect((Properties)config);
                AttributesFactory factory = new AttributesFactory();
                factory.setScope(Scope.LOCAL);
                RemoteQueryDUnitTest.this.createRegion(name, factory.createRegionAttributes());
                DistributedTestCase.pause(1000);
                try {
                    RemoteQueryDUnitTest.this.startBridgeServer(0, false);
                }
                catch (Exception ex) {
                    DistributedTestCase.fail("While starting CacheServer", ex);
                }
            }
        });
        vm0.invoke(new CacheSerializableRunnable("Create Bridge Server"){

            @Override
            public void run2() throws CacheException {
                Region region = RemoteQueryDUnitTest.this.getRootRegion().getSubregion(name);
                for (int i = 0; i < 100; ++i) {
                    region.put((Object)("key-" + i), (Object)new TestObject(i, "ibm"));
                }
            }
        });
        final int port = vm0.invokeInt(RemoteQueryDUnitTest.class, "getCacheServerPort");
        final String host0 = RemoteQueryDUnitTest.getServerHostName(vm0.getHost());
        vm1.invoke(new CacheSerializableRunnable("Create region"){

            @Override
            public void run2() throws CacheException {
                Properties config = new Properties();
                config.setProperty("mcast-port", "0");
                DistributedTestCase.system = (InternalDistributedSystem)DistributedSystem.connect((Properties)config);
                RemoteQueryDUnitTest.this.getCache();
                AttributesFactory factory = new AttributesFactory();
                factory.setScope(Scope.LOCAL);
                BridgeClient writer = new BridgeClient();
                Properties props = new Properties();
                props.setProperty("endpoints", "server=" + host0 + ":" + port);
                props.setProperty("establishCallbackConnection", "true");
                writer.init(props);
                factory.setCacheWriter((CacheWriter)writer);
                RemoteQueryDUnitTest.this.createRegion(name, factory.createRegionAttributes());
            }
        });
        vm1.invoke(new CacheSerializableRunnable("Execute queries"){

            @Override
            public void run2() throws CacheException {
                Region region = RemoteQueryDUnitTest.this.getRootRegion().getSubregion(name);
                String[] queryStrings = new String[]{"id<9", "selection<9", "important<9", "\"select\"<9"};
                for (int i = 0; i < queryStrings.length; ++i) {
                    SelectResults results = null;
                    try {
                        results = region.query(queryStrings[i]);
                    }
                    catch (Exception e) {
                        DistributedTestCase.fail("Failed executing " + queryStrings[i], e);
                    }
                    TestCase.assertEquals((int)9, (int)results.size());
                    String msg = "results expected to be instance of ResultsBag, but was found to be is instance of '";
                    TestCase.assertTrue((String)(msg + results.getClass().getName() + "'"), (boolean)(results instanceof ResultsBag));
                    TestCase.assertTrue((boolean)(results.asList().get(0) instanceof TestObject));
                }
            }
        });
        vm1.invoke(new CacheSerializableRunnable("Close client"){

            @Override
            public void run2() throws CacheException {
                Region region = RemoteQueryDUnitTest.this.getRootRegion().getSubregion(name);
                BridgeClient writer = (BridgeClient)region.getAttributes().getCacheWriter();
                writer.close();
                region.getAttributesMutator().setCacheWriter(null);
            }
        });
        vm0.invoke(new SerializableRunnable("Stop CacheServer"){

            @Override
            public void run() {
                RemoteQueryDUnitTest.this.stopBridgeServer(RemoteQueryDUnitTest.this.getCache());
            }
        });
    }

    public void testBug36969() throws Exception {
        final String name = this.getName();
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        int numberOfEntries = 100;
        vm0.invoke(new CacheSerializableRunnable("Create Bridge Server"){

            @Override
            public void run2() throws CacheException {
                Properties config = new Properties();
                int unusedPort = AvailablePort.getRandomAvailablePort((int)1);
                config.setProperty("mcast-port", String.valueOf(unusedPort));
                DistributedTestCase.system = (InternalDistributedSystem)DistributedSystem.connect((Properties)config);
                AttributesFactory factory = new AttributesFactory();
                factory.setScope(Scope.LOCAL);
                final Region region = RemoteQueryDUnitTest.this.createRegion(name, factory.createRegionAttributes());
                QueryObserverHolder.setInstance((QueryObserver)new QueryObserverAdapter(){

                    public void afterQueryEvaluation(Object result) {
                        region.close();
                    }
                });
                DistributedTestCase.pause(1000);
                try {
                    RemoteQueryDUnitTest.this.startBridgeServer(0, false);
                }
                catch (Exception ex) {
                    DistributedTestCase.fail("While starting CacheServer", ex);
                }
            }
        });
        vm0.invoke(new CacheSerializableRunnable("Create Bridge Server"){

            @Override
            public void run2() throws CacheException {
                Region region = RemoteQueryDUnitTest.this.getRootRegion().getSubregion(name);
                for (int i = 0; i < 100; ++i) {
                    region.put((Object)("key-" + i), (Object)new TestObject(i, "ibm"));
                }
            }
        });
        final int port = vm0.invokeInt(RemoteQueryDUnitTest.class, "getCacheServerPort");
        final String host0 = RemoteQueryDUnitTest.getServerHostName(vm0.getHost());
        vm1.invoke(new CacheSerializableRunnable("Create region"){

            @Override
            public void run2() throws CacheException {
                Properties config = new Properties();
                config.setProperty("mcast-port", "0");
                DistributedTestCase.system = (InternalDistributedSystem)DistributedSystem.connect((Properties)config);
                RemoteQueryDUnitTest.this.getCache();
                AttributesFactory factory = new AttributesFactory();
                factory.setScope(Scope.LOCAL);
                BridgeClient writer = new BridgeClient();
                Properties props = new Properties();
                props.setProperty("endpoints", "server=" + host0 + ":" + port);
                props.setProperty("establishCallbackConnection", "true");
                writer.init(props);
                factory.setCacheWriter((CacheWriter)writer);
                RemoteQueryDUnitTest.this.createRegion(name, factory.createRegionAttributes());
            }
        });
        vm1.invoke(new CacheSerializableRunnable("Execute queries"){

            @Override
            public void run2() throws CacheException {
                Region region = RemoteQueryDUnitTest.this.getRootRegion().getSubregion(name);
                String queryStrings = "id<9";
                try {
                    region.query(queryStrings);
                    TestCase.fail((String)"The query should have experienced RegionDestroyedException");
                }
                catch (QueryInvocationTargetException queryInvocationTargetException) {
                }
                catch (Exception e) {
                    DistributedTestCase.fail("Failed executing query " + queryStrings + " due  to unexpected Excecption", e);
                }
            }
        });
        vm0.invoke(new CacheSerializableRunnable("Create two regions"){

            @Override
            public void run2() throws CacheException {
                AttributesFactory factory = new AttributesFactory();
                factory.setScope(Scope.LOCAL);
                final Region region1 = RemoteQueryDUnitTest.this.createRegion(name, factory.createRegionAttributes());
                Region region2 = RemoteQueryDUnitTest.this.createRegion(name + "_2", factory.createRegionAttributes());
                QueryObserverHolder.setInstance((QueryObserver)new QueryObserverAdapter(){

                    public void afterQueryEvaluation(Object result) {
                        region1.close();
                    }
                });
                DistributedTestCase.pause(1000);
                for (int i = 0; i < 100; ++i) {
                    region1.put((Object)("key-" + i), (Object)new TestObject(i, "ibm"));
                    region2.put((Object)("key-" + i), (Object)new TestObject(i, "ibm"));
                }
            }
        });
        vm1.invoke(new CacheSerializableRunnable("Execute queries"){

            @Override
            public void run2() throws CacheException {
                Region region = RemoteQueryDUnitTest.this.getRootRegion().getSubregion(name);
                String queryString = "select distinct * from /" + name + ",/" + name + "_2";
                try {
                    region.query(queryString);
                    TestCase.fail((String)"The query should have experienced RegionDestroyedException");
                }
                catch (QueryInvocationTargetException queryInvocationTargetException) {
                }
                catch (Exception e) {
                    DistributedTestCase.fail("Failed executing query " + queryString + " due  to unexpected Excecption", e);
                }
            }
        });
        vm1.invoke(new CacheSerializableRunnable("Close client"){

            @Override
            public void run2() throws CacheException {
                Region region = RemoteQueryDUnitTest.this.getRootRegion().getSubregion(name);
                BridgeClient writer = (BridgeClient)region.getAttributes().getCacheWriter();
                writer.close();
                region.getAttributesMutator().setCacheWriter(null);
            }
        });
        vm0.invoke(new SerializableRunnable("Stop CacheServer"){

            @Override
            public void run() {
                QueryObserverHolder.setInstance((QueryObserver)new QueryObserverAdapter());
                RemoteQueryDUnitTest.this.stopBridgeServer(RemoteQueryDUnitTest.this.getCache());
            }
        });
    }

    protected void startBridgeServer(int port, boolean notifyBySubscription) throws IOException {
        Cache cache = this.getCache();
        BridgeServer bridge = cache.addBridgeServer();
        bridge.setPort(port);
        bridge.setNotifyBySubscription(notifyBySubscription);
        bridge.start();
        bridgeServerPort = bridge.getPort();
    }

    protected void stopBridgeServer(Cache cache) {
        BridgeServer bridge = (BridgeServer)cache.getBridgeServers().iterator().next();
        bridge.stop();
        RemoteQueryDUnitTest.assertFalse((boolean)bridge.isRunning());
    }

    private static int getCacheServerPort() {
        return bridgeServerPort;
    }

    public static class StructIdComparator
    implements Comparator {
        public int compare(Object obj1, Object obj2) {
            int obj2Id;
            int obj1Id = (Integer)((Struct)obj1).get("id");
            if (obj1Id > (obj2Id = ((Integer)((Struct)obj2).get("id")).intValue())) {
                return 1;
            }
            if (obj1Id < obj2Id) {
                return -1;
            }
            return 0;
        }
    }

    public static class IdComparator
    implements Comparator {
        public int compare(Object obj1, Object obj2) {
            int obj2Id;
            int obj1Id = ((TestObject)obj1).getId();
            if (obj1Id > (obj2Id = ((TestObject)obj2).getId())) {
                return 1;
            }
            if (obj1Id < obj2Id) {
                return -1;
            }
            return 0;
        }
    }

    public static class TestObject
    implements DataSerializable {
        protected String _ticker;
        protected int _price;
        public int id;
        public int important;
        public int selection;
        public int select;

        public TestObject() {
        }

        public TestObject(int id, String ticker) {
            this.id = id;
            this._ticker = ticker;
            this._price = id;
            this.important = id;
            this.selection = id;
            this.select = id;
        }

        public int getId() {
            return this.id;
        }

        public String getTicker() {
            return this._ticker;
        }

        public int getPrice() {
            return this._price;
        }

        public void toData(DataOutput out) throws IOException {
            out.writeInt(this.id);
            DataSerializer.writeString((String)this._ticker, (DataOutput)out);
            out.writeInt(this._price);
        }

        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            this.id = in.readInt();
            this._ticker = DataSerializer.readString((DataInput)in);
            this._price = in.readInt();
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append("TestObject [").append("id=").append(this.id).append("; ticker=").append(this._ticker).append("; price=").append(this._price).append("]");
            return buffer.toString();
        }
    }
}

