/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.query.dunit;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.client.ClientCache;
import com.gemstone.gemfire.cache.client.ClientCacheFactory;
import com.gemstone.gemfire.cache.client.PoolFactory;
import com.gemstone.gemfire.cache.client.PoolManager;
import com.gemstone.gemfire.cache.client.ServerOperationException;
import com.gemstone.gemfire.cache.query.FunctionDomainException;
import com.gemstone.gemfire.cache.query.Index;
import com.gemstone.gemfire.cache.query.IndexInvalidException;
import com.gemstone.gemfire.cache.query.NameResolutionException;
import com.gemstone.gemfire.cache.query.Query;
import com.gemstone.gemfire.cache.query.QueryException;
import com.gemstone.gemfire.cache.query.QueryExecutionLowMemoryException;
import com.gemstone.gemfire.cache.query.QueryExecutionTimeoutException;
import com.gemstone.gemfire.cache.query.QueryInvocationTargetException;
import com.gemstone.gemfire.cache.query.QueryService;
import com.gemstone.gemfire.cache.query.SelectResults;
import com.gemstone.gemfire.cache.query.TypeMismatchException;
import com.gemstone.gemfire.cache.query.data.Portfolio;
import com.gemstone.gemfire.cache.query.internal.DefaultQuery;
import com.gemstone.gemfire.cache.query.internal.QueryMonitor;
import com.gemstone.gemfire.cache.server.CacheServer;
import com.gemstone.gemfire.cache30.BridgeTestCase;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.internal.AvailablePortHelper;
import com.gemstone.gemfire.internal.cache.DistributedRegion;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.control.HeapMemoryMonitor;
import com.gemstone.gemfire.internal.cache.control.InternalResourceManager;
import com.gemstone.gemfire.internal.cache.control.ResourceListener;
import com.gemstone.gemfire.internal.cache.control.TestMemoryThresholdListener;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import dunit.AsyncInvocation;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableCallable;
import dunit.VM;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import junit.framework.TestCase;
import util.TestException;

public class ResourceManagerWithQueryMonitorDUnitTest
extends BridgeTestCase {
    private static int MAX_TEST_QUERY_TIMEOUT = 4000;
    private static int TEST_QUERY_TIMEOUT = 1000;
    private static final int CRITICAL_HEAP_USED = 950;
    private static final int NORMAL_HEAP_USED = 500;
    private SerializableCallable setHeapMemoryMonitorTestMode = new SerializableCallable(){

        public Object call() throws Exception {
            HeapMemoryMonitor.setTestDisableMemoryUpdates((boolean)true);
            return null;
        }
    };
    private SerializableCallable resetResourceManager = new SerializableCallable(){

        public Object call() throws Exception {
            InternalResourceManager irm = ((GemFireCacheImpl)ResourceManagerWithQueryMonitorDUnitTest.this.getCache()).getResourceManager();
            Set listeners = irm.getResourceListeners(InternalResourceManager.ResourceType.HEAP_MEMORY);
            for (ResourceListener l : listeners) {
                if (!(l instanceof TestMemoryThresholdListener)) continue;
                ((TestMemoryThresholdListener)l).resetThresholdCalls();
            }
            irm.setCriticalHeapPercentage(0.0f);
            irm.setEvictionHeapPercentage(0.0f);
            irm.getHeapMonitor().setTestMaxMemoryBytes(0L);
            HeapMemoryMonitor.setTestDisableMemoryUpdates((boolean)false);
            return null;
        }
    };
    private SerializableCallable resetQueryMonitor = new SerializableCallable(){

        public Object call() throws Exception {
            QueryMonitor.clearLowMemory();
            DefaultQuery.testHook = null;
            return null;
        }
    };

    public ResourceManagerWithQueryMonitorDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        ResourceManagerWithQueryMonitorDUnitTest.invokeInEveryVM(this.setHeapMemoryMonitorTestMode);
    }

    @Override
    public void tearDown2() throws Exception {
        ResourceManagerWithQueryMonitorDUnitTest.invokeInEveryVM(this.resetResourceManager);
        super.tearDown2();
        ResourceManagerWithQueryMonitorDUnitTest.invokeInEveryVM(this.resetQueryMonitor);
    }

    public void testRMAndNoTimeoutSet() throws Exception {
        this.doCriticalMemoryHitTest("portfolios", false, 85, false, -1, true);
    }

    public void testRMAndNoTimeoutSetParReg() throws Exception {
        this.doCriticalMemoryHitTest("portfolios", true, 85, false, -1, true);
    }

    public void testRMButDisabledQueryMonitorForLowMemAndNoTimeoutSet() throws Exception {
        this.doCriticalMemoryHitTest("portfolios", false, 85, true, -1, true);
    }

    public void testRMAndTimeoutSet() throws Exception {
        this.doCriticalMemoryHitTest("portfolios", false, 85, true, TEST_QUERY_TIMEOUT, true);
    }

    public void testRMAndTimeoutSetAndQueryTimesoutInstead() throws Exception {
        this.doCriticalMemoryHitTest("portfolios", false, 85, true, TEST_QUERY_TIMEOUT, false);
    }

    public void testRMButDisabledQueryMonitorForLowMemAndTimeoutSet() throws Exception {
        this.doCriticalMemoryHitTest("portfolios", false, 85, true, TEST_QUERY_TIMEOUT, true);
    }

    public void testRMAndNoTimeoutSetOnServer() throws Exception {
        this.doCriticalMemoryHitTestOnServer("portfolios", false, 85, false, -1, true);
    }

    public void testRMAndNoTimeoutSetParRegOnServer() throws Exception {
        this.doCriticalMemoryHitTestOnServer("portfolios", true, 85, false, -1, true);
    }

    public void testRMButDisabledQueryMonitorForLowMemAndNoTimeoutSetOnServer() throws Exception {
        this.doCriticalMemoryHitTestOnServer("portfolios", false, 85, true, -1, true);
    }

    public void testRMAndTimeoutSetOnServer() throws Exception {
        this.doCriticalMemoryHitTestOnServer("portfolios", false, 85, true, TEST_QUERY_TIMEOUT, true);
    }

    public void testRMAndTimeoutSetAndQueryTimesoutInsteadOnServer() throws Exception {
        this.doCriticalMemoryHitTestOnServer("portfolios", false, 85, true, TEST_QUERY_TIMEOUT, false);
    }

    public void testRMButDisabledQueryMonitorForLowMemAndTimeoutSetOnServer() throws Exception {
        this.doCriticalMemoryHitTestOnServer("portfolios", false, 85, true, TEST_QUERY_TIMEOUT, true);
    }

    public void testPRGatherCancellation() throws Exception {
        this.doCriticalMemoryHitTestWithMultipleServers("portfolios", true, 85, false, -1, true);
    }

    public void testPRGatherCancellationWhileGatheringResults() throws Exception {
        this.doCriticalMemoryHitDuringGatherTestWithMultipleServers("portfolios", true, 85, false, -1, true);
    }

    public void testPRGatherCancellationWhileAddingResults() throws Exception {
        this.doCriticalMemoryHitAddResultsTestWithMultipleServers("portfolios", true, 85, false, -1, true);
    }

    public void testIndexCreationCancellationPR() throws Exception {
        this.doCriticalMemoryHitWithIndexTest("portfolios", true, 85, false, -1, true, "compact");
    }

    public void testIndexCreationCancellation() throws Exception {
        this.doCriticalMemoryHitWithIndexTest("portfolios", false, 85, false, -1, true, "compact");
    }

    public void testIndexCreationNoCancellationPR() throws Exception {
        this.doCriticalMemoryHitWithIndexTest("portfolios", true, 85, true, -1, true, "compact");
    }

    public void testHashIndexCreationCancellationPR() throws Exception {
        this.doCriticalMemoryHitWithIndexTest("portfolios", true, 85, false, -1, true, "hash");
    }

    public void testHashIndexCreationCancellation() throws Exception {
        this.doCriticalMemoryHitWithIndexTest("portfolios", false, 85, false, -1, true, "hash");
    }

    public void testHashIndexCreationNoCancellationPR() throws Exception {
        this.doCriticalMemoryHitWithIndexTest("portfolios", true, 85, true, -1, true, "hash");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCriticalMemoryHitTest(final String regionName, boolean createPR, int criticalThreshold, boolean disabledQueryMonitorForLowMem, int queryTimeout, boolean hitCriticalThreshold) throws Exception {
        Host host = Host.getHost(0);
        VM server = host.getVM(0);
        VM client = host.getVM(1);
        int numObjects = 200;
        try {
            int port = AvailablePortHelper.getRandomAvailableTCPPort();
            int mcastPort = AvailablePortHelper.getRandomAvailableUDPPort();
            this.startCacheServer(server, port, mcastPort, criticalThreshold, disabledQueryMonitorForLowMem, queryTimeout, regionName, createPR, 0);
            this.startClient(client, server, port, regionName);
            this.populateData(server, regionName, 200);
            this.doTestCriticalHeapAndQueryTimeout(server, client, regionName, disabledQueryMonitorForLowMem, queryTimeout, hitCriticalThreshold);
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            if (hitCriticalThreshold) {
                this.vmRecoversFromCriticalHeap(server);
            }
            client.invoke(new CacheSerializableRunnable("Executing query when system is 'Normal'"){

                @Override
                public void run2() {
                    try {
                        QueryService qs = ResourceManagerWithQueryMonitorDUnitTest.this.getCache().getQueryService();
                        Query query = qs.newQuery("Select * From /" + regionName);
                        SelectResults results = (SelectResults)query.execute();
                        TestCase.assertEquals((int)200, (int)results.size());
                    }
                    catch (QueryInvocationTargetException e) {
                        TestCase.assertFalse((boolean)true);
                    }
                    catch (NameResolutionException e) {
                        TestCase.assertFalse((boolean)true);
                    }
                    catch (TypeMismatchException e) {
                        TestCase.assertFalse((boolean)true);
                    }
                    catch (FunctionDomainException e) {
                        TestCase.assertFalse((boolean)true);
                    }
                }
            });
            this.doTestCriticalHeapAndQueryTimeout(server, client, regionName, disabledQueryMonitorForLowMem, queryTimeout, hitCriticalThreshold);
            if (hitCriticalThreshold) {
                this.vmRecoversFromCriticalHeap(server);
            }
        }
        finally {
            this.stopServer(server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCriticalMemoryHitWithIndexTest(final String regionName, boolean createPR, int criticalThreshold, final boolean disabledQueryMonitorForLowMem, int queryTimeout, final boolean hitCriticalThreshold, final String indexType) throws Exception {
        Host host = Host.getHost(0);
        VM server1 = host.getVM(0);
        VM server2 = host.getVM(2);
        VM client = host.getVM(1);
        int numObjects = 200;
        try {
            int[] port = AvailablePortHelper.getRandomAvailableTCPPorts(2);
            int mcastPort = AvailablePortHelper.getRandomAvailableUDPPort();
            this.startCacheServer(server1, port[0], mcastPort, criticalThreshold, disabledQueryMonitorForLowMem, queryTimeout, regionName, createPR, 0);
            this.startCacheServer(server2, port[1], mcastPort, criticalThreshold, true, -1, regionName, createPR, 0);
            this.startClient(client, server1, port[0], regionName);
            this.populateData(server1, regionName, 200);
            this.createCancelDuringGatherTestHook(server1);
            server1.invoke(new SerializableCallable("create index"){

                public Object call() {
                    QueryService qs = null;
                    try {
                        qs = ResourceManagerWithQueryMonitorDUnitTest.this.getCache().getQueryService();
                        Index index = null;
                        if (indexType.equals("compact")) {
                            index = qs.createIndex("newIndex", "ID", "/" + regionName);
                        } else if (indexType.equals("hash")) {
                            index = qs.createHashIndex("newIndex", "ID", "/" + regionName);
                        }
                        TestCase.assertNotNull(index);
                        TestCase.assertTrue((boolean)((CancelDuringGatherHook)DefaultQuery.testHook).triggeredOOME);
                        if (hitCriticalThreshold && !disabledQueryMonitorForLowMem) {
                            throw new CacheException("Should have hit low memory"){};
                        }
                        TestCase.assertEquals((int)1, (int)qs.getIndexes().size());
                    }
                    catch (Exception e) {
                        if (e instanceof IndexInvalidException) {
                            if (!hitCriticalThreshold || disabledQueryMonitorForLowMem) {
                                throw new CacheException("Should not have run into low memory exception"){};
                            }
                        }
                        throw new CacheException(e){};
                    }
                    return 0;
                }
            });
        }
        finally {
            this.stopServer(server1);
            this.stopServer(server2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCriticalMemoryHitAddResultsTestWithMultipleServers(final String regionName, boolean createPR, int criticalThreshold, final boolean disabledQueryMonitorForLowMem, final int queryTimeout, final boolean hitCriticalThreshold) throws Exception {
        Host host = Host.getHost(0);
        VM server1 = host.getVM(0);
        VM server2 = host.getVM(1);
        VM client = host.getVM(2);
        int numObjects = 200;
        try {
            int[] port = AvailablePortHelper.getRandomAvailableTCPPorts(2);
            int mcastPort = AvailablePortHelper.getRandomAvailableUDPPort();
            this.startCacheServer(server1, port[0], mcastPort, criticalThreshold, disabledQueryMonitorForLowMem, queryTimeout, regionName, createPR, 0);
            this.startCacheServer(server2, port[1], mcastPort, criticalThreshold, true, -1, regionName, createPR, 0);
            this.startClient(client, server1, port[0], regionName);
            this.populateData(server2, regionName, 200);
            this.createCancelDuringAddResultsTestHook(server1);
            client.invoke(new SerializableCallable("executing query to be canceled during add results"){

                public Object call() {
                    QueryService qs = null;
                    try {
                        qs = ResourceManagerWithQueryMonitorDUnitTest.this.getCache().getQueryService();
                        Query query = qs.newQuery("Select * From /" + regionName);
                        SelectResults results = (SelectResults)query.execute();
                        if (hitCriticalThreshold && !disabledQueryMonitorForLowMem) {
                            throw new CacheException("should have hit low memory"){};
                        }
                    }
                    catch (Exception e) {
                        ResourceManagerWithQueryMonitorDUnitTest.this.handleException(e, hitCriticalThreshold, disabledQueryMonitorForLowMem, queryTimeout);
                    }
                    return 0;
                }
            });
            this.verifyRejectedObjects(server1, disabledQueryMonitorForLowMem, queryTimeout, hitCriticalThreshold);
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            if (hitCriticalThreshold) {
                this.vmRecoversFromCriticalHeap(server1);
            }
            client.invoke(new CacheSerializableRunnable("Executing query when system is 'Normal'"){

                @Override
                public void run2() {
                    try {
                        QueryService qs = ResourceManagerWithQueryMonitorDUnitTest.this.getCache().getQueryService();
                        Query query = qs.newQuery("Select * From /" + regionName);
                        SelectResults results = (SelectResults)query.execute();
                        TestCase.assertEquals((int)200, (int)results.size());
                    }
                    catch (QueryInvocationTargetException e) {
                        TestCase.assertFalse((boolean)true);
                    }
                    catch (NameResolutionException e) {
                        TestCase.assertFalse((boolean)true);
                    }
                    catch (TypeMismatchException e) {
                        TestCase.assertFalse((boolean)true);
                    }
                    catch (FunctionDomainException e) {
                        TestCase.assertFalse((boolean)true);
                    }
                }
            });
            if (hitCriticalThreshold) {
                this.vmRecoversFromCriticalHeap(server1);
            }
        }
        finally {
            this.stopServer(server1);
            this.stopServer(server2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCriticalMemoryHitDuringGatherTestWithMultipleServers(final String regionName, boolean createPR, int criticalThreshold, boolean disabledQueryMonitorForLowMem, int queryTimeout, boolean hitCriticalThreshold) throws Exception {
        Host host = Host.getHost(0);
        VM server1 = host.getVM(0);
        VM server2 = host.getVM(1);
        VM client = host.getVM(2);
        int numObjects = 200;
        try {
            int[] port = AvailablePortHelper.getRandomAvailableTCPPorts(2);
            int mcastPort = AvailablePortHelper.getRandomAvailableUDPPort();
            this.startCacheServer(server1, port[0], mcastPort, criticalThreshold, disabledQueryMonitorForLowMem, queryTimeout, regionName, createPR, 0);
            this.startCacheServer(server2, port[1], mcastPort, criticalThreshold, true, -1, regionName, createPR, 0);
            this.startClient(client, server1, port[0], regionName);
            this.populateData(server2, regionName, 200);
            this.createCancelDuringGatherTestHook(server1);
            client.invoke(new SerializableCallable("executing query to be canceled by gather"){

                public Object call() {
                    QueryService qs = null;
                    try {
                        qs = ResourceManagerWithQueryMonitorDUnitTest.this.getCache().getQueryService();
                        Query query = qs.newQuery("Select * From /" + regionName);
                        query.execute();
                    }
                    catch (ServerOperationException soe) {
                        if (soe.getRootCause() instanceof QueryException) {
                            QueryException e = (QueryException)soe.getRootCause();
                            if (!ResourceManagerWithQueryMonitorDUnitTest.this.isExceptionDueToLowMemory(e, 950)) {
                                throw new CacheException(soe){};
                            }
                            return 0;
                        }
                    }
                    catch (Exception e) {
                        throw new CacheException(e){};
                    }
                    throw new CacheException("should have hit low memory"){};
                }
            });
            this.verifyRejectedObjects(server1, disabledQueryMonitorForLowMem, queryTimeout, hitCriticalThreshold);
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            if (hitCriticalThreshold) {
                this.vmRecoversFromCriticalHeap(server1);
            }
            client.invoke(new CacheSerializableRunnable("Executing query when system is 'Normal'"){

                @Override
                public void run2() {
                    try {
                        QueryService qs = ResourceManagerWithQueryMonitorDUnitTest.this.getCache().getQueryService();
                        Query query = qs.newQuery("Select * From /" + regionName);
                        SelectResults results = (SelectResults)query.execute();
                        TestCase.assertEquals((int)200, (int)results.size());
                    }
                    catch (QueryInvocationTargetException e) {
                        TestCase.assertFalse((boolean)true);
                    }
                    catch (NameResolutionException e) {
                        TestCase.assertFalse((boolean)true);
                    }
                    catch (TypeMismatchException e) {
                        TestCase.assertFalse((boolean)true);
                    }
                    catch (FunctionDomainException e) {
                        TestCase.assertFalse((boolean)true);
                    }
                }
            });
            if (hitCriticalThreshold) {
                this.vmRecoversFromCriticalHeap(server1);
            }
        }
        finally {
            this.stopServer(server1);
            this.stopServer(server2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCriticalMemoryHitTestWithMultipleServers(final String regionName, boolean createPR, int criticalThreshold, boolean disabledQueryMonitorForLowMem, int queryTimeout, boolean hitCriticalThreshold) throws Exception {
        Host host = Host.getHost(0);
        VM server1 = host.getVM(0);
        VM server2 = host.getVM(1);
        VM client = host.getVM(2);
        int numObjects = 200;
        try {
            int[] port = AvailablePortHelper.getRandomAvailableTCPPorts(2);
            int mcastPort = AvailablePortHelper.getRandomAvailableUDPPort();
            this.startCacheServer(server1, port[0], mcastPort, criticalThreshold, disabledQueryMonitorForLowMem, queryTimeout, regionName, createPR, 0);
            this.startCacheServer(server2, port[1], mcastPort, criticalThreshold, true, -1, regionName, createPR, 0);
            this.startClient(client, server1, port[0], regionName);
            this.populateData(server2, regionName, 200);
            this.doTestCriticalHeapAndQueryTimeout(server1, client, regionName, disabledQueryMonitorForLowMem, queryTimeout, hitCriticalThreshold);
            this.verifyRejectedObjects(server1, disabledQueryMonitorForLowMem, queryTimeout, hitCriticalThreshold);
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            if (hitCriticalThreshold) {
                this.vmRecoversFromCriticalHeap(server1);
            }
            client.invoke(new CacheSerializableRunnable("Executing query when system is 'Normal'"){

                @Override
                public void run2() {
                    try {
                        QueryService qs = ResourceManagerWithQueryMonitorDUnitTest.this.getCache().getQueryService();
                        Query query = qs.newQuery("Select * From /" + regionName);
                        SelectResults results = (SelectResults)query.execute();
                        TestCase.assertEquals((int)200, (int)results.size());
                    }
                    catch (QueryInvocationTargetException e) {
                        TestCase.assertFalse((boolean)true);
                    }
                    catch (NameResolutionException e) {
                        TestCase.assertFalse((boolean)true);
                    }
                    catch (TypeMismatchException e) {
                        TestCase.assertFalse((boolean)true);
                    }
                    catch (FunctionDomainException e) {
                        TestCase.assertFalse((boolean)true);
                    }
                }
            });
            this.doTestCriticalHeapAndQueryTimeout(server1, client, regionName, disabledQueryMonitorForLowMem, queryTimeout, hitCriticalThreshold);
            this.verifyRejectedObjects(server1, disabledQueryMonitorForLowMem, queryTimeout, hitCriticalThreshold);
            if (hitCriticalThreshold) {
                this.vmRecoversFromCriticalHeap(server1);
            }
        }
        finally {
            this.stopServer(server1);
            this.stopServer(server2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCriticalMemoryHitTestOnServer(final String regionName, boolean createPR, int criticalThreshold, boolean disabledQueryMonitorForLowMem, int queryTimeout, boolean hitCriticalThreshold) throws Exception {
        Host host = Host.getHost(0);
        VM server = host.getVM(0);
        VM client = host.getVM(1);
        int numObjects = 200;
        try {
            int port = AvailablePortHelper.getRandomAvailableTCPPort();
            int mcastPort = AvailablePortHelper.getRandomAvailableUDPPort();
            this.startCacheServer(server, port, mcastPort, criticalThreshold, disabledQueryMonitorForLowMem, queryTimeout, regionName, createPR, 0);
            this.populateData(server, regionName, 200);
            this.doTestCriticalHeapAndQueryTimeout(server, server, regionName, disabledQueryMonitorForLowMem, queryTimeout, hitCriticalThreshold);
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            if (hitCriticalThreshold) {
                this.vmRecoversFromCriticalHeap(server);
            }
            server.invoke(new CacheSerializableRunnable("Executing query when system is 'Normal'"){

                @Override
                public void run2() {
                    try {
                        QueryService qs = ResourceManagerWithQueryMonitorDUnitTest.this.getCache().getQueryService();
                        Query query = qs.newQuery("Select * From /" + regionName);
                        SelectResults results = (SelectResults)query.execute();
                        TestCase.assertEquals((int)200, (int)results.size());
                    }
                    catch (QueryInvocationTargetException e) {
                        TestCase.assertFalse((boolean)true);
                    }
                    catch (NameResolutionException e) {
                        TestCase.assertFalse((boolean)true);
                    }
                    catch (TypeMismatchException e) {
                        TestCase.assertFalse((boolean)true);
                    }
                    catch (FunctionDomainException e) {
                        TestCase.assertFalse((boolean)true);
                    }
                }
            });
            this.doTestCriticalHeapAndQueryTimeout(server, server, regionName, disabledQueryMonitorForLowMem, queryTimeout, hitCriticalThreshold);
            if (hitCriticalThreshold) {
                this.vmRecoversFromCriticalHeap(server);
            }
        }
        finally {
            this.stopServer(server);
        }
    }

    private void doTestCriticalHeapAndQueryTimeout(VM server, VM client, String regionName, boolean disabledQueryMonitorForLowMem, int queryTimeout, boolean hitCriticalThreshold) {
        this.createLatchTestHook(server);
        AsyncInvocation queryExecution = this.invokeClientQuery(client, regionName, disabledQueryMonitorForLowMem, queryTimeout, hitCriticalThreshold);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        if (hitCriticalThreshold) {
            this.vmHitsCriticalHeap(server);
        }
        try {
            Thread.sleep(MAX_TEST_QUERY_TIMEOUT);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        this.releaseHook(server);
        DistributedTestCase.join(queryExecution, 60000L, ResourceManagerWithQueryMonitorDUnitTest.getLogWriter());
        try {
            ResourceManagerWithQueryMonitorDUnitTest.assertEquals((Object)0, (Object)queryExecution.getResult());
        }
        catch (Throwable e) {
            e.printStackTrace();
            ResourceManagerWithQueryMonitorDUnitTest.fail();
        }
    }

    private AsyncInvocation invokeClientQuery(VM client, final String regionName, final boolean disabledQueryMonitorForLowMem, final int queryTimeout, final boolean hitCriticalThreshold) {
        return client.invokeAsync(new SerializableCallable("execute query from client"){

            public Object call() throws CacheException {
                Query query;
                QueryService qs = null;
                try {
                    qs = ResourceManagerWithQueryMonitorDUnitTest.this.getCache().getQueryService();
                    query = qs.newQuery("Select * From /" + regionName);
                    query.execute();
                    if (disabledQueryMonitorForLowMem) {
                        if (queryTimeout != -1) {
                            throw new CacheException("Should have reached the query timeout"){};
                        }
                    } else if (hitCriticalThreshold) {
                        throw new CacheException("Exception should have been thrown due to low memory"){};
                    }
                }
                catch (Exception e) {
                    ResourceManagerWithQueryMonitorDUnitTest.this.handleException(e, hitCriticalThreshold, disabledQueryMonitorForLowMem, queryTimeout);
                }
                try {
                    query = qs.newQuery("Select * From /" + regionName);
                    query.execute();
                    if (hitCriticalThreshold && !disabledQueryMonitorForLowMem) {
                        throw new CacheException("Low memory should still be cancelling queries"){};
                    }
                }
                catch (Exception e) {
                    ResourceManagerWithQueryMonitorDUnitTest.this.handleException(e, hitCriticalThreshold, disabledQueryMonitorForLowMem, queryTimeout);
                }
                return 0;
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handleException(Exception e, boolean hitCriticalThreshold, boolean disabledQueryMonitorForLowMem, long queryTimeout) throws CacheException {
        if (e instanceof QueryExecutionLowMemoryException) {
            if (hitCriticalThreshold && !disabledQueryMonitorForLowMem) return;
            throw new CacheException("Query should not have been canceled due to memory"){};
        }
        if (e instanceof QueryExecutionTimeoutException) {
            if (queryTimeout != -1L) return;
            throw new CacheException("Query failed due to unexplained reason, should not have been a time out or low memory " + DefaultQuery.testHook.getClass().getName() + " " + e){};
        }
        if (e instanceof QueryException) {
            if (this.isExceptionDueToLowMemory((QueryException)((Object)e), 950)) {
                if (hitCriticalThreshold && !disabledQueryMonitorForLowMem) return;
                throw new CacheException("Query should not have been canceled due to memory"){};
            }
            if (!this.isExceptionDueToTimeout((QueryException)((Object)e), queryTimeout)) throw new CacheException(e){};
            if (queryTimeout != -1L) return;
            throw new CacheException("Query failed due to unexplained reason, should not have been a time out or low memory"){};
        }
        if (!(e instanceof ServerOperationException)) throw new CacheException(e){};
        ServerOperationException soe = (ServerOperationException)((Object)e);
        if (soe.getRootCause() instanceof QueryExecutionLowMemoryException) {
            if (hitCriticalThreshold && !disabledQueryMonitorForLowMem) return;
            throw new CacheException("Query should not have been canceled due to memory"){};
        }
        if (soe.getRootCause() instanceof QueryException) {
            QueryException qe = (QueryException)soe.getRootCause();
            if (this.isExceptionDueToLowMemory(qe, 950)) {
                if (hitCriticalThreshold && !disabledQueryMonitorForLowMem) return;
                throw new CacheException("Query should not have been canceled due to memory"){};
            }
            if (!this.isExceptionDueToTimeout(qe, queryTimeout)) throw new CacheException(soe){};
            if (queryTimeout != -1L) return;
            e.printStackTrace();
            throw new CacheException("Query failed due to unexplained reason, should not have been a time out or low memory"){};
        }
        if (!(soe.getRootCause() instanceof QueryExecutionTimeoutException)) throw new CacheException(soe){};
        if (queryTimeout != -1L) return;
        throw new CacheException("Query failed due to unexplained reason, should not have been a time out or low memory " + DefaultQuery.testHook.getClass().getName() + " " + soe.getRootCause()){};
    }

    private void vmHitsCriticalHeap(VM vm) {
        vm.invoke(new CacheSerializableRunnable("vm hits critical heap"){

            @Override
            public void run2() {
                InternalResourceManager resourceManager = (InternalResourceManager)ResourceManagerWithQueryMonitorDUnitTest.this.getCache().getResourceManager();
                resourceManager.getHeapMonitor().updateStateAndSendEvent(950L);
            }
        });
    }

    private void vmRecoversFromCriticalHeap(VM vm) {
        vm.invoke(new CacheSerializableRunnable("vm hits critical heap"){

            @Override
            public void run2() {
                InternalResourceManager resourceManager = (InternalResourceManager)ResourceManagerWithQueryMonitorDUnitTest.this.getCache().getResourceManager();
                resourceManager.getHeapMonitor().updateStateAndSendEvent(500L);
            }
        });
    }

    private void createLatchTestHook(VM vm) {
        vm.invoke(new CacheSerializableRunnable("create latch test Hook"){

            @Override
            public void run2() {
                DefaultQuery.TestHook hook;
                DefaultQuery.testHook = hook = ResourceManagerWithQueryMonitorDUnitTest.this.getPauseHook();
            }
        });
    }

    private void createCancelDuringGatherTestHook(VM vm) {
        vm.invoke(new CacheSerializableRunnable("create cancel during gather test Hook"){

            @Override
            public void run2() {
                DefaultQuery.TestHook hook;
                DefaultQuery.testHook = hook = ResourceManagerWithQueryMonitorDUnitTest.this.getCancelDuringGatherHook();
            }
        });
    }

    private void createCancelDuringAddResultsTestHook(VM vm) {
        vm.invoke(new CacheSerializableRunnable("create cancel during gather test Hook"){

            @Override
            public void run2() {
                DefaultQuery.TestHook hook;
                DefaultQuery.testHook = hook = ResourceManagerWithQueryMonitorDUnitTest.this.getCancelDuringAddResultsHook();
            }
        });
    }

    private void releaseHook(VM vm) {
        vm.invoke(new CacheSerializableRunnable("release latch Hook"){

            @Override
            public void run2() {
                PauseTestHook hook = (PauseTestHook)DefaultQuery.testHook;
                hook.countDown();
            }
        });
    }

    private void verifyRejectedObjects(VM vm, final boolean disabledQueryMonitorForLowMem, int queryTimeout, final boolean hitCriticalThreshold) {
        vm.invoke(new CacheSerializableRunnable("verify dropped objects"){

            @Override
            public void run2() {
                if (!disabledQueryMonitorForLowMem && hitCriticalThreshold) {
                    if (DefaultQuery.testHook instanceof PauseTestHook) {
                        PauseTestHook hook = (PauseTestHook)DefaultQuery.testHook;
                        TestCase.assertTrue((boolean)hook.rejectedObjects);
                    } else if (DefaultQuery.testHook instanceof CancelDuringGatherHook) {
                        CancelDuringGatherHook hook = (CancelDuringGatherHook)DefaultQuery.testHook;
                        TestCase.assertTrue((boolean)hook.rejectedObjects);
                    } else if (DefaultQuery.testHook instanceof CancelDuringAddResultsHook) {
                        CancelDuringAddResultsHook hook = (CancelDuringAddResultsHook)DefaultQuery.testHook;
                        TestCase.assertTrue((boolean)hook.rejectedObjects);
                    }
                }
            }
        });
    }

    private void populateData(VM vm, final String regionName, final int numObjects) {
        vm.invoke(new CacheSerializableRunnable("populate data for " + regionName){

            @Override
            public void run2() {
                Region region = ResourceManagerWithQueryMonitorDUnitTest.this.getCache().getRegion(regionName);
                for (int i = 0; i < numObjects; ++i) {
                    region.put((Object)("key_" + i), (Object)new Portfolio(i));
                }
            }
        });
    }

    private void stopServer(VM server) {
        server.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                GemFireCacheImpl cache = (GemFireCacheImpl)ResourceManagerWithQueryMonitorDUnitTest.this.getCache();
                cache.TEST_MAX_QUERY_EXECUTION_TIME_OVERRIDE_EXCEPTION = false;
                cache.TEST_MAX_QUERY_EXECUTION_TIME = -1;
                return null;
            }
        });
    }

    private void startCacheServer(VM server, final int port, final int mcastPort, final int criticalThreshold, final boolean disableQueryMonitorForLowMemory, final int queryTimeout, final String regionName, final boolean createPR, final int prRedundancy) throws Exception {
        server.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                ResourceManagerWithQueryMonitorDUnitTest.this.getSystem(ResourceManagerWithQueryMonitorDUnitTest.this.getServerProperties(mcastPort, disableQueryMonitorForLowMemory, queryTimeout));
                if (disableQueryMonitorForLowMemory) {
                    System.setProperty("gemfire.Cache.DISABLE_QUERY_MONITOR_FOR_LOW_MEMORY", "true");
                } else {
                    System.clearProperty("gemfire.Cache.DISABLE_QUERY_MONITOR_FOR_LOW_MEMORY");
                }
                GemFireCacheImpl cache = (GemFireCacheImpl)ResourceManagerWithQueryMonitorDUnitTest.this.getCache();
                if (queryTimeout != -1) {
                    cache.TEST_MAX_QUERY_EXECUTION_TIME_OVERRIDE_EXCEPTION = true;
                    cache.TEST_MAX_QUERY_EXECUTION_TIME = queryTimeout;
                } else {
                    cache.TEST_MAX_QUERY_EXECUTION_TIME_OVERRIDE_EXCEPTION = false;
                    cache.TEST_MAX_QUERY_EXECUTION_TIME = -1;
                }
                if (criticalThreshold != 0) {
                    InternalResourceManager resourceManager = cache.getResourceManager();
                    HeapMemoryMonitor heapMonitor = resourceManager.getHeapMonitor();
                    heapMonitor.setTestMaxMemoryBytes(1000L);
                    HeapMemoryMonitor.setTestBytesUsedForThresholdSet((long)500L);
                    resourceManager.setCriticalHeapPercentage((float)criticalThreshold);
                }
                AttributesFactory factory = new AttributesFactory();
                if (createPR) {
                    PartitionAttributesFactory paf = new PartitionAttributesFactory();
                    paf.setRedundantCopies(prRedundancy);
                    paf.setTotalNumBuckets(11);
                    factory.setPartitionAttributes(paf.create());
                } else {
                    factory.setScope(Scope.DISTRIBUTED_ACK);
                    factory.setDataPolicy(DataPolicy.REPLICATE);
                }
                Region region = ResourceManagerWithQueryMonitorDUnitTest.this.createRootRegion(regionName, factory.create());
                if (createPR) {
                    TestCase.assertTrue((boolean)(region instanceof PartitionedRegion));
                } else {
                    TestCase.assertTrue((boolean)(region instanceof DistributedRegion));
                }
                CacheServer cacheServer = ResourceManagerWithQueryMonitorDUnitTest.this.getCache().addCacheServer();
                cacheServer.setPort(port);
                cacheServer.start();
                return null;
            }
        });
    }

    private void startClient(VM client, final VM server, final int port, String regionName) {
        client.invoke(new CacheSerializableRunnable("Start client"){

            @Override
            public void run2() throws CacheException {
                Properties props = ResourceManagerWithQueryMonitorDUnitTest.this.getClientProps();
                ResourceManagerWithQueryMonitorDUnitTest.this.getSystem(props);
                ClientCacheFactory ccf = new ClientCacheFactory(props);
                ccf.addPoolServer(DistributedTestCase.getServerHostName(server.getHost()), port);
                ClientCache cache = ResourceManagerWithQueryMonitorDUnitTest.this.getClientCache(ccf);
            }
        });
    }

    private void startPeerClient(VM client, final VM server, final int port, final String regionName) {
        client.invoke(new CacheSerializableRunnable("Start peer client"){

            @Override
            public void run2() throws CacheException {
                Properties props = ResourceManagerWithQueryMonitorDUnitTest.this.getClientProps();
                ResourceManagerWithQueryMonitorDUnitTest.this.getSystem(props);
                PoolFactory pf = PoolManager.createFactory();
                pf.addServer(DistributedTestCase.getServerHostName(server.getHost()), port);
                pf.create("pool1");
                AttributesFactory af = new AttributesFactory();
                af.setScope(Scope.LOCAL);
                af.setPoolName("pool1");
                Region region = ResourceManagerWithQueryMonitorDUnitTest.this.createRootRegion(regionName, af.create());
                ResourceManagerWithQueryMonitorDUnitTest.this.getCache();
            }
        });
    }

    protected Properties getClientProps() {
        Properties p = new Properties();
        p.setProperty("mcast-port", "0");
        p.setProperty("locators", "");
        return p;
    }

    protected Properties getServerProperties(int mcastPort, boolean disableQueryMonitorForMemory, int queryTimeout) {
        Properties p = new Properties();
        p.setProperty("mcast-port", mcastPort + "");
        p.setProperty("locators", "");
        return p;
    }

    private boolean isExceptionDueToLowMemory(QueryException e, int HEAP_USED) {
        String message = e.getMessage();
        return message.contains(LocalizedStrings.QueryMonitor_LOW_MEMORY_CANCELED_QUERY.toLocalizedString(new Object[]{HEAP_USED})) || message.contains(LocalizedStrings.QueryMonitor_LOW_MEMORY_WHILE_GATHERING_RESULTS_FROM_PARTITION_REGION.toLocalizedString());
    }

    private boolean isExceptionDueToTimeout(QueryException e, long queryTimeout) {
        String message = e.getMessage();
        return message.contains("The QueryMonitor thread may be sleeping longer than") || message.contains(LocalizedStrings.QueryMonitor_LONG_RUNNING_QUERY_CANCELED.toLocalizedString(new Object[]{queryTimeout})) || message.contains(LocalizedStrings.QueryMonitor_LONG_RUNNING_QUERY_CANCELED.toLocalizedString(new Object[]{-1}));
    }

    private DefaultQuery.TestHook getPauseHook() {
        return new PauseTestHook();
    }

    private DefaultQuery.TestHook getCancelDuringGatherHook() {
        return new CancelDuringGatherHook();
    }

    private DefaultQuery.TestHook getCancelDuringAddResultsHook() {
        return new CancelDuringAddResultsHook();
    }

    private class CancelDuringAddResultsHook
    implements DefaultQuery.TestHook {
        public boolean triggeredOOME = false;
        public boolean rejectedObjects = false;

        private CancelDuringAddResultsHook() {
        }

        public void doTestHook(int spot) {
            if (spot == 4) {
                if (!this.triggeredOOME) {
                    InternalResourceManager resourceManager = (InternalResourceManager)ResourceManagerWithQueryMonitorDUnitTest.this.getCache().getResourceManager();
                    resourceManager.getHeapMonitor().updateStateAndSendEvent(950L);
                    this.triggeredOOME = true;
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
            } else if (spot == 5) {
                this.rejectedObjects = true;
            }
        }
    }

    private class CancelDuringGatherHook
    implements DefaultQuery.TestHook {
        public boolean rejectedObjects = false;
        public boolean triggeredOOME = false;
        private int count = 0;
        private int numObjectsBeforeCancel = 5;

        private CancelDuringGatherHook() {
        }

        public void doTestHook(int spot) {
            if (spot == 2) {
                this.rejectedObjects = true;
            } else if (spot == 3 && this.count++ == this.numObjectsBeforeCancel) {
                InternalResourceManager resourceManager = (InternalResourceManager)ResourceManagerWithQueryMonitorDUnitTest.this.getCache().getResourceManager();
                resourceManager.getHeapMonitor().updateStateAndSendEvent(950L);
                this.triggeredOOME = true;
            }
        }
    }

    private class PauseTestHook
    implements DefaultQuery.TestHook {
        private CountDownLatch latch = new CountDownLatch(1);
        public boolean rejectedObjects = false;

        private PauseTestHook() {
        }

        public void doTestHook(int spot) {
            if (spot == 1) {
                try {
                    if (!this.latch.await(8L, TimeUnit.SECONDS)) {
                        throw new TestException("query was never unlatched");
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    Thread.currentThread().interrupt();
                }
            } else if (spot == 2) {
                this.rejectedObjects = true;
            }
        }

        public void countDown() {
            this.latch.countDown();
        }
    }
}

