/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.query.internal;

import com.gemstone.gemfire.cache.query.Struct;
import com.gemstone.gemfire.cache.query.internal.ResultsBag;
import com.gemstone.gemfire.cache.query.internal.ResultsBagLimitBehaviourTest;
import com.gemstone.gemfire.cache.query.internal.StructBag;
import com.gemstone.gemfire.cache.query.internal.StructImpl;
import com.gemstone.gemfire.cache.query.internal.types.ObjectTypeImpl;
import com.gemstone.gemfire.cache.query.internal.types.StructTypeImpl;
import com.gemstone.gemfire.cache.query.types.ObjectType;
import com.gemstone.gemfire.cache.query.types.StructType;
import java.util.Iterator;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class StructBagLimitBehaviourTest
extends ResultsBagLimitBehaviourTest {
    public StructBagLimitBehaviourTest(String testName) {
        super(testName);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(StructBagLimitBehaviourTest.class);
        return suite;
    }

    public static void main(String[] args) {
        TestRunner.run((Test)StructBagLimitBehaviourTest.suite());
    }

    public ResultsBag getBagObject(Class clazz) {
        ObjectType[] types = new ObjectType[]{new ObjectTypeImpl(clazz), new ObjectTypeImpl(clazz)};
        StructTypeImpl type = new StructTypeImpl(new String[]{"field1", "field2"}, types);
        return new StructBag((StructType)type, null);
    }

    public Object wrap(Object obj, ObjectType type) {
        StructTypeImpl stype = (StructTypeImpl)type;
        if (obj == null) {
            return new StructImpl(stype, null);
        }
        return new StructImpl(stype, new Object[]{obj, obj});
    }

    public void testRemoveAllStructBagSpecificMthod() {
        StructBag bag1 = (StructBag)this.getBagObject(Integer.class);
        bag1.add(this.wrap(null, bag1.getCollectionType().getElementType()));
        bag1.add(this.wrap(null, bag1.getCollectionType().getElementType()));
        bag1.add(this.wrap(new Integer(1), bag1.getCollectionType().getElementType()));
        bag1.add(this.wrap(new Integer(2), bag1.getCollectionType().getElementType()));
        bag1.add(this.wrap(new Integer(2), bag1.getCollectionType().getElementType()));
        bag1.add(this.wrap(new Integer(3), bag1.getCollectionType().getElementType()));
        bag1.add(this.wrap(new Integer(3), bag1.getCollectionType().getElementType()));
        bag1.add(this.wrap(new Integer(4), bag1.getCollectionType().getElementType()));
        bag1.applyLimit(4);
        StructBag bag2 = (StructBag)this.getBagObject(Integer.class);
        bag2.addAll(bag1);
        Iterator itr2 = bag2.iterator();
        Struct first = (Struct)itr2.next();
        int occrnce = 0;
        while (itr2.hasNext()) {
            if (!itr2.next().equals(first)) continue;
            itr2.remove();
            ++occrnce;
        }
        StructBagLimitBehaviourTest.assertTrue((boolean)bag1.removeAll(bag2));
        StructBagLimitBehaviourTest.assertEquals((int)occrnce, (int)bag1.size());
        Iterator itr = bag1.iterator();
        for (int i = 0; i < occrnce; ++i) {
            itr.next();
        }
        StructBagLimitBehaviourTest.assertFalse((boolean)itr.hasNext());
    }

    public void testRetainAllStructBagSpecific() {
        StructBag bag1 = (StructBag)this.getBagObject(Integer.class);
        bag1.add(this.wrap(new Integer(1), bag1.getCollectionType().getElementType()));
        bag1.add(this.wrap(new Integer(2), bag1.getCollectionType().getElementType()));
        bag1.add(this.wrap(new Integer(2), bag1.getCollectionType().getElementType()));
        bag1.add(this.wrap(new Integer(3), bag1.getCollectionType().getElementType()));
        bag1.add(this.wrap(new Integer(3), bag1.getCollectionType().getElementType()));
        bag1.add(this.wrap(new Integer(4), bag1.getCollectionType().getElementType()));
        bag1.add(this.wrap(null, bag1.getCollectionType().getElementType()));
        bag1.add(this.wrap(null, bag1.getCollectionType().getElementType()));
        bag1.applyLimit(4);
        StructBag bag2 = (StructBag)this.getBagObject(Integer.class);
        bag2.addAll(bag1);
        Iterator itr2 = bag2.iterator();
        Struct first = (Struct)itr2.next();
        int occrnce = 0;
        while (itr2.hasNext()) {
            if (!itr2.next().equals(first)) continue;
            itr2.remove();
            ++occrnce;
        }
        bag1.retainAll(bag2);
        StructBagLimitBehaviourTest.assertEquals((int)4, (int)bag1.size());
        Iterator itr = bag1.iterator();
        for (int i = 0; i < 4; ++i) {
            itr.next();
        }
        StructBagLimitBehaviourTest.assertFalse((boolean)itr.hasNext());
    }
}

