/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.query.internal.index;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.DiskStore;
import com.gemstone.gemfire.cache.EvictionAction;
import com.gemstone.gemfire.cache.EvictionAlgorithm;
import com.gemstone.gemfire.cache.EvictionAttributes;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionFactory;
import com.gemstone.gemfire.cache.RegionShortcut;
import com.gemstone.gemfire.cache.client.ClientCache;
import com.gemstone.gemfire.cache.client.ClientCacheFactory;
import com.gemstone.gemfire.cache.client.ClientRegionShortcut;
import com.gemstone.gemfire.cache.query.Index;
import com.gemstone.gemfire.cache.query.QueryService;
import com.gemstone.gemfire.cache.query.data.Portfolio;
import com.gemstone.gemfire.cache.query.data.PortfolioData;
import com.gemstone.gemfire.cache.query.internal.index.CompactRangeIndex;
import com.gemstone.gemfire.cache.query.internal.index.IndexManager;
import com.gemstone.gemfire.cache.query.partitioned.PRQueryDUnitHelper;
import com.gemstone.gemfire.cache.util.BridgeServer;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.internal.cache.EvictionAttributesImpl;
import dunit.AsyncInvocation;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.VM;
import java.io.IOException;
import junit.framework.TestCase;

public class ConcurrentIndexInitOnOverflowRegionDUnitTest
extends CacheTestCase {
    PRQueryDUnitHelper PRQHelp = new PRQueryDUnitHelper("");
    String name;
    final int redundancy = 0;
    private int cnt = 0;
    private int cntDest = 1;
    public static volatile boolean hooked = false;
    private static int bridgeServerPort;

    public ConcurrentIndexInitOnOverflowRegionDUnitTest(String name) {
        super(name);
    }

    public void testAsyncIndexInitDuringEntryDestroyAndQueryOnRR() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        this.name = "PartionedPortfoliosPR";
        vm0.invoke(new CacheSerializableRunnable("Create local region with synchronous index maintenance"){

            @Override
            public void run2() throws CacheException {
                Cache cache = ConcurrentIndexInitOnOverflowRegionDUnitTest.this.PRQHelp.getCache();
                Region partitionRegion = null;
                IndexManager.testHook = null;
                try {
                    DiskStore ds = cache.findDiskStore("disk");
                    if (ds == null) {
                        ds = cache.createDiskStoreFactory().setDiskDirs(CacheTestCase.getDiskDirs()).create("disk");
                    }
                    AttributesFactory attr = new AttributesFactory();
                    attr.setValueConstraint(PortfolioData.class);
                    attr.setIndexMaintenanceSynchronous(true);
                    EvictionAttributesImpl evicAttr = new EvictionAttributesImpl().setAction(EvictionAction.OVERFLOW_TO_DISK);
                    evicAttr.setAlgorithm(EvictionAlgorithm.LRU_ENTRY).setMaximum(1);
                    attr.setEvictionAttributes((EvictionAttributes)evicAttr);
                    attr.setDataPolicy(DataPolicy.REPLICATE);
                    attr.setDiskStoreName("disk");
                    RegionFactory regionFactory = cache.createRegionFactory(attr.create());
                    partitionRegion = regionFactory.create(ConcurrentIndexInitOnOverflowRegionDUnitTest.this.name);
                }
                catch (IllegalStateException ex) {
                    DistributedTestCase.getLogWriter().warning("Creation caught IllegalStateException", (Throwable)ex);
                }
                TestCase.assertNotNull((String)("Region " + ConcurrentIndexInitOnOverflowRegionDUnitTest.this.name + " not in cache"), (Object)cache.getRegion(ConcurrentIndexInitOnOverflowRegionDUnitTest.this.name));
                TestCase.assertNotNull((String)"Region ref null", partitionRegion);
                TestCase.assertTrue((String)"Region ref claims to be destroyed", (!partitionRegion.isDestroyed() ? 1 : 0) != 0);
                try {
                    Index index = cache.getQueryService().createIndex("statusIndex", "p.status", "/" + ConcurrentIndexInitOnOverflowRegionDUnitTest.this.name + " p");
                    TestCase.assertNotNull((Object)index);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                    TestCase.fail((String)"Index creation failed");
                }
            }
        });
        AsyncInvocation asyncInv1 = vm0.invokeAsync(new CacheSerializableRunnable("Change value in region"){

            @Override
            public void run2() throws CacheException {
                Cache cache = ConcurrentIndexInitOnOverflowRegionDUnitTest.this.PRQHelp.getCache();
                Region r = ConcurrentIndexInitOnOverflowRegionDUnitTest.this.PRQHelp.getCache().getRegion(ConcurrentIndexInitOnOverflowRegionDUnitTest.this.name);
                for (int i = 0; i < 100; ++i) {
                    r.put((Object)i, (Object)new PortfolioData(i));
                }
                TestCase.assertNull((Object)IndexManager.testHook);
                IndexManager.testHook = new IndexManagerTestHook();
                ConcurrentIndexInitOnOverflowRegionDUnitTest.this.PRQHelp.getCache().getLogger().fine("Destroying the value");
                r.destroy((Object)1);
                IndexManager.testHook = null;
            }
        });
        AsyncInvocation asyncInv2 = vm0.invokeAsync(new CacheSerializableRunnable("Run query on region"){

            @Override
            public void run2() throws CacheException {
                Cache cache = ConcurrentIndexInitOnOverflowRegionDUnitTest.this.PRQHelp.getCache();
                while (!hooked) {
                    DistributedTestCase.pause(100);
                }
                try {
                    Index index = cache.getQueryService().createIndex("idIndex", "p.ID", "/" + ConcurrentIndexInitOnOverflowRegionDUnitTest.this.name + " p");
                    TestCase.assertNotNull((Object)index);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                    TestCase.fail((String)"Index creation failed");
                }
            }
        });
        DistributedTestCase.join(asyncInv2, 30000L, this.PRQHelp.getCache().getLogger());
        DistributedTestCase.join(asyncInv1, 30000L, this.PRQHelp.getCache().getLogger());
    }

    public void testAsyncIndexInitDuringEntryPutUsingClientOnRR() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        this.name = "PartionedPortfoliosPR";
        vm0.invoke(new CacheSerializableRunnable("Create local region with synchronous index maintenance"){

            @Override
            public void run2() throws CacheException {
                Cache cache = ConcurrentIndexInitOnOverflowRegionDUnitTest.this.PRQHelp.getCache();
                Region partitionRegion = null;
                IndexManager.testHook = null;
                try {
                    BridgeServer bridge = cache.addBridgeServer();
                    bridge.setPort(0);
                    bridge.start();
                    bridgeServerPort = bridge.getPort();
                    DiskStore ds = cache.findDiskStore("disk");
                    if (ds == null) {
                        ds = cache.createDiskStoreFactory().setDiskDirs(CacheTestCase.getDiskDirs()).create("disk");
                    }
                    AttributesFactory attr = new AttributesFactory();
                    attr.setValueConstraint(PortfolioData.class);
                    attr.setIndexMaintenanceSynchronous(true);
                    EvictionAttributesImpl evicAttr = new EvictionAttributesImpl().setAction(EvictionAction.OVERFLOW_TO_DISK);
                    evicAttr.setAlgorithm(EvictionAlgorithm.LRU_ENTRY).setMaximum(1);
                    attr.setEvictionAttributes((EvictionAttributes)evicAttr);
                    attr.setDataPolicy(DataPolicy.REPLICATE);
                    attr.setDiskStoreName("disk");
                    RegionFactory regionFactory = cache.createRegionFactory(attr.create());
                    partitionRegion = regionFactory.create(ConcurrentIndexInitOnOverflowRegionDUnitTest.this.name);
                }
                catch (IllegalStateException ex) {
                    DistributedTestCase.getLogWriter().warning("Creation caught IllegalStateException", (Throwable)ex);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                TestCase.assertNotNull((String)("Region " + ConcurrentIndexInitOnOverflowRegionDUnitTest.this.name + " not in cache"), (Object)cache.getRegion(ConcurrentIndexInitOnOverflowRegionDUnitTest.this.name));
                TestCase.assertNotNull((String)"Region ref null", partitionRegion);
                TestCase.assertTrue((String)"Region ref claims to be destroyed", (!partitionRegion.isDestroyed() ? 1 : 0) != 0);
                try {
                    Index index = cache.getQueryService().createIndex("idIndex", "p.ID", "/" + ConcurrentIndexInitOnOverflowRegionDUnitTest.this.name + " p");
                    TestCase.assertNotNull((Object)index);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                    TestCase.fail((String)"Index creation failed");
                }
            }
        });
        final int port = vm0.invokeInt(ConcurrentIndexInitOnOverflowRegionDUnitTest.class, "getCacheServerPort");
        final String host0 = ConcurrentIndexInitOnOverflowRegionDUnitTest.getServerHostName(vm0.getHost());
        vm1.invoke(new CacheSerializableRunnable("Change value in region"){

            @Override
            public void run2() throws CacheException {
                CacheTestCase.disconnectFromDS();
                ClientCache clientCache = new ClientCacheFactory().addPoolServer(host0, port).create();
                Region r = clientCache.createClientRegionFactory(ClientRegionShortcut.PROXY).create(ConcurrentIndexInitOnOverflowRegionDUnitTest.this.name);
                for (int i = 0; i < 100; ++i) {
                    r.put((Object)i, (Object)new PortfolioData(i));
                }
            }
        });
        vm0.invoke(new CacheSerializableRunnable("Set Test Hook"){

            @Override
            public void run2() throws CacheException {
                TestCase.assertNull((Object)IndexManager.testHook);
                IndexManager.testHook = new IndexManagerTestHook();
            }
        });
        AsyncInvocation asyncInv1 = vm1.invokeAsync(new CacheSerializableRunnable("Change value in region"){

            @Override
            public void run2() throws CacheException {
                ClientCache clientCache = ClientCacheFactory.getAnyInstance();
                Region r = clientCache.getRegion(ConcurrentIndexInitOnOverflowRegionDUnitTest.this.name);
                clientCache.getLogger().fine("Destroying the value");
                r.destroy((Object)1);
            }
        });
        AsyncInvocation asyncInv2 = vm0.invokeAsync(new CacheSerializableRunnable("Run query on region"){

            @Override
            public void run2() throws CacheException {
                Cache cache = ConcurrentIndexInitOnOverflowRegionDUnitTest.this.PRQHelp.getCache();
                while (!hooked) {
                    DistributedTestCase.pause(100);
                }
                try {
                    Index index = cache.getQueryService().createIndex("statusIndex", "p.status", "/" + ConcurrentIndexInitOnOverflowRegionDUnitTest.this.name + " p");
                    TestCase.assertNotNull((Object)index);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                    TestCase.fail((String)"Index creation failed");
                }
            }
        });
        DistributedTestCase.join(asyncInv2, 30000L, this.PRQHelp.getCache().getLogger());
        DistributedTestCase.join(asyncInv1, 30000L, this.PRQHelp.getCache().getLogger());
        vm0.invoke(new CacheSerializableRunnable("Set Test Hook"){

            @Override
            public void run2() throws CacheException {
                TestCase.assertNotNull((Object)IndexManager.testHook);
                IndexManager.testHook = null;
            }
        });
    }

    public void testIndexUpdateWithRegionClear() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        String regionName = "portfolio";
        hooked = false;
        vm0.invoke(new CacheSerializableRunnable("Create region and index"){

            @Override
            public void run2() throws CacheException {
                Cache cache = ConcurrentIndexInitOnOverflowRegionDUnitTest.this.PRQHelp.getCache();
                Region region = cache.createRegionFactory(RegionShortcut.LOCAL).create("portfolio");
                QueryService qService = cache.getQueryService();
                try {
                    qService.createIndex("idIndex", "ID", "/portfolio");
                    qService.createIndex("secIdIndex", "pos.secId", "/portfoliop, p.positions.values pos");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    ConcurrentIndexInitOnOverflowRegionDUnitTest concurrentIndexInitOnOverflowRegionDUnitTest = ConcurrentIndexInitOnOverflowRegionDUnitTest.this;
                    concurrentIndexInitOnOverflowRegionDUnitTest.PRQHelp.getLogWriter().fine("Index creation failed.");
                }
            }
        });
        AsyncInvocation indexUpdateAsysnch = vm0.invokeAsync(new CacheSerializableRunnable("index updates"){

            @Override
            public void run2() throws CacheException {
                Region region = ConcurrentIndexInitOnOverflowRegionDUnitTest.this.PRQHelp.getCache().getRegion("portfolio");
                for (int i = 0; i < 100; ++i) {
                    if (i == 50) {
                        final class LocalTestHook
                        implements IndexManager.TestHook {
                            LocalTestHook() {
                            }

                            public void hook(int spot) throws RuntimeException {
                                switch (spot) {
                                    case 6: {
                                        hooked = true;
                                        while (hooked) {
                                            DistributedTestCase.pause(20);
                                        }
                                        break;
                                    }
                                }
                            }
                        }
                        IndexManager.testHook = new LocalTestHook();
                    }
                    region.put((Object)i, (Object)new Portfolio(i));
                    if (i != 50) continue;
                    DistributedTestCase.pause(20);
                }
            }
        });
        vm0.invoke(new CacheSerializableRunnable("Clear the region"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run2() throws CacheException {
                Region region = ConcurrentIndexInitOnOverflowRegionDUnitTest.this.PRQHelp.getCache().getRegion("portfolio");
                while (!hooked) {
                    DistributedTestCase.pause(100);
                }
                if (hooked) {
                    hooked = false;
                    IndexManager.testHook = null;
                    region.clear();
                }
                try {
                    QueryService qservice = ConcurrentIndexInitOnOverflowRegionDUnitTest.this.PRQHelp.getCache().getQueryService();
                    Index index = qservice.getIndex(region, "idIndex");
                    if (((CompactRangeIndex)index).getIndexStorage().size() > 1) {
                        TestCase.fail((String)("After clear region size is supposed to be zero as all index updates are blocked. Current region size is: " + region.size()));
                    }
                }
                finally {
                    IndexManager.testHook = null;
                }
            }
        });
        DistributedTestCase.join(indexUpdateAsysnch, 20000L, this.PRQHelp.getCache().getLogger());
        vm0.invoke(new CacheSerializableRunnable("Check region size"){

            @Override
            public void run2() throws CacheException {
                Region region = ConcurrentIndexInitOnOverflowRegionDUnitTest.this.PRQHelp.getCache().getRegion("portfolio");
                if (region.size() > 50) {
                    TestCase.fail((String)("After clear region size is supposed to be 50 as all index updates are blocked " + region.size()));
                }
            }
        });
    }

    private static int getCacheServerPort() {
        return bridgeServerPort;
    }

    public class IndexManagerTestHook
    implements IndexManager.TestHook {
        public void hook(int spot) throws RuntimeException {
            switch (spot) {
                case 6: {
                    hooked = true;
                    DistributedTestCase.getLogWriter().fine("IndexManagerTestHook is hooked.");
                    DistributedTestCase.pause(10000);
                    hooked = false;
                    break;
                }
            }
        }
    }
}

