/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.query.internal.index;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.DiskStore;
import com.gemstone.gemfire.cache.EvictionAction;
import com.gemstone.gemfire.cache.EvictionAlgorithm;
import com.gemstone.gemfire.cache.EvictionAttributes;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionFactory;
import com.gemstone.gemfire.cache.query.Index;
import com.gemstone.gemfire.cache.query.Query;
import com.gemstone.gemfire.cache.query.SelectResults;
import com.gemstone.gemfire.cache.query.data.PortfolioData;
import com.gemstone.gemfire.cache.query.internal.index.IndexManager;
import com.gemstone.gemfire.cache.query.partitioned.PRQueryDUnitHelper;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.internal.cache.EvictionAttributesImpl;
import dunit.AsyncInvocation;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.VM;
import junit.framework.TestCase;

public class ConcurrentIndexOperationsOnOverflowRegionDUnitTest
extends CacheTestCase {
    PRQueryDUnitHelper PRQHelp = new PRQueryDUnitHelper("");
    String name;
    final int redundancy = 0;
    private int cnt = 0;
    private int cntDest = 1;
    public static volatile boolean hooked = false;

    public ConcurrentIndexOperationsOnOverflowRegionDUnitTest(String name) {
        super(name);
    }

    public void testAsyncIndexInitDuringEntryDestroyAndQueryOnRR() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        this.name = "PartionedPortfoliosPR";
        vm0.invoke(new CacheSerializableRunnable("Create local region with synchronous index maintenance"){

            @Override
            public void run2() throws CacheException {
                Cache cache = ConcurrentIndexOperationsOnOverflowRegionDUnitTest.this.PRQHelp.getCache();
                Region partitionRegion = null;
                IndexManager.testHook = null;
                try {
                    DiskStore ds = cache.findDiskStore("disk");
                    if (ds == null) {
                        ds = cache.createDiskStoreFactory().setDiskDirs(CacheTestCase.getDiskDirs()).create("disk");
                    }
                    AttributesFactory attr = new AttributesFactory();
                    attr.setValueConstraint(PortfolioData.class);
                    attr.setIndexMaintenanceSynchronous(true);
                    EvictionAttributesImpl evicAttr = new EvictionAttributesImpl().setAction(EvictionAction.OVERFLOW_TO_DISK);
                    evicAttr.setAlgorithm(EvictionAlgorithm.LRU_ENTRY).setMaximum(1);
                    attr.setEvictionAttributes((EvictionAttributes)evicAttr);
                    attr.setDataPolicy(DataPolicy.REPLICATE);
                    attr.setDiskStoreName("disk");
                    RegionFactory regionFactory = cache.createRegionFactory(attr.create());
                    partitionRegion = regionFactory.create(ConcurrentIndexOperationsOnOverflowRegionDUnitTest.this.name);
                }
                catch (IllegalStateException ex) {
                    DistributedTestCase.getLogWriter().warning("Creation caught IllegalStateException", (Throwable)ex);
                }
                TestCase.assertNotNull((String)("Region " + ConcurrentIndexOperationsOnOverflowRegionDUnitTest.this.name + " not in cache"), (Object)cache.getRegion(ConcurrentIndexOperationsOnOverflowRegionDUnitTest.this.name));
                TestCase.assertNotNull((String)"Region ref null", partitionRegion);
                TestCase.assertTrue((String)"Region ref claims to be destroyed", (!partitionRegion.isDestroyed() ? 1 : 0) != 0);
                try {
                    Index index = cache.getQueryService().createIndex("statusIndex", "p.ID", "/" + ConcurrentIndexOperationsOnOverflowRegionDUnitTest.this.name + " p");
                    TestCase.assertNotNull((Object)index);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                    TestCase.fail((String)"Index creation failed");
                }
            }
        });
        AsyncInvocation asyncInv1 = vm0.invokeAsync(new CacheSerializableRunnable("Change value in region"){

            @Override
            public void run2() throws CacheException {
                Cache cache = ConcurrentIndexOperationsOnOverflowRegionDUnitTest.this.PRQHelp.getCache();
                Region r = ConcurrentIndexOperationsOnOverflowRegionDUnitTest.this.PRQHelp.getCache().getRegion(ConcurrentIndexOperationsOnOverflowRegionDUnitTest.this.name);
                for (int i = 0; i < 100; ++i) {
                    r.put((Object)i, (Object)new PortfolioData(i));
                }
                TestCase.assertNull((Object)IndexManager.testHook);
                IndexManager.testHook = new IndexManagerTestHook();
                ConcurrentIndexOperationsOnOverflowRegionDUnitTest.this.PRQHelp.getCache().getLogger().fine("Destroying the value");
                r.destroy((Object)1);
                IndexManager.testHook = null;
            }
        });
        AsyncInvocation asyncInv2 = vm0.invokeAsync(new CacheSerializableRunnable("Run query on region"){

            @Override
            public void run2() throws CacheException {
                Cache cache = ConcurrentIndexOperationsOnOverflowRegionDUnitTest.this.PRQHelp.getCache();
                Query statusQuery = ConcurrentIndexOperationsOnOverflowRegionDUnitTest.this.PRQHelp.getCache().getQueryService().newQuery("select * from /" + ConcurrentIndexOperationsOnOverflowRegionDUnitTest.this.name + " p where p.ID > -1");
                while (!hooked) {
                    DistributedTestCase.pause(100);
                }
                try {
                    ConcurrentIndexOperationsOnOverflowRegionDUnitTest.this.PRQHelp.getCache().getLogger().fine("Querying the region");
                    SelectResults results = (SelectResults)statusQuery.execute();
                    TestCase.assertEquals((int)100, (int)results.size());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        DistributedTestCase.join(asyncInv2, 30000L, this.PRQHelp.getCache().getLogger());
        DistributedTestCase.join(asyncInv1, 30000L, this.PRQHelp.getCache().getLogger());
    }

    public void testAsyncIndexInitDuringEntryDestroyAndQueryOnPR() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        this.name = "PartionedPortfoliosPR";
        vm0.invoke(new CacheSerializableRunnable("Create local region with synchronous index maintenance"){

            @Override
            public void run2() throws CacheException {
                Cache cache = ConcurrentIndexOperationsOnOverflowRegionDUnitTest.this.PRQHelp.getCache();
                Region partitionRegion = null;
                IndexManager.testHook = null;
                try {
                    DiskStore ds = cache.findDiskStore("disk");
                    if (ds == null) {
                        ds = cache.createDiskStoreFactory().setDiskDirs(CacheTestCase.getDiskDirs()).create("disk");
                    }
                    AttributesFactory attr = new AttributesFactory();
                    attr.setValueConstraint(PortfolioData.class);
                    attr.setIndexMaintenanceSynchronous(true);
                    EvictionAttributesImpl evicAttr = new EvictionAttributesImpl().setAction(EvictionAction.OVERFLOW_TO_DISK);
                    evicAttr.setAlgorithm(EvictionAlgorithm.LRU_ENTRY).setMaximum(1);
                    attr.setEvictionAttributes((EvictionAttributes)evicAttr);
                    attr.setDataPolicy(DataPolicy.PARTITION);
                    attr.setPartitionAttributes(new PartitionAttributesFactory().setTotalNumBuckets(1).create());
                    attr.setDiskStoreName("disk");
                    RegionFactory regionFactory = cache.createRegionFactory(attr.create());
                    partitionRegion = regionFactory.create(ConcurrentIndexOperationsOnOverflowRegionDUnitTest.this.name);
                }
                catch (IllegalStateException ex) {
                    DistributedTestCase.getLogWriter().warning("Creation caught IllegalStateException", (Throwable)ex);
                }
                TestCase.assertNotNull((String)("Region " + ConcurrentIndexOperationsOnOverflowRegionDUnitTest.this.name + " not in cache"), (Object)cache.getRegion(ConcurrentIndexOperationsOnOverflowRegionDUnitTest.this.name));
                TestCase.assertNotNull((String)"Region ref null", partitionRegion);
                TestCase.assertTrue((String)"Region ref claims to be destroyed", (!partitionRegion.isDestroyed() ? 1 : 0) != 0);
                try {
                    Index index = cache.getQueryService().createIndex("statusIndex", "p.ID", "/" + ConcurrentIndexOperationsOnOverflowRegionDUnitTest.this.name + " p");
                    TestCase.assertNotNull((Object)index);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                    TestCase.fail((String)"Index creation failed");
                }
            }
        });
        AsyncInvocation asyncInv1 = vm0.invokeAsync(new CacheSerializableRunnable("Change value in region"){

            @Override
            public void run2() throws CacheException {
                Cache cache = ConcurrentIndexOperationsOnOverflowRegionDUnitTest.this.PRQHelp.getCache();
                Region r = ConcurrentIndexOperationsOnOverflowRegionDUnitTest.this.PRQHelp.getCache().getRegion(ConcurrentIndexOperationsOnOverflowRegionDUnitTest.this.name);
                for (int i = 0; i < 100; ++i) {
                    r.put((Object)i, (Object)new PortfolioData(i));
                }
                TestCase.assertNull((Object)IndexManager.testHook);
                IndexManager.testHook = new IndexManagerTestHook();
                ConcurrentIndexOperationsOnOverflowRegionDUnitTest.this.PRQHelp.getCache().getLogger().fine("Destroying the value");
                r.destroy((Object)1);
                IndexManager.testHook = null;
            }
        });
        AsyncInvocation asyncInv2 = vm0.invokeAsync(new CacheSerializableRunnable("Run query on region"){

            @Override
            public void run2() throws CacheException {
                Cache cache = ConcurrentIndexOperationsOnOverflowRegionDUnitTest.this.PRQHelp.getCache();
                Query statusQuery = ConcurrentIndexOperationsOnOverflowRegionDUnitTest.this.PRQHelp.getCache().getQueryService().newQuery("select * from /" + ConcurrentIndexOperationsOnOverflowRegionDUnitTest.this.name + " p where p.ID > -1");
                while (!hooked) {
                    DistributedTestCase.pause(100);
                }
                try {
                    ConcurrentIndexOperationsOnOverflowRegionDUnitTest.this.PRQHelp.getCache().getLogger().fine("Querying the region");
                    SelectResults results = (SelectResults)statusQuery.execute();
                    TestCase.assertEquals((int)100, (int)results.size());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        DistributedTestCase.join(asyncInv2, 30000L, this.PRQHelp.getCache().getLogger());
        DistributedTestCase.join(asyncInv1, 30000L, this.PRQHelp.getCache().getLogger());
    }

    public void testAsyncIndexInitDuringEntryDestroyAndQueryOnPersistentRR() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        this.name = "PartionedPortfoliosPR";
        vm0.invoke(new CacheSerializableRunnable("Create local region with synchronous index maintenance"){

            @Override
            public void run2() throws CacheException {
                Cache cache = ConcurrentIndexOperationsOnOverflowRegionDUnitTest.this.PRQHelp.getCache();
                Region partitionRegion = null;
                IndexManager.testHook = null;
                try {
                    DiskStore ds = cache.findDiskStore("disk");
                    if (ds == null) {
                        ds = cache.createDiskStoreFactory().setDiskDirs(CacheTestCase.getDiskDirs()).create("disk");
                    }
                    AttributesFactory attr = new AttributesFactory();
                    attr.setValueConstraint(PortfolioData.class);
                    attr.setIndexMaintenanceSynchronous(true);
                    EvictionAttributesImpl evicAttr = new EvictionAttributesImpl().setAction(EvictionAction.OVERFLOW_TO_DISK);
                    evicAttr.setAlgorithm(EvictionAlgorithm.LRU_ENTRY).setMaximum(1);
                    attr.setEvictionAttributes((EvictionAttributes)evicAttr);
                    attr.setDataPolicy(DataPolicy.PERSISTENT_REPLICATE);
                    attr.setDiskStoreName("disk");
                    RegionFactory regionFactory = cache.createRegionFactory(attr.create());
                    partitionRegion = regionFactory.create(ConcurrentIndexOperationsOnOverflowRegionDUnitTest.this.name);
                }
                catch (IllegalStateException ex) {
                    DistributedTestCase.getLogWriter().warning("Creation caught IllegalStateException", (Throwable)ex);
                }
                TestCase.assertNotNull((String)("Region " + ConcurrentIndexOperationsOnOverflowRegionDUnitTest.this.name + " not in cache"), (Object)cache.getRegion(ConcurrentIndexOperationsOnOverflowRegionDUnitTest.this.name));
                TestCase.assertNotNull((String)"Region ref null", partitionRegion);
                TestCase.assertTrue((String)"Region ref claims to be destroyed", (!partitionRegion.isDestroyed() ? 1 : 0) != 0);
                try {
                    Index index = cache.getQueryService().createIndex("statusIndex", "p.ID", "/" + ConcurrentIndexOperationsOnOverflowRegionDUnitTest.this.name + " p");
                    TestCase.assertNotNull((Object)index);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                    TestCase.fail((String)"Index creation failed");
                }
            }
        });
        AsyncInvocation asyncInv1 = vm0.invokeAsync(new CacheSerializableRunnable("Change value in region"){

            @Override
            public void run2() throws CacheException {
                Cache cache = ConcurrentIndexOperationsOnOverflowRegionDUnitTest.this.PRQHelp.getCache();
                Region r = ConcurrentIndexOperationsOnOverflowRegionDUnitTest.this.PRQHelp.getCache().getRegion(ConcurrentIndexOperationsOnOverflowRegionDUnitTest.this.name);
                for (int i = 0; i < 100; ++i) {
                    r.put((Object)i, (Object)new PortfolioData(i));
                }
                TestCase.assertNull((Object)IndexManager.testHook);
                IndexManager.testHook = new IndexManagerTestHook();
                ConcurrentIndexOperationsOnOverflowRegionDUnitTest.this.PRQHelp.getCache().getLogger().fine("Destroying the value");
                r.destroy((Object)1);
                IndexManager.testHook = null;
            }
        });
        AsyncInvocation asyncInv2 = vm0.invokeAsync(new CacheSerializableRunnable("Run query on region"){

            @Override
            public void run2() throws CacheException {
                Cache cache = ConcurrentIndexOperationsOnOverflowRegionDUnitTest.this.PRQHelp.getCache();
                Query statusQuery = ConcurrentIndexOperationsOnOverflowRegionDUnitTest.this.PRQHelp.getCache().getQueryService().newQuery("select * from /" + ConcurrentIndexOperationsOnOverflowRegionDUnitTest.this.name + " p where p.ID > -1");
                while (!hooked) {
                    DistributedTestCase.pause(100);
                }
                try {
                    ConcurrentIndexOperationsOnOverflowRegionDUnitTest.this.PRQHelp.getCache().getLogger().fine("Querying the region");
                    SelectResults results = (SelectResults)statusQuery.execute();
                    TestCase.assertEquals((int)100, (int)results.size());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        DistributedTestCase.join(asyncInv2, 30000L, this.PRQHelp.getCache().getLogger());
        DistributedTestCase.join(asyncInv1, 30000L, this.PRQHelp.getCache().getLogger());
    }

    public void testAsyncIndexInitDuringEntryDestroyAndQueryOnPersistentPR() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        this.name = "PartionedPortfoliosPR";
        vm0.invoke(new CacheSerializableRunnable("Create local region with synchronous index maintenance"){

            @Override
            public void run2() throws CacheException {
                Cache cache = ConcurrentIndexOperationsOnOverflowRegionDUnitTest.this.PRQHelp.getCache();
                Region partitionRegion = null;
                IndexManager.testHook = null;
                try {
                    DiskStore ds = cache.findDiskStore("disk");
                    if (ds == null) {
                        ds = cache.createDiskStoreFactory().setDiskDirs(CacheTestCase.getDiskDirs()).create("disk");
                    }
                    AttributesFactory attr = new AttributesFactory();
                    attr.setValueConstraint(PortfolioData.class);
                    attr.setIndexMaintenanceSynchronous(true);
                    EvictionAttributesImpl evicAttr = new EvictionAttributesImpl().setAction(EvictionAction.OVERFLOW_TO_DISK);
                    evicAttr.setAlgorithm(EvictionAlgorithm.LRU_ENTRY).setMaximum(1);
                    attr.setEvictionAttributes((EvictionAttributes)evicAttr);
                    attr.setDataPolicy(DataPolicy.PERSISTENT_PARTITION);
                    attr.setPartitionAttributes(new PartitionAttributesFactory().setTotalNumBuckets(1).create());
                    attr.setDiskStoreName("disk");
                    RegionFactory regionFactory = cache.createRegionFactory(attr.create());
                    partitionRegion = regionFactory.create(ConcurrentIndexOperationsOnOverflowRegionDUnitTest.this.name);
                }
                catch (IllegalStateException ex) {
                    DistributedTestCase.getLogWriter().warning("Creation caught IllegalStateException", (Throwable)ex);
                }
                TestCase.assertNotNull((String)("Region " + ConcurrentIndexOperationsOnOverflowRegionDUnitTest.this.name + " not in cache"), (Object)cache.getRegion(ConcurrentIndexOperationsOnOverflowRegionDUnitTest.this.name));
                TestCase.assertNotNull((String)"Region ref null", partitionRegion);
                TestCase.assertTrue((String)"Region ref claims to be destroyed", (!partitionRegion.isDestroyed() ? 1 : 0) != 0);
                try {
                    Index index = cache.getQueryService().createIndex("statusIndex", "p.ID", "/" + ConcurrentIndexOperationsOnOverflowRegionDUnitTest.this.name + " p");
                    TestCase.assertNotNull((Object)index);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                    TestCase.fail((String)"Index creation failed");
                }
            }
        });
        AsyncInvocation asyncInv1 = vm0.invokeAsync(new CacheSerializableRunnable("Change value in region"){

            @Override
            public void run2() throws CacheException {
                Cache cache = ConcurrentIndexOperationsOnOverflowRegionDUnitTest.this.PRQHelp.getCache();
                Region r = ConcurrentIndexOperationsOnOverflowRegionDUnitTest.this.PRQHelp.getCache().getRegion(ConcurrentIndexOperationsOnOverflowRegionDUnitTest.this.name);
                for (int i = 0; i < 100; ++i) {
                    r.put((Object)i, (Object)new PortfolioData(i));
                }
                TestCase.assertNull((Object)IndexManager.testHook);
                IndexManager.testHook = new IndexManagerTestHook();
                ConcurrentIndexOperationsOnOverflowRegionDUnitTest.this.PRQHelp.getCache().getLogger().fine("Destroying the value");
                r.destroy((Object)1);
                IndexManager.testHook = null;
            }
        });
        AsyncInvocation asyncInv2 = vm0.invokeAsync(new CacheSerializableRunnable("Run query on region"){

            @Override
            public void run2() throws CacheException {
                Cache cache = ConcurrentIndexOperationsOnOverflowRegionDUnitTest.this.PRQHelp.getCache();
                Query statusQuery = ConcurrentIndexOperationsOnOverflowRegionDUnitTest.this.PRQHelp.getCache().getQueryService().newQuery("select * from /" + ConcurrentIndexOperationsOnOverflowRegionDUnitTest.this.name + " p where p.ID > -1");
                while (!hooked) {
                    DistributedTestCase.pause(100);
                }
                try {
                    ConcurrentIndexOperationsOnOverflowRegionDUnitTest.this.PRQHelp.getCache().getLogger().fine("Querying the region");
                    SelectResults results = (SelectResults)statusQuery.execute();
                    TestCase.assertEquals((int)100, (int)results.size());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        DistributedTestCase.join(asyncInv2, 30000L, this.PRQHelp.getCache().getLogger());
        DistributedTestCase.join(asyncInv1, 30000L, this.PRQHelp.getCache().getLogger());
    }

    public void _testAsyncIndexInitDuringEntryDestroyAndQueryOnNonOverflowRR() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        this.name = "PartionedPortfoliosPR";
        vm0.invoke(new CacheSerializableRunnable("Create local region with synchronous index maintenance"){

            @Override
            public void run2() throws CacheException {
                Cache cache = ConcurrentIndexOperationsOnOverflowRegionDUnitTest.this.PRQHelp.getCache();
                Region partitionRegion = null;
                IndexManager.testHook = null;
                try {
                    AttributesFactory attr = new AttributesFactory();
                    attr.setValueConstraint(PortfolioData.class);
                    attr.setIndexMaintenanceSynchronous(true);
                    attr.setDataPolicy(DataPolicy.REPLICATE);
                    RegionFactory regionFactory = cache.createRegionFactory(attr.create());
                    partitionRegion = regionFactory.create(ConcurrentIndexOperationsOnOverflowRegionDUnitTest.this.name);
                }
                catch (IllegalStateException ex) {
                    DistributedTestCase.getLogWriter().warning("Creation caught IllegalStateException", (Throwable)ex);
                }
                TestCase.assertNotNull((String)("Region " + ConcurrentIndexOperationsOnOverflowRegionDUnitTest.this.name + " not in cache"), (Object)cache.getRegion(ConcurrentIndexOperationsOnOverflowRegionDUnitTest.this.name));
                TestCase.assertNotNull((String)"Region ref null", (Object)partitionRegion);
                TestCase.assertTrue((String)"Region ref claims to be destroyed", (!partitionRegion.isDestroyed() ? 1 : 0) != 0);
                try {
                    Index index = cache.getQueryService().createIndex("statusIndex", "p.ID", "/" + ConcurrentIndexOperationsOnOverflowRegionDUnitTest.this.name + " p");
                    TestCase.assertNotNull((Object)index);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                    TestCase.fail((String)"Index creation failed");
                }
            }
        });
        AsyncInvocation asyncInv1 = vm0.invokeAsync(new CacheSerializableRunnable("Change value in region"){

            @Override
            public void run2() throws CacheException {
                Cache cache = ConcurrentIndexOperationsOnOverflowRegionDUnitTest.this.PRQHelp.getCache();
                Region r = ConcurrentIndexOperationsOnOverflowRegionDUnitTest.this.PRQHelp.getCache().getRegion(ConcurrentIndexOperationsOnOverflowRegionDUnitTest.this.name);
                for (int i = 0; i < 100; ++i) {
                    r.put((Object)i, (Object)new PortfolioData(i));
                }
                TestCase.assertNull((Object)IndexManager.testHook);
                IndexManager.testHook = new IndexManagerNoWaitTestHook();
                ConcurrentIndexOperationsOnOverflowRegionDUnitTest.this.PRQHelp.getCache().getLogger().fine("Destroying the value");
                r.destroy((Object)1);
                IndexManager.testHook = null;
            }
        });
        AsyncInvocation asyncInv2 = vm0.invokeAsync(new CacheSerializableRunnable("Run query on region"){

            @Override
            public void run2() throws CacheException {
                Cache cache = ConcurrentIndexOperationsOnOverflowRegionDUnitTest.this.PRQHelp.getCache();
                Query statusQuery = ConcurrentIndexOperationsOnOverflowRegionDUnitTest.this.PRQHelp.getCache().getQueryService().newQuery("select * from /" + ConcurrentIndexOperationsOnOverflowRegionDUnitTest.this.name + " p where p.ID > -1");
                while (!hooked) {
                    DistributedTestCase.pause(10);
                }
                try {
                    ConcurrentIndexOperationsOnOverflowRegionDUnitTest.this.PRQHelp.getCache().getLogger().fine("Querying the region");
                    SelectResults results = (SelectResults)statusQuery.execute();
                    TestCase.assertEquals((int)100, (int)results.size());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        DistributedTestCase.join(asyncInv2, 30000L, this.PRQHelp.getCache().getLogger());
        DistributedTestCase.join(asyncInv1, 30000L, this.PRQHelp.getCache().getLogger());
    }

    public void _testAsyncIndexInitDuringEntryDestroyAndQueryOnOnNonOverflowPR() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        this.name = "PartionedPortfoliosPR";
        vm0.invoke(new CacheSerializableRunnable("Create local region with synchronous index maintenance"){

            @Override
            public void run2() throws CacheException {
                Cache cache = ConcurrentIndexOperationsOnOverflowRegionDUnitTest.this.PRQHelp.getCache();
                Region partitionRegion = null;
                IndexManager.testHook = null;
                try {
                    AttributesFactory attr = new AttributesFactory();
                    attr.setValueConstraint(PortfolioData.class);
                    attr.setIndexMaintenanceSynchronous(true);
                    attr.setDataPolicy(DataPolicy.PARTITION);
                    attr.setPartitionAttributes(new PartitionAttributesFactory().setTotalNumBuckets(1).create());
                    RegionFactory regionFactory = cache.createRegionFactory(attr.create());
                    partitionRegion = regionFactory.create(ConcurrentIndexOperationsOnOverflowRegionDUnitTest.this.name);
                }
                catch (IllegalStateException ex) {
                    DistributedTestCase.getLogWriter().warning("Creation caught IllegalStateException", (Throwable)ex);
                }
                TestCase.assertNotNull((String)("Region " + ConcurrentIndexOperationsOnOverflowRegionDUnitTest.this.name + " not in cache"), (Object)cache.getRegion(ConcurrentIndexOperationsOnOverflowRegionDUnitTest.this.name));
                TestCase.assertNotNull((String)"Region ref null", partitionRegion);
                TestCase.assertTrue((String)"Region ref claims to be destroyed", (!partitionRegion.isDestroyed() ? 1 : 0) != 0);
                try {
                    Index index = cache.getQueryService().createIndex("statusIndex", "p.ID", "/" + ConcurrentIndexOperationsOnOverflowRegionDUnitTest.this.name + " p");
                    TestCase.assertNotNull((Object)index);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                    TestCase.fail((String)"Index creation failed");
                }
            }
        });
        AsyncInvocation asyncInv1 = vm0.invokeAsync(new CacheSerializableRunnable("Change value in region"){

            @Override
            public void run2() throws CacheException {
                Cache cache = ConcurrentIndexOperationsOnOverflowRegionDUnitTest.this.PRQHelp.getCache();
                Region r = ConcurrentIndexOperationsOnOverflowRegionDUnitTest.this.PRQHelp.getCache().getRegion(ConcurrentIndexOperationsOnOverflowRegionDUnitTest.this.name);
                for (int i = 0; i < 100; ++i) {
                    r.put((Object)i, (Object)new PortfolioData(i));
                }
                TestCase.assertNull((Object)IndexManager.testHook);
                IndexManager.testHook = new IndexManagerNoWaitTestHook();
                ConcurrentIndexOperationsOnOverflowRegionDUnitTest.this.PRQHelp.getCache().getLogger().fine("Destroying the value");
                r.destroy((Object)1);
                IndexManager.testHook = null;
            }
        });
        AsyncInvocation asyncInv2 = vm0.invokeAsync(new CacheSerializableRunnable("Run query on region"){

            @Override
            public void run2() throws CacheException {
                Cache cache = ConcurrentIndexOperationsOnOverflowRegionDUnitTest.this.PRQHelp.getCache();
                Query statusQuery = ConcurrentIndexOperationsOnOverflowRegionDUnitTest.this.PRQHelp.getCache().getQueryService().newQuery("select * from /" + ConcurrentIndexOperationsOnOverflowRegionDUnitTest.this.name + " p where p.ID > -1");
                while (!hooked) {
                    DistributedTestCase.pause(10);
                }
                try {
                    ConcurrentIndexOperationsOnOverflowRegionDUnitTest.this.PRQHelp.getCache().getLogger().fine("Querying the region");
                    SelectResults results = (SelectResults)statusQuery.execute();
                    TestCase.assertEquals((int)100, (int)results.size());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        DistributedTestCase.join(asyncInv2, 30000L, this.PRQHelp.getCache().getLogger());
        DistributedTestCase.join(asyncInv1, 30000L, this.PRQHelp.getCache().getLogger());
    }

    public class IndexManagerNoWaitTestHook
    implements IndexManager.TestHook {
        public void hook(int spot) throws RuntimeException {
            switch (spot) {
                case 5: {
                    hooked = true;
                    DistributedTestCase.getLogWriter().fine("IndexManagerTestHook is hooked.");
                    DistributedTestCase.pause(100);
                    hooked = false;
                    break;
                }
            }
        }
    }

    public class IndexManagerTestHook
    implements IndexManager.TestHook {
        public void hook(int spot) throws RuntimeException {
            switch (spot) {
                case 5: {
                    hooked = true;
                    DistributedTestCase.getLogWriter().fine("IndexManagerTestHook is hooked.");
                    DistributedTestCase.pause(10000);
                    hooked = false;
                    break;
                }
            }
        }
    }
}

