/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.query.internal.index;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionFactory;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.query.Index;
import com.gemstone.gemfire.cache.query.Query;
import com.gemstone.gemfire.cache.query.SelectResults;
import com.gemstone.gemfire.cache.query.data.Portfolio;
import com.gemstone.gemfire.cache.query.data.PortfolioData;
import com.gemstone.gemfire.cache.query.internal.Undefined;
import com.gemstone.gemfire.cache.query.partitioned.PRQueryDUnitHelper;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.cache30.CacheTestCase;
import dunit.AsyncInvocation;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.VM;
import java.util.Arrays;
import junit.framework.TestCase;

public class InitializeIndexEntryDestroyQueryDUnitTest
extends CacheTestCase {
    PRQueryDUnitHelper PRQHelp = new PRQueryDUnitHelper("");
    String name;
    final int redundancy = 0;
    final Portfolio portfolio = new Portfolio(1, 1);
    private int cnt = 0;
    private int cntDest = 100;
    static volatile boolean hooked = false;

    public InitializeIndexEntryDestroyQueryDUnitTest(String name) {
        super(name);
    }

    public void testAsyncIndexInitDuringEntryDestroyAndQuery() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        this.name = "PartionedPortfolios";
        vm0.invoke(new CacheSerializableRunnable("Create local region with asynchronous index maintenance"){

            @Override
            public void run2() throws CacheException {
                Cache cache = InitializeIndexEntryDestroyQueryDUnitTest.this.PRQHelp.getCache();
                Region localRegion = null;
                try {
                    AttributesFactory attr = new AttributesFactory();
                    attr.setValueConstraint(PortfolioData.class);
                    attr.setScope(Scope.LOCAL);
                    attr.setIndexMaintenanceSynchronous(false);
                    RegionFactory regionFactory = cache.createRegionFactory(attr.create());
                    localRegion = regionFactory.create(InitializeIndexEntryDestroyQueryDUnitTest.this.name);
                }
                catch (IllegalStateException ex) {
                    DistributedTestCase.getLogWriter().warning("Creation caught IllegalStateException", (Throwable)ex);
                }
                TestCase.assertNotNull((String)("Region " + InitializeIndexEntryDestroyQueryDUnitTest.this.name + " not in cache"), (Object)cache.getRegion(InitializeIndexEntryDestroyQueryDUnitTest.this.name));
                TestCase.assertNotNull((String)"Region ref null", (Object)localRegion);
                TestCase.assertTrue((String)"Region ref claims to be destroyed", (!localRegion.isDestroyed() ? 1 : 0) != 0);
            }
        });
        Object[] portfolio = this.PRQHelp.createPortfolioData(this.cnt, this.cntDest);
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPuts(this.name, portfolio, this.cnt, this.cntDest));
        AsyncInvocation asyInvk0 = vm0.invokeAsync(new CacheSerializableRunnable("Create Index with Hook"){

            @Override
            public void run2() throws CacheException {
                Region r = InitializeIndexEntryDestroyQueryDUnitTest.this.PRQHelp.getCache().getRegion(InitializeIndexEntryDestroyQueryDUnitTest.this.name);
                for (int i = 0; i < InitializeIndexEntryDestroyQueryDUnitTest.this.cntDest; ++i) {
                    Cache cache = InitializeIndexEntryDestroyQueryDUnitTest.this.PRQHelp.getCache();
                    Index index = null;
                    try {
                        index = cache.getQueryService().createIndex("statusIndex", "p.status", "/" + InitializeIndexEntryDestroyQueryDUnitTest.this.name + " p");
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                        TestCase.fail((String)"Index creation failed");
                    }
                    TestCase.assertNotNull(index);
                    DistributedTestCase.pause(100);
                    InitializeIndexEntryDestroyQueryDUnitTest.this.PRQHelp.getCache().getQueryService().removeIndex(index);
                    DistributedTestCase.pause(100);
                }
            }
        });
        AsyncInvocation asyInvk1 = vm0.invokeAsync(new CacheSerializableRunnable("Change value in region"){

            @Override
            public void run2() throws CacheException {
                Cache cache = InitializeIndexEntryDestroyQueryDUnitTest.this.PRQHelp.getCache();
                Region r = InitializeIndexEntryDestroyQueryDUnitTest.this.PRQHelp.getCache().getRegion(InitializeIndexEntryDestroyQueryDUnitTest.this.name);
                int i = 0;
                int j = 0;
                while (i < 1000) {
                    PortfolioData p = (PortfolioData)r.get((Object)j);
                    InitializeIndexEntryDestroyQueryDUnitTest.this.PRQHelp.getCache().getLogger().fine("Going to destroy the value" + p);
                    r.destroy((Object)j);
                    DistributedTestCase.pause(100);
                    InitializeIndexEntryDestroyQueryDUnitTest.this.PRQHelp.getCache().getLogger().fine("Putting the value back" + p);
                    r.put((Object)j, (Object)p);
                    if (j == InitializeIndexEntryDestroyQueryDUnitTest.this.cntDest - 1) {
                        j = 0;
                    }
                    ++i;
                    ++j;
                }
            }
        });
        vm0.invoke(new CacheSerializableRunnable("Run query on region"){

            @Override
            public void run2() throws CacheException {
                Cache cache = InitializeIndexEntryDestroyQueryDUnitTest.this.PRQHelp.getCache();
                Region r = InitializeIndexEntryDestroyQueryDUnitTest.this.PRQHelp.getCache().getRegion(InitializeIndexEntryDestroyQueryDUnitTest.this.name);
                Query query = InitializeIndexEntryDestroyQueryDUnitTest.this.PRQHelp.getCache().getQueryService().newQuery("select * from /" + InitializeIndexEntryDestroyQueryDUnitTest.this.name + " p where p.status = 'active'");
                SelectResults results = null;
                for (int i = 0; i < 500; ++i) {
                    try {
                        InitializeIndexEntryDestroyQueryDUnitTest.this.PRQHelp.getCache().getLogger().fine("Querying the region");
                        results = (SelectResults)query.execute();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    for (Object obj : results) {
                        if (!(obj instanceof Undefined)) continue;
                        TestCase.fail((String)("Found an undefined element" + Arrays.toString(results.toArray())));
                    }
                }
            }
        });
        DistributedTestCase.join(asyInvk0, 1000000L, InitializeIndexEntryDestroyQueryDUnitTest.getLogWriter());
        if (asyInvk0.exceptionOccurred()) {
            InitializeIndexEntryDestroyQueryDUnitTest.fail("asyInvk0 failed", asyInvk0.getException());
        }
        DistributedTestCase.join(asyInvk1, 1000000L, InitializeIndexEntryDestroyQueryDUnitTest.getLogWriter());
        if (asyInvk1.exceptionOccurred()) {
            InitializeIndexEntryDestroyQueryDUnitTest.fail("asyInvk1 failed", asyInvk1.getException());
        }
    }

    public void testAsyncIndexInitDuringEntryDestroyAndQueryOnPR() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        this.name = "PartionedPortfoliosPR";
        vm0.invoke(new CacheSerializableRunnable("Create local region with asynchronous index maintenance"){

            @Override
            public void run2() throws CacheException {
                Cache cache = InitializeIndexEntryDestroyQueryDUnitTest.this.PRQHelp.getCache();
                Region partitionRegion = null;
                try {
                    AttributesFactory attr = new AttributesFactory();
                    attr.setValueConstraint(PortfolioData.class);
                    attr.setIndexMaintenanceSynchronous(false);
                    attr.setPartitionAttributes(new PartitionAttributesFactory().create());
                    RegionFactory regionFactory = cache.createRegionFactory(attr.create());
                    partitionRegion = regionFactory.create(InitializeIndexEntryDestroyQueryDUnitTest.this.name);
                }
                catch (IllegalStateException ex) {
                    DistributedTestCase.getLogWriter().warning("Creation caught IllegalStateException", (Throwable)ex);
                }
                TestCase.assertNotNull((String)("Region " + InitializeIndexEntryDestroyQueryDUnitTest.this.name + " not in cache"), (Object)cache.getRegion(InitializeIndexEntryDestroyQueryDUnitTest.this.name));
                TestCase.assertNotNull((String)"Region ref null", (Object)partitionRegion);
                TestCase.assertTrue((String)"Region ref claims to be destroyed", (!partitionRegion.isDestroyed() ? 1 : 0) != 0);
            }
        });
        Object[] portfolio = this.PRQHelp.createPortfolioData(this.cnt, this.cntDest);
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPuts(this.name, portfolio, this.cnt, this.cntDest));
        AsyncInvocation asyInvk0 = vm0.invokeAsync(new CacheSerializableRunnable("Create Index with Hook"){

            @Override
            public void run2() throws CacheException {
                Region r = InitializeIndexEntryDestroyQueryDUnitTest.this.PRQHelp.getCache().getRegion(InitializeIndexEntryDestroyQueryDUnitTest.this.name);
                for (int i = 0; i < InitializeIndexEntryDestroyQueryDUnitTest.this.cntDest; ++i) {
                    Cache cache = InitializeIndexEntryDestroyQueryDUnitTest.this.PRQHelp.getCache();
                    Index index = null;
                    try {
                        index = cache.getQueryService().createIndex("statusIndex", "p.status", "/" + InitializeIndexEntryDestroyQueryDUnitTest.this.name + " p");
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                        TestCase.fail((String)"Index creation failed");
                    }
                    TestCase.assertNotNull(index);
                    InitializeIndexEntryDestroyQueryDUnitTest.this.PRQHelp.getCache().getQueryService().removeIndex(index);
                }
            }
        });
        AsyncInvocation asyInvk1 = vm0.invokeAsync(new CacheSerializableRunnable("Change value in region"){

            @Override
            public void run2() throws CacheException {
                Cache cache = InitializeIndexEntryDestroyQueryDUnitTest.this.PRQHelp.getCache();
                Region r = InitializeIndexEntryDestroyQueryDUnitTest.this.PRQHelp.getCache().getRegion(InitializeIndexEntryDestroyQueryDUnitTest.this.name);
                int i = 0;
                int j = 0;
                while (i < 1000) {
                    PortfolioData p = (PortfolioData)r.get((Object)j);
                    InitializeIndexEntryDestroyQueryDUnitTest.this.PRQHelp.getCache().getLogger().fine("Going to destroy the value" + p);
                    r.destroy((Object)j);
                    DistributedTestCase.pause(20);
                    InitializeIndexEntryDestroyQueryDUnitTest.this.PRQHelp.getCache().getLogger().fine("Putting the value back" + p);
                    r.put((Object)j, (Object)p);
                    if (j == InitializeIndexEntryDestroyQueryDUnitTest.this.cntDest - 1) {
                        j = 0;
                    }
                    ++i;
                    ++j;
                }
            }
        });
        vm0.invoke(new CacheSerializableRunnable("Run query on region"){

            @Override
            public void run2() throws CacheException {
                Cache cache = InitializeIndexEntryDestroyQueryDUnitTest.this.PRQHelp.getCache();
                Region r = InitializeIndexEntryDestroyQueryDUnitTest.this.PRQHelp.getCache().getRegion(InitializeIndexEntryDestroyQueryDUnitTest.this.name);
                Query query = InitializeIndexEntryDestroyQueryDUnitTest.this.PRQHelp.getCache().getQueryService().newQuery("select * from /" + InitializeIndexEntryDestroyQueryDUnitTest.this.name + " p where p.status = 'active'");
                SelectResults results = null;
                for (int i = 0; i < 500; ++i) {
                    try {
                        InitializeIndexEntryDestroyQueryDUnitTest.this.PRQHelp.getCache().getLogger().fine("Querying the region");
                        results = (SelectResults)query.execute();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    for (Object obj : results) {
                        if (!(obj instanceof Undefined)) continue;
                        TestCase.fail((String)("Found an undefined element" + Arrays.toString(results.toArray())));
                    }
                }
            }
        });
        DistributedTestCase.join(asyInvk0, 1000000L, InitializeIndexEntryDestroyQueryDUnitTest.getLogWriter());
        if (asyInvk0.exceptionOccurred()) {
            InitializeIndexEntryDestroyQueryDUnitTest.fail("asyInvk0 failed", asyInvk0.getException());
        }
        DistributedTestCase.join(asyInvk1, 1000000L, InitializeIndexEntryDestroyQueryDUnitTest.getLogWriter());
        if (asyInvk1.exceptionOccurred()) {
            InitializeIndexEntryDestroyQueryDUnitTest.fail("asyInvk1 failed", asyInvk1.getException());
        }
    }

    public void testConcurrentRemoveIndexAndQueryOnPR() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        this.name = "PartionedPortfoliosPR";
        vm0.invoke(new CacheSerializableRunnable("Create local region with asynchronous index maintenance"){

            @Override
            public void run2() throws CacheException {
                Cache cache = InitializeIndexEntryDestroyQueryDUnitTest.this.PRQHelp.getCache();
                Region partitionRegion = null;
                try {
                    AttributesFactory attr = new AttributesFactory();
                    attr.setValueConstraint(PortfolioData.class);
                    attr.setIndexMaintenanceSynchronous(false);
                    attr.setPartitionAttributes(new PartitionAttributesFactory().create());
                    RegionFactory regionFactory = cache.createRegionFactory(attr.create());
                    partitionRegion = regionFactory.create(InitializeIndexEntryDestroyQueryDUnitTest.this.name);
                }
                catch (IllegalStateException ex) {
                    DistributedTestCase.getLogWriter().warning("Creation caught IllegalStateException", (Throwable)ex);
                }
                TestCase.assertNotNull((String)("Region " + InitializeIndexEntryDestroyQueryDUnitTest.this.name + " not in cache"), (Object)cache.getRegion(InitializeIndexEntryDestroyQueryDUnitTest.this.name));
                TestCase.assertNotNull((String)"Region ref null", (Object)partitionRegion);
                TestCase.assertTrue((String)"Region ref claims to be destroyed", (!partitionRegion.isDestroyed() ? 1 : 0) != 0);
            }
        });
        Object[] portfolio = this.PRQHelp.createPortfolioData(this.cnt, this.cntDest);
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPuts(this.name, portfolio, this.cnt, this.cntDest));
        vm0.invoke(new CacheSerializableRunnable("Create Index"){

            @Override
            public void run2() throws CacheException {
                Region r = InitializeIndexEntryDestroyQueryDUnitTest.this.PRQHelp.getCache().getRegion(InitializeIndexEntryDestroyQueryDUnitTest.this.name);
                Cache cache = InitializeIndexEntryDestroyQueryDUnitTest.this.PRQHelp.getCache();
                Index sindex = null;
                Index iindex = null;
                Index pkindex = null;
                try {
                    sindex = cache.getQueryService().createIndex("statusIndex", "p.status", "/" + InitializeIndexEntryDestroyQueryDUnitTest.this.name + " p");
                    iindex = cache.getQueryService().createIndex("idIndex", "p.ID", "/" + InitializeIndexEntryDestroyQueryDUnitTest.this.name + " p");
                    pkindex = cache.getQueryService().createIndex("pkidIndex", "p.pk", "/" + InitializeIndexEntryDestroyQueryDUnitTest.this.name + " p");
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                    TestCase.fail((String)"Index creation failed");
                }
                TestCase.assertNotNull(sindex);
                TestCase.assertNotNull(iindex);
                TestCase.assertNotNull(pkindex);
            }
        });
        vm0.invoke(new CacheSerializableRunnable("Run query on region"){

            @Override
            public void run2() throws CacheException {
                Cache cache = InitializeIndexEntryDestroyQueryDUnitTest.this.PRQHelp.getCache();
                Region r = InitializeIndexEntryDestroyQueryDUnitTest.this.PRQHelp.getCache().getRegion(InitializeIndexEntryDestroyQueryDUnitTest.this.name);
                Query query = InitializeIndexEntryDestroyQueryDUnitTest.this.PRQHelp.getCache().getQueryService().newQuery("select * from /" + InitializeIndexEntryDestroyQueryDUnitTest.this.name + " p where p.status = 'active' and p.ID > 0 and p.pk != ' ' ");
                SelectResults results = null;
                for (int i = 0; i < 10; ++i) {
                    try {
                        InitializeIndexEntryDestroyQueryDUnitTest.this.PRQHelp.getCache().getLogger().fine("Querying the region with " + query);
                        results = (SelectResults)query.execute();
                    }
                    catch (Exception e) {
                        DistributedTestCase.fail("Query: " + query + " execution failed with exception", e);
                    }
                    for (Object obj : results) {
                        if (!(obj instanceof Undefined)) continue;
                        TestCase.fail((String)("Found an undefined element" + Arrays.toString(results.toArray())));
                    }
                }
            }
        });
        vm0.invoke(new CacheSerializableRunnable("Create Index"){

            @Override
            public void run2() throws CacheException {
                Region r = InitializeIndexEntryDestroyQueryDUnitTest.this.PRQHelp.getCache().getRegion(InitializeIndexEntryDestroyQueryDUnitTest.this.name);
                Cache cache = InitializeIndexEntryDestroyQueryDUnitTest.this.PRQHelp.getCache();
                InitializeIndexEntryDestroyQueryDUnitTest.this.PRQHelp.getCache().getQueryService().removeIndexes(r);
            }
        });
    }
}

