/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.query.internal.index;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.client.ClientCache;
import com.gemstone.gemfire.cache.client.ClientCacheFactory;
import com.gemstone.gemfire.cache.client.ClientRegionShortcut;
import com.gemstone.gemfire.cache.query.data.PortfolioPdx;
import com.gemstone.gemfire.cache.server.CacheServer;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.internal.AvailablePort;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.VM;
import java.io.IOException;
import java.util.HashMap;
import java.util.Properties;

public class PutAllWithIndexPerfDUnitTest
extends CacheTestCase {
    private static int bridgeServerPort;
    static long timeWithoutStructTypeIndex;
    static long timeWithStructTypeIndex;

    public PutAllWithIndexPerfDUnitTest(String name) {
        super(name);
    }

    public static void caseSetUp() throws Exception {
        PutAllWithIndexPerfDUnitTest.disconnectAllFromDS();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tearDown2() throws Exception {
        try {
            super.tearDown2();
        }
        finally {
            PutAllWithIndexPerfDUnitTest.disconnectAllFromDS();
        }
    }

    public void testPutAllWithIndexes() {
        String name = "testRegion";
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        int numberOfEntries = 10000;
        vm0.invoke(new CacheSerializableRunnable("Create Bridge Server"){

            @Override
            public void run2() throws CacheException {
                Properties config = new Properties();
                int unusedPort = AvailablePort.getRandomAvailablePort((int)1);
                config.setProperty("mcast-port", String.valueOf(unusedPort));
                Cache cache = new CacheFactory(config).create();
                AttributesFactory factory = new AttributesFactory();
                factory.setScope(Scope.LOCAL);
                cache.createRegionFactory(factory.create()).create("testRegion");
                try {
                    PutAllWithIndexPerfDUnitTest.this.startBridgeServer(0, false);
                }
                catch (Exception ex) {
                    DistributedTestCase.fail("While starting CacheServer", ex);
                }
                try {
                    cache.getQueryService().createIndex("idIndex", "ID", "/testRegion");
                }
                catch (Exception e) {
                    DistributedTestCase.fail("index creation failed", e);
                }
            }
        });
        final int port = vm0.invokeInt(PutAllWithIndexPerfDUnitTest.class, "getCacheServerPort");
        final String host0 = PutAllWithIndexPerfDUnitTest.getServerHostName(vm0.getHost());
        vm1.invoke(new CacheSerializableRunnable("Create region"){

            @Override
            public void run2() throws CacheException {
                Properties config = new Properties();
                config.setProperty("mcast-port", "0");
                ClientCache cache = new ClientCacheFactory().addPoolServer(host0, port).create();
                AttributesFactory factory = new AttributesFactory();
                factory.setScope(Scope.LOCAL);
                cache.createClientRegionFactory(ClientRegionShortcut.PROXY).create("testRegion");
            }
        });
        vm1.invoke(new CacheSerializableRunnable("putAll() test"){

            @Override
            public void run2() throws CacheException {
                int i;
                Region exampleRegion = ClientCacheFactory.getAnyInstance().getRegion("testRegion");
                HashMap<Integer, PortfolioPdx> warmupMap = new HashMap<Integer, PortfolioPdx>();
                HashMap<Integer, PortfolioPdx> data = new HashMap<Integer, PortfolioPdx>();
                for (i = 0; i < 10000; ++i) {
                    PortfolioPdx p = new PortfolioPdx(i);
                    if (i < 1000) {
                        warmupMap.put(i, p);
                    }
                    data.put(i, p);
                }
                for (i = 0; i < 10; ++i) {
                    exampleRegion.putAll(warmupMap);
                }
                long start = System.currentTimeMillis();
                for (int i2 = 0; i2 < 10; ++i2) {
                    exampleRegion.putAll(data);
                }
                long end = System.currentTimeMillis();
                timeWithoutStructTypeIndex = (end - start) / 10L;
                System.out.println("Total putall time for 10000 objects is: " + (end - start) / 10L + "ms");
            }
        });
        vm0.invoke(new CacheSerializableRunnable("Remove Index and create new one"){

            @Override
            public void run2() throws CacheException {
                try {
                    Cache cache = CacheFactory.getAnyInstance();
                    cache.getQueryService().removeIndexes();
                    cache.getRegion("testRegion").clear();
                    cache.getQueryService().createIndex("idIndex", "p.ID", "/testRegion p");
                }
                catch (Exception e) {
                    DistributedTestCase.fail("index creation failed", e);
                }
            }
        });
        vm1.invoke(new CacheSerializableRunnable("putAll() test"){

            @Override
            public void run2() throws CacheException {
                int i;
                Region exampleRegion = ClientCacheFactory.getAnyInstance().getRegion("testRegion");
                exampleRegion.clear();
                HashMap<Integer, PortfolioPdx> warmupMap = new HashMap<Integer, PortfolioPdx>();
                HashMap<Integer, PortfolioPdx> data = new HashMap<Integer, PortfolioPdx>();
                for (i = 0; i < 10000; ++i) {
                    PortfolioPdx p = new PortfolioPdx(i);
                    if (i < 1000) {
                        warmupMap.put(i, p);
                    }
                    data.put(i, p);
                }
                for (i = 0; i < 10; ++i) {
                    exampleRegion.putAll(warmupMap);
                }
                long start = System.currentTimeMillis();
                for (int i2 = 0; i2 < 10; ++i2) {
                    exampleRegion.putAll(data);
                }
                long end = System.currentTimeMillis();
                timeWithStructTypeIndex = (end - start) / 10L;
                System.out.println("Total putall time for 10000 objects is: " + (end - start) / 10L + "ms");
            }
        });
        if (timeWithoutStructTypeIndex > timeWithStructTypeIndex) {
            PutAllWithIndexPerfDUnitTest.fail((String)"putAll took more time without struct type index than simple index");
        }
    }

    protected void startBridgeServer(int port, boolean notifyBySubscription) throws IOException {
        Cache cache = CacheFactory.getAnyInstance();
        CacheServer bridge = cache.addCacheServer();
        bridge.setPort(port);
        bridge.start();
        bridgeServerPort = bridge.getPort();
    }

    private static int getCacheServerPort() {
        return bridgeServerPort;
    }

    static {
        timeWithoutStructTypeIndex = 0L;
        timeWithStructTypeIndex = 0L;
    }
}

