/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.query.partitioned;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheClosedException;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.PartitionAttributes;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionDestroyedException;
import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.FunctionAdapter;
import com.gemstone.gemfire.cache.execute.FunctionContext;
import com.gemstone.gemfire.cache.execute.FunctionException;
import com.gemstone.gemfire.cache.execute.FunctionService;
import com.gemstone.gemfire.cache.execute.RegionFunctionContext;
import com.gemstone.gemfire.cache.query.Query;
import com.gemstone.gemfire.cache.query.QueryException;
import com.gemstone.gemfire.cache.query.QueryInvocationTargetException;
import com.gemstone.gemfire.cache.query.QueryService;
import com.gemstone.gemfire.cache.query.RegionNotFoundException;
import com.gemstone.gemfire.cache.query.SelectResults;
import com.gemstone.gemfire.cache.query.data.Portfolio;
import com.gemstone.gemfire.cache.query.partitioned.PRQueryDUnitHelper;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.distributed.internal.ReplyException;
import com.gemstone.gemfire.internal.cache.ForceReattemptException;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegionDUnitTestCase;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.VM;
import java.util.ArrayList;
import junit.framework.TestCase;
import parReg.query.NewPortfolio;
import util.TestException;

public class PRColocatedEquiJoinDUnitTest
extends PartitionedRegionDUnitTestCase {
    int totalNumBuckets = 100;
    int queryTestCycle = 10;
    PRQueryDUnitHelper PRQHelp = new PRQueryDUnitHelper("");
    final String name = "Portfolios1";
    final String coloName = "Portfolios2";
    final String localName = "LocalPortfolios1";
    final String coloLocalName = "LocalPortfolios2";
    final int cnt = 0;
    final int cntDest = 200;
    final int redundancy = 1;

    public PRColocatedEquiJoinDUnitTest(String name) {
        super(name);
    }

    public void testPRLocalQuerying() throws Exception {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        PRColocatedEquiJoinDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRBasicQuerying: Querying PR Test with DACK Started");
        PRColocatedEquiJoinDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRBasicQuerying: Creating the DataStore node in the PR");
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRCreate("Portfolios1", 1, Portfolio.class));
        PRColocatedEquiJoinDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRBasicQuerying: Successfully created the DataStore node in the PR");
        PRColocatedEquiJoinDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRBasicQuerying: Successfully Created PR's across all VM's");
        PRColocatedEquiJoinDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRBasicQuerying: Creating the Colocated DataStore node in the PR");
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRColocatedCreate("Portfolios2", 1, "Portfolios1"));
        PRColocatedEquiJoinDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRBasicQuerying: Successfully created the Colocated DataStore node in the PR");
        PRColocatedEquiJoinDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRBasicQuerying: Successfully Created PR's across all VM's");
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForLocalRegionCreation("LocalPortfolios1", Portfolio.class));
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForLocalRegionCreation("LocalPortfolios2", NewPortfolio.class));
        Object[] portfolio = this.PRQHelp.createPortfoliosAndPositions(200);
        Object[] newPortfolio = this.PRQHelp.createNewPortfoliosAndPositions(200);
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPuts("LocalPortfolios1", portfolio, 0, 200));
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPuts("LocalPortfolios2", newPortfolio, 0, 200));
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPuts("Portfolios1", portfolio, 0, 200));
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPuts("Portfolios2", newPortfolio, 0, 200));
        PRColocatedEquiJoinDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRBasicQuerying: Inserted Portfolio data across PR's");
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRColocatedDataSetQueryAndCompareResults("Portfolios1", "Portfolios2", "LocalPortfolios1", "LocalPortfolios2"));
        PRColocatedEquiJoinDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRBasicQuerying: Querying PR's Test ENDED");
    }

    public void testNonColocatedPRLocalQuerying() throws Exception {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        PRColocatedEquiJoinDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRBasicQuerying: Querying PR Test with DACK Started");
        PRColocatedEquiJoinDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRBasicQuerying: Creating the DataStore node in the PR");
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRCreate("Portfolios1", 1, Portfolio.class));
        PRColocatedEquiJoinDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRBasicQuerying: Successfully created the DataStore node in the PR");
        PRColocatedEquiJoinDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRBasicQuerying: Successfully Created PR's across all VM's");
        PRColocatedEquiJoinDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRBasicQuerying: Creating the Colocated DataStore node in the PR");
        vm0.invoke(new CacheSerializableRunnable("Portfolios2"){

            @Override
            public void run2() throws CacheException {
                Cache cache = PRColocatedEquiJoinDUnitTest.this.getCache();
                Region partitionedregion = null;
                try {
                    AttributesFactory attr = new AttributesFactory();
                    attr.setValueConstraint(NewPortfolio.class);
                    PartitionAttributesFactory paf = new PartitionAttributesFactory();
                    PartitionAttributes prAttr = paf.setRedundantCopies(1).create();
                    attr.setPartitionAttributes(prAttr);
                    partitionedregion = cache.createRegion("Portfolios2", attr.create());
                }
                catch (IllegalStateException ex) {
                    DistributedTestCase.getLogWriter().warning("PRQueryDUnitHelper#getCacheSerializableRunnableForPRCreateWithRedundancy: Creation caught IllegalStateException", (Throwable)ex);
                }
                TestCase.assertNotNull((String)"PRQueryDUnitHelper#getCacheSerializableRunnableForPRCreateWithRedundancy: Partitioned Region Portfolios2 not in cache", (Object)cache.getRegion("Portfolios2"));
                TestCase.assertNotNull((String)"PRQueryDUnitHelper#getCacheSerializableRunnableForPRCreateWithRedundancy: Partitioned Region ref null", partitionedregion);
                TestCase.assertTrue((String)"PRQueryDUnitHelper#getCacheSerializableRunnableForPRCreateWithRedundancy: Partitioned Region ref claims to be destroyed", (!partitionedregion.isDestroyed() ? 1 : 0) != 0);
            }
        });
        PRColocatedEquiJoinDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRBasicQuerying: Successfully created the Colocated DataStore node in the PR");
        PRColocatedEquiJoinDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRBasicQuerying: Successfully Created PR's across all VM's");
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForLocalRegionCreation("LocalPortfolios1", Portfolio.class));
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForLocalRegionCreation("LocalPortfolios2", NewPortfolio.class));
        Object[] portfolio = this.PRQHelp.createPortfoliosAndPositions(200);
        Object[] newPortfolio = this.PRQHelp.createNewPortfoliosAndPositions(200);
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPuts("LocalPortfolios1", portfolio, 0, 200));
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPuts("LocalPortfolios2", newPortfolio, 0, 200));
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPuts("Portfolios1", portfolio, 0, 200));
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPuts("Portfolios2", newPortfolio, 0, 200));
        PRColocatedEquiJoinDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRBasicQuerying: Inserted Portfolio data across PR's");
        vm0.invoke(new CacheSerializableRunnable("PRQuery"){

            @Override
            public void run2() throws CacheException {
                Cache cache = PRColocatedEquiJoinDUnitTest.this.getCache();
                String[] queries = new String[]{"r1.ID = r2.id"};
                Object[][] r = new Object[queries.length][2];
                Region region = null;
                region = cache.getRegion("Portfolios1");
                TestCase.assertNotNull((Object)region);
                region = cache.getRegion("Portfolios2");
                TestCase.assertNotNull((Object)region);
                QueryService qs = PRColocatedEquiJoinDUnitTest.this.getCache().getQueryService();
                try {
                    for (int j = 0; j < queries.length; ++j) {
                        PRColocatedEquiJoinDUnitTest.this.getCache().getLogger().info("About to execute local query: " + queries[j]);
                        final class TestQueryFunction
                        extends FunctionAdapter {
                            private final String id;

                            public boolean hasResult() {
                                return true;
                            }

                            public boolean isHA() {
                                return false;
                            }

                            public TestQueryFunction(String id) {
                                this.id = id;
                            }

                            public void execute(FunctionContext context) {
                                Cache cache = CacheFactory.getAnyInstance();
                                QueryService queryService = cache.getQueryService();
                                ArrayList allQueryResults = new ArrayList();
                                String qstr = (String)context.getArguments();
                                try {
                                    Query query = queryService.newQuery(qstr);
                                    context.getResultSender().sendResult((Object)((ArrayList)((SelectResults)query.execute((RegionFunctionContext)context)).asList()));
                                    context.getResultSender().lastResult(null);
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                    throw new FunctionException((Throwable)e);
                                }
                            }

                            public String getId() {
                                return this.id;
                            }
                        }
                        TestQueryFunction func = new TestQueryFunction("testfunction");
                        Object funcResult = FunctionService.onRegion((Region)(PRColocatedEquiJoinDUnitTest.this.getCache().getRegion("Portfolios1") instanceof PartitionedRegion ? PRColocatedEquiJoinDUnitTest.this.getCache().getRegion("Portfolios1") : PRColocatedEquiJoinDUnitTest.this.getCache().getRegion("Portfolios2"))).withArgs((Object)("Select " + (queries[j].contains("ORDER BY") ? "DISTINCT" : "") + " * from /" + "Portfolios1" + " r1, /" + "Portfolios2" + " r2 where " + queries[j])).execute((Function)func).getResult();
                        r[j][0] = ((ArrayList)funcResult).get(0);
                    }
                    TestCase.fail((String)"PRQueryDUnitHelper#getCacheSerializableRunnableForPRQueryAndCompareResults: Queries Executed successfully with non-colocated region on one of the nodes");
                }
                catch (FunctionException e) {
                    if (e.getCause() instanceof UnsupportedOperationException) {
                        DistributedTestCase.getLogWriter().info("Query received FunctionException successfully while using QueryService.");
                    }
                    TestCase.fail((String)"UnsupportedOperationException must be thrown here");
                }
            }
        });
        PRColocatedEquiJoinDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRBasicQuerying: Querying PR's Test ENDED");
    }

    public void testPRLocalQueryingWithIndexes() throws Exception {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        PRColocatedEquiJoinDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRBasicQuerying: Querying PR Test with DACK Started");
        PRColocatedEquiJoinDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRBasicQuerying: Creating the DataStore node in the PR");
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRCreate("Portfolios1", 1, Portfolio.class));
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRIndexCreate("Portfolios1", "IdIndex1", "r1.ID", "/Portfolios1 r1", null));
        PRColocatedEquiJoinDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRBasicQuerying: Successfully created the DataStore node in the PR");
        PRColocatedEquiJoinDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRBasicQuerying: Successfully Created PR's across all VM's");
        PRColocatedEquiJoinDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRBasicQuerying: Creating the Colocated DataStore node in the PR");
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRColocatedCreate("Portfolios2", 1, "Portfolios1"));
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRIndexCreate("Portfolios2", "IdIndex2", "r2.id", "/Portfolios2 r2", null));
        PRColocatedEquiJoinDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRBasicQuerying: Successfully created the Colocated DataStore node in the PR");
        PRColocatedEquiJoinDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRBasicQuerying: Successfully Created PR's across all VM's");
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForLocalRegionCreation("LocalPortfolios1", Portfolio.class));
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForLocalRegionCreation("LocalPortfolios2", NewPortfolio.class));
        Object[] portfolio = this.PRQHelp.createPortfoliosAndPositions(200);
        Object[] newPortfolio = this.PRQHelp.createNewPortfoliosAndPositions(200);
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPuts("LocalPortfolios1", portfolio, 0, 200));
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPuts("LocalPortfolios2", newPortfolio, 0, 200));
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPuts("Portfolios1", portfolio, 0, 200));
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPuts("Portfolios2", newPortfolio, 0, 200));
        PRColocatedEquiJoinDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRBasicQuerying: Inserted Portfolio data across PR's");
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRColocatedDataSetQueryAndCompareResults("Portfolios1", "Portfolios2", "LocalPortfolios1", "LocalPortfolios2"));
        PRColocatedEquiJoinDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRBasicQuerying: Querying PR's Test ENDED");
    }

    public void testPRLocalQueryingWithIndexOnOneRegion() throws Exception {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        PRColocatedEquiJoinDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRBasicQuerying: Querying PR Test with DACK Started");
        PRColocatedEquiJoinDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRBasicQuerying: Creating the DataStore node in the PR");
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRCreate("Portfolios1", 1, Portfolio.class));
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRIndexCreate("Portfolios1", "IdIndex1", "r1.ID", "/Portfolios1 r1", null));
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRIndexCreate("Portfolios1", "IdIndex11", "r1.status", "/Portfolios1 r1", null));
        PRColocatedEquiJoinDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRBasicQuerying: Successfully created the DataStore node in the PR");
        PRColocatedEquiJoinDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRBasicQuerying: Successfully Created PR's across all VM's");
        PRColocatedEquiJoinDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRBasicQuerying: Creating the Colocated DataStore node in the PR");
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRColocatedCreate("Portfolios2", 1, "Portfolios1"));
        PRColocatedEquiJoinDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRBasicQuerying: Successfully created the Colocated DataStore node in the PR");
        PRColocatedEquiJoinDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRBasicQuerying: Successfully Created PR's across all VM's");
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForLocalRegionCreation("LocalPortfolios1", Portfolio.class));
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForLocalRegionCreation("LocalPortfolios2", NewPortfolio.class));
        Object[] portfolio = this.PRQHelp.createPortfoliosAndPositions(200);
        Object[] newPortfolio = this.PRQHelp.createNewPortfoliosAndPositions(200);
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPuts("LocalPortfolios1", portfolio, 0, 200));
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPuts("LocalPortfolios2", newPortfolio, 0, 200));
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPuts("Portfolios1", portfolio, 0, 200));
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPuts("Portfolios2", newPortfolio, 0, 200));
        PRColocatedEquiJoinDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRBasicQuerying: Inserted Portfolio data across PR's");
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRColocatedDataSetQueryAndCompareResults("Portfolios1", "Portfolios2", "LocalPortfolios1", "LocalPortfolios2"));
        PRColocatedEquiJoinDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRBasicQuerying: Querying PR's Test ENDED");
    }

    public void testPRRRLocalQuerying() throws Exception {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        PRColocatedEquiJoinDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRBasicQuerying: Querying PR Test with DACK Started");
        PRColocatedEquiJoinDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRBasicQuerying: Creating the DataStore node in the PR");
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRCreate("Portfolios1", 1, Portfolio.class));
        PRColocatedEquiJoinDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRBasicQuerying: Successfully created the DataStore node in the PR");
        PRColocatedEquiJoinDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRBasicQuerying: Successfully Created PR's across all VM's");
        PRColocatedEquiJoinDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRBasicQuerying: Creating the Colocated DataStore node in the PR");
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForLocalRegionCreation("Portfolios2", NewPortfolio.class));
        PRColocatedEquiJoinDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRBasicQuerying: Successfully created the Colocated DataStore node in the PR");
        PRColocatedEquiJoinDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRBasicQuerying: Successfully Created PR's across all VM's");
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForLocalRegionCreation("LocalPortfolios1", Portfolio.class));
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForLocalRegionCreation("LocalPortfolios2", NewPortfolio.class));
        Object[] portfolio = this.PRQHelp.createPortfoliosAndPositions(200);
        Object[] newPortfolio = this.PRQHelp.createNewPortfoliosAndPositions(200);
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPuts("LocalPortfolios1", portfolio, 0, 200));
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPuts("LocalPortfolios2", newPortfolio, 0, 200));
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPuts("Portfolios1", portfolio, 0, 200));
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPuts("Portfolios2", newPortfolio, 0, 200));
        PRColocatedEquiJoinDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRBasicQuerying: Inserted Portfolio data across PR's");
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRColocatedDataSetQueryAndCompareResults("Portfolios1", "Portfolios2", "LocalPortfolios1", "LocalPortfolios2"));
        PRColocatedEquiJoinDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRBasicQuerying: Querying PR's Test ENDED");
    }

    public void testPRRRLocalQueryingWithIndexes() throws Exception {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        PRColocatedEquiJoinDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRBasicQuerying: Querying PR Test with DACK Started");
        PRColocatedEquiJoinDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRBasicQuerying: Creating the DataStore node in the PR");
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRCreate("Portfolios1", 1, Portfolio.class));
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRIndexCreate("Portfolios1", "IdIndex1", "r1.ID", "/Portfolios1 r1", null));
        PRColocatedEquiJoinDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRBasicQuerying: Successfully created the DataStore node in the PR");
        PRColocatedEquiJoinDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRBasicQuerying: Successfully Created PR's across all VM's");
        PRColocatedEquiJoinDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRBasicQuerying: Creating the Colocated DataStore node in the PR");
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForLocalRegionCreation("Portfolios2", NewPortfolio.class));
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRIndexCreate("Portfolios2", "IdIndex2", "r2.id", "/Portfolios2 r2", null));
        PRColocatedEquiJoinDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRBasicQuerying: Successfully created the Colocated DataStore node in the PR");
        PRColocatedEquiJoinDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRBasicQuerying: Successfully Created PR's across all VM's");
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForLocalRegionCreation("LocalPortfolios1", Portfolio.class));
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForLocalRegionCreation("LocalPortfolios2", NewPortfolio.class));
        Object[] portfolio = this.PRQHelp.createPortfoliosAndPositions(200);
        Object[] newPortfolio = this.PRQHelp.createNewPortfoliosAndPositions(200);
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPuts("LocalPortfolios1", portfolio, 0, 200));
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPuts("LocalPortfolios2", newPortfolio, 0, 200));
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPuts("Portfolios1", portfolio, 0, 200));
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPuts("Portfolios2", newPortfolio, 0, 200));
        PRColocatedEquiJoinDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRBasicQuerying: Inserted Portfolio data across PR's");
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRColocatedDataSetQueryAndCompareResults("Portfolios1", "Portfolios2", "LocalPortfolios1", "LocalPortfolios2"));
        PRColocatedEquiJoinDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRBasicQuerying: Querying PR's Test ENDED");
    }

    public void testPRRRLocalQueryingWithIndexOnOnePRRegion() throws Exception {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        PRColocatedEquiJoinDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRBasicQuerying: Querying PR Test with DACK Started");
        PRColocatedEquiJoinDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRBasicQuerying: Creating the DataStore node in the PR");
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRCreate("Portfolios1", 1, Portfolio.class));
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRIndexCreate("Portfolios1", "IdIndex1", "r1.ID", "/Portfolios1 r1", null));
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRIndexCreate("Portfolios1", "IdIndex11", "r1.status", "/Portfolios1 r1", null));
        PRColocatedEquiJoinDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRBasicQuerying: Successfully created the DataStore node in the PR");
        PRColocatedEquiJoinDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRBasicQuerying: Successfully Created PR's across all VM's");
        PRColocatedEquiJoinDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRBasicQuerying: Creating the Colocated DataStore node in the PR");
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForLocalRegionCreation("Portfolios2", NewPortfolio.class));
        PRColocatedEquiJoinDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRBasicQuerying: Successfully created the Colocated DataStore node in the PR");
        PRColocatedEquiJoinDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRBasicQuerying: Successfully Created PR's across all VM's");
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForLocalRegionCreation("LocalPortfolios1", Portfolio.class));
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForLocalRegionCreation("LocalPortfolios2", NewPortfolio.class));
        Object[] portfolio = this.PRQHelp.createPortfoliosAndPositions(200);
        Object[] newPortfolio = this.PRQHelp.createNewPortfoliosAndPositions(200);
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPuts("LocalPortfolios1", portfolio, 0, 200));
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPuts("LocalPortfolios2", newPortfolio, 0, 200));
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPuts("Portfolios1", portfolio, 0, 200));
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPuts("Portfolios2", newPortfolio, 0, 200));
        PRColocatedEquiJoinDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRBasicQuerying: Inserted Portfolio data across PR's");
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRColocatedDataSetQueryAndCompareResults("Portfolios1", "Portfolios2", "LocalPortfolios1", "LocalPortfolios2"));
        PRColocatedEquiJoinDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRBasicQuerying: Querying PR's Test ENDED");
    }

    public void testRRPRLocalQuerying() throws Exception {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        PRColocatedEquiJoinDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRBasicQuerying: Querying PR Test with DACK Started");
        PRColocatedEquiJoinDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRBasicQuerying: Creating the DataStore node in the PR");
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRCreate("Portfolios2", 1, NewPortfolio.class));
        PRColocatedEquiJoinDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRBasicQuerying: Successfully created the DataStore node in the PR");
        PRColocatedEquiJoinDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRBasicQuerying: Successfully Created PR's across all VM's");
        PRColocatedEquiJoinDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRBasicQuerying: Creating the Colocated DataStore node in the PR");
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForLocalRegionCreation("Portfolios1", Portfolio.class));
        PRColocatedEquiJoinDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRBasicQuerying: Successfully created the Colocated DataStore node in the PR");
        PRColocatedEquiJoinDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRBasicQuerying: Successfully Created PR's across all VM's");
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForLocalRegionCreation("LocalPortfolios1", Portfolio.class));
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForLocalRegionCreation("LocalPortfolios2", NewPortfolio.class));
        Object[] portfolio = this.PRQHelp.createPortfoliosAndPositions(200);
        Object[] newPortfolio = this.PRQHelp.createNewPortfoliosAndPositions(200);
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPuts("LocalPortfolios1", portfolio, 0, 200));
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPuts("LocalPortfolios2", newPortfolio, 0, 200));
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPuts("Portfolios1", portfolio, 0, 200));
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPuts("Portfolios2", newPortfolio, 0, 200));
        PRColocatedEquiJoinDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRBasicQuerying: Inserted Portfolio data across PR's");
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRColocatedDataSetQueryAndCompareResults("Portfolios1", "Portfolios2", "LocalPortfolios1", "LocalPortfolios2"));
        PRColocatedEquiJoinDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRBasicQuerying: Querying PR's Test ENDED");
    }

    public void testRRPRLocalQueryingWithIndexes() throws Exception {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        PRColocatedEquiJoinDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRBasicQuerying: Querying PR Test with DACK Started");
        PRColocatedEquiJoinDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRBasicQuerying: Creating the DataStore node in the PR");
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRCreate("Portfolios2", 1, NewPortfolio.class));
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRIndexCreate("Portfolios2", "IdIndex1", "r2.id", "/Portfolios2 r2", null));
        PRColocatedEquiJoinDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRBasicQuerying: Successfully created the DataStore node in the PR");
        PRColocatedEquiJoinDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRBasicQuerying: Successfully Created PR's across all VM's");
        PRColocatedEquiJoinDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRBasicQuerying: Creating the Colocated DataStore node in the PR");
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForLocalRegionCreation("Portfolios1", Portfolio.class));
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRIndexCreate("Portfolios1", "IdIndex2", "r1.ID", "/Portfolios1 r1", null));
        PRColocatedEquiJoinDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRBasicQuerying: Successfully created the Colocated DataStore node in the PR");
        PRColocatedEquiJoinDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRBasicQuerying: Successfully Created PR's across all VM's");
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForLocalRegionCreation("LocalPortfolios1", Portfolio.class));
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForLocalRegionCreation("LocalPortfolios2", NewPortfolio.class));
        Object[] portfolio = this.PRQHelp.createPortfoliosAndPositions(200);
        Object[] newPortfolio = this.PRQHelp.createNewPortfoliosAndPositions(200);
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPuts("LocalPortfolios1", portfolio, 0, 200));
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPuts("LocalPortfolios2", newPortfolio, 0, 200));
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPuts("Portfolios1", portfolio, 0, 200));
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPuts("Portfolios2", newPortfolio, 0, 200));
        PRColocatedEquiJoinDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRBasicQuerying: Inserted Portfolio data across PR's");
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRColocatedDataSetQueryAndCompareResults("Portfolios1", "Portfolios2", "LocalPortfolios1", "LocalPortfolios2"));
        PRColocatedEquiJoinDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRBasicQuerying: Querying PR's Test ENDED");
    }

    public void testRRPRLocalQueryingWithIndexOnOnePRRegion() throws Exception {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        PRColocatedEquiJoinDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRBasicQuerying: Querying PR Test with DACK Started");
        PRColocatedEquiJoinDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRBasicQuerying: Creating the DataStore node in the PR");
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRCreate("Portfolios2", 1, NewPortfolio.class));
        PRColocatedEquiJoinDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRBasicQuerying: Successfully created the DataStore node in the PR");
        PRColocatedEquiJoinDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRBasicQuerying: Successfully Created PR's across all VM's");
        PRColocatedEquiJoinDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRBasicQuerying: Creating the Colocated DataStore node in the PR");
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForLocalRegionCreation("Portfolios1", Portfolio.class));
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRIndexCreate("Portfolios1", "IdIndex1", "r1.ID", "/Portfolios1 r1", null));
        PRColocatedEquiJoinDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRBasicQuerying: Successfully created the Colocated DataStore node in the PR");
        PRColocatedEquiJoinDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRBasicQuerying: Successfully Created PR's across all VM's");
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForLocalRegionCreation("LocalPortfolios1", Portfolio.class));
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForLocalRegionCreation("LocalPortfolios2", NewPortfolio.class));
        Object[] portfolio = this.PRQHelp.createPortfoliosAndPositions(200);
        Object[] newPortfolio = this.PRQHelp.createNewPortfoliosAndPositions(200);
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPuts("LocalPortfolios1", portfolio, 0, 200));
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPuts("LocalPortfolios2", newPortfolio, 0, 200));
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPuts("Portfolios1", portfolio, 0, 200));
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPuts("Portfolios2", newPortfolio, 0, 200));
        PRColocatedEquiJoinDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRBasicQuerying: Inserted Portfolio data across PR's");
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRColocatedDataSetQueryAndCompareResults("Portfolios1", "Portfolios2", "LocalPortfolios1", "LocalPortfolios2"));
        PRColocatedEquiJoinDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRBasicQuerying: Querying PR's Test ENDED");
    }

    public void testPRNonLocalQueryException() throws Exception {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        PRColocatedEquiJoinDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRBasicQuerying: Querying PR Test with DACK Started");
        PRColocatedEquiJoinDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRBasicQuerying: Creating the DataStore node in the PR");
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRCreate("Portfolios1", 1, Portfolio.class));
        vm1.invoke(this.PRQHelp.getCacheSerializableRunnableForPRCreate("Portfolios1", 1, Portfolio.class));
        PRColocatedEquiJoinDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRBasicQuerying: Successfully created the DataStore node in the PR");
        PRColocatedEquiJoinDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRBasicQuerying: Successfully Created PR's across all VM's");
        PRColocatedEquiJoinDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRBasicQuerying: Creating the Colocated DataStore node in the PR");
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRColocatedCreate("Portfolios2", 1, "Portfolios1"));
        vm1.invoke(this.PRQHelp.getCacheSerializableRunnableForPRColocatedCreate("Portfolios2", 1, "Portfolios1"));
        PRColocatedEquiJoinDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRBasicQuerying: Successfully created the Colocated DataStore node in the PR");
        PRColocatedEquiJoinDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRBasicQuerying: Successfully Created PR's across all VM's");
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForLocalRegionCreation("LocalPortfolios1", Portfolio.class));
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForLocalRegionCreation("LocalPortfolios2", NewPortfolio.class));
        Object[] portfolio = this.PRQHelp.createPortfoliosAndPositions(200);
        Object[] newPortfolio = this.PRQHelp.createNewPortfoliosAndPositions(200);
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPuts("LocalPortfolios1", portfolio, 0, 200));
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPuts("LocalPortfolios2", newPortfolio, 0, 200));
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPuts("Portfolios1", portfolio, 0, 200));
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPuts("Portfolios2", newPortfolio, 0, 200));
        PRColocatedEquiJoinDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRBasicQuerying: Inserted Portfolio data across PR's");
        vm0.invoke(new CacheSerializableRunnable("PRQuery"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run2() throws CacheException {
                Cache cache = PRColocatedEquiJoinDUnitTest.this.getCache();
                String[] queries = new String[]{"r1.ID = r2.id"};
                Object[][] r = new Object[queries.length][2];
                Region region = null;
                region = cache.getRegion("Portfolios1");
                TestCase.assertNotNull((Object)region);
                region = cache.getRegion("Portfolios2");
                TestCase.assertNotNull((Object)region);
                region = cache.getRegion("LocalPortfolios1");
                TestCase.assertNotNull((Object)region);
                region = cache.getRegion("LocalPortfolios2");
                TestCase.assertNotNull((Object)region);
                String[] expectedExceptions = new String[]{RegionDestroyedException.class.getName(), ReplyException.class.getName(), CacheClosedException.class.getName(), ForceReattemptException.class.getName(), QueryInvocationTargetException.class.getName()};
                for (int i = 0; i < expectedExceptions.length; ++i) {
                    PRColocatedEquiJoinDUnitTest.this.getCache().getLogger().info("<ExpectedException action=add>" + expectedExceptions[i] + "</ExpectedException>");
                }
                QueryService qs = PRColocatedEquiJoinDUnitTest.this.getCache().getQueryService();
                try {
                    for (int j = 0; j < queries.length; ++j) {
                        PRColocatedEquiJoinDUnitTest.this.getCache().getLogger().info("About to execute local query: " + queries[j]);
                        r[j][1] = qs.newQuery("Select " + (queries[j].contains("ORDER BY") ? "DISTINCT" : "") + " * from /" + "Portfolios1" + " r1, /" + "Portfolios2" + " r2 where " + queries[j]).execute();
                    }
                    TestCase.fail((String)"PRQueryDUnitHelper#getCacheSerializableRunnableForPRQueryAndCompareResults: Queries Executed successfully on Local region & PR Region");
                }
                catch (QueryInvocationTargetException e) {
                    throw new TestException("PRQueryDUnitHelper#getCacheSerializableRunnableForPRQueryAndCompareResults: Caught unexpected query exception", e);
                }
                catch (QueryException e) {
                    DistributedTestCase.getLogWriter().error("PRQueryDUnitHelper#getCacheSerializableRunnableForPRQueryAndCompareResults: Caught QueryException while querying" + (Object)((Object)e), (Throwable)e);
                    throw new TestException("PRQueryDUnitHelper#getCacheSerializableRunnableForPRQueryAndCompareResults: Caught unexpected query exception", e);
                }
                catch (UnsupportedOperationException uso) {
                    DistributedTestCase.getLogWriter().info(uso.getMessage());
                    if (!uso.getMessage().equalsIgnoreCase(LocalizedStrings.DefaultQuery_A_QUERY_ON_A_PARTITIONED_REGION_0_MAY_NOT_REFERENCE_ANY_OTHER_REGION_1.toLocalizedString(new Object[]{"Portfolios1", "/Portfolios2"}))) {
                        TestCase.fail((String)"Query did not throw UnsupportedOperationException while using QueryService instead of LocalQueryService");
                    }
                    DistributedTestCase.getLogWriter().info("Query received UnsupportedOperationException successfully while using QueryService.");
                }
                finally {
                    for (int i = 0; i < expectedExceptions.length; ++i) {
                        PRColocatedEquiJoinDUnitTest.this.getCache().getLogger().info("<ExpectedException action=remove>" + expectedExceptions[i] + "</ExpectedException>");
                    }
                }
            }
        });
        PRColocatedEquiJoinDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRBasicQuerying: Querying PR's Test ENDED");
    }

    public void testPRRRLocalQueryingWithHetroIndexes() throws Exception {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        PRColocatedEquiJoinDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRBasicQuerying: Querying PR Test with DACK Started");
        PRColocatedEquiJoinDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRBasicQuerying: Creating the DataStore node in the PR");
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRCreate("Portfolios1", 1, Portfolio.class));
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRIndexCreate("Portfolios1", "IdIndex1", "r1.ID", "/Portfolios1 r1", null));
        PRColocatedEquiJoinDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRBasicQuerying: Successfully created the DataStore node in the PR");
        PRColocatedEquiJoinDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRBasicQuerying: Successfully Created PR's across all VM's");
        PRColocatedEquiJoinDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRBasicQuerying: Creating the Colocated DataStore node in the PR");
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForLocalRegionCreation("Portfolios2", NewPortfolio.class));
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRIndexCreate("Portfolios2", "IdIndex2", "r2.id", "/Portfolios2 r2, r2.positions.values pos2", null));
        PRColocatedEquiJoinDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRBasicQuerying: Successfully created the Colocated DataStore node in the PR");
        PRColocatedEquiJoinDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRBasicQuerying: Successfully Created PR's across all VM's");
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForLocalRegionCreation("LocalPortfolios1", Portfolio.class));
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForLocalRegionCreation("LocalPortfolios2", NewPortfolio.class));
        Object[] portfolio = this.PRQHelp.createPortfoliosAndPositions(200);
        Object[] newPortfolio = this.PRQHelp.createNewPortfoliosAndPositions(200);
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPuts("LocalPortfolios1", portfolio, 0, 200));
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPuts("LocalPortfolios2", newPortfolio, 0, 200));
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPuts("Portfolios1", portfolio, 0, 200));
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPuts("Portfolios2", newPortfolio, 0, 200));
        PRColocatedEquiJoinDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRBasicQuerying: Inserted Portfolio data across PR's");
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRAndRRQueryAndCompareResults("Portfolios1", "Portfolios2", "LocalPortfolios1", "LocalPortfolios2"));
        PRColocatedEquiJoinDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRBasicQuerying: Querying PR's Test ENDED");
    }

    public void testRRPRLocalQueryingWithHetroIndexes() throws Exception {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        PRColocatedEquiJoinDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRBasicQuerying: Querying PR Test with DACK Started");
        PRColocatedEquiJoinDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRBasicQuerying: Creating the DataStore node in the PR");
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRCreate("Portfolios2", 1, NewPortfolio.class));
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRIndexCreate("Portfolios2", "IdIndex1", "r2.id", "/Portfolios2 r2", null));
        PRColocatedEquiJoinDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRBasicQuerying: Successfully created the DataStore node in the PR");
        PRColocatedEquiJoinDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRBasicQuerying: Successfully Created PR's across all VM's");
        PRColocatedEquiJoinDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRBasicQuerying: Creating the Colocated DataStore node in the PR");
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForLocalRegionCreation("Portfolios1", Portfolio.class));
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRIndexCreate("Portfolios1", "IdIndex2", "r1.ID", "/Portfolios1 r1, r1.positions.values pos1", null));
        PRColocatedEquiJoinDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRBasicQuerying: Successfully created the Colocated DataStore node in the PR");
        PRColocatedEquiJoinDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRBasicQuerying: Successfully Created PR's across all VM's");
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForLocalRegionCreation("LocalPortfolios1", Portfolio.class));
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForLocalRegionCreation("LocalPortfolios2", NewPortfolio.class));
        Object[] portfolio = this.PRQHelp.createPortfoliosAndPositions(200);
        Object[] newPortfolio = this.PRQHelp.createNewPortfoliosAndPositions(200);
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPuts("LocalPortfolios1", portfolio, 0, 200));
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPuts("LocalPortfolios2", newPortfolio, 0, 200));
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPuts("Portfolios1", portfolio, 0, 200));
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPuts("Portfolios2", newPortfolio, 0, 200));
        PRColocatedEquiJoinDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRBasicQuerying: Inserted Portfolio data across PR's");
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForRRAndPRQueryAndCompareResults("Portfolios1", "Portfolios2", "LocalPortfolios1", "LocalPortfolios2"));
        PRColocatedEquiJoinDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRBasicQuerying: Querying PR's Test ENDED");
    }

    public void testPRRRCompactRangeAndNestedRangeIndexQuerying() throws Exception {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        PRColocatedEquiJoinDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRBasicQuerying: Querying PR Test with DACK Started");
        PRColocatedEquiJoinDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRBasicQuerying: Creating the DataStore node in the PR");
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRCreate("Portfolios1", 1, Portfolio.class));
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRIndexCreate("Portfolios1", "IdIndex1", "r1.ID", "/Portfolios1 r1", null));
        PRColocatedEquiJoinDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRBasicQuerying: Successfully created the DataStore node in the PR");
        PRColocatedEquiJoinDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRBasicQuerying: Successfully Created PR's across all VM's");
        PRColocatedEquiJoinDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRBasicQuerying: Creating the Colocated DataStore node in the PR");
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForLocalRegionCreation("Portfolios2", Portfolio.class));
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRIndexCreate("Portfolios2", "IdIndex2", "pos2.id", "/Portfolios2 r2, r2.positions.values pos2", null));
        PRColocatedEquiJoinDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRBasicQuerying: Successfully created the Colocated DataStore node in the PR");
        PRColocatedEquiJoinDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRBasicQuerying: Successfully Created PR's across all VM's");
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForLocalRegionCreation("LocalPortfolios1", Portfolio.class));
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForLocalRegionCreation("LocalPortfolios2", Portfolio.class));
        Object[] portfolio = this.PRQHelp.createPortfoliosAndPositions(200);
        Object[] newPortfolio = this.PRQHelp.createPortfoliosAndPositions(200);
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPuts("LocalPortfolios1", portfolio, 0, 200));
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPuts("LocalPortfolios2", newPortfolio, 0, 200));
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPuts("Portfolios1", portfolio, 0, 200));
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPuts("Portfolios2", newPortfolio, 0, 200));
        PRColocatedEquiJoinDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRBasicQuerying: Inserted Portfolio data across PR's");
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRAndRRQueryWithCompactAndRangeIndexAndCompareResults("Portfolios1", "Portfolios2", "LocalPortfolios1", "LocalPortfolios2"));
        PRColocatedEquiJoinDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRBasicQuerying: Querying PR's Test ENDED");
    }

    public void testPRRRIndexQueryWithSameTypeIndexQueryResults() throws Exception {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        PRColocatedEquiJoinDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRBasicQuerying: Querying PR Test with DACK Started");
        PRColocatedEquiJoinDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRBasicQuerying: Creating the DataStore node in the PR");
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRCreate("Portfolios1", 1, Portfolio.class));
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRIndexCreate("Portfolios1", "IdIndex1", "r1.ID", "/Portfolios1 r1", null));
        PRColocatedEquiJoinDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRBasicQuerying: Successfully created the DataStore node in the PR");
        PRColocatedEquiJoinDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRBasicQuerying: Successfully Created PR's across all VM's");
        PRColocatedEquiJoinDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRBasicQuerying: Creating the Colocated DataStore node in the PR");
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForLocalRegionWithAsyncIndexCreation("Portfolios2", NewPortfolio.class));
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRIndexCreate("Portfolios2", "IdIndex2", "r2.id", "/Portfolios2 r2", null));
        PRColocatedEquiJoinDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRBasicQuerying: Successfully created the Colocated DataStore node in the PR");
        PRColocatedEquiJoinDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRBasicQuerying: Successfully Created PR's across all VM's");
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForLocalRegionCreation("LocalPortfolios1", Portfolio.class));
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRIndexCreate("Portfolios1", "IdIndex3", "r1.ID", "/LocalPortfolios1 r1", null));
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForLocalRegionCreation("LocalPortfolios2", NewPortfolio.class));
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRIndexCreate("Portfolios2", "IdIndex4", "r2.id", "/LocalPortfolios2 r2", null));
        Object[] portfolio = this.PRQHelp.createPortfoliosAndPositions(200);
        Object[] newPortfolio = this.PRQHelp.createNewPortfoliosAndPositions(200);
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPuts("LocalPortfolios1", portfolio, 0, 200));
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPuts("LocalPortfolios2", newPortfolio, 0, 200));
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPuts("Portfolios1", portfolio, 0, 200));
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPuts("Portfolios2", newPortfolio, 0, 200));
        PRColocatedEquiJoinDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRBasicQuerying: Inserted Portfolio data across PR's");
        PRColocatedEquiJoinDUnitTest.pause(5000);
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRAndRRQueryAndCompareResults("Portfolios1", "Portfolios2", "LocalPortfolios1", "LocalPortfolios2"));
        PRColocatedEquiJoinDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRBasicQuerying: Querying PR's Test ENDED");
    }

    public void testPRRRNonLocalQueryingWithNoRROnOneNode() throws Exception {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        PRColocatedEquiJoinDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRBasicQuerying: Querying PR Test with DACK Started");
        PRColocatedEquiJoinDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRBasicQuerying: Creating the DataStore node in the PR");
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRCreate("Portfolios1", 0, Portfolio.class));
        vm1.invoke(this.PRQHelp.getCacheSerializableRunnableForPRCreate("Portfolios1", 0, Portfolio.class));
        PRColocatedEquiJoinDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRBasicQuerying: Successfully created the DataStore node in the PR");
        PRColocatedEquiJoinDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRBasicQuerying: Successfully Created PR's across all VM's");
        PRColocatedEquiJoinDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRBasicQuerying: Creating the Colocated DataStore node in the RR");
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForLocalRegionCreation("Portfolios2", NewPortfolio.class));
        PRColocatedEquiJoinDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRBasicQuerying: Successfully Created PR's across all VM's");
        Object[] portfolio = this.PRQHelp.createPortfoliosAndPositions(200);
        Object[] newPortfolio = this.PRQHelp.createNewPortfoliosAndPositions(200);
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPuts("Portfolios1", portfolio, 0, 200));
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPuts("Portfolios2", newPortfolio, 0, 200));
        PRColocatedEquiJoinDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRBasicQuerying: Inserted Portfolio data across PR's");
        vm0.invoke(new CacheSerializableRunnable("PRQuery"){

            @Override
            public void run2() throws CacheException {
                Cache cache = PRColocatedEquiJoinDUnitTest.this.getCache();
                String[] queries = new String[]{"r1.ID = r2.id"};
                Object[][] r = new Object[queries.length][2];
                Region region = null;
                region = cache.getRegion("Portfolios1");
                TestCase.assertNotNull((Object)region);
                region = cache.getRegion("Portfolios2");
                TestCase.assertNotNull((Object)region);
                QueryService qs = PRColocatedEquiJoinDUnitTest.this.getCache().getQueryService();
                try {
                    for (int j = 0; j < queries.length; ++j) {
                        PRColocatedEquiJoinDUnitTest.this.getCache().getLogger().info("About to execute local query: " + queries[j]);
                        final class TestQueryFunction
                        extends FunctionAdapter {
                            private final String id;

                            public boolean hasResult() {
                                return true;
                            }

                            public boolean isHA() {
                                return false;
                            }

                            public TestQueryFunction(String id) {
                                this.id = id;
                            }

                            public void execute(FunctionContext context) {
                                Cache cache = CacheFactory.getAnyInstance();
                                QueryService queryService = cache.getQueryService();
                                ArrayList allQueryResults = new ArrayList();
                                String qstr = (String)context.getArguments();
                                try {
                                    Query query = queryService.newQuery(qstr);
                                    context.getResultSender().sendResult((Object)((ArrayList)((SelectResults)query.execute((RegionFunctionContext)context)).asList()));
                                    context.getResultSender().lastResult(null);
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                    throw new FunctionException((Throwable)e);
                                }
                            }

                            public String getId() {
                                return this.id;
                            }
                        }
                        TestQueryFunction func = new TestQueryFunction("testfunction");
                        Object funcResult = FunctionService.onRegion((Region)(PRColocatedEquiJoinDUnitTest.this.getCache().getRegion("Portfolios1") instanceof PartitionedRegion ? PRColocatedEquiJoinDUnitTest.this.getCache().getRegion("Portfolios1") : PRColocatedEquiJoinDUnitTest.this.getCache().getRegion("Portfolios2"))).withArgs((Object)("Select " + (queries[j].contains("ORDER BY") ? "DISTINCT" : "") + " * from /" + "Portfolios1" + " r1, /" + "Portfolios2" + " r2 where " + queries[j])).execute((Function)func).getResult();
                        r[j][0] = ((ArrayList)funcResult).get(0);
                    }
                    TestCase.fail((String)"PRQueryDUnitHelper#getCacheSerializableRunnableForPRQueryAndCompareResults: Queries Executed successfully without RR region on one of the nodes");
                }
                catch (FunctionException e) {
                    if (e.getCause() instanceof RegionNotFoundException) {
                        DistributedTestCase.getLogWriter().info("Query received FunctionException successfully while using QueryService.");
                    }
                    TestCase.fail((String)"RegionNotFoundException must be thrown here");
                }
            }
        });
        PRColocatedEquiJoinDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRBasicQuerying: Querying PR's Test ENDED");
    }
}

