/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.query.partitioned;

import com.gemstone.gemfire.cache.query.partitioned.PRQueryDUnitHelper;
import com.gemstone.gemfire.internal.cache.ForceReattemptException;
import com.gemstone.gemfire.internal.cache.PartitionedRegionDUnitTestCase;
import dunit.AsyncInvocation;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.VM;
import java.util.LinkedList;
import java.util.Properties;
import java.util.Random;

public class PRQueryRegionCloseDUnitTest
extends PartitionedRegionDUnitTestCase {
    static Properties props = new Properties();
    int totalNumBuckets = 100;
    int threadSleepTime = 500;
    int querySleepTime = 2000;
    int queryTestCycle = 10;
    PRQueryDUnitHelper PRQHelp = new PRQueryDUnitHelper("");
    final String name = "Portfolios";
    final String localName = "LocalPortfolios";
    final int cnt = 0;
    final int cntDest = 50;
    final int redundancy = 1;

    public PRQueryRegionCloseDUnitTest(String name) {
        super(name);
    }

    public void testPRWithRegionCloseInOneDatastoreWithoutDelay() throws Exception {
        PRQueryRegionCloseDUnitTest.getLogWriter().info("PRQueryRegionCloseDUnitTest#testPRWithRegionCloseInOneDatastoreWithoutDelay: Querying PR Test with region Close PR operation*****");
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        LinkedList<VM> vmList = new LinkedList<VM>();
        vmList.add(vm1);
        vmList.add(vm2);
        PRQueryRegionCloseDUnitTest.getLogWriter().info("PRQueryRegionCloseDUnitTest#testPRWithRegionCloseInOneDatastoreWithoutDelay: Creating Accessor node on VM0");
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRAccessorCreate("Portfolios", 1));
        PRQueryRegionCloseDUnitTest.getLogWriter().info("PRQueryRegionCloseDUnitTest#testPRWithRegionCloseInOneDatastoreWithoutDelay: Successfully Created Accessor node on VM0");
        PRQueryRegionCloseDUnitTest.getLogWriter().info("PRQueryRegionCloseDUnitTest#testPRWithRegionCloseInOneDatastoreWithoutDelay: Creating PR's across all VM1 , VM2");
        vm1.invoke(this.PRQHelp.getCacheSerializableRunnableForPRCreate("Portfolios", 1));
        vm2.invoke(this.PRQHelp.getCacheSerializableRunnableForPRCreate("Portfolios", 1));
        PRQueryRegionCloseDUnitTest.getLogWriter().info("PRQueryRegionCloseDUnitTest#testPRWithRegionCloseInOneDatastoreWithoutDelay: Successfully Created PR on VM1 , VM2");
        PRQueryRegionCloseDUnitTest.getLogWriter().info("PRQueryRegionCloseDUnitTest#testPRWithRegionCloseInOneDatastoreWithoutDelay: Creating Local Region on VM0");
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForLocalRegionCreation("LocalPortfolios"));
        PRQueryRegionCloseDUnitTest.getLogWriter().info("PRQueryRegionCloseDUnitTest#testPRWithRegionCloseInOneDatastoreWithoutDelay: Successfully Created Local Region on VM0");
        Object[] portfolio = this.PRQHelp.createPortfolioData(0, 50);
        PRQueryRegionCloseDUnitTest.getLogWriter().info("PRQueryRegionCloseDUnitTest#testPRWithRegionCloseInOneDatastoreWithoutDelay: Inserting Portfolio data through the accessor node");
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPuts("Portfolios", portfolio, 0, 50));
        PRQueryRegionCloseDUnitTest.getLogWriter().info("PRQueryRegionCloseDUnitTest#testPRWithRegionCloseInOneDatastoreWithoutDelay: Successfully Inserted Portfolio data through the accessor node");
        PRQueryRegionCloseDUnitTest.getLogWriter().info("PRQueryRegionCloseDUnitTest#testPRWithRegionCloseInOneDatastoreWithoutDelay: Inserting Portfolio data on local node  VM0 for result Set Comparison");
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPuts("LocalPortfolios", portfolio, 0, 50));
        PRQueryRegionCloseDUnitTest.getLogWriter().info("PRQueryRegionCloseDUnitTest#testPRWithRegionCloseInOneDatastoreWithoutDelay: Successfully Inserted Portfolio data on local node  VM0 for result Set Comparison");
        Random random = new Random();
        PRQueryRegionCloseDUnitTest.getLogWriter().info("PRQueryRegionCloseDUnitTest#testPRWithRegionCloseInOneDatastoreWithoutDelay: Querying on VM0 both on PR Region & local ,also  Comparing the Results sets from both");
        AsyncInvocation async0 = vm0.invokeAsync(this.PRQHelp.getCacheSerializableRunnableForPRQueryAndCompareResults("Portfolios", "LocalPortfolios"));
        PRQueryRegionCloseDUnitTest.getLogWriter().info("PRQueryRegionCloseDUnitTest#testPRWithRegionCloseInOneDatastoreWithoutDelay: Calling for Region.close() on either of the Datastores VM1 , VM2 at random and then recreating the cache, with a predefined Delay ");
        for (int j = 0; j < this.queryTestCycle; ++j) {
            int k = random.nextInt(vmList.size());
            if (0 == k) continue;
            ((VM)vmList.get(k)).invoke(this.PRQHelp.getCacheSerializableRunnableForRegionClose("Portfolios", 1));
            PRQueryRegionCloseDUnitTest.pause(this.threadSleepTime);
        }
        DistributedTestCase.join(async0, 30000L, PRQueryRegionCloseDUnitTest.getLogWriter());
        if (async0.exceptionOccurred()) {
            boolean isForceReattempt = false;
            Throwable t = async0.getException();
            do {
                if (!(t instanceof ForceReattemptException)) continue;
                isForceReattempt = true;
                break;
            } while ((t = t.getCause()) != null);
            if (!isForceReattempt) {
                PRQueryRegionCloseDUnitTest.fail("Unexpected exception during query", async0.getException());
            }
        }
        PRQueryRegionCloseDUnitTest.getLogWriter().info("PRQueryRegionCloseDUnitTest#testPRWithRegionCloseInOneDatastoreWithoutDelay: Querying with PR Operations ENDED*****");
    }
}

