/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.snapshot;

import com.examples.snapshot.MyObject;
import com.examples.snapshot.MyPdxSerializer;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.CacheWriter;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.EvictionAttributes;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionShortcut;
import com.gemstone.gemfire.cache.client.ClientCache;
import com.gemstone.gemfire.cache.client.ClientCacheFactory;
import com.gemstone.gemfire.cache.client.ClientRegionShortcut;
import com.gemstone.gemfire.cache.query.CqAttributesFactory;
import com.gemstone.gemfire.cache.query.CqEvent;
import com.gemstone.gemfire.cache.query.CqListener;
import com.gemstone.gemfire.cache.query.CqQuery;
import com.gemstone.gemfire.cache.server.CacheServer;
import com.gemstone.gemfire.cache.snapshot.SnapshotIterator;
import com.gemstone.gemfire.cache.snapshot.SnapshotOptions;
import com.gemstone.gemfire.cache.snapshot.SnapshotReader;
import com.gemstone.gemfire.cache.util.CacheListenerAdapter;
import com.gemstone.gemfire.cache.util.CacheWriterAdapter;
import com.gemstone.gemfire.cache.util.CqListenerAdapter;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.internal.AvailablePortHelper;
import com.gemstone.gemfire.pdx.PdxSerializer;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableCallable;
import java.io.File;
import java.util.concurrent.atomic.AtomicBoolean;
import junit.framework.TestCase;

public class ClientSnapshotDUnitTest
extends CacheTestCase {
    private transient Region<Integer, MyObject> region;

    public ClientSnapshotDUnitTest(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testExport() throws Exception {
        int count = 10000;
        for (int i = 0; i < count; ++i) {
            this.region.put((Object)i, (Object)new MyObject((long)i, "clienttest " + i));
        }
        SerializableCallable export = new SerializableCallable(){

            public Object call() throws Exception {
                File f = new File(CacheTestCase.getDiskDirs()[0], "client-export.snapshot");
                Region r = ClientSnapshotDUnitTest.this.getCache().getRegion("clienttest");
                r.getSnapshotService().save(f, SnapshotOptions.SnapshotFormat.GEMFIRE);
                return f;
            }
        };
        File snapshot = (File)Host.getHost(0).getVM(3).invoke(export);
        try (SnapshotIterator iter = SnapshotReader.read((File)snapshot);){
            while (iter.hasNext()) {
                iter.next();
                --count;
            }
            ClientSnapshotDUnitTest.assertEquals((int)0, (int)count);
        }
    }

    public void testImport() throws Exception {
        int count = 1000;
        for (int i = 0; i < count; ++i) {
            this.region.put((Object)i, (Object)new MyObject((long)i, "clienttest " + i));
        }
        SerializableCallable export = new SerializableCallable(){

            public Object call() throws Exception {
                File f = new File(CacheTestCase.getDiskDirs()[0], "client-import.snapshot");
                Region r = ClientSnapshotDUnitTest.this.getCache().getRegion("clienttest");
                r.getSnapshotService().save(f, SnapshotOptions.SnapshotFormat.GEMFIRE);
                return f;
            }
        };
        Host.getHost(0).getVM(3).invoke(export);
        for (int i = 0; i < count; ++i) {
            this.region.put((Object)i, (Object)new MyObject((long)i, "XXX"));
        }
        SerializableCallable imp = new SerializableCallable(){

            public Object call() throws Exception {
                final AtomicBoolean cqtest = new AtomicBoolean(false);
                CqAttributesFactory af = new CqAttributesFactory();
                af.addCqListener((CqListener)new CqListenerAdapter(){

                    public void onEvent(CqEvent aCqEvent) {
                        cqtest.set(true);
                    }
                });
                Region r = ClientSnapshotDUnitTest.this.getCache().getRegion("clienttest");
                CqQuery cq = r.getRegionService().getQueryService().newCq("SELECT * FROM /clienttest", af.create());
                cq.execute();
                File f = new File(CacheTestCase.getDiskDirs()[0], "client-import.snapshot");
                r.getSnapshotService().load(f, SnapshotOptions.SnapshotFormat.GEMFIRE);
                return cqtest.get();
            }
        };
        this.region.getAttributesMutator().setCacheWriter((CacheWriter)new CacheWriterAdapter<Integer, MyObject>(){

            public void beforeUpdate(EntryEvent<Integer, MyObject> event) {
                TestCase.fail((String)"CacheWriter invoked during import");
            }
        });
        final AtomicBoolean cltest = new AtomicBoolean(false);
        this.region.getAttributesMutator().addCacheListener((CacheListener)new CacheListenerAdapter<Integer, MyObject>(){

            public void afterUpdate(EntryEvent<Integer, MyObject> event) {
                cltest.set(true);
            }
        });
        boolean cqtest = (Boolean)Host.getHost(0).getVM(3).invoke(imp);
        ClientSnapshotDUnitTest.assertEquals((String)"CacheListener invoked during import", (boolean)false, (boolean)cltest.get());
        ClientSnapshotDUnitTest.assertEquals((String)"CqListener invoked during import", (boolean)false, (boolean)cqtest);
        for (MyObject obj : this.region.values()) {
            ClientSnapshotDUnitTest.assertTrue((boolean)obj.getF2().startsWith("clienttest"));
        }
    }

    public void testClientCallbacks() throws Exception {
        int count = 1000;
        for (int i = 0; i < count; ++i) {
            this.region.put((Object)i, (Object)new MyObject((long)i, "clienttest " + i));
        }
        File f = new File(ClientSnapshotDUnitTest.getDiskDirs()[0], "client-callback.snapshot");
        this.region.getSnapshotService().save(f, SnapshotOptions.SnapshotFormat.GEMFIRE);
        for (int i = 0; i < count; ++i) {
            this.region.put((Object)i, (Object)new MyObject((long)i, "XXX"));
        }
        SerializableCallable callbacks = new SerializableCallable(){

            public Object call() throws Exception {
                Region r = ClientSnapshotDUnitTest.this.getCache().getRegion("clienttest");
                r.registerInterestRegex(".*");
                r.getAttributesMutator().setCacheWriter((CacheWriter)new CacheWriterAdapter<Integer, MyObject>(){

                    public void beforeUpdate(EntryEvent<Integer, MyObject> event) {
                        TestCase.fail((String)"CacheWriter invoked during import");
                    }
                });
                r.getAttributesMutator().addCacheListener((CacheListener)new CacheListenerAdapter<Integer, MyObject>(){

                    public void afterUpdate(EntryEvent<Integer, MyObject> event) {
                        TestCase.fail((String)"CacheListener was invoked during import");
                    }
                });
                AtomicBoolean cqtest = new AtomicBoolean(false);
                CqAttributesFactory af = new CqAttributesFactory();
                af.addCqListener((CqListener)new CqListenerAdapter(){

                    public void onEvent(CqEvent aCqEvent) {
                        TestCase.fail((String)"Cq was invoked during import");
                    }
                });
                CqQuery cq = r.getRegionService().getQueryService().newCq("SELECT * FROM /clienttest", af.create());
                cq.execute();
                return null;
            }
        };
        Host.getHost(0).getVM(3).invoke(callbacks);
        this.region.getSnapshotService().load(f, SnapshotOptions.SnapshotFormat.GEMFIRE);
    }

    public void testInvalidate() throws Exception {
        SerializableCallable invalid = new SerializableCallable(){

            public Object call() throws Exception {
                Region r = ClientSnapshotDUnitTest.this.getCache().getRegion("clienttest");
                r.put((Object)1, (Object)new MyObject(1L, "invalidate"));
                r.invalidate((Object)1);
                File f = new File(CacheTestCase.getDiskDirs()[0], "client-invalidate.snapshot");
                r.getSnapshotService().save(f, SnapshotOptions.SnapshotFormat.GEMFIRE);
                r.getSnapshotService().load(f, SnapshotOptions.SnapshotFormat.GEMFIRE);
                return null;
            }
        };
        Host.getHost(0).getVM(3).invoke(invalid);
        ClientSnapshotDUnitTest.assertTrue((boolean)this.region.containsKey((Object)1));
        ClientSnapshotDUnitTest.assertFalse((boolean)this.region.containsValueForKey((Object)1));
        ClientSnapshotDUnitTest.assertNull((Object)this.region.get((Object)1));
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.loadCache();
    }

    public void loadCache() throws Exception {
        CacheFactory cf = new CacheFactory().setPdxSerializer((PdxSerializer)new MyPdxSerializer());
        Cache cache = this.getCache(cf);
        CacheServer server = cache.addCacheServer();
        final int port = AvailablePortHelper.getRandomAvailableTCPPort();
        server.setPort(port);
        server.start();
        this.region = cache.createRegionFactory(RegionShortcut.REPLICATE).create("clienttest");
        final Host host = Host.getHost(0);
        SerializableCallable client = new SerializableCallable(){

            public Object call() throws Exception {
                ClientCacheFactory cf = new ClientCacheFactory().set("log-level", DistributedTestCase.getDUnitLogLevel()).setPdxSerializer((PdxSerializer)new MyPdxSerializer()).addPoolServer(DistributedTestCase.getServerHostName(host), port).setPoolSubscriptionEnabled(true).setPoolPRSingleHopEnabled(false);
                ClientCache cache = ClientSnapshotDUnitTest.this.getClientCache(cf);
                Region r = cache.createClientRegionFactory(ClientRegionShortcut.CACHING_PROXY_HEAP_LRU).setEvictionAttributes(EvictionAttributes.createLRUEntryAttributes((int)5)).create("clienttest");
                return null;
            }
        };
        SerializableCallable remote = new SerializableCallable(){

            public Object call() throws Exception {
                CacheFactory cf = new CacheFactory().setPdxSerializer((PdxSerializer)new MyPdxSerializer());
                Cache cache = ClientSnapshotDUnitTest.this.getCache(cf);
                cache.createRegionFactory(RegionShortcut.REPLICATE).create("clienttest");
                return null;
            }
        };
        host.getVM(3).invoke(client);
        host.getVM(2).invoke(remote);
    }
}

