/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.snapshot;

import com.examples.snapshot.MyPdxSerializer;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.snapshot.RegionGenerator;
import com.gemstone.gemfire.cache.snapshot.RegionSnapshotService;
import com.gemstone.gemfire.cache.snapshot.SnapshotOptions;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.internal.cache.snapshot.SnapshotFileMapper;
import com.gemstone.gemfire.internal.cache.snapshot.SnapshotOptionsImpl;
import com.gemstone.gemfire.pdx.PdxSerializer;
import dunit.Host;
import dunit.SerializableCallable;
import dunit.VM;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Arrays;
import junit.framework.TestCase;

public class ParallelSnapshotDUnitTest
extends CacheTestCase {
    static byte[] ffff = new byte[]{15, 15, 15, 15};
    static byte[] eeee = new byte[]{14, 14, 14, 14};

    public ParallelSnapshotDUnitTest(String name) {
        super(name);
    }

    public void testExportImport() throws Exception {
        this.doExport(false);
        this.doImport(false);
    }

    public void testExportImportErrors() throws Exception {
        try {
            this.doExport(true);
            ParallelSnapshotDUnitTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.doExport(false);
        try {
            this.doImport(true);
            ParallelSnapshotDUnitTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void doExport(boolean explode) throws Exception {
        Region region = this.getCache().getRegion("test");
        for (int i = 0; i < 1000; ++i) {
            region.put((Object)i, (Object)ffff);
        }
        RegionSnapshotService rss = region.getSnapshotService();
        final TestSnapshotFileMapper mapper = new TestSnapshotFileMapper();
        mapper.explode = explode;
        SnapshotOptionsImpl opt = (SnapshotOptionsImpl)rss.createOptions();
        opt.setParallelMode(true);
        opt.setMapper((SnapshotFileMapper)mapper);
        final File f = new File("mysnap");
        rss.save(f, SnapshotOptions.SnapshotFormat.GEMFIRE, (SnapshotOptions)opt);
        mapper.explode = false;
        SerializableCallable check = new SerializableCallable(){

            public Object call() throws Exception {
                ParallelSnapshotDUnitTest.this.getCache().getDistributedSystem().getDistributedMember();
                File snap = mapper.mapExportPath(ParallelSnapshotDUnitTest.this.getCache().getDistributedSystem().getDistributedMember(), f);
                TestCase.assertTrue((String)("Could not find snapshot: " + snap), (boolean)snap.exists());
                return null;
            }
        };
        this.forEachVm(check, true);
    }

    private void doImport(boolean explode) throws ClassNotFoundException, IOException {
        int i;
        Region region = this.getCache().getRegion("test");
        RegionSnapshotService rss = region.getSnapshotService();
        TestSnapshotFileMapper mapper = new TestSnapshotFileMapper();
        mapper.explode = explode;
        SnapshotOptionsImpl opt = (SnapshotOptionsImpl)rss.createOptions();
        opt.setParallelMode(true);
        opt.setMapper((SnapshotFileMapper)mapper);
        File f = new File("mysnap");
        for (i = 0; i < 1000; ++i) {
            region.put((Object)i, (Object)eeee);
        }
        rss.load(f, SnapshotOptions.SnapshotFormat.GEMFIRE, (SnapshotOptions)opt);
        for (i = 0; i < 1000; ++i) {
            ParallelSnapshotDUnitTest.assertTrue((boolean)Arrays.equals(ffff, (byte[])region.get((Object)i)));
        }
    }

    public Object forEachVm(SerializableCallable call, boolean local) throws Exception {
        Host host = Host.getHost(0);
        int vms = host.getVMCount();
        for (int i = 0; i < vms; ++i) {
            host.getVM(i).invoke(call);
        }
        if (local) {
            return call.call();
        }
        return null;
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.loadCache();
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
        File[] snaps = new File(".").listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith("mysnap");
            }
        });
        if (snaps != null) {
            for (File f : snaps) {
                f.delete();
            }
        }
    }

    public void loadCache() throws Exception {
        SerializableCallable setup = new SerializableCallable(){

            public Object call() throws Exception {
                CacheFactory cf = new CacheFactory().setPdxSerializer((PdxSerializer)new MyPdxSerializer());
                Cache cache = ParallelSnapshotDUnitTest.this.getCache(cf);
                RegionGenerator rgen = new RegionGenerator();
                rgen.createRegion(cache, null, RegionGenerator.RegionType.PARTITION, "test");
                return null;
            }
        };
        this.forEachVm(setup, true);
    }

    private static class TestSnapshotFileMapper
    implements SnapshotFileMapper {
        volatile boolean explode;

        private TestSnapshotFileMapper() {
        }

        public File mapExportPath(DistributedMember member, File snapshot) {
            if (this.explode) {
                throw new RuntimeException();
            }
            return new File(snapshot.getAbsoluteFile().toString() + VM.getCurrentVMNum());
        }

        public File[] mapImportPath(DistributedMember member, File snapshot) {
            if (this.explode) {
                throw new RuntimeException();
            }
            File f = new File(snapshot.getAbsoluteFile().toString() + VM.getCurrentVMNum());
            return new File[]{f};
        }
    }
}

