/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.snapshot;

import com.examples.snapshot.MyObject;
import com.examples.snapshot.MyPdxSerializer;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.CacheWriter;
import com.gemstone.gemfire.cache.DiskStore;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.snapshot.CacheSnapshotService;
import com.gemstone.gemfire.cache.snapshot.RegionGenerator;
import com.gemstone.gemfire.cache.snapshot.SnapshotFilter;
import com.gemstone.gemfire.cache.snapshot.SnapshotOptions;
import com.gemstone.gemfire.cache.util.CacheListenerAdapter;
import com.gemstone.gemfire.cache.util.CacheWriterAdapter;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.pdx.PdxSerializer;
import dunit.Host;
import dunit.SerializableCallable;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import junit.framework.TestCase;

public class SnapshotDUnitTest
extends CacheTestCase {
    public SnapshotDUnitTest(String name) {
        super(name);
    }

    public void testExportAndImport() throws Exception {
        File dir = new File(SnapshotDUnitTest.getDiskDirs()[0], "snap");
        dir.mkdir();
        this.getCache().getSnapshotService().save(dir, SnapshotOptions.SnapshotFormat.GEMFIRE);
        for (RegionGenerator.RegionType rt : RegionGenerator.RegionType.values()) {
            for (RegionGenerator.SerializationType st : RegionGenerator.SerializationType.values()) {
                String name = "test-" + rt.name() + "-" + st.name();
                Region region = this.getCache().getRegion(name);
                for (Map.Entry entry : region.entrySet()) {
                    region.put(entry.getKey(), (Object)new MyObject(Integer.MAX_VALUE, "bad!!"));
                }
            }
        }
        SerializableCallable callbacks = new SerializableCallable(){

            public Object call() throws Exception {
                for (RegionGenerator.RegionType rt : RegionGenerator.RegionType.values()) {
                    for (RegionGenerator.SerializationType st : RegionGenerator.SerializationType.values()) {
                        String name = "test-" + rt.name() + "-" + st.name();
                        Cache c = SnapshotDUnitTest.this.getCache();
                        Region region = c.getRegion(name);
                        region.getAttributesMutator().setCacheWriter((CacheWriter)new CacheWriterAdapter<Integer, MyObject>(){

                            public void beforeUpdate(EntryEvent<Integer, MyObject> event) {
                                TestCase.fail((String)"CacheWriter invoked during import");
                            }
                        });
                        region.getAttributesMutator().addCacheListener((CacheListener)new CacheListenerAdapter<Integer, MyObject>(){

                            public void afterUpdate(EntryEvent<Integer, MyObject> event) {
                                TestCase.fail((String)"CacheListener invoked during import");
                            }
                        });
                    }
                }
                return null;
            }
        };
        SnapshotDUnitTest.forEachVm(callbacks, true);
        RegionGenerator rgen = new RegionGenerator();
        this.getCache().getSnapshotService().load(dir, SnapshotOptions.SnapshotFormat.GEMFIRE);
        for (RegionGenerator.RegionType rt : RegionGenerator.RegionType.values()) {
            for (RegionGenerator.SerializationType st : RegionGenerator.SerializationType.values()) {
                Region region = this.getCache().getRegion("test-" + rt.name() + "-" + st.name());
                for (Map.Entry<Integer, MyObject> entry : SnapshotDUnitTest.createExpected(st, rgen).entrySet()) {
                    SnapshotDUnitTest.assertEquals((String)("Comparison failure for " + rt.name() + "/" + st.name()), (Object)entry.getValue(), (Object)region.get((Object)entry.getKey()));
                }
            }
        }
    }

    public void testCacheExportFilterException() throws Exception {
        SnapshotFilter<Object, Object> oops = new SnapshotFilter<Object, Object>(){

            public boolean accept(Map.Entry<Object, Object> entry) {
                throw new RuntimeException();
            }
        };
        CacheSnapshotService css = this.getCache().getSnapshotService();
        SnapshotOptions options = css.createOptions().setFilter((SnapshotFilter)oops);
        boolean caughtException = false;
        try {
            File dir = new File(SnapshotDUnitTest.getDiskDirs()[0], "export");
            dir.mkdir();
            css.save(dir, SnapshotOptions.SnapshotFormat.GEMFIRE, options);
        }
        catch (Exception e) {
            caughtException = true;
        }
        SnapshotDUnitTest.assertTrue((boolean)caughtException);
    }

    public void testCacheImportFilterException() throws Exception {
        SnapshotFilter<Object, Object> oops = new SnapshotFilter<Object, Object>(){

            public boolean accept(Map.Entry<Object, Object> entry) {
                throw new RuntimeException();
            }
        };
        File dir = new File(SnapshotDUnitTest.getDiskDirs()[0], "import");
        dir.mkdir();
        CacheSnapshotService css = this.getCache().getSnapshotService();
        css.save(dir, SnapshotOptions.SnapshotFormat.GEMFIRE);
        SnapshotOptions options = css.createOptions().setFilter((SnapshotFilter)oops);
        boolean caughtException = false;
        try {
            css.load(dir.listFiles(), SnapshotOptions.SnapshotFormat.GEMFIRE, options);
        }
        catch (Exception e) {
            caughtException = true;
        }
        SnapshotDUnitTest.assertTrue((boolean)caughtException);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.loadCache();
        RegionGenerator rgen = new RegionGenerator();
        for (RegionGenerator.RegionType rt : RegionGenerator.RegionType.values()) {
            for (RegionGenerator.SerializationType st : RegionGenerator.SerializationType.values()) {
                Region region = this.getCache().getRegion("test-" + rt.name() + "-" + st.name());
                region.putAll(SnapshotDUnitTest.createExpected(st, rgen));
            }
        }
    }

    public static Map<Integer, MyObject> createExpected(RegionGenerator.SerializationType type, RegionGenerator rgen) {
        HashMap<Integer, MyObject> expected = new HashMap<Integer, MyObject>();
        for (int i = 0; i < 1000; ++i) {
            expected.put(i, rgen.createData(type, i, "The number is " + i));
        }
        return expected;
    }

    public void loadCache() throws Exception {
        SerializableCallable setup = new SerializableCallable(){

            public Object call() throws Exception {
                CacheFactory cf = new CacheFactory().setPdxSerializer((PdxSerializer)new MyPdxSerializer()).setPdxPersistent(true);
                Cache cache = SnapshotDUnitTest.this.getCache(cf);
                DiskStore ds = cache.createDiskStoreFactory().setMaxOplogSize(1L).setDiskDirs(CacheTestCase.getDiskDirs()).create("snapshotTest");
                RegionGenerator rgen = new RegionGenerator();
                for (RegionGenerator.RegionType rt : RegionGenerator.RegionType.values()) {
                    for (RegionGenerator.SerializationType st : RegionGenerator.SerializationType.values()) {
                        rgen.createRegion(cache, ds.getName(), rt, "test-" + rt.name() + "-" + st.name());
                    }
                }
                return null;
            }
        };
        SnapshotDUnitTest.forEachVm(setup, true);
    }

    public static Object forEachVm(SerializableCallable call, boolean local) throws Exception {
        Host host = Host.getHost(0);
        int vms = host.getVMCount();
        for (int i = 0; i < vms; ++i) {
            host.getVM(i).invoke(call);
        }
        if (local) {
            return call.call();
        }
        return null;
    }
}

