/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache30;

import com.gemstone.gemfire.InternalGemFireException;
import com.gemstone.gemfire.Statistics;
import com.gemstone.gemfire.StatisticsType;
import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.client.ClientCache;
import com.gemstone.gemfire.cache.client.Pool;
import com.gemstone.gemfire.cache.client.PoolManager;
import com.gemstone.gemfire.cache.util.BridgeMembership;
import com.gemstone.gemfire.cache.util.BridgeMembershipEvent;
import com.gemstone.gemfire.cache.util.BridgeMembershipListener;
import com.gemstone.gemfire.cache30.BridgeTestCase;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.DurableClientAttributes;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.LocalLogWriter;
import com.gemstone.gemfire.internal.cache.tier.InternalBridgeMembership;
import com.gemstone.gemfire.internal.cache.tier.sockets.ServerConnection;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableRunnable;
import dunit.VM;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import junit.framework.TestCase;

public class BridgeMembershipDUnitTest
extends BridgeTestCase {
    protected static final boolean CLIENT = true;
    protected static final boolean SERVER = false;
    protected static final int JOINED = 0;
    protected static final int LEFT = 1;
    protected static final int CRASHED = 2;
    protected static Socket meanSocket;
    protected static int testBridgeMembershipEventsInClient_port;
    protected static int testGetConnectedServers_port;
    protected static int testGetNotifiedClients_port;
    protected static int testGetNotifiedClients_clientCount;

    public BridgeMembershipDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.getSystem();
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
        InternalBridgeMembership.unregisterAllListeners();
    }

    private void waitForAcceptsInProgressToBe(final int target) throws Exception {
        DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){
            String excuse;

            @Override
            public boolean done() {
                int actual = BridgeMembershipDUnitTest.this.getAcceptsInProgress();
                if (actual == BridgeMembershipDUnitTest.this.getAcceptsInProgress()) {
                    return true;
                }
                this.excuse = "accepts in progress (" + actual + ") never became " + target;
                return false;
            }

            @Override
            public String description() {
                return this.excuse;
            }
        };
        DistributedTestCase.waitForCriterion(ev, 60000L, 200L, true);
    }

    protected int getAcceptsInProgress() {
        StatisticsType st = InternalDistributedSystem.getAnyInstance().findType("CacheServerStats");
        Statistics[] s = InternalDistributedSystem.getAnyInstance().findStatisticsByType(st);
        return s[0].getInt("acceptsInProgress");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testConnectionTimeout() throws Exception {
        Host host = Host.getHost(0);
        final String hostName = BridgeMembershipDUnitTest.getServerHostName(host);
        VM vm0 = host.getVM(0);
        System.setProperty("BridgeServer.acceptTimeout", "1000");
        try {
            final int port = this.startBridgeServer(0);
            try {
                BridgeMembershipDUnitTest.assertTrue((port != 0 ? 1 : 0) != 0);
                CacheSerializableRunnable createMeanSocket = new CacheSerializableRunnable("Connect to server with socket"){

                    @Override
                    public void run2() throws CacheException {
                        BridgeMembershipDUnitTest.this.getCache();
                        DistributedTestCase.getLogWriter().info("connecting to cache server with socket");
                        try {
                            InetAddress addr = InetAddress.getByName(hostName);
                            meanSocket = new Socket(addr, port);
                        }
                        catch (Exception e) {
                            throw new RuntimeException("Test failed to connect or was interrupted", e);
                        }
                    }
                };
                CacheSerializableRunnable closeMeanSocket = new CacheSerializableRunnable("close mean socket"){

                    @Override
                    public void run2() throws CacheException {
                        DistributedTestCase.getLogWriter().info("closing mean socket");
                        try {
                            meanSocket.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                };
                BridgeMembershipDUnitTest.assertEquals((int)0, (int)this.getAcceptsInProgress());
                BridgeMembershipDUnitTest.getLogWriter().info("creating mean socket");
                vm0.invoke(createMeanSocket);
                try {
                    BridgeMembershipDUnitTest.getLogWriter().info("waiting to see it connect on server");
                    this.waitForAcceptsInProgressToBe(1);
                }
                finally {
                    BridgeMembershipDUnitTest.getLogWriter().info("closing mean socket");
                    vm0.invoke(closeMeanSocket);
                }
                BridgeMembershipDUnitTest.getLogWriter().info("waiting to see accept to go away on server");
                this.waitForAcceptsInProgressToBe(0);
                BridgeMembershipDUnitTest.getLogWriter().info("creating mean socket 2");
                vm0.invoke(createMeanSocket);
                try {
                    BridgeMembershipDUnitTest.getLogWriter().info("waiting to see it connect on server 2");
                    this.waitForAcceptsInProgressToBe(1);
                    BridgeMembershipDUnitTest.getLogWriter().info("waiting to see accept to go away on server without us closing");
                    this.waitForAcceptsInProgressToBe(0);
                }
                finally {
                    BridgeMembershipDUnitTest.getLogWriter().info("closing mean socket 2");
                    vm0.invoke(closeMeanSocket);
                }
            }
            finally {
                this.stopBridgeServers(this.getCache());
            }
        }
        finally {
            System.getProperties().remove("BridgeServer.acceptTimeout");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSynchronousEvents() throws Exception {
        InternalBridgeMembership.setForceSynchronous((boolean)true);
        try {
            this.doTestBasicEvents();
        }
        finally {
            InternalBridgeMembership.setForceSynchronous((boolean)false);
        }
    }

    public void testBasicEvents() throws Exception {
        this.doTestBasicEvents();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doTestBasicEvents() throws Exception {
        final boolean[] fired = new boolean[3];
        final DistributedMember[] member = new DistributedMember[3];
        final String[] memberId = new String[3];
        final boolean[] isClient = new boolean[3];
        BridgeMembershipListener listener = new BridgeMembershipListener(){

            public synchronized void memberJoined(BridgeMembershipEvent event) {
                fired[0] = true;
                member[0] = event.getMember();
                memberId[0] = event.getMemberId();
                isClient[0] = event.isClient();
                this.notify();
            }

            public synchronized void memberLeft(BridgeMembershipEvent event) {
                fired[1] = true;
                member[1] = event.getMember();
                memberId[1] = event.getMemberId();
                isClient[1] = event.isClient();
                this.notify();
            }

            public synchronized void memberCrashed(BridgeMembershipEvent event) {
                fired[2] = true;
                member[2] = event.getMember();
                memberId[2] = event.getMemberId();
                isClient[2] = event.isClient();
                this.notify();
            }
        };
        BridgeMembership.registerBridgeMembershipListener((BridgeMembershipListener)listener);
        TestDistributedMember serverJoined = new TestDistributedMember("serverJoined");
        InternalBridgeMembership.notifyJoined((DistributedMember)serverJoined, (boolean)false);
        BridgeMembershipListener bridgeMembershipListener = listener;
        synchronized (bridgeMembershipListener) {
            if (!fired[0]) {
                listener.wait(2000L);
            }
        }
        BridgeMembershipDUnitTest.assertTrue((boolean)fired[0]);
        BridgeMembershipDUnitTest.assertEquals((Object)serverJoined, (Object)member[0]);
        BridgeMembershipDUnitTest.assertEquals((String)serverJoined.getId(), (String)memberId[0]);
        BridgeMembershipDUnitTest.assertFalse((boolean)isClient[0]);
        BridgeMembershipDUnitTest.assertFalse((boolean)fired[1]);
        BridgeMembershipDUnitTest.assertNull((Object)memberId[1]);
        BridgeMembershipDUnitTest.assertFalse((boolean)isClient[1]);
        BridgeMembershipDUnitTest.assertFalse((boolean)fired[2]);
        BridgeMembershipDUnitTest.assertNull((Object)memberId[2]);
        BridgeMembershipDUnitTest.assertFalse((boolean)isClient[2]);
        this.resetArraysForTesting(fired, member, memberId, isClient);
        TestDistributedMember clientJoined = new TestDistributedMember("clientJoined");
        InternalBridgeMembership.notifyJoined((DistributedMember)clientJoined, (boolean)true);
        BridgeMembershipListener bridgeMembershipListener2 = listener;
        synchronized (bridgeMembershipListener2) {
            if (!fired[0]) {
                listener.wait(2000L);
            }
        }
        BridgeMembershipDUnitTest.assertTrue((boolean)fired[0]);
        BridgeMembershipDUnitTest.assertEquals((Object)clientJoined, (Object)member[0]);
        BridgeMembershipDUnitTest.assertEquals((String)clientJoined.getId(), (String)memberId[0]);
        BridgeMembershipDUnitTest.assertTrue((boolean)isClient[0]);
        BridgeMembershipDUnitTest.assertFalse((boolean)fired[1]);
        BridgeMembershipDUnitTest.assertNull((Object)memberId[1]);
        BridgeMembershipDUnitTest.assertFalse((boolean)isClient[1]);
        BridgeMembershipDUnitTest.assertFalse((boolean)fired[2]);
        BridgeMembershipDUnitTest.assertNull((Object)memberId[2]);
        BridgeMembershipDUnitTest.assertFalse((boolean)isClient[2]);
        this.resetArraysForTesting(fired, member, memberId, isClient);
        TestDistributedMember serverLeft = new TestDistributedMember("serverLeft");
        InternalBridgeMembership.notifyLeft((DistributedMember)serverLeft, (boolean)false);
        BridgeMembershipListener bridgeMembershipListener3 = listener;
        synchronized (bridgeMembershipListener3) {
            if (!fired[1]) {
                listener.wait(2000L);
            }
        }
        BridgeMembershipDUnitTest.assertFalse((boolean)fired[0]);
        BridgeMembershipDUnitTest.assertNull((Object)memberId[0]);
        BridgeMembershipDUnitTest.assertFalse((boolean)isClient[0]);
        BridgeMembershipDUnitTest.assertTrue((boolean)fired[1]);
        BridgeMembershipDUnitTest.assertEquals((Object)serverLeft, (Object)member[1]);
        BridgeMembershipDUnitTest.assertEquals((String)serverLeft.getId(), (String)memberId[1]);
        BridgeMembershipDUnitTest.assertFalse((boolean)isClient[1]);
        BridgeMembershipDUnitTest.assertFalse((boolean)fired[2]);
        BridgeMembershipDUnitTest.assertNull((Object)memberId[2]);
        BridgeMembershipDUnitTest.assertFalse((boolean)isClient[2]);
        this.resetArraysForTesting(fired, member, memberId, isClient);
        TestDistributedMember clientLeft = new TestDistributedMember("clientLeft");
        InternalBridgeMembership.notifyLeft((DistributedMember)clientLeft, (boolean)true);
        BridgeMembershipListener bridgeMembershipListener4 = listener;
        synchronized (bridgeMembershipListener4) {
            if (!fired[1]) {
                listener.wait(2000L);
            }
        }
        BridgeMembershipDUnitTest.assertFalse((boolean)fired[0]);
        BridgeMembershipDUnitTest.assertNull((Object)memberId[0]);
        BridgeMembershipDUnitTest.assertFalse((boolean)isClient[0]);
        BridgeMembershipDUnitTest.assertTrue((boolean)fired[1]);
        BridgeMembershipDUnitTest.assertEquals((Object)clientLeft, (Object)member[1]);
        BridgeMembershipDUnitTest.assertEquals((String)clientLeft.getId(), (String)memberId[1]);
        BridgeMembershipDUnitTest.assertTrue((boolean)isClient[1]);
        BridgeMembershipDUnitTest.assertFalse((boolean)fired[2]);
        BridgeMembershipDUnitTest.assertNull((Object)memberId[2]);
        BridgeMembershipDUnitTest.assertFalse((boolean)isClient[2]);
        this.resetArraysForTesting(fired, member, memberId, isClient);
        TestDistributedMember serverCrashed = new TestDistributedMember("serverCrashed");
        InternalBridgeMembership.notifyCrashed((DistributedMember)serverCrashed, (boolean)false);
        BridgeMembershipListener bridgeMembershipListener5 = listener;
        synchronized (bridgeMembershipListener5) {
            if (!fired[2]) {
                listener.wait(2000L);
            }
        }
        BridgeMembershipDUnitTest.assertFalse((boolean)fired[0]);
        BridgeMembershipDUnitTest.assertNull((Object)memberId[0]);
        BridgeMembershipDUnitTest.assertFalse((boolean)isClient[0]);
        BridgeMembershipDUnitTest.assertFalse((boolean)fired[1]);
        BridgeMembershipDUnitTest.assertNull((Object)memberId[1]);
        BridgeMembershipDUnitTest.assertFalse((boolean)isClient[1]);
        BridgeMembershipDUnitTest.assertTrue((boolean)fired[2]);
        BridgeMembershipDUnitTest.assertEquals((Object)serverCrashed, (Object)member[2]);
        BridgeMembershipDUnitTest.assertEquals((String)serverCrashed.getId(), (String)memberId[2]);
        BridgeMembershipDUnitTest.assertFalse((boolean)isClient[2]);
        this.resetArraysForTesting(fired, member, memberId, isClient);
        TestDistributedMember clientCrashed = new TestDistributedMember("clientCrashed");
        InternalBridgeMembership.notifyCrashed((DistributedMember)clientCrashed, (boolean)true);
        BridgeMembershipListener bridgeMembershipListener6 = listener;
        synchronized (bridgeMembershipListener6) {
            if (!fired[2]) {
                listener.wait(2000L);
            }
        }
        BridgeMembershipDUnitTest.assertFalse((boolean)fired[0]);
        BridgeMembershipDUnitTest.assertNull((Object)memberId[0]);
        BridgeMembershipDUnitTest.assertFalse((boolean)isClient[0]);
        BridgeMembershipDUnitTest.assertFalse((boolean)fired[1]);
        BridgeMembershipDUnitTest.assertNull((Object)memberId[1]);
        BridgeMembershipDUnitTest.assertFalse((boolean)isClient[1]);
        BridgeMembershipDUnitTest.assertTrue((boolean)fired[2]);
        BridgeMembershipDUnitTest.assertEquals((Object)clientCrashed, (Object)member[2]);
        BridgeMembershipDUnitTest.assertEquals((String)clientCrashed.getId(), (String)memberId[2]);
        BridgeMembershipDUnitTest.assertTrue((boolean)isClient[2]);
        this.resetArraysForTesting(fired, member, memberId, isClient);
    }

    private void resetArraysForTesting(boolean[] fired, DistributedMember[] member, String[] memberId, boolean[] isClient) {
        for (int i = 0; i < fired.length; ++i) {
            fired[i] = false;
            member[i] = null;
            memberId[i] = null;
            isClient[i] = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUnregisterBridgeMembershipListener() throws Exception {
        final boolean[] fired = new boolean[1];
        final DistributedMember[] member = new DistributedMember[1];
        final String[] memberId = new String[1];
        final boolean[] isClient = new boolean[1];
        BridgeMembershipListener listener = new BridgeMembershipListener(){

            public synchronized void memberJoined(BridgeMembershipEvent event) {
                fired[0] = true;
                member[0] = event.getMember();
                memberId[0] = event.getMemberId();
                isClient[0] = event.isClient();
                this.notify();
            }

            public void memberLeft(BridgeMembershipEvent event) {
            }

            public void memberCrashed(BridgeMembershipEvent event) {
            }
        };
        BridgeMembership.registerBridgeMembershipListener((BridgeMembershipListener)listener);
        TestDistributedMember clientJoined = new TestDistributedMember("clientJoined");
        InternalBridgeMembership.notifyJoined((DistributedMember)clientJoined, (boolean)true);
        BridgeMembershipListener bridgeMembershipListener = listener;
        synchronized (bridgeMembershipListener) {
            if (!fired[0]) {
                listener.wait(2000L);
            }
        }
        BridgeMembershipDUnitTest.assertTrue((boolean)fired[0]);
        BridgeMembershipDUnitTest.assertEquals((Object)clientJoined, (Object)member[0]);
        BridgeMembershipDUnitTest.assertEquals((String)clientJoined.getId(), (String)memberId[0]);
        BridgeMembershipDUnitTest.assertTrue((boolean)isClient[0]);
        this.resetArraysForTesting(fired, member, memberId, isClient);
        BridgeMembershipDUnitTest.assertFalse((boolean)fired[0]);
        BridgeMembershipDUnitTest.assertNull((Object)memberId[0]);
        BridgeMembershipDUnitTest.assertFalse((boolean)isClient[0]);
        BridgeMembership.unregisterBridgeMembershipListener((BridgeMembershipListener)listener);
        InternalBridgeMembership.notifyJoined((DistributedMember)clientJoined, (boolean)true);
        BridgeMembershipDUnitTest.pause(2000);
        BridgeMembershipDUnitTest.assertFalse((boolean)fired[0]);
        BridgeMembershipDUnitTest.assertNull((Object)member[0]);
        BridgeMembershipDUnitTest.assertNull((Object)memberId[0]);
        BridgeMembershipDUnitTest.assertFalse((boolean)isClient[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMultipleListeners() throws Exception {
        int i;
        int NUM_LISTENERS = 4;
        final boolean[] fired = new boolean[4];
        final DistributedMember[] member = new DistributedMember[4];
        final String[] memberId = new String[4];
        final boolean[] isClient = new boolean[4];
        BridgeMembershipListener[] listeners = new BridgeMembershipListener[4];
        for (int i2 = 0; i2 < 4; ++i2) {
            final int whichListener = i2;
            listeners[i2] = new BridgeMembershipListener(){

                public synchronized void memberJoined(BridgeMembershipEvent event) {
                    TestCase.assertFalse((boolean)fired[whichListener]);
                    TestCase.assertNull((Object)member[whichListener]);
                    TestCase.assertNull((Object)memberId[whichListener]);
                    TestCase.assertFalse((boolean)isClient[whichListener]);
                    fired[whichListener] = true;
                    member[whichListener] = event.getMember();
                    memberId[whichListener] = event.getMemberId();
                    isClient[whichListener] = event.isClient();
                    this.notify();
                }

                public void memberLeft(BridgeMembershipEvent event) {
                }

                public void memberCrashed(BridgeMembershipEvent event) {
                }
            };
        }
        TestDistributedMember clientJoined = new TestDistributedMember("clientJoined");
        InternalBridgeMembership.notifyJoined((DistributedMember)clientJoined, (boolean)true);
        BridgeMembershipDUnitTest.pause(2000);
        for (int i3 = 0; i3 < 4; ++i3) {
            BridgeMembershipDUnitTest.assertFalse((boolean)fired[i3]);
            BridgeMembershipDUnitTest.assertNull((Object)member[i3]);
            BridgeMembershipDUnitTest.assertNull((Object)memberId[i3]);
            BridgeMembershipDUnitTest.assertFalse((boolean)isClient[i3]);
        }
        BridgeMembership.registerBridgeMembershipListener((BridgeMembershipListener)listeners[0]);
        BridgeMembership.registerBridgeMembershipListener((BridgeMembershipListener)listeners[0]);
        BridgeMembershipListener[] registeredListeners = BridgeMembership.getBridgeMembershipListeners();
        BridgeMembershipDUnitTest.assertEquals((int)1, (int)registeredListeners.length);
        BridgeMembershipDUnitTest.assertEquals((Object)listeners[0], (Object)registeredListeners[0]);
        BridgeMembership.registerBridgeMembershipListener((BridgeMembershipListener)listeners[1]);
        registeredListeners = BridgeMembership.getBridgeMembershipListeners();
        BridgeMembershipDUnitTest.assertEquals((int)2, (int)registeredListeners.length);
        BridgeMembershipDUnitTest.assertEquals((Object)listeners[0], (Object)registeredListeners[0]);
        BridgeMembershipDUnitTest.assertEquals((Object)listeners[1], (Object)registeredListeners[1]);
        InternalBridgeMembership.notifyJoined((DistributedMember)clientJoined, (boolean)true);
        BridgeMembershipListener bridgeMembershipListener = listeners[1];
        synchronized (bridgeMembershipListener) {
            if (!fired[1]) {
                listeners[1].wait(2000L);
            }
        }
        for (int i4 = 0; i4 < 4; ++i4) {
            if (i4 < 2) {
                BridgeMembershipDUnitTest.assertTrue((boolean)fired[i4]);
                BridgeMembershipDUnitTest.assertEquals((Object)clientJoined, (Object)member[i4]);
                BridgeMembershipDUnitTest.assertEquals((String)clientJoined.getId(), (String)memberId[i4]);
                BridgeMembershipDUnitTest.assertTrue((boolean)isClient[i4]);
                continue;
            }
            BridgeMembershipDUnitTest.assertFalse((boolean)fired[i4]);
            BridgeMembershipDUnitTest.assertNull((Object)member[i4]);
            BridgeMembershipDUnitTest.assertNull((Object)memberId[i4]);
            BridgeMembershipDUnitTest.assertFalse((boolean)isClient[i4]);
        }
        this.resetArraysForTesting(fired, member, memberId, isClient);
        BridgeMembership.unregisterBridgeMembershipListener((BridgeMembershipListener)listeners[0]);
        registeredListeners = BridgeMembership.getBridgeMembershipListeners();
        BridgeMembershipDUnitTest.assertEquals((int)1, (int)registeredListeners.length);
        BridgeMembershipDUnitTest.assertEquals((Object)listeners[1], (Object)registeredListeners[0]);
        InternalBridgeMembership.notifyJoined((DistributedMember)clientJoined, (boolean)true);
        BridgeMembershipListener i4 = listeners[1];
        synchronized (i4) {
            if (!fired[1]) {
                listeners[1].wait(2000L);
            }
        }
        for (int i5 = 0; i5 < 4; ++i5) {
            if (i5 == 1) {
                BridgeMembershipDUnitTest.assertTrue((boolean)fired[i5]);
                BridgeMembershipDUnitTest.assertEquals((Object)clientJoined, (Object)member[i5]);
                BridgeMembershipDUnitTest.assertEquals((String)clientJoined.getId(), (String)memberId[i5]);
                BridgeMembershipDUnitTest.assertTrue((boolean)isClient[i5]);
                continue;
            }
            BridgeMembershipDUnitTest.assertFalse((boolean)fired[i5]);
            BridgeMembershipDUnitTest.assertNull((Object)member[i5]);
            BridgeMembershipDUnitTest.assertNull((Object)memberId[i5]);
            BridgeMembershipDUnitTest.assertFalse((boolean)isClient[i5]);
        }
        this.resetArraysForTesting(fired, member, memberId, isClient);
        BridgeMembership.registerBridgeMembershipListener((BridgeMembershipListener)listeners[2]);
        BridgeMembership.registerBridgeMembershipListener((BridgeMembershipListener)listeners[3]);
        registeredListeners = BridgeMembership.getBridgeMembershipListeners();
        BridgeMembershipDUnitTest.assertEquals((int)3, (int)registeredListeners.length);
        BridgeMembershipDUnitTest.assertEquals((Object)listeners[1], (Object)registeredListeners[0]);
        BridgeMembershipDUnitTest.assertEquals((Object)listeners[2], (Object)registeredListeners[1]);
        BridgeMembershipDUnitTest.assertEquals((Object)listeners[3], (Object)registeredListeners[2]);
        InternalBridgeMembership.notifyJoined((DistributedMember)clientJoined, (boolean)true);
        BridgeMembershipListener i5 = listeners[3];
        synchronized (i5) {
            if (!fired[3]) {
                listeners[3].wait(2000L);
            }
        }
        for (int i6 = 0; i6 < 4; ++i6) {
            if (i6 != 0) {
                BridgeMembershipDUnitTest.assertTrue((boolean)fired[i6]);
                BridgeMembershipDUnitTest.assertEquals((Object)clientJoined, (Object)member[i6]);
                BridgeMembershipDUnitTest.assertEquals((String)clientJoined.getId(), (String)memberId[i6]);
                BridgeMembershipDUnitTest.assertTrue((boolean)isClient[i6]);
                continue;
            }
            BridgeMembershipDUnitTest.assertFalse((boolean)fired[i6]);
            BridgeMembershipDUnitTest.assertNull((Object)member[i6]);
            BridgeMembershipDUnitTest.assertNull((Object)memberId[i6]);
            BridgeMembershipDUnitTest.assertFalse((boolean)isClient[i6]);
        }
        this.resetArraysForTesting(fired, member, memberId, isClient);
        BridgeMembership.registerBridgeMembershipListener((BridgeMembershipListener)listeners[0]);
        registeredListeners = BridgeMembership.getBridgeMembershipListeners();
        BridgeMembershipDUnitTest.assertEquals((int)4, (int)registeredListeners.length);
        BridgeMembershipDUnitTest.assertEquals((Object)listeners[1], (Object)registeredListeners[0]);
        BridgeMembershipDUnitTest.assertEquals((Object)listeners[2], (Object)registeredListeners[1]);
        BridgeMembershipDUnitTest.assertEquals((Object)listeners[3], (Object)registeredListeners[2]);
        BridgeMembershipDUnitTest.assertEquals((Object)listeners[0], (Object)registeredListeners[3]);
        InternalBridgeMembership.notifyJoined((DistributedMember)clientJoined, (boolean)true);
        BridgeMembershipListener i6 = listeners[0];
        synchronized (i6) {
            if (!fired[0]) {
                listeners[0].wait(2000L);
            }
        }
        for (int i7 = 0; i7 < 4; ++i7) {
            BridgeMembershipDUnitTest.assertTrue((boolean)fired[i7]);
            BridgeMembershipDUnitTest.assertEquals((Object)clientJoined, (Object)member[i7]);
            BridgeMembershipDUnitTest.assertEquals((String)clientJoined.getId(), (String)memberId[i7]);
            BridgeMembershipDUnitTest.assertTrue((boolean)isClient[i7]);
        }
        this.resetArraysForTesting(fired, member, memberId, isClient);
        BridgeMembership.unregisterBridgeMembershipListener((BridgeMembershipListener)listeners[3]);
        registeredListeners = BridgeMembership.getBridgeMembershipListeners();
        BridgeMembershipDUnitTest.assertEquals((int)3, (int)registeredListeners.length);
        BridgeMembershipDUnitTest.assertEquals((Object)listeners[1], (Object)registeredListeners[0]);
        BridgeMembershipDUnitTest.assertEquals((Object)listeners[2], (Object)registeredListeners[1]);
        BridgeMembershipDUnitTest.assertEquals((Object)listeners[0], (Object)registeredListeners[2]);
        InternalBridgeMembership.notifyJoined((DistributedMember)clientJoined, (boolean)true);
        BridgeMembershipListener i7 = listeners[0];
        synchronized (i7) {
            if (!fired[0]) {
                listeners[0].wait(2000L);
            }
        }
        for (int i8 = 0; i8 < 4; ++i8) {
            if (i8 < 3) {
                BridgeMembershipDUnitTest.assertTrue((boolean)fired[i8]);
                BridgeMembershipDUnitTest.assertEquals((Object)clientJoined, (Object)member[i8]);
                BridgeMembershipDUnitTest.assertEquals((String)clientJoined.getId(), (String)memberId[i8]);
                BridgeMembershipDUnitTest.assertTrue((boolean)isClient[i8]);
                continue;
            }
            BridgeMembershipDUnitTest.assertFalse((boolean)fired[i8]);
            BridgeMembershipDUnitTest.assertNull((Object)member[i8]);
            BridgeMembershipDUnitTest.assertNull((Object)memberId[i8]);
            BridgeMembershipDUnitTest.assertFalse((boolean)isClient[i8]);
        }
        this.resetArraysForTesting(fired, member, memberId, isClient);
        BridgeMembership.unregisterBridgeMembershipListener((BridgeMembershipListener)listeners[2]);
        registeredListeners = BridgeMembership.getBridgeMembershipListeners();
        BridgeMembershipDUnitTest.assertEquals((int)2, (int)registeredListeners.length);
        BridgeMembershipDUnitTest.assertEquals((Object)listeners[1], (Object)registeredListeners[0]);
        BridgeMembershipDUnitTest.assertEquals((Object)listeners[0], (Object)registeredListeners[1]);
        InternalBridgeMembership.notifyJoined((DistributedMember)clientJoined, (boolean)true);
        BridgeMembershipListener i8 = listeners[0];
        synchronized (i8) {
            if (!fired[0]) {
                listeners[0].wait(2000L);
            }
        }
        for (i = 0; i < 4; ++i) {
            if (i < 2) {
                BridgeMembershipDUnitTest.assertTrue((boolean)fired[i]);
                BridgeMembershipDUnitTest.assertEquals((Object)clientJoined, (Object)member[i]);
                BridgeMembershipDUnitTest.assertEquals((String)clientJoined.getId(), (String)memberId[i]);
                BridgeMembershipDUnitTest.assertTrue((boolean)isClient[i]);
                continue;
            }
            BridgeMembershipDUnitTest.assertFalse((boolean)fired[i]);
            BridgeMembershipDUnitTest.assertNull((Object)member[i]);
            BridgeMembershipDUnitTest.assertNull((Object)memberId[i]);
            BridgeMembershipDUnitTest.assertFalse((boolean)isClient[i]);
        }
        this.resetArraysForTesting(fired, member, memberId, isClient);
        BridgeMembership.unregisterBridgeMembershipListener((BridgeMembershipListener)listeners[1]);
        BridgeMembership.unregisterBridgeMembershipListener((BridgeMembershipListener)listeners[0]);
        registeredListeners = BridgeMembership.getBridgeMembershipListeners();
        BridgeMembershipDUnitTest.assertEquals((int)0, (int)registeredListeners.length);
        InternalBridgeMembership.notifyJoined((DistributedMember)clientJoined, (boolean)true);
        BridgeMembershipDUnitTest.pause(2000);
        for (i = 0; i < 4; ++i) {
            BridgeMembershipDUnitTest.assertFalse((boolean)fired[i]);
            BridgeMembershipDUnitTest.assertNull((Object)member[i]);
            BridgeMembershipDUnitTest.assertNull((Object)memberId[i]);
            BridgeMembershipDUnitTest.assertFalse((boolean)isClient[i]);
        }
        this.resetArraysForTesting(fired, member, memberId, isClient);
        BridgeMembership.registerBridgeMembershipListener((BridgeMembershipListener)listeners[1]);
        registeredListeners = BridgeMembership.getBridgeMembershipListeners();
        BridgeMembershipDUnitTest.assertEquals((int)1, (int)registeredListeners.length);
        BridgeMembershipDUnitTest.assertEquals((Object)listeners[1], (Object)registeredListeners[0]);
        InternalBridgeMembership.notifyJoined((DistributedMember)clientJoined, (boolean)true);
        BridgeMembershipListener i9 = listeners[1];
        synchronized (i9) {
            if (!fired[1]) {
                listeners[1].wait(2000L);
            }
        }
        for (int i10 = 0; i10 < 4; ++i10) {
            if (i10 == 1) {
                BridgeMembershipDUnitTest.assertTrue((boolean)fired[i10]);
                BridgeMembershipDUnitTest.assertEquals((Object)clientJoined, (Object)member[i10]);
                BridgeMembershipDUnitTest.assertEquals((String)clientJoined.getId(), (String)memberId[i10]);
                BridgeMembershipDUnitTest.assertTrue((boolean)isClient[i10]);
                continue;
            }
            BridgeMembershipDUnitTest.assertFalse((boolean)fired[i10]);
            BridgeMembershipDUnitTest.assertNull((Object)member[i10]);
            BridgeMembershipDUnitTest.assertNull((Object)memberId[i10]);
            BridgeMembershipDUnitTest.assertFalse((boolean)isClient[i10]);
        }
    }

    private static int getTestBridgeMembershipEventsInClient_port() {
        return testBridgeMembershipEventsInClient_port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBridgeMembershipEventsInClient() throws Exception {
        final boolean[] fired = new boolean[3];
        final DistributedMember[] member = new DistributedMember[3];
        final String[] memberId = new String[3];
        final boolean[] isClient = new boolean[3];
        BridgeMembershipListener listener = new BridgeMembershipListener(){

            public synchronized void memberJoined(BridgeMembershipEvent event) {
                DistributedTestCase.getLogWriter().info("[testBridgeMembershipEventsInClient] memberJoined: " + event);
                fired[0] = true;
                member[0] = event.getMember();
                memberId[0] = event.getMemberId();
                isClient[0] = event.isClient();
                this.notify();
            }

            public synchronized void memberLeft(BridgeMembershipEvent event) {
                DistributedTestCase.getLogWriter().info("[testBridgeMembershipEventsInClient] memberLeft: " + event);
            }

            public synchronized void memberCrashed(BridgeMembershipEvent event) {
                DistributedTestCase.getLogWriter().info("[testBridgeMembershipEventsInClient] memberCrashed: " + event);
                fired[2] = true;
                member[2] = event.getMember();
                memberId[2] = event.getMemberId();
                isClient[2] = event.isClient();
                this.notify();
            }
        };
        BridgeMembership.registerBridgeMembershipListener((BridgeMembershipListener)listener);
        VM vm0 = Host.getHost(0).getVM(0);
        final String name = this.getUniqueName();
        final int[] ports = new int[1];
        vm0.invoke(new CacheSerializableRunnable("Create BridgeServer"){

            @Override
            public void run2() throws CacheException {
                try {
                    DistributedTestCase.getLogWriter().info("[testBridgeMembershipEventsInClient] Create BridgeServer");
                    BridgeMembershipDUnitTest.this.getSystem();
                    AttributesFactory factory = new AttributesFactory();
                    factory.setScope(Scope.LOCAL);
                    Region region = BridgeMembershipDUnitTest.this.createRegion(name, factory.create());
                    TestCase.assertNotNull((Object)region);
                    TestCase.assertNotNull((Object)BridgeMembershipDUnitTest.this.getRootRegion().getSubregion(name));
                    testBridgeMembershipEventsInClient_port = BridgeMembershipDUnitTest.this.startBridgeServer(0);
                }
                catch (IOException e) {
                    BridgeMembershipDUnitTest.this.getSystem().getLogWriter().fine((Throwable)new Exception(e));
                    TestCase.fail((String)("Failed to start CacheServer on VM1: " + e.getMessage()));
                }
            }
        });
        ports[0] = vm0.invokeInt(BridgeMembershipDUnitTest.class, "getTestBridgeMembershipEventsInClient_port");
        BridgeMembershipDUnitTest.assertTrue((ports[0] != 0 ? 1 : 0) != 0);
        DistributedMember serverMember = (DistributedMember)vm0.invoke(BridgeMembershipDUnitTest.class, "getDistributedMember");
        String serverMemberId = (String)vm0.invoke(BridgeMembershipDUnitTest.class, "getMemberId");
        BridgeMembershipDUnitTest.getLogWriter().info("[testBridgeMembershipEventsInClient] ports[0]=" + ports[0]);
        BridgeMembershipDUnitTest.getLogWriter().info("[testBridgeMembershipEventsInClient] serverMember=" + serverMember);
        BridgeMembershipDUnitTest.getLogWriter().info("[testBridgeMembershipEventsInClient] serverMemberId=" + serverMemberId);
        BridgeMembershipDUnitTest.assertFalse((boolean)fired[0]);
        BridgeMembershipDUnitTest.assertNull((Object)member[0]);
        BridgeMembershipDUnitTest.assertNull((Object)memberId[0]);
        BridgeMembershipDUnitTest.assertFalse((boolean)isClient[0]);
        BridgeMembershipDUnitTest.assertFalse((boolean)fired[1]);
        BridgeMembershipDUnitTest.assertNull((Object)member[1]);
        BridgeMembershipDUnitTest.assertNull((Object)memberId[1]);
        BridgeMembershipDUnitTest.assertFalse((boolean)isClient[1]);
        BridgeMembershipDUnitTest.assertFalse((boolean)fired[2]);
        BridgeMembershipDUnitTest.assertNull((Object)member[2]);
        BridgeMembershipDUnitTest.assertNull((Object)memberId[2]);
        BridgeMembershipDUnitTest.assertFalse((boolean)isClient[2]);
        BridgeMembershipDUnitTest.getLogWriter().info("[testBridgeMembershipEventsInClient] sanity check");
        TestDistributedMember test = new TestDistributedMember("test");
        InternalBridgeMembership.notifyJoined((DistributedMember)test, (boolean)false);
        BridgeMembershipDUnitTest.pause(2000);
        BridgeMembershipDUnitTest.assertTrue((boolean)fired[0]);
        BridgeMembershipDUnitTest.assertEquals((Object)test, (Object)member[0]);
        BridgeMembershipDUnitTest.assertEquals((String)test.getId(), (String)memberId[0]);
        BridgeMembershipDUnitTest.assertFalse((boolean)isClient[0]);
        BridgeMembershipDUnitTest.assertFalse((boolean)fired[1]);
        BridgeMembershipDUnitTest.assertNull((Object)member[1]);
        BridgeMembershipDUnitTest.assertNull((Object)memberId[1]);
        BridgeMembershipDUnitTest.assertFalse((boolean)isClient[1]);
        BridgeMembershipDUnitTest.assertFalse((boolean)fired[2]);
        BridgeMembershipDUnitTest.assertNull((Object)member[2]);
        BridgeMembershipDUnitTest.assertNull((Object)memberId[2]);
        BridgeMembershipDUnitTest.assertFalse((boolean)isClient[2]);
        this.resetArraysForTesting(fired, member, memberId, isClient);
        BridgeMembershipDUnitTest.getLogWriter().info("[testBridgeMembershipEventsInClient] create bridge client");
        Properties config = new Properties();
        config.setProperty("mcast-port", "0");
        config.setProperty("locators", "");
        this.getSystem(config);
        try {
            this.getCache();
            AttributesFactory factory = new AttributesFactory();
            factory.setScope(Scope.LOCAL);
            BridgeTestCase.configureConnectionPool(factory, BridgeMembershipDUnitTest.getServerHostName(Host.getHost(0)), ports, true, -1, -1, null);
            this.createRegion(name, factory.create());
            BridgeMembershipDUnitTest.assertNotNull((Object)this.getRootRegion().getSubregion(name));
        }
        catch (CacheException ex) {
            BridgeMembershipDUnitTest.fail("While creating Region on Edge", ex);
        }
        BridgeMembershipDUnitTest.pause(60000);
        BridgeMembershipDUnitTest.getLogWriter().info("[testBridgeMembershipEventsInClient] assert client detected server join");
        ClientCache clientCache = (ClientCache)this.getCache();
        Set servers = clientCache.getCurrentServers();
        BridgeMembershipDUnitTest.assertTrue((!servers.isEmpty() ? 1 : 0) != 0);
        InetSocketAddress serverAddr = (InetSocketAddress)servers.iterator().next();
        InetSocketAddress expectedAddr = new InetSocketAddress(serverMember.getHost(), ports[0]);
        BridgeMembershipDUnitTest.assertEquals((Object)expectedAddr, (Object)serverAddr);
        BridgeMembershipDUnitTest.assertTrue((boolean)fired[0]);
        BridgeMembershipDUnitTest.assertNotNull((Object)member[0]);
        BridgeMembershipDUnitTest.assertNotNull((Object)memberId[0]);
        BridgeMembershipDUnitTest.assertEquals((Object)serverMember, (Object)member[0]);
        BridgeMembershipDUnitTest.assertEquals((String)serverMemberId, (String)memberId[0]);
        BridgeMembershipDUnitTest.assertFalse((boolean)isClient[0]);
        BridgeMembershipDUnitTest.assertFalse((boolean)fired[1]);
        BridgeMembershipDUnitTest.assertNull((Object)member[1]);
        BridgeMembershipDUnitTest.assertNull((Object)memberId[1]);
        BridgeMembershipDUnitTest.assertFalse((boolean)isClient[1]);
        BridgeMembershipDUnitTest.assertFalse((boolean)fired[2]);
        BridgeMembershipDUnitTest.assertNull((Object)member[2]);
        BridgeMembershipDUnitTest.assertNull((Object)memberId[2]);
        BridgeMembershipDUnitTest.assertFalse((boolean)isClient[2]);
        this.resetArraysForTesting(fired, member, memberId, isClient);
        String expected = "java.io.IOException";
        String addExpected = "<ExpectedException action=add>" + expected + "</ExpectedException>";
        String removeExpected = "<ExpectedException action=remove>" + expected + "</ExpectedException>";
        LocalLogWriter bgexecLogger = new LocalLogWriter(Integer.MIN_VALUE, System.out);
        bgexecLogger.info(addExpected);
        BridgeMembershipDUnitTest.getLogWriter().info(addExpected);
        try {
            vm0.invoke(new SerializableRunnable("Stop BridgeServer"){

                @Override
                public void run() {
                    DistributedTestCase.getLogWriter().info("[testBridgeMembershipEventsInClient] Stop BridgeServer");
                    BridgeMembershipDUnitTest.this.stopBridgeServers(BridgeMembershipDUnitTest.this.getCache());
                }
            });
            BridgeMembershipDUnitTest.pause(60000);
        }
        finally {
            bgexecLogger.info(removeExpected);
            BridgeMembershipDUnitTest.getLogWriter().info(removeExpected);
        }
        BridgeMembershipDUnitTest.getLogWriter().info("[testBridgeMembershipEventsInClient] assert client detected server departure");
        BridgeMembershipDUnitTest.assertFalse((boolean)fired[0]);
        BridgeMembershipDUnitTest.assertNull((Object)member[0]);
        BridgeMembershipDUnitTest.assertNull((Object)memberId[0]);
        BridgeMembershipDUnitTest.assertFalse((boolean)isClient[0]);
        BridgeMembershipDUnitTest.assertFalse((boolean)fired[1]);
        BridgeMembershipDUnitTest.assertNull((Object)member[1]);
        BridgeMembershipDUnitTest.assertNull((Object)memberId[1]);
        BridgeMembershipDUnitTest.assertFalse((boolean)isClient[1]);
        BridgeMembershipDUnitTest.assertTrue((boolean)fired[2]);
        BridgeMembershipDUnitTest.assertNotNull((Object)member[2]);
        BridgeMembershipDUnitTest.assertNotNull((Object)memberId[2]);
        BridgeMembershipDUnitTest.assertEquals((Object)serverMember, (Object)member[2]);
        BridgeMembershipDUnitTest.assertEquals((String)serverMemberId, (String)memberId[2]);
        BridgeMembershipDUnitTest.assertFalse((boolean)isClient[2]);
        this.resetArraysForTesting(fired, member, memberId, isClient);
        vm0.invoke(new CacheSerializableRunnable("Recreate BridgeServer"){

            @Override
            public void run2() throws CacheException {
                try {
                    DistributedTestCase.getLogWriter().info("[testBridgeMembershipEventsInClient] restarting BridgeServer");
                    BridgeMembershipDUnitTest.this.startBridgeServer(ports[0]);
                }
                catch (IOException e) {
                    BridgeMembershipDUnitTest.this.getSystem().getLogWriter().fine((Throwable)new Exception(e));
                    TestCase.fail((String)("Failed to start CacheServer on VM1: " + e.getMessage()));
                }
            }
        });
        BridgeMembershipDUnitTest.pause(60000);
        BridgeMembershipDUnitTest.getLogWriter().info("[testBridgeMembershipEventsInClient] assert client detected server recovery");
        BridgeMembershipDUnitTest.assertTrue((boolean)fired[0]);
        BridgeMembershipDUnitTest.assertNotNull((Object)member[0]);
        BridgeMembershipDUnitTest.assertNotNull((Object)memberId[0]);
        BridgeMembershipDUnitTest.assertFalse((boolean)isClient[0]);
        BridgeMembershipDUnitTest.assertEquals((Object)serverMember, (Object)member[0]);
        BridgeMembershipDUnitTest.assertEquals((String)serverMemberId, (String)memberId[0]);
        BridgeMembershipDUnitTest.assertFalse((boolean)fired[1]);
        BridgeMembershipDUnitTest.assertNull((Object)member[1]);
        BridgeMembershipDUnitTest.assertNull((Object)memberId[1]);
        BridgeMembershipDUnitTest.assertFalse((boolean)isClient[1]);
        BridgeMembershipDUnitTest.assertFalse((boolean)fired[2]);
        BridgeMembershipDUnitTest.assertNull((Object)member[2]);
        BridgeMembershipDUnitTest.assertNull((Object)memberId[2]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBridgeMembershipEventsInServer() throws Exception {
        final boolean[] fired = new boolean[3];
        final DistributedMember[] member = new DistributedMember[3];
        final String[] memberId = new String[3];
        final boolean[] isClient = new boolean[3];
        BridgeMembershipListener listener = new BridgeMembershipListener(){

            public synchronized void memberJoined(BridgeMembershipEvent event) {
                DistributedTestCase.getLogWriter().info("[testBridgeMembershipEventsInServer] memberJoined: " + event);
                fired[0] = true;
                member[0] = event.getMember();
                memberId[0] = event.getMemberId();
                isClient[0] = event.isClient();
                this.notify();
                TestCase.assertFalse((fired[1] || fired[2] ? 1 : 0) != 0);
            }

            public synchronized void memberLeft(BridgeMembershipEvent event) {
                DistributedTestCase.getLogWriter().info("[testBridgeMembershipEventsInServer] memberLeft: " + event);
                fired[1] = true;
                member[1] = event.getMember();
                memberId[1] = event.getMemberId();
                isClient[1] = event.isClient();
                this.notify();
                TestCase.assertFalse((fired[0] || fired[2] ? 1 : 0) != 0);
            }

            public synchronized void memberCrashed(BridgeMembershipEvent event) {
                DistributedTestCase.getLogWriter().info("[testBridgeMembershipEventsInServer] memberCrashed: " + event);
                fired[2] = true;
                member[2] = event.getMember();
                memberId[2] = event.getMemberId();
                isClient[2] = event.isClient();
                this.notify();
                TestCase.assertFalse((fired[0] || fired[1] ? 1 : 0) != 0);
            }
        };
        BridgeMembership.registerBridgeMembershipListener((BridgeMembershipListener)listener);
        VM vm0 = Host.getHost(0).getVM(0);
        final String name = this.getUniqueName();
        final int[] ports = new int[1];
        BridgeMembershipDUnitTest.getLogWriter().info("[testBridgeMembershipEventsInServer] Create BridgeServer");
        this.getSystem();
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.LOCAL);
        Region region = this.createRegion(name, factory.create());
        BridgeMembershipDUnitTest.assertNotNull((Object)region);
        BridgeMembershipDUnitTest.assertNotNull((Object)this.getRootRegion().getSubregion(name));
        ports[0] = this.startBridgeServer(0);
        BridgeMembershipDUnitTest.assertTrue((ports[0] != 0 ? 1 : 0) != 0);
        String serverMemberId = BridgeMembershipDUnitTest.getMemberId();
        DistributedMember serverMember = BridgeMembershipDUnitTest.getDistributedMember();
        BridgeMembershipDUnitTest.getLogWriter().info("[testBridgeMembershipEventsInServer] ports[0]=" + ports[0]);
        BridgeMembershipDUnitTest.getLogWriter().info("[testBridgeMembershipEventsInServer] serverMemberId=" + serverMemberId);
        BridgeMembershipDUnitTest.getLogWriter().info("[testBridgeMembershipEventsInServer] serverMember=" + serverMember);
        BridgeMembershipDUnitTest.assertFalse((boolean)fired[0]);
        BridgeMembershipDUnitTest.assertNull((Object)member[0]);
        BridgeMembershipDUnitTest.assertNull((Object)memberId[0]);
        BridgeMembershipDUnitTest.assertFalse((boolean)isClient[0]);
        BridgeMembershipDUnitTest.assertFalse((boolean)fired[1]);
        BridgeMembershipDUnitTest.assertNull((Object)member[1]);
        BridgeMembershipDUnitTest.assertNull((Object)memberId[1]);
        BridgeMembershipDUnitTest.assertFalse((boolean)isClient[1]);
        BridgeMembershipDUnitTest.assertFalse((boolean)fired[2]);
        BridgeMembershipDUnitTest.assertNull((Object)member[2]);
        BridgeMembershipDUnitTest.assertNull((Object)memberId[2]);
        BridgeMembershipDUnitTest.assertFalse((boolean)isClient[2]);
        BridgeMembershipDUnitTest.getLogWriter().info("[testBridgeMembershipEventsInServer] sanity check");
        TestDistributedMember test = new TestDistributedMember("test");
        InternalBridgeMembership.notifyJoined((DistributedMember)test, (boolean)true);
        BridgeMembershipListener bridgeMembershipListener = listener;
        synchronized (bridgeMembershipListener) {
            if (!fired[0]) {
                listener.wait(2000L);
            }
        }
        BridgeMembershipDUnitTest.assertTrue((boolean)fired[0]);
        BridgeMembershipDUnitTest.assertEquals((Object)test, (Object)member[0]);
        BridgeMembershipDUnitTest.assertEquals((String)test.getId(), (String)memberId[0]);
        BridgeMembershipDUnitTest.assertTrue((boolean)isClient[0]);
        BridgeMembershipDUnitTest.assertFalse((boolean)fired[1]);
        BridgeMembershipDUnitTest.assertNull((Object)member[1]);
        BridgeMembershipDUnitTest.assertNull((Object)memberId[1]);
        BridgeMembershipDUnitTest.assertFalse((boolean)isClient[1]);
        BridgeMembershipDUnitTest.assertFalse((boolean)fired[2]);
        BridgeMembershipDUnitTest.assertNull((Object)member[2]);
        BridgeMembershipDUnitTest.assertNull((Object)memberId[2]);
        BridgeMembershipDUnitTest.assertFalse((boolean)isClient[2]);
        this.resetArraysForTesting(fired, member, memberId, isClient);
        final Host host = Host.getHost(0);
        CacheSerializableRunnable createConnectionPool = new CacheSerializableRunnable("Create connectionPool"){

            @Override
            public void run2() throws CacheException {
                DistributedTestCase.getLogWriter().info("[testBridgeMembershipEventsInServer] create bridge client");
                Properties config = new Properties();
                config.setProperty("mcast-port", "0");
                config.setProperty("locators", "");
                BridgeMembershipDUnitTest.this.getSystem(config);
                AttributesFactory factory = new AttributesFactory();
                factory.setScope(Scope.LOCAL);
                BridgeTestCase.configureConnectionPool(factory, DistributedTestCase.getServerHostName(host), ports, true, -1, 2, null);
                BridgeMembershipDUnitTest.this.createRegion(name, factory.create());
                TestCase.assertNotNull((Object)BridgeMembershipDUnitTest.this.getRootRegion().getSubregion(name));
            }
        };
        vm0.invoke(createConnectionPool);
        String clientMemberId = (String)vm0.invoke(BridgeMembershipDUnitTest.class, "getMemberId");
        DistributedMember clientMember = (DistributedMember)vm0.invoke(BridgeMembershipDUnitTest.class, "getDistributedMember");
        BridgeMembershipListener bridgeMembershipListener2 = listener;
        synchronized (bridgeMembershipListener2) {
            if (!fired[0]) {
                listener.wait(60000L);
            }
        }
        BridgeMembershipDUnitTest.getLogWriter().info("[testBridgeMembershipEventsInServer] assert server detected client join");
        BridgeMembershipDUnitTest.assertTrue((boolean)fired[0]);
        BridgeMembershipDUnitTest.assertEquals((String)(member[0] + " should equal " + clientMember), (Object)clientMember, (Object)member[0]);
        BridgeMembershipDUnitTest.assertEquals((String)(memberId[0] + " should equal " + clientMemberId), (String)clientMemberId, (String)memberId[0]);
        BridgeMembershipDUnitTest.assertTrue((boolean)isClient[0]);
        BridgeMembershipDUnitTest.assertFalse((boolean)fired[1]);
        BridgeMembershipDUnitTest.assertNull((Object)member[1]);
        BridgeMembershipDUnitTest.assertNull((Object)memberId[1]);
        BridgeMembershipDUnitTest.assertFalse((boolean)isClient[1]);
        BridgeMembershipDUnitTest.assertFalse((boolean)fired[2]);
        BridgeMembershipDUnitTest.assertNull((Object)member[2]);
        BridgeMembershipDUnitTest.assertNull((Object)memberId[2]);
        BridgeMembershipDUnitTest.assertFalse((boolean)isClient[2]);
        this.resetArraysForTesting(fired, member, memberId, isClient);
        this.pauseForClientToJoin();
        vm0.invoke(new SerializableRunnable("Stop bridge client"){

            @Override
            public void run() {
                DistributedTestCase.getLogWriter().info("[testBridgeMembershipEventsInServer] Stop bridge client");
                BridgeMembershipDUnitTest.this.getRootRegion().getSubregion(name).close();
                Map m = PoolManager.getAll();
                for (Pool p : m.values()) {
                    p.destroy();
                }
            }
        });
        bridgeMembershipListener2 = listener;
        synchronized (bridgeMembershipListener2) {
            if (!fired[1]) {
                listener.wait(60000L);
            }
        }
        BridgeMembershipDUnitTest.getLogWriter().info("[testBridgeMembershipEventsInServer] assert server detected client left");
        BridgeMembershipDUnitTest.assertFalse((boolean)fired[0]);
        BridgeMembershipDUnitTest.assertNull((Object)member[0]);
        BridgeMembershipDUnitTest.assertNull((Object)memberId[0]);
        BridgeMembershipDUnitTest.assertFalse((boolean)isClient[0]);
        BridgeMembershipDUnitTest.assertTrue((boolean)fired[1]);
        BridgeMembershipDUnitTest.assertEquals((Object)clientMember, (Object)member[1]);
        BridgeMembershipDUnitTest.assertEquals((String)clientMemberId, (String)memberId[1]);
        BridgeMembershipDUnitTest.assertTrue((boolean)isClient[1]);
        BridgeMembershipDUnitTest.assertFalse((boolean)fired[2]);
        BridgeMembershipDUnitTest.assertNull((Object)member[2]);
        BridgeMembershipDUnitTest.assertNull((Object)memberId[2]);
        BridgeMembershipDUnitTest.assertFalse((boolean)isClient[2]);
        this.resetArraysForTesting(fired, member, memberId, isClient);
        vm0.invoke(createConnectionPool);
        clientMemberId = (String)vm0.invoke(BridgeMembershipDUnitTest.class, "getMemberId");
        bridgeMembershipListener2 = listener;
        synchronized (bridgeMembershipListener2) {
            if (!fired[0]) {
                listener.wait(60000L);
            }
        }
        BridgeMembershipDUnitTest.getLogWriter().info("[testBridgeMembershipEventsInServer] assert server detected client re-join");
        BridgeMembershipDUnitTest.assertTrue((boolean)fired[0]);
        BridgeMembershipDUnitTest.assertEquals((Object)clientMember, (Object)member[0]);
        BridgeMembershipDUnitTest.assertEquals((String)clientMemberId, (String)memberId[0]);
        BridgeMembershipDUnitTest.assertTrue((boolean)isClient[0]);
        BridgeMembershipDUnitTest.assertFalse((boolean)fired[1]);
        BridgeMembershipDUnitTest.assertNull((Object)member[1]);
        BridgeMembershipDUnitTest.assertNull((Object)memberId[1]);
        BridgeMembershipDUnitTest.assertFalse((boolean)isClient[1]);
        BridgeMembershipDUnitTest.assertFalse((boolean)fired[2]);
        BridgeMembershipDUnitTest.assertNull((Object)member[2]);
        BridgeMembershipDUnitTest.assertNull((Object)memberId[2]);
        BridgeMembershipDUnitTest.assertFalse((boolean)isClient[2]);
        this.resetArraysForTesting(fired, member, memberId, isClient);
        this.pauseForClientToJoin();
        ServerConnection.setForceClientCrashEvent((boolean)true);
        try {
            vm0.invoke(new SerializableRunnable("Stop bridge client"){

                @Override
                public void run() {
                    DistributedTestCase.getLogWriter().info("[testBridgeMembershipEventsInServer] Stop bridge client");
                    BridgeMembershipDUnitTest.this.getRootRegion().getSubregion(name).close();
                    Map m = PoolManager.getAll();
                    for (Pool p : m.values()) {
                        p.destroy();
                    }
                }
            });
            bridgeMembershipListener2 = listener;
            synchronized (bridgeMembershipListener2) {
                if (!fired[2]) {
                    listener.wait(60000L);
                }
            }
            BridgeMembershipDUnitTest.getLogWriter().info("[testBridgeMembershipEventsInServer] assert server detected client crashed");
            BridgeMembershipDUnitTest.assertFalse((boolean)fired[0]);
            BridgeMembershipDUnitTest.assertNull((Object)member[0]);
            BridgeMembershipDUnitTest.assertNull((Object)memberId[0]);
            BridgeMembershipDUnitTest.assertFalse((boolean)isClient[0]);
            BridgeMembershipDUnitTest.assertFalse((boolean)fired[1]);
            BridgeMembershipDUnitTest.assertNull((Object)member[1]);
            BridgeMembershipDUnitTest.assertNull((Object)memberId[1]);
            BridgeMembershipDUnitTest.assertFalse((boolean)isClient[1]);
            BridgeMembershipDUnitTest.assertTrue((boolean)fired[2]);
            BridgeMembershipDUnitTest.assertEquals((Object)clientMember, (Object)member[2]);
            BridgeMembershipDUnitTest.assertEquals((String)clientMemberId, (String)memberId[2]);
            BridgeMembershipDUnitTest.assertTrue((boolean)isClient[2]);
        }
        finally {
            ServerConnection.setForceClientCrashEvent((boolean)false);
        }
    }

    private void pauseForClientToJoin() {
        BridgeMembershipDUnitTest.pause(2000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLifecycle() throws Exception {
        final boolean[] fired = new boolean[3];
        final DistributedMember[] member = new DistributedMember[3];
        final String[] memberId = new String[3];
        final boolean[] isClient = new boolean[3];
        BridgeMembershipListener listener = new BridgeMembershipListener(){

            public synchronized void memberJoined(BridgeMembershipEvent event) {
                TestCase.assertFalse((boolean)fired[0]);
                TestCase.assertNull((Object)member[0]);
                TestCase.assertNull((Object)memberId[0]);
                TestCase.assertFalse((boolean)isClient[0]);
                fired[0] = true;
                member[0] = event.getMember();
                memberId[0] = event.getMemberId();
                isClient[0] = event.isClient();
                this.notify();
            }

            public synchronized void memberLeft(BridgeMembershipEvent event) {
            }

            public synchronized void memberCrashed(BridgeMembershipEvent event) {
            }
        };
        BridgeMembership.registerBridgeMembershipListener((BridgeMembershipListener)listener);
        Properties config = new Properties();
        config.setProperty("mcast-port", "0");
        config.setProperty("locators", "");
        this.getSystem(config);
        TestDistributedMember serverJoined = new TestDistributedMember("serverJoined");
        InternalBridgeMembership.notifyJoined((DistributedMember)serverJoined, (boolean)false);
        BridgeMembershipListener bridgeMembershipListener = listener;
        synchronized (bridgeMembershipListener) {
            if (!fired[0]) {
                listener.wait(2000L);
            }
        }
        BridgeMembershipDUnitTest.assertTrue((boolean)fired[0]);
        BridgeMembershipDUnitTest.assertEquals((Object)serverJoined, (Object)member[0]);
        BridgeMembershipDUnitTest.assertEquals((String)serverJoined.getId(), (String)memberId[0]);
        BridgeMembershipDUnitTest.assertFalse((boolean)isClient[0]);
        this.resetArraysForTesting(fired, member, memberId, isClient);
        BridgeMembershipDUnitTest.disconnectFromDS();
        InternalBridgeMembership.notifyJoined((DistributedMember)serverJoined, (boolean)false);
        BridgeMembershipDUnitTest.pause(2000);
        BridgeMembershipDUnitTest.assertFalse((boolean)fired[0]);
        BridgeMembershipDUnitTest.assertNull((Object)member[0]);
        BridgeMembershipDUnitTest.assertNull((Object)memberId[0]);
        BridgeMembershipDUnitTest.assertFalse((boolean)isClient[0]);
        this.resetArraysForTesting(fired, member, memberId, isClient);
        InternalDistributedSystem sys = this.getSystem(config);
        BridgeMembershipDUnitTest.assertTrue((boolean)sys.isConnected());
        InternalBridgeMembership.notifyJoined((DistributedMember)serverJoined, (boolean)false);
        BridgeMembershipListener bridgeMembershipListener2 = listener;
        synchronized (bridgeMembershipListener2) {
            if (!fired[0]) {
                listener.wait(2000L);
            }
        }
        BridgeMembershipDUnitTest.assertTrue((boolean)fired[0]);
        BridgeMembershipDUnitTest.assertEquals((Object)serverJoined, (Object)member[0]);
        BridgeMembershipDUnitTest.assertEquals((String)serverJoined.getId(), (String)memberId[0]);
        BridgeMembershipDUnitTest.assertFalse((boolean)isClient[0]);
    }

    public void testGetConnectedClients() throws Exception {
        final String name = this.getUniqueName();
        final int[] ports = new int[1];
        BridgeMembershipDUnitTest.getLogWriter().info("[testGetConnectedClients] Create BridgeServer");
        this.getSystem();
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.LOCAL);
        Region region = this.createRegion(name, factory.create());
        BridgeMembershipDUnitTest.assertNotNull((Object)region);
        BridgeMembershipDUnitTest.assertNotNull((Object)this.getRootRegion().getSubregion(name));
        ports[0] = this.startBridgeServer(0);
        BridgeMembershipDUnitTest.assertTrue((ports[0] != 0 ? 1 : 0) != 0);
        String serverMemberId = BridgeMembershipDUnitTest.getMemberId();
        BridgeMembershipDUnitTest.getLogWriter().info("[testGetConnectedClients] ports[0]=" + ports[0]);
        BridgeMembershipDUnitTest.getLogWriter().info("[testGetConnectedClients] serverMemberId=" + serverMemberId);
        final Host host = Host.getHost(0);
        CacheSerializableRunnable createPool = new CacheSerializableRunnable("Create connection pool"){

            @Override
            public void run2() throws CacheException {
                DistributedTestCase.getLogWriter().info("[testGetConnectedClients] create bridge client");
                Properties config = new Properties();
                config.setProperty("mcast-port", "0");
                config.setProperty("locators", "");
                BridgeMembershipDUnitTest.this.getSystem(config);
                AttributesFactory factory = new AttributesFactory();
                factory.setScope(Scope.LOCAL);
                BridgeTestCase.configureConnectionPool(factory, DistributedTestCase.getServerHostName(host), ports, true, -1, -1, null);
                BridgeMembershipDUnitTest.this.createRegion(name, factory.create());
                TestCase.assertNotNull((Object)BridgeMembershipDUnitTest.this.getRootRegion().getSubregion(name));
            }
        };
        String[] clientMemberIdArray = new String[host.getVMCount()];
        for (int i = 0; i < host.getVMCount(); ++i) {
            VM vm = Host.getHost(0).getVM(i);
            vm.invoke(createPool);
            clientMemberIdArray[i] = String.valueOf(vm.invoke(BridgeMembershipDUnitTest.class, "getMemberId"));
        }
        List<String> clientMemberIds = Arrays.asList(clientMemberIdArray);
        this.pauseForClientToJoin();
        Map connectedClients = InternalBridgeMembership.getConnectedClients((boolean)false);
        BridgeMembershipDUnitTest.assertNotNull((Object)connectedClients);
        BridgeMembershipDUnitTest.assertEquals((int)clientMemberIds.size(), (int)connectedClients.size());
        for (String connectedClient : connectedClients.keySet()) {
            BridgeMembershipDUnitTest.getLogWriter().info("[testGetConnectedClients] checking for client " + connectedClient);
            BridgeMembershipDUnitTest.assertTrue((boolean)clientMemberIds.contains(connectedClient));
            BridgeMembershipDUnitTest.getLogWriter().info("[testGetConnectedClients] count for connectedClient: " + connectedClients.get(connectedClient));
        }
    }

    public void testGetConnectedServers() throws Exception {
        Host host = Host.getHost(0);
        final String name = this.getUniqueName();
        final int[] ports = new int[host.getVMCount()];
        for (int i = 0; i < host.getVMCount(); ++i) {
            final int whichVM = i;
            VM vm = Host.getHost(0).getVM(i);
            vm.invoke(new CacheSerializableRunnable("Create bridge server"){

                @Override
                public void run2() throws CacheException {
                    DistributedTestCase.getLogWriter().info("[testGetConnectedServers] Create BridgeServer");
                    BridgeMembershipDUnitTest.this.getSystem();
                    AttributesFactory factory = new AttributesFactory();
                    factory.setScope(Scope.LOCAL);
                    Region region = BridgeMembershipDUnitTest.this.createRegion(name + "_" + whichVM, factory.create());
                    TestCase.assertNotNull((Object)region);
                    TestCase.assertNotNull((Object)BridgeMembershipDUnitTest.this.getRootRegion().getSubregion(name + "_" + whichVM));
                    region.put((Object)"KEY-1", (Object)"VAL-1");
                    try {
                        testGetConnectedServers_port = BridgeMembershipDUnitTest.this.startBridgeServer(0);
                    }
                    catch (IOException e) {
                        DistributedTestCase.getLogWriter().error("startBridgeServer threw IOException", (Throwable)e);
                        TestCase.fail((String)("startBridgeServer threw IOException " + e.getMessage()));
                    }
                    TestCase.assertTrue((testGetConnectedServers_port != 0 ? 1 : 0) != 0);
                    DistributedTestCase.getLogWriter().info("[testGetConnectedServers] port=" + ports[whichVM]);
                    DistributedTestCase.getLogWriter().info("[testGetConnectedServers] serverMemberId=" + BridgeTestCase.getDistributedMember());
                }
            });
            ports[whichVM] = vm.invokeInt(BridgeMembershipDUnitTest.class, "getTestGetConnectedServers_port");
            BridgeMembershipDUnitTest.assertTrue((ports[whichVM] != 0 ? 1 : 0) != 0);
        }
        BridgeMembershipDUnitTest.getLogWriter().info("[testGetConnectedServers] create bridge client");
        Properties config = new Properties();
        config.setProperty("mcast-port", "0");
        config.setProperty("locators", "");
        this.getSystem(config);
        this.getCache();
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.LOCAL);
        for (int i = 0; i < ports.length; ++i) {
            BridgeMembershipDUnitTest.getLogWriter().info("[testGetConnectedServers] creating connectionpool for " + BridgeMembershipDUnitTest.getServerHostName(host) + " " + ports[i]);
            int[] thisServerPorts = new int[]{ports[i]};
            BridgeTestCase.configureConnectionPoolWithName(factory, BridgeMembershipDUnitTest.getServerHostName(host), thisServerPorts, false, -1, -1, null, "pooly" + i);
            Region region = this.createRegion(name + "_" + i, factory.create());
            BridgeMembershipDUnitTest.assertNotNull((Object)this.getRootRegion().getSubregion(name + "_" + i));
            region.get((Object)"KEY-1");
        }
        this.pauseForClientToJoin();
        this.pauseForClientToJoin();
        BridgeMembershipDUnitTest.assertEquals((int)host.getVMCount(), (int)PoolManager.getAll().size());
        Map connectedServers = InternalBridgeMembership.getConnectedServers();
        BridgeMembershipDUnitTest.assertNotNull((Object)connectedServers);
        BridgeMembershipDUnitTest.assertEquals((int)host.getVMCount(), (int)connectedServers.size());
        for (String connectedServer : connectedServers.keySet()) {
            BridgeMembershipDUnitTest.getLogWriter().info("[testGetConnectedServers]  value for connectedServer: " + connectedServers.get(connectedServer));
        }
    }

    private static int getTestGetConnectedServers_port() {
        return testGetConnectedServers_port;
    }

    public void testGetNotifiedClients() throws Exception {
        Host host = Host.getHost(0);
        final String name = this.getUniqueName();
        final int[] ports = new int[host.getVMCount()];
        for (int i = 0; i < host.getVMCount(); ++i) {
            final int whichVM = i;
            VM vm = Host.getHost(0).getVM(i);
            vm.invoke(new CacheSerializableRunnable("Create bridge server"){

                @Override
                public void run2() throws CacheException {
                    DistributedTestCase.getLogWriter().info("[testGetNotifiedClients] Create BridgeServer");
                    BridgeMembershipDUnitTest.this.getSystem();
                    AttributesFactory factory = new AttributesFactory();
                    Region region = BridgeMembershipDUnitTest.this.createRegion(name, factory.create());
                    TestCase.assertNotNull((Object)region);
                    TestCase.assertNotNull((Object)BridgeMembershipDUnitTest.this.getRootRegion().getSubregion(name));
                    region.put((Object)"KEY-1", (Object)"VAL-1");
                    try {
                        testGetNotifiedClients_port = BridgeMembershipDUnitTest.this.startBridgeServer(0);
                    }
                    catch (IOException e) {
                        DistributedTestCase.getLogWriter().error("startBridgeServer threw IOException", (Throwable)e);
                        TestCase.fail((String)("startBridgeServer threw IOException " + e.getMessage()));
                    }
                    TestCase.assertTrue((testGetNotifiedClients_port != 0 ? 1 : 0) != 0);
                    DistributedTestCase.getLogWriter().info("[testGetNotifiedClients] port=" + ports[whichVM]);
                    DistributedTestCase.getLogWriter().info("[testGetNotifiedClients] serverMemberId=" + BridgeTestCase.getMemberId());
                }
            });
            ports[whichVM] = vm.invokeInt(BridgeMembershipDUnitTest.class, "getTestGetNotifiedClients_port");
            BridgeMembershipDUnitTest.assertTrue((ports[whichVM] != 0 ? 1 : 0) != 0);
        }
        BridgeMembershipDUnitTest.getLogWriter().info("[testGetNotifiedClients] create bridge client");
        Properties config = new Properties();
        config.setProperty("mcast-port", "0");
        config.setProperty("locators", "");
        this.getSystem(config);
        this.getCache();
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.LOCAL);
        BridgeMembershipDUnitTest.getLogWriter().info("[testGetNotifiedClients] creating connection pool");
        BridgeTestCase.configureConnectionPool(factory, BridgeMembershipDUnitTest.getServerHostName(host), ports, true, -1, -1, null);
        Region region = this.createRegion(name, factory.create());
        BridgeMembershipDUnitTest.assertNotNull((Object)this.getRootRegion().getSubregion(name));
        region.registerInterest((Object)"KEY-1");
        region.get((Object)"KEY-1");
        final String clientMemberId = BridgeMembershipDUnitTest.getMemberId();
        this.pauseForClientToJoin();
        int[] clientCounts = new int[host.getVMCount()];
        for (int i = 0; i < host.getVMCount(); ++i) {
            int whichVM = i;
            VM vm = Host.getHost(0).getVM(i);
            vm.invoke(new CacheSerializableRunnable("Create bridge server"){

                @Override
                public void run2() throws CacheException {
                    Map clients = InternalBridgeMembership.getConnectedClients((boolean)true);
                    TestCase.assertNotNull((Object)clients);
                    testGetNotifiedClients_clientCount = clients.size();
                    if (testGetNotifiedClients_clientCount > 0) {
                        TestCase.assertEquals((Object)clientMemberId, clients.keySet().iterator().next());
                    }
                }
            });
            clientCounts[whichVM] = vm.invokeInt(BridgeMembershipDUnitTest.class, "getTestGetNotifiedClients_clientCount");
        }
        int totalClientCounts = 0;
        for (int i = 0; i < clientCounts.length; ++i) {
            totalClientCounts += clientCounts[i];
        }
    }

    private static int getTestGetNotifiedClients_port() {
        return testGetNotifiedClients_port;
    }

    private static int getTestGetNotifiedClients_clientCount() {
        return testGetNotifiedClients_clientCount;
    }

    static final class TestDistributedMember
    implements DistributedMember {
        private String host;

        public TestDistributedMember(String host) {
            this.host = host;
        }

        public String getName() {
            return "";
        }

        public String getHost() {
            return this.host;
        }

        public Set getRoles() {
            return new HashSet();
        }

        public int getProcessId() {
            return 0;
        }

        public String getId() {
            return this.host;
        }

        public int compareTo(DistributedMember o) {
            if (o == null || !(o instanceof TestDistributedMember)) {
                throw new InternalGemFireException("Invalidly comparing TestDistributedMember to " + o);
            }
            TestDistributedMember tds = (TestDistributedMember)o;
            return this.getHost().compareTo(tds.getHost());
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof TestDistributedMember)) {
                return false;
            }
            return this.compareTo((TestDistributedMember)obj) == 0;
        }

        public int hashCode() {
            return this.getHost().hashCode();
        }

        public DurableClientAttributes getDurableClientAttributes() {
            return null;
        }

        public List<String> getGroups() {
            return Collections.emptyList();
        }
    }
}

