/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache30;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheLoader;
import com.gemstone.gemfire.cache.Declarable;
import com.gemstone.gemfire.cache.LoaderHelper;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.client.Pool;
import com.gemstone.gemfire.cache.client.PoolFactory;
import com.gemstone.gemfire.cache.client.PoolManager;
import com.gemstone.gemfire.cache.util.BridgeServer;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.cache30.TestCacheLoader;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.AvailablePortHelper;
import dunit.DistributedTestCase;
import dunit.VM;
import java.io.IOException;
import java.util.Properties;
import junit.framework.TestCase;

public class BridgeTestCase
extends CacheTestCase {
    public static String NON_EXISTENT_KEY = "NON_EXISTENT_KEY";
    public static boolean AUTO_LOAD_BALANCE = false;
    public static final String BridgeServerKey = "BridgeServerKey";

    public static void caseSetUp() {
        BridgeTestCase.disconnectAllFromDS();
    }

    public static void caseTearDown() {
        BridgeTestCase.disconnectAllFromDS();
    }

    public BridgeTestCase(String name) {
        super(name);
    }

    public int startBridgeServer(int port) throws IOException {
        Cache cache = this.getCache();
        BridgeServer bridge = cache.addBridgeServer();
        bridge.setPort(port);
        bridge.setMaxThreads(this.getMaxThreads());
        bridge.start();
        return bridge.getPort();
    }

    protected int getMaxThreads() {
        return 0;
    }

    public void stopBridgeServers(Cache cache) {
        BridgeServer bridge2 = null;
        for (BridgeServer bridge2 : cache.getBridgeServers()) {
            bridge2.stop();
            BridgeTestCase.assertFalse((boolean)bridge2.isRunning());
        }
    }

    protected RegionAttributes getRegionAttributes() {
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.LOCAL);
        return factory.create();
    }

    public static String createBridgeClientConnection(String host, int[] ports) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < ports.length; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append("name" + i + "=");
            sb.append(host + ":" + ports[i]);
        }
        return sb.toString();
    }

    public static Pool configureConnectionPool(AttributesFactory factory, String host, int port1, int port2, boolean establish, int redundancy, int connectionsPerServer, String serverGroup, int pingInterval, int idleTimeout, boolean threadLocalCnxs, int lifetimeTimeout) {
        int[] ports = port2 != -1 ? new int[]{port1, port2} : new int[]{port1};
        return BridgeTestCase.configureConnectionPool(factory, host, ports, establish, redundancy, connectionsPerServer, serverGroup, pingInterval, idleTimeout, threadLocalCnxs, lifetimeTimeout);
    }

    public static Pool configureConnectionPool(AttributesFactory factory, String host, int port1, int port2, boolean establish, int redundancy, int connectionsPerServer, String serverGroup, int pingInterval, int idleTimeout, boolean threadLocalCnxs) {
        return BridgeTestCase.configureConnectionPool(factory, host, port1, port2, establish, redundancy, connectionsPerServer, serverGroup, pingInterval, idleTimeout, threadLocalCnxs, -2);
    }

    public static Pool configureConnectionPool(AttributesFactory factory, String host, int port1, int port2, boolean establish, int redundancy, int connectionsPerServer, String serverGroup, int pingInterval) {
        return BridgeTestCase.configureConnectionPool(factory, host, port1, port2, establish, redundancy, connectionsPerServer, serverGroup, pingInterval, -1, false);
    }

    public static Pool configureConnectionPool(AttributesFactory factory, String host, int port1, int port2, boolean establish, int redundancy, int connectionsPerServer, String serverGroup) {
        return BridgeTestCase.configureConnectionPool(factory, host, port1, port2, establish, redundancy, connectionsPerServer, serverGroup, -1);
    }

    public static Pool configureConnectionPoolWithName(AttributesFactory factory, String host, int[] ports, boolean establish, int redundancy, int connectionsPerServer, String serverGroup, String poolName) {
        return BridgeTestCase.configureConnectionPoolWithNameAndFactory(factory, host, ports, establish, redundancy, connectionsPerServer, serverGroup, poolName, PoolManager.createFactory(), -1, -1, false, -2, -1);
    }

    public static Pool configureConnectionPoolWithName(AttributesFactory factory, String host, int[] ports, boolean establish, int redundancy, int connectionsPerServer, String serverGroup, String poolName, int pingInterval, int idleTimeout, boolean threadLocalCnxs, int lifetimeTimeout, int statisticInterval) {
        return BridgeTestCase.configureConnectionPoolWithNameAndFactory(factory, host, ports, establish, redundancy, connectionsPerServer, serverGroup, poolName, PoolManager.createFactory(), pingInterval, idleTimeout, threadLocalCnxs, lifetimeTimeout, statisticInterval);
    }

    public static Pool configureConnectionPoolWithNameAndFactory(AttributesFactory factory, String host, int[] ports, boolean establish, int redundancy, int connectionsPerServer, String serverGroup, String poolName, PoolFactory pf) {
        return BridgeTestCase.configureConnectionPoolWithNameAndFactory(factory, host, ports, establish, redundancy, connectionsPerServer, serverGroup, poolName, pf, -1, -1, false, -2, -1);
    }

    public static Pool configureConnectionPoolWithNameAndFactory(AttributesFactory factory, String host, int[] ports, boolean establish, int redundancy, int connectionsPerServer, String serverGroup, String poolName, PoolFactory pf, int pingInterval, int idleTimeout, boolean threadLocalCnxs, int lifetimeTimeout, int statisticInterval) {
        if (AUTO_LOAD_BALANCE) {
            pf.addLocator(host, BridgeTestCase.getDUnitLocatorPort());
        } else {
            for (int z = 0; z < ports.length; ++z) {
                pf.addServer(host, ports[z]);
            }
        }
        if (connectionsPerServer != -1) {
            pf.setMinConnections(connectionsPerServer * ports.length);
        }
        if (threadLocalCnxs) {
            pf.setThreadLocalConnections(true);
        }
        if (pingInterval != -1) {
            pf.setPingInterval((long)pingInterval);
        }
        if (idleTimeout != -1) {
            pf.setIdleTimeout((long)idleTimeout);
        }
        if (statisticInterval != -1) {
            pf.setStatisticInterval(statisticInterval);
        }
        if (lifetimeTimeout != -2) {
            pf.setLoadConditioningInterval(lifetimeTimeout);
        }
        if (establish) {
            pf.setSubscriptionEnabled(true);
            pf.setSubscriptionRedundancy(redundancy);
            pf.setSubscriptionAckInterval(1);
        }
        if (serverGroup != null) {
            pf.setServerGroup(serverGroup);
        }
        String rpoolName = "testPool";
        if (poolName != null) {
            rpoolName = poolName;
        }
        Pool pool = pf.create(rpoolName);
        if (factory != null) {
            factory.setPoolName(rpoolName);
        }
        return pool;
    }

    public static Pool configureConnectionPool(AttributesFactory factory, String host, int[] ports, boolean establish, int redundancy, int connectionsPerServer, String serverGroup) {
        return BridgeTestCase.configureConnectionPool(factory, host, ports, establish, redundancy, connectionsPerServer, serverGroup, -1, -1, false, -2);
    }

    public static Pool configureConnectionPool(AttributesFactory factory, String host, int[] ports, boolean establish, int redundancy, int connectionsPerServer, String serverGroup, int pingInterval, int idleTimeout, boolean threadLocalCnxs, int lifetimeTimeout) {
        return BridgeTestCase.configureConnectionPoolWithName(factory, host, ports, establish, redundancy, connectionsPerServer, serverGroup, null, pingInterval, idleTimeout, threadLocalCnxs, lifetimeTimeout, -1);
    }

    public static Pool configureConnectionPool(AttributesFactory factory, String host, int[] ports, boolean establish, int redundancy, int connectionsPerServer, String serverGroup, int pingInterval, int idleTimeout, boolean threadLocalCnxs, int lifetimeTimeout, int statisticInterval) {
        return BridgeTestCase.configureConnectionPoolWithName(factory, host, ports, establish, redundancy, connectionsPerServer, serverGroup, null, pingInterval, idleTimeout, threadLocalCnxs, lifetimeTimeout, statisticInterval);
    }

    protected static String getMemberId() {
        final InternalDistributedSystem system = InternalDistributedSystem.getAnyInstance();
        DistributedTestCase.WaitCriterion w = new DistributedTestCase.WaitCriterion(){

            @Override
            public String description() {
                return "bridge never finished connecting";
            }

            @Override
            public boolean done() {
                return !system.getMemberId().contains("):0:");
            }
        };
        int waitMillis = 5000;
        int interval = 100;
        boolean throwException = true;
        BridgeTestCase.waitForCriterion(w, waitMillis, interval, throwException);
        return system.getMemberId();
    }

    protected static DistributedMember getDistributedMember() {
        InternalDistributedSystem system = InternalDistributedSystem.getAnyInstance();
        return system.getDistributedMember();
    }

    protected static Properties getSystemProperties() {
        InternalDistributedSystem system = InternalDistributedSystem.getAnyInstance();
        return system.getProperties();
    }

    public void createBridgeServer(VM vm, final String rName, final int port) {
        vm.invoke(new CacheSerializableRunnable("Create Region on Server"){

            @Override
            public void run2() {
                try {
                    AttributesFactory factory = new AttributesFactory();
                    factory.setScope(Scope.DISTRIBUTED_ACK);
                    factory.setCacheLoader((CacheLoader)new BridgeServerCacheLoader());
                    CacheTestCase.beginCacheXml();
                    BridgeTestCase.this.createRootRegion(rName, factory.create());
                    BridgeTestCase.this.startBridgeServer(port);
                    BridgeTestCase.this.finishCacheXml(rName + "-" + port);
                    Region region = BridgeTestCase.this.getRootRegion(rName);
                    TestCase.assertNotNull((Object)region);
                    region.put((Object)BridgeTestCase.BridgeServerKey, (Object)new Integer(port));
                }
                catch (Exception e) {
                    BridgeTestCase.this.getSystem().getLogWriter().severe((Throwable)e);
                    TestCase.fail((String)("Failed to start CacheServer " + e));
                }
            }
        });
    }

    public static int[] createUniquePorts(int numToCreate) {
        return AvailablePortHelper.getRandomAvailableTCPPorts(numToCreate);
    }

    public static class BridgeServerCacheLoader
    extends TestCacheLoader
    implements Declarable {
        @Override
        public Object load2(LoaderHelper helper) {
            Object ret;
            if (helper.getArgument() instanceof Integer) {
                try {
                    Thread.sleep(((Integer)helper.getArgument()).intValue());
                }
                catch (InterruptedException ugh) {
                    TestCase.fail((String)"interrupted");
                }
            }
            if ((ret = helper.getKey()) instanceof String && ret != null && ret.equals(NON_EXISTENT_KEY)) {
                return null;
            }
            return ret;
        }

        public void init(Properties props) {
        }
    }
}

