/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache30;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.UnsupportedOperationInTransactionException;
import com.gemstone.gemfire.cache.util.CacheListenerAdapter;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.cache.TXManagerImpl;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import dunit.Host;
import dunit.VM;
import junit.framework.TestCase;

public class Bug34387DUnitTest
extends CacheTestCase {
    protected transient int invokeCount;
    static volatile boolean callbackFailure;

    public Bug34387DUnitTest(String name) {
        super(name);
    }

    protected static void callbackAssertEquals(String message, Object expected, Object actual) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected != null && expected.equals(actual)) {
            return;
        }
        callbackFailure = true;
        Bug34387DUnitTest.assertEquals((String)message, (Object)expected, (Object)actual);
    }

    private VM getOtherVm() {
        Host host = Host.getHost(0);
        return host.getVM(0);
    }

    private void initOtherId() {
        VM vm = this.getOtherVm();
        vm.invoke(new CacheSerializableRunnable("Connect"){

            @Override
            public void run2() throws CacheException {
                Bug34387DUnitTest.this.getCache();
            }
        });
        vm.invoke(Bug34387DUnitTest.class, "getVMDistributedMember");
    }

    private void doCommitOtherVm(final boolean doDestroy) {
        VM vm = this.getOtherVm();
        vm.invoke(new CacheSerializableRunnable("create root"){

            @Override
            public void run2() throws CacheException {
                AttributesFactory af = new AttributesFactory();
                af.setScope(Scope.DISTRIBUTED_ACK);
                af.setConcurrencyChecksEnabled(true);
                Region r1 = Bug34387DUnitTest.this.createRootRegion("r1", af.create());
                TXManagerImpl ctm = Bug34387DUnitTest.this.getGemfireCache().getCacheTransactionManager();
                ctm.begin();
                r1.create((Object)"createKey", (Object)"createValue");
                if (doDestroy) {
                    try {
                        r1.localDestroy((Object)"createKey");
                        TestCase.fail((String)"expected exception not thrown");
                    }
                    catch (UnsupportedOperationInTransactionException e) {
                        TestCase.assertEquals((String)e.getMessage(), (String)LocalizedStrings.TXStateProxy_LOCAL_DESTROY_NOT_ALLOWED_IN_TRANSACTION.toLocalizedString());
                    }
                } else {
                    try {
                        r1.localInvalidate((Object)"createKey");
                        TestCase.fail((String)"expected exception not thrown");
                    }
                    catch (UnsupportedOperationInTransactionException e) {
                        TestCase.assertEquals((String)e.getMessage(), (String)LocalizedStrings.TXStateProxy_LOCAL_INVALIDATE_NOT_ALLOWED_IN_TRANSACTION.toLocalizedString());
                    }
                }
                ctm.commit();
                TXManagerImpl.waitForPendingCommitForTest();
            }
        });
    }

    public static DistributedMember getVMDistributedMember() {
        return InternalDistributedSystem.getAnyInstance().getDistributedMember();
    }

    public void testDummy() {
    }

    public void Bug44146_testCreateAndLD() throws CacheException {
        this.initOtherId();
        AttributesFactory af = new AttributesFactory();
        af.setDataPolicy(DataPolicy.REPLICATE);
        af.setScope(Scope.DISTRIBUTED_ACK);
        af.setConcurrencyChecksEnabled(true);
        callbackFailure = false;
        CacheListenerAdapter cl1 = new CacheListenerAdapter(){

            public void afterCreate(EntryEvent e) {
                Bug34387DUnitTest.callbackAssertEquals("Keys not equal", "createKey", e.getKey());
                Bug34387DUnitTest.callbackAssertEquals("Values not equal", "createValue", e.getNewValue());
                ++Bug34387DUnitTest.this.invokeCount;
            }
        };
        af.addCacheListener((CacheListener)cl1);
        Region r1 = this.createRootRegion("r1", af.create());
        this.invokeCount = 0;
        Bug34387DUnitTest.assertNull((Object)r1.getEntry((Object)"createKey"));
        this.doCommitOtherVm(true);
        Bug34387DUnitTest.assertNotNull((Object)r1.getEntry((Object)"createKey"));
        Bug34387DUnitTest.assertEquals((Object)"createValue", (Object)r1.getEntry((Object)"createKey").getValue());
        Bug34387DUnitTest.assertEquals((int)1, (int)this.invokeCount);
        Bug34387DUnitTest.assertFalse((String)"Errors in callbacks; check logs for details", (boolean)callbackFailure);
    }

    public void Bug44146_testCreateAndLI() throws CacheException {
        this.initOtherId();
        AttributesFactory af = new AttributesFactory();
        af.setDataPolicy(DataPolicy.REPLICATE);
        af.setScope(Scope.DISTRIBUTED_ACK);
        af.setConcurrencyChecksEnabled(true);
        callbackFailure = false;
        CacheListenerAdapter cl1 = new CacheListenerAdapter(){

            public void afterCreate(EntryEvent e) {
                Bug34387DUnitTest.callbackAssertEquals("key not equal", "createKey", e.getKey());
                Bug34387DUnitTest.callbackAssertEquals("value not equal", "createValue", e.getNewValue());
                ++Bug34387DUnitTest.this.invokeCount;
            }
        };
        af.addCacheListener((CacheListener)cl1);
        Region r1 = this.createRootRegion("r1", af.create());
        this.invokeCount = 0;
        Bug34387DUnitTest.assertNull((Object)r1.getEntry((Object)"createKey"));
        this.doCommitOtherVm(false);
        Bug34387DUnitTest.assertNotNull((Object)r1.getEntry((Object)"createKey"));
        Bug34387DUnitTest.assertEquals((Object)"createValue", (Object)r1.getEntry((Object)"createKey").getValue());
        Bug34387DUnitTest.assertEquals((int)1, (int)this.invokeCount);
        Bug34387DUnitTest.assertFalse((String)"Errors in callbacks; check logs for details", (boolean)callbackFailure);
    }
}

