/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache30;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.CacheLoader;
import com.gemstone.gemfire.cache.CacheLoaderException;
import com.gemstone.gemfire.cache.CacheWriter;
import com.gemstone.gemfire.cache.LoaderHelper;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.cache30.TestCacheCallback;
import com.gemstone.gemfire.cache30.TestCacheListener;
import com.gemstone.gemfire.cache30.TestCacheLoader;
import com.gemstone.gemfire.cache30.TestCacheWriter;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;

public class CacheCloseTest
extends CacheTestCase {
    public CacheCloseTest(String name) {
        super(name);
    }

    private RegionAttributes createAtts(List callbacks) {
        AttributesFactory factory = new AttributesFactory();
        TestCacheListener listener = new TestCacheListener(){};
        callbacks.add(listener);
        factory.setCacheListener((CacheListener)listener);
        TestCacheWriter writer = new TestCacheWriter(){};
        callbacks.add(writer);
        factory.setCacheWriter((CacheWriter)writer);
        TestCacheLoader loader = new TestCacheLoader(){

            @Override
            public Object load2(LoaderHelper helper) throws CacheLoaderException {
                TestCase.fail((String)"load2 should not be called by this test");
                return null;
            }

            @Override
            public void close2() {
                throw new RuntimeException("make sure exceptions from close callbacks are logged and ignored");
            }
        };
        callbacks.add(loader);
        factory.setCacheLoader((CacheLoader)loader);
        return factory.create();
    }

    public void testCallbacksClosed() throws CacheException {
        ArrayList callbacks = new ArrayList();
        Region r = this.createRootRegion(this.createAtts(callbacks));
        r.createSubregion("testCallbacksClosed", this.createAtts(callbacks));
        CacheCloseTest.closeCache();
        for (TestCacheCallback listener : callbacks) {
            CacheCloseTest.assertTrue((String)("listener not invoked: " + listener), (boolean)listener.isClosed());
        }
        AttributesFactory factory = new AttributesFactory();
        this.createRootRegion(factory.create());
    }
}

