/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache30;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.CacheLoader;
import com.gemstone.gemfire.cache.CacheLoaderException;
import com.gemstone.gemfire.cache.CacheWriter;
import com.gemstone.gemfire.cache.CacheWriterException;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.LoaderHelper;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.TimeoutException;
import com.gemstone.gemfire.cache30.CacheWriterTestCase;
import com.gemstone.gemfire.cache30.TestCacheListener;
import com.gemstone.gemfire.cache30.TestCacheLoader;
import com.gemstone.gemfire.cache30.TestCacheWriter;
import dunit.DistributedTestCase;
import junit.framework.TestCase;

public abstract class CacheLoaderTestCase
extends CacheWriterTestCase {
    public CacheLoaderTestCase(String name) {
        super(name);
    }

    public void testCacheLoader() throws CacheException {
        final String name = this.getUniqueName();
        final String key = this.getUniqueName();
        final Integer value = new Integer(42);
        final String arg = "ARG";
        String exception = "EXCEPTION";
        TestCacheLoader loader = new TestCacheLoader(){

            @Override
            public Object load2(LoaderHelper helper) throws CacheLoaderException {
                TestCase.assertEquals((Object)key, (Object)helper.getKey());
                TestCase.assertEquals((String)name, (String)helper.getRegion().getName());
                try {
                    RegionAttributes attrs = helper.getRegion().getAttributes();
                    if (attrs.getScope().isDistributed()) {
                        TestCase.assertNull((Object)helper.netSearch(false));
                        TestCase.assertNull((Object)helper.netSearch(true));
                    }
                }
                catch (TimeoutException ex) {
                    DistributedTestCase.fail("Why did I time out?", ex);
                }
                Object argument = helper.getArgument();
                if (argument != null) {
                    if (argument.equals("EXCEPTION")) {
                        String s = "Test Exception";
                        throw new CacheLoaderException(s);
                    }
                    TestCase.assertEquals((Object)arg, (Object)argument);
                }
                return value;
            }
        };
        AttributesFactory factory = new AttributesFactory(this.getRegionAttributes());
        factory.setCacheLoader((CacheLoader)loader);
        Region region = this.createRegion(name, factory.create());
        loader.wasInvoked();
        Region.Entry entry = region.getEntry((Object)key);
        CacheLoaderTestCase.assertNull((Object)entry);
        region.create((Object)key, null);
        entry = region.getEntry((Object)key);
        CacheLoaderTestCase.assertNotNull((Object)entry);
        CacheLoaderTestCase.assertNull((Object)entry.getValue());
        CacheLoaderTestCase.assertEquals((Object)value, (Object)region.get((Object)key));
        CacheLoaderTestCase.assertTrue((boolean)loader.wasInvoked());
        CacheLoaderTestCase.assertEquals((Object)value, (Object)region.getEntry((Object)key).getValue());
    }

    public void testCacheLoaderNull() throws CacheException {
        TestCacheLoader loader = new TestCacheLoader(){

            @Override
            public Object load2(LoaderHelper helper) throws CacheLoaderException {
                return null;
            }
        };
        AttributesFactory factory = new AttributesFactory(this.getRegionAttributes());
        factory.setCacheLoader((CacheLoader)loader);
        String name = this.getUniqueName();
        Region region = this.createRegion(name, factory.create());
        loader.wasInvoked();
        CacheLoaderTestCase.assertNull((Object)region.get((Object)"KEY"));
        CacheLoaderTestCase.assertTrue((boolean)loader.wasInvoked());
    }

    public void testCacheWriterOnLoad() throws CacheException {
        String name = this.getUniqueName();
        String key = this.getUniqueName();
        final Integer oldValue = new Integer(42);
        final Integer newValue = new Integer(43);
        TestCacheLoader loader = new TestCacheLoader(){

            @Override
            public Object load2(LoaderHelper helper) throws CacheLoaderException {
                return oldValue;
            }
        };
        TestCacheWriter writer = new TestCacheWriter(){

            @Override
            public void beforeCreate2(EntryEvent event) throws CacheWriterException {
                TestCase.assertEquals((Object)oldValue, (Object)event.getNewValue());
                TestCase.assertTrue((boolean)event.isLoad());
                TestCase.assertTrue((boolean)event.isLocalLoad());
                TestCase.assertFalse((boolean)event.isNetLoad());
                TestCase.assertFalse((boolean)event.isNetSearch());
            }
        };
        AttributesFactory factory = new AttributesFactory(this.getRegionAttributes());
        factory.setCacheLoader((CacheLoader)loader);
        factory.setCacheWriter((CacheWriter)writer);
        Region region = this.createRegion(name, factory.create());
        loader.wasInvoked();
        CacheLoaderTestCase.assertEquals((Object)oldValue, (Object)region.get((Object)key));
        CacheLoaderTestCase.assertTrue((boolean)loader.wasInvoked());
        CacheLoaderTestCase.assertTrue((boolean)writer.wasInvoked());
        writer = new TestCacheWriter(){

            @Override
            public void beforeUpdate2(EntryEvent event) throws CacheWriterException {
                TestCase.assertEquals((Object)oldValue, (Object)event.getOldValue());
                TestCase.assertEquals((Object)newValue, (Object)event.getNewValue());
                TestCase.assertFalse((boolean)event.isLoad());
                TestCase.assertFalse((boolean)event.isLocalLoad());
                TestCase.assertFalse((boolean)event.isNetLoad());
                TestCase.assertFalse((boolean)event.isNetSearch());
            }
        };
        region.getAttributesMutator().setCacheWriter((CacheWriter)writer);
        region.put((Object)key, (Object)newValue);
        CacheLoaderTestCase.assertFalse((boolean)loader.wasInvoked());
        CacheLoaderTestCase.assertTrue((boolean)writer.wasInvoked());
    }

    public void testCacheListenerOnLoad() throws CacheException, InterruptedException {
        String name = this.getUniqueName();
        String key = this.getUniqueName();
        final Integer oldValue = new Integer(42);
        final Integer newValue = new Integer(43);
        TestCacheLoader loader = new TestCacheLoader(){

            @Override
            public Object load2(LoaderHelper helper) throws CacheLoaderException {
                return oldValue;
            }
        };
        TestCacheListener listener = new TestCacheListener(){

            @Override
            public void afterCreate2(EntryEvent event) {
                TestCase.assertEquals((Object)oldValue, (Object)event.getNewValue());
                TestCase.assertTrue((boolean)event.isLoad());
                TestCase.assertTrue((boolean)event.isLocalLoad());
                TestCase.assertFalse((boolean)event.isNetLoad());
                TestCase.assertFalse((boolean)event.isNetSearch());
            }
        };
        AttributesFactory factory = new AttributesFactory(this.getRegionAttributes());
        factory.setCacheLoader((CacheLoader)loader);
        factory.setCacheListener((CacheListener)listener);
        Region region = this.createRegion(name, factory.create());
        loader.wasInvoked();
        CacheLoaderTestCase.assertEquals((Object)oldValue, (Object)region.get((Object)key));
        CacheLoaderTestCase.assertTrue((boolean)loader.wasInvoked());
        CacheLoaderTestCase.pause(500);
        CacheLoaderTestCase.assertTrue((boolean)listener.wasInvoked());
        listener = new TestCacheListener(){

            @Override
            public void afterUpdate2(EntryEvent event) {
                TestCase.assertEquals((Object)oldValue, (Object)event.getOldValue());
                TestCase.assertEquals((Object)newValue, (Object)event.getNewValue());
                TestCase.assertFalse((boolean)event.isLoad());
                TestCase.assertFalse((boolean)event.isLocalLoad());
                TestCase.assertFalse((boolean)event.isNetLoad());
                TestCase.assertFalse((boolean)event.isNetSearch());
            }
        };
        region.getAttributesMutator().setCacheListener((CacheListener)listener);
        region.put((Object)key, (Object)newValue);
        CacheLoaderTestCase.pause(500);
        CacheLoaderTestCase.assertFalse((boolean)loader.wasInvoked());
        CacheLoaderTestCase.assertTrue((boolean)listener.wasInvoked());
    }
}

