/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache30;

import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Properties;
import java.util.regex.Pattern;

public class CacheLogRollTest
extends CacheTestCase {
    public CacheLogRollTest(String name) {
        super(name);
    }

    private void logAndRollAndVerify(String baseLogName, DistributedSystem ds, String mainId) throws FileNotFoundException, IOException {
        String logfile = baseLogName + ".log";
        String metaLogFile = "meta-" + baseLogName + "-" + mainId + ".log";
        String rolledLogFile1 = baseLogName + "-" + mainId + "-01.log";
        String rolledLogFile2 = baseLogName + "-" + mainId + "-02.log";
        String META_MARKER_1 = "Switching to log " + baseLogName + ".log";
        String META_MARKER_2 = "Rolling current log to " + baseLogName + "-" + mainId + "-01.log";
        String META_MARKER_3 = "Rolling current log to " + baseLogName + "-" + mainId + "-02.log";
        String FIRST_CHILD_MARKER = "hey guys im the first child whatsup";
        String LOG_NONSENSE = "what is your story what are you doing hey whatsup i can't believe it wow";
        System.out.println("LOGNAME:" + logfile);
        ds.getLogWriter().info(FIRST_CHILD_MARKER);
        File f = new File(logfile);
        CacheLogRollTest.assertTrue((String)("log-file :" + logfile + " should exist"), (boolean)f.exists());
        File fm = new File(metaLogFile);
        CacheLogRollTest.assertTrue((String)("meta-log-file :" + metaLogFile + " should exist"), (boolean)fm.exists());
        File f1 = new File(rolledLogFile1);
        CacheLogRollTest.assertTrue((String)("child-log-file :" + rolledLogFile1 + " should'nt exist"), (!f1.exists() ? 1 : 0) != 0);
        File f2 = new File(rolledLogFile2);
        CacheLogRollTest.assertTrue((String)("child-log-file2 :" + rolledLogFile2 + " should'nt exist yet"), (!f2.exists() ? 1 : 0) != 0);
        String metalog = this.getLogContents(metaLogFile);
        CacheLogRollTest.assertTrue((String)("metalog(" + metaLogFile + ") should have " + META_MARKER_1 + " in it:\n" + metalog), (metalog.indexOf(META_MARKER_1) != -1 ? 1 : 0) != 0);
        String mainlog = this.getLogContents(logfile);
        CacheLogRollTest.assertTrue((String)("log(" + logfile + ") should have " + FIRST_CHILD_MARKER + " in it:\n" + mainlog), (mainlog.indexOf(FIRST_CHILD_MARKER) != -1 ? 1 : 0) != 0);
        for (int i = 0; i < 100000 && !f2.exists(); ++i) {
            ds.getLogWriter().info(LOG_NONSENSE);
        }
        CacheLogRollTest.assertTrue((String)("child-log-file1 :" + rolledLogFile1 + " should exist now"), (boolean)f1.exists());
        CacheLogRollTest.assertTrue((String)("child-log-file2 :" + rolledLogFile2 + " should exist now"), (boolean)f2.exists());
        metalog = this.getLogContents(metaLogFile);
        CacheLogRollTest.assertTrue((String)("log(" + metaLogFile + ") should have " + META_MARKER_2 + " in it:\n" + metalog), (metalog.indexOf(META_MARKER_2) != -1 ? 1 : 0) != 0);
        CacheLogRollTest.assertTrue((String)("log(" + metaLogFile + ") should have " + META_MARKER_3 + " in it:\n" + metalog), (metalog.indexOf(META_MARKER_3) != -1 ? 1 : 0) != 0);
        CacheLogRollTest.assertTrue((String)("log(" + metaLogFile + ") should'nt have " + LOG_NONSENSE + " in it:\n" + metalog), (metalog.indexOf(LOG_NONSENSE) == -1 ? 1 : 0) != 0);
        String logChild2 = this.getLogContents(logfile);
        CacheLogRollTest.assertTrue((String)("log(" + logfile + ") should have " + LOG_NONSENSE + " in it:\n" + logChild2), (logChild2.indexOf(LOG_NONSENSE) != -1 ? 1 : 0) != 0);
        logChild2 = this.getLogContents(rolledLogFile1);
        CacheLogRollTest.assertTrue((String)("log(" + rolledLogFile1 + ") should have " + LOG_NONSENSE + " in it:\n" + logChild2), (logChild2.indexOf(LOG_NONSENSE) != -1 ? 1 : 0) != 0);
        logChild2 = this.getLogContents(rolledLogFile2);
        CacheLogRollTest.assertTrue((String)("log(" + rolledLogFile2 + ") should have " + LOG_NONSENSE + " in it:\n" + logChild2), (logChild2.indexOf(LOG_NONSENSE) != -1 ? 1 : 0) != 0);
    }

    private void SecurityLogAndRollAndVerify(String baseLogName, DistributedSystem ds, String mainId) throws FileNotFoundException, IOException {
        String logfile = baseLogName + ".log";
        String sec_logfile = "sec_" + logfile;
        String metaLogFile = "meta-" + baseLogName + "-" + mainId + ".log";
        String rolledLogFile1 = baseLogName + "-" + mainId + "-01.log";
        String rolledLogFile2 = baseLogName + "-" + mainId + "-02.log";
        String rolledSecLogFile1 = "sec_" + baseLogName + "-" + mainId + "-01.log";
        String rolledSecLogFile2 = "sec_" + baseLogName + "-" + mainId + "-02.log";
        String META_MARKER_1 = "Switching to log " + baseLogName + ".log";
        String META_MARKER_2 = "Rolling current log to " + baseLogName + "-" + mainId + "-01.log";
        String META_MARKER_3 = "Rolling current log to " + baseLogName + "-" + mainId + "-02.log";
        String FIRST_CHILD_MARKER = "hey guys im the first child whatsup";
        String LOG_NONSENSE = "what is your story what are you doing hey whatsup i can't believe it wow";
        System.out.println("LOGNAME:" + logfile + ", SECLOGNAME:" + sec_logfile);
        ds.getLogWriter().info(FIRST_CHILD_MARKER);
        ds.getSecurityLogWriter().info(FIRST_CHILD_MARKER);
        File f = new File(logfile);
        File sec_f = new File(sec_logfile);
        CacheLogRollTest.assertTrue((String)("log-file :" + logfile + " should exist"), (boolean)f.exists());
        CacheLogRollTest.assertTrue((String)("security-log-file :" + sec_logfile + " should exist"), (boolean)sec_f.exists());
        File fm = new File(metaLogFile);
        CacheLogRollTest.assertTrue((String)("meta-log-file :" + metaLogFile + " should exist"), (boolean)fm.exists());
        File f1 = new File(rolledLogFile1);
        File sec_f1 = new File(rolledSecLogFile1);
        CacheLogRollTest.assertTrue((String)("child-log-file :" + rolledLogFile1 + " should'nt exist"), (!f1.exists() ? 1 : 0) != 0);
        CacheLogRollTest.assertTrue((String)("security-child-log-file :" + rolledLogFile1 + " should'nt exist"), (!sec_f1.exists() ? 1 : 0) != 0);
        File f2 = new File(rolledLogFile2);
        File sec_f2 = new File(rolledSecLogFile2);
        CacheLogRollTest.assertTrue((String)("child-log-file2 :" + rolledLogFile2 + " should'nt exist yet"), (!f2.exists() ? 1 : 0) != 0);
        CacheLogRollTest.assertTrue((String)("security-child-log-file2 :" + rolledSecLogFile2 + " should'nt exist yet"), (!sec_f2.exists() ? 1 : 0) != 0);
        String metalog = this.getLogContents(metaLogFile);
        CacheLogRollTest.assertTrue((String)("metalog(" + metaLogFile + ") should have " + META_MARKER_1 + " in it:\n" + metalog), (metalog.indexOf(META_MARKER_1) != -1 ? 1 : 0) != 0);
        String mainlog = this.getLogContents(logfile);
        CacheLogRollTest.assertTrue((String)("log(" + logfile + ") should have " + FIRST_CHILD_MARKER + " in it:\n" + mainlog), (mainlog.indexOf(FIRST_CHILD_MARKER) != -1 ? 1 : 0) != 0);
        String sec_mainlog = this.getLogContents(sec_logfile);
        CacheLogRollTest.assertTrue((String)("log(" + sec_logfile + ") should have " + FIRST_CHILD_MARKER + " in it:\n" + sec_mainlog), (sec_mainlog.indexOf(FIRST_CHILD_MARKER) != -1 ? 1 : 0) != 0);
        for (int i = 0; i < 100000 && !f2.exists(); ++i) {
            ds.getLogWriter().info(LOG_NONSENSE);
        }
        for (int j = 0; j < 100000 && !sec_f2.exists(); ++j) {
            ds.getSecurityLogWriter().info(LOG_NONSENSE);
        }
        CacheLogRollTest.assertTrue((String)("child-log-file1 :" + rolledLogFile1 + " should exist now"), (boolean)f1.exists());
        CacheLogRollTest.assertTrue((String)("child-log-file2 :" + rolledLogFile2 + " should exist now"), (boolean)f2.exists());
        CacheLogRollTest.assertTrue((String)("security-child-log-file1 :" + rolledSecLogFile1 + " should exist now"), (boolean)sec_f1.exists());
        CacheLogRollTest.assertTrue((String)("security-child-log-file2 :" + rolledSecLogFile2 + " should exist now"), (boolean)sec_f2.exists());
        metalog = this.getLogContents(metaLogFile);
        CacheLogRollTest.assertTrue((String)("log(" + metaLogFile + ") should have " + META_MARKER_2 + " in it:\n" + metalog), (metalog.indexOf(META_MARKER_2) != -1 ? 1 : 0) != 0);
        CacheLogRollTest.assertTrue((String)("log(" + metaLogFile + ") should have " + META_MARKER_3 + " in it:\n" + metalog), (metalog.indexOf(META_MARKER_3) != -1 ? 1 : 0) != 0);
        CacheLogRollTest.assertTrue((String)("log(" + metaLogFile + ") should'nt have " + LOG_NONSENSE + " in it:\n" + metalog), (metalog.indexOf(LOG_NONSENSE) == -1 ? 1 : 0) != 0);
        String logChild2 = this.getLogContents(logfile);
        CacheLogRollTest.assertTrue((String)("log(" + logfile + ") should have " + LOG_NONSENSE + " in it:\n" + logChild2), (logChild2.indexOf(LOG_NONSENSE) != -1 ? 1 : 0) != 0);
        String sec_logChild2 = this.getLogContents(sec_logfile);
        CacheLogRollTest.assertTrue((String)("log(" + sec_logfile + ") should have " + LOG_NONSENSE + " in it:\n" + sec_logChild2), (sec_logChild2.indexOf(LOG_NONSENSE) != -1 ? 1 : 0) != 0);
        logChild2 = this.getLogContents(rolledLogFile1);
        CacheLogRollTest.assertTrue((String)("log(" + rolledLogFile1 + ") should have " + LOG_NONSENSE + " in it:\n" + logChild2), (logChild2.indexOf(LOG_NONSENSE) != -1 ? 1 : 0) != 0);
        sec_logChild2 = this.getLogContents(rolledSecLogFile1);
        CacheLogRollTest.assertTrue((String)("log(" + rolledSecLogFile1 + ") should have " + LOG_NONSENSE + " in it:\n" + sec_logChild2), (sec_logChild2.indexOf(LOG_NONSENSE) != -1 ? 1 : 0) != 0);
        logChild2 = this.getLogContents(rolledLogFile2);
        CacheLogRollTest.assertTrue((String)("log(" + rolledLogFile2 + ") should have " + LOG_NONSENSE + " in it:\n" + logChild2), (logChild2.indexOf(LOG_NONSENSE) != -1 ? 1 : 0) != 0);
        sec_logChild2 = this.getLogContents(rolledSecLogFile2);
        CacheLogRollTest.assertTrue((String)("log(" + rolledSecLogFile2 + ") should have " + LOG_NONSENSE + " in it:\n" + sec_logChild2), (sec_logChild2.indexOf(LOG_NONSENSE) != -1 ? 1 : 0) != 0);
    }

    public void testDiskSpace() throws Exception {
        Properties props = new Properties();
        String baseLogName = "diskarito";
        String logfile = baseLogName + ".log";
        props.put("log-file", logfile);
        props.put("log-file-size-limit", "1");
        InternalDistributedSystem ds = this.getSystem(props);
        props.put("log-disk-space-limit", "200");
        for (int i = 0; i < 10; ++i) {
            ds = this.getSystem(props);
            ds.disconnect();
        }
    }

    public void testSimpleStartRestartWithRolling() throws Exception {
        Properties props = new Properties();
        String baseLogName = "restarto";
        String logfile = baseLogName + ".log";
        props.put("log-file", logfile);
        props.put("log-file-size-limit", "1");
        props.put("log-disk-space-limit", "200");
        this.getSystem(props).disconnect();
        final Pattern mainIdPattern = Pattern.compile("meta-" + baseLogName + "-\\d\\d.log");
        File[] metaLogs = new File(".").listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File d, String name) {
                return mainIdPattern.matcher(name).matches();
            }
        });
        CacheLogRollTest.assertEquals((int)1, (int)metaLogs.length);
        String f = metaLogs[0].getName();
        int idx = f.lastIndexOf("-");
        int idx2 = f.lastIndexOf(".");
        String mainId = f.substring(idx + 1, idx2);
        String metaName = "meta-" + baseLogName + "-" + mainId + ".log";
        File fm = new File(metaName);
        CacheLogRollTest.assertTrue((String)("Ok so metalog:" + metaName + " better exist:"), (boolean)fm.exists());
        for (int i = 1; i < 10; ++i) {
            int mainInt = Integer.parseInt(mainId) + i;
            String myid = mainInt < 10 ? "0" + mainInt : "" + mainInt;
            String oldMain = mainInt < 11 ? "0" + (mainInt - 1) : "" + (mainInt - 1);
            String lfold = "meta-" + baseLogName + "-" + oldMain + ".log";
            File fold = new File(lfold);
            CacheLogRollTest.assertTrue((String)("before we even get going here[" + i + "] mainInt:" + mainInt + " myid:" + myid + " " + lfold + " should exist the metaname was :" + metaName + " and it should match that"), (boolean)fold.exists());
            String lf = "meta-" + baseLogName + "-" + myid + ".log";
            String lfl = baseLogName + "-" + oldMain + "-01.log";
            File f1m = new File(lf);
            File f1l = new File(lfl);
            CacheLogRollTest.assertTrue((!f1m.exists() ? 1 : 0) != 0);
            CacheLogRollTest.assertTrue((!f1l.exists() ? 1 : 0) != 0);
            InternalDistributedSystem ds = this.getSystem(props);
            CacheLogRollTest.assertTrue((String)("We are hoping that:" + lf + " exists"), (boolean)f1m.exists());
            CacheLogRollTest.assertTrue((String)("We are hoping that:" + lfl + " exists"), (boolean)f1l.exists());
            ds.disconnect();
        }
    }

    public void testStartWithRollingThenRestartWithRolling() throws Exception {
        Properties props = new Properties();
        String baseLogName = "biscuits";
        String logfile = baseLogName + ".log";
        props.put("log-file", logfile);
        props.put("log-file-size-limit", "1");
        InternalDistributedSystem ds = this.getSystem(props);
        final Pattern mainIdPattern = Pattern.compile("meta-" + baseLogName + "-\\d\\d.log");
        File[] metaLogs = new File(".").listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File d, String name) {
                return mainIdPattern.matcher(name).matches();
            }
        });
        CacheLogRollTest.assertEquals((int)1, (int)metaLogs.length);
        String f = metaLogs[0].getName();
        int idx = f.lastIndexOf("-");
        int idx2 = f.lastIndexOf(".");
        String mainId = f.substring(idx + 1, idx2);
        this.logAndRollAndVerify(baseLogName, (DistributedSystem)ds, mainId);
        int dsId = System.identityHashCode(ds);
        props.put("log-disk-space-limit", "200");
        File f1m = new File(logfile);
        CacheLogRollTest.assertTrue((boolean)f1m.exists());
        File f1c1 = new File(baseLogName + "-" + mainId + "-01.log");
        CacheLogRollTest.assertTrue((boolean)f1c1.exists());
        File f1c2 = new File(baseLogName + "-" + mainId + "-02.log");
        CacheLogRollTest.assertTrue((boolean)f1c2.exists());
        File f1c3 = new File(baseLogName + "-" + mainId + "-03.log");
        CacheLogRollTest.assertTrue((!f1c3.exists() ? 1 : 0) != 0);
        int mId = Integer.parseInt(mainId);
        StringBuffer sb = new StringBuffer();
        if (++mId < 10) {
            sb.append('0');
        }
        sb.append(mId);
        String nextMainId = sb.toString();
        File f2c1 = new File(baseLogName + "-" + nextMainId + "-01.log");
        CacheLogRollTest.assertTrue((!f2c1.exists() ? 1 : 0) != 0);
        ds = this.getSystem(props);
        int dsId2 = System.identityHashCode(ds);
        CacheLogRollTest.assertTrue((String)"This should be a new ds!", (dsId != dsId2 ? 1 : 0) != 0);
        CacheLogRollTest.assertTrue((boolean)f1c3.exists());
    }

    public void testLogFileLayoutAndRolling() throws Exception {
        String baseLogName = "tacos";
        Properties props = new Properties();
        String logfile = baseLogName + ".log";
        props.put("log-file", logfile);
        props.put("log-file-size-limit", "1");
        InternalDistributedSystem ds = this.getSystem(props);
        final Pattern mainIdPattern = Pattern.compile("meta-" + baseLogName + "-\\d+.log");
        File[] metaLogs = new File(".").listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File d, String name) {
                return mainIdPattern.matcher(name).matches();
            }
        });
        CacheLogRollTest.assertEquals((int)1, (int)metaLogs.length);
        String f = metaLogs[0].getName();
        int idx = f.lastIndexOf("-");
        int idx2 = f.lastIndexOf(".");
        String mainId = f.substring(idx + 1, idx2);
        ds.getProperties();
        this.logAndRollAndVerify(baseLogName, (DistributedSystem)ds, mainId);
    }

    public void testSecurityLogFileLayoutAndRolling() throws Exception {
        String baseLogName = "securitytacos";
        Properties props = new Properties();
        String logfile = baseLogName + ".log";
        String sec_logfile = "sec_" + baseLogName + ".log";
        props.put("log-file", logfile);
        props.put("log-file-size-limit", "1");
        props.put("security-log-file", sec_logfile);
        props.put("security-log-level", CacheLogRollTest.getDUnitLogLevel());
        InternalDistributedSystem ds = this.getSystem(props);
        final Pattern mainIdPattern = Pattern.compile("meta-" + baseLogName + "-\\d+.log");
        File[] metaLogs = new File(".").listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File d, String name) {
                return mainIdPattern.matcher(name).matches();
            }
        });
        CacheLogRollTest.assertEquals((int)1, (int)metaLogs.length);
        String f = metaLogs[0].getName();
        int idx = f.lastIndexOf("-");
        int idx2 = f.lastIndexOf(".");
        String mainId = f.substring(idx + 1, idx2);
        ds.getProperties();
        this.SecurityLogAndRollAndVerify(baseLogName, (DistributedSystem)ds, mainId);
    }

    String getLogContents(String logfile) throws FileNotFoundException, IOException {
        File f = new File(logfile);
        BufferedReader reader = new BufferedReader(new FileReader(f));
        StringBuffer fileData = new StringBuffer();
        int numRead = 0;
        char[] buf = new char[1024];
        while ((numRead = reader.read(buf)) != -1) {
            String readData = String.valueOf(buf, 0, numRead);
            fileData.append(readData);
            buf = new char[1024];
        }
        return fileData.toString();
    }
}

