/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache30;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.CacheTransactionManager;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.distributed.DistributedSystem;
import dunit.AsyncInvocation;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.VM;
import java.io.Serializable;
import java.util.Properties;
import java.util.Set;

public class CacheMapTxnDUnitTest
extends DistributedTestCase {
    static Cache cache;
    static Properties props;
    static DistributedSystem ds;
    static Region region;
    static Region mirroredRegion;
    static CacheTransactionManager cacheTxnMgr;

    public CacheMapTxnDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        vm0.invoke(CacheMapTxnDUnitTest.class, "createCache");
        vm1.invoke(CacheMapTxnDUnitTest.class, "createCache");
    }

    @Override
    public void tearDown2() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        vm0.invoke(CacheMapTxnDUnitTest.class, "closeCache");
        vm1.invoke(CacheMapTxnDUnitTest.class, "closeCache");
    }

    public static void createCache() {
        try {
            ds = new CacheMapTxnDUnitTest("temp").getSystem(props);
            cache = CacheFactory.create((DistributedSystem)ds);
            AttributesFactory factory = new AttributesFactory();
            factory.setScope(Scope.DISTRIBUTED_ACK);
            factory.setDataPolicy(DataPolicy.REPLICATE);
            RegionAttributes attr = factory.create();
            region = cache.createRegion("map", attr);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void closeCache() {
        try {
            cache.close();
            ds.disconnect();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void testCommitTxn() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        vm0.invoke(CacheMapTxnDUnitTest.class, "commitTxn");
    }

    public void testRollbackTxn() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        vm0.invoke(CacheMapTxnDUnitTest.class, "rollbackTxn");
    }

    public void testRollbackTxnClear() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        int i = 0;
        Object[] objArr = new Object[1];
        for (i = 0; i < 5; ++i) {
            objArr[0] = "" + i;
            vm1.invoke(CacheMapTxnDUnitTest.class, "putMethod", objArr);
        }
        vm0.invoke(CacheMapTxnDUnitTest.class, "rollbackTxnClear");
        i = 3;
        objArr[0] = "" + i;
        Object ob2 = vm1.invoke(CacheMapTxnDUnitTest.class, "getMethod", objArr);
        if (ob2 != null) {
            CacheMapTxnDUnitTest.fail((String)"failed in testRollbackTxnClear");
        }
    }

    public void testMiscMethods() throws Throwable {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        vm0.invoke(CacheMapTxnDUnitTest.class, "miscMethodsOwner");
        AsyncInvocation o2 = vm0.invokeAsync(CacheMapTxnDUnitTest.class, "miscMethodsNotOwner");
        AsyncInvocation o3 = vm1.invokeAsync(CacheMapTxnDUnitTest.class, "miscMethodsNotOwner");
        DistributedTestCase.join(o2, 30000L, CacheMapTxnDUnitTest.getLogWriter());
        DistributedTestCase.join(o3, 30000L, CacheMapTxnDUnitTest.getLogWriter());
        if (o2.exceptionOccurred()) {
            CacheMapTxnDUnitTest.fail("o2 failed", o2.getException());
        }
        if (o3.exceptionOccurred()) {
            CacheMapTxnDUnitTest.fail("o3 failed", o3.getException());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void commitTxn() {
        try {
            boolean val;
            boolean succeeded;
            boolean flag;
            cacheTxnMgr = cache.getCacheTransactionManager();
            int[] i = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
            Object o3 = "init";
            region.put((Object)("" + i[0]), (Object)"zero");
            region.create((Object)("" + i[5]), (Object)"fifth");
            cacheTxnMgr.begin();
            region.put((Object)("" + i[1]), (Object)"first");
            o3 = region.get((Object)("" + i[1]));
            if (!o3.toString().equals("first")) {
                CacheMapTxnDUnitTest.fail((String)"get inside transaction returns incorrect object");
            }
            region.put((Object)("" + i[2]), (Object)"second");
            o3 = region.remove((Object)("" + i[2]));
            if (!o3.toString().equals("second")) {
                CacheMapTxnDUnitTest.fail((String)"remove inside transaction returns incorrect object");
            }
            if (flag = region.containsKey((Object)("" + i[2]))) {
                CacheMapTxnDUnitTest.fail((String)"region.containsKey after region.remove inside txn returns incorrect value");
            }
            region.put((Object)("" + i[3]), (Object)"third");
            region.put((Object)("" + i[0]), (Object)"updatedZero");
            region.putIfAbsent((Object)("" + i[4]), (Object)"fourth");
            if (!region.get((Object)("" + i[4])).toString().equals("fourth")) {
                CacheMapTxnDUnitTest.fail((String)"putIfAbsent inside transaction returns incorrect object");
            }
            region.replace((Object)("" + i[4]), (Object)"fourth2");
            if (!region.get((Object)("" + i[4])).toString().equals("fourth2")) {
                CacheMapTxnDUnitTest.fail((String)"replace inside transaction returns incorrect object)");
            }
            region.replace((Object)("" + i[4]), (Object)"fourth2", (Object)"fourth3");
            if (!region.get((Object)("" + i[4])).toString().equals("fourth3")) {
                CacheMapTxnDUnitTest.fail((String)"replace inside transaction returns incorrect object)");
            }
            CacheMapTxnDUnitTest.assertTrue((!(succeeded = region.remove((Object)("" + i[5]), (Object)new Serializable(){})) ? 1 : 0) != 0);
            CacheMapTxnDUnitTest.assertTrue((boolean)region.get((Object)("" + i[5])).equals("fifth"));
            region.remove((Object)("" + i[5]));
            cacheTxnMgr.commit();
            o3 = region.get((Object)("" + i[1]));
            if (!o3.toString().equals("first")) {
                CacheMapTxnDUnitTest.fail((String)"get after committed transaction returns incorrect object");
            }
            if ((o3 = region.get((Object)("" + i[2]))) != null) {
                CacheMapTxnDUnitTest.fail((String)"get after committed transaction returns incorrect object");
            }
            if (!(o3 = region.get((Object)("" + i[3]))).toString().equals("third")) {
                CacheMapTxnDUnitTest.fail((String)"get after committed transaction returns incorrect object");
            }
            if (!region.get((Object)("" + i[4])).toString().equals("fourth3")) {
                CacheMapTxnDUnitTest.fail((String)"get after committed transaction returns incorrect object");
            }
            if (region.containsKey((Object)("" + i[5]))) {
                CacheMapTxnDUnitTest.fail((String)"containsKey after committed transaction was true");
            }
            if (!(val = region.containsValue((Object)"updatedZero"))) {
                CacheMapTxnDUnitTest.fail((String)"containsValue after committed transaction returns incorrect result");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            CacheMapTxnDUnitTest.fail("failed in commitTxn", ex);
        }
        finally {
            if (cacheTxnMgr.exists()) {
                try {
                    cacheTxnMgr.commit();
                }
                catch (Exception cce) {
                    cce.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void rollbackTxn() {
        try {
            boolean succeeded;
            cacheTxnMgr = cache.getCacheTransactionManager();
            int[] i = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
            Object o3 = "init";
            region.put((Object)("" + i[0]), (Object)"zero");
            region.put((Object)("" + i[5]), (Object)"fifth");
            cacheTxnMgr.begin();
            region.put((Object)("" + i[1]), (Object)"first");
            o3 = region.get((Object)("" + i[1]));
            if (!o3.toString().equals("first")) {
                CacheMapTxnDUnitTest.fail((String)"get inside transaction returns incorrect object");
            }
            boolean flag = region.containsValue((Object)new String("first"));
            region.put((Object)("" + i[2]), (Object)"second");
            o3 = region.remove((Object)("" + i[2]));
            if (!o3.toString().equals("second")) {
                CacheMapTxnDUnitTest.fail((String)"remove inside transaction returns incorrect object");
            }
            region.put((Object)("" + i[3]), (Object)"third");
            region.put((Object)("" + i[0]), (Object)"updatedZero");
            region.putIfAbsent((Object)("" + i[4]), (Object)"fourth");
            if (!region.get((Object)("" + i[4])).toString().equals("fourth")) {
                CacheMapTxnDUnitTest.fail((String)"putIfAbsent inside transaction returns incorrect object");
            }
            region.replace((Object)("" + i[4]), (Object)"fourth2");
            if (!region.get((Object)("" + i[4])).toString().equals("fourth2")) {
                CacheMapTxnDUnitTest.fail((String)"replace inside transaction returns incorrect object)");
            }
            region.replace((Object)("" + i[4]), (Object)"fourth2", (Object)"fourth3");
            if (!region.get((Object)("" + i[4])).toString().equals("fourth3")) {
                CacheMapTxnDUnitTest.fail((String)"replace inside transaction returns incorrect object)");
            }
            CacheMapTxnDUnitTest.assertTrue((!(succeeded = region.remove((Object)("" + i[5]), (Object)new Serializable(){})) ? 1 : 0) != 0);
            CacheMapTxnDUnitTest.assertTrue((boolean)region.get((Object)("" + i[5])).equals("fifth"));
            region.remove((Object)("" + i[5]));
            cacheTxnMgr.rollback();
            o3 = region.get((Object)("" + i[1]));
            if (o3 != null) {
                CacheMapTxnDUnitTest.fail((String)"get after rolled back transaction returns incorrect object");
            }
            if ((o3 = region.get((Object)("" + i[2]))) != null) {
                CacheMapTxnDUnitTest.fail((String)"get after rolled back transaction returns incorrect object");
            }
            if ((o3 = region.get((Object)("" + i[3]))) != null) {
                CacheMapTxnDUnitTest.fail((String)"get after rolled back transaction returns incorrect object");
            }
            if ((o3 = region.get((Object)("" + i[4]))) != null) {
                CacheMapTxnDUnitTest.fail((String)"get after rolled back transaction returns incorrect object");
            }
            if ((o3 = region.get((Object)("" + i[5]))) == null) {
                CacheMapTxnDUnitTest.fail((String)"get after rolled back transaction returns incorrect object");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            CacheMapTxnDUnitTest.fail("failed in rollbackTxn", ex);
        }
        finally {
            if (cacheTxnMgr.exists()) {
                try {
                    cacheTxnMgr.commit();
                }
                catch (Exception cce) {
                    cce.printStackTrace();
                }
            }
        }
    }

    public static void rollbackTxnClear() {
        try {
            cacheTxnMgr = cache.getCacheTransactionManager();
            int[] i = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
            region.put((Object)("" + i[0]), (Object)"zero");
            cacheTxnMgr.begin();
            region.put((Object)("" + i[1]), (Object)"first");
            region.put((Object)("" + i[0]), (Object)"updatedZero");
            region.clear();
            cacheTxnMgr.rollback();
            boolean val = region.containsValue((Object)"updatedZero");
            if (val) {
                CacheMapTxnDUnitTest.fail((String)"containsValue after region.clear & rolled back transaction returns incorrect result");
            }
            if (val = region.containsValue((Object)"first")) {
                CacheMapTxnDUnitTest.fail((String)"containsValue after region.clear & rolled back transaction returns incorrect result");
            }
        }
        catch (Exception ex) {
            cacheTxnMgr = null;
            ex.printStackTrace();
            CacheMapTxnDUnitTest.fail((String)"failed in rollbackTxnClear");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void miscMethodsOwner() {
        try {
            boolean val;
            cacheTxnMgr = cache.getCacheTransactionManager();
            int[] i = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
            region.clear();
            region.put((Object)("" + i[0]), (Object)"zero");
            region.put((Object)("" + i[1]), (Object)"first");
            region.put((Object)("" + i[2]), (Object)"second");
            region.put((Object)("" + i[3]), (Object)"third");
            cacheTxnMgr.begin();
            region.put((Object)("" + i[4]), (Object)"forth");
            region.put((Object)("" + i[5]), (Object)"fifth");
            int j = region.size();
            if (j != 6) {
                CacheMapTxnDUnitTest.fail((String)("region.size inside transaction returns incorrect results: " + j));
            }
            Set set = region.entrySet();
            int k = set.size();
            if (j != 6) {
                CacheMapTxnDUnitTest.fail((String)("region.entrySet inside transaction returns incorrect results: " + j));
            }
            set = region.keySet();
            k = set.size();
            if (j != 6) {
                CacheMapTxnDUnitTest.fail((String)("region.keySet inside transaction returns incorrect results: " + j));
            }
            if (!(val = region.containsValue((Object)"forth"))) {
                CacheMapTxnDUnitTest.fail((String)"containsValue inside transaction returns incorrect result");
            }
            cacheTxnMgr.rollback();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            CacheMapTxnDUnitTest.fail((String)"failed in miscMethodsOwner");
        }
        finally {
            if (cacheTxnMgr.exists()) {
                try {
                    cacheTxnMgr.commit();
                }
                catch (Exception cce) {
                    cce.printStackTrace();
                }
            }
        }
    }

    public static void miscMethodsNotOwner() {
        try {
            boolean val;
            int j = region.size();
            if (j != 4) {
                CacheMapTxnDUnitTest.fail((String)("region.size for not owner of transaction returns incorrect results, size is " + j + " but expected 4"));
            }
            Set set = region.entrySet();
            int k = set.size();
            if (j != 4) {
                CacheMapTxnDUnitTest.fail((String)"region.entrySet for not owner of transaction returns incorrect results");
            }
            set = region.keySet();
            k = set.size();
            if (j != 4) {
                CacheMapTxnDUnitTest.fail((String)"region.keySet for not owner of transaction returns incorrect results");
            }
            if (val = region.containsKey((Object)"forth")) {
                CacheMapTxnDUnitTest.fail((String)"containsValue for not owner of transaction returns incorrect result");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            CacheMapTxnDUnitTest.fail((String)"failed in miscMethodsNotOwner");
        }
    }

    public static Object putMethod(Object ob) {
        Object obj = null;
        try {
            if (ob != null) {
                String str = "first";
                obj = region.put(ob, (Object)str);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            CacheMapTxnDUnitTest.fail((String)"Failed while region.put");
        }
        return obj;
    }

    public static Object getMethod(Object ob) {
        Object obj = null;
        try {
            obj = region.get(ob);
        }
        catch (Exception ex) {
            CacheMapTxnDUnitTest.fail((String)"Failed while region.get");
        }
        return obj;
    }

    static {
        props = new Properties();
        ds = null;
    }
}

