/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache30;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheStatistics;
import com.gemstone.gemfire.cache.EntryDestroyedException;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.StatisticsDisabledException;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import dunit.Host;
import dunit.VM;
import junit.framework.TestCase;

public class CacheStatisticsTest
extends CacheTestCase {
    protected static volatile long lastAccessed;
    protected static volatile long lastModified;
    protected static volatile long lastModifiedLocal;
    protected static volatile long lastModifiedRemote;

    public CacheStatisticsTest(String name) {
        super(name);
    }

    public static void assertInRange(long start, long end, long actual) {
        CacheStatisticsTest.assertTrue((String)("Expected: " + actual + " >= " + start), (actual >= start ? 1 : 0) != 0);
        CacheStatisticsTest.assertTrue((String)("Expected: " + actual + " <= " + end), (actual <= end ? 1 : 0) != 0);
    }

    public void testHitMissCount() throws CacheException {
        String name = this.getUniqueName();
        String key = "KEY";
        String key2 = "KEY2";
        String key3 = "KEY3";
        String value = "VALUE";
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.LOCAL);
        factory.setStatisticsEnabled(true);
        Region region = this.createRegion(name, factory.create());
        CacheStatistics rStats = region.getStatistics();
        CacheStatisticsTest.assertEquals((long)0L, (long)rStats.getHitCount());
        CacheStatisticsTest.assertEquals((long)0L, (long)rStats.getMissCount());
        CacheStatisticsTest.assertEquals((float)0.0f, (float)rStats.getHitRatio(), (float)0.0f);
        CacheStatisticsTest.assertNull((Object)region.get((Object)key));
        CacheStatisticsTest.assertEquals((long)0L, (long)rStats.getHitCount());
        CacheStatisticsTest.assertEquals((long)1L, (long)rStats.getMissCount());
        CacheStatisticsTest.assertEquals((float)0.0f, (float)rStats.getHitRatio(), (float)0.0f);
        CacheStatisticsTest.assertNull((Object)region.get((Object)key));
        CacheStatisticsTest.assertEquals((long)0L, (long)rStats.getHitCount());
        CacheStatisticsTest.assertEquals((long)2L, (long)rStats.getMissCount());
        CacheStatisticsTest.assertEquals((float)0.0f, (float)rStats.getHitRatio(), (float)0.0f);
        rStats.resetCounts();
        CacheStatisticsTest.assertEquals((long)0L, (long)rStats.getHitCount());
        CacheStatisticsTest.assertEquals((long)0L, (long)rStats.getMissCount());
        CacheStatisticsTest.assertEquals((float)0.0f, (float)rStats.getHitRatio(), (float)0.0f);
        region.put((Object)key, (Object)value);
        CacheStatisticsTest.assertEquals((long)0L, (long)rStats.getHitCount());
        CacheStatisticsTest.assertEquals((long)0L, (long)rStats.getMissCount());
        CacheStatistics eStats = region.getEntry((Object)key).getStatistics();
        CacheStatisticsTest.assertEquals((long)0L, (long)eStats.getHitCount());
        CacheStatisticsTest.assertEquals((long)0L, (long)eStats.getMissCount());
        CacheStatisticsTest.assertEquals((float)0.0f, (float)eStats.getHitRatio(), (float)0.0f);
        region.get((Object)key);
        CacheStatisticsTest.assertEquals((long)1L, (long)eStats.getHitCount());
        CacheStatisticsTest.assertEquals((long)0L, (long)eStats.getMissCount());
        CacheStatisticsTest.assertEquals((float)1.0f, (float)eStats.getHitRatio(), (float)0.0f);
        CacheStatisticsTest.assertEquals((long)1L, (long)rStats.getHitCount());
        CacheStatisticsTest.assertEquals((long)0L, (long)rStats.getMissCount());
        CacheStatisticsTest.assertEquals((float)1.0f, (float)rStats.getHitRatio(), (float)0.0f);
        region.get((Object)key2);
        CacheStatisticsTest.assertEquals((long)1L, (long)eStats.getHitCount());
        CacheStatisticsTest.assertEquals((long)0L, (long)eStats.getMissCount());
        CacheStatisticsTest.assertEquals((float)1.0f, (float)eStats.getHitRatio(), (float)0.0f);
        CacheStatisticsTest.assertEquals((long)1L, (long)rStats.getHitCount());
        CacheStatisticsTest.assertEquals((long)1L, (long)rStats.getMissCount());
        CacheStatisticsTest.assertEquals((float)0.5f, (float)rStats.getHitRatio(), (float)0.0f);
        region.create((Object)key3, null);
        CacheStatistics e3Stats = region.getEntry((Object)key3).getStatistics();
        CacheStatisticsTest.assertEquals((long)0L, (long)e3Stats.getHitCount());
        CacheStatisticsTest.assertEquals((long)0L, (long)e3Stats.getMissCount());
        CacheStatisticsTest.assertEquals((float)0.0f, (float)e3Stats.getHitRatio(), (float)0.0f);
        region.get((Object)key3);
        CacheStatisticsTest.assertEquals((long)0L, (long)e3Stats.getHitCount());
        CacheStatisticsTest.assertEquals((long)1L, (long)e3Stats.getMissCount());
        CacheStatisticsTest.assertEquals((float)0.0f, (float)e3Stats.getHitRatio(), (float)0.0f);
        CacheStatisticsTest.assertEquals((long)1L, (long)rStats.getHitCount());
        CacheStatisticsTest.assertEquals((long)2L, (long)rStats.getMissCount());
        CacheStatisticsTest.assertEquals((float)0.33f, (float)rStats.getHitRatio(), (float)0.01f);
        eStats.resetCounts();
        CacheStatisticsTest.assertEquals((long)0L, (long)eStats.getHitCount());
        CacheStatisticsTest.assertEquals((long)0L, (long)eStats.getMissCount());
        CacheStatisticsTest.assertEquals((float)0.0f, (float)eStats.getHitRatio(), (float)0.0f);
        rStats.resetCounts();
        region.invalidate((Object)key);
        CacheStatisticsTest.assertEquals((long)0L, (long)eStats.getHitCount());
        CacheStatisticsTest.assertEquals((long)0L, (long)eStats.getMissCount());
        CacheStatisticsTest.assertEquals((float)0.0f, (float)eStats.getHitRatio(), (float)0.0f);
        region.get((Object)key);
        CacheStatisticsTest.assertEquals((long)0L, (long)eStats.getHitCount());
        CacheStatisticsTest.assertEquals((long)1L, (long)eStats.getMissCount());
        CacheStatisticsTest.assertEquals((long)0L, (long)rStats.getHitCount());
        CacheStatisticsTest.assertEquals((long)1L, (long)rStats.getMissCount());
        region.destroy((Object)key);
        try {
            eStats.getMissCount();
            CacheStatisticsTest.fail((String)"Should have thrown an EntryDestroyedException");
        }
        catch (EntryDestroyedException entryDestroyedException) {
            // empty catch block
        }
    }

    public void testTimeStats() throws CacheException, InterruptedException {
        long ESTAT_RES = 100L;
        String name = this.getUniqueName();
        String key = "KEY";
        String key2 = "KEY2";
        String value = "VALUE";
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.LOCAL);
        factory.setStatisticsEnabled(true);
        long before = ((GemFireCacheImpl)this.getCache()).cacheTimeMillis();
        Region region = this.createRegion(name, factory.create());
        CacheStatistics rStats = region.getStatistics();
        CacheStatistics rootStats = this.getRootRegion().getStatistics();
        long after = ((GemFireCacheImpl)this.getCache()).cacheTimeMillis();
        CacheStatisticsTest.assertInRange(before, after, rStats.getLastAccessedTime());
        CacheStatisticsTest.assertInRange(before, after, rStats.getLastModifiedTime());
        CacheStatisticsTest.assertInRange(before, after, rootStats.getLastAccessedTime());
        CacheStatisticsTest.assertInRange(before, after, rootStats.getLastModifiedTime());
        long oldBefore = before;
        long oldAfter = after;
        CacheStatisticsTest.pause(150);
        before = ((GemFireCacheImpl)this.getCache()).cacheTimeMillis();
        region.get((Object)key);
        after = ((GemFireCacheImpl)this.getCache()).cacheTimeMillis();
        CacheStatisticsTest.assertInRange(before, after, rStats.getLastAccessedTime());
        CacheStatisticsTest.assertInRange(oldBefore, oldAfter, rStats.getLastModifiedTime());
        CacheStatisticsTest.assertInRange(before, after, rootStats.getLastAccessedTime());
        CacheStatisticsTest.assertInRange(oldBefore, oldAfter, rootStats.getLastModifiedTime());
        CacheStatisticsTest.pause(150);
        before = ((GemFireCacheImpl)this.getCache()).cacheTimeMillis();
        region.put((Object)key, (Object)value);
        CacheStatistics eStats = region.getEntry((Object)key).getStatistics();
        after = ((GemFireCacheImpl)this.getCache()).cacheTimeMillis();
        CacheStatisticsTest.assertInRange(before, after, rStats.getLastAccessedTime());
        CacheStatisticsTest.assertInRange(before, after, rStats.getLastModifiedTime());
        CacheStatisticsTest.assertInRange(before, after, rootStats.getLastAccessedTime());
        CacheStatisticsTest.assertInRange(before, after, rootStats.getLastModifiedTime());
        CacheStatisticsTest.assertInRange(before - 100L, after + 100L, eStats.getLastAccessedTime());
        CacheStatisticsTest.assertInRange(before - 100L, after + 100L, eStats.getLastModifiedTime());
        oldBefore = before;
        oldAfter = after;
        CacheStatisticsTest.pause(150);
        before = ((GemFireCacheImpl)this.getCache()).cacheTimeMillis();
        region.get((Object)key);
        after = ((GemFireCacheImpl)this.getCache()).cacheTimeMillis();
        CacheStatisticsTest.assertInRange(before, after, rStats.getLastAccessedTime());
        CacheStatisticsTest.assertInRange(oldBefore, oldAfter, rStats.getLastModifiedTime());
        CacheStatisticsTest.assertInRange(before, after, rootStats.getLastAccessedTime());
        CacheStatisticsTest.assertInRange(oldBefore, oldAfter, rootStats.getLastModifiedTime());
        CacheStatisticsTest.assertInRange(before - 100L, after + 100L, eStats.getLastAccessedTime());
        CacheStatisticsTest.assertInRange(oldBefore - 100L, oldAfter + 100L, eStats.getLastModifiedTime());
        long oldOldBefore = oldBefore;
        long oldOldAfter = oldAfter;
        oldBefore = before;
        oldAfter = after;
        CacheStatisticsTest.pause(150);
        before = ((GemFireCacheImpl)this.getCache()).cacheTimeMillis();
        region.create((Object)key2, null);
        CacheStatistics eStats2 = region.getEntry((Object)key2).getStatistics();
        after = ((GemFireCacheImpl)this.getCache()).cacheTimeMillis();
        CacheStatisticsTest.assertInRange(before, after, rStats.getLastAccessedTime());
        CacheStatisticsTest.assertInRange(before, after, rStats.getLastModifiedTime());
        CacheStatisticsTest.assertInRange(before, after, rootStats.getLastAccessedTime());
        CacheStatisticsTest.assertInRange(before, after, rootStats.getLastModifiedTime());
        CacheStatisticsTest.assertInRange(oldBefore - 100L, oldAfter + 100L, eStats.getLastAccessedTime());
        CacheStatisticsTest.assertInRange(oldOldBefore - 100L, oldOldAfter + 100L, eStats.getLastModifiedTime());
        CacheStatisticsTest.assertInRange(before - 100L, after + 100L, eStats2.getLastAccessedTime());
        CacheStatisticsTest.assertInRange(before - 100L, after + 100L, eStats2.getLastModifiedTime());
        oldBefore = before;
        oldAfter = after;
        CacheStatisticsTest.pause(150);
        before = ((GemFireCacheImpl)this.getCache()).cacheTimeMillis();
        region.invalidate((Object)key2);
        after = ((GemFireCacheImpl)this.getCache()).cacheTimeMillis();
        CacheStatisticsTest.assertInRange(oldBefore - 100L, oldAfter + 100L, eStats2.getLastAccessedTime());
        CacheStatisticsTest.assertInRange(oldBefore - 100L, oldAfter + 100L, eStats2.getLastModifiedTime());
        CacheStatisticsTest.assertInRange(oldBefore, oldAfter, rStats.getLastAccessedTime());
        CacheStatisticsTest.assertInRange(oldBefore, oldAfter, rStats.getLastModifiedTime());
        CacheStatisticsTest.assertInRange(oldBefore, oldAfter, rootStats.getLastAccessedTime());
        CacheStatisticsTest.assertInRange(oldBefore, oldAfter, rootStats.getLastModifiedTime());
        CacheStatisticsTest.pause(150);
        before = ((GemFireCacheImpl)this.getCache()).cacheTimeMillis();
        region.destroy((Object)key2);
        after = ((GemFireCacheImpl)this.getCache()).cacheTimeMillis();
        CacheStatisticsTest.assertInRange(oldBefore, oldAfter, rStats.getLastAccessedTime());
        CacheStatisticsTest.assertInRange(oldBefore, oldAfter, rStats.getLastModifiedTime());
        CacheStatisticsTest.assertInRange(oldBefore, oldAfter, rootStats.getLastAccessedTime());
        CacheStatisticsTest.assertInRange(oldBefore, oldAfter, rootStats.getLastModifiedTime());
        before = ((GemFireCacheImpl)this.getCache()).cacheTimeMillis();
        Region sub = region.createSubregion("sub", region.getAttributes());
        after = ((GemFireCacheImpl)this.getCache()).cacheTimeMillis();
        CacheStatisticsTest.assertInRange(before, after, rStats.getLastAccessedTime());
        CacheStatisticsTest.assertInRange(before, after, rStats.getLastModifiedTime());
        CacheStatisticsTest.assertInRange(before, after, rootStats.getLastAccessedTime());
        CacheStatisticsTest.assertInRange(before, after, rootStats.getLastModifiedTime());
        oldBefore = before;
        oldAfter = after;
        before = ((GemFireCacheImpl)this.getCache()).cacheTimeMillis();
        sub.destroyRegion();
        after = ((GemFireCacheImpl)this.getCache()).cacheTimeMillis();
        CacheStatisticsTest.assertInRange(oldBefore, oldAfter, rStats.getLastAccessedTime());
        CacheStatisticsTest.assertInRange(oldBefore, oldAfter, rStats.getLastModifiedTime());
        CacheStatisticsTest.assertInRange(oldBefore, oldAfter, rootStats.getLastAccessedTime());
        CacheStatisticsTest.assertInRange(oldBefore, oldAfter, rootStats.getLastModifiedTime());
    }

    public void testDistributedStats() {
        final String name = this.getUniqueName();
        final String key = "KEY";
        final String value = "VALUE";
        CacheSerializableRunnable create = new CacheSerializableRunnable("Create Region"){

            @Override
            public void run2() throws CacheException {
                AttributesFactory factory = new AttributesFactory();
                factory.setScope(Scope.DISTRIBUTED_ACK);
                factory.setEarlyAck(false);
                factory.setStatisticsEnabled(true);
                CacheStatisticsTest.this.createRegion(name, factory.create());
            }
        };
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        vm0.invoke(create);
        vm1.invoke(create);
        vm0.invoke(new CacheSerializableRunnable("Define entry"){

            @Override
            public void run2() throws CacheException {
                Region region = CacheStatisticsTest.this.getRootRegion().getSubregion(name);
                region.put(key, value);
                CacheStatistics stats = region.getEntry(key).getStatistics();
                lastAccessed = stats.getLastAccessedTime();
                lastModified = stats.getLastModifiedTime();
                CacheStatisticsTest.this.getCache().getLogger().fine("DEFINE: lastAccessed: " + lastAccessed + ", lastModified: " + lastModified);
                TestCase.assertEquals((long)0L, (long)stats.getHitCount());
                TestCase.assertEquals((long)0L, (long)stats.getMissCount());
                TestCase.assertTrue((lastModified > 0L ? 1 : 0) != 0);
                lastModifiedLocal = lastModified;
            }
        });
        vm1.invoke(new CacheSerializableRunnable("Net search"){

            @Override
            public void run2() throws CacheException {
                Region region = CacheStatisticsTest.this.getRootRegion().getSubregion(name);
                Object result = region.get(key);
                TestCase.assertEquals((Object)value, (Object)result);
                CacheStatistics stats = region.getEntry(key).getStatistics();
                lastModifiedRemote = stats.getLastModifiedTime();
                CacheStatisticsTest.this.getCache().getLogger().fine("NETSEARCH: lastAccessed: " + stats.getLastAccessedTime() + ", lastModified: " + stats.getLastModifiedTime());
            }
        });
        vm0.invoke(new CacheSerializableRunnable("Verify stats"){

            @Override
            public void run2() throws CacheException {
                Region region = CacheStatisticsTest.this.getRootRegion().getSubregion(name);
                CacheStatistics stats = region.getEntry(key).getStatistics();
                TestCase.assertEquals((long)lastAccessed, (long)stats.getLastAccessedTime());
                TestCase.assertEquals((long)lastModified, (long)stats.getLastModifiedTime());
                TestCase.assertEquals((long)0L, (long)stats.getHitCount());
                TestCase.assertEquals((long)0L, (long)stats.getMissCount());
            }
        });
        CacheStatisticsTest.assertEquals((long)lastModifiedLocal, (long)lastModifiedRemote);
        CacheStatisticsTest.pause(100);
        vm1.invoke(new CacheSerializableRunnable("Update"){

            @Override
            public void run2() throws CacheException {
                Region region = CacheStatisticsTest.this.getRootRegion().getSubregion(name);
                region.put(key, value);
                TestCase.assertEquals((Object)value, (Object)region.getEntry(key).getValue());
                CacheStatistics stats = region.getEntry(key).getStatistics();
                CacheStatisticsTest.this.getCache().getLogger().fine("UPDATE: lastAccessed: " + stats.getLastAccessedTime() + ", lastModified: " + stats.getLastModifiedTime());
            }
        });
        long errorMargin = 50L;
        vm0.invoke(new CacheSerializableRunnable("Verify stats"){

            @Override
            public void run2() throws CacheException {
                Region region = CacheStatisticsTest.this.getRootRegion().getSubregion(name);
                CacheStatistics stats = region.getEntry(key).getStatistics();
                long ta = stats.getLastAccessedTime();
                long tm = stats.getLastModifiedTime();
                long hc = stats.getHitCount();
                long mc = stats.getMissCount();
                CacheStatisticsTest.this.getCache().getLogger().fine("VERIFY: lastAccessed: " + ta + ", lastModified: " + tm);
                TestCase.assertTrue((String)("lastAccessedTime was " + ta + " but was expected to be > " + lastAccessed), (lastAccessed < ta + 50L ? 1 : 0) != 0);
                TestCase.assertTrue((String)("lastAccessed=" + lastAccessed + " should be < stats.getLastModifiedTime=" + tm), (lastAccessed < tm + 50L ? 1 : 0) != 0);
                TestCase.assertEquals((long)0L, (long)hc);
                TestCase.assertEquals((long)0L, (long)mc);
                lastAccessed = stats.getLastAccessedTime();
            }
        });
        vm1.invoke(new CacheSerializableRunnable("Invalidate"){

            @Override
            public void run2() throws CacheException {
                Region region = CacheStatisticsTest.this.getRootRegion().getSubregion(name);
                region.invalidate(key);
            }
        });
        vm0.invoke(new CacheSerializableRunnable("Verify stats"){

            @Override
            public void run2() throws CacheException {
                Region region = CacheStatisticsTest.this.getRootRegion().getSubregion(name);
                CacheStatistics stats = region.getEntry(key).getStatistics();
                TestCase.assertEquals((long)lastAccessed, (long)stats.getLastAccessedTime());
                TestCase.assertEquals((long)lastAccessed, (long)stats.getLastModifiedTime());
                TestCase.assertEquals((long)0L, (long)stats.getHitCount());
                TestCase.assertEquals((long)0L, (long)stats.getMissCount());
            }
        });
        vm1.invoke(new CacheSerializableRunnable("Destroy Entry"){

            @Override
            public void run2() throws CacheException {
                Region region = CacheStatisticsTest.this.getRootRegion().getSubregion(name);
                region.destroy(key);
            }
        });
        vm0.invoke(new CacheSerializableRunnable("Verify region stats"){

            @Override
            public void run2() throws CacheException {
                Region region = CacheStatisticsTest.this.getRootRegion().getSubregion(name);
                CacheStatistics stats = region.getStatistics();
                TestCase.assertEquals((long)0L, (long)stats.getHitCount());
                TestCase.assertEquals((long)0L, (long)stats.getMissCount());
            }
        });
    }

    public void testDisabledStatistics() throws CacheException {
        String name = this.getUniqueName();
        String key = "KEY";
        String value = "VALUE";
        AttributesFactory factory = new AttributesFactory();
        factory.setStatisticsEnabled(false);
        Region region = this.createRegion(name, factory.create());
        try {
            region.getStatistics();
            CacheStatisticsTest.fail((String)"Should have thrown a StatisticsDisabledException");
        }
        catch (StatisticsDisabledException statisticsDisabledException) {
            // empty catch block
        }
        region.put((Object)key, (Object)value);
        Region.Entry entry = region.getEntry((Object)key);
        try {
            entry.getStatistics();
        }
        catch (StatisticsDisabledException statisticsDisabledException) {
            // empty catch block
        }
    }
}

