/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache30;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheWriter;
import com.gemstone.gemfire.cache.CacheWriterException;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.RegionEvent;
import com.gemstone.gemfire.cache30.RegionAttributesTestCase;
import com.gemstone.gemfire.cache30.TestCacheWriter;
import junit.framework.TestCase;

public abstract class CacheWriterTestCase
extends RegionAttributesTestCase {
    public CacheWriterTestCase(String name) {
        super(name);
    }

    public void testCacheWriterBeforeCreate() throws CacheException {
        String name = this.getUniqueName();
        final String key = this.getUniqueName();
        final Integer value = new Integer(42);
        final String arg = "ARG";
        String exception = "EXCEPTION";
        TestCacheWriter writer = new TestCacheWriter(){

            @Override
            public void beforeCreate2(EntryEvent event) throws CacheWriterException {
                TestCase.assertEquals((Object)key, (Object)event.getKey());
                TestCase.assertEquals((Object)value, (Object)event.getNewValue());
                TestCase.assertNull((Object)event.getOldValue());
                TestCase.assertTrue((boolean)event.getOperation().isCreate());
                TestCase.assertFalse((boolean)event.getOperation().isLoad());
                TestCase.assertFalse((boolean)event.getOperation().isLocalLoad());
                TestCase.assertFalse((boolean)event.getOperation().isNetLoad());
                TestCase.assertFalse((boolean)event.getOperation().isNetSearch());
                Object argument = event.getCallbackArgument();
                if (argument != null) {
                    if (argument.equals("EXCEPTION")) {
                        String s = "Test CacheWriterException";
                        throw new CacheWriterException(s);
                    }
                    TestCase.assertEquals((Object)arg, (Object)argument);
                }
            }

            @Override
            public void beforeDestroy2(EntryEvent event) throws CacheWriterException {
            }
        };
        AttributesFactory factory = new AttributesFactory(this.getRegionAttributes());
        factory.setCacheWriter((CacheWriter)writer);
        Region region = this.createRegion(name, factory.create());
        region.create((Object)key, (Object)value);
        CacheWriterTestCase.assertTrue((boolean)writer.wasInvoked());
        region.destroy((Object)key);
        CacheWriterTestCase.assertTrue((boolean)writer.wasInvoked());
        region.put((Object)key, (Object)value);
        CacheWriterTestCase.assertTrue((boolean)writer.wasInvoked());
        region.destroy((Object)key);
        CacheWriterTestCase.assertTrue((boolean)writer.wasInvoked());
        region.create((Object)key, (Object)value, (Object)arg);
        CacheWriterTestCase.assertTrue((boolean)writer.wasInvoked());
        region.destroy((Object)key);
        CacheWriterTestCase.assertTrue((boolean)writer.wasInvoked());
        region.put((Object)key, (Object)value, (Object)arg);
        CacheWriterTestCase.assertTrue((boolean)writer.wasInvoked());
        region.destroy((Object)key);
        CacheWriterTestCase.assertTrue((boolean)writer.wasInvoked());
        try {
            region.create((Object)key, (Object)value, (Object)"EXCEPTION");
            CacheWriterTestCase.fail((String)"Should have thrown a CacheWriterException");
        }
        catch (CacheWriterException ex) {
            CacheWriterTestCase.assertTrue((boolean)writer.wasInvoked());
        }
        try {
            region.put((Object)key, (Object)value, (Object)"EXCEPTION");
            CacheWriterTestCase.fail((String)"Should have thrown a CacheWriterException");
        }
        catch (CacheWriterException ex) {
            CacheWriterTestCase.assertTrue((boolean)writer.wasInvoked());
        }
    }

    public void testCacheWriterBeforeUpdate() throws CacheException {
        String name = this.getUniqueName();
        final String key = this.getUniqueName();
        final Integer oldValue = new Integer(42);
        final Integer newValue = new Integer(43);
        final String arg = "ARG";
        String exception = "EXCEPTION";
        TestCacheWriter writer = new TestCacheWriter(){

            @Override
            public void beforeCreate2(EntryEvent event) throws CacheWriterException {
            }

            @Override
            public void beforeDestroy2(EntryEvent event) throws CacheWriterException {
            }

            @Override
            public void beforeUpdate2(EntryEvent event) throws CacheWriterException {
                TestCase.assertEquals((Object)key, (Object)event.getKey());
                TestCase.assertEquals((Object)newValue, (Object)event.getNewValue());
                TestCase.assertEquals((Object)oldValue, (Object)event.getOldValue());
                TestCase.assertTrue((boolean)event.getOperation().isUpdate());
                TestCase.assertFalse((boolean)event.getOperation().isLoad());
                TestCase.assertFalse((boolean)event.getOperation().isLocalLoad());
                TestCase.assertFalse((boolean)event.getOperation().isNetLoad());
                TestCase.assertFalse((boolean)event.getOperation().isNetSearch());
                Object argument = event.getCallbackArgument();
                if (argument != null) {
                    if (argument.equals("EXCEPTION")) {
                        String s = "Test CacheWriterException";
                        throw new CacheWriterException(s);
                    }
                    TestCase.assertEquals((Object)arg, (Object)argument);
                }
            }
        };
        AttributesFactory factory = new AttributesFactory(this.getRegionAttributes());
        factory.setCacheWriter((CacheWriter)writer);
        Region region = this.createRegion(name, factory.create());
        region.create((Object)key, (Object)oldValue);
        CacheWriterTestCase.assertTrue((boolean)writer.wasInvoked());
        region.put((Object)key, (Object)newValue);
        CacheWriterTestCase.assertTrue((boolean)writer.wasInvoked());
        region.destroy((Object)key);
        CacheWriterTestCase.assertTrue((boolean)writer.wasInvoked());
        region.put((Object)key, (Object)oldValue);
        CacheWriterTestCase.assertTrue((boolean)writer.wasInvoked());
        region.put((Object)key, (Object)newValue);
        CacheWriterTestCase.assertTrue((boolean)writer.wasInvoked());
        region.destroy((Object)key);
        CacheWriterTestCase.assertTrue((boolean)writer.wasInvoked());
        region.create((Object)key, (Object)oldValue);
        CacheWriterTestCase.assertTrue((boolean)writer.wasInvoked());
        region.put((Object)key, (Object)newValue, (Object)arg);
        CacheWriterTestCase.assertTrue((boolean)writer.wasInvoked());
        region.destroy((Object)key);
        CacheWriterTestCase.assertTrue((boolean)writer.wasInvoked());
        region.put((Object)key, (Object)oldValue);
        CacheWriterTestCase.assertTrue((boolean)writer.wasInvoked());
        region.put((Object)key, (Object)newValue, (Object)arg);
        CacheWriterTestCase.assertTrue((boolean)writer.wasInvoked());
        region.destroy((Object)key);
        CacheWriterTestCase.assertTrue((boolean)writer.wasInvoked());
        region.create((Object)key, (Object)oldValue);
        CacheWriterTestCase.assertTrue((boolean)writer.wasInvoked());
        try {
            region.put((Object)key, (Object)newValue, (Object)"EXCEPTION");
            CacheWriterTestCase.fail((String)"Should have thrown a CacheWriterException");
        }
        catch (CacheWriterException ex) {
            CacheWriterTestCase.assertTrue((boolean)writer.wasInvoked());
        }
        region.destroy((Object)key);
        CacheWriterTestCase.assertTrue((boolean)writer.wasInvoked());
        region.create((Object)key, (Object)oldValue);
        CacheWriterTestCase.assertTrue((boolean)writer.wasInvoked());
        try {
            region.put((Object)key, (Object)newValue, (Object)"EXCEPTION");
            CacheWriterTestCase.fail((String)"Should have thrown a CacheWriterException");
        }
        catch (CacheWriterException ex) {
            CacheWriterTestCase.assertTrue((boolean)writer.wasInvoked());
        }
    }

    public void testCacheWriterBeforeDestroy() throws CacheException {
        String name = this.getUniqueName();
        final String key = this.getUniqueName();
        final Integer value = new Integer(42);
        final String arg = "ARG";
        String exception = "EXCEPTION";
        TestCacheWriter writer = new TestCacheWriter(){

            @Override
            public void beforeCreate2(EntryEvent event) throws CacheWriterException {
            }

            @Override
            public void beforeDestroy2(EntryEvent event) throws CacheWriterException {
                TestCase.assertEquals((Object)key, (Object)event.getKey());
                TestCase.assertEquals((Object)value, (Object)event.getOldValue());
                TestCase.assertNull((Object)event.getNewValue());
                TestCase.assertTrue((boolean)event.getOperation().isDestroy());
                TestCase.assertFalse((boolean)event.getOperation().isLoad());
                TestCase.assertFalse((boolean)event.getOperation().isLocalLoad());
                TestCase.assertFalse((boolean)event.getOperation().isNetLoad());
                TestCase.assertFalse((boolean)event.getOperation().isNetSearch());
                Object argument = event.getCallbackArgument();
                if (argument != null) {
                    if (argument.equals("EXCEPTION")) {
                        String s = "Test CacheWriterException";
                        throw new CacheWriterException(s);
                    }
                    TestCase.assertEquals((Object)arg, (Object)argument);
                }
            }
        };
        AttributesFactory factory = new AttributesFactory(this.getRegionAttributes());
        factory.setCacheWriter((CacheWriter)writer);
        Region region = this.createRegion(name, factory.create());
        region.create((Object)key, (Object)value);
        CacheWriterTestCase.assertTrue((boolean)writer.wasInvoked());
        region.destroy((Object)key);
        CacheWriterTestCase.assertTrue((boolean)writer.wasInvoked());
        region.create((Object)key, (Object)value);
        CacheWriterTestCase.assertTrue((boolean)writer.wasInvoked());
        region.destroy((Object)key, (Object)arg);
        CacheWriterTestCase.assertTrue((boolean)writer.wasInvoked());
        region.create((Object)key, (Object)value);
        CacheWriterTestCase.assertTrue((boolean)writer.wasInvoked());
        try {
            region.destroy((Object)key, (Object)"EXCEPTION");
            CacheWriterTestCase.fail((String)"Should have thrown a CacheWriterException");
        }
        catch (CacheWriterException ex) {
            CacheWriterTestCase.assertTrue((boolean)writer.wasInvoked());
        }
    }

    public void testCacheWriterBeforeRegionDestroy() throws CacheException {
        final String name = this.getUniqueName();
        final String arg = "ARG";
        String exception = "EXCEPTION";
        TestCacheWriter writer = new TestCacheWriter(){
            private boolean closed = false;
            private boolean destroyed = false;

            @Override
            public boolean wasInvoked() {
                boolean value = this.closed && this.destroyed;
                super.wasInvoked();
                return value;
            }

            @Override
            public void close2() {
                this.closed = true;
            }

            @Override
            public void beforeRegionDestroy2(RegionEvent event) throws CacheWriterException {
                TestCase.assertEquals((String)name, (String)event.getRegion().getName());
                TestCase.assertTrue((boolean)event.getOperation().isRegionDestroy());
                TestCase.assertFalse((boolean)event.getOperation().isExpiration());
                TestCase.assertFalse((boolean)event.isOriginRemote());
                Object argument = event.getCallbackArgument();
                if (argument != null) {
                    if (argument.equals("EXCEPTION")) {
                        String s = "Test CacheWriterException";
                        throw new CacheWriterException(s);
                    }
                    TestCase.assertEquals((Object)arg, (Object)argument);
                }
                this.destroyed = true;
            }
        };
        AttributesFactory factory = new AttributesFactory(this.getRegionAttributes());
        factory.setCacheWriter((CacheWriter)writer);
        RegionAttributes attrs = factory.create();
        Region region = this.createRegion(name, attrs);
        region.destroyRegion();
        CacheWriterTestCase.assertTrue((boolean)region.isDestroyed());
        CacheWriterTestCase.assertTrue((boolean)writer.wasInvoked());
        region = this.createRegion(name, attrs);
        region.destroyRegion((Object)arg);
        CacheWriterTestCase.assertTrue((boolean)writer.wasInvoked());
        CacheWriterTestCase.assertTrue((boolean)region.isDestroyed());
        try {
            region = this.createRegion(name, attrs);
            region.destroyRegion((Object)"EXCEPTION");
            CacheWriterTestCase.fail((String)"Should have thrown a CacheWriterException");
        }
        catch (CacheWriterException ex) {
            CacheWriterTestCase.assertTrue((boolean)writer.wasInvoked());
            CacheWriterTestCase.assertFalse((boolean)region.isDestroyed());
            CacheWriterTestCase.assertNull((Object)region.getSubregion(name));
        }
    }

    public void testCacheWriterLocalDestroy() throws CacheException {
        String name = this.getUniqueName();
        TestCacheWriter writer = new TestCacheWriter(){};
        AttributesFactory factory = new AttributesFactory(this.getRegionAttributes());
        factory.setCacheWriter((CacheWriter)writer);
        RegionAttributes attrs = factory.create();
        Region region = this.createRegion(name, attrs);
        region.localDestroyRegion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCacheWriterExceptionAborts() throws CacheException {
        Region.Entry entry;
        String name = this.getUniqueName();
        String exception = "EXCEPTION";
        TestCacheWriter writer = new TestCacheWriter(){

            private void handleEvent(Object argument) throws CacheWriterException {
                if ("EXCEPTION".equals(argument)) {
                    String s = "Test Exception";
                    throw new CacheWriterException(s);
                }
            }

            @Override
            public void beforeCreate2(EntryEvent event) throws CacheWriterException {
                this.handleEvent(event.getCallbackArgument());
            }

            @Override
            public void beforeUpdate2(EntryEvent event) throws CacheWriterException {
                this.handleEvent(event.getCallbackArgument());
            }

            @Override
            public void beforeDestroy2(EntryEvent event) throws CacheWriterException {
                this.handleEvent(event.getCallbackArgument());
            }

            @Override
            public void beforeRegionDestroy2(RegionEvent event) throws CacheWriterException {
                this.handleEvent(event.getCallbackArgument());
            }
        };
        AttributesFactory factory = new AttributesFactory(this.getRegionAttributes());
        factory.setCacheWriter((CacheWriter)writer);
        RegionAttributes attrs = factory.create();
        Region region = this.createRegion(name, attrs);
        Integer value = new Integer(42);
        String p1 = "Test Exception";
        this.getCache().getLogger().info("<ExpectedException action=add>" + p1 + "</ExpectedException>");
        try {
            region.put((Object)name, (Object)value, (Object)"EXCEPTION");
            CacheWriterTestCase.fail((String)"Should have thrown a CacheWriterException");
        }
        catch (CacheWriterException ex) {
            CacheWriterTestCase.assertNull((Object)region.getEntry((Object)name));
        }
        finally {
            this.getCache().getLogger().info("<ExpectedException action=remove>" + p1 + "</ExpectedException>");
        }
        region.put((Object)name, (Object)value);
        try {
            region.put((Object)name, (Object)"NEVER SEEN", (Object)"EXCEPTION");
            CacheWriterTestCase.fail((String)"Should have thrown a CacheWriterException");
        }
        catch (CacheWriterException ex) {
            entry = region.getEntry((Object)name);
            CacheWriterTestCase.assertNotNull((Object)entry);
            CacheWriterTestCase.assertEquals((Object)value, (Object)entry.getValue());
        }
        try {
            region.destroy((Object)name, (Object)"EXCEPTION");
            CacheWriterTestCase.fail((String)"Should have thrown a CacheWriterException");
        }
        catch (CacheWriterException ex) {
            entry = region.getEntry((Object)name);
            CacheWriterTestCase.assertNotNull((Object)entry);
            CacheWriterTestCase.assertEquals((Object)value, (Object)entry.getValue());
        }
        try {
            region.destroyRegion((Object)"EXCEPTION");
        }
        catch (CacheWriterException ex) {
            CacheWriterTestCase.assertTrue((!region.isDestroyed() ? 1 : 0) != 0);
            CacheWriterTestCase.assertNotNull((Object)region.getParentRegion().getSubregion(name));
        }
    }
}

