/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache30;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.CacheLoader;
import com.gemstone.gemfire.cache.CacheLoaderException;
import com.gemstone.gemfire.cache.CacheWriter;
import com.gemstone.gemfire.cache.CacheXmlException;
import com.gemstone.gemfire.cache.Declarable;
import com.gemstone.gemfire.cache.DiskWriteAttributesFactory;
import com.gemstone.gemfire.cache.EvictionAction;
import com.gemstone.gemfire.cache.EvictionAttributes;
import com.gemstone.gemfire.cache.ExpirationAction;
import com.gemstone.gemfire.cache.ExpirationAttributes;
import com.gemstone.gemfire.cache.LoaderHelper;
import com.gemstone.gemfire.cache.MirrorType;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.client.PoolManager;
import com.gemstone.gemfire.cache.util.BridgeClient;
import com.gemstone.gemfire.cache.util.ObjectSizer;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.cache30.TestCacheListener;
import com.gemstone.gemfire.cache30.TestCacheWriter;
import com.gemstone.gemfire.cache30.TestTransactionListener;
import com.gemstone.gemfire.i18n.LogWriterI18n;
import com.gemstone.gemfire.internal.AvailablePortHelper;
import com.gemstone.gemfire.internal.cache.xmlcache.CacheCreation;
import com.gemstone.gemfire.internal.cache.xmlcache.CacheXmlGenerator;
import com.gemstone.gemfire.internal.cache.xmlcache.CacheXmlParser;
import com.gemstone.gemfire.internal.cache.xmlcache.ClientCacheCreation;
import com.gemstone.gemfire.internal.cache.xmlcache.Declarable2;
import com.gemstone.gemfire.internal.cache.xmlcache.RegionAttributesCreation;
import com.gemstone.gemfire.internal.cache.xmlcache.RegionCreation;
import dunit.DistributedTestCase;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.Properties;
import junit.framework.TestCase;
import org.xml.sax.SAXException;

public class CacheXml30Test
extends CacheTestCase {
    private File xmlFile;
    static boolean lonerDistributedSystem = true;

    public CacheXml30Test(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        CacheXml30Test.disconnectAllFromDS();
    }

    @Override
    public void tearDown2() throws Exception {
        this.xmlFile = null;
        super.tearDown2();
        CacheXml30Test.disconnectAllFromDS();
    }

    protected String getGemFireVersion() {
        return "3_0";
    }

    protected void setXmlFile(File xmlFile) {
        this.xmlFile = xmlFile;
    }

    protected File findFile(String fileName) {
        File dir = new File(System.getProperty("JTESTS"));
        if (!dir.exists()) {
            String s = "Could not find JTESTS";
            throw new IllegalStateException(s);
        }
        String[] subdirs = new String[]{"com", "gemstone", "gemfire", "cache30"};
        for (int i = 0; i < subdirs.length; ++i) {
            if ((dir = new File(dir, subdirs[i])).exists()) continue;
            String s = "Could not find " + dir;
            throw new IllegalStateException(s);
        }
        File file = new File(dir, fileName);
        return file;
    }

    @Override
    public Properties getDistributedSystemProperties() {
        Properties props = super.getDistributedSystemProperties();
        if (this.xmlFile != null) {
            props.setProperty("cache-xml-file", this.xmlFile.toString());
        }
        if (lonerDistributedSystem) {
            props.setProperty("mcast-port", "0");
            props.setProperty("locators", "");
        }
        return props;
    }

    protected void testXml(CacheCreation creation) {
        this.testXml(creation, true);
    }

    protected void testXml(CacheCreation creation, boolean checkSame) {
        File dir = new File("XML_" + this.getGemFireVersion());
        dir.mkdirs();
        File file = new File(dir, this.getUniqueName() + ".xml");
        boolean useSchema = false;
        String version = this.getGemFireVersion();
        try {
            PrintWriter pw = new PrintWriter((Writer)new FileWriter(file), true);
            CacheXmlGenerator.generate((Cache)creation, (PrintWriter)pw, (boolean)false, (String)version);
            pw.close();
        }
        catch (IOException ex) {
            String s = "While generating XML";
            CacheXml30Test.fail(s, ex);
        }
        this.setXmlFile(file);
        boolean client = creation instanceof ClientCacheCreation;
        Cache cache = this.getCache(client);
        try {
            if (checkSame && !creation.sameAs(cache)) {
                StringWriter sw = new StringWriter();
                CacheXmlGenerator.generate((Cache)creation, (PrintWriter)new PrintWriter((Writer)sw, true), (boolean)false, (String)version);
                CacheXmlGenerator.generate((Cache)cache, (PrintWriter)new PrintWriter((Writer)sw, true), (boolean)false, (String)version);
                CacheXml30Test.fail((String)sw.toString());
            }
        }
        catch (RuntimeException re) {
            StringWriter sw = new StringWriter();
            CacheXmlGenerator.generate((Cache)creation, (PrintWriter)new PrintWriter((Writer)sw, true), (boolean)false, (String)version);
            CacheXmlGenerator.generate((Cache)cache, (PrintWriter)new PrintWriter((Writer)sw, true), (boolean)false, (String)version);
            CacheXml30Test.fail(sw.toString(), re);
        }
    }

    public void testNonExistentFile() throws IOException {
        File nonExistent = new File(this.getName() + ".xml");
        nonExistent.delete();
        this.setXmlFile(nonExistent);
        try {
            this.getCache();
            CacheXml30Test.fail((String)"Should have thrown a CacheXmlException");
        }
        catch (CacheXmlException cacheXmlException) {
            // empty catch block
        }
    }

    public void testXmlFileIsDirectory() {
        File dir = new File(this.getName() + "dir");
        dir.mkdirs();
        dir.deleteOnExit();
        this.setXmlFile(dir);
        try {
            this.getCache();
            CacheXml30Test.fail((String)"Should have thrown a CacheXmlException");
        }
        catch (CacheXmlException cacheXmlException) {
            // empty catch block
        }
    }

    public void testDefaultCache() {
        CacheCreation cache = new CacheCreation();
        this.testXml(cache);
    }

    public void testNonDefaultCache() {
        CacheCreation cache = new CacheCreation();
        cache.setLockTimeout(42);
        cache.setLockLease(43);
        cache.setSearchTimeout(44);
        if (this.getGemFireVersion().compareTo("4_0") >= 0) {
            cache.setCopyOnRead(true);
        }
        this.testXml(cache);
    }

    public void testEntriesInRootRegion() throws CacheException {
        CacheCreation cache = new CacheCreation();
        RegionCreation root = (RegionCreation)cache.createRegion("root", (RegionAttributes)new RegionAttributesCreation(cache));
        root.put((Object)"KEY1", (Object)"VALUE1");
        root.put((Object)"KEY2", (Object)"VALUE2");
        root.put((Object)"KEY3", (Object)"VALUE3");
        this.testXml(cache);
    }

    public void testConstrainedKeys() throws CacheException {
        CacheCreation cache = new CacheCreation();
        RegionAttributesCreation attrs = new RegionAttributesCreation(cache);
        attrs.setKeyConstraint(String.class);
        cache.createRegion("root", (RegionAttributes)attrs);
        this.testXml(cache);
    }

    public void testExpirationAttriubutes() throws CacheException {
        CacheCreation cache = new CacheCreation();
        RegionAttributesCreation attrs = new RegionAttributesCreation(cache);
        attrs.setStatisticsEnabled(true);
        ExpirationAttributes expire = new ExpirationAttributes(42, ExpirationAction.INVALIDATE);
        attrs.setRegionTimeToLive(expire);
        expire = new ExpirationAttributes(43, ExpirationAction.DESTROY);
        attrs.setRegionIdleTimeout(expire);
        expire = new ExpirationAttributes(44, ExpirationAction.LOCAL_INVALIDATE);
        attrs.setEntryTimeToLive(expire);
        expire = new ExpirationAttributes(45, ExpirationAction.LOCAL_DESTROY);
        attrs.setEntryIdleTimeout(expire);
        cache.createRegion("root", (RegionAttributes)attrs);
        this.testXml(cache);
    }

    public void testCacheLoaderWithDeclarables() throws CacheException {
        CacheCreation cache = new CacheCreation();
        RegionAttributesCreation attrs = new RegionAttributesCreation(cache);
        CacheLoaderWithDeclarables loader = new CacheLoaderWithDeclarables();
        attrs.setCacheLoader((CacheLoader)loader);
        cache.createRegion("root", (RegionAttributes)attrs);
        this.testXml(cache);
    }

    public void testBridgeClientAsLoader() throws CacheException {
        this.getSystem();
        CacheCreation cache = new CacheCreation();
        RegionAttributesCreation attrs = new RegionAttributesCreation(cache);
        int[] ports = AvailablePortHelper.getRandomAvailableTCPPorts(1);
        TestBridgeClient bc = new TestBridgeClient();
        Properties props = new Properties();
        props.setProperty("endpoints", "server=" + DistributedTestCase.getIPLiteral() + ":" + ports[0]);
        bc.init(props);
        attrs.setCacheLoader((CacheLoader)bc);
        cache.createRegion("root", (RegionAttributes)attrs);
        this.testXml(cache);
        Region ro = cache.getRegion("root");
        CacheXml30Test.assertSame((Object)ro.getAttributes().getCacheLoader(), (Object)ro.getAttributes().getCacheWriter());
        CacheXml30Test.assertTrue((boolean)(ro.getAttributes().getCacheLoader() instanceof TestBridgeClient));
        CacheXml30Test.assertEquals((String)("pools=" + PoolManager.getAll()), (int)1, (int)PoolManager.getAll().size());
    }

    public void testBridgeClientWriterOverride() throws CacheException {
        this.getSystem();
        CacheCreation cache = new CacheCreation();
        RegionAttributesCreation attrs = new RegionAttributesCreation(cache);
        int[] ports = AvailablePortHelper.getRandomAvailableTCPPorts(1);
        TestBridgeClient bc = new TestBridgeClient();
        Properties props = new Properties();
        props.setProperty("endpoints", "server=" + DistributedTestCase.getIPLiteral() + ":" + ports[0]);
        bc.init(props);
        attrs.setCacheLoader((CacheLoader)bc);
        attrs.setCacheWriter((CacheWriter)new MyTestCacheWriter());
        cache.createRegion("root", (RegionAttributes)attrs);
        this.testXml(cache);
        Region ro = cache.getRegion("root");
        CacheXml30Test.assertTrue((boolean)(ro.getAttributes().getCacheLoader() instanceof BridgeClient));
        CacheXml30Test.assertTrue((boolean)(ro.getAttributes().getCacheWriter() instanceof MyTestCacheWriter));
        CacheXml30Test.assertEquals((String)("pools=" + PoolManager.getAll()), (int)1, (int)PoolManager.getAll().size());
    }

    public void testBridgeClientLoaderOverride() throws CacheException {
        this.getSystem();
        CacheCreation cache = new CacheCreation();
        RegionAttributesCreation attrs = new RegionAttributesCreation(cache);
        int[] ports = AvailablePortHelper.getRandomAvailableTCPPorts(1);
        TestBridgeClient bc = new TestBridgeClient();
        Properties props = new Properties();
        props.setProperty("endpoints", "server=" + DistributedTestCase.getIPLiteral() + ":" + ports[0]);
        bc.init(props);
        attrs.setCacheWriter((CacheWriter)bc);
        attrs.setCacheLoader((CacheLoader)new CacheLoaderWithDeclarables());
        cache.createRegion("root", (RegionAttributes)attrs);
        this.testXml(cache);
        Region ro = cache.getRegion("root");
        CacheXml30Test.assertTrue((boolean)(ro.getAttributes().getCacheWriter() instanceof BridgeClient));
        CacheXml30Test.assertTrue((boolean)(ro.getAttributes().getCacheLoader() instanceof CacheLoaderWithDeclarables));
        CacheXml30Test.assertEquals((String)("pools=" + PoolManager.getAll()), (int)1, (int)PoolManager.getAll().size());
    }

    public void testBridgeClientAsWriter() throws CacheException {
        this.getSystem();
        CacheCreation cache = new CacheCreation();
        RegionAttributesCreation attrs = new RegionAttributesCreation(cache);
        int[] ports = AvailablePortHelper.getRandomAvailableTCPPorts(1);
        TestBridgeClient bc = new TestBridgeClient();
        Properties props = new Properties();
        props.setProperty("endpoints", "server=" + DistributedTestCase.getIPLiteral() + ":" + ports[0]);
        bc.init(props);
        attrs.setCacheWriter((CacheWriter)bc);
        cache.createRegion("root", (RegionAttributes)attrs);
        this.testXml(cache);
        Region ro = cache.getRegion("root");
        CacheXml30Test.assertSame((Object)ro.getAttributes().getCacheLoader(), (Object)ro.getAttributes().getCacheWriter());
        CacheXml30Test.assertTrue((boolean)(ro.getAttributes().getCacheWriter() instanceof TestBridgeClient));
        CacheXml30Test.assertEquals((String)("pools=" + PoolManager.getAll()), (int)1, (int)PoolManager.getAll().size());
    }

    public void testCacheWriter() throws CacheException {
        CacheCreation cache = new CacheCreation();
        RegionAttributesCreation attrs = new RegionAttributesCreation(cache);
        MyTestCacheWriter writer = new MyTestCacheWriter();
        attrs.setCacheWriter((CacheWriter)writer);
        cache.createRegion("root", (RegionAttributes)attrs);
        this.testXml(cache);
    }

    public void testCacheListener() throws CacheException {
        CacheCreation cache = new CacheCreation();
        RegionAttributesCreation attrs = new RegionAttributesCreation(cache);
        MyTestCacheListener listener = new MyTestCacheListener();
        attrs.setCacheListener((CacheListener)listener);
        cache.createRegion("root", (RegionAttributes)attrs);
        this.testXml(cache);
    }

    public void testNonDefaultRegionAttributes() throws CacheException {
        CacheCreation cache = new CacheCreation();
        RegionAttributesCreation attrs = new RegionAttributesCreation(cache);
        attrs.setScope(Scope.DISTRIBUTED_NO_ACK);
        attrs.setMirrorType(MirrorType.KEYS_VALUES);
        attrs.setInitialCapacity(142);
        attrs.setLoadFactor(42.42f);
        attrs.setStatisticsEnabled(false);
        cache.createRegion("root", (RegionAttributes)attrs);
        this.testXml(cache);
    }

    public void testMalformed() {
        this.setXmlFile(this.findFile("malformed.xml"));
        try {
            this.getCache();
            CacheXml30Test.fail((String)"Should have thrown a CacheXmlException");
        }
        catch (CacheXmlException ex) {
            CacheXml30Test.assertTrue((boolean)(ex.getCause() instanceof SAXException));
        }
    }

    public void testBadInt() {
        this.setXmlFile(this.findFile("badInt.xml"));
        try {
            this.getCache();
            CacheXml30Test.fail((String)"Should have thrown a CacheXmlException");
        }
        catch (CacheXmlException ex) {
            Throwable cause = ex.getCause();
            CacheXml30Test.assertNotNull((String)"Expected a cause", (Object)cause);
            CacheXml30Test.assertTrue((String)("Didn't expect cause:" + cause + " (a " + cause.getClass().getName() + ")"), (boolean)(cause instanceof NumberFormatException));
        }
    }

    public void testBadFloat() {
        this.setXmlFile(this.findFile("badFloat.xml"));
        try {
            this.getCache();
            CacheXml30Test.fail((String)"Should have thrown a CacheXmlException");
        }
        catch (CacheXmlException ex) {
            CacheXml30Test.assertTrue((boolean)(ex.getCause() instanceof NumberFormatException));
        }
    }

    public void testBadScope() {
        this.setXmlFile(this.findFile("badScope.xml"));
        try {
            this.getCache();
            CacheXml30Test.fail((String)"Should have thrown a CacheXmlException");
        }
        catch (CacheXmlException ex) {
            CacheXml30Test.assertTrue((boolean)(ex.getCause() instanceof SAXException));
        }
    }

    public void testBadKeyConstraintClass() {
        this.setXmlFile(this.findFile("badKeyConstraintClass.xml"));
        try {
            this.getCache();
            CacheXml30Test.fail((String)"Should have thrown a CacheXmlException");
        }
        catch (CacheXmlException ex) {
            CacheXml30Test.assertTrue((boolean)(ex.getCause() instanceof ClassNotFoundException));
        }
    }

    public void testCallbackNotDeclarable() {
        this.setXmlFile(this.findFile("callbackNotDeclarable.xml"));
        try {
            this.getCache();
            CacheXml30Test.fail((String)"Should have thrown a CacheXmlException");
        }
        catch (CacheXmlException ex) {
            Throwable cause = ex.getCause();
            CacheXml30Test.assertNull((Object)cause);
        }
    }

    public void testCallbackWithException() {
        this.setXmlFile(this.findFile("callbackWithException.xml"));
        try {
            this.getCache();
            CacheXml30Test.fail((String)"Should have thrown a CacheXmlException");
        }
        catch (CacheXmlException ex) {
            CacheXml30Test.assertTrue((boolean)(ex.getCause() instanceof TestException));
        }
    }

    public void testLoaderNotLoader() {
        this.setXmlFile(this.findFile("loaderNotLoader.xml"));
        try {
            this.getCache();
            CacheXml30Test.fail((String)"Should have thrown a CacheXmlException");
        }
        catch (CacheXmlException ex) {
            Throwable cause = ex.getCause();
            CacheXml30Test.assertNull((String)("Didn't expect a " + cause), (Object)cause);
        }
    }

    public void testNestedRegions() throws CacheException {
        CacheCreation cache = new CacheCreation();
        RegionAttributesCreation attrs = new RegionAttributesCreation(cache);
        attrs.setScope(Scope.DISTRIBUTED_NO_ACK);
        RegionCreation root = (RegionCreation)cache.createRegion("root", (RegionAttributes)attrs);
        attrs = new RegionAttributesCreation(cache);
        attrs.setScope(Scope.DISTRIBUTED_NO_ACK);
        attrs.setMirrorType(MirrorType.KEYS_VALUES);
        attrs.setInitialCapacity(142);
        attrs.setLoadFactor(42.42f);
        attrs.setStatisticsEnabled(false);
        root.createSubregion("one", (RegionAttributes)attrs);
        attrs = new RegionAttributesCreation(cache);
        attrs.setScope(Scope.DISTRIBUTED_ACK);
        attrs.setMirrorType(MirrorType.KEYS);
        attrs.setInitialCapacity(242);
        Region region = root.createSubregion("two", (RegionAttributes)attrs);
        attrs = new RegionAttributesCreation(cache);
        attrs.setScope(Scope.GLOBAL);
        attrs.setLoadFactor(43.43f);
        region.createSubregion("three", (RegionAttributes)attrs);
        this.testXml(cache);
    }

    public void testAttributesUnordered() {
        this.setXmlFile(this.findFile("attributesUnordered.xml"));
        this.getCache();
    }

    public void testDiskDirs() throws CacheException {
        CacheCreation cache = new CacheCreation();
        RegionAttributesCreation attrs = new RegionAttributesCreation(cache);
        File[] dirs = new File[]{new File(this.getUniqueName() + "-dir1"), new File(this.getUniqueName() + "-dir2")};
        for (int i = 0; i < dirs.length; ++i) {
            dirs[i].mkdirs();
            dirs[i].deleteOnExit();
        }
        int[] diskSizes = new int[]{Integer.MAX_VALUE, Integer.MAX_VALUE};
        attrs.setDiskDirsAndSize(dirs, diskSizes);
        cache.createRegion("root", (RegionAttributes)attrs);
        this.testXml(cache);
    }

    public void testOverflowAndBackup() throws CacheException {
        CacheCreation cache = new CacheCreation();
        RegionAttributesCreation attrs = new RegionAttributesCreation(cache);
        attrs.setMirrorType(MirrorType.KEYS_VALUES);
        attrs.setPersistBackup(true);
        cache.createRegion("root", (RegionAttributes)attrs);
        this.testXml(cache);
    }

    public void testDiskWriteAttributes() throws CacheException {
        CacheCreation cache = new CacheCreation();
        RegionAttributesCreation attrs = new RegionAttributesCreation(cache);
        RegionCreation root = (RegionCreation)cache.createRegion("root", (RegionAttributes)attrs);
        attrs = new RegionAttributesCreation(cache);
        DiskWriteAttributesFactory dwaf = new DiskWriteAttributesFactory();
        dwaf.setSynchronous(true);
        attrs.setDiskWriteAttributes(dwaf.create());
        root.createSubregion("sync", (RegionAttributes)attrs);
        attrs = new RegionAttributesCreation(cache);
        dwaf = new DiskWriteAttributesFactory();
        dwaf.setTimeInterval(123L);
        dwaf.setBytesThreshold(456L);
        attrs.setDiskWriteAttributes(dwaf.create());
        root.createSubregion("async", (RegionAttributes)attrs);
        this.testXml(cache);
    }

    public void testExampleCacheXmlFile() throws Exception {
        String dirName = "examples_" + this.getGemFireVersion();
        File dir = this.findFile(dirName);
        if (dir.exists()) {
            File[] xmlFiles = dir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".xml");
                }
            });
            CacheXml30Test.assertTrue((String)("No XML files in " + dirName), (xmlFiles.length > 0 ? 1 : 0) != 0);
            for (int i = 0; i < xmlFiles.length; ++i) {
                File xmlFile = xmlFiles[i];
                CacheXml30Test.getLogWriter().info("Parsing " + xmlFile);
                FileInputStream fis = new FileInputStream(xmlFile);
                CacheXmlParser.parse((InputStream)fis, (LogWriterI18n)CacheXml30Test.getLogWriter().convertToLogWriterI18n());
            }
        } else {
            Class<CacheXmlParser> c = CacheXmlParser.class;
            URL url = c.getProtectionDomain().getCodeSource().getLocation();
            File gemfireJar = new File(url.getPath());
            CacheXml30Test.assertTrue((String)("gemfire.jar (" + gemfireJar + ") doesn't exist???"), (boolean)gemfireJar.exists());
            File lib = gemfireJar.getParentFile();
            File product = lib.getParentFile();
            File docs = new File(product, "docs");
            File japi = new File(docs, "japi");
            File com = new File(japi, "com");
            File gemstone = new File(com, "gemstone");
            File gemfire = new File(gemstone, "gemfire");
            File cache = new File(gemfire, "cache");
            File doc_files = new File(cache, "doc-files");
            File example = new File(doc_files, "example-cache.xml");
            CacheXml30Test.assertTrue((String)("Could not find example cache.xml file: " + example), (boolean)example.exists());
            FileInputStream fis = new FileInputStream(example);
            CacheXmlParser.parse((InputStream)fis, (LogWriterI18n)CacheXml30Test.getLogWriter().convertToLogWriterI18n());
            File example2 = new File(doc_files, "example2-cache.xml");
            fis = new FileInputStream(example2);
            CacheXmlParser.parse((InputStream)fis, (LogWriterI18n)CacheXml30Test.getLogWriter().convertToLogWriterI18n());
            File example3 = new File(doc_files, "example3-cache.xml");
            fis = new FileInputStream(example3);
            CacheXmlParser.parse((InputStream)fis, (LogWriterI18n)CacheXml30Test.getLogWriter().convertToLogWriterI18n());
        }
    }

    public void testEvictionLRUEntryAttributes() throws Exception {
        String rName = this.getUniqueName();
        CacheCreation cache = new CacheCreation();
        RegionAttributesCreation attrs = new RegionAttributesCreation(cache);
        attrs.setEvictionAttributes(EvictionAttributes.createLRUEntryAttributes((int)80, (EvictionAction)EvictionAction.LOCAL_DESTROY));
        cache.createRegion(rName, (RegionAttributes)attrs);
        this.testXml(cache);
    }

    public void testEvictionLRUMemoryAttributes() throws Exception {
        String rName = this.getUniqueName();
        CacheCreation cache = new CacheCreation();
        RegionAttributesCreation attrs = new RegionAttributesCreation(cache);
        attrs.setEvictionAttributes(EvictionAttributes.createLRUMemoryAttributes((int)10, (ObjectSizer)new EvictionObjectSizer()));
        cache.createRegion(rName, (RegionAttributes)attrs);
        this.testXml(cache);
    }

    public void testEvictionLRUHeapAttributes() throws Exception {
        String rName = this.getUniqueName();
        CacheCreation cache = new CacheCreation();
        RegionAttributesCreation attrs = new RegionAttributesCreation(cache);
        attrs.setEvictionAttributes(EvictionAttributes.createLRUHeapAttributes((ObjectSizer)new EvictionObjectSizer(), (EvictionAction)EvictionAction.LOCAL_DESTROY));
        cache.createRegion(rName, (RegionAttributes)attrs);
        this.testXml(cache);
    }

    public static class TestDeclarable
    implements Declarable {
        public void init(Properties props) {
        }

        public boolean equals(Object o) {
            return o instanceof TestDeclarable;
        }
    }

    public static class CacheLoaderWithDeclarables
    implements CacheLoader,
    Declarable2 {
        private Properties props = new Properties();
        private boolean initialized = false;

        public CacheLoaderWithDeclarables() {
            this.props.put("KEY1", "VALUE1");
            this.props.put("KEY2", new TestDeclarable());
        }

        public boolean isInitialized() {
            return this.initialized;
        }

        public void init(Properties props) {
            this.initialized = true;
            TestCase.assertEquals((Object)this.props, (Object)props);
        }

        public Properties getConfig() {
            return this.props;
        }

        public Object load(LoaderHelper helper) throws CacheLoaderException {
            TestCase.fail((String)"Loader shouldn't be invoked");
            return null;
        }

        public boolean equals(Object o) {
            if (o instanceof CacheLoaderWithDeclarables) {
                CacheLoaderWithDeclarables other = (CacheLoaderWithDeclarables)o;
                return this.props.equals(other.props);
            }
            return false;
        }

        public void close() {
        }
    }

    public static class MyTestTransactionListener
    extends TestTransactionListener
    implements Declarable {
        public void init(Properties props) {
        }

        public boolean equals(Object o) {
            return o instanceof MyTestTransactionListener;
        }
    }

    public static class MyTestCacheWriter
    extends TestCacheWriter
    implements Declarable {
        public void init(Properties props) {
        }

        public boolean equals(Object o) {
            return o instanceof MyTestCacheWriter;
        }
    }

    public static class MyTestCacheListener
    extends TestCacheListener
    implements Declarable {
        public void init(Properties props) {
        }

        public boolean equals(Object o) {
            return o instanceof MyTestCacheListener;
        }
    }

    public static class ExceptionalCacheListener
    extends TestCacheListener {
        public ExceptionalCacheListener() {
            throw new TestException();
        }
    }

    public static class TestException
    extends RuntimeException {
        public TestException() {
            super("Test Exception");
        }
    }

    public static class NotDeclarableCacheListener
    extends TestCacheListener {
    }

    public static class EvictionObjectSizer
    implements ObjectSizer,
    Declarable2 {
        Properties props = new Properties();

        public int sizeof(Object o) {
            return 1;
        }

        public Properties getConfig() {
            if (null == this.props) {
                this.props = new Properties();
            }
            this.props.setProperty("EvictionObjectSizerColor", "blue");
            return this.props;
        }

        public void init(Properties props) {
            this.props = props;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof EvictionObjectSizer)) {
                return false;
            }
            EvictionObjectSizer other = (EvictionObjectSizer)obj;
            return this.props.equals(other.props);
        }
    }

    public static class TestBridgeClient
    extends BridgeClient {
        public boolean equals(Object obj) {
            return obj instanceof BridgeClient;
        }
    }
}

