/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache30;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.CacheXmlException;
import com.gemstone.gemfire.cache.DynamicRegionFactory;
import com.gemstone.gemfire.cache.ExpirationAction;
import com.gemstone.gemfire.cache.ExpirationAttributes;
import com.gemstone.gemfire.cache.MirrorType;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.RegionExistsException;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.util.BridgeServer;
import com.gemstone.gemfire.cache.util.BridgeWriter;
import com.gemstone.gemfire.cache30.CacheXml30Test;
import com.gemstone.gemfire.cache30.CacheXml40Test;
import com.gemstone.gemfire.internal.cache.xmlcache.CacheCreation;
import com.gemstone.gemfire.internal.cache.xmlcache.CacheXmlGenerator;
import com.gemstone.gemfire.internal.cache.xmlcache.RegionAttributesCreation;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import org.xml.sax.SAXException;

public class CacheXml41Test
extends CacheXml40Test {
    public CacheXml41Test(String name) {
        super(name);
    }

    @Override
    protected String getGemFireVersion() {
        return "4_1";
    }

    @Override
    public void setBridgeAttributes(BridgeServer bridge1) {
        super.setBridgeAttributes(bridge1);
        bridge1.setMaximumTimeBetweenPings(12345);
        bridge1.setNotifyBySubscription(true);
        bridge1.setSocketBufferSize(98765);
    }

    public void testRegisteringNamedRegionAttributes() {
        CacheCreation cache = new CacheCreation();
        String id1 = "id1";
        RegionAttributesCreation attrs = new RegionAttributesCreation(cache);
        attrs.setScope(Scope.DISTRIBUTED_ACK);
        attrs.setMirrorType(MirrorType.KEYS);
        cache.setRegionAttributes(id1, (RegionAttributes)attrs);
        String id2 = "id2";
        attrs = new RegionAttributesCreation(cache);
        attrs.setScope(Scope.DISTRIBUTED_NO_ACK);
        attrs.setMirrorType(MirrorType.KEYS_VALUES);
        attrs.setConcurrencyLevel(15);
        cache.setRegionAttributes(id2, (RegionAttributes)attrs);
        String id3 = "id3";
        attrs = new RegionAttributesCreation(cache);
        attrs.setScope(Scope.LOCAL);
        attrs.setValueConstraint(Integer.class);
        cache.setRegionAttributes(id3, (RegionAttributes)attrs);
        this.testXml(cache);
    }

    public void testNamedAttributes() throws CacheException {
        this.setXmlFile(this.findFile("namedAttributes.xml"));
        Class<String> keyConstraint = String.class;
        Class<Integer> valueConstraint = Integer.class;
        String id = "id1";
        String regionName = "root";
        Cache cache = this.getCache();
        RegionAttributes attrs = cache.getRegionAttributes(id);
        CacheXml41Test.assertEquals(keyConstraint, (Object)attrs.getKeyConstraint());
        CacheXml41Test.assertEquals(valueConstraint, (Object)attrs.getValueConstraint());
        CacheXml41Test.assertEquals((int)45, (int)attrs.getEntryIdleTimeout().getTimeout());
        CacheXml41Test.assertEquals((Object)ExpirationAction.INVALIDATE, (Object)attrs.getEntryIdleTimeout().getAction());
        Region region = cache.getRegion(regionName);
        CacheXml41Test.assertNotNull((Object)region);
        attrs = region.getAttributes();
        CacheXml41Test.assertEquals(keyConstraint, (Object)attrs.getKeyConstraint());
        CacheXml41Test.assertEquals(valueConstraint, (Object)attrs.getValueConstraint());
        CacheXml41Test.assertEquals((int)45, (int)attrs.getEntryIdleTimeout().getTimeout());
        CacheXml41Test.assertEquals((Object)ExpirationAction.INVALIDATE, (Object)attrs.getEntryIdleTimeout().getAction());
        Region subregion = region.getSubregion("subregion");
        CacheXml41Test.assertNotNull((Object)subregion);
        attrs = subregion.getAttributes();
        CacheXml41Test.assertEquals(keyConstraint, (Object)attrs.getKeyConstraint());
        CacheXml41Test.assertEquals(Long.class, (Object)attrs.getValueConstraint());
        CacheXml41Test.assertEquals((int)90, (int)attrs.getEntryIdleTimeout().getTimeout());
        CacheXml41Test.assertEquals((Object)ExpirationAction.DESTROY, (Object)attrs.getEntryIdleTimeout().getAction());
        CacheXml41Test.assertNotNull((Object)cache.getRegionAttributes("id2"));
    }

    public void testUnknownNamedAttributes() {
        this.setXmlFile(this.findFile("unknownNamedAttributes.xml"));
        try {
            this.getCache();
            CacheXml41Test.fail((String)"Should have thrown an IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testCreateSameRegionTwice() throws CacheException {
        block4: {
            CacheCreation cache = new CacheCreation();
            RegionAttributesCreation attrs = new RegionAttributesCreation(cache);
            String name = "root";
            cache.createRegion(name, (RegionAttributes)attrs);
            try {
                cache.createRegion(name, (RegionAttributes)attrs);
                CacheXml41Test.fail((String)"Should have thrown a RegionExistsException");
            }
            catch (RegionExistsException regionExistsException) {
                // empty catch block
            }
            this.setXmlFile(this.findFile("sameRootRegion.xml"));
            try {
                this.getCache();
                CacheXml41Test.fail((String)"Should have thrown a CacheXmlException");
            }
            catch (CacheXmlException ex) {
                Throwable cause = ex.getCause();
                CacheXml41Test.assertTrue((boolean)(cause instanceof SAXException));
                cause = ((SAXException)cause).getException();
                if (cause instanceof RegionExistsException) break block4;
                CacheXml41Test.fail("Expected a RegionExistsException, not a " + cause.getClass().getName(), cause);
            }
        }
    }

    public void testCreateSameSubregionTwice() throws CacheException {
        block4: {
            CacheCreation cache = new CacheCreation();
            RegionAttributesCreation attrs = new RegionAttributesCreation(cache);
            String name = this.getUniqueName();
            Region root = cache.createRegion("root", (RegionAttributes)attrs);
            root.createSubregion(name, (RegionAttributes)attrs);
            try {
                root.createSubregion(name, (RegionAttributes)attrs);
                CacheXml41Test.fail((String)"Should have thrown a RegionExistsException");
            }
            catch (RegionExistsException regionExistsException) {
                // empty catch block
            }
            this.setXmlFile(this.findFile("sameSubregion.xml"));
            try {
                this.getCache();
                CacheXml41Test.fail((String)"Should have thrown a CacheXmlException");
            }
            catch (CacheXmlException ex) {
                Throwable cause = ex.getCause();
                CacheXml41Test.assertTrue((boolean)(cause instanceof SAXException));
                cause = ((SAXException)cause).getException();
                if (cause instanceof RegionExistsException) break block4;
                CacheXml41Test.fail("Expected a RegionExistsException, not a " + cause.getClass().getName(), cause);
            }
        }
    }

    public InputStream generate(CacheCreation creation) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        boolean useSchema = false;
        String version = this.getGemFireVersion();
        PrintWriter pw = new PrintWriter((Writer)new OutputStreamWriter(baos), true);
        CacheXmlGenerator.generate((Cache)creation, (PrintWriter)pw, (boolean)false, (String)version);
        pw.close();
        byte[] bytes = baos.toByteArray();
        return new ByteArrayInputStream(bytes);
    }

    public void testModifyCacheAttributes() throws CacheException {
        boolean copyOnRead1 = false;
        boolean isServer1 = true;
        int lockLease1 = 123;
        int lockTimeout1 = 345;
        int searchTimeout1 = 567;
        CacheCreation creation = new CacheCreation();
        creation.setCopyOnRead(copyOnRead1);
        creation.setIsServer(isServer1);
        creation.setLockLease(lockLease1);
        creation.setLockTimeout(lockTimeout1);
        creation.setSearchTimeout(searchTimeout1);
        this.testXml(creation);
        Cache cache = this.getCache();
        CacheXml41Test.assertEquals((boolean)copyOnRead1, (boolean)cache.getCopyOnRead());
        CacheXml41Test.assertEquals((boolean)isServer1, (boolean)cache.isServer());
        CacheXml41Test.assertEquals((int)lockLease1, (int)cache.getLockLease());
        CacheXml41Test.assertEquals((int)lockTimeout1, (int)cache.getLockTimeout());
        CacheXml41Test.assertEquals((int)searchTimeout1, (int)cache.getSearchTimeout());
        boolean copyOnRead2 = true;
        boolean isServer2 = false;
        int lockLease2 = 234;
        int lockTimeout2 = 456;
        int searchTimeout2 = 678;
        creation = new CacheCreation();
        creation.setCopyOnRead(copyOnRead2);
        creation.setIsServer(isServer2);
        creation.setLockLease(lockLease2);
        creation.setLockTimeout(lockTimeout2);
        creation.setSearchTimeout(searchTimeout2);
        cache.loadCacheXml(this.generate(creation));
        CacheXml41Test.assertEquals((boolean)copyOnRead2, (boolean)cache.getCopyOnRead());
        CacheXml41Test.assertEquals((boolean)isServer2, (boolean)cache.isServer());
        CacheXml41Test.assertEquals((int)lockLease2, (int)cache.getLockLease());
        CacheXml41Test.assertEquals((int)lockTimeout2, (int)cache.getLockTimeout());
        CacheXml41Test.assertEquals((int)searchTimeout2, (int)cache.getSearchTimeout());
    }

    public void testAddRegionViaCacheXml() throws CacheException {
        CacheCreation creation = new CacheCreation();
        this.testXml(creation);
        Cache cache = this.getCache();
        CacheXml41Test.assertTrue((boolean)cache.rootRegions().isEmpty());
        creation = new CacheCreation();
        RegionAttributesCreation attrs = new RegionAttributesCreation(creation);
        attrs.setScope(Scope.GLOBAL);
        attrs.setKeyConstraint(Integer.class);
        attrs.setCacheListener((CacheListener)new CacheXml30Test.MyTestCacheListener());
        Region root = creation.createRegion("root", (RegionAttributes)attrs);
        attrs = new RegionAttributesCreation(creation);
        attrs.setScope(Scope.LOCAL);
        attrs.setEarlyAck(true);
        attrs.setValueConstraint(String.class);
        Region subregion = root.createSubregion("subregion", (RegionAttributes)attrs);
        cache.loadCacheXml(this.generate(creation));
        root = cache.getRegion("root");
        CacheXml41Test.assertNotNull((Object)root);
        CacheXml41Test.assertEquals((Object)Scope.GLOBAL, (Object)root.getAttributes().getScope());
        CacheXml41Test.assertEquals(Integer.class, (Object)root.getAttributes().getKeyConstraint());
        CacheXml41Test.assertTrue((boolean)(root.getAttributes().getCacheListener() instanceof CacheXml30Test.MyTestCacheListener));
        subregion = root.getSubregion("subregion");
        CacheXml41Test.assertNotNull((Object)subregion);
        CacheXml41Test.assertEquals((Object)Scope.LOCAL, (Object)subregion.getAttributes().getScope());
        CacheXml41Test.assertTrue((boolean)subregion.getAttributes().getEarlyAck());
        CacheXml41Test.assertFalse((boolean)subregion.getAttributes().getMulticastEnabled());
        CacheXml41Test.assertEquals(String.class, (Object)subregion.getAttributes().getValueConstraint());
        creation = new CacheCreation();
        attrs = new RegionAttributesCreation(creation);
        root = creation.createRegion("root", (RegionAttributes)attrs);
        attrs = new RegionAttributesCreation(creation);
        attrs.setScope(Scope.DISTRIBUTED_ACK);
        attrs.setEarlyAck(false);
        attrs.setValueConstraint(Long.class);
        Region subregion2 = root.createSubregion("subregion2", (RegionAttributes)attrs);
        cache.loadCacheXml(this.generate(creation));
        subregion2 = root.getSubregion("subregion2");
        CacheXml41Test.assertNotNull((Object)subregion2);
        CacheXml41Test.assertEquals((Object)Scope.DISTRIBUTED_ACK, (Object)subregion2.getAttributes().getScope());
        CacheXml41Test.assertTrue((!subregion2.getAttributes().getEarlyAck() ? 1 : 0) != 0);
        CacheXml41Test.assertEquals(Long.class, (Object)subregion2.getAttributes().getValueConstraint());
    }

    public void testModifyRegionViaCacheXml() throws CacheException {
        CacheCreation creation = new CacheCreation();
        int timeout1a = 123;
        ExpirationAction action1a = ExpirationAction.LOCAL_DESTROY;
        int timeout1b = 456;
        ExpirationAction action1b = ExpirationAction.DESTROY;
        RegionAttributesCreation attrs = new RegionAttributesCreation(creation);
        attrs.setStatisticsEnabled(true);
        attrs.setEntryIdleTimeout(new ExpirationAttributes(timeout1a, action1a));
        Region root = creation.createRegion("root", (RegionAttributes)attrs);
        attrs = new RegionAttributesCreation(creation);
        attrs.setStatisticsEnabled(true);
        attrs.setEntryIdleTimeout(new ExpirationAttributes(timeout1b, action1b));
        Region subregion = root.createSubregion("subregion", (RegionAttributes)attrs);
        this.testXml(creation);
        Cache cache = this.getCache();
        root = cache.getRegion("root");
        CacheXml41Test.assertEquals((int)timeout1a, (int)root.getAttributes().getEntryIdleTimeout().getTimeout());
        CacheXml41Test.assertEquals((Object)action1a, (Object)root.getAttributes().getEntryIdleTimeout().getAction());
        subregion = root.getSubregion("subregion");
        CacheXml41Test.assertEquals((int)timeout1b, (int)subregion.getAttributes().getEntryIdleTimeout().getTimeout());
        CacheXml41Test.assertEquals((Object)action1b, (Object)subregion.getAttributes().getEntryIdleTimeout().getAction());
        creation = new CacheCreation();
        int timeout2a = 234;
        ExpirationAction action2a = ExpirationAction.LOCAL_INVALIDATE;
        int timeout2b = 567;
        ExpirationAction action2b = ExpirationAction.INVALIDATE;
        attrs = new RegionAttributesCreation(creation);
        attrs.setStatisticsEnabled(true);
        attrs.setEntryIdleTimeout(new ExpirationAttributes(timeout2a, action2a));
        attrs.setCacheListener((CacheListener)new CacheXml30Test.MyTestCacheListener());
        root = creation.createRegion("root", (RegionAttributes)attrs);
        attrs = new RegionAttributesCreation(creation);
        attrs.setStatisticsEnabled(true);
        attrs.setEntryIdleTimeout(new ExpirationAttributes(timeout2b, action2b));
        subregion = root.createSubregion("subregion", (RegionAttributes)attrs);
        cache.loadCacheXml(this.generate(creation));
        root = cache.getRegion("root");
        subregion = root.getSubregion("subregion");
        CacheXml41Test.assertEquals((int)timeout2a, (int)root.getAttributes().getEntryIdleTimeout().getTimeout());
        CacheXml41Test.assertEquals((Object)action2a, (Object)root.getAttributes().getEntryIdleTimeout().getAction());
        CacheXml41Test.assertTrue((boolean)(root.getAttributes().getCacheListener() instanceof CacheXml30Test.MyTestCacheListener));
        CacheXml41Test.assertEquals((int)timeout2b, (int)subregion.getAttributes().getEntryIdleTimeout().getTimeout());
        CacheXml41Test.assertEquals((Object)action2b, (Object)subregion.getAttributes().getEntryIdleTimeout().getAction());
    }

    public void testAddEntriesViaCacheXml() throws CacheException {
        String key1 = "KEY1";
        String value1 = "VALUE1";
        CacheCreation creation = new CacheCreation();
        RegionAttributesCreation attrs = new RegionAttributesCreation(creation);
        attrs.setScope(Scope.LOCAL);
        Region root = creation.createRegion("root", (RegionAttributes)attrs);
        root.put((Object)key1, (Object)value1);
        this.testXml(creation);
        Cache cache = this.getCache();
        root = cache.getRegion("root");
        CacheXml41Test.assertEquals((int)1, (int)root.entries(false).size());
        CacheXml41Test.assertEquals((Object)value1, (Object)root.get((Object)key1));
        creation = new CacheCreation();
        attrs = new RegionAttributesCreation(creation);
        attrs.setScope(Scope.LOCAL);
        String value2 = "VALUE2";
        String key2 = "KEY2";
        String value3 = "VALUE3";
        root = creation.createRegion("root", (RegionAttributes)attrs);
        root.put((Object)key1, (Object)value2);
        root.put((Object)key2, (Object)value3);
        cache.loadCacheXml(this.generate(creation));
        root = cache.getRegion("root");
        CacheXml41Test.assertEquals((int)2, (int)root.entries(false).size());
        CacheXml41Test.assertEquals((Object)value2, (Object)root.get((Object)key1));
        CacheXml41Test.assertEquals((Object)value3, (Object)root.get((Object)key2));
    }

    public void testEnableGatewayAttribute() throws CacheException {
        CacheCreation cache = new CacheCreation();
        RegionAttributesCreation attrs = new RegionAttributesCreation(cache);
        attrs.setEnableGateway(true);
        cache.createRegion("root", (RegionAttributes)attrs);
        this.testXml(cache);
        CacheXml41Test.assertEquals((boolean)true, (boolean)cache.getRegion("root").getAttributes().getEnableGateway());
    }

    public void testPublisherAttribute() throws CacheException {
    }

    public void testEnableBridgeConflationAttribute() throws CacheException {
        CacheCreation cache = new CacheCreation();
        RegionAttributesCreation attrs = new RegionAttributesCreation(cache);
        attrs.setEnableBridgeConflation(true);
        cache.createRegion("root", (RegionAttributes)attrs);
        this.testXml(cache);
        CacheXml41Test.assertEquals((boolean)true, (boolean)cache.getRegion("root").getAttributes().getEnableBridgeConflation());
    }

    public void testEnableAsyncConflationAttribute() throws CacheException {
        CacheCreation cache = new CacheCreation();
        RegionAttributesCreation attrs = new RegionAttributesCreation(cache);
        attrs.setEnableAsyncConflation(true);
        cache.createRegion("root", (RegionAttributes)attrs);
        this.testXml(cache);
        CacheXml41Test.assertEquals((boolean)true, (boolean)cache.getRegion("root").getAttributes().getEnableAsyncConflation());
    }

    public void testDynamicRegionFactoryDefault() throws CacheException {
        CacheCreation cache = new CacheCreation();
        cache.setDynamicRegionFactoryConfig(new DynamicRegionFactory.Config());
        RegionAttributesCreation attrs = new RegionAttributesCreation(cache);
        cache.createRegion("root", (RegionAttributes)attrs);
        this.testXml(cache, false);
        CacheXml41Test.assertEquals((boolean)true, (boolean)DynamicRegionFactory.get().getConfig().getRegisterInterest());
        CacheXml41Test.assertEquals((boolean)true, (boolean)DynamicRegionFactory.get().getConfig().getPersistBackup());
        CacheXml41Test.assertEquals((boolean)true, (boolean)DynamicRegionFactory.get().isOpen());
        CacheXml41Test.assertEquals(null, (Object)DynamicRegionFactory.get().getConfig().getDiskDir());
        CacheXml41Test.assertEquals(null, (Object)DynamicRegionFactory.get().getConfig().getBridgeWriter());
        Region dr = this.getCache().getRegion("__DynamicRegions");
        if (dr != null) {
            dr.localDestroyRegion();
        }
    }

    public void testDynamicRegionFactoryNonDefault() throws CacheException {
        CacheCreation cache = new CacheCreation();
        cache.setDynamicRegionFactoryConfig(new DynamicRegionFactory.Config((File)null, (BridgeWriter)null, false, false));
        RegionAttributesCreation attrs = new RegionAttributesCreation(cache);
        cache.createRegion("root", (RegionAttributes)attrs);
        this.testXml(cache, false);
        CacheXml41Test.assertEquals((boolean)false, (boolean)DynamicRegionFactory.get().getConfig().getRegisterInterest());
        CacheXml41Test.assertEquals((boolean)false, (boolean)DynamicRegionFactory.get().getConfig().getPersistBackup());
        CacheXml41Test.assertEquals((boolean)true, (boolean)DynamicRegionFactory.get().isOpen());
        CacheXml41Test.assertEquals(null, (Object)DynamicRegionFactory.get().getConfig().getDiskDir());
        CacheXml41Test.assertEquals(null, (Object)DynamicRegionFactory.get().getConfig().getBridgeWriter());
        Region dr = this.getCache().getRegion("__DynamicRegions");
        if (dr != null) {
            dr.localDestroyRegion();
        }
    }

    public void testDynamicRegionFactoryDiskDir() throws CacheException {
        CacheCreation cache = new CacheCreation();
        File f = new File("diskDir");
        f.mkdirs();
        cache.setDynamicRegionFactoryConfig(new DynamicRegionFactory.Config(f, null));
        RegionAttributesCreation attrs = new RegionAttributesCreation(cache);
        cache.createRegion("root", (RegionAttributes)attrs);
        this.testXml(cache, false);
        CacheXml41Test.assertEquals((boolean)true, (boolean)DynamicRegionFactory.get().isOpen());
        CacheXml41Test.assertEquals((Object)f.getAbsoluteFile(), (Object)DynamicRegionFactory.get().getConfig().getDiskDir());
        CacheXml41Test.assertEquals(null, (Object)DynamicRegionFactory.get().getConfig().getBridgeWriter());
        Region dr = this.getCache().getRegion("__DynamicRegions");
        if (dr != null) {
            dr.localDestroyRegion();
        }
    }

    public void _testDynamicRegionFactoryCacheWriter() throws CacheException {
        CacheCreation cache = new CacheCreation();
        CacheXml30Test.MyTestCacheWriter writer = new CacheXml30Test.MyTestCacheWriter();
        cache.setDynamicRegionFactoryConfig(new DynamicRegionFactory.Config(null, (BridgeWriter)writer));
        RegionAttributesCreation attrs = new RegionAttributesCreation(cache);
        cache.createRegion("root", (RegionAttributes)attrs);
        this.testXml(cache, false);
        CacheXml41Test.assertEquals((boolean)true, (boolean)DynamicRegionFactory.get().isOpen());
        CacheXml41Test.assertEquals(null, (Object)DynamicRegionFactory.get().getConfig().getDiskDir());
        CacheXml41Test.assertEquals((Object)writer, (Object)DynamicRegionFactory.get().getConfig().getBridgeWriter());
    }
}

