/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache30;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CustomExpiry;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.Declarable;
import com.gemstone.gemfire.cache.DynamicRegionFactory;
import com.gemstone.gemfire.cache.ExpirationAttributes;
import com.gemstone.gemfire.cache.InterestPolicy;
import com.gemstone.gemfire.cache.MirrorType;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.SubscriptionAttributes;
import com.gemstone.gemfire.cache.client.Pool;
import com.gemstone.gemfire.cache.client.PoolFactory;
import com.gemstone.gemfire.cache.client.PoolManager;
import com.gemstone.gemfire.cache.server.CacheServer;
import com.gemstone.gemfire.cache.server.ClientSubscriptionConfig;
import com.gemstone.gemfire.cache.server.ServerLoad;
import com.gemstone.gemfire.cache.server.ServerLoadProbe;
import com.gemstone.gemfire.cache.server.ServerLoadProbeAdapter;
import com.gemstone.gemfire.cache.server.ServerMetrics;
import com.gemstone.gemfire.cache.util.Gateway;
import com.gemstone.gemfire.cache.util.GatewayHub;
import com.gemstone.gemfire.cache.util.GatewayQueueAttributes;
import com.gemstone.gemfire.cache30.CacheXml55Test;
import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.internal.AvailablePortHelper;
import com.gemstone.gemfire.internal.cache.PoolFactoryImpl;
import com.gemstone.gemfire.internal.cache.xmlcache.CacheCreation;
import com.gemstone.gemfire.internal.cache.xmlcache.Declarable2;
import com.gemstone.gemfire.internal.cache.xmlcache.RegionAttributesCreation;
import com.gemstone.gemfire.internal.cache.xmlcache.RegionCreation;
import dunit.Host;
import dunit.SerializableCallable;
import dunit.VM;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import junit.framework.Assert;

public class CacheXml57Test
extends CacheXml55Test {
    private static final String ALIAS1;
    private static final String ALIAS2;

    public CacheXml57Test(String name) {
        super(name);
    }

    @Override
    protected String getGemFireVersion() {
        return "5_7";
    }

    public void testDefaultCacheServerGroups() throws CacheException {
        CacheCreation cache = new CacheCreation();
        CacheServer bs = cache.addCacheServer();
        bs.setPort(AvailablePortHelper.getRandomAvailableTCPPort());
        bs.setGroups(CacheServer.DEFAULT_GROUPS);
        this.testXml(cache);
        Cache c = this.getCache();
        CacheXml57Test.assertNotNull((Object)c);
        CacheServer server = (CacheServer)cache.getCacheServers().iterator().next();
        CacheXml57Test.assertNotNull((Object)server);
        CacheXml57Test.assertEquals((Object)CacheServer.DEFAULT_GROUPS, (Object)server.getGroups());
    }

    public void testOneCacheServerGroups() throws CacheException {
        CacheCreation cache = new CacheCreation();
        CacheServer bs = cache.addCacheServer();
        bs.setPort(AvailablePortHelper.getRandomAvailableTCPPort());
        String[] groups = new String[]{"group1"};
        bs.setGroups(groups);
        this.testXml(cache);
        Cache c = this.getCache();
        CacheXml57Test.assertNotNull((Object)c);
        CacheServer server = (CacheServer)cache.getCacheServers().iterator().next();
        CacheXml57Test.assertNotNull((Object)server);
        CacheXml57Test.assertEquals(Arrays.asList(groups), Arrays.asList(server.getGroups()));
    }

    public void testTwoCacheServerGroups() throws CacheException {
        CacheCreation cache = new CacheCreation();
        CacheServer bs = cache.addCacheServer();
        bs.setPort(AvailablePortHelper.getRandomAvailableTCPPort());
        String[] groups = new String[]{"group1", "group2"};
        bs.setGroups(groups);
        this.testXml(cache);
        Cache c = this.getCache();
        CacheXml57Test.assertNotNull((Object)c);
        CacheServer server = (CacheServer)cache.getCacheServers().iterator().next();
        CacheXml57Test.assertNotNull((Object)server);
        CacheXml57Test.assertEquals(Arrays.asList(groups), Arrays.asList(server.getGroups()));
    }

    public void testDefaultCacheServerBindAddress() throws CacheException {
        CacheCreation cache = new CacheCreation();
        CacheServer bs = cache.addCacheServer();
        bs.setPort(AvailablePortHelper.getRandomAvailableTCPPort());
        this.testXml(cache);
        Cache c = this.getCache();
        CacheXml57Test.assertNotNull((Object)c);
        CacheServer server = (CacheServer)cache.getCacheServers().iterator().next();
        CacheXml57Test.assertNotNull((Object)server);
        CacheXml57Test.assertEquals((String)"", (String)server.getBindAddress());
    }

    public void testCacheServerBindAddress() throws CacheException {
        CacheCreation cache = new CacheCreation();
        CacheServer bs = cache.addCacheServer();
        bs.setPort(AvailablePortHelper.getRandomAvailableTCPPort());
        String BA = ALIAS1;
        bs.setBindAddress(BA);
        this.testXml(cache);
        Cache c = this.getCache();
        CacheXml57Test.assertNotNull((Object)c);
        CacheServer server = (CacheServer)cache.getCacheServers().iterator().next();
        CacheXml57Test.assertNotNull((Object)server);
        CacheXml57Test.assertEquals((String)BA, (String)server.getBindAddress());
    }

    public void testCacheServerHostnameForClients() throws CacheException {
        CacheCreation cache = new CacheCreation();
        CacheServer bs = cache.addCacheServer();
        bs.setPort(AvailablePortHelper.getRandomAvailableTCPPort());
        String BA = ALIAS1;
        bs.setBindAddress(BA);
        bs.setHostnameForClients("clientHostName");
        this.testXml(cache);
        Cache c = this.getCache();
        CacheXml57Test.assertNotNull((Object)c);
        CacheServer server = (CacheServer)cache.getCacheServers().iterator().next();
        CacheXml57Test.assertNotNull((Object)server);
        CacheXml57Test.assertEquals((String)BA, (String)server.getBindAddress());
        CacheXml57Test.assertEquals((String)"clientHostName", (String)server.getHostnameForClients());
    }

    public void testExplicitConnectionPool() throws CacheException {
        this.getSystem();
        CacheCreation cache = new CacheCreation();
        PoolFactory f = cache.createPoolFactory();
        f.addServer(ALIAS2, 3777).addServer(ALIAS1, 3888);
        f.setFreeConnectionTimeout(12345).setLoadConditioningInterval(12345).setSocketBufferSize(12345).setThreadLocalConnections(true).setReadTimeout(12345).setMinConnections(12346).setMaxConnections(12347).setRetryAttempts(12348).setIdleTimeout(12349L).setPingInterval(12350L).setStatisticInterval(12351).setServerGroup("mygroup").setSubscriptionRedundancy(12345).setSubscriptionMessageTrackingTimeout(12345).setSubscriptionAckInterval(333);
        f.create("mypool");
        RegionAttributesCreation attrs = new RegionAttributesCreation(cache);
        attrs.setPoolName("mypool");
        cache.createVMRegion("rootNORMAL", (RegionAttributes)attrs);
        this.testXml(cache);
        Cache c = this.getCache();
        CacheXml57Test.assertNotNull((Object)c);
        Region r = c.getRegion("rootNORMAL");
        CacheXml57Test.assertNotNull((Object)r);
        CacheXml57Test.assertEquals((String)"mypool", (String)r.getAttributes().getPoolName());
        Pool cp = PoolManager.find((String)"mypool");
        CacheXml57Test.assertNotNull((Object)cp);
        CacheXml57Test.assertEquals((int)0, (int)cp.getLocators().size());
        CacheXml57Test.assertEquals((int)2, (int)cp.getServers().size());
        CacheXml57Test.assertEquals((Object)CacheXml57Test.createINSA(ALIAS2, 3777), cp.getServers().get(0));
        CacheXml57Test.assertEquals((Object)CacheXml57Test.createINSA(ALIAS1, 3888), cp.getServers().get(1));
        CacheXml57Test.assertEquals((int)12345, (int)cp.getFreeConnectionTimeout());
        CacheXml57Test.assertEquals((int)12345, (int)cp.getLoadConditioningInterval());
        CacheXml57Test.assertEquals((int)12345, (int)cp.getSocketBufferSize());
        CacheXml57Test.assertEquals((boolean)true, (boolean)cp.getThreadLocalConnections());
        CacheXml57Test.assertEquals((int)12345, (int)cp.getReadTimeout());
        CacheXml57Test.assertEquals((int)12346, (int)cp.getMinConnections());
        CacheXml57Test.assertEquals((int)12347, (int)cp.getMaxConnections());
        CacheXml57Test.assertEquals((int)12348, (int)cp.getRetryAttempts());
        CacheXml57Test.assertEquals((long)12349L, (long)cp.getIdleTimeout());
        CacheXml57Test.assertEquals((long)12350L, (long)cp.getPingInterval());
        CacheXml57Test.assertEquals((int)12351, (int)cp.getStatisticInterval());
        CacheXml57Test.assertEquals((String)"mygroup", (String)cp.getServerGroup());
        CacheXml57Test.assertEquals((int)12345, (int)cp.getSubscriptionRedundancy());
        CacheXml57Test.assertEquals((int)12345, (int)cp.getSubscriptionMessageTrackingTimeout());
        CacheXml57Test.assertEquals((int)333, (int)cp.getSubscriptionAckInterval());
    }

    public void testDefaultConnectionPool() throws CacheException {
        this.getSystem();
        CacheCreation cache = new CacheCreation();
        PoolFactory f = cache.createPoolFactory();
        f.addLocator(ALIAS2, 3777);
        f.create("mypool");
        RegionAttributesCreation attrs = new RegionAttributesCreation(cache);
        attrs.setPoolName("mypool");
        cache.createVMRegion("rootNORMAL", (RegionAttributes)attrs);
        this.testXml(cache);
        Cache c = this.getCache();
        CacheXml57Test.assertNotNull((Object)c);
        Region r = c.getRegion("rootNORMAL");
        CacheXml57Test.assertNotNull((Object)r);
        CacheXml57Test.assertEquals((String)"mypool", (String)r.getAttributes().getPoolName());
        Pool cp = PoolManager.find((String)"mypool");
        CacheXml57Test.assertNotNull((Object)cp);
        CacheXml57Test.assertEquals((int)1, (int)cp.getLocators().size());
        CacheXml57Test.assertEquals((int)0, (int)cp.getServers().size());
        CacheXml57Test.assertEquals((Object)CacheXml57Test.createINSA(ALIAS2, 3777), cp.getLocators().get(0));
        CacheXml57Test.assertEquals((int)10000, (int)cp.getFreeConnectionTimeout());
        CacheXml57Test.assertEquals((int)300000, (int)cp.getLoadConditioningInterval());
        CacheXml57Test.assertEquals((int)32768, (int)cp.getSocketBufferSize());
        CacheXml57Test.assertEquals((boolean)false, (boolean)cp.getThreadLocalConnections());
        CacheXml57Test.assertEquals((int)10000, (int)cp.getReadTimeout());
        CacheXml57Test.assertEquals((int)1, (int)cp.getMinConnections());
        CacheXml57Test.assertEquals((int)-1, (int)cp.getMaxConnections());
        CacheXml57Test.assertEquals((int)-1, (int)cp.getRetryAttempts());
        CacheXml57Test.assertEquals((long)5000L, (long)cp.getIdleTimeout());
        CacheXml57Test.assertEquals((long)10000L, (long)cp.getPingInterval());
        CacheXml57Test.assertEquals((int)-1, (int)cp.getStatisticInterval());
        CacheXml57Test.assertEquals((String)"", (String)cp.getServerGroup());
        CacheXml57Test.assertEquals((boolean)false, (boolean)cp.getSubscriptionEnabled());
        CacheXml57Test.assertEquals((int)0, (int)cp.getSubscriptionRedundancy());
        CacheXml57Test.assertEquals((int)900000, (int)cp.getSubscriptionMessageTrackingTimeout());
        CacheXml57Test.assertEquals((int)100, (int)cp.getSubscriptionAckInterval());
    }

    public void testTwoConnectionPools() throws CacheException {
        this.getSystem();
        CacheCreation cache = new CacheCreation();
        PoolFactory f = cache.createPoolFactory();
        f.addLocator(ALIAS2, 3777).create("mypool");
        f.reset().addLocator(ALIAS1, 3888).create("mypool2");
        try {
            f.create("mypool");
            CacheXml57Test.fail((String)"expected IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            f.create("mypool2");
            CacheXml57Test.fail((String)"expected IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        RegionAttributesCreation attrs = new RegionAttributesCreation(cache);
        attrs.setPoolName("mypool");
        cache.createVMRegion("rootNORMAL", (RegionAttributes)attrs);
        this.testXml(cache);
        Cache c = this.getCache();
        CacheXml57Test.assertNotNull((Object)c);
        Region r = c.getRegion("rootNORMAL");
        CacheXml57Test.assertNotNull((Object)r);
        CacheXml57Test.assertEquals((String)"mypool", (String)r.getAttributes().getPoolName());
        Pool cp = PoolManager.find((String)"mypool");
        CacheXml57Test.assertNotNull((Object)cp);
        CacheXml57Test.assertEquals((int)0, (int)cp.getServers().size());
        CacheXml57Test.assertEquals((int)1, (int)cp.getLocators().size());
        CacheXml57Test.assertEquals((Object)CacheXml57Test.createINSA(ALIAS2, 3777), cp.getLocators().get(0));
        cp = PoolManager.find((String)"mypool2");
        CacheXml57Test.assertNotNull((Object)cp);
        CacheXml57Test.assertEquals((int)0, (int)cp.getServers().size());
        CacheXml57Test.assertEquals((int)1, (int)cp.getLocators().size());
        CacheXml57Test.assertEquals((Object)CacheXml57Test.createINSA(ALIAS1, 3888), cp.getLocators().get(0));
    }

    private static InetSocketAddress createINSA(String host, int port) {
        try {
            InetAddress hostAddr = InetAddress.getByName(host);
            return new InetSocketAddress(hostAddr, port);
        }
        catch (UnknownHostException cause) {
            IllegalArgumentException ex = new IllegalArgumentException("Unknown host " + host);
            ex.initCause(cause);
            throw ex;
        }
    }

    public void testNoConnectionPools() throws CacheException {
        CacheCreation cache = new CacheCreation();
        RegionAttributesCreation attrs = new RegionAttributesCreation(cache);
        attrs.setPoolName("mypool");
        cache.createVMRegion("rootNORMAL", (RegionAttributes)attrs);
        try {
            this.testXml(cache);
            CacheXml57Test.fail((String)"expected IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAlreadyExistingPool() throws CacheException {
        this.getSystem();
        PoolFactoryImpl f = (PoolFactoryImpl)PoolManager.createFactory();
        f.setStartDisabled(true).addLocator(ALIAS2, 12345).create("mypool");
        try {
            CacheCreation cache = new CacheCreation();
            cache.createPoolFactory().addLocator(ALIAS2, 12345).create("mypool");
            try {
                this.testXml(cache);
                CacheXml57Test.fail((String)"expected IllegalStateException");
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        finally {
            PoolManager.close();
        }
    }

    public void testDynamicRegionFactoryConnectionPool() throws CacheException, IOException {
        this.getSystem();
        VM vm0 = Host.getHost(0).getVM(0);
        final int port = AvailablePortHelper.getRandomAvailableTCPPortOnVM(vm0);
        vm0.invoke(new SerializableCallable("Create cache server"){

            public Object call() throws IOException {
                DynamicRegionFactory.get().open();
                Cache cache = CacheXml57Test.this.getCache();
                CacheServer bridge = cache.addCacheServer();
                bridge.setPort(port);
                bridge.setNotifyBySubscription(true);
                bridge.start();
                return null;
            }
        });
        CacheCreation cache = new CacheCreation();
        cache.createPoolFactory().addServer(CacheXml57Test.getServerHostName(vm0.getHost()), port).setSubscriptionEnabled(true).create("connectionPool");
        cache.setDynamicRegionFactoryConfig(new DynamicRegionFactory.Config(null, "connectionPool", false, false));
        RegionAttributesCreation attrs = new RegionAttributesCreation(cache);
        cache.createRegion("root", (RegionAttributes)attrs);
        this.testXml(cache, false);
        CacheXml57Test.assertEquals((boolean)false, (boolean)DynamicRegionFactory.get().getConfig().getRegisterInterest());
        CacheXml57Test.assertEquals((boolean)false, (boolean)DynamicRegionFactory.get().getConfig().getPersistBackup());
        CacheXml57Test.assertEquals((boolean)true, (boolean)DynamicRegionFactory.get().isOpen());
        CacheXml57Test.assertEquals(null, (Object)DynamicRegionFactory.get().getConfig().getDiskDir());
        CacheXml57Test.assertEquals(null, (Object)DynamicRegionFactory.get().getConfig().getBridgeWriter());
        CacheXml57Test.assertEquals((String)"connectionPool", (String)DynamicRegionFactory.get().getConfig().getPoolName());
        Region dr = this.getCache().getRegion("__DynamicRegions");
        if (dr != null) {
            dr.localDestroyRegion();
        }
    }

    public void testGatewayHubManualStart() throws IOException {
        CacheCreation cache = new CacheCreation();
        int HUB_PORT = AvailablePort.getRandomAvailablePort((int)0);
        int PORT = AvailablePort.getRandomAvailablePort((int)0);
        GatewayHub hub = cache.setGatewayHub("US", HUB_PORT);
        hub.setManualStart(true);
        Gateway gateway = hub.addGateway("EU");
        gateway.addEndpoint("EU-1", ALIAS2, PORT);
        this.testXml(cache);
        Cache c = this.getCache();
        List hubs = c.getGatewayHubs();
        GatewayHub createdHub = (GatewayHub)hubs.get(0);
        CacheXml57Test.assertNotNull((Object)createdHub);
        CacheXml57Test.assertEquals((String)"US", (String)createdHub.getId());
        CacheXml57Test.assertEquals((boolean)false, (createdHub.getCancelCriterion().cancelInProgress() == null ? 1 : 0) != 0);
        createdHub.start();
        CacheXml57Test.assertEquals((boolean)true, (createdHub.getCancelCriterion().cancelInProgress() == null ? 1 : 0) != 0);
    }

    public void testGatewayHubGetByName() {
        CacheCreation cache = new CacheCreation();
        int HUB_PORT = AvailablePort.getRandomAvailablePort((int)0);
        int PORT = AvailablePort.getRandomAvailablePort((int)0);
        GatewayHub hub = cache.setGatewayHub("US", HUB_PORT);
        Gateway gateway = hub.addGateway("EU");
        GatewayQueueAttributes queueAttributes = new GatewayQueueAttributes();
        queueAttributes.setOverflowDirectory(this.getClass().getName() + "_diskDir");
        gateway.setQueueAttributes(queueAttributes);
        gateway.addEndpoint("EU-1", ALIAS2, PORT);
        this.testXml(cache);
        Cache c = this.getCache();
        GatewayHub createdHub = c.getGatewayHub("US");
        CacheXml57Test.assertNotNull((Object)createdHub);
    }

    public void testBridgeAttributesRelatedToHAOverFlow() throws CacheException {
        CacheCreation cache = new CacheCreation();
        cache.setMessageSyncInterval(3445);
        CacheServer bs = cache.addCacheServer();
        ClientSubscriptionConfig csc = bs.getClientSubscriptionConfig();
        csc.setEvictionPolicy("entry");
        cache.getLogger().config("EvictionPolicy : " + csc.getEvictionPolicy());
        csc.setCapacity(501);
        cache.getLogger().config("EvictionCapacity : " + csc.getCapacity());
        csc.setOverflowDirectory("overFlow");
        cache.getLogger().config("EvictionOverflowDirectory : " + csc.getOverflowDirectory());
        bs.setPort(AvailablePortHelper.getRandomAvailableTCPPort());
        RegionAttributesCreation attrs = new RegionAttributesCreation(cache);
        attrs.setDataPolicy(DataPolicy.NORMAL);
        cache.createVMRegion("rootNORMAL", (RegionAttributes)attrs);
        this.testXml(cache);
        Cache c = this.getCache();
        CacheXml57Test.assertNotNull((Object)c);
        CacheServer server = (CacheServer)cache.getCacheServers().iterator().next();
        CacheXml57Test.assertNotNull((Object)server);
        ClientSubscriptionConfig chaqf = server.getClientSubscriptionConfig();
        CacheXml57Test.assertEquals((String)"entry", (String)chaqf.getEvictionPolicy());
        CacheXml57Test.assertEquals((int)501, (int)chaqf.getCapacity());
        CacheXml57Test.assertEquals((String)"overFlow", (String)chaqf.getOverflowDirectory());
    }

    public void testBridgeLoadProbe() {
        CacheCreation cache = new CacheCreation();
        CacheServer server = cache.addCacheServer();
        server.setPort(AvailablePortHelper.getRandomAvailableTCPPort());
        server.setLoadProbe((ServerLoadProbe)new MyLoadProbe());
        this.testXml(cache);
        Cache c = this.getCache();
        server = (CacheServer)c.getCacheServers().get(0);
        Assert.assertEquals(MyLoadProbe.class, server.getLoadProbe().getClass());
    }

    public void testLoadPollInterval() {
        CacheCreation cache = new CacheCreation();
        CacheServer server = cache.addCacheServer();
        server.setPort(AvailablePortHelper.getRandomAvailableTCPPort());
        server.setLoadPollInterval(12345L);
        this.testXml(cache);
        Cache c = this.getCache();
        server = (CacheServer)c.getCacheServers().get(0);
        Assert.assertEquals((long)12345L, (long)server.getLoadPollInterval());
    }

    public void testCustomEntryXml() {
        CacheCreation cache = new CacheCreation();
        RegionAttributesCreation attrs = new RegionAttributesCreation(cache);
        attrs.setScope(Scope.DISTRIBUTED_NO_ACK);
        RegionCreation root = (RegionCreation)cache.createRegion("root", (RegionAttributes)attrs);
        attrs = new RegionAttributesCreation(cache);
        attrs.setScope(Scope.DISTRIBUTED_NO_ACK);
        attrs.setInitialCapacity(142);
        attrs.setLoadFactor(42.42f);
        attrs.setStatisticsEnabled(true);
        attrs.setCustomEntryIdleTimeout((CustomExpiry)new Expiry1());
        attrs.setCustomEntryTimeToLive((CustomExpiry)new Expiry5());
        root.createSubregion("one", (RegionAttributes)attrs);
        attrs = new RegionAttributesCreation(cache);
        attrs.setScope(Scope.DISTRIBUTED_ACK);
        attrs.setInitialCapacity(242);
        attrs.setStatisticsEnabled(true);
        attrs.setCustomEntryIdleTimeout((CustomExpiry)new Expiry2());
        Region region = root.createSubregion("two", (RegionAttributes)attrs);
        attrs = new RegionAttributesCreation(cache);
        attrs.setScope(Scope.DISTRIBUTED_ACK);
        attrs.setLoadFactor(43.43f);
        attrs.setStatisticsEnabled(true);
        attrs.setCustomEntryIdleTimeout((CustomExpiry)new Expiry3());
        attrs.setCustomEntryTimeToLive((CustomExpiry)new Expiry4());
        region.createSubregion("three", (RegionAttributes)attrs);
        this.testXml(cache);
    }

    public void testPreloadDataPolicy() throws CacheException {
        CacheCreation cache = new CacheCreation();
        RegionAttributesCreation attrs = new RegionAttributesCreation(cache);
        attrs.setDataPolicy(DataPolicy.NORMAL);
        cache.createRegion("rootNORMAL", (RegionAttributes)attrs);
        attrs = new RegionAttributesCreation(cache);
        attrs.setDataPolicy(DataPolicy.NORMAL);
        attrs.setSubscriptionAttributes(new SubscriptionAttributes(InterestPolicy.ALL));
        cache.createRegion("rootNORMAL_ALL", (RegionAttributes)attrs);
        attrs = new RegionAttributesCreation(cache);
        attrs.setMirrorType(MirrorType.KEYS_VALUES);
        cache.createRegion("rootREPLICATE", (RegionAttributes)attrs);
        attrs = new RegionAttributesCreation(cache);
        attrs.setDataPolicy(DataPolicy.PERSISTENT_REPLICATE);
        cache.createRegion("rootPERSISTENT_REPLICATE", (RegionAttributes)attrs);
        attrs = new RegionAttributesCreation(cache);
        attrs.setDataPolicy(DataPolicy.EMPTY);
        cache.createRegion("rootEMPTY", (RegionAttributes)attrs);
        attrs = new RegionAttributesCreation(cache);
        attrs.setDataPolicy(DataPolicy.EMPTY);
        attrs.setSubscriptionAttributes(new SubscriptionAttributes(InterestPolicy.ALL));
        cache.createRegion("rootEMPTY_ALL", (RegionAttributes)attrs);
        attrs = new RegionAttributesCreation(cache);
        attrs.setDataPolicy(DataPolicy.PRELOADED);
        attrs.setSubscriptionAttributes(new SubscriptionAttributes(InterestPolicy.ALL));
        cache.createRegion("rootPRELOADED_ALL", (RegionAttributes)attrs);
        this.testXml(cache);
    }

    public void testEnableSubscriptionConflationAttribute() throws CacheException {
        CacheCreation cache = new CacheCreation();
        RegionAttributesCreation attrs = new RegionAttributesCreation(cache);
        attrs.setEnableSubscriptionConflation(true);
        cache.createRegion("root", (RegionAttributes)attrs);
        this.testXml(cache);
        CacheXml57Test.assertEquals((boolean)true, (boolean)cache.getRegion("root").getAttributes().getEnableSubscriptionConflation());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        String tmp_alias1 = "unset";
        String tmp_alias2 = "unset";
        try {
            tmp_alias1 = CacheXml57Test.getServerHostName(Host.getHost(0));
            InetSocketAddress addr = CacheXml57Test.createINSA(tmp_alias1, 10000);
            tmp_alias2 = addr.getHostName();
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        finally {
            ALIAS1 = tmp_alias1;
            ALIAS2 = tmp_alias2;
        }
    }

    public static class Expiry5
    implements CustomExpiry,
    Declarable2 {
        public ExpirationAttributes getExpiry(Region.Entry entry) {
            return null;
        }

        public void init(Properties props) {
        }

        public void close() {
        }

        public Properties getConfig() {
            Properties p = new Properties();
            p.put("prop1", "val1");
            p.put("prop2", "val2");
            return p;
        }
    }

    public static class Expiry4
    implements CustomExpiry,
    Declarable {
        public ExpirationAttributes getExpiry(Region.Entry entry) {
            return null;
        }

        public void init(Properties props) {
        }

        public void close() {
        }
    }

    public static class Expiry3
    implements CustomExpiry,
    Declarable {
        public ExpirationAttributes getExpiry(Region.Entry entry) {
            return null;
        }

        public void init(Properties props) {
        }

        public void close() {
        }
    }

    public static class Expiry2
    implements CustomExpiry,
    Declarable {
        public ExpirationAttributes getExpiry(Region.Entry entry) {
            return null;
        }

        public void init(Properties props) {
        }

        public void close() {
        }
    }

    public static class Expiry1
    implements CustomExpiry,
    Declarable {
        public ExpirationAttributes getExpiry(Region.Entry entry) {
            return null;
        }

        public void init(Properties props) {
        }

        public void close() {
        }
    }

    public static class MyLoadProbe
    extends ServerLoadProbeAdapter
    implements Declarable {
        public ServerLoad getLoad(ServerMetrics metrics) {
            return null;
        }

        public void init(Properties props) {
        }

        public boolean equals(Object o) {
            return o instanceof MyLoadProbe;
        }
    }
}

