/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache30;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.DiskWriteAttributesFactory;
import com.gemstone.gemfire.cache.EvictionAction;
import com.gemstone.gemfire.cache.EvictionAlgorithm;
import com.gemstone.gemfire.cache.EvictionAttributes;
import com.gemstone.gemfire.cache.ExpirationAction;
import com.gemstone.gemfire.cache.ExpirationAttributes;
import com.gemstone.gemfire.cache.PartitionAttributes;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.PartitionResolver;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.FunctionService;
import com.gemstone.gemfire.cache30.CacheXml57Test;
import com.gemstone.gemfire.internal.cache.functions.TestFunction;
import com.gemstone.gemfire.internal.cache.xmlcache.CacheCreation;
import com.gemstone.gemfire.internal.cache.xmlcache.FunctionServiceCreation;
import com.gemstone.gemfire.internal.cache.xmlcache.RegionAttributesCreation;
import com.gemstone.gemfire.internal.cache.xmlcache.ResourceManagerCreation;
import java.util.Map;
import java.util.Properties;
import parReg.colocation.MonthPartitionResolver;

public class CacheXml58Test
extends CacheXml57Test {
    public CacheXml58Test(String name) {
        super(name);
    }

    @Override
    protected String getGemFireVersion() {
        return "5_8";
    }

    public void testPartitionedRegionAttributesForCustomPartitioning() throws CacheException {
        CacheCreation cache = new CacheCreation();
        RegionAttributesCreation attrs = new RegionAttributesCreation(cache);
        MonthPartitionResolver partitionResolver = new MonthPartitionResolver();
        Properties params = new Properties();
        params.setProperty("initial-index-value", "1000");
        params.setProperty("secondary-index-value", "5000");
        partitionResolver.init(params);
        PartitionAttributesFactory paf = new PartitionAttributesFactory();
        paf.setRedundantCopies(1);
        paf.setTotalMaxMemory(500L);
        paf.setLocalMaxMemory(100);
        paf.setPartitionResolver((PartitionResolver)partitionResolver);
        attrs.setPartitionAttributes(paf.create());
        cache.createRegion("parRoot", (RegionAttributes)attrs);
        Region r = cache.getRegion("parRoot");
        CacheXml58Test.assertEquals((int)r.getAttributes().getPartitionAttributes().getRedundantCopies(), (int)1);
        CacheXml58Test.assertEquals((int)r.getAttributes().getPartitionAttributes().getLocalMaxMemory(), (int)100);
        CacheXml58Test.assertEquals((long)r.getAttributes().getPartitionAttributes().getTotalMaxMemory(), (long)500L);
        CacheXml58Test.assertEquals((Object)r.getAttributes().getPartitionAttributes().getPartitionResolver(), (Object)partitionResolver);
        this.testXml(cache);
        Cache c = this.getCache();
        CacheXml58Test.assertNotNull((Object)c);
        Region region = c.getRegion("parRoot");
        CacheXml58Test.assertNotNull((Object)region);
        RegionAttributes regionAttrs = region.getAttributes();
        PartitionAttributes pa = regionAttrs.getPartitionAttributes();
        CacheXml58Test.assertEquals((int)pa.getRedundantCopies(), (int)1);
        CacheXml58Test.assertEquals((int)pa.getLocalMaxMemory(), (int)100);
        CacheXml58Test.assertEquals((long)pa.getTotalMaxMemory(), (long)500L);
        CacheXml58Test.assertNotNull(pa.getPartitionResolver().getClass());
        CacheXml58Test.assertEquals((Object)pa.getPartitionResolver(), (Object)partitionResolver);
    }

    public void testCacheCreationWithFuntionService() throws CacheException {
        CacheCreation cache = new CacheCreation();
        FunctionServiceCreation fsc = new FunctionServiceCreation();
        TestFunction function1 = new TestFunction(true, "TestFunction2");
        TestFunction function2 = new TestFunction(true, "TestFunction3");
        TestFunction function3 = new TestFunction(true, "TestFunction4");
        fsc.registerFunction((Function)function1);
        fsc.registerFunction((Function)function2);
        fsc.registerFunction((Function)function3);
        fsc.create();
        cache.setFunctionServiceCreation(fsc);
        this.testXml(cache);
        this.getCache();
        Map functionIdMap = FunctionService.getRegisteredFunctions();
        CacheXml58Test.assertEquals((String)("expected 6 functions but map=" + functionIdMap), (int)6, (int)functionIdMap.size());
        CacheXml58Test.assertTrue((boolean)function1.equals(functionIdMap.get(function1.getId())));
        CacheXml58Test.assertTrue((boolean)function2.equals(functionIdMap.get(function2.getId())));
        CacheXml58Test.assertTrue((boolean)function3.equals(functionIdMap.get(function3.getId())));
    }

    public void testPartitionedRegionAttributesForExpiration() throws CacheException {
        CacheCreation cache = new CacheCreation();
        RegionAttributesCreation attrs = new RegionAttributesCreation(cache);
        attrs.setStatisticsEnabled(true);
        RegionAttributes rootAttrs = null;
        ExpirationAttributes expiration = new ExpirationAttributes(60, ExpirationAction.DESTROY);
        MonthPartitionResolver partitionResolver = new MonthPartitionResolver();
        Properties params = new Properties();
        params.setProperty("initial-index-value", "1000");
        params.setProperty("secondary-index-value", "5000");
        partitionResolver.init(params);
        PartitionAttributesFactory paf = new PartitionAttributesFactory();
        paf.setRedundantCopies(1);
        paf.setTotalMaxMemory(500L);
        paf.setLocalMaxMemory(100);
        paf.setPartitionResolver((PartitionResolver)partitionResolver);
        AttributesFactory fac = new AttributesFactory((RegionAttributes)attrs);
        fac.setEntryTimeToLive(expiration);
        fac.setEntryIdleTimeout(expiration);
        fac.setPartitionAttributes(paf.create());
        rootAttrs = fac.create();
        cache.createRegion("parRoot", rootAttrs);
        Region r = cache.getRegion("parRoot");
        CacheXml58Test.assertNotNull((Object)r);
        CacheXml58Test.assertEquals((int)r.getAttributes().getPartitionAttributes().getRedundantCopies(), (int)1);
        CacheXml58Test.assertEquals((int)r.getAttributes().getPartitionAttributes().getLocalMaxMemory(), (int)100);
        CacheXml58Test.assertEquals((long)r.getAttributes().getPartitionAttributes().getTotalMaxMemory(), (long)500L);
        CacheXml58Test.assertEquals((Object)r.getAttributes().getPartitionAttributes().getPartitionResolver(), (Object)partitionResolver);
        CacheXml58Test.assertEquals((int)r.getAttributes().getEntryIdleTimeout().getTimeout(), (int)expiration.getTimeout());
        CacheXml58Test.assertEquals((int)r.getAttributes().getEntryTimeToLive().getTimeout(), (int)expiration.getTimeout());
        this.testXml(cache);
        Cache c = this.getCache();
        CacheXml58Test.assertNotNull((Object)c);
        Region region = c.getRegion("parRoot");
        CacheXml58Test.assertNotNull((Object)region);
        RegionAttributes regionAttrs = region.getAttributes();
        PartitionAttributes pa = regionAttrs.getPartitionAttributes();
        CacheXml58Test.assertEquals((int)pa.getRedundantCopies(), (int)1);
        CacheXml58Test.assertEquals((int)pa.getLocalMaxMemory(), (int)100);
        CacheXml58Test.assertEquals((long)pa.getTotalMaxMemory(), (long)500L);
        CacheXml58Test.assertNotNull(pa.getPartitionResolver().getClass());
        CacheXml58Test.assertEquals((Object)pa.getPartitionResolver(), (Object)partitionResolver);
        CacheXml58Test.assertEquals((int)regionAttrs.getEntryIdleTimeout().getTimeout(), (int)expiration.getTimeout());
        CacheXml58Test.assertEquals((int)regionAttrs.getEntryTimeToLive().getTimeout(), (int)expiration.getTimeout());
    }

    public void testPartitionedRegionAttributesForEviction() throws CacheException {
        boolean redundantCopies = true;
        CacheCreation cache = new CacheCreation();
        if (this.getGemFireVersion().equals("6_0")) {
            ResourceManagerCreation rm = new ResourceManagerCreation();
            rm.setCriticalHeapPercentage(95.0f);
            cache.setResourceManagerCreation(rm);
        }
        RegionAttributesCreation attrs = new RegionAttributesCreation(cache);
        attrs.setStatisticsEnabled(true);
        RegionAttributes rootAttrs = null;
        ExpirationAttributes expiration = new ExpirationAttributes(60, ExpirationAction.DESTROY);
        MonthPartitionResolver partitionResolver = new MonthPartitionResolver();
        Properties params = new Properties();
        params.setProperty("initial-index-value", "1000");
        params.setProperty("secondary-index-value", "5000");
        partitionResolver.init(params);
        PartitionAttributesFactory paf = new PartitionAttributesFactory();
        paf.setRedundantCopies(1);
        paf.setTotalMaxMemory(500L);
        paf.setLocalMaxMemory(100);
        paf.setPartitionResolver((PartitionResolver)partitionResolver);
        AttributesFactory fac = new AttributesFactory((RegionAttributes)attrs);
        fac.setEvictionAttributes(EvictionAttributes.createLRUMemoryAttributes((int)100, null, (EvictionAction)EvictionAction.OVERFLOW_TO_DISK));
        fac.setEntryTimeToLive(expiration);
        fac.setEntryIdleTimeout(expiration);
        DiskWriteAttributesFactory dwaf = new DiskWriteAttributesFactory();
        dwaf.setSynchronous(true);
        fac.setPartitionAttributes(paf.create());
        rootAttrs = fac.create();
        cache.createRegion("parRoot", rootAttrs);
        Region r = cache.getRegion("parRoot");
        CacheXml58Test.assertNotNull((Object)r);
        CacheXml58Test.assertEquals((int)r.getAttributes().getPartitionAttributes().getRedundantCopies(), (int)1);
        CacheXml58Test.assertEquals((int)r.getAttributes().getPartitionAttributes().getLocalMaxMemory(), (int)100);
        CacheXml58Test.assertEquals((long)r.getAttributes().getPartitionAttributes().getTotalMaxMemory(), (long)500L);
        CacheXml58Test.assertEquals((Object)r.getAttributes().getPartitionAttributes().getPartitionResolver(), (Object)partitionResolver);
        CacheXml58Test.assertEquals((int)r.getAttributes().getEntryIdleTimeout().getTimeout(), (int)expiration.getTimeout());
        CacheXml58Test.assertEquals((int)r.getAttributes().getEntryTimeToLive().getTimeout(), (int)expiration.getTimeout());
        this.testXml(cache);
        Cache c = this.getCache();
        CacheXml58Test.assertNotNull((Object)c);
        Region region = c.getRegion("parRoot");
        CacheXml58Test.assertNotNull((Object)region);
        RegionAttributes regionAttrs = region.getAttributes();
        PartitionAttributes pa = regionAttrs.getPartitionAttributes();
        EvictionAttributes ea = regionAttrs.getEvictionAttributes();
        CacheXml58Test.assertEquals((int)pa.getRedundantCopies(), (int)1);
        CacheXml58Test.assertEquals((int)pa.getLocalMaxMemory(), (int)100);
        CacheXml58Test.assertEquals((long)pa.getTotalMaxMemory(), (long)500L);
        CacheXml58Test.assertNotNull(pa.getPartitionResolver().getClass());
        CacheXml58Test.assertEquals((Object)pa.getPartitionResolver(), (Object)partitionResolver);
        CacheXml58Test.assertEquals((int)regionAttrs.getEntryIdleTimeout().getTimeout(), (int)expiration.getTimeout());
        CacheXml58Test.assertEquals((int)regionAttrs.getEntryTimeToLive().getTimeout(), (int)expiration.getTimeout());
        CacheXml58Test.assertEquals((Object)ea.getAlgorithm(), (Object)EvictionAlgorithm.LRU_MEMORY);
        CacheXml58Test.assertEquals((Object)ea.getAction(), (Object)EvictionAction.OVERFLOW_TO_DISK);
    }

    public void testPartitionedRegionAttributesForCoLocation() {
        CacheXml58Test.closeCache();
        CacheCreation cache = new CacheCreation();
        RegionAttributesCreation custAttrs = new RegionAttributesCreation(cache);
        RegionAttributesCreation orderAttrs = new RegionAttributesCreation(cache);
        PartitionAttributesFactory custPaf = new PartitionAttributesFactory();
        PartitionAttributesFactory orderPaf = new PartitionAttributesFactory();
        custPaf.setRedundantCopies(1);
        custPaf.setTotalMaxMemory(500L);
        custPaf.setLocalMaxMemory(100);
        custAttrs.setPartitionAttributes(custPaf.create());
        cache.createRegion("Customer", (RegionAttributes)custAttrs);
        orderPaf.setRedundantCopies(1);
        orderPaf.setTotalMaxMemory(500L);
        orderPaf.setLocalMaxMemory(100);
        orderPaf.setColocatedWith("Customer");
        orderAttrs.setPartitionAttributes(orderPaf.create());
        cache.createRegion("Order", (RegionAttributes)orderAttrs);
        this.testXml(cache);
        Cache c = this.getCache();
        CacheXml58Test.assertNotNull((Object)c);
        Region cust = c.getRegion("/Customer");
        CacheXml58Test.assertNotNull((Object)cust);
        Region order = c.getRegion("/Order");
        CacheXml58Test.assertNotNull((Object)order);
        String coLocatedRegion = order.getAttributes().getPartitionAttributes().getColocatedWith();
        CacheXml58Test.assertEquals((String)"Customer", (String)coLocatedRegion);
    }

    public void testPartitionedRegionAttributesForCoLocation2() {
        CacheXml58Test.closeCache();
        this.setXmlFile(this.findFile("coLocation.xml"));
        Cache c = this.getCache();
        CacheXml58Test.assertNotNull((Object)c);
        Region cust = c.getRegion("/Customer");
        CacheXml58Test.assertNotNull((Object)cust);
        Region order = c.getRegion("/Order");
        CacheXml58Test.assertNotNull((Object)order);
        CacheXml58Test.assertTrue((cust.getAttributes().getPartitionAttributes().getColocatedWith() == null ? 1 : 0) != 0);
        CacheXml58Test.assertTrue((boolean)order.getAttributes().getPartitionAttributes().getColocatedWith().equals("Customer"));
    }

    public void testPartitionedRegionAttributesForMemLruWithoutMaxMem() throws CacheException {
        boolean redundantCopies = true;
        CacheCreation cache = new CacheCreation();
        RegionAttributesCreation attrs = new RegionAttributesCreation(cache);
        attrs.setStatisticsEnabled(true);
        PartitionAttributesFactory paf = new PartitionAttributesFactory();
        paf.setRedundantCopies(1);
        paf.setTotalMaxMemory(500L);
        paf.setLocalMaxMemory(100);
        AttributesFactory fac = new AttributesFactory((RegionAttributes)attrs);
        fac.setEvictionAttributes(EvictionAttributes.createLRUMemoryAttributes(null, (EvictionAction)EvictionAction.LOCAL_DESTROY));
        fac.setPartitionAttributes(paf.create());
        cache.createRegion("parRoot", fac.create());
        this.testXml(cache);
        Cache c = this.getCache();
        CacheXml58Test.assertNotNull((Object)c);
        Region region = c.getRegion("parRoot");
        CacheXml58Test.assertNotNull((Object)region);
        RegionAttributes regionAttrs = region.getAttributes();
        PartitionAttributes pa = regionAttrs.getPartitionAttributes();
        EvictionAttributes ea = regionAttrs.getEvictionAttributes();
        CacheXml58Test.assertEquals((int)pa.getRedundantCopies(), (int)1);
        CacheXml58Test.assertEquals((int)pa.getLocalMaxMemory(), (int)100);
        CacheXml58Test.assertEquals((long)pa.getTotalMaxMemory(), (long)500L);
        CacheXml58Test.assertEquals((Object)ea.getAlgorithm(), (Object)EvictionAlgorithm.LRU_MEMORY);
        CacheXml58Test.assertEquals((Object)ea.getAction(), (Object)EvictionAction.LOCAL_DESTROY);
        CacheXml58Test.assertEquals((int)ea.getMaximum(), (int)pa.getLocalMaxMemory());
    }

    public void testPartitionedRegionAttributesForMemLruWithMaxMem() throws CacheException {
        boolean redundantCopies = true;
        int maxMem = 25;
        CacheCreation cache = new CacheCreation();
        RegionAttributesCreation attrs = new RegionAttributesCreation(cache);
        attrs.setStatisticsEnabled(true);
        PartitionAttributesFactory paf = new PartitionAttributesFactory();
        paf.setRedundantCopies(1);
        paf.setTotalMaxMemory(500L);
        paf.setLocalMaxMemory(100);
        AttributesFactory fac = new AttributesFactory((RegionAttributes)attrs);
        fac.setEvictionAttributes(EvictionAttributes.createLRUMemoryAttributes((int)25, null, (EvictionAction)EvictionAction.LOCAL_DESTROY));
        fac.setPartitionAttributes(paf.create());
        cache.createRegion("parRoot", fac.create());
        this.testXml(cache);
        Cache c = this.getCache();
        CacheXml58Test.assertNotNull((Object)c);
        Region region = c.getRegion("parRoot");
        CacheXml58Test.assertNotNull((Object)region);
        RegionAttributes regionAttrs = region.getAttributes();
        PartitionAttributes pa = regionAttrs.getPartitionAttributes();
        EvictionAttributes ea = regionAttrs.getEvictionAttributes();
        CacheXml58Test.assertEquals((int)pa.getRedundantCopies(), (int)1);
        CacheXml58Test.assertEquals((int)pa.getLocalMaxMemory(), (int)100);
        CacheXml58Test.assertEquals((long)pa.getTotalMaxMemory(), (long)500L);
        CacheXml58Test.assertEquals((Object)ea.getAlgorithm(), (Object)EvictionAlgorithm.LRU_MEMORY);
        CacheXml58Test.assertEquals((Object)ea.getAction(), (Object)EvictionAction.LOCAL_DESTROY);
        CacheXml58Test.assertNotSame((Object)ea.getMaximum(), (Object)25);
        CacheXml58Test.assertEquals((int)ea.getMaximum(), (int)pa.getLocalMaxMemory());
    }

    public void testReplicatedRegionAttributesForMemLruWithoutMaxMem() throws CacheException {
        boolean redundantCopies = true;
        CacheCreation cache = new CacheCreation();
        AttributesFactory fac = new AttributesFactory();
        fac.setDataPolicy(DataPolicy.REPLICATE);
        fac.setEvictionAttributes(EvictionAttributes.createLRUMemoryAttributes(null, (EvictionAction)EvictionAction.OVERFLOW_TO_DISK));
        cache.createRegion("parRoot", fac.create());
        this.testXml(cache);
        Cache c = this.getCache();
        CacheXml58Test.assertNotNull((Object)c);
        Region region = c.getRegion("parRoot");
        CacheXml58Test.assertNotNull((Object)region);
        RegionAttributes regionAttrs = region.getAttributes();
        EvictionAttributes ea = regionAttrs.getEvictionAttributes();
        CacheXml58Test.assertEquals((Object)ea.getAlgorithm(), (Object)EvictionAlgorithm.LRU_MEMORY);
        CacheXml58Test.assertEquals((Object)ea.getAction(), (Object)EvictionAction.OVERFLOW_TO_DISK);
        CacheXml58Test.assertEquals((int)ea.getMaximum(), (int)10);
    }

    public void testReplicatedRegionAttributesForMemLruWithMaxMem() throws CacheException {
        boolean redundantCopies = true;
        int maxMem = 25;
        CacheCreation cache = new CacheCreation();
        AttributesFactory fac = new AttributesFactory();
        fac.setDataPolicy(DataPolicy.REPLICATE);
        fac.setEvictionAttributes(EvictionAttributes.createLRUMemoryAttributes((int)25, null, (EvictionAction)EvictionAction.OVERFLOW_TO_DISK));
        cache.createRegion("parRoot", fac.create());
        this.testXml(cache);
        Cache c = this.getCache();
        CacheXml58Test.assertNotNull((Object)c);
        Region region = c.getRegion("parRoot");
        CacheXml58Test.assertNotNull((Object)region);
        RegionAttributes regionAttrs = region.getAttributes();
        EvictionAttributes ea = regionAttrs.getEvictionAttributes();
        CacheXml58Test.assertEquals((Object)ea.getAlgorithm(), (Object)EvictionAlgorithm.LRU_MEMORY);
        CacheXml58Test.assertEquals((Object)ea.getAction(), (Object)EvictionAction.OVERFLOW_TO_DISK);
        CacheXml58Test.assertEquals((int)ea.getMaximum(), (int)25);
    }
}

