/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache30;

import com.gemstone.gemfire.DataSerializable;
import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.PartitionAttributes;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache30.CacheXml58Test;
import com.gemstone.gemfire.internal.InternalDataSerializer;
import com.gemstone.gemfire.internal.InternalInstantiator;
import com.gemstone.gemfire.internal.cache.xmlcache.CacheCreation;
import com.gemstone.gemfire.internal.cache.xmlcache.RegionAttributesCreation;
import com.gemstone.gemfire.internal.cache.xmlcache.ResourceManagerCreation;
import com.gemstone.gemfire.internal.cache.xmlcache.SerializerCreation;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;

public class CacheXml60Test
extends CacheXml58Test {
    public CacheXml60Test(String name) {
        super(name);
    }

    @Override
    protected String getGemFireVersion() {
        return "6_0";
    }

    public void testRecoveryDelayAttributes() throws CacheException {
        CacheCreation cache = new CacheCreation();
        RegionAttributesCreation attrs = new RegionAttributesCreation(cache);
        PartitionAttributesFactory paf = new PartitionAttributesFactory();
        paf.setRedundantCopies(1);
        paf.setTotalMaxMemory(500L);
        paf.setLocalMaxMemory(100);
        paf.setRecoveryDelay(33L);
        paf.setStartupRecoveryDelay(270L);
        attrs.setPartitionAttributes(paf.create());
        cache.createRegion("parRoot", (RegionAttributes)attrs);
        Region r = cache.getRegion("parRoot");
        CacheXml60Test.assertEquals((int)r.getAttributes().getPartitionAttributes().getRedundantCopies(), (int)1);
        CacheXml60Test.assertEquals((int)r.getAttributes().getPartitionAttributes().getLocalMaxMemory(), (int)100);
        CacheXml60Test.assertEquals((long)r.getAttributes().getPartitionAttributes().getTotalMaxMemory(), (long)500L);
        CacheXml60Test.assertEquals((long)33L, (long)r.getAttributes().getPartitionAttributes().getRecoveryDelay());
        CacheXml60Test.assertEquals((long)270L, (long)r.getAttributes().getPartitionAttributes().getStartupRecoveryDelay());
        this.testXml(cache);
        Cache c = this.getCache();
        CacheXml60Test.assertNotNull((Object)c);
        Region region = c.getRegion("parRoot");
        CacheXml60Test.assertNotNull((Object)region);
        RegionAttributes regionAttrs = region.getAttributes();
        PartitionAttributes pa = regionAttrs.getPartitionAttributes();
        CacheXml60Test.assertEquals((int)pa.getRedundantCopies(), (int)1);
        CacheXml60Test.assertEquals((int)pa.getLocalMaxMemory(), (int)100);
        CacheXml60Test.assertEquals((long)pa.getTotalMaxMemory(), (long)500L);
        CacheXml60Test.assertEquals((long)33L, (long)r.getAttributes().getPartitionAttributes().getRecoveryDelay());
        CacheXml60Test.assertEquals((long)270L, (long)r.getAttributes().getPartitionAttributes().getStartupRecoveryDelay());
    }

    public void testDefaultRecoveryDelayAttributes() throws CacheException {
        CacheCreation cache = new CacheCreation();
        RegionAttributesCreation attrs = new RegionAttributesCreation(cache);
        PartitionAttributesFactory paf = new PartitionAttributesFactory();
        paf.setRedundantCopies(1);
        paf.setTotalMaxMemory(500L);
        paf.setLocalMaxMemory(100);
        attrs.setPartitionAttributes(paf.create());
        cache.createRegion("parRoot", (RegionAttributes)attrs);
        Region r = cache.getRegion("parRoot");
        CacheXml60Test.assertEquals((int)r.getAttributes().getPartitionAttributes().getRedundantCopies(), (int)1);
        CacheXml60Test.assertEquals((int)r.getAttributes().getPartitionAttributes().getLocalMaxMemory(), (int)100);
        CacheXml60Test.assertEquals((long)r.getAttributes().getPartitionAttributes().getTotalMaxMemory(), (long)500L);
        CacheXml60Test.assertEquals((long)-1L, (long)r.getAttributes().getPartitionAttributes().getRecoveryDelay());
        CacheXml60Test.assertEquals((long)0L, (long)r.getAttributes().getPartitionAttributes().getStartupRecoveryDelay());
        this.testXml(cache);
        Cache c = this.getCache();
        CacheXml60Test.assertNotNull((Object)c);
        Region region = c.getRegion("parRoot");
        CacheXml60Test.assertNotNull((Object)region);
        RegionAttributes regionAttrs = region.getAttributes();
        PartitionAttributes pa = regionAttrs.getPartitionAttributes();
        CacheXml60Test.assertEquals((int)pa.getRedundantCopies(), (int)1);
        CacheXml60Test.assertEquals((int)pa.getLocalMaxMemory(), (int)100);
        CacheXml60Test.assertEquals((long)pa.getTotalMaxMemory(), (long)500L);
        CacheXml60Test.assertEquals((long)-1L, (long)r.getAttributes().getPartitionAttributes().getRecoveryDelay());
        CacheXml60Test.assertEquals((long)0L, (long)r.getAttributes().getPartitionAttributes().getStartupRecoveryDelay());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testResourceManagerThresholds() throws Exception {
        CacheCreation cache = new CacheCreation();
        float low = 90.0f;
        float high = 95.0f;
        ResourceManagerCreation rmc = new ResourceManagerCreation();
        rmc.setEvictionHeapPercentage(90.0f);
        rmc.setCriticalHeapPercentage(95.0f);
        cache.setResourceManagerCreation(rmc);
        this.testXml(cache);
        Cache c = this.getCache();
        CacheXml60Test.assertEquals((Object)Float.valueOf(90.0f), (Object)Float.valueOf(c.getResourceManager().getEvictionHeapPercentage()));
        CacheXml60Test.assertEquals((Object)Float.valueOf(95.0f), (Object)Float.valueOf(c.getResourceManager().getCriticalHeapPercentage()));
        CacheXml60Test.closeCache();
        rmc = new ResourceManagerCreation();
        rmc.setEvictionHeapPercentage(90.0f);
        rmc.setCriticalHeapPercentage(91.0f);
        cache.setResourceManagerCreation(rmc);
        this.testXml(cache);
        c = this.getCache();
        CacheXml60Test.assertEquals((Object)Float.valueOf(90.0f), (Object)Float.valueOf(c.getResourceManager().getEvictionHeapPercentage()));
        CacheXml60Test.assertEquals((Object)Float.valueOf(91.0f), (Object)Float.valueOf(c.getResourceManager().getCriticalHeapPercentage()));
        CacheXml60Test.closeCache();
        rmc = new ResourceManagerCreation();
        rmc.setEvictionHeapPercentage(95.0f);
        rmc.setCriticalHeapPercentage(90.0f);
        cache.setResourceManagerCreation(rmc);
        try {
            this.testXml(cache);
            CacheXml60Test.assertTrue((boolean)false);
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        finally {
            CacheXml60Test.closeCache();
        }
        rmc = new ResourceManagerCreation();
        rmc.setEvictionHeapPercentage(0.0f);
        rmc.setCriticalHeapPercentage(90.0f);
        cache.setResourceManagerCreation(rmc);
        this.testXml(cache);
        c = this.getCache();
        CacheXml60Test.assertEquals((Object)Float.valueOf(0.0f), (Object)Float.valueOf(c.getResourceManager().getEvictionHeapPercentage()));
        CacheXml60Test.assertEquals((Object)Float.valueOf(90.0f), (Object)Float.valueOf(c.getResourceManager().getCriticalHeapPercentage()));
        CacheXml60Test.closeCache();
        rmc = new ResourceManagerCreation();
        rmc.setEvictionHeapPercentage(90.0f);
        rmc.setCriticalHeapPercentage(0.0f);
        cache.setResourceManagerCreation(rmc);
        this.testXml(cache);
        c = this.getCache();
        CacheXml60Test.assertEquals((Object)Float.valueOf(90.0f), (Object)Float.valueOf(c.getResourceManager().getEvictionHeapPercentage()));
        CacheXml60Test.assertEquals((Object)Float.valueOf(0.0f), (Object)Float.valueOf(c.getResourceManager().getCriticalHeapPercentage()));
        CacheXml60Test.closeCache();
        rmc = new ResourceManagerCreation();
        rmc.setEvictionHeapPercentage(0.0f);
        rmc.setCriticalHeapPercentage(0.0f);
        cache.setResourceManagerCreation(rmc);
        this.testXml(cache);
        c = this.getCache();
        CacheXml60Test.assertEquals((Object)Float.valueOf(0.0f), (Object)Float.valueOf(c.getResourceManager().getEvictionHeapPercentage()));
        CacheXml60Test.assertEquals((Object)Float.valueOf(0.0f), (Object)Float.valueOf(c.getResourceManager().getCriticalHeapPercentage()));
    }

    public void testSerializationRegistration() {
        CacheCreation cc = new CacheCreation();
        SerializerCreation sc = new SerializerCreation();
        cc.setSerializerCreation(sc);
        sc.registerInstantiator(DS1.class, Integer.valueOf(15));
        sc.registerInstantiator(DS2.class, Integer.valueOf(16));
        sc.registerSerializer(GoodSerializer.class);
        this.testXml(cc);
        CacheXml60Test.assertEquals((int)15, (int)InternalInstantiator.getClassId(DS1.class));
        CacheXml60Test.assertEquals((int)16, (int)InternalInstantiator.getClassId(DS2.class));
        CacheXml60Test.assertEquals(GoodSerializer.class, InternalDataSerializer.getSerializer((int)101).getClass());
        sc = new SerializerCreation();
        sc.registerInstantiator(NotDataSerializable.class, Integer.valueOf(15));
        CacheXml60Test.closeCache();
        cc.setSerializerCreation(sc);
        try {
            this.testXml(cc);
            CacheXml60Test.fail((String)"Instantiator should not have registered due to bad class.");
        }
        catch (Exception exception) {
            // empty catch block
        }
        sc = new SerializerCreation();
        sc.registerSerializer(BadSerializer.class);
        CacheXml60Test.closeCache();
        cc.setSerializerCreation(sc);
        try {
            this.testXml(cc);
            CacheXml60Test.fail((String)"Serializer should not have registered due to bad class.");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static class BadSerializer
    extends DataSerializer {
        public Object fromData(DataInput in) throws IOException, ClassNotFoundException {
            return null;
        }

        public int getId() {
            return 101;
        }

        public Class[] getSupportedClasses() {
            return null;
        }

        public boolean toData(Object o, DataOutput out) throws IOException {
            return false;
        }
    }

    public static class GoodSerializer
    extends DataSerializer {
        public Object fromData(DataInput in) throws IOException, ClassNotFoundException {
            return null;
        }

        public int getId() {
            return 101;
        }

        public Class[] getSupportedClasses() {
            return new Class[]{DS1.class};
        }

        public boolean toData(Object o, DataOutput out) throws IOException {
            return false;
        }
    }

    public static class NotDataSerializable
    implements Serializable {
    }

    public static class DS2
    implements DataSerializable {
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        }

        public void toData(DataOutput out) throws IOException {
        }
    }

    public static class DS1
    implements DataSerializable {
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        }

        public void toData(DataOutput out) throws IOException {
        }
    }
}

