/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache30;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache30.CacheXml60Test;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.xmlcache.CacheCreation;
import com.gemstone.gemfire.internal.cache.xmlcache.RegionAttributesCreation;

public class CacheXml61Test
extends CacheXml60Test {
    public CacheXml61Test(String name) {
        super(name);
    }

    @Override
    protected String getGemFireVersion() {
        return "6_1";
    }

    public void testRegionAttributesForRegionEntryCloning() throws CacheException {
        String rNameBase = this.getUniqueName();
        String r1 = rNameBase + "1";
        CacheCreation creation = new CacheCreation();
        RegionAttributesCreation attrs = new RegionAttributesCreation(creation);
        attrs.setScope(Scope.LOCAL);
        attrs.setEarlyAck(false);
        attrs.setCloningEnable(false);
        attrs.setMulticastEnabled(true);
        creation.createRegion(r1, (RegionAttributes)attrs);
        this.testXml(creation);
        Cache c = this.getCache();
        CacheXml61Test.assertTrue((boolean)(c instanceof GemFireCacheImpl));
        c.loadCacheXml(this.generate(creation));
        Region reg1 = c.getRegion(r1);
        CacheXml61Test.assertNotNull((Object)reg1);
        CacheXml61Test.assertEquals((Object)Scope.LOCAL, (Object)reg1.getAttributes().getScope());
        CacheXml61Test.assertFalse((boolean)reg1.getAttributes().getEarlyAck());
        CacheXml61Test.assertTrue((boolean)reg1.getAttributes().getMulticastEnabled());
        CacheXml61Test.assertFalse((boolean)reg1.getAttributes().getCloningEnabled());
        reg1.getAttributesMutator().setCloningEnabled(true);
        CacheXml61Test.assertTrue((boolean)reg1.getAttributes().getCloningEnabled());
        reg1.getAttributesMutator().setCloningEnabled(false);
        CacheXml61Test.assertFalse((boolean)reg1.getAttributes().getCloningEnabled());
        String sub = "subRegion";
        RegionAttributesCreation attrsSub = new RegionAttributesCreation(creation);
        attrsSub.setScope(Scope.LOCAL);
        reg1.createSubregion(sub, (RegionAttributes)attrsSub);
        Region subRegion = reg1.getSubregion(sub);
        CacheXml61Test.assertFalse((boolean)subRegion.getAttributes().getCloningEnabled());
        subRegion.getAttributesMutator().setCloningEnabled(true);
        CacheXml61Test.assertTrue((boolean)subRegion.getAttributes().getCloningEnabled());
    }
}

