/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache30;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.DiskStore;
import com.gemstone.gemfire.cache.DiskStoreFactory;
import com.gemstone.gemfire.cache.EvictionAction;
import com.gemstone.gemfire.cache.EvictionAttributes;
import com.gemstone.gemfire.cache.InterestPolicy;
import com.gemstone.gemfire.cache.PartitionAttributes;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.RegionShortcut;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.SubscriptionAttributes;
import com.gemstone.gemfire.cache.TransactionWriter;
import com.gemstone.gemfire.cache.client.ClientRegionShortcut;
import com.gemstone.gemfire.cache.client.Pool;
import com.gemstone.gemfire.cache.client.PoolFactory;
import com.gemstone.gemfire.cache.client.PoolManager;
import com.gemstone.gemfire.cache.server.CacheServer;
import com.gemstone.gemfire.cache.server.ClientSubscriptionConfig;
import com.gemstone.gemfire.cache.util.Gateway;
import com.gemstone.gemfire.cache.util.GatewayHub;
import com.gemstone.gemfire.cache.util.GatewayQueueAttributes;
import com.gemstone.gemfire.cache30.CacheXml61Test;
import com.gemstone.gemfire.cache30.TestTransactionWriter;
import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.internal.AvailablePortHelper;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.xmlcache.CacheCreation;
import com.gemstone.gemfire.internal.cache.xmlcache.CacheTransactionManagerCreation;
import com.gemstone.gemfire.internal.cache.xmlcache.ClientCacheCreation;
import com.gemstone.gemfire.internal.cache.xmlcache.RegionAttributesCreation;
import com.gemstone.gemfire.internal.cache.xmlcache.RegionCreation;
import com.gemstone.gemfire.internal.cache.xmlcache.ResourceManagerCreation;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import dunit.DistributedTestCase;
import dunit.Host;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.List;

public class CacheXml65Test
extends CacheXml61Test {
    private static final String ALIAS1;
    private static final String ALIAS2;

    private static InetSocketAddress createINSA(String host, int port) {
        try {
            InetAddress hostAddr = InetAddress.getByName(host);
            return new InetSocketAddress(hostAddr, port);
        }
        catch (UnknownHostException cause) {
            IllegalArgumentException ex = new IllegalArgumentException("Unknown host " + host);
            ex.initCause(cause);
            throw ex;
        }
    }

    public CacheXml65Test(String name) {
        super(name);
    }

    @Override
    protected String getGemFireVersion() {
        return "6_5";
    }

    @Override
    public void testDefaultConnectionPool() throws CacheException {
        this.getSystem();
        CacheCreation cache = new CacheCreation();
        PoolFactory f = cache.createPoolFactory();
        f.addLocator(ALIAS2, 3777);
        f.create("mypool");
        RegionAttributesCreation attrs = new RegionAttributesCreation(cache);
        attrs.setPoolName("mypool");
        cache.createVMRegion("rootNORMAL", (RegionAttributes)attrs);
        this.testXml(cache);
        Cache c = this.getCache();
        CacheXml65Test.assertNotNull((Object)c);
        Region r = c.getRegion("rootNORMAL");
        CacheXml65Test.assertNotNull((Object)r);
        CacheXml65Test.assertEquals((String)"mypool", (String)r.getAttributes().getPoolName());
        Pool cp = PoolManager.find((String)"mypool");
        CacheXml65Test.assertNotNull((Object)cp);
        CacheXml65Test.assertEquals((int)1, (int)cp.getLocators().size());
        CacheXml65Test.assertEquals((int)0, (int)cp.getServers().size());
        CacheXml65Test.assertEquals((Object)CacheXml65Test.createINSA(ALIAS2, 3777), cp.getLocators().get(0));
        CacheXml65Test.assertEquals((int)10000, (int)cp.getFreeConnectionTimeout());
        CacheXml65Test.assertEquals((int)300000, (int)cp.getLoadConditioningInterval());
        CacheXml65Test.assertEquals((int)32768, (int)cp.getSocketBufferSize());
        CacheXml65Test.assertEquals((boolean)false, (boolean)cp.getThreadLocalConnections());
        CacheXml65Test.assertEquals((int)10000, (int)cp.getReadTimeout());
        CacheXml65Test.assertEquals((int)1, (int)cp.getMinConnections());
        CacheXml65Test.assertEquals((int)-1, (int)cp.getMaxConnections());
        CacheXml65Test.assertEquals((int)-1, (int)cp.getRetryAttempts());
        CacheXml65Test.assertEquals((long)5000L, (long)cp.getIdleTimeout());
        CacheXml65Test.assertEquals((long)10000L, (long)cp.getPingInterval());
        CacheXml65Test.assertEquals((int)-1, (int)cp.getStatisticInterval());
        CacheXml65Test.assertEquals((String)"", (String)cp.getServerGroup());
        CacheXml65Test.assertEquals((boolean)false, (boolean)cp.getSubscriptionEnabled());
        CacheXml65Test.assertEquals((boolean)true, (boolean)cp.getPRSingleHopEnabled());
        CacheXml65Test.assertEquals((int)0, (int)cp.getSubscriptionRedundancy());
        CacheXml65Test.assertEquals((int)900000, (int)cp.getSubscriptionMessageTrackingTimeout());
        CacheXml65Test.assertEquals((int)100, (int)cp.getSubscriptionAckInterval());
        CacheXml65Test.assertEquals((boolean)false, (boolean)cp.getMultiuserAuthentication());
    }

    public void testDiskStore() throws CacheException {
        CacheCreation cache = new CacheCreation();
        DiskStoreFactory dsf = cache.createDiskStoreFactory();
        File[] dirs1 = new File[]{new File("").getAbsoluteFile()};
        DiskStore ds1 = dsf.setAllowForceCompaction(true).setAutoCompact(true).setCompactionThreshold(100).setMaxOplogSize(2L).setTimeInterval(10L).setWriteBufferSize(15).setQueueSize(12).setDiskDirsAndSizes(dirs1, new int[]{20480}).create(this.getUniqueName() + 1);
        File[] dirs2 = new File[]{new File("").getAbsoluteFile()};
        DiskStore ds2 = dsf.setAllowForceCompaction(false).setAutoCompact(false).setCompactionThreshold(99).setMaxOplogSize(1L).setTimeInterval(9L).setWriteBufferSize(14).setQueueSize(11).setDiskDirsAndSizes(dirs2, new int[]{40960}).create(this.getUniqueName() + 2);
        RegionAttributesCreation attrs = new RegionAttributesCreation(cache);
        attrs.setScope(Scope.DISTRIBUTED_ACK);
        attrs.setDataPolicy(DataPolicy.PERSISTENT_REPLICATE);
        attrs.setDiskStoreName(this.getUniqueName() + 1);
        attrs.setDiskSynchronous(true);
        RegionCreation root = (RegionCreation)cache.createRegion("root", (RegionAttributes)attrs);
        attrs = new RegionAttributesCreation(cache);
        attrs.setScope(Scope.DISTRIBUTED_ACK);
        attrs.setDataPolicy(DataPolicy.PERSISTENT_REPLICATE);
        attrs.setDiskStoreName(this.getUniqueName() + 2);
        Region region = root.createSubregion("subwithdiskstore", (RegionAttributes)attrs);
        attrs = new RegionAttributesCreation(cache);
        attrs.setScope(Scope.DISTRIBUTED_ACK);
        attrs.setDataPolicy(DataPolicy.PERSISTENT_REPLICATE);
        region = root.createSubregion("subwithdefaultdiskstore", (RegionAttributes)attrs);
        this.testXml(cache);
    }

    @Override
    public void testExplicitConnectionPool() throws CacheException {
        this.getSystem();
        CacheCreation cache = new CacheCreation();
        PoolFactory f = cache.createPoolFactory();
        f.addServer(ALIAS2, 3777).addServer(ALIAS1, 3888);
        f.setFreeConnectionTimeout(12345).setLoadConditioningInterval(12345).setSocketBufferSize(12345).setThreadLocalConnections(true).setPRSingleHopEnabled(true).setReadTimeout(12345).setMinConnections(12346).setMaxConnections(12347).setRetryAttempts(12348).setIdleTimeout(12349L).setPingInterval(12350L).setStatisticInterval(12351).setServerGroup("mygroup").setSubscriptionRedundancy(12345).setSubscriptionMessageTrackingTimeout(12345).setSubscriptionAckInterval(333).setMultiuserAuthentication(true);
        f.create("mypool");
        RegionAttributesCreation attrs = new RegionAttributesCreation(cache);
        attrs.setPoolName("mypool");
        attrs.setDataPolicy(DataPolicy.EMPTY);
        cache.createVMRegion("rootNORMAL", (RegionAttributes)attrs);
        this.testXml(cache);
        Cache c = this.getCache();
        CacheXml65Test.assertNotNull((Object)c);
        Region r = c.getRegion("rootNORMAL");
        CacheXml65Test.assertNotNull((Object)r);
        CacheXml65Test.assertEquals((String)"mypool", (String)r.getAttributes().getPoolName());
        Pool cp = PoolManager.find((String)"mypool");
        CacheXml65Test.assertNotNull((Object)cp);
        CacheXml65Test.assertEquals((int)0, (int)cp.getLocators().size());
        CacheXml65Test.assertEquals((int)2, (int)cp.getServers().size());
        CacheXml65Test.assertEquals((Object)CacheXml65Test.createINSA(ALIAS2, 3777), cp.getServers().get(0));
        CacheXml65Test.assertEquals((Object)CacheXml65Test.createINSA(ALIAS1, 3888), cp.getServers().get(1));
        CacheXml65Test.assertEquals((int)12345, (int)cp.getFreeConnectionTimeout());
        CacheXml65Test.assertEquals((int)12345, (int)cp.getLoadConditioningInterval());
        CacheXml65Test.assertEquals((int)12345, (int)cp.getSocketBufferSize());
        CacheXml65Test.assertEquals((boolean)true, (boolean)cp.getThreadLocalConnections());
        CacheXml65Test.assertEquals((boolean)true, (boolean)cp.getPRSingleHopEnabled());
        CacheXml65Test.assertEquals((int)12345, (int)cp.getReadTimeout());
        CacheXml65Test.assertEquals((int)12346, (int)cp.getMinConnections());
        CacheXml65Test.assertEquals((int)12347, (int)cp.getMaxConnections());
        CacheXml65Test.assertEquals((int)12348, (int)cp.getRetryAttempts());
        CacheXml65Test.assertEquals((long)12349L, (long)cp.getIdleTimeout());
        CacheXml65Test.assertEquals((long)12350L, (long)cp.getPingInterval());
        CacheXml65Test.assertEquals((int)12351, (int)cp.getStatisticInterval());
        CacheXml65Test.assertEquals((String)"mygroup", (String)cp.getServerGroup());
        CacheXml65Test.assertEquals((int)12345, (int)cp.getSubscriptionRedundancy());
        CacheXml65Test.assertEquals((int)12345, (int)cp.getSubscriptionMessageTrackingTimeout());
        CacheXml65Test.assertEquals((int)333, (int)cp.getSubscriptionAckInterval());
        CacheXml65Test.assertEquals((boolean)true, (boolean)cp.getMultiuserAuthentication());
    }

    public void testDiskStoreValidation() throws CacheException {
        RegionAttributes regionAttributes;
        AttributesFactory factory;
        RegionCreation root;
        CacheCreation cache = new CacheCreation();
        DiskStoreFactory dsf = cache.createDiskStoreFactory();
        DiskStore ds1 = dsf.create(this.getUniqueName());
        RegionAttributesCreation attrs = new RegionAttributesCreation(cache);
        attrs.setScope(Scope.DISTRIBUTED_ACK);
        attrs.setDataPolicy(DataPolicy.REPLICATE);
        attrs.setDiskStoreName(this.getUniqueName());
        try {
            root = (RegionCreation)cache.createRegion("root", (RegionAttributes)attrs);
        }
        catch (IllegalStateException e) {
            CacheXml65Test.assertTrue((boolean)e.getMessage().contains(LocalizedStrings.DiskStore_IS_USED_IN_NONPERSISTENT_REGION.toLocalizedString()));
        }
        catch (Exception ex) {
            CacheXml65Test.fail("Unexpected exception", ex);
        }
        EvictionAttributes ea = EvictionAttributes.createLRUEntryAttributes((int)1000, (EvictionAction)EvictionAction.OVERFLOW_TO_DISK);
        attrs.setEvictionAttributes(ea);
        try {
            root = (RegionCreation)cache.createRegion("root", (RegionAttributes)attrs);
        }
        catch (IllegalStateException e) {
            CacheXml65Test.fail("With eviction of overflow to disk, region can specify disk store name", e);
        }
        catch (Exception ex) {
            CacheXml65Test.fail("Unexpected exception", ex);
        }
        File dir = new File("testDiskStoreValidation");
        dir.mkdir();
        dir.deleteOnExit();
        File[] dirs2 = new File[]{dir, new File("").getAbsoluteFile()};
        try {
            factory = new AttributesFactory();
            factory.setDiskDirs(dirs2);
            factory.setDiskStoreName(this.getUniqueName());
            regionAttributes = factory.create();
        }
        catch (IllegalStateException e) {
            CacheXml65Test.assertTrue((boolean)e.getMessage().contains(LocalizedStrings.DiskStore_Deprecated_API_0_Cannot_Mix_With_DiskStore_1.toLocalizedString(new Object[]{"setDiskDirs or setDiskWriteAttributes", this.getUniqueName()})));
        }
        catch (Exception ex) {
            CacheXml65Test.fail("Unexpected exception", ex);
        }
        try {
            factory = new AttributesFactory();
            factory.setDiskStoreName(this.getUniqueName());
            factory.setDiskDirs(dirs2);
            regionAttributes = factory.create();
        }
        catch (IllegalStateException e) {
            CacheXml65Test.assertTrue((boolean)e.getMessage().contains(LocalizedStrings.DiskStore_Deprecated_API_0_Cannot_Mix_With_DiskStore_1.toLocalizedString(new Object[]{"setDiskDirs", this.getUniqueName()})));
        }
        catch (Exception ex) {
            CacheXml65Test.fail("Unexpected exception", ex);
        }
        this.testXml(cache);
    }

    public void testDiskStoreFactory() throws CacheException {
        DiskStore ds1;
        CacheCreation cache = new CacheCreation();
        DiskStoreFactory dsf = cache.createDiskStoreFactory();
        try {
            dsf.setDiskDirs(new File[]{new File("non_exist_dir")});
            ds1 = dsf.create(this.getUniqueName());
            CacheXml65Test.fail((String)"Expected IllegalStateException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        dsf.setDiskDirs(new File[]{new File(".")});
        ds1 = dsf.create(this.getUniqueName());
        RegionAttributesCreation attrs = new RegionAttributesCreation(cache);
        attrs.setScope(Scope.DISTRIBUTED_ACK);
        attrs.setDataPolicy(DataPolicy.PERSISTENT_REPLICATE);
        attrs.setDiskStoreName(this.getUniqueName());
        AttributesFactory factory = new AttributesFactory((RegionAttributes)attrs);
        RegionAttributes ra = factory.create();
        try {
            RegionCreation root = (RegionCreation)cache.createRegion("root", ra);
        }
        catch (Exception ex) {
            CacheXml65Test.fail("Unexpected exception", ex);
        }
        factory = new AttributesFactory();
        factory.setDiskStoreName(this.getUniqueName());
        factory.setScope(Scope.DISTRIBUTED_ACK);
        factory.setDataPolicy(DataPolicy.PERSISTENT_REPLICATE);
        ra = factory.create();
        try {
            RegionCreation root2 = (RegionCreation)cache.createRegion("root2", ra);
        }
        catch (Exception ex) {
            CacheXml65Test.fail("Unexpected exception", ex);
        }
        factory = new AttributesFactory();
        factory.setDiskStoreName(null);
        factory.setScope(Scope.DISTRIBUTED_ACK);
        factory.setDataPolicy(DataPolicy.PERSISTENT_REPLICATE);
        ra = factory.create();
        try {
            RegionCreation root3 = (RegionCreation)cache.createRegion("root3", ra);
        }
        catch (Exception ex) {
            CacheXml65Test.fail("Unexpected exception", ex);
        }
        this.testXml(cache);
    }

    public void testRedefineOfDefaultDiskStore() throws CacheException {
        CacheCreation cache = new CacheCreation();
        DiskStoreFactory dsf = cache.createDiskStoreFactory();
        dsf.setAutoCompact(false);
        DiskStore ds1 = dsf.create("DEFAULT");
        RegionAttributesCreation attrs = new RegionAttributesCreation(cache);
        attrs.setScope(Scope.DISTRIBUTED_ACK);
        attrs.setDataPolicy(DataPolicy.PERSISTENT_REPLICATE);
        AttributesFactory factory = new AttributesFactory((RegionAttributes)attrs);
        RegionAttributes ra = factory.create();
        try {
            RegionCreation root = (RegionCreation)cache.createRegion("root", ra);
        }
        catch (Exception ex) {
            CacheXml65Test.fail("Unexpected exception", ex);
        }
        this.testXml(cache);
        Cache c = this.getCache();
        CacheXml65Test.assertNotNull((Object)c);
        DiskStore ds2 = c.findDiskStore("DEFAULT");
        CacheXml65Test.assertNotNull((Object)ds2);
        CacheXml65Test.assertEquals((boolean)ds1.getAutoCompact(), (boolean)ds2.getAutoCompact());
    }

    public void testPersistentPartition() throws CacheException {
        CacheCreation cache = new CacheCreation();
        RegionAttributesCreation attrs = new RegionAttributesCreation(cache);
        attrs.setDataPolicy(DataPolicy.PERSISTENT_PARTITION);
        cache.createRegion("parRoot", (RegionAttributes)attrs);
        Region r = cache.getRegion("parRoot");
        CacheXml65Test.assertEquals((Object)DataPolicy.PERSISTENT_PARTITION, (Object)r.getAttributes().getDataPolicy());
        this.testXml(cache);
        Cache c = this.getCache();
        CacheXml65Test.assertNotNull((Object)c);
        Region region = c.getRegion("parRoot");
        CacheXml65Test.assertNotNull((Object)region);
        CacheXml65Test.assertEquals((Object)DataPolicy.PERSISTENT_PARTITION, (Object)region.getAttributes().getDataPolicy());
        region.localDestroyRegion();
    }

    public void testGatewayHub65() throws CacheException {
        String diskStoreName = this.getUniqueName();
        CacheCreation cache = new CacheCreation();
        int HUB_PORT = AvailablePort.getRandomAvailablePort((int)0);
        int PORT1 = AvailablePort.getRandomAvailablePort((int)0);
        int PORT2 = AvailablePort.getRandomAvailablePort((int)0);
        GatewayHub hub = cache.setGatewayHub("US", HUB_PORT);
        hub.setSocketBufferSize(65536);
        hub.setMaximumTimeBetweenPings(30000);
        Gateway gateway = hub.addGateway("EU");
        gateway.setSocketBufferSize(65536);
        gateway.addEndpoint("EU-1", DistributedTestCase.getIPLiteral(), PORT1);
        gateway.addEndpoint("EU-2", DistributedTestCase.getIPLiteral(), PORT2);
        GatewayQueueAttributes queueAttributes = gateway.getQueueAttributes();
        File overflowDirectory = new File(this.getName());
        overflowDirectory.mkdir();
        DiskStoreFactory dsf = cache.createDiskStoreFactory();
        File[] dirs1 = new File[]{overflowDirectory.getAbsoluteFile()};
        DiskStore ds1 = dsf.setDiskDirs(dirs1).create(diskStoreName);
        queueAttributes.setDiskStoreName(diskStoreName);
        try {
            queueAttributes.setOverflowDirectory(overflowDirectory.getAbsolutePath());
        }
        catch (IllegalStateException e) {
            CacheXml65Test.assertTrue((boolean)e.getMessage().contains(LocalizedStrings.DiskStore_Deprecated_API_0_Cannot_Mix_With_DiskStore_1.toLocalizedString(new Object[]{"setOverflowDirectory", diskStoreName})));
        }
        catch (Exception ex) {
            CacheXml65Test.fail("Unexpected exception", ex);
        }
        queueAttributes.setMaximumQueueMemory(200);
        queueAttributes.setBatchSize(500);
        queueAttributes.setBatchTimeInterval(100);
        queueAttributes.setBatchConflation(true);
        queueAttributes.setEnablePersistence(true);
        this.testXml(cache);
        Cache c = this.getCache();
        List hubs = c.getGatewayHubs();
        GatewayHub createdHub = (GatewayHub)hubs.get(0);
        CacheXml65Test.assertTrue((createdHub != null ? 1 : 0) != 0);
        CacheXml65Test.assertEquals((String)"US", (String)createdHub.getId());
        CacheXml65Test.assertEquals((int)HUB_PORT, (int)createdHub.getPort());
        CacheXml65Test.assertEquals((int)65536, (int)createdHub.getSocketBufferSize());
        Gateway createdGateway = (Gateway)createdHub.getGateways().get(0);
        CacheXml65Test.assertNotNull((Object)createdGateway);
        CacheXml65Test.assertEquals((String)"EU", (String)createdGateway.getId());
        CacheXml65Test.assertEquals((int)65536, (int)createdGateway.getSocketBufferSize());
        List endpoints = createdGateway.getEndpoints();
        CacheXml65Test.assertEquals((int)2, (int)endpoints.size());
        for (Gateway.Endpoint endpoint : endpoints) {
            if (endpoint.getId().equals("EU-1")) {
                CacheXml65Test.assertEquals((String)DistributedTestCase.getIPLiteral(), (String)endpoint.getHost());
                CacheXml65Test.assertEquals((int)PORT1, (int)endpoint.getPort());
                continue;
            }
            if (endpoint.getId().equals("EU-2")) {
                CacheXml65Test.assertEquals((String)DistributedTestCase.getIPLiteral(), (String)endpoint.getHost());
                CacheXml65Test.assertEquals((int)PORT2, (int)endpoint.getPort());
                continue;
            }
            CacheXml65Test.fail((String)("Expected an endpoint with id EU-1 or EU-2 but got one with id " + endpoint.getId()));
        }
        GatewayQueueAttributes createdQueueAttributes = createdGateway.getQueueAttributes();
        CacheXml65Test.assertEquals((String)diskStoreName, (String)createdQueueAttributes.getDiskStoreName());
        CacheXml65Test.assertEquals((String)overflowDirectory.getAbsolutePath(), (String)ds1.getDiskDirs()[0].getAbsolutePath());
        CacheXml65Test.assertEquals((int)200, (int)createdQueueAttributes.getMaximumQueueMemory());
        CacheXml65Test.assertEquals((int)500, (int)createdQueueAttributes.getBatchSize());
        CacheXml65Test.assertEquals((int)100, (int)createdQueueAttributes.getBatchTimeInterval());
        CacheXml65Test.assertEquals((boolean)true, (boolean)createdQueueAttributes.getBatchConflation());
        CacheXml65Test.assertEquals((boolean)true, (boolean)createdQueueAttributes.getEnablePersistence());
        String rq = new StringBuffer(createdGateway.getGatewayHubId()).append('_').append(createdGateway.getId()).append("_EVENT_QUEUE").toString();
        Region wbcl = c.getRegion(rq);
        if (wbcl != null) {
            wbcl.localDestroyRegion();
        }
    }

    public void testGatewayHub65ForDefaultDS() {
        CacheCreation cache = new CacheCreation();
        int HUB_PORT = AvailablePort.getRandomAvailablePort((int)0);
        int PORT1 = AvailablePort.getRandomAvailablePort((int)0);
        int PORT2 = AvailablePort.getRandomAvailablePort((int)0);
        GatewayHub hub = cache.setGatewayHub("US", HUB_PORT);
        hub.setSocketBufferSize(65536);
        hub.setMaximumTimeBetweenPings(30000);
        Gateway gateway = hub.addGateway("EU");
        gateway.setSocketBufferSize(65536);
        gateway.addEndpoint("EU-1", DistributedTestCase.getIPLiteral(), PORT1);
        gateway.addEndpoint("EU-2", DistributedTestCase.getIPLiteral(), PORT2);
        GatewayQueueAttributes queueAttributes = gateway.getQueueAttributes();
        queueAttributes.setMaximumQueueMemory(200);
        queueAttributes.setBatchSize(500);
        queueAttributes.setBatchTimeInterval(100);
        queueAttributes.setBatchConflation(true);
        queueAttributes.setEnablePersistence(true);
        this.testXml(cache);
        Cache c = this.getCache();
        List hubs = c.getGatewayHubs();
        GatewayHub createdHub = (GatewayHub)hubs.get(0);
        CacheXml65Test.assertTrue((createdHub != null ? 1 : 0) != 0);
        try {
            createdHub.start();
        }
        catch (IOException e) {
            CacheXml65Test.fail("Unexpected exception", e);
        }
        CacheXml65Test.assertEquals((String)"US", (String)createdHub.getId());
        CacheXml65Test.assertEquals((int)HUB_PORT, (int)createdHub.getPort());
        CacheXml65Test.assertEquals((int)65536, (int)createdHub.getSocketBufferSize());
        Gateway createdGateway = (Gateway)createdHub.getGateways().get(0);
        CacheXml65Test.assertNotNull((Object)createdGateway);
        CacheXml65Test.assertEquals((String)"EU", (String)createdGateway.getId());
        CacheXml65Test.assertEquals((int)65536, (int)createdGateway.getSocketBufferSize());
        List endpoints = createdGateway.getEndpoints();
        CacheXml65Test.assertEquals((int)2, (int)endpoints.size());
        for (Gateway.Endpoint endpoint : endpoints) {
            if (endpoint.getId().equals("EU-1")) {
                CacheXml65Test.assertEquals((String)DistributedTestCase.getIPLiteral(), (String)endpoint.getHost());
                CacheXml65Test.assertEquals((int)PORT1, (int)endpoint.getPort());
                continue;
            }
            if (endpoint.getId().equals("EU-2")) {
                CacheXml65Test.assertEquals((String)DistributedTestCase.getIPLiteral(), (String)endpoint.getHost());
                CacheXml65Test.assertEquals((int)PORT2, (int)endpoint.getPort());
                continue;
            }
            CacheXml65Test.fail((String)("Expected an endpoint with id EU-1 or EU-2 but got one with id " + endpoint.getId()));
        }
        GatewayQueueAttributes createdQueueAttributes = createdGateway.getQueueAttributes();
        CacheXml65Test.assertEquals(null, (String)createdQueueAttributes.getDiskStoreName());
        File curDir = new File(".").getAbsoluteFile();
        File lockFile = new File(curDir, "DRLK_IF" + GemFireCacheImpl.DEFAULT_DS_NAME + ".lk");
        CacheXml65Test.assertTrue((boolean)lockFile.exists());
        CacheXml65Test.assertEquals((int)200, (int)createdQueueAttributes.getMaximumQueueMemory());
        CacheXml65Test.assertEquals((int)500, (int)createdQueueAttributes.getBatchSize());
        CacheXml65Test.assertEquals((int)100, (int)createdQueueAttributes.getBatchTimeInterval());
        CacheXml65Test.assertEquals((boolean)true, (boolean)createdQueueAttributes.getBatchConflation());
        CacheXml65Test.assertEquals((boolean)true, (boolean)createdQueueAttributes.getEnablePersistence());
        String rq = new StringBuffer(createdGateway.getGatewayHubId()).append('_').append(createdGateway.getId()).append("_EVENT_QUEUE").toString();
        Region wbcl = c.getRegion(rq);
        if (wbcl != null) {
            wbcl.localDestroyRegion();
        }
    }

    public void testBridgeAttributesRelatedToHAOverFlow65() throws CacheException {
        CacheCreation cache = new CacheCreation();
        cache.setMessageSyncInterval(3445);
        CacheServer bs = cache.addCacheServer();
        ClientSubscriptionConfig csc = bs.getClientSubscriptionConfig();
        csc.setEvictionPolicy("entry");
        cache.getLogger().config("EvictionPolicy : " + csc.getEvictionPolicy());
        csc.setCapacity(501);
        cache.getLogger().config("EvictionCapacity : " + csc.getCapacity());
        File overflowDirectory = new File("overFlow");
        overflowDirectory.mkdirs();
        DiskStoreFactory dsf = cache.createDiskStoreFactory();
        File[] dirs1 = new File[]{overflowDirectory};
        DiskStore ds1 = dsf.setDiskDirs(dirs1).create(this.getUniqueName());
        csc.setDiskStoreName(this.getUniqueName());
        try {
            csc.setOverflowDirectory("overFlow");
        }
        catch (IllegalStateException e) {
            CacheXml65Test.assertTrue((boolean)e.getMessage().contains(LocalizedStrings.DiskStore_Deprecated_API_0_Cannot_Mix_With_DiskStore_1.toLocalizedString(new Object[]{"setOverflowDirectory", this.getUniqueName()})));
        }
        catch (Exception ex) {
            CacheXml65Test.fail("Unexpected exception", ex);
        }
        cache.getLogger().config("Eviction disk store : " + csc.getDiskStoreName());
        bs.setPort(AvailablePortHelper.getRandomAvailableTCPPort());
        RegionAttributesCreation attrs = new RegionAttributesCreation(cache);
        attrs.setDataPolicy(DataPolicy.NORMAL);
        cache.createVMRegion("rootNORMAL", (RegionAttributes)attrs);
        this.testXml(cache);
        Cache c = this.getCache();
        CacheXml65Test.assertNotNull((Object)c);
        CacheServer server = (CacheServer)cache.getCacheServers().iterator().next();
        CacheXml65Test.assertNotNull((Object)server);
        ClientSubscriptionConfig chaqf = server.getClientSubscriptionConfig();
        CacheXml65Test.assertEquals((String)"entry", (String)chaqf.getEvictionPolicy());
        CacheXml65Test.assertEquals((int)501, (int)chaqf.getCapacity());
        DiskStore dsi = cache.findDiskStore(chaqf.getDiskStoreName());
        CacheXml65Test.assertEquals((String)"overFlow", (String)dsi.getDiskDirs()[0].toString());
    }

    public void testClientSubscriptionQueueUsingDefaultDS() throws CacheException {
        CacheCreation cache = new CacheCreation();
        cache.setMessageSyncInterval(3445);
        CacheServer bs = cache.addCacheServer();
        ClientSubscriptionConfig csc = bs.getClientSubscriptionConfig();
        csc.setEvictionPolicy("entry");
        cache.getLogger().config("EvictionPolicy : " + csc.getEvictionPolicy());
        csc.setCapacity(501);
        cache.getLogger().config("EvictionCapacity : " + csc.getCapacity());
        cache.getLogger().config("Eviction disk store : " + csc.getDiskStoreName());
        bs.setPort(AvailablePortHelper.getRandomAvailableTCPPort());
        RegionAttributesCreation attrs = new RegionAttributesCreation(cache);
        attrs.setDataPolicy(DataPolicy.NORMAL);
        cache.createVMRegion("rootNORMAL", (RegionAttributes)attrs);
        this.testXml(cache);
        Cache c = this.getCache();
        CacheXml65Test.assertNotNull((Object)c);
        CacheServer server = (CacheServer)cache.getCacheServers().iterator().next();
        CacheXml65Test.assertNotNull((Object)server);
        ClientSubscriptionConfig chaqf = server.getClientSubscriptionConfig();
        CacheXml65Test.assertEquals((String)"entry", (String)chaqf.getEvictionPolicy());
        CacheXml65Test.assertEquals((int)501, (int)chaqf.getCapacity());
        File curDir = new File(".").getAbsoluteFile();
        File lockFile = new File(curDir, "DRLK_IF" + GemFireCacheImpl.DEFAULT_DS_NAME + ".lk");
        CacheXml65Test.assertTrue((boolean)lockFile.exists());
    }

    public void testTransactionWriter() throws CacheException {
        CacheCreation creation = new CacheCreation();
        CacheTransactionManagerCreation ctmc = new CacheTransactionManagerCreation();
        ctmc.setWriter((TransactionWriter)new TestTransactionWriter());
        creation.addCacheTransactionManagerCreation(ctmc);
        this.testXml(creation);
        Cache c = this.getCache();
        CacheXml65Test.assertTrue((boolean)(c instanceof GemFireCacheImpl));
        c.loadCacheXml(this.generate(creation));
        TransactionWriter tw = c.getCacheTransactionManager().getWriter();
        CacheXml65Test.assertTrue((String)("tw should be TransactionWriter, but it is:" + tw), (boolean)(tw instanceof TestTransactionWriter));
    }

    public void testDiskStoreInTemplates() throws CacheException {
        File dir = new File("west");
        dir.mkdir();
        dir.deleteOnExit();
        dir = new File("east");
        dir.mkdir();
        dir.deleteOnExit();
        this.setXmlFile(this.findFile("ewtest.xml"));
        String regionName_west = "orders/west";
        String regionName_east = "orders/east";
        Cache cache = this.getCache();
        DiskStore ds = cache.findDiskStore("persistentDiskStore1");
        CacheXml65Test.assertNotNull((Object)ds);
        CacheXml65Test.assertEquals((int)500, (int)ds.getQueueSize());
        File[] dirs = ds.getDiskDirs();
        CacheXml65Test.assertEquals((String)"west", (String)dirs[0].getPath());
        ds = cache.findDiskStore("persistentDiskStore2");
        CacheXml65Test.assertNotNull((Object)ds);
        CacheXml65Test.assertEquals((int)500, (int)ds.getQueueSize());
        dirs = ds.getDiskDirs();
        CacheXml65Test.assertEquals((String)"east", (String)dirs[0].getPath());
        CacheXml65Test.assertNotNull((Object)cache.getRegionAttributes("nack"));
        RegionAttributes attrs = cache.getRegionAttributes("persistent");
        CacheXml65Test.assertEquals((Object)DataPolicy.PERSISTENT_REPLICATE, (Object)attrs.getDataPolicy());
        CacheXml65Test.assertEquals((boolean)false, (boolean)attrs.isDiskSynchronous());
        CacheXml65Test.assertEquals((String)"persistentDiskStore1", (String)attrs.getDiskStoreName());
        Region region = cache.getRegion(regionName_west);
        CacheXml65Test.assertNotNull((Object)region);
        attrs = region.getAttributes();
        CacheXml65Test.assertEquals((Object)DataPolicy.PERSISTENT_REPLICATE, (Object)attrs.getDataPolicy());
        CacheXml65Test.assertEquals((boolean)false, (boolean)attrs.isDiskSynchronous());
        CacheXml65Test.assertEquals((String)"persistentDiskStore1", (String)attrs.getDiskStoreName());
        region = cache.getRegion(regionName_east);
        CacheXml65Test.assertNotNull((Object)region);
        attrs = region.getAttributes();
        CacheXml65Test.assertEquals((Object)DataPolicy.PERSISTENT_REPLICATE, (Object)attrs.getDataPolicy());
        CacheXml65Test.assertEquals((boolean)false, (boolean)attrs.isDiskSynchronous());
        CacheXml65Test.assertEquals((String)"persistentDiskStore2", (String)attrs.getDiskStoreName());
        String regionName_datap = "data-p";
        region = cache.getRegion(regionName_datap);
        CacheXml65Test.assertNotNull((Object)region);
        attrs = region.getAttributes();
        PartitionAttributes pa = attrs.getPartitionAttributes();
        CacheXml65Test.assertEquals((int)1, (int)pa.getRedundantCopies());
        CacheXml65Test.assertEquals((int)3, (int)pa.getTotalNumBuckets());
        CacheXml65Test.assertEquals((Object)DataPolicy.PERSISTENT_PARTITION, (Object)attrs.getDataPolicy());
    }

    public void testBackupFiles() throws CacheException {
        CacheCreation cache = new CacheCreation();
        File backup1 = new File("/back/me/up");
        File backup2 = new File("/me/too/please");
        cache.addBackup(backup1);
        cache.addBackup(backup2);
        this.testXml(cache);
        GemFireCacheImpl c = (GemFireCacheImpl)this.getCache();
        CacheXml65Test.assertEquals(Arrays.asList(backup1, backup2), (Object)c.getBackupFiles());
    }

    public void testClientCache() throws CacheException {
        ClientCacheCreation cache = new ClientCacheCreation();
        cache.setCopyOnRead(true);
        this.testXml((CacheCreation)cache);
        GemFireCacheImpl c = (GemFireCacheImpl)this.getCache();
        CacheXml65Test.assertEquals((boolean)true, (boolean)c.getCopyOnRead());
        CacheXml65Test.assertEquals((boolean)true, (boolean)c.isClient());
        for (ClientRegionShortcut pra : ClientRegionShortcut.values()) {
            CacheXml65Test.assertNotNull((Object)c.getRegionAttributes(pra.name()));
        }
        CacheXml65Test.assertEquals((int)ClientRegionShortcut.values().length, (int)c.listRegionAttributes().size());
    }

    public void testNormalCache() throws CacheException {
        CacheCreation cache = new CacheCreation();
        cache.setCopyOnRead(true);
        this.testXml(cache);
        GemFireCacheImpl c = (GemFireCacheImpl)this.getCache();
        CacheXml65Test.assertEquals((boolean)true, (boolean)c.getCopyOnRead());
        CacheXml65Test.assertEquals((boolean)false, (boolean)c.isClient());
        for (RegionShortcut pra : RegionShortcut.values()) {
            CacheXml65Test.assertNotNull((Object)c.getRegionAttributes(pra.name()));
        }
        CacheXml65Test.assertEquals((int)RegionShortcut.values().length, (int)c.listRegionAttributes().size());
    }

    public void testPARTITION() throws CacheException {
        CacheCreation cache = new CacheCreation();
        RegionCreation root = (RegionCreation)cache.createRegion("partition", "PARTITION");
        this.testXml(cache);
        GemFireCacheImpl c = (GemFireCacheImpl)this.getCache();
        Region r = c.getRegion("partition");
        CacheXml65Test.assertNotNull((Object)r);
        RegionAttributes ra = r.getAttributes();
        CacheXml65Test.assertEquals((Object)DataPolicy.PARTITION, (Object)ra.getDataPolicy());
        CacheXml65Test.assertNotNull((Object)ra.getPartitionAttributes());
        CacheXml65Test.assertEquals((int)0, (int)ra.getPartitionAttributes().getRedundantCopies());
    }

    public void testPARTITION_REDUNDANT() throws CacheException {
        CacheCreation cache = new CacheCreation();
        RegionCreation root = (RegionCreation)cache.createRegion("rpartition", "PARTITION_REDUNDANT");
        this.testXml(cache);
        GemFireCacheImpl c = (GemFireCacheImpl)this.getCache();
        Region r = c.getRegion("rpartition");
        CacheXml65Test.assertNotNull((Object)r);
        RegionAttributes ra = r.getAttributes();
        CacheXml65Test.assertEquals((Object)DataPolicy.PARTITION, (Object)ra.getDataPolicy());
        CacheXml65Test.assertNotNull((Object)ra.getPartitionAttributes());
        CacheXml65Test.assertEquals((int)1, (int)ra.getPartitionAttributes().getRedundantCopies());
    }

    public void testPARTITION_PERSISTENT() throws CacheException {
        CacheCreation cache = new CacheCreation();
        RegionCreation root = (RegionCreation)cache.createRegion("ppartition", "PARTITION_PERSISTENT");
        this.testXml(cache);
        GemFireCacheImpl c = (GemFireCacheImpl)this.getCache();
        Region r = c.getRegion("ppartition");
        CacheXml65Test.assertNotNull((Object)r);
        RegionAttributes ra = r.getAttributes();
        CacheXml65Test.assertEquals((Object)DataPolicy.PERSISTENT_PARTITION, (Object)ra.getDataPolicy());
        CacheXml65Test.assertNotNull((Object)ra.getPartitionAttributes());
        CacheXml65Test.assertEquals((int)0, (int)ra.getPartitionAttributes().getRedundantCopies());
    }

    public void testPARTITION_REDUNDANT_PERSISTENT() throws CacheException {
        CacheCreation cache = new CacheCreation();
        RegionCreation root = (RegionCreation)cache.createRegion("prpartition", "PARTITION_REDUNDANT_PERSISTENT");
        this.testXml(cache);
        GemFireCacheImpl c = (GemFireCacheImpl)this.getCache();
        Region r = c.getRegion("prpartition");
        CacheXml65Test.assertNotNull((Object)r);
        RegionAttributes ra = r.getAttributes();
        CacheXml65Test.assertEquals((Object)DataPolicy.PERSISTENT_PARTITION, (Object)ra.getDataPolicy());
        CacheXml65Test.assertNotNull((Object)ra.getPartitionAttributes());
        CacheXml65Test.assertEquals((int)1, (int)ra.getPartitionAttributes().getRedundantCopies());
    }

    public void testPARTITION_OVERFLOW() throws CacheException {
        CacheCreation cache = new CacheCreation();
        ResourceManagerCreation rmc = new ResourceManagerCreation();
        rmc.setEvictionHeapPercentage(55.0f);
        rmc.setCriticalHeapPercentage(80.0f);
        cache.setResourceManagerCreation(rmc);
        RegionCreation root = (RegionCreation)cache.createRegion("partitionoverflow", "PARTITION_OVERFLOW");
        this.testXml(cache);
        GemFireCacheImpl c = (GemFireCacheImpl)this.getCache();
        Region r = c.getRegion("partitionoverflow");
        CacheXml65Test.assertNotNull((Object)r);
        RegionAttributes ra = r.getAttributes();
        CacheXml65Test.assertEquals((Object)DataPolicy.PARTITION, (Object)ra.getDataPolicy());
        CacheXml65Test.assertNotNull((Object)ra.getPartitionAttributes());
        CacheXml65Test.assertEquals((int)0, (int)ra.getPartitionAttributes().getRedundantCopies());
        CacheXml65Test.assertEquals((Object)EvictionAttributes.createLRUHeapAttributes(null, (EvictionAction)EvictionAction.OVERFLOW_TO_DISK), (Object)ra.getEvictionAttributes());
        CacheXml65Test.assertEquals((Object)Float.valueOf(55.0f), (Object)Float.valueOf(c.getResourceManager().getEvictionHeapPercentage()));
        CacheXml65Test.assertEquals((Object)Float.valueOf(80.0f), (Object)Float.valueOf(c.getResourceManager().getCriticalHeapPercentage()));
    }

    public void testPARTITION_REDUNDANT_OVERFLOW() throws CacheException {
        CacheCreation cache = new CacheCreation();
        RegionCreation root = (RegionCreation)cache.createRegion("rpartitionoverflow", "PARTITION_REDUNDANT_OVERFLOW");
        this.testXml(cache);
        GemFireCacheImpl c = (GemFireCacheImpl)this.getCache();
        Region r = c.getRegion("rpartitionoverflow");
        CacheXml65Test.assertNotNull((Object)r);
        RegionAttributes ra = r.getAttributes();
        CacheXml65Test.assertEquals((Object)DataPolicy.PARTITION, (Object)ra.getDataPolicy());
        CacheXml65Test.assertNotNull((Object)ra.getPartitionAttributes());
        CacheXml65Test.assertEquals((int)1, (int)ra.getPartitionAttributes().getRedundantCopies());
        CacheXml65Test.assertEquals((Object)EvictionAttributes.createLRUHeapAttributes(null, (EvictionAction)EvictionAction.OVERFLOW_TO_DISK), (Object)ra.getEvictionAttributes());
        CacheXml65Test.assertEquals((Object)Float.valueOf(80.0f), (Object)Float.valueOf(c.getResourceManager().getEvictionHeapPercentage()));
    }

    public void testPARTITION_PERSISTENT_OVERFLOW() throws CacheException {
        CacheCreation cache = new CacheCreation();
        ResourceManagerCreation rmc = new ResourceManagerCreation();
        rmc.setCriticalHeapPercentage(80.0f);
        cache.setResourceManagerCreation(rmc);
        RegionCreation root = (RegionCreation)cache.createRegion("ppartitionoverflow", "PARTITION_PERSISTENT_OVERFLOW");
        this.testXml(cache);
        GemFireCacheImpl c = (GemFireCacheImpl)this.getCache();
        Region r = c.getRegion("ppartitionoverflow");
        CacheXml65Test.assertNotNull((Object)r);
        RegionAttributes ra = r.getAttributes();
        CacheXml65Test.assertEquals((Object)DataPolicy.PERSISTENT_PARTITION, (Object)ra.getDataPolicy());
        CacheXml65Test.assertNotNull((Object)ra.getPartitionAttributes());
        CacheXml65Test.assertEquals((int)0, (int)ra.getPartitionAttributes().getRedundantCopies());
        CacheXml65Test.assertEquals((Object)EvictionAttributes.createLRUHeapAttributes(null, (EvictionAction)EvictionAction.OVERFLOW_TO_DISK), (Object)ra.getEvictionAttributes());
        CacheXml65Test.assertEquals((Object)Float.valueOf(80.0f), (Object)Float.valueOf(c.getResourceManager().getCriticalHeapPercentage()));
        CacheXml65Test.assertEquals((Object)Float.valueOf(75.0f), (Object)Float.valueOf(c.getResourceManager().getEvictionHeapPercentage()));
    }

    public void testPARTITION_REDUNDANT_PERSISTENT_OVERFLOW() throws CacheException {
        CacheCreation cache = new CacheCreation();
        ResourceManagerCreation rmc = new ResourceManagerCreation();
        rmc.setEvictionHeapPercentage(0.0f);
        cache.setResourceManagerCreation(rmc);
        RegionCreation root = (RegionCreation)cache.createRegion("prpartitionoverflow", "PARTITION_REDUNDANT_PERSISTENT_OVERFLOW");
        this.testXml(cache);
        GemFireCacheImpl c = (GemFireCacheImpl)this.getCache();
        Region r = c.getRegion("prpartitionoverflow");
        CacheXml65Test.assertNotNull((Object)r);
        RegionAttributes ra = r.getAttributes();
        CacheXml65Test.assertEquals((Object)DataPolicy.PERSISTENT_PARTITION, (Object)ra.getDataPolicy());
        CacheXml65Test.assertNotNull((Object)ra.getPartitionAttributes());
        CacheXml65Test.assertEquals((int)1, (int)ra.getPartitionAttributes().getRedundantCopies());
        CacheXml65Test.assertEquals((Object)EvictionAttributes.createLRUHeapAttributes(null, (EvictionAction)EvictionAction.OVERFLOW_TO_DISK), (Object)ra.getEvictionAttributes());
        CacheXml65Test.assertEquals((Object)Float.valueOf(0.0f), (Object)Float.valueOf(c.getResourceManager().getEvictionHeapPercentage()));
    }

    public void testPARTITION_HEAP_LRU() throws CacheException {
        CacheCreation cache = new CacheCreation();
        RegionCreation root = (RegionCreation)cache.createRegion("partitionlru", "PARTITION_HEAP_LRU");
        this.testXml(cache);
        GemFireCacheImpl c = (GemFireCacheImpl)this.getCache();
        Region r = c.getRegion("partitionlru");
        CacheXml65Test.assertNotNull((Object)r);
        RegionAttributes ra = r.getAttributes();
        CacheXml65Test.assertEquals((Object)DataPolicy.PARTITION, (Object)ra.getDataPolicy());
        CacheXml65Test.assertNotNull((Object)ra.getPartitionAttributes());
        CacheXml65Test.assertEquals((int)0, (int)ra.getPartitionAttributes().getRedundantCopies());
        CacheXml65Test.assertEquals((Object)EvictionAttributes.createLRUHeapAttributes(), (Object)ra.getEvictionAttributes());
        CacheXml65Test.assertEquals((Object)Float.valueOf(80.0f), (Object)Float.valueOf(c.getResourceManager().getEvictionHeapPercentage()));
    }

    public void testPARTITION_REDUNDANT_HEAP_LRU() throws CacheException {
        CacheCreation cache = new CacheCreation();
        RegionCreation root = (RegionCreation)cache.createRegion("rpartitionlru", "PARTITION_REDUNDANT_HEAP_LRU");
        this.testXml(cache);
        GemFireCacheImpl c = (GemFireCacheImpl)this.getCache();
        Region r = c.getRegion("rpartitionlru");
        CacheXml65Test.assertNotNull((Object)r);
        RegionAttributes ra = r.getAttributes();
        CacheXml65Test.assertEquals((Object)DataPolicy.PARTITION, (Object)ra.getDataPolicy());
        CacheXml65Test.assertNotNull((Object)ra.getPartitionAttributes());
        CacheXml65Test.assertEquals((int)1, (int)ra.getPartitionAttributes().getRedundantCopies());
        CacheXml65Test.assertEquals((Object)EvictionAttributes.createLRUHeapAttributes(), (Object)ra.getEvictionAttributes());
        CacheXml65Test.assertEquals((Object)Float.valueOf(80.0f), (Object)Float.valueOf(c.getResourceManager().getEvictionHeapPercentage()));
    }

    public void testREPLICATE() throws CacheException {
        CacheCreation cache = new CacheCreation();
        RegionCreation root = (RegionCreation)cache.createRegion("replicate", "REPLICATE");
        this.testXml(cache);
        GemFireCacheImpl c = (GemFireCacheImpl)this.getCache();
        Region r = c.getRegion("replicate");
        CacheXml65Test.assertNotNull((Object)r);
        RegionAttributes ra = r.getAttributes();
        CacheXml65Test.assertEquals((Object)DataPolicy.REPLICATE, (Object)ra.getDataPolicy());
        CacheXml65Test.assertEquals((Object)Scope.DISTRIBUTED_ACK, (Object)ra.getScope());
    }

    public void testREPLICATE_PERSISTENT() throws CacheException {
        CacheCreation cache = new CacheCreation();
        RegionCreation root = (RegionCreation)cache.createRegion("preplicate", "REPLICATE_PERSISTENT");
        this.testXml(cache);
        GemFireCacheImpl c = (GemFireCacheImpl)this.getCache();
        Region r = c.getRegion("preplicate");
        CacheXml65Test.assertNotNull((Object)r);
        RegionAttributes ra = r.getAttributes();
        CacheXml65Test.assertEquals((Object)DataPolicy.PERSISTENT_REPLICATE, (Object)ra.getDataPolicy());
        CacheXml65Test.assertEquals((Object)Scope.DISTRIBUTED_ACK, (Object)ra.getScope());
    }

    public void testREPLICATE_OVERFLOW() throws CacheException {
        CacheCreation cache = new CacheCreation();
        RegionCreation root = (RegionCreation)cache.createRegion("replicateoverflow", "REPLICATE_OVERFLOW");
        this.testXml(cache);
        GemFireCacheImpl c = (GemFireCacheImpl)this.getCache();
        Region r = c.getRegion("replicateoverflow");
        CacheXml65Test.assertNotNull((Object)r);
        RegionAttributes ra = r.getAttributes();
        CacheXml65Test.assertEquals((Object)DataPolicy.REPLICATE, (Object)ra.getDataPolicy());
        CacheXml65Test.assertEquals((Object)Scope.DISTRIBUTED_ACK, (Object)ra.getScope());
        CacheXml65Test.assertEquals((Object)EvictionAttributes.createLRUHeapAttributes(null, (EvictionAction)EvictionAction.OVERFLOW_TO_DISK), (Object)ra.getEvictionAttributes());
        CacheXml65Test.assertEquals((Object)Float.valueOf(80.0f), (Object)Float.valueOf(c.getResourceManager().getEvictionHeapPercentage()));
    }

    public void testREPLICATE_PERSISTENT_OVERFLOW() throws CacheException {
        CacheCreation cache = new CacheCreation();
        RegionCreation root = (RegionCreation)cache.createRegion("preplicateoverflow", "REPLICATE_PERSISTENT_OVERFLOW");
        this.testXml(cache);
        GemFireCacheImpl c = (GemFireCacheImpl)this.getCache();
        Region r = c.getRegion("preplicateoverflow");
        CacheXml65Test.assertNotNull((Object)r);
        RegionAttributes ra = r.getAttributes();
        CacheXml65Test.assertEquals((Object)DataPolicy.PERSISTENT_REPLICATE, (Object)ra.getDataPolicy());
        CacheXml65Test.assertEquals((Object)Scope.DISTRIBUTED_ACK, (Object)ra.getScope());
        CacheXml65Test.assertEquals((Object)EvictionAttributes.createLRUHeapAttributes(null, (EvictionAction)EvictionAction.OVERFLOW_TO_DISK), (Object)ra.getEvictionAttributes());
        CacheXml65Test.assertEquals((Object)Float.valueOf(80.0f), (Object)Float.valueOf(c.getResourceManager().getEvictionHeapPercentage()));
    }

    public void testREPLICATE_HEAP_LRU() throws CacheException, IOException {
        CacheCreation cache = new CacheCreation();
        RegionCreation root = (RegionCreation)cache.createRegion("replicatelru", "REPLICATE_HEAP_LRU");
        this.testXml(cache);
        GemFireCacheImpl c = (GemFireCacheImpl)this.getCache();
        Region r = c.getRegion("replicatelru");
        CacheXml65Test.assertNotNull((Object)r);
        RegionAttributes ra = r.getAttributes();
        CacheXml65Test.assertEquals((Object)DataPolicy.PRELOADED, (Object)ra.getDataPolicy());
        CacheXml65Test.assertEquals((Object)new SubscriptionAttributes(InterestPolicy.ALL), (Object)ra.getSubscriptionAttributes());
        CacheXml65Test.assertEquals((Object)Scope.DISTRIBUTED_ACK, (Object)ra.getScope());
        CacheXml65Test.assertEquals((Object)EvictionAttributes.createLRUHeapAttributes(), (Object)ra.getEvictionAttributes());
        CacheXml65Test.assertEquals((Object)Float.valueOf(80.0f), (Object)Float.valueOf(c.getResourceManager().getEvictionHeapPercentage()));
    }

    public void testLOCAL() throws CacheException {
        CacheCreation cache = new CacheCreation();
        RegionCreation root = (RegionCreation)cache.createRegion("local", "LOCAL");
        this.testXml(cache);
        GemFireCacheImpl c = (GemFireCacheImpl)this.getCache();
        Region r = c.getRegion("local");
        CacheXml65Test.assertNotNull((Object)r);
        RegionAttributes ra = r.getAttributes();
        CacheXml65Test.assertEquals((Object)DataPolicy.NORMAL, (Object)ra.getDataPolicy());
        CacheXml65Test.assertEquals((Object)Scope.LOCAL, (Object)ra.getScope());
    }

    public void testLOCAL_PERSISTENT() throws CacheException {
        CacheCreation cache = new CacheCreation();
        RegionCreation root = (RegionCreation)cache.createRegion("plocal", "LOCAL_PERSISTENT");
        this.testXml(cache);
        GemFireCacheImpl c = (GemFireCacheImpl)this.getCache();
        Region r = c.getRegion("plocal");
        CacheXml65Test.assertNotNull((Object)r);
        RegionAttributes ra = r.getAttributes();
        CacheXml65Test.assertEquals((Object)DataPolicy.PERSISTENT_REPLICATE, (Object)ra.getDataPolicy());
        CacheXml65Test.assertEquals((Object)Scope.LOCAL, (Object)ra.getScope());
    }

    public void testLOCAL_HEAP_LRU() throws CacheException {
        CacheCreation cache = new CacheCreation();
        RegionCreation root = (RegionCreation)cache.createRegion("locallru", "LOCAL_HEAP_LRU");
        this.testXml(cache);
        GemFireCacheImpl c = (GemFireCacheImpl)this.getCache();
        Region r = c.getRegion("locallru");
        CacheXml65Test.assertNotNull((Object)r);
        RegionAttributes ra = r.getAttributes();
        CacheXml65Test.assertEquals((Object)DataPolicy.NORMAL, (Object)ra.getDataPolicy());
        CacheXml65Test.assertEquals((Object)Scope.LOCAL, (Object)ra.getScope());
        CacheXml65Test.assertEquals((Object)EvictionAttributes.createLRUHeapAttributes(), (Object)ra.getEvictionAttributes());
        CacheXml65Test.assertEquals((Object)Float.valueOf(80.0f), (Object)Float.valueOf(c.getResourceManager().getEvictionHeapPercentage()));
    }

    public void testLOCAL_OVERFLOW() throws CacheException {
        CacheCreation cache = new CacheCreation();
        RegionCreation root = (RegionCreation)cache.createRegion("localoverflow", "LOCAL_OVERFLOW");
        this.testXml(cache);
        GemFireCacheImpl c = (GemFireCacheImpl)this.getCache();
        Region r = c.getRegion("localoverflow");
        CacheXml65Test.assertNotNull((Object)r);
        RegionAttributes ra = r.getAttributes();
        CacheXml65Test.assertEquals((Object)DataPolicy.NORMAL, (Object)ra.getDataPolicy());
        CacheXml65Test.assertEquals((Object)Scope.LOCAL, (Object)ra.getScope());
        CacheXml65Test.assertEquals((Object)EvictionAttributes.createLRUHeapAttributes(null, (EvictionAction)EvictionAction.OVERFLOW_TO_DISK), (Object)ra.getEvictionAttributes());
        CacheXml65Test.assertEquals((Object)Float.valueOf(80.0f), (Object)Float.valueOf(c.getResourceManager().getEvictionHeapPercentage()));
    }

    public void testLOCAL_PERSISTENT_OVERFLOW() throws CacheException {
        CacheCreation cache = new CacheCreation();
        RegionCreation root = (RegionCreation)cache.createRegion("cpolocal", "LOCAL_PERSISTENT_OVERFLOW");
        this.testXml(cache);
        GemFireCacheImpl c = (GemFireCacheImpl)this.getCache();
        Region r = c.getRegion("cpolocal");
        CacheXml65Test.assertNotNull((Object)r);
        RegionAttributes ra = r.getAttributes();
        CacheXml65Test.assertEquals((Object)DataPolicy.PERSISTENT_REPLICATE, (Object)ra.getDataPolicy());
        CacheXml65Test.assertEquals((Object)Scope.LOCAL, (Object)ra.getScope());
        CacheXml65Test.assertEquals((Object)EvictionAttributes.createLRUHeapAttributes(null, (EvictionAction)EvictionAction.OVERFLOW_TO_DISK), (Object)ra.getEvictionAttributes());
        CacheXml65Test.assertEquals((Object)Float.valueOf(80.0f), (Object)Float.valueOf(c.getResourceManager().getEvictionHeapPercentage()));
    }

    public void testPARTITION_PROXY() throws CacheException {
        CacheCreation cache = new CacheCreation();
        RegionCreation root = (RegionCreation)cache.createRegion("partitionProxy", "PARTITION_PROXY");
        this.testXml(cache);
        GemFireCacheImpl c = (GemFireCacheImpl)this.getCache();
        Region r = c.getRegion("partitionProxy");
        CacheXml65Test.assertNotNull((Object)r);
        RegionAttributes ra = r.getAttributes();
        CacheXml65Test.assertEquals((Object)DataPolicy.PARTITION, (Object)ra.getDataPolicy());
        CacheXml65Test.assertNotNull((Object)ra.getPartitionAttributes());
        CacheXml65Test.assertEquals((int)0, (int)ra.getPartitionAttributes().getRedundantCopies());
        CacheXml65Test.assertEquals((int)0, (int)ra.getPartitionAttributes().getLocalMaxMemory());
    }

    public void testPARTITION_PROXY_REDUNDANT() throws CacheException {
        CacheCreation cache = new CacheCreation();
        RegionCreation root = (RegionCreation)cache.createRegion("rpartitionProxy", "PARTITION_PROXY_REDUNDANT");
        this.testXml(cache);
        GemFireCacheImpl c = (GemFireCacheImpl)this.getCache();
        Region r = c.getRegion("rpartitionProxy");
        CacheXml65Test.assertNotNull((Object)r);
        RegionAttributes ra = r.getAttributes();
        CacheXml65Test.assertEquals((Object)DataPolicy.PARTITION, (Object)ra.getDataPolicy());
        CacheXml65Test.assertNotNull((Object)ra.getPartitionAttributes());
        CacheXml65Test.assertEquals((int)1, (int)ra.getPartitionAttributes().getRedundantCopies());
        CacheXml65Test.assertEquals((int)0, (int)ra.getPartitionAttributes().getLocalMaxMemory());
    }

    public void testREPLICATE_PROXY() throws CacheException {
        CacheCreation cache = new CacheCreation();
        RegionCreation root = (RegionCreation)cache.createRegion("replicateProxy", "REPLICATE_PROXY");
        this.testXml(cache);
        GemFireCacheImpl c = (GemFireCacheImpl)this.getCache();
        Region r = c.getRegion("replicateProxy");
        CacheXml65Test.assertNotNull((Object)r);
        RegionAttributes ra = r.getAttributes();
        CacheXml65Test.assertEquals((Object)DataPolicy.EMPTY, (Object)ra.getDataPolicy());
        CacheXml65Test.assertEquals((Object)Scope.DISTRIBUTED_ACK, (Object)ra.getScope());
    }

    public void testPROXY() throws CacheException {
        ClientCacheCreation cache = new ClientCacheCreation();
        RegionCreation root = (RegionCreation)cache.createRegion("proxy", "PROXY");
        this.testXml((CacheCreation)cache);
        GemFireCacheImpl c = (GemFireCacheImpl)this.getCache();
        CacheXml65Test.assertEquals((boolean)true, (boolean)c.isClient());
        Region r = c.getRegion("proxy");
        CacheXml65Test.assertNotNull((Object)r);
        RegionAttributes ra = r.getAttributes();
        CacheXml65Test.assertEquals((Object)DataPolicy.EMPTY, (Object)ra.getDataPolicy());
        CacheXml65Test.assertEquals((Object)Scope.LOCAL, (Object)ra.getScope());
        CacheXml65Test.assertEquals((String)"DEFAULT", (String)ra.getPoolName());
    }

    public void testCACHING_PROXY() throws CacheException {
        ClientCacheCreation cache = new ClientCacheCreation();
        RegionCreation root = (RegionCreation)cache.createRegion("cproxy", "CACHING_PROXY");
        this.testXml((CacheCreation)cache);
        GemFireCacheImpl c = (GemFireCacheImpl)this.getCache();
        CacheXml65Test.assertEquals((boolean)true, (boolean)c.isClient());
        Region r = c.getRegion("cproxy");
        CacheXml65Test.assertNotNull((Object)r);
        RegionAttributes ra = r.getAttributes();
        CacheXml65Test.assertEquals((Object)DataPolicy.NORMAL, (Object)ra.getDataPolicy());
        CacheXml65Test.assertEquals((Object)Scope.LOCAL, (Object)ra.getScope());
        CacheXml65Test.assertEquals((String)"DEFAULT", (String)ra.getPoolName());
    }

    public void testCACHING_PROXY_HEAP_LRU() throws CacheException {
        ClientCacheCreation cache = new ClientCacheCreation();
        RegionCreation root = (RegionCreation)cache.createRegion("cproxylru", "CACHING_PROXY_HEAP_LRU");
        this.testXml((CacheCreation)cache);
        GemFireCacheImpl c = (GemFireCacheImpl)this.getCache();
        CacheXml65Test.assertEquals((boolean)true, (boolean)c.isClient());
        Region r = c.getRegion("cproxylru");
        CacheXml65Test.assertNotNull((Object)r);
        RegionAttributes ra = r.getAttributes();
        CacheXml65Test.assertEquals((Object)DataPolicy.NORMAL, (Object)ra.getDataPolicy());
        CacheXml65Test.assertEquals((Object)Scope.LOCAL, (Object)ra.getScope());
        CacheXml65Test.assertEquals((String)"DEFAULT", (String)ra.getPoolName());
        CacheXml65Test.assertEquals((Object)EvictionAttributes.createLRUHeapAttributes(), (Object)ra.getEvictionAttributes());
        CacheXml65Test.assertEquals((Object)Float.valueOf(80.0f), (Object)Float.valueOf(c.getResourceManager().getEvictionHeapPercentage()));
    }

    public void testCACHING_PROXY_OVERFLOW() throws CacheException {
        ClientCacheCreation cache = new ClientCacheCreation();
        RegionCreation root = (RegionCreation)cache.createRegion("cproxyoverflow", "CACHING_PROXY_OVERFLOW");
        this.testXml((CacheCreation)cache);
        GemFireCacheImpl c = (GemFireCacheImpl)this.getCache();
        CacheXml65Test.assertEquals((boolean)true, (boolean)c.isClient());
        Region r = c.getRegion("cproxyoverflow");
        CacheXml65Test.assertNotNull((Object)r);
        RegionAttributes ra = r.getAttributes();
        CacheXml65Test.assertEquals((Object)DataPolicy.NORMAL, (Object)ra.getDataPolicy());
        CacheXml65Test.assertEquals((Object)Scope.LOCAL, (Object)ra.getScope());
        CacheXml65Test.assertEquals((String)"DEFAULT", (String)ra.getPoolName());
        CacheXml65Test.assertEquals((Object)EvictionAttributes.createLRUHeapAttributes(null, (EvictionAction)EvictionAction.OVERFLOW_TO_DISK), (Object)ra.getEvictionAttributes());
        CacheXml65Test.assertEquals((Object)Float.valueOf(80.0f), (Object)Float.valueOf(c.getResourceManager().getEvictionHeapPercentage()));
    }

    public void testClientLOCAL() throws CacheException {
        ClientCacheCreation cache = new ClientCacheCreation();
        RegionCreation root = (RegionCreation)cache.createRegion("local", "LOCAL");
        this.testXml((CacheCreation)cache);
        GemFireCacheImpl c = (GemFireCacheImpl)this.getCache();
        CacheXml65Test.assertEquals((boolean)true, (boolean)c.isClient());
        Region r = c.getRegion("local");
        CacheXml65Test.assertNotNull((Object)r);
        RegionAttributes ra = r.getAttributes();
        CacheXml65Test.assertEquals((Object)DataPolicy.NORMAL, (Object)ra.getDataPolicy());
        CacheXml65Test.assertEquals((Object)Scope.LOCAL, (Object)ra.getScope());
        CacheXml65Test.assertEquals(null, (String)ra.getPoolName());
    }

    public void testClientLOCAL_HEAP_LRU() throws CacheException {
        ClientCacheCreation cache = new ClientCacheCreation();
        RegionCreation root = (RegionCreation)cache.createRegion("locallru", "LOCAL_HEAP_LRU");
        this.testXml((CacheCreation)cache);
        GemFireCacheImpl c = (GemFireCacheImpl)this.getCache();
        CacheXml65Test.assertEquals((boolean)true, (boolean)c.isClient());
        Region r = c.getRegion("locallru");
        CacheXml65Test.assertNotNull((Object)r);
        RegionAttributes ra = r.getAttributes();
        CacheXml65Test.assertEquals((Object)DataPolicy.NORMAL, (Object)ra.getDataPolicy());
        CacheXml65Test.assertEquals((Object)Scope.LOCAL, (Object)ra.getScope());
        CacheXml65Test.assertEquals(null, (String)ra.getPoolName());
        CacheXml65Test.assertEquals((Object)EvictionAttributes.createLRUHeapAttributes(), (Object)ra.getEvictionAttributes());
        CacheXml65Test.assertEquals((Object)Float.valueOf(80.0f), (Object)Float.valueOf(c.getResourceManager().getEvictionHeapPercentage()));
    }

    public void testClientLOCAL_OVERFLOW() throws CacheException {
        ClientCacheCreation cache = new ClientCacheCreation();
        RegionCreation root = (RegionCreation)cache.createRegion("localoverflow", "LOCAL_OVERFLOW");
        this.testXml((CacheCreation)cache);
        GemFireCacheImpl c = (GemFireCacheImpl)this.getCache();
        CacheXml65Test.assertEquals((boolean)true, (boolean)c.isClient());
        Region r = c.getRegion("localoverflow");
        CacheXml65Test.assertNotNull((Object)r);
        RegionAttributes ra = r.getAttributes();
        CacheXml65Test.assertEquals((Object)DataPolicy.NORMAL, (Object)ra.getDataPolicy());
        CacheXml65Test.assertEquals((Object)Scope.LOCAL, (Object)ra.getScope());
        CacheXml65Test.assertEquals(null, (String)ra.getPoolName());
        CacheXml65Test.assertEquals((Object)EvictionAttributes.createLRUHeapAttributes(null, (EvictionAction)EvictionAction.OVERFLOW_TO_DISK), (Object)ra.getEvictionAttributes());
        CacheXml65Test.assertEquals((Object)Float.valueOf(80.0f), (Object)Float.valueOf(c.getResourceManager().getEvictionHeapPercentage()));
    }

    public void testClientLOCAL_PERSISTENT() throws CacheException {
        ClientCacheCreation cache = new ClientCacheCreation();
        RegionCreation root = (RegionCreation)cache.createRegion("cplocal", "LOCAL_PERSISTENT");
        this.testXml((CacheCreation)cache);
        GemFireCacheImpl c = (GemFireCacheImpl)this.getCache();
        CacheXml65Test.assertEquals((boolean)true, (boolean)c.isClient());
        Region r = c.getRegion("cplocal");
        CacheXml65Test.assertNotNull((Object)r);
        RegionAttributes ra = r.getAttributes();
        CacheXml65Test.assertEquals((Object)DataPolicy.PERSISTENT_REPLICATE, (Object)ra.getDataPolicy());
        CacheXml65Test.assertEquals((Object)Scope.LOCAL, (Object)ra.getScope());
        CacheXml65Test.assertEquals(null, (String)ra.getPoolName());
    }

    public void testClientLOCAL_PERSISTENT_OVERFLOW() throws CacheException {
        ClientCacheCreation cache = new ClientCacheCreation();
        RegionCreation root = (RegionCreation)cache.createRegion("cpolocal", "LOCAL_PERSISTENT_OVERFLOW");
        this.testXml((CacheCreation)cache);
        GemFireCacheImpl c = (GemFireCacheImpl)this.getCache();
        CacheXml65Test.assertEquals((boolean)true, (boolean)c.isClient());
        Region r = c.getRegion("cpolocal");
        CacheXml65Test.assertNotNull((Object)r);
        RegionAttributes ra = r.getAttributes();
        CacheXml65Test.assertEquals((Object)DataPolicy.PERSISTENT_REPLICATE, (Object)ra.getDataPolicy());
        CacheXml65Test.assertEquals((Object)Scope.LOCAL, (Object)ra.getScope());
        CacheXml65Test.assertEquals(null, (String)ra.getPoolName());
        CacheXml65Test.assertEquals((Object)EvictionAttributes.createLRUHeapAttributes(null, (EvictionAction)EvictionAction.OVERFLOW_TO_DISK), (Object)ra.getEvictionAttributes());
        CacheXml65Test.assertEquals((Object)Float.valueOf(80.0f), (Object)Float.valueOf(c.getResourceManager().getEvictionHeapPercentage()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        String tmp_alias1 = "unset";
        String tmp_alias2 = "unset";
        try {
            tmp_alias1 = CacheXml65Test.getServerHostName(Host.getHost(0));
            InetSocketAddress addr = CacheXml65Test.createINSA(tmp_alias1, 10000);
            tmp_alias2 = addr.getHostName();
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        finally {
            ALIAS1 = tmp_alias1;
            ALIAS2 = tmp_alias2;
        }
    }
}

