/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache30;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.CacheTransactionManager;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.TransactionEvent;
import com.gemstone.gemfire.cache.TransactionListener;
import com.gemstone.gemfire.cache.util.CacheListenerAdapter;
import com.gemstone.gemfire.cache.util.TransactionListenerAdapter;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.cache.TXManagerImpl;
import dunit.Host;
import dunit.SerializableCallable;
import dunit.VM;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import junit.framework.TestCase;

public class CallbackArgDUnitTest
extends CacheTestCase {
    protected volatile transient int invokeCount;
    protected static String callbackArg;
    List expectedKeys;
    int clCount = 0;

    public CallbackArgDUnitTest(String name) {
        super(name);
    }

    private VM getOtherVm() {
        Host host = Host.getHost(0);
        return host.getVM(0);
    }

    private void initOtherId() {
        VM vm = this.getOtherVm();
        vm.invoke(new CacheSerializableRunnable("Connect"){

            @Override
            public void run2() throws CacheException {
                CallbackArgDUnitTest.this.getCache();
            }
        });
        vm.invoke(CallbackArgDUnitTest.class, "getVMDistributedMember");
    }

    private void doCommitOtherVm() {
        VM vm = this.getOtherVm();
        vm.invoke(new CacheSerializableRunnable("create root"){

            @Override
            public void run2() throws CacheException {
                AttributesFactory af = new AttributesFactory();
                CacheListenerAdapter cl1 = new CacheListenerAdapter(){

                    public void afterCreate(EntryEvent e) {
                        TestCase.assertEquals((Object)callbackArg, (Object)e.getCallbackArgument());
                    }
                };
                af.addCacheListener((CacheListener)cl1);
                af.setScope(Scope.DISTRIBUTED_ACK);
                Region r1 = CallbackArgDUnitTest.this.createRootRegion("r1", af.create());
                Region r2 = r1.createSubregion("r2", af.create());
                Region r3 = r2.createSubregion("r3", af.create());
                TXManagerImpl ctm = (TXManagerImpl)CallbackArgDUnitTest.this.getCache().getCacheTransactionManager();
                TransactionListenerAdapter tl1 = new TransactionListenerAdapter(){

                    public void afterCommit(TransactionEvent e) {
                        TestCase.assertEquals((int)6, (int)e.getEvents().size());
                        for (EntryEvent ee : e.getEvents()) {
                            TestCase.assertEquals((Object)callbackArg, (Object)ee.getCallbackArgument());
                            TestCase.assertEquals((boolean)true, (boolean)ee.isCallbackArgumentAvailable());
                        }
                    }
                };
                ctm.addListener((TransactionListener)tl1);
                ctm.begin();
                r2.put((Object)"b", (Object)"value1", (Object)callbackArg);
                r3.put((Object)"c", (Object)"value2", (Object)callbackArg);
                r1.put((Object)"a", (Object)"value3", (Object)callbackArg);
                r1.put((Object)"a2", (Object)"value4", (Object)callbackArg);
                r3.put((Object)"c2", (Object)"value5", (Object)callbackArg);
                r2.put((Object)"b2", (Object)"value6", (Object)callbackArg);
                ctm.commit();
                TXManagerImpl.waitForPendingCommitForTest();
            }
        });
    }

    public static DistributedMember getVMDistributedMember() {
        return InternalDistributedSystem.getAnyInstance().getDistributedMember();
    }

    Object getCurrentExpectedKey() {
        Object result = this.expectedKeys.get(this.clCount);
        ++this.clCount;
        return result;
    }

    public void testForNA_CA() throws CacheException {
        this.doTest();
    }

    public void testForCA() throws Exception {
        callbackArg = "cbArg";
        this.getOtherVm().invoke(new SerializableCallable(){

            public Object call() throws Exception {
                callbackArg = "cbArg";
                return null;
            }
        });
        this.doTest();
    }

    private void doTest() throws CacheException {
        this.initOtherId();
        AttributesFactory af = new AttributesFactory();
        af.setDataPolicy(DataPolicy.REPLICATE);
        af.setScope(Scope.DISTRIBUTED_ACK);
        CacheListenerAdapter cl1 = new CacheListenerAdapter(){

            public void afterCreate(EntryEvent e) {
                TestCase.assertEquals((Object)CallbackArgDUnitTest.this.getCurrentExpectedKey(), (Object)e.getKey());
                TestCase.assertEquals((Object)callbackArg, (Object)e.getCallbackArgument());
                TestCase.assertEquals((boolean)true, (boolean)e.isCallbackArgumentAvailable());
            }
        };
        af.addCacheListener((CacheListener)cl1);
        Region r1 = this.createRootRegion("r1", af.create());
        Region r2 = r1.createSubregion("r2", af.create());
        r2.createSubregion("r3", af.create());
        TransactionListenerAdapter tl1 = new TransactionListenerAdapter(){

            public void afterCommit(TransactionEvent e) {
                TestCase.assertEquals((int)6, (int)e.getEvents().size());
                ArrayList<Object> keys = new ArrayList<Object>();
                for (EntryEvent ee : e.getEvents()) {
                    keys.add(ee.getKey());
                    TestCase.assertEquals((Object)callbackArg, (Object)ee.getCallbackArgument());
                    TestCase.assertEquals((boolean)true, (boolean)ee.isCallbackArgumentAvailable());
                }
                TestCase.assertEquals((Object)CallbackArgDUnitTest.this.expectedKeys, keys);
                CallbackArgDUnitTest.this.invokeCount = 1;
            }
        };
        CacheTransactionManager ctm = this.getCache().getCacheTransactionManager();
        ctm.addListener((TransactionListener)tl1);
        this.invokeCount = 0;
        this.clCount = 0;
        this.expectedKeys = Arrays.asList("b", "c", "a", "a2", "c2", "b2");
        this.doCommitOtherVm();
        CallbackArgDUnitTest.assertEquals((int)1, (int)this.invokeCount);
        CallbackArgDUnitTest.assertEquals((int)6, (int)this.clCount);
    }
}

