/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache30;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionShortcut;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.cache.DistributedRegion;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.InitialImageOperation;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.RegionMap;
import com.gemstone.gemfire.internal.cache.versions.VersionSource;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableCallable;
import dunit.SerializableRunnable;
import dunit.VM;
import junit.framework.TestCase;

public class ConcurrentLeaveDuringGIIDUnitTest
extends CacheTestCase {
    public ConcurrentLeaveDuringGIIDUnitTest(String name) {
        super(name);
    }

    public void testBug48962() throws Exception {
        VM X = Host.getHost(0).getVM(1);
        VM A = Host.getHost(0).getVM(2);
        VM B = Host.getHost(0).getVM(3);
        final String regionName = this.getUniqueName() + "_Region";
        SerializableCallable createRegionXB = new SerializableCallable("create region in X and B"){

            public Object call() {
                Region r = ConcurrentLeaveDuringGIIDUnitTest.this.getCache().createRegionFactory(RegionShortcut.REPLICATE).create(regionName);
                DistributedMember result = null;
                if (VM.getCurrentVMNum() == 1) {
                    r.put((Object)"keyFromX", (Object)"valueFromX");
                    result = ConcurrentLeaveDuringGIIDUnitTest.this.getCache().getDistributedSystem().getDistributedMember();
                    r.getCache().getDistributedSystem().disconnect();
                } else {
                    TestCase.assertFalse((boolean)r.containsKey((Object)"keyFromX"));
                    result = ConcurrentLeaveDuringGIIDUnitTest.this.getCache().getDistributedSystem().getDistributedMember();
                }
                return result;
            }
        };
        SerializableCallable createRegionA = new SerializableCallable("create region in A"){

            public Object call() {
                final GiiCallback cb = new GiiCallback(InitialImageOperation.GIITestHookType.BeforeGetInitialImage, regionName);
                InitialImageOperation.setGIITestHook((InitialImageOperation.GIITestHook)cb);
                Thread t = new Thread("create region in a thread that will block before GII"){

                    @Override
                    public void run() {
                        Region r = ConcurrentLeaveDuringGIIDUnitTest.this.getCache().createRegionFactory(RegionShortcut.REPLICATE).create(regionName);
                    }
                };
                t.start();
                DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){

                    @Override
                    public boolean done() {
                        return cb.isRunning;
                    }

                    @Override
                    public String description() {
                        return "waiting for GII test hook to be invoked";
                    }
                };
                DistributedTestCase.waitForCriterion(wc, 20000L, 500L, true);
                return ConcurrentLeaveDuringGIIDUnitTest.this.getCache().getDistributedSystem().getDistributedMember();
            }
        };
        A.invoke(createRegionA);
        final InternalDistributedMember Xid = (InternalDistributedMember)X.invoke(createRegionXB);
        A.invoke(new SerializableRunnable("make sure A got keyFromX from X"){

            @Override
            public void run() {
                GemFireCacheImpl cache = (GemFireCacheImpl)ConcurrentLeaveDuringGIIDUnitTest.this.getCache();
                final RegionMap r = cache.getRegionByPathForProcessing(regionName).getRegionMap();
                DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){

                    @Override
                    public boolean done() {
                        return r.containsKey((Object)"keyFromX");
                    }

                    @Override
                    public String description() {
                        return "waiting for region " + regionName + " to contain keyFromX";
                    }
                };
                DistributedTestCase.waitForCriterion(wc, 20000L, 1000L, true);
            }
        });
        B.invoke(createRegionXB);
        A.invoke(new SerializableRunnable("allow A to continue GII from B"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                GiiCallback cb = (GiiCallback)InitialImageOperation.getGIITestHookForCheckingPurpose((InitialImageOperation.GIITestHookType)InitialImageOperation.GIITestHookType.BeforeGetInitialImage);
                Object object = cb.lockObject;
                synchronized (object) {
                    cb.lockObject.notify();
                }
                DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){

                    @Override
                    public boolean done() {
                        return ConcurrentLeaveDuringGIIDUnitTest.this.getCache().getRegion(regionName) != null;
                    }

                    @Override
                    public String description() {
                        return "waiting for region " + regionName + " to initialize";
                    }
                };
                DistributedTestCase.waitForCriterion(wc, 20000L, 1000L, true);
                DistributedRegion r = (DistributedRegion)ConcurrentLeaveDuringGIIDUnitTest.this.getCache().getRegion(regionName);
                if (!r.getVersionVector().contains((VersionSource)Xid, 1L)) {
                    DistributedTestCase.getLogWriter().info("r's version vector is " + r.getVersionVector().fullToString());
                    r.dumpBackingMap();
                }
                TestCase.assertTrue((boolean)r.containsKey((Object)"keyFromX"));
                TestCase.assertTrue((boolean)r.getVersionVector().contains((VersionSource)Xid, 1L));
            }
        });
        B.invoke(new SerializableRunnable("ensure B is now consistent"){

            @Override
            public void run() {
                final Region r = ConcurrentLeaveDuringGIIDUnitTest.this.getCache().getRegion(regionName);
                DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){

                    @Override
                    public boolean done() {
                        return r.containsKey((Object)"keyFromX");
                    }

                    @Override
                    public String description() {
                        return "waiting for region " + regionName + " to contain keyFromX";
                    }
                };
                DistributedTestCase.waitForCriterion(wc, 20000L, 500L, true);
                TestCase.assertTrue((boolean)((LocalRegion)r).getVersionVector().contains((VersionSource)Xid, 1L));
            }
        });
    }

    private class GiiCallback
    extends InitialImageOperation.GIITestHook {
        private Object lockObject;

        public GiiCallback(InitialImageOperation.GIITestHookType type, String region_name) {
            super(type, region_name);
            this.lockObject = new Object();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reset() {
            Object object = this.lockObject;
            synchronized (object) {
                this.lockObject.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object = this.lockObject;
            synchronized (object) {
                try {
                    this.isRunning = true;
                    this.lockObject.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }
}

