/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache30;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.CacheLoader;
import com.gemstone.gemfire.cache.CacheLoaderException;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.DiskStore;
import com.gemstone.gemfire.cache.DiskStoreFactory;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.cache.EvictionAction;
import com.gemstone.gemfire.cache.EvictionAttributes;
import com.gemstone.gemfire.cache.LoaderHelper;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionFactory;
import com.gemstone.gemfire.cache.RegionShortcut;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.cache30.TestCacheListener;
import com.gemstone.gemfire.internal.cache.CachedDeserializable;
import com.gemstone.gemfire.internal.cache.CachedDeserializableFactory;
import com.gemstone.gemfire.internal.cache.DiskRegion;
import com.gemstone.gemfire.internal.cache.DiskRegionStats;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.lru.LRUStatistics;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableCallable;
import dunit.VM;
import hydra.ProcessMgr;
import java.io.File;
import java.lang.reflect.Array;
import java.util.BitSet;
import java.util.Collection;
import java.util.Set;
import junit.framework.TestCase;

public class DiskRegionTest
extends CacheTestCase {
    public DiskRegionTest(String name) {
        super(name);
    }

    protected LRUStatistics getLRUStats(Region region) {
        LocalRegion l = (LocalRegion)region;
        return l.getEvictionController().getLRUHelper().getStats();
    }

    public void testDiskRegionOverflow() throws Exception {
        String name = this.getUniqueName();
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.LOCAL);
        factory.setEvictionAttributes(EvictionAttributes.createLRUEntryAttributes((int)100, (EvictionAction)EvictionAction.OVERFLOW_TO_DISK));
        File d = new File("DiskRegions" + ProcessMgr.getProcessId());
        d.mkdirs();
        DiskStoreFactory dsf = this.getCache().createDiskStoreFactory();
        dsf.setDiskDirs(new File[]{d});
        factory.setDiskSynchronous(true);
        DiskStore ds = dsf.create(name);
        factory.setDiskStoreName(ds.getName());
        Region region = this.createRegion(name, factory.create());
        DiskRegion dr = ((LocalRegion)region).getDiskRegion();
        DiskRegionTest.assertNotNull((Object)dr);
        DiskRegionStats diskStats = dr.getStats();
        LRUStatistics lruStats = this.getLRUStats(region);
        DiskRegionTest.assertNotNull((Object)diskStats);
        DiskRegionTest.assertNotNull((Object)lruStats);
        DiskRegionTest.flush(region);
        DiskRegionTest.assertEquals((long)0L, (long)diskStats.getWrites());
        DiskRegionTest.assertEquals((long)0L, (long)diskStats.getReads());
        DiskRegionTest.assertEquals((long)0L, (long)lruStats.getEvictions());
        int total = 0;
        while (lruStats.getEvictions() <= 0L) {
            int[] array = new int[250];
            array[0] = total;
            region.put((Object)new Integer(total), (Object)array);
            ++total;
        }
        DiskRegionTest.flush(region);
        DiskRegionTest.getLogWriter().info("DEBUG: writes=" + diskStats.getWrites() + " reads=" + diskStats.getReads() + " evictions=" + lruStats.getEvictions() + " total=" + total + " numEntriesInVM=" + diskStats.getNumEntriesInVM() + " numOverflows=" + diskStats.getNumOverflowOnDisk());
        DiskRegionTest.assertEquals((long)1L, (long)diskStats.getWrites());
        DiskRegionTest.assertEquals((long)0L, (long)diskStats.getReads());
        DiskRegionTest.assertEquals((long)1L, (long)lruStats.getEvictions());
        DiskRegionTest.assertEquals((long)1L, (long)diskStats.getNumOverflowOnDisk());
        DiskRegionTest.assertEquals((long)(total - 1), (long)diskStats.getNumEntriesInVM());
        Object value = region.get((Object)new Integer(0));
        DiskRegionTest.flush(region);
        DiskRegionTest.assertNotNull((Object)value);
        DiskRegionTest.assertEquals((int)0, (int)((int[])value)[0]);
        DiskRegionTest.getLogWriter().info("DEBUG: writes=" + diskStats.getWrites() + " reads=" + diskStats.getReads() + " evictions=" + lruStats.getEvictions() + " total=" + total + " numEntriesInVM=" + diskStats.getNumEntriesInVM() + " numOverflows=" + diskStats.getNumOverflowOnDisk());
        DiskRegionTest.assertEquals((long)2L, (long)diskStats.getWrites());
        DiskRegionTest.assertEquals((long)1L, (long)diskStats.getReads());
        DiskRegionTest.assertEquals((long)2L, (long)lruStats.getEvictions());
        for (int i = 0; i < total; ++i) {
            int[] array = (int[])region.get((Object)new Integer(i));
            DiskRegionTest.assertNotNull((Object)array);
            DiskRegionTest.assertEquals((int)i, (int)array[0]);
        }
    }

    public void testRemoteUpdates() throws Exception {
        final String name = this.getUniqueName();
        CacheSerializableRunnable create = new CacheSerializableRunnable("Create region"){

            @Override
            public void run2() throws CacheException {
                AttributesFactory factory = new AttributesFactory();
                factory.setScope(Scope.DISTRIBUTED_NO_ACK);
                factory.setEvictionAttributes(EvictionAttributes.createLRUMemoryAttributes((int)2, null, (EvictionAction)EvictionAction.OVERFLOW_TO_DISK));
                File d = new File("DiskRegions" + ProcessMgr.getProcessId());
                d.mkdirs();
                DiskStoreFactory dsf = DiskRegionTest.this.getCache().createDiskStoreFactory();
                dsf.setDiskDirs(new File[]{d});
                DiskStore ds = dsf.create(name);
                factory.setDiskStoreName(ds.getName());
                DiskRegionTest.this.createRegion(name, factory.create());
            }
        };
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        vm0.invoke(create);
        vm1.invoke(create);
        vm0.invoke(new CacheSerializableRunnable("Fill Region"){

            @Override
            public void run2() throws CacheException {
                LocalRegion region = (LocalRegion)DiskRegionTest.this.getRootRegion().getSubregion(name);
                LRUStatistics lruStats = DiskRegionTest.this.getLRUStats((Region)region);
                int i = 0;
                while (lruStats.getEvictions() <= 0L) {
                    region.put((Object)new Integer(i), (Object)new short[250]);
                    ++i;
                }
                TestCase.assertTrue((i > 5 ? 1 : 0) != 0);
            }
        });
        vm1.invoke(new CacheSerializableRunnable("Update Region"){

            @Override
            public void run2() throws CacheException {
                LocalRegion region = (LocalRegion)DiskRegionTest.this.getRootRegion().getSubregion(name);
                for (int i = 0; i < 10; ++i) {
                    region.put((Object)new Integer(i), (Object)new int[250]);
                }
            }
        });
        vm0.invoke(new CacheSerializableRunnable("Verify overflow"){

            @Override
            public void run2() throws CacheException {
                LocalRegion region = (LocalRegion)DiskRegionTest.this.getRootRegion().getSubregion(name);
                final LRUStatistics lruStats = DiskRegionTest.this.getLRUStats((Region)region);
                DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

                    @Override
                    public boolean done() {
                        return lruStats.getEvictions() > 6L;
                    }

                    @Override
                    public String description() {
                        return "waiting for evictions to exceed 6";
                    }
                };
                DistributedTestCase.waitForCriterion(ev, 5000L, 200L, true);
            }
        });
        vm0.invoke(new CacheSerializableRunnable("Populate with byte[]"){

            @Override
            public void run2() throws CacheException {
                LocalRegion region = (LocalRegion)DiskRegionTest.this.getRootRegion().getSubregion(name);
                for (int i = 0; i < 10000; ++i) {
                    region.put((Object)String.valueOf(i), (Object)String.valueOf(i).getBytes());
                }
            }
        });
        vm1.invoke(new CacheSerializableRunnable("Get with byte[]"){

            @Override
            public void run2() throws CacheException {
                LocalRegion region = (LocalRegion)DiskRegionTest.this.getRootRegion().getSubregion(name);
                for (int i = 0; i < 10000; ++i) {
                    byte[] bytes = (byte[])region.get((Object)String.valueOf(i));
                    TestCase.assertEquals((String)String.valueOf(i), (String)new String(bytes));
                }
            }
        });
    }

    public void testNoFaults() throws Exception {
        String name = this.getUniqueName();
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.LOCAL);
        factory.setEvictionAttributes(EvictionAttributes.createLRUEntryAttributes((int)100, (EvictionAction)EvictionAction.OVERFLOW_TO_DISK));
        File d = new File("DiskRegions" + ProcessMgr.getProcessId());
        d.mkdirs();
        DiskStoreFactory dsf = this.getCache().createDiskStoreFactory();
        dsf.setDiskDirs(new File[]{d});
        DiskStore ds = dsf.create(name);
        factory.setDiskStoreName(ds.getName());
        Region region = this.createRegion(name, factory.create());
        DiskRegion dr = ((LocalRegion)region).getDiskRegion();
        DiskRegionStats diskStats = dr.getStats();
        LRUStatistics lruStats = this.getLRUStats(region);
        int total = 0;
        while (lruStats.getEvictions() <= 20L) {
            int[] array = new int[250];
            array[0] = total;
            region.put((Object)new Integer(total), (Object)array);
            ++total;
        }
        DiskRegionTest.assertTrue((total > 40 ? 1 : 0) != 0);
        long firstEvictions = lruStats.getEvictions();
        long firstReads = diskStats.getReads();
        for (int i = 1; i <= 40; ++i) {
            int key = total - i;
            region.get((Object)new Integer(key));
            DiskRegionTest.assertEquals((String)("Key " + key + " caused an eviction"), (long)firstEvictions, (long)lruStats.getEvictions());
            DiskRegionTest.assertEquals((String)("Key " + key + " caused an eviction"), (long)firstReads, (long)diskStats.getReads());
        }
    }

    public void testOverflowMirror() throws Exception {
        final String name = this.getUniqueName();
        CacheSerializableRunnable create = new CacheSerializableRunnable("Create region"){

            @Override
            public void run2() throws CacheException {
                AttributesFactory factory = new AttributesFactory();
                factory.setScope(Scope.DISTRIBUTED_ACK);
                factory.setEarlyAck(false);
                factory.setEvictionAttributes(EvictionAttributes.createLRUEntryAttributes((int)100, (EvictionAction)EvictionAction.OVERFLOW_TO_DISK));
                factory.setDataPolicy(DataPolicy.REPLICATE);
                File d = new File("DiskRegions" + ProcessMgr.getProcessId());
                d.mkdirs();
                DiskStoreFactory dsf = DiskRegionTest.this.getCache().createDiskStoreFactory();
                dsf.setDiskDirs(new File[]{d});
                factory.setDiskSynchronous(true);
                DiskStore ds = dsf.create(name);
                factory.setDiskStoreName(ds.getName());
                DiskRegionTest.this.createRegion(name, factory.create());
            }
        };
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        vm0.invoke(create);
        vm1.invoke(create);
        vm0.invoke(new CacheSerializableRunnable("Fill Region"){

            @Override
            public void run2() throws CacheException {
                LocalRegion region = (LocalRegion)DiskRegionTest.this.getRootRegion().getSubregion(name);
                LRUStatistics lruStats = DiskRegionTest.this.getLRUStats((Region)region);
                int i = 0;
                while (lruStats.getEvictions() < 10L) {
                    DistributedTestCase.getLogWriter().info("Put " + i);
                    region.put((Object)new Integer(i), (Object)new byte[1]);
                    ++i;
                }
                TestCase.assertEquals((long)10L, (long)lruStats.getEvictions());
            }
        });
        vm1.invoke(new CacheSerializableRunnable("Verify overflow"){

            @Override
            public void run2() throws CacheException {
                LocalRegion region = (LocalRegion)DiskRegionTest.this.getRootRegion().getSubregion(name);
                LRUStatistics lruStats = DiskRegionTest.this.getLRUStats((Region)region);
                TestCase.assertEquals((long)10L, (long)lruStats.getEvictions());
                for (int i = 0; i < 10; ++i) {
                    region.get((Object)new Integer(i));
                    TestCase.assertEquals((String)("No eviction for " + i), (long)(11 + i), (long)lruStats.getEvictions());
                }
            }
        });
    }

    public void testDestroy() throws Exception {
        String name = this.getUniqueName();
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.LOCAL);
        factory.setEvictionAttributes(EvictionAttributes.createLRUEntryAttributes((int)100, (EvictionAction)EvictionAction.OVERFLOW_TO_DISK));
        File d = new File("DiskRegions" + ProcessMgr.getProcessId());
        d.mkdirs();
        DiskStoreFactory dsf = this.getCache().createDiskStoreFactory();
        dsf.setDiskDirs(new File[]{d});
        factory.setDiskSynchronous(true);
        DiskStore ds = dsf.create(name);
        factory.setDiskStoreName(ds.getName());
        Region region = this.createRegion(name, factory.create());
        DiskRegion dr = ((LocalRegion)region).getDiskRegion();
        DiskRegionStats diskStats = dr.getStats();
        LRUStatistics lruStats = this.getLRUStats(region);
        int total = 0;
        while (lruStats.getEvictions() < 40L) {
            region.put((Object)new Integer(total), (Object)new byte[1000]);
            ++total;
        }
        DiskRegionTest.assertEquals((long)0L, (long)diskStats.getRemoves());
        long evictions = lruStats.getEvictions();
        DiskRegionTest.getLogWriter().info("Destroying memory resident entries");
        int i = total - 1;
        while ((long)i >= evictions) {
            region.destroy((Object)new Integer(i));
            DiskRegionTest.flush(region);
            DiskRegionTest.assertEquals((long)0L, (long)diskStats.getRemoves());
            DiskRegionTest.assertEquals((long)evictions, (long)lruStats.getEvictions());
            --i;
        }
        DiskRegionTest.getLogWriter().info("Destroying disk-resident entries.  evictions=" + evictions);
        for (i = (int)evictions - 1; i >= 0; --i) {
            region.destroy((Object)new Integer(i));
            DiskRegionTest.flush(region);
            DiskRegionTest.assertEquals((long)(evictions - (long)i), (long)diskStats.getRemoves());
        }
        DiskRegionTest.assertEquals((long)evictions, (long)lruStats.getEvictions());
        DiskRegionTest.getLogWriter().info("keys remaining in region: " + region.keys().size());
        DiskRegionTest.assertEquals((int)0, (int)region.keys().size());
    }

    public void testCacheEvents() throws Exception {
        int i;
        String name = this.getUniqueName();
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.LOCAL);
        factory.setEvictionAttributes(EvictionAttributes.createLRUEntryAttributes((int)100, (EvictionAction)EvictionAction.OVERFLOW_TO_DISK));
        File d = new File("DiskRegions" + ProcessMgr.getProcessId());
        d.mkdirs();
        TestCacheListener listener = new TestCacheListener(){

            @Override
            public void afterCreate2(EntryEvent event) {
            }
        };
        factory.addCacheListener((CacheListener)listener);
        DiskStoreFactory dsf = this.getCache().createDiskStoreFactory();
        dsf.setDiskDirs(new File[]{d});
        factory.setDiskSynchronous(true);
        DiskStore ds = dsf.create(name);
        factory.setDiskStoreName(ds.getName());
        Region region = this.createRegion(name, factory.create());
        LRUStatistics lruStats = this.getLRUStats(region);
        int total = 0;
        while (lruStats.getEvictions() < 20L) {
            region.put((Object)new Integer(total), (Object)String.valueOf(total));
            DiskRegionTest.assertEquals((Object)String.valueOf(total), (Object)region.get((Object)new Integer(total)));
            ++total;
        }
        DiskRegionTest.assertTrue((boolean)listener.wasInvoked());
        listener = new TestCacheListener(){

            @Override
            public void close2() {
            }
        };
        region.getAttributesMutator().setCacheListener((CacheListener)listener);
        for (i = 0; i < total; ++i) {
            String value = (String)region.get((Object)new Integer(i));
            DiskRegionTest.assertNotNull((Object)value);
            DiskRegionTest.assertEquals((String)String.valueOf(i), (String)value);
        }
        DiskRegionTest.assertFalse((boolean)listener.wasInvoked());
        listener = new TestCacheListener(){

            @Override
            public void afterUpdate2(EntryEvent event) {
                Integer key = (Integer)event.getKey();
                TestCase.assertEquals(null, (Object)event.getOldValue());
                TestCase.assertEquals((boolean)false, (boolean)event.isOldValueAvailable());
                byte[] value = (byte[])event.getNewValue();
                TestCase.assertEquals((int)key, (int)value.length);
            }
        };
        region.getAttributesMutator().setCacheListener((CacheListener)listener);
        for (i = 0; i < 20; ++i) {
            region.put((Object)new Integer(i), (Object)new byte[i]);
        }
        DiskRegionTest.assertTrue((boolean)listener.wasInvoked());
    }

    public void fillUpOverflowRegion() throws Exception {
        String name = this.getUniqueName();
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.LOCAL);
        factory.setEvictionAttributes(EvictionAttributes.createLRUEntryAttributes((int)100, (EvictionAction)EvictionAction.OVERFLOW_TO_DISK));
        File d = new File("DiskRegions" + ProcessMgr.getProcessId());
        d.mkdirs();
        DiskStoreFactory dsf = this.getCache().createDiskStoreFactory();
        dsf.setDiskDirs(new File[]{d});
        DiskStore ds = dsf.create(name);
        factory.setDiskStoreName(ds.getName());
        Region region = this.createRegion(name, factory.create());
        for (int i = 0; i < 10000; ++i) {
            int[] array = new int[1000];
            array[0] = i;
            try {
                region.put((Object)array, (Object)new Integer(i));
                continue;
            }
            catch (IllegalStateException ex) {
                String message = ex.getMessage();
                DiskRegionTest.assertTrue((message.indexOf("is full with") != -1 ? 1 : 0) != 0);
                return;
            }
        }
        DiskRegionTest.fail((String)"Should have thrown an IllegalStateException");
    }

    public void testValues() throws Exception {
        String name = this.getUniqueName();
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.LOCAL);
        factory.setEvictionAttributes(EvictionAttributes.createLRUEntryAttributes((int)100, (EvictionAction)EvictionAction.OVERFLOW_TO_DISK));
        File d = new File("DiskRegions" + ProcessMgr.getProcessId());
        d.mkdirs();
        DiskStoreFactory dsf = this.getCache().createDiskStoreFactory();
        dsf.setDiskDirs(new File[]{d});
        DiskStore ds = dsf.create(name);
        factory.setDiskStoreName(ds.getName());
        Region region = this.createRegion(name, factory.create());
        LRUStatistics lruStats = this.getLRUStats(region);
        int total = 0;
        while (lruStats.getEvictions() <= 0L) {
            int[] array = new int[250];
            array[0] = total;
            region.put((Object)new Integer(total), (Object)array);
            ++total;
        }
        BitSet bits = new BitSet();
        Collection values = region.values();
        DiskRegionTest.assertEquals((int)total, (int)values.size());
        for (Object value : values) {
            DiskRegionTest.assertNotNull(value);
            int[] array = (int[])value;
            int i = array[0];
            DiskRegionTest.assertFalse((String)("Bit " + i + " is already set"), (boolean)bits.get(i));
            bits.set(i);
        }
    }

    public void testRegionEvictValue() throws Exception {
        int i;
        String name = this.getUniqueName() + "testRegionEvictValue";
        File d = new File("DiskRegions" + ProcessMgr.getProcessId());
        d.mkdirs();
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.LOCAL);
        factory.setDataPolicy(DataPolicy.PERSISTENT_REPLICATE);
        DiskStoreFactory dsf = this.getCache().createDiskStoreFactory();
        dsf.setDiskDirs(new File[]{d});
        DiskStore ds = dsf.create(name);
        factory.setDiskStoreName(ds.getName());
        Region region = this.createRegion(name, factory.create());
        int size = 200;
        for (i = 0; i < size; ++i) {
            region.put((Object)("Key-" + i), (Object)new Integer(i));
        }
        for (i = 0; i < size / 2; ++i) {
            if (i % 2 != 0) continue;
            ((LocalRegion)region).evictValue((Object)("Key-" + i));
        }
        for (i = 0; i < size / 2; ++i) {
            if (i % 2 != 0) continue;
            try {
                Object value = ((LocalRegion)region).getValueInVM((Object)("Key-" + i));
                if (value == null) continue;
                DiskRegionTest.fail((String)("The values should have been evicted to disk, for key: Key-" + i));
                continue;
            }
            catch (EntryNotFoundException e) {
                DiskRegionTest.fail((String)"Entry not found not expected but occured ");
            }
        }
    }

    public void testEvictValueOnRegionWithEvictionAttributes() throws Exception {
        int i;
        String name = this.getUniqueName() + "testRegionEvictValue";
        File d = new File("DiskRegions" + ProcessMgr.getProcessId());
        d.mkdirs();
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.LOCAL);
        factory.setDataPolicy(DataPolicy.PERSISTENT_REPLICATE);
        factory.setEvictionAttributes(EvictionAttributes.createLRUEntryAttributes((int)100, (EvictionAction)EvictionAction.OVERFLOW_TO_DISK));
        DiskStoreFactory dsf = this.getCache().createDiskStoreFactory();
        dsf.setDiskDirs(new File[]{d});
        DiskStore ds = dsf.create(name);
        factory.setDiskStoreName(ds.getName());
        Region region = this.createRegion(name, factory.create());
        int size = 200;
        for (i = 0; i < size; ++i) {
            region.put((Object)("Key-" + i), (Object)new Integer(i));
        }
        for (i = 0; i < size / 4; ++i) {
            try {
                ((LocalRegion)region).evictValue((Object)("Key-" + i));
                DiskRegionTest.fail((String)"Should have thrown exception with, evictValue not supported on region with eviction attributes.");
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void testBackupStatistics() throws CacheException {
        String name = this.getUniqueName();
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.LOCAL);
        factory.setDataPolicy(DataPolicy.PERSISTENT_REPLICATE);
        File d = new File("DiskRegions" + ProcessMgr.getProcessId());
        d.mkdirs();
        int total = 10;
        DiskStoreFactory dsf = this.getCache().createDiskStoreFactory();
        dsf.setDiskDirs(new File[]{d});
        factory.setDiskSynchronous(true);
        DiskStore ds = dsf.create(name);
        factory.setDiskStoreName(ds.getName());
        Region region = this.createRegion(name, factory.create());
        DiskRegion dr = ((LocalRegion)region).getDiskRegion();
        DiskRegionTest.assertNotNull((Object)dr);
        DiskRegionStats diskStats = dr.getStats();
        DiskRegionTest.assertEquals((long)0L, (long)diskStats.getWrites());
        DiskRegionTest.assertEquals((long)0L, (long)diskStats.getNumEntriesInVM());
        DiskRegionTest.assertEquals((long)0L, (long)diskStats.getReads());
        DiskRegionTest.assertEquals((long)0L, (long)diskStats.getNumOverflowOnDisk());
        for (int i = 0; i < 10; ++i) {
            String s = String.valueOf(i);
            region.put((Object)s, (Object)s);
            DiskRegionTest.assertEquals((long)(i + 1), (long)diskStats.getWrites());
            DiskRegionTest.assertEquals((long)(i + 1), (long)diskStats.getNumEntriesInVM());
            DiskRegionTest.assertEquals((long)0L, (long)diskStats.getReads());
            DiskRegionTest.assertEquals((long)0L, (long)diskStats.getNumOverflowOnDisk());
        }
        region.put((Object)"foobar", (Object)"junk");
        DiskRegionTest.assertEquals((long)11L, (long)diskStats.getWrites());
        DiskRegionTest.assertEquals((long)11L, (long)diskStats.getNumEntriesInVM());
        DiskRegionTest.assertEquals((long)0L, (long)diskStats.getReads());
        DiskRegionTest.assertEquals((long)0L, (long)diskStats.getNumOverflowOnDisk());
        region.localDestroy((Object)"foobar");
        DiskRegionTest.assertEquals((long)12L, (long)diskStats.getWrites());
        DiskRegionTest.assertEquals((long)10L, (long)diskStats.getNumEntriesInVM());
        DiskRegionTest.assertEquals((long)0L, (long)diskStats.getReads());
        region.put((Object)"foobar2", (Object)"junk");
        DiskRegionTest.flush(region);
        region.localDestroy((Object)"foobar2");
        DiskRegionTest.assertEquals((int)10, (int)region.keys().size());
    }

    public void assertArrayEquals(Object expected, Object v) {
        DiskRegionTest.assertEquals(expected.getClass(), v.getClass());
        int vLength = Array.getLength(v);
        DiskRegionTest.assertEquals((int)Array.getLength(expected), (int)vLength);
        for (int i = 0; i < vLength; ++i) {
            DiskRegionTest.assertEquals((Object)Array.get(expected, i), (Object)Array.get(v, i));
        }
    }

    public void testBackup() throws Exception {
        String name = this.getUniqueName();
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.LOCAL);
        factory.setEvictionAttributes(EvictionAttributes.createLRUEntryAttributes((int)100, (EvictionAction)EvictionAction.OVERFLOW_TO_DISK));
        factory.setDataPolicy(DataPolicy.PERSISTENT_REPLICATE);
        File d = new File("DiskRegions" + ProcessMgr.getProcessId());
        d.mkdirs();
        DiskStoreFactory dsf = this.getCache().createDiskStoreFactory();
        dsf.setDiskDirs(new File[]{d});
        factory.setDiskSynchronous(true);
        DiskStore ds = dsf.create(name);
        factory.setDiskStoreName(ds.getName());
        int total = 10;
        Region region = this.createRegion(name, factory.create());
        for (int i = 0; i < total; ++i) {
            String s = String.valueOf(i);
            region.put((Object)s, (Object)s);
        }
        region.put((Object)"foobar", (Object)"junk");
        region.localDestroy((Object)"foobar");
        region.put((Object)"foobar2", (Object)"junk");
        DiskRegionTest.flush(region);
        region.localDestroy((Object)"foobar2");
        region.put((Object)"invalid", (Object)"invalid");
        DiskRegionTest.flush(region);
        region.invalidate((Object)"invalid");
        DiskRegionTest.flush(region);
        DiskRegionTest.assertTrue((region.containsKey((Object)"invalid") && !region.containsValueForKey((Object)"invalid") ? 1 : 0) != 0);
        ++total;
        region.put((Object)"localinvalid", (Object)"localinvalid");
        DiskRegionTest.flush(region);
        region.localInvalidate((Object)"localinvalid");
        DiskRegionTest.flush(region);
        DiskRegionTest.assertTrue((region.containsKey((Object)"localinvalid") && !region.containsValueForKey((Object)"localinvalid") ? 1 : 0) != 0);
        ++total;
        region.put((Object)"byteArray", (Object)new byte[0]);
        DiskRegionTest.flush(region);
        this.assertArrayEquals(new byte[0], region.get((Object)"byteArray"));
        ++total;
        region.put((Object)"modified", (Object)"originalValue");
        DiskRegionTest.flush(region);
        region.put((Object)"modified", (Object)"modified");
        DiskRegionTest.flush(region);
        DiskRegionTest.assertEquals((Object)"modified", (Object)region.get((Object)"modified"));
        DiskRegionTest.assertEquals((int)(++total), (int)region.keys().size());
        DiskRegionTest.closeCache();
        this.getCache();
        dsf = this.getCache().createDiskStoreFactory();
        dsf.setDiskDirs(new File[]{d});
        dsf.create(name);
        region = this.createRegion(name, factory.create());
        DiskRegionTest.assertEquals((int)total, (int)region.keys().size());
        DiskRegionTest.assertTrue((region.containsKey((Object)"invalid") && !region.containsValueForKey((Object)"invalid") ? 1 : 0) != 0);
        region.localDestroy((Object)"invalid");
        --total;
        DiskRegionTest.assertTrue((region.containsKey((Object)"localinvalid") && !region.containsValueForKey((Object)"localinvalid") ? 1 : 0) != 0);
        region.localDestroy((Object)"localinvalid");
        --total;
        this.assertArrayEquals(new byte[0], region.get((Object)"byteArray"));
        region.localDestroy((Object)"byteArray");
        --total;
        DiskRegionTest.assertEquals((Object)"modified", (Object)region.get((Object)"modified"));
        region.localDestroy((Object)"modified");
        --total;
    }

    public void testRegionEntryValues() throws Exception {
        String name = this.getUniqueName();
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.LOCAL);
        factory.setEvictionAttributes(EvictionAttributes.createLRUEntryAttributes((int)100, (EvictionAction)EvictionAction.OVERFLOW_TO_DISK));
        File d = new File("DiskRegions" + ProcessMgr.getProcessId());
        d.mkdirs();
        DiskStoreFactory dsf = this.getCache().createDiskStoreFactory();
        dsf.setDiskDirs(new File[]{d});
        DiskStore ds = dsf.create(name);
        factory.setDiskStoreName(ds.getName());
        Region region = this.createRegion(name, factory.create());
        LRUStatistics lruStats = this.getLRUStats(region);
        int total = 0;
        while (lruStats.getEvictions() <= 0L) {
            int[] array = new int[250];
            array[0] = total;
            region.put((Object)new Integer(total), (Object)array);
            ++total;
        }
        Set values = region.entries(false);
        DiskRegionTest.assertEquals((int)total, (int)values.size());
        for (Region.Entry entry : values) {
            Integer key = (Integer)entry.getKey();
            int[] value = (int[])entry.getValue();
            DiskRegionTest.assertNotNull((Object)value);
            DiskRegionTest.assertEquals((String)("Key/value" + key), (int)key, (int)value[0]);
        }
    }

    public void testInvalidate() throws Exception {
        String name = this.getUniqueName();
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.LOCAL);
        factory.setEvictionAttributes(EvictionAttributes.createLRUEntryAttributes((int)100, (EvictionAction)EvictionAction.OVERFLOW_TO_DISK));
        File d = new File("DiskRegions" + ProcessMgr.getProcessId());
        d.mkdirs();
        DiskStoreFactory dsf = this.getCache().createDiskStoreFactory();
        dsf.setDiskDirs(new File[]{d});
        DiskStore ds = dsf.create(name);
        factory.setDiskStoreName(ds.getName());
        Region region = this.createRegion(name, factory.create());
        LRUStatistics lruStats = this.getLRUStats(region);
        int total = 0;
        while (lruStats.getEvictions() <= 10L) {
            int[] array = new int[250];
            array[0] = total;
            region.put((Object)new Integer(total), (Object)array);
            ++total;
        }
        region.invalidate((Object)new Integer(0));
        DiskRegionTest.assertNull((Object)region.get((Object)new Integer(0)));
    }

    public void testDistributedInvalidate() throws Exception {
        final String name = this.getUniqueName();
        CacheSerializableRunnable create = new CacheSerializableRunnable("Create region"){

            @Override
            public void run2() throws CacheException {
                AttributesFactory factory = new AttributesFactory();
                factory.setScope(Scope.DISTRIBUTED_ACK);
                factory.setEarlyAck(false);
                factory.setEvictionAttributes(EvictionAttributes.createLRUEntryAttributes((int)100, (EvictionAction)EvictionAction.OVERFLOW_TO_DISK));
                File d = new File("DiskRegions" + ProcessMgr.getProcessId());
                d.mkdirs();
                DiskStoreFactory dsf = DiskRegionTest.this.getCache().createDiskStoreFactory();
                dsf.setDiskDirs(new File[]{d});
                DiskStore ds = dsf.create(name);
                factory.setDiskStoreName(ds.getName());
                DiskRegionTest.this.createRegion(name, factory.create());
            }
        };
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        vm0.invoke(create);
        vm1.invoke(create);
        vm0.invoke(new CacheSerializableRunnable("Fill Region"){

            @Override
            public void run2() throws CacheException {
                LocalRegion region = (LocalRegion)DiskRegionTest.this.getRootRegion().getSubregion(name);
                LRUStatistics lruStats = DiskRegionTest.this.getLRUStats((Region)region);
                int i = 0;
                while (lruStats.getEvictions() < 10L) {
                    DistributedTestCase.getLogWriter().info("Put " + i);
                    region.put((Object)new Integer(i), (Object)new byte[1]);
                    ++i;
                }
                TestCase.assertEquals((long)10L, (long)lruStats.getEvictions());
            }
        });
        final Integer key = new Integer(20);
        vm1.invoke(new CacheSerializableRunnable("Invalidate entry"){

            @Override
            public void run2() throws CacheException {
                Region region = DiskRegionTest.this.getRootRegion().getSubregion(name);
                TestCase.assertNotNull((Object)region.get(key));
                region.invalidate(key);
            }
        });
        vm0.invoke(new CacheSerializableRunnable("Verify invalidate"){

            @Override
            public void run2() throws CacheException {
                final Region region = DiskRegionTest.this.getRootRegion().getSubregion(name);
                DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

                    @Override
                    public boolean done() {
                        return region.get(key) == null;
                    }

                    @Override
                    public String description() {
                        return "value for key remains: " + key;
                    }
                };
                DistributedTestCase.waitForCriterion(ev, 500L, 200L, true);
            }
        });
        String newValue = "NEW VALUE";
        vm1.invoke(new CacheSerializableRunnable("Update entry"){

            @Override
            public void run2() throws CacheException {
                Region region = DiskRegionTest.this.getRootRegion().getSubregion(name);
                region.put(key, (Object)"NEW VALUE");
            }
        });
        vm0.invoke(new CacheSerializableRunnable("Verify update"){

            @Override
            public void run2() throws CacheException {
                final Region region = DiskRegionTest.this.getRootRegion().getSubregion(name);
                DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

                    @Override
                    public boolean done() {
                        return "NEW VALUE".equals(region.get(key));
                    }

                    @Override
                    public String description() {
                        return "verify update";
                    }
                };
                DistributedTestCase.waitForCriterion(ev, 500L, 200L, true);
            }
        });
    }

    public void testOverflowUpdatedValue() throws Exception {
        String name = this.getUniqueName();
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.LOCAL);
        factory.setEvictionAttributes(EvictionAttributes.createLRUEntryAttributes((int)100, (EvictionAction)EvictionAction.OVERFLOW_TO_DISK));
        File d = new File("DiskRegions" + ProcessMgr.getProcessId());
        d.mkdirs();
        DiskStoreFactory dsf = this.getCache().createDiskStoreFactory();
        dsf.setDiskDirs(new File[]{d});
        DiskStore ds = dsf.create(name);
        factory.setDiskStoreName(ds.getName());
        Region region = this.createRegion(name, factory.create());
        LRUStatistics lruStats = this.getLRUStats(region);
        int total = 0;
        while (lruStats.getEvictions() <= 10L) {
            int[] array = new int[250];
            array[0] = total;
            region.put((Object)new Integer(total), (Object)array);
            ++total;
        }
        String newValue = "NEW VALUE";
        Integer key = new Integer(0);
        region.put((Object)key, (Object)newValue);
        DiskRegionTest.assertEquals((Object)newValue, (Object)region.get((Object)key));
        for (int i = 1; i < total; ++i) {
            region.get((Object)new Integer(i));
        }
        DiskRegionTest.assertEquals((Object)newValue, (Object)region.get((Object)key));
    }

    private static void flush(Region region) {
        ((LocalRegion)region).getDiskRegion().flushForTesting();
    }

    public void testTestHookStatistics() throws Exception {
        String name = this.getUniqueName();
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.LOCAL);
        factory.setEvictionAttributes(EvictionAttributes.createLRUEntryAttributes((int)100, (EvictionAction)EvictionAction.OVERFLOW_TO_DISK));
        DiskStoreFactory dsf = this.getCache().createDiskStoreFactory();
        factory.setDiskSynchronous(true);
        File d = new File("DiskRegions" + ProcessMgr.getProcessId());
        d.mkdirs();
        dsf.setDiskDirs(new File[]{d});
        DiskStore ds = dsf.create(name);
        factory.setDiskStoreName(ds.getName());
        LocalRegion region = (LocalRegion)this.createRegion(name, factory.create());
        DiskRegion dr = region.getDiskRegion();
        DiskRegionStats diskStats = dr.getStats();
        LRUStatistics lruStats = this.getLRUStats((Region)region);
        int total = 0;
        while (lruStats.getEvictions() <= 0L) {
            int[] array = new int[]{total};
            region.put((Object)new Integer(total), (Object)array);
            if (lruStats.getEvictions() <= 0L) {
                DiskRegionTest.assertEquals((long)(total + 1), (long)diskStats.getNumEntriesInVM());
            }
            ++total;
        }
        DiskRegionTest.assertEquals((long)1L, (long)diskStats.getNumOverflowOnDisk());
        region.get((Object)new Integer(0));
        DiskRegionTest.assertEquals((long)region.entryCount(), (long)(diskStats.getNumEntriesInVM() + diskStats.getNumOverflowOnDisk()));
        DiskRegionTest.assertEquals((long)(total - 1), (long)diskStats.getNumEntriesInVM());
        DiskRegionTest.assertEquals((long)1L, (long)diskStats.getNumOverflowOnDisk());
        region.put((Object)new Integer(total + 10), (Object)new int[1]);
        region.put((Object)new Integer(total + 11), (Object)new int[1]);
        region.put((Object)new Integer(total + 12), (Object)new int[1]);
        region.put((Object)new Integer(total + 13), (Object)new int[1]);
        DiskRegionTest.assertEquals((long)region.entryCount(), (long)(diskStats.getNumEntriesInVM() + diskStats.getNumOverflowOnDisk()));
        DiskRegionTest.assertEquals((long)(total - 1), (long)diskStats.getNumEntriesInVM());
        DiskRegionTest.assertEquals((long)5L, (long)diskStats.getNumOverflowOnDisk());
        region.invalidate((Object)new Integer(total + 10));
        DiskRegionTest.assertEquals((long)region.entryCount(), (long)(diskStats.getNumEntriesInVM() + diskStats.getNumOverflowOnDisk()));
        DiskRegionTest.assertEquals((long)(total - 1), (long)diskStats.getNumEntriesInVM());
        DiskRegionTest.assertEquals((long)5L, (long)diskStats.getNumOverflowOnDisk());
        region.localInvalidate((Object)new Integer(total + 11));
        DiskRegionTest.assertEquals((long)region.entryCount(), (long)(diskStats.getNumEntriesInVM() + diskStats.getNumOverflowOnDisk()));
        DiskRegionTest.assertEquals((long)(total - 1), (long)diskStats.getNumEntriesInVM());
        DiskRegionTest.assertEquals((long)5L, (long)diskStats.getNumOverflowOnDisk());
        region.destroy((Object)new Integer(total + 10));
        region.dumpBackingMap();
        DiskRegionTest.assertEquals((long)region.entryCount(), (long)(diskStats.getNumEntriesInVM() + diskStats.getNumOverflowOnDisk()));
        DiskRegionTest.assertEquals((long)(total - 2), (long)diskStats.getNumEntriesInVM());
        DiskRegionTest.assertEquals((long)5L, (long)diskStats.getNumOverflowOnDisk());
        region.destroy((Object)new Integer(3));
        DiskRegionTest.assertEquals((long)region.entryCount(), (long)(diskStats.getNumEntriesInVM() + diskStats.getNumOverflowOnDisk()));
        DiskRegionTest.assertEquals((long)(total - 2), (long)diskStats.getNumEntriesInVM());
        DiskRegionTest.assertEquals((long)4L, (long)diskStats.getNumOverflowOnDisk());
    }

    public void testLowLevelGetMethods() throws Exception {
        String name = this.getUniqueName();
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.LOCAL);
        factory.setEvictionAttributes(EvictionAttributes.createLRUEntryAttributes((int)100, (EvictionAction)EvictionAction.OVERFLOW_TO_DISK));
        DiskStoreFactory dsf = this.getCache().createDiskStoreFactory();
        factory.setDiskSynchronous(true);
        File d = new File("DiskRegions" + ProcessMgr.getProcessId());
        d.mkdirs();
        dsf.setDiskDirs(new File[]{d});
        DiskStore ds = dsf.create(name);
        factory.setDiskStoreName(ds.getName());
        LocalRegion region = (LocalRegion)this.createRegion(name, factory.create());
        LRUStatistics lruStats = this.getLRUStats((Region)region);
        int total = 0;
        while (lruStats.getEvictions() <= 2L) {
            int[] array = new int[250];
            array[0] = total;
            Integer key = new Integer(total);
            region.put((Object)key, (Object)array);
            array = (int[])region.getValueInVM((Object)key);
            DiskRegionTest.assertNotNull((Object)array);
            DiskRegionTest.assertEquals((int)total, (int)array[0]);
            DiskRegionTest.assertNull((Object)region.getValueOnDisk((Object)key));
            ++total;
        }
        Integer key = new Integer(1);
        DiskRegionTest.assertNull((Object)region.getValueInVM((Object)key));
        int[] array = (int[])region.getValueOnDisk((Object)key);
        DiskRegionTest.assertNotNull((Object)array);
        DiskRegionTest.assertEquals((int)1, (int)array[0]);
        region.get((Object)key);
        if (CachedDeserializableFactory.preferObject()) {
            array = (int[])region.getValueInVM((Object)key);
        } else {
            CachedDeserializable cd = (CachedDeserializable)region.getValueInVM((Object)key);
            array = (int[])cd.getValue();
        }
        DiskRegionTest.assertNotNull((Object)array);
        DiskRegionTest.assertEquals((int)1, (int)array[0]);
        array = (int[])region.getValueOnDisk((Object)key);
        DiskRegionTest.assertNotNull((Object)array);
        DiskRegionTest.assertEquals((int)1, (int)array[0]);
    }

    public void testLRUCapacityController() throws CacheException {
        String name = this.getUniqueName();
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.LOCAL);
        factory.setEvictionAttributes(EvictionAttributes.createLRUEntryAttributes((int)1000, (EvictionAction)EvictionAction.OVERFLOW_TO_DISK));
        DiskStoreFactory dsf = this.getCache().createDiskStoreFactory();
        factory.setDiskSynchronous(true);
        File d = new File("DiskRegions" + ProcessMgr.getProcessId());
        d.mkdirs();
        dsf.setDiskDirs(new File[]{d});
        DiskStore ds = dsf.create(name);
        factory.setDiskStoreName(ds.getName());
        Region region = this.createRegion(name, factory.create());
        DiskRegion dr = ((LocalRegion)region).getDiskRegion();
        DiskRegionStats diskStats = dr.getStats();
        LRUStatistics lruStats = this.getLRUStats(region);
        DiskRegionTest.flush(region);
        DiskRegionTest.assertEquals((long)0L, (long)diskStats.getWrites());
        DiskRegionTest.assertEquals((long)0L, (long)diskStats.getReads());
        DiskRegionTest.assertEquals((long)0L, (long)lruStats.getEvictions());
        for (int i = 1; i <= 1000; ++i) {
            Integer key = new Integer(i);
            String value = String.valueOf(i);
            region.put((Object)key, (Object)value);
            DiskRegionTest.assertEquals((long)i, (long)lruStats.getCounter());
            DiskRegionTest.assertEquals((long)0L, (long)lruStats.getEvictions());
            DiskRegionTest.assertEquals((String)("On iteration " + i), (long)0L, (long)diskStats.getWrites());
            DiskRegionTest.assertEquals((long)0L, (long)diskStats.getReads());
            DiskRegionTest.assertEquals((long)0L, (long)diskStats.getNumOverflowOnDisk());
        }
        DiskRegionTest.assertEquals((long)0L, (long)diskStats.getWrites());
        DiskRegionTest.assertEquals((long)0L, (long)diskStats.getReads());
        DiskRegionTest.assertEquals((long)0L, (long)diskStats.getNumOverflowOnDisk());
        region.put((Object)new Integer(1001), (Object)String.valueOf(1001));
        DiskRegionTest.assertEquals((long)1000L, (long)lruStats.getCounter());
        DiskRegionTest.assertEquals((long)1L, (long)lruStats.getEvictions());
        DiskRegionTest.assertEquals((long)1L, (long)diskStats.getWrites());
        DiskRegionTest.assertEquals((long)0L, (long)diskStats.getReads());
        DiskRegionTest.assertEquals((long)1L, (long)diskStats.getNumOverflowOnDisk());
        DiskRegionTest.assertEquals((long)1000L, (long)diskStats.getNumEntriesInVM());
        region.put((Object)new Integer(1002), (Object)String.valueOf(1002));
        DiskRegionTest.assertEquals((long)1000L, (long)lruStats.getCounter());
        DiskRegionTest.assertEquals((long)2L, (long)lruStats.getEvictions());
        DiskRegionTest.assertEquals((long)2L, (long)diskStats.getWrites());
        DiskRegionTest.assertEquals((long)0L, (long)diskStats.getReads());
        DiskRegionTest.assertEquals((long)2L, (long)diskStats.getNumOverflowOnDisk());
        DiskRegionTest.assertEquals((long)1000L, (long)diskStats.getNumEntriesInVM());
        region.put((Object)new Integer(1000), (Object)String.valueOf(1000));
        DiskRegionTest.assertEquals((long)1000L, (long)lruStats.getCounter());
        DiskRegionTest.assertEquals((long)2L, (long)lruStats.getEvictions());
        DiskRegionTest.assertEquals((long)2L, (long)diskStats.getWrites());
        DiskRegionTest.assertEquals((long)0L, (long)diskStats.getReads());
        DiskRegionTest.assertEquals((long)2L, (long)diskStats.getNumOverflowOnDisk());
        DiskRegionTest.assertEquals((long)1000L, (long)diskStats.getNumEntriesInVM());
    }

    public void testLRUCCSizeOne() throws CacheException {
        String value;
        Integer key;
        int i;
        int threshold = 1;
        String name = this.getUniqueName();
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.LOCAL);
        factory.setEvictionAttributes(EvictionAttributes.createLRUEntryAttributes((int)threshold, (EvictionAction)EvictionAction.OVERFLOW_TO_DISK));
        factory.setCacheLoader(new CacheLoader(){

            public Object load(LoaderHelper helper) throws CacheLoaderException {
                return "LOADED VALUE";
            }

            public void close() {
            }
        });
        DiskStoreFactory dsf = this.getCache().createDiskStoreFactory();
        factory.setDiskSynchronous(true);
        File d = new File("DiskRegions" + ProcessMgr.getProcessId());
        d.mkdirs();
        dsf.setDiskDirs(new File[]{d});
        DiskStore ds = dsf.create(name);
        factory.setDiskStoreName(ds.getName());
        Region region = this.createRegion(name, factory.create());
        LRUStatistics lruStats = this.getLRUStats(region);
        DiskRegionTest.assertNotNull((Object)lruStats);
        for (i = 1; i <= 1; ++i) {
            key = new Integer(i);
            value = String.valueOf(i);
            region.put((Object)key, (Object)value);
            DiskRegionTest.assertEquals((long)1L, (long)lruStats.getCounter());
            DiskRegionTest.assertEquals((long)0L, (long)lruStats.getEvictions());
        }
        for (i = 2; i <= 10; ++i) {
            key = new Integer(i);
            value = String.valueOf(i);
            region.put((Object)key, (Object)value);
            DiskRegionTest.assertEquals((long)1L, (long)lruStats.getCounter());
            DiskRegionTest.assertEquals((long)(i - 1), (long)lruStats.getEvictions());
        }
        for (i = 11; i <= 20; ++i) {
            key = new Integer(i);
            region.get((Object)key);
            DiskRegionTest.assertEquals((long)1L, (long)lruStats.getCounter());
            DiskRegionTest.assertEquals((long)(i - 1), (long)lruStats.getEvictions());
        }
    }

    public void testPersistentReplicateB4NonPersistent() {
        Host host = Host.getHost(0);
        VM vm1 = host.getVM(0);
        VM vm2 = host.getVM(1);
        VM vm3 = host.getVM(2);
        final String regionName = this.getName();
        vm1.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                RegionFactory rf = DiskRegionTest.this.getCache().createRegionFactory(RegionShortcut.REPLICATE_PERSISTENT);
                Region r = rf.create(regionName);
                TestCase.assertTrue((boolean)r.getAttributes().getConcurrencyChecksEnabled());
                return null;
            }
        });
        vm2.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                RegionFactory rf = DiskRegionTest.this.getCache().createRegionFactory(RegionShortcut.REPLICATE);
                Region region = rf.create(regionName);
                TestCase.assertTrue((boolean)region.getAttributes().getConcurrencyChecksEnabled());
                return null;
            }
        });
        vm3.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Cache cache = DiskRegionTest.this.getCache();
                AttributesFactory af = new AttributesFactory();
                af.setScope(Scope.DISTRIBUTED_ACK);
                RegionFactory rf = cache.createRegionFactory(af.create());
                Region r = rf.create(regionName);
                TestCase.assertNotNull((Object)r);
                TestCase.assertTrue((boolean)r.getAttributes().getConcurrencyChecksEnabled());
                return null;
            }
        });
    }

    public void testRRProxyWithPersistentReplicates() {
        Host host = Host.getHost(0);
        VM vm1 = host.getVM(0);
        VM vm2 = host.getVM(1);
        VM vm3 = host.getVM(2);
        final String regionName = this.getName();
        SerializableCallable createRRProxy = new SerializableCallable(){

            public Object call() throws Exception {
                Region r = DiskRegionTest.this.getCache().createRegionFactory(RegionShortcut.REPLICATE_PROXY).create(regionName);
                TestCase.assertNotNull((Object)r);
                return null;
            }
        };
        SerializableCallable createPersistentRR = new SerializableCallable(){

            public Object call() throws Exception {
                Region r = DiskRegionTest.this.getCache().createRegionFactory(RegionShortcut.REPLICATE_PERSISTENT).create(regionName);
                TestCase.assertNotNull((Object)r);
                return null;
            }
        };
        vm1.invoke(createRRProxy);
        vm2.invoke(createPersistentRR);
        vm3.invoke(createRRProxy);
        SerializableCallable assertConcurrency = new SerializableCallable(){

            public Object call() throws Exception {
                Region r = DiskRegionTest.this.getCache().getRegion(regionName);
                TestCase.assertTrue((boolean)r.getAttributes().getConcurrencyChecksEnabled());
                return null;
            }
        };
        vm1.invoke(assertConcurrency);
        vm3.invoke(assertConcurrency);
    }
}

