/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache30;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.cache30.RegionTestCase;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import dunit.Host;
import dunit.VM;
import java.io.Serializable;
import java.util.Arrays;
import junit.framework.Assert;

public class DiskRegionTestImpl
extends Assert
implements Serializable {
    final RegionTestCase rtc;
    private static final int NUM_ENTRIES = 1000;
    private static final int VALUE_SIZE = 2000;

    private CacheSerializableRunnable createRgnRunnable(final String name) {
        return new CacheSerializableRunnable("Create region"){

            @Override
            public void run2() throws CacheException {
                DiskRegionTestImpl.this.rtc.createRegion(name);
            }
        };
    }

    public DiskRegionTestImpl(RegionTestCase rtc) {
        this.rtc = rtc;
    }

    public void testCreateDiskRegion() throws CacheException {
        String name = this.rtc.getUniqueName();
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        vm0.invoke(this.createRgnRunnable(name));
    }

    public void testBackupFillValues() throws CacheException {
        RegionAttributes attrs = this.rtc.getRegionAttributes();
        DiskRegionTestImpl.assertTrue((String)"This test not appropriate for non-backup regions", (boolean)attrs.getPersistBackup());
        final String name = this.rtc.getUniqueName();
        String key1 = "KEY1";
        String key2 = "KEY2";
        String value1 = "VALUE1";
        String value2 = "VALUE2";
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        vm0.invoke(new CacheSerializableRunnable("Create backup Region in VM0"){

            @Override
            public void run2() throws CacheException {
                Region rgn = DiskRegionTestImpl.this.rtc.createRegion(name);
                rgn.create((Object)"KEY1", (Object)"VALUE1");
                rgn.create((Object)"KEY2", (Object)"VALUE2");
                rgn.create((Object)new Integer(0), (Object)"TEMP-0");
                rgn.create((Object)new Integer(1), (Object)"TEMP-1");
            }
        });
        vm1.invoke(new CacheSerializableRunnable("Create & Populate non-mirrored in VM1"){

            @Override
            public void run2() throws CacheException {
                AttributesFactory factory = new AttributesFactory();
                Scope scope = DiskRegionTestImpl.this.rtc.getRegionAttributes().getScope();
                factory.setScope(scope);
                DataPolicy dataPolicy = DiskRegionTestImpl.this.rtc.getRegionAttributes().getDataPolicy();
                factory.setDataPolicy(dataPolicy);
                RegionAttributes attrs2 = factory.create();
                Region rgn = DiskRegionTestImpl.this.rtc.createRegion(name, attrs2);
                for (int i = 0; i < 1000; ++i) {
                    byte[] value = new byte[2000];
                    Arrays.fill(value, (byte)-85);
                    rgn.put((Object)new Integer(i), (Object)value);
                }
                Assert.assertEquals((int)1002, (int)rgn.keySet().size());
            }
        });
        vm0.invoke(new CacheSerializableRunnable("Close Cache in VM0"){

            @Override
            public void run2() throws CacheException {
                CacheTestCase.closeCache();
            }
        });
        String runnableName = "Re-create backup region in VM0 with mirror KEYS_VALUES and Do Verification";
        vm0.invoke(new CacheSerializableRunnable(runnableName){

            @Override
            public void run2() throws CacheException {
                byte[] v;
                Region.Entry entry;
                int i;
                AttributesFactory factory = new AttributesFactory(DiskRegionTestImpl.this.rtc.getRegionAttributes());
                factory.setDataPolicy(DataPolicy.PERSISTENT_REPLICATE);
                RegionAttributes attrs2 = factory.create();
                Region rgn = DiskRegionTestImpl.this.rtc.createRegion(name, attrs2);
                Assert.assertEquals((int)1002, (int)rgn.keySet().size());
                boolean RECOVER_VALUES = true;
                if (RECOVER_VALUES) {
                    Assert.assertEquals((Object)"VALUE1", (Object)rgn.getEntry((Object)"KEY1").getValue());
                    Assert.assertEquals((Object)"VALUE2", (Object)rgn.getEntry((Object)"KEY2").getValue());
                } else {
                    Assert.assertNull((Object)this.valueInVM(rgn, "KEY1"));
                    Assert.assertNull((Object)this.valueInVM(rgn, "KEY2"));
                }
                Assert.assertEquals((Object)"VALUE1", (Object)this.valueOnDisk(rgn, "KEY1"));
                Assert.assertEquals((Object)"VALUE2", (Object)this.valueOnDisk(rgn, "KEY2"));
                for (i = 0; i < 1000; ++i) {
                    entry = rgn.getEntry((Object)new Integer(i));
                    Assert.assertNotNull((String)("No entry for key " + i), (Object)entry);
                    v = (byte[])entry.getValue();
                    Assert.assertNotNull((String)("Null value for key " + i), (Object)v);
                    Assert.assertEquals((int)2000, (int)v.length);
                    Assert.assertEquals((byte)-85, (byte)v[i % 2000]);
                }
                rgn.close();
                rgn = DiskRegionTestImpl.this.rtc.createRegion(name, attrs2);
                Assert.assertEquals((int)1002, (int)rgn.keySet().size());
                if (RECOVER_VALUES) {
                    Assert.assertEquals((Object)"VALUE1", (Object)rgn.getEntry((Object)"KEY1").getValue());
                    Assert.assertEquals((Object)"VALUE2", (Object)rgn.getEntry((Object)"KEY2").getValue());
                } else {
                    Assert.assertNull((Object)this.valueInVM(rgn, "KEY1"));
                    Assert.assertNull((Object)this.valueInVM(rgn, "KEY2"));
                }
                Assert.assertEquals((Object)"VALUE1", (Object)this.valueOnDisk(rgn, "KEY1"));
                Assert.assertEquals((Object)"VALUE2", (Object)this.valueOnDisk(rgn, "KEY2"));
                for (i = 0; i < 1000; ++i) {
                    entry = rgn.getEntry((Object)new Integer(i));
                    Assert.assertNotNull((String)("No entry for key " + i), (Object)entry);
                    v = (byte[])entry.getValue();
                    Assert.assertNotNull((String)("Null value for key " + i), (Object)v);
                    Assert.assertEquals((int)2000, (int)v.length);
                    Assert.assertEquals((byte)-85, (byte)v[i % 2000]);
                }
            }

            private Object valueInVM(Region rgn, Object key) throws EntryNotFoundException {
                LocalRegion lrgn = (LocalRegion)rgn;
                return lrgn.getValueInVM(key);
            }

            private Object valueOnDisk(Region rgn, Object key) throws EntryNotFoundException {
                LocalRegion lrgn = (LocalRegion)rgn;
                return lrgn.getValueOnDisk(key);
            }
        });
    }
}

