/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache30;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.CacheWriter;
import com.gemstone.gemfire.cache.CacheWriterException;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.RegionDestroyedException;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.util.CacheListenerAdapter;
import com.gemstone.gemfire.cache.util.CacheWriterAdapter;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.distributed.DistributedSystem;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableRunnable;
import dunit.VM;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import junit.framework.TestCase;

public class DistAckMapMethodsDUnitTest
extends DistributedTestCase {
    static Cache cache;
    static Properties props;
    static DistributedSystem ds;
    static Region region;
    static Region mirroredRegion;
    static Region remRegion;
    static boolean afterDestroy;
    static Object afterDestroyObj;

    public DistAckMapMethodsDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        vm0.invoke(DistAckMapMethodsDUnitTest.class, "createCache");
        vm1.invoke(DistAckMapMethodsDUnitTest.class, "createCache");
    }

    @Override
    public void tearDown2() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        vm0.invoke(DistAckMapMethodsDUnitTest.class, "closeCache");
        vm1.invoke(DistAckMapMethodsDUnitTest.class, "closeCache");
        cache = null;
        DistAckMapMethodsDUnitTest.invokeInEveryVM(new SerializableRunnable(){

            @Override
            public void run() {
                cache = null;
            }
        });
    }

    public static void createCache() {
        try {
            ds = new DistAckMapMethodsDUnitTest("temp").getSystem(props);
            cache = CacheFactory.create((DistributedSystem)ds);
            AttributesFactory factory = new AttributesFactory();
            factory.setScope(Scope.DISTRIBUTED_ACK);
            RegionAttributes attr = factory.create();
            region = cache.createRegion("map", attr);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void closeCache() {
        try {
            cache.close();
            ds.disconnect();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void createMirroredRegion() {
        try {
            AttributesFactory factory1 = new AttributesFactory();
            factory1.setScope(Scope.DISTRIBUTED_ACK);
            factory1.setDataPolicy(DataPolicy.REPLICATE);
            RegionAttributes attr1 = factory1.create();
            mirroredRegion = cache.createRegion("mirrored", attr1);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void createRegionToTestRemove() {
        try {
            AttributesFactory factory2 = new AttributesFactory();
            factory2.setScope(Scope.DISTRIBUTED_ACK);
            RemoveCacheWriter cacheWriter = new RemoveCacheWriter();
            RemoveCacheListener cacheListener = new RemoveCacheListener();
            factory2.setCacheWriter((CacheWriter)cacheWriter);
            factory2.setCacheListener((CacheListener)cacheListener);
            RegionAttributes attr2 = factory2.create();
            remRegion = cache.createRegion("remove", attr2);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void testPutMethod() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        int i = 1;
        Object[] objArr = new Object[]{"" + i};
        vm0.invoke(DistAckMapMethodsDUnitTest.class, "putMethod", objArr);
        Object obj1 = vm1.invoke(DistAckMapMethodsDUnitTest.class, "getMethod", objArr);
        if (obj1 == null) {
            DistAckMapMethodsDUnitTest.fail((String)"region.put(key, value) from one vm does not match with region.get(key) from other vm");
        }
        i = 2;
        objArr[0] = "" + i;
        vm0.invoke(DistAckMapMethodsDUnitTest.class, "putMethod", objArr);
        obj1 = vm1.invoke(DistAckMapMethodsDUnitTest.class, "putMethod", objArr);
        if (obj1 != null) {
            DistAckMapMethodsDUnitTest.fail((String)"failed while region.put from both vms for same key");
        }
    }

    public void testRemoveMethod() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        int i = 1;
        Object[] objArr = new Object[]{"" + i};
        vm0.invoke(DistAckMapMethodsDUnitTest.class, "putMethod", objArr);
        vm0.invoke(DistAckMapMethodsDUnitTest.class, "removeMethod", objArr);
        boolean ret = vm0.invokeBoolean(DistAckMapMethodsDUnitTest.class, "containsKeyMethod", objArr);
        if (ret) {
            DistAckMapMethodsDUnitTest.fail((String)"region.remove failed with distributed ack scope");
        }
        vm0.invoke(DistAckMapMethodsDUnitTest.class, "putMethod", objArr);
        Object obj1 = vm1.invoke(DistAckMapMethodsDUnitTest.class, "getMethod", objArr);
        Object obj2 = vm1.invoke(DistAckMapMethodsDUnitTest.class, "removeMethod", objArr);
        DistAckMapMethodsDUnitTest.getLogWriter().fine("111111111" + obj1);
        DistAckMapMethodsDUnitTest.getLogWriter().fine("2222222222" + obj2);
        if (obj1 == null) {
            DistAckMapMethodsDUnitTest.fail((String)"region1.getMethod returned null");
        }
        if (!obj1.equals(obj2)) {
            DistAckMapMethodsDUnitTest.fail((String)"region.remove failed with distributed ack scope");
        }
    }

    public void testRemoveMethodDetails() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        vm0.invoke(DistAckMapMethodsDUnitTest.class, "createRegionToTestRemove");
        vm1.invoke(DistAckMapMethodsDUnitTest.class, "createRegionToTestRemove");
        vm0.invoke(DistAckMapMethodsDUnitTest.class, "removeMethodDetails");
        vm1.invoke(new CacheSerializableRunnable("testRemoveMethodDetails"){

            @Override
            public void run2() throws CacheException {
                Object ob1 = remRegion.get((Object)new Integer(1));
                TestCase.assertEquals((String)"beforeDestroy", (String)ob1.toString());
                TestCase.assertEquals((String)"afterDestroy", (String)remRegion.get((Object)new Integer(3)).toString());
            }
        });
    }

    public void testIsEmptyMethod() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        int i = 1;
        Object[] objArr = new Object[]{"" + i};
        vm0.invoke(DistAckMapMethodsDUnitTest.class, "putMethod", objArr);
        boolean val = vm1.invokeBoolean(DistAckMapMethodsDUnitTest.class, "isEmptyMethod");
        if (!val) {
            DistAckMapMethodsDUnitTest.fail((String)"Failed in region.isEmpty");
        }
        vm1.invoke(DistAckMapMethodsDUnitTest.class, "getMethod", objArr);
        boolean val1 = vm1.invokeBoolean(DistAckMapMethodsDUnitTest.class, "isEmptyMethod");
        if (val1) {
            DistAckMapMethodsDUnitTest.fail((String)"Failed in region.isEmpty");
        }
    }

    public void testContainsValueMethod() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        int i = 1;
        Object[] objArr = new Object[]{"" + i};
        vm0.invoke(DistAckMapMethodsDUnitTest.class, "putMethod", objArr);
        Object[] ob = new Object[]{"first"};
        boolean val = vm1.invokeBoolean(DistAckMapMethodsDUnitTest.class, "containsValueMethod", ob);
        if (val) {
            DistAckMapMethodsDUnitTest.fail((String)"Failed in region.ContainsValue");
        }
        vm1.invoke(DistAckMapMethodsDUnitTest.class, "getMethod", objArr);
        boolean val1 = vm1.invokeBoolean(DistAckMapMethodsDUnitTest.class, "containsValueMethod", ob);
        if (!val1) {
            DistAckMapMethodsDUnitTest.fail((String)"Failed in region.ContainsValue");
        }
    }

    public void testKeySetMethod() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        int i = 1;
        Object[] objArr = new Object[]{"" + i};
        vm0.invoke(DistAckMapMethodsDUnitTest.class, "putMethod", objArr);
        int temp = vm1.invokeInt(DistAckMapMethodsDUnitTest.class, "keySetMethod");
        if (temp != 0) {
            DistAckMapMethodsDUnitTest.fail((String)"failed in keySetMethodtest method");
        }
        vm1.invoke(DistAckMapMethodsDUnitTest.class, "getMethod", objArr);
        temp = vm1.invokeInt(DistAckMapMethodsDUnitTest.class, "keySetMethod");
        if (temp == 0) {
            DistAckMapMethodsDUnitTest.fail((String)"failed in keySetMethodtest method");
        }
        temp = 0;
        vm0.invoke(DistAckMapMethodsDUnitTest.class, "createMirroredRegion");
        vm1.invoke(DistAckMapMethodsDUnitTest.class, "createMirroredRegion");
        vm0.invoke(DistAckMapMethodsDUnitTest.class, "putMethod", objArr);
        temp = vm1.invokeInt(DistAckMapMethodsDUnitTest.class, "keySetMethod");
        if (temp == 0) {
            DistAckMapMethodsDUnitTest.fail((String)"failed in keySetMethodtest method");
        }
    }

    public void testEntrySetMethod() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        int i = 1;
        Object[] objArr = new Object[]{"" + i};
        vm0.invoke(DistAckMapMethodsDUnitTest.class, "putMethod", objArr);
        int temp = vm1.invokeInt(DistAckMapMethodsDUnitTest.class, "entrySetMethod");
        if (temp != 0) {
            DistAckMapMethodsDUnitTest.fail((String)"failed in entrySetMethodtest method");
        }
        vm1.invoke(DistAckMapMethodsDUnitTest.class, "getMethod", objArr);
        temp = vm1.invokeInt(DistAckMapMethodsDUnitTest.class, "entrySetMethod");
        if (temp == 0) {
            DistAckMapMethodsDUnitTest.fail((String)"failed in entrySetMethodtest method");
        }
        temp = 0;
        vm0.invoke(DistAckMapMethodsDUnitTest.class, "createMirroredRegion");
        vm1.invoke(DistAckMapMethodsDUnitTest.class, "createMirroredRegion");
        vm0.invoke(DistAckMapMethodsDUnitTest.class, "putOnMirroredRegion", objArr);
        temp = vm1.invokeInt(DistAckMapMethodsDUnitTest.class, "entrySetMethod");
        if (temp == 0) {
            DistAckMapMethodsDUnitTest.fail((String)"failed in entrySetMethodtest method");
        }
    }

    public void testSizeMethod() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        int i = 1;
        int j = 0;
        Object[] objArr = new Object[]{"" + i};
        vm0.invoke(DistAckMapMethodsDUnitTest.class, "putMethod", objArr);
        j = vm1.invokeInt(DistAckMapMethodsDUnitTest.class, "sizeMethod");
        if (j != 0) {
            DistAckMapMethodsDUnitTest.fail((String)"failed in region.size method");
        }
        vm1.invoke(DistAckMapMethodsDUnitTest.class, "getMethod", objArr);
        j = vm1.invokeInt(DistAckMapMethodsDUnitTest.class, "sizeMethod");
        if (j == 0) {
            DistAckMapMethodsDUnitTest.fail((String)"failed in region.size method");
        }
    }

    public void testallMethodsArgs() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        vm0.invoke(DistAckMapMethodsDUnitTest.class, "allMethodsArgs");
    }

    public static Object putMethod(Object ob) {
        Object obj = null;
        try {
            if (ob != null) {
                String str = "first";
                obj = region.put(ob, (Object)str);
            }
        }
        catch (Exception ex) {
            DistAckMapMethodsDUnitTest.fail((String)"Failed while region.put");
        }
        return obj;
    }

    public static Object getMethod(Object ob) {
        Object obj = null;
        try {
            obj = region.get(ob);
        }
        catch (Exception ex) {
            DistAckMapMethodsDUnitTest.fail((String)"Failed while region.get");
        }
        return obj;
    }

    public static Object removeMethod(Object ob) {
        Object obj = null;
        try {
            obj = region.remove(ob);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            DistAckMapMethodsDUnitTest.fail((String)"Failed while region.remove");
        }
        return obj;
    }

    public static boolean containsKeyMethod(Object ob) {
        boolean flag = false;
        try {
            flag = region.containsKey(ob);
        }
        catch (Exception ex) {
            DistAckMapMethodsDUnitTest.fail((String)"Failed while region.containsKey");
        }
        return flag;
    }

    public static boolean isEmptyMethod() {
        boolean flag = false;
        try {
            flag = region.isEmpty();
        }
        catch (Exception ex) {
            DistAckMapMethodsDUnitTest.fail((String)"Failed while region.isEmpty");
        }
        return flag;
    }

    public static boolean containsValueMethod(Object ob) {
        boolean flag = false;
        try {
            flag = region.containsValue(ob);
        }
        catch (Exception ex) {
            DistAckMapMethodsDUnitTest.fail((String)"Failed while region.containsValueMethod");
        }
        return flag;
    }

    public static int keySetMethod() {
        Set set = new HashSet();
        int i = 0;
        try {
            set = region.keySet();
            i = set.size();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            DistAckMapMethodsDUnitTest.fail((String)"Failed while region.keySet");
        }
        return i;
    }

    public static int entrySetMethod() {
        Set set = new HashSet();
        int i = 0;
        try {
            set = region.entrySet();
            i = set.size();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            DistAckMapMethodsDUnitTest.fail((String)"Failed while region.entrySet");
        }
        return i;
    }

    public static int sizeMethod() {
        int i = 0;
        try {
            i = region.size();
        }
        catch (Exception ex) {
            DistAckMapMethodsDUnitTest.fail((String)"Failed while region.size");
        }
        return i;
    }

    public static Object putOnMirroredRegion(Object ob) {
        Object obj = null;
        try {
            String str = "mirror";
            obj = mirroredRegion.put(ob, (Object)str);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            DistAckMapMethodsDUnitTest.fail((String)"Failed while mirroredRegion.put");
        }
        return obj;
    }

    public static Object getFromMirroredRegion(Object ob) {
        Object obj = null;
        try {
            obj = mirroredRegion.get(ob);
        }
        catch (Exception ex) {
            DistAckMapMethodsDUnitTest.fail((String)"Failed while mirroredRegion.get");
        }
        return obj;
    }

    public static void removeMethodDetails() {
        Integer inOb22;
        Integer inOb1 = new Integer(1);
        try {
            region.put((Object)inOb1, (Object)"first");
            Object ob1 = region.remove((Object)inOb1);
            DistAckMapMethodsDUnitTest.assertEquals((String)"first", (String)ob1.toString());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            region.remove((Object)new Integer(2));
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            inOb22 = new Integer(2);
            region.put((Object)inOb22, (Object)"second");
            inOb22 = null;
            region.remove((Object)inOb22);
            DistAckMapMethodsDUnitTest.fail((String)"Should have thrown NullPointerException ");
        }
        catch (NullPointerException inOb22) {
            // empty catch block
        }
        try {
            inOb22 = new Integer(2);
            remRegion.put((Object)inOb22, (Object)"second");
            remRegion.remove((Object)inOb22);
            inOb22 = new Integer(1);
            DistAckMapMethodsDUnitTest.assertEquals((String)"beforeDestroy", (String)remRegion.get((Object)inOb22).toString());
            while (!afterDestroy) {
            }
            inOb22 = new Integer(3);
            DistAckMapMethodsDUnitTest.assertEquals((String)"afterDestroy", (String)remRegion.get((Object)inOb22).toString());
            DistAckMapMethodsDUnitTest.assertNotNull((Object)afterDestroyObj);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void allMethodsArgs() {
        try {
            region.put((Object)new Integer(1), (Object)new String("first"));
            region.put((Object)new Integer(2), (Object)new String("second"));
            region.put((Object)new Integer(3), (Object)new String("third"));
            Object ob1 = region.get((Object)new Integer(1));
            DistAckMapMethodsDUnitTest.assertEquals((String)"first", (String)ob1.toString());
            boolean val1 = region.containsKey((Object)new Integer(2));
            DistAckMapMethodsDUnitTest.assertEquals((boolean)true, (boolean)val1);
            boolean val2 = region.containsValue((Object)new String("second"));
            try {
                region.remove((Object)new Integer(3));
            }
            catch (Exception ex) {
                ex.printStackTrace();
                DistAckMapMethodsDUnitTest.fail((String)"failed while region.remove(new Object())");
            }
            Integer key = null;
            String value = null;
            try {
                region.put(key, value);
                DistAckMapMethodsDUnitTest.fail((String)"should have thrown NullPointerException");
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            try {
                region.containsValue(value);
                DistAckMapMethodsDUnitTest.fail((String)"should have thrown NullPointerException");
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            key = new Integer(5);
            value = new String("fifth");
            region.localDestroyRegion();
            try {
                region.put((Object)key, (Object)value);
                DistAckMapMethodsDUnitTest.fail((String)"should have thrown RegionDestroyedException");
            }
            catch (RegionDestroyedException regionDestroyedException) {
                // empty catch block
            }
            try {
                region.remove((Object)key);
                DistAckMapMethodsDUnitTest.fail((String)"should have thrown RegionDestroyedException");
            }
            catch (RegionDestroyedException regionDestroyedException) {
                // empty catch block
            }
            try {
                region.containsValue((Object)value);
                DistAckMapMethodsDUnitTest.fail((String)"should have thrown RegionDestroyedException");
            }
            catch (RegionDestroyedException regionDestroyedException) {
                // empty catch block
            }
            try {
                region.size();
                DistAckMapMethodsDUnitTest.fail((String)"should have thrown RegionDestroyedException");
            }
            catch (RegionDestroyedException regionDestroyedException) {
                // empty catch block
            }
            try {
                region.keySet();
                DistAckMapMethodsDUnitTest.fail((String)"should have thrown RegionDestroyedException");
            }
            catch (RegionDestroyedException regionDestroyedException) {
                // empty catch block
            }
            try {
                region.entrySet();
                DistAckMapMethodsDUnitTest.fail((String)"should have thrown RegionDestroyedException");
            }
            catch (RegionDestroyedException regionDestroyedException) {}
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    static {
        props = new Properties();
        ds = null;
        afterDestroy = false;
    }

    static class RemoveCacheListener
    extends CacheListenerAdapter {
        RemoveCacheListener() {
        }

        public void afterDestroy(EntryEvent entryEvent) throws CacheWriterException {
            Integer o1 = new Integer(3);
            remRegion.put((Object)o1, (Object)"afterDestroy");
            afterDestroyObj = entryEvent.getKey();
            afterDestroy = true;
        }
    }

    static class RemoveCacheWriter
    extends CacheWriterAdapter {
        RemoveCacheWriter() {
        }

        public void beforeDestroy(EntryEvent entryEvent) throws CacheWriterException {
            Integer o1 = new Integer(1);
            remRegion.put((Object)o1, (Object)"beforeDestroy");
        }
    }
}

