/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache30;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.EvictionAction;
import com.gemstone.gemfire.cache.EvictionAttributes;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache30.DistributedAckRegionCCEDUnitTest;

public class DistributedAckOverflowRegionCCEDUnitTest
extends DistributedAckRegionCCEDUnitTest {
    public DistributedAckOverflowRegionCCEDUnitTest(String name) {
        super(name);
    }

    @Override
    protected RegionAttributes getRegionAttributes() {
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        factory.setDataPolicy(DataPolicy.REPLICATE);
        factory.setConcurrencyChecksEnabled(true);
        factory.setEvictionAttributes(EvictionAttributes.createLRUEntryAttributes((int)5, (EvictionAction)EvictionAction.OVERFLOW_TO_DISK));
        return factory.create();
    }

    @Override
    protected RegionAttributes getRegionAttributes(String type) {
        RegionAttributes ra = this.getCache().getRegionAttributes(type);
        if (ra == null) {
            throw new IllegalStateException("The region shortcut " + type + " has been removed.");
        }
        AttributesFactory factory = new AttributesFactory(ra);
        factory.setConcurrencyChecksEnabled(true);
        if (!ra.getDataPolicy().isEmpty()) {
            factory.setEvictionAttributes(EvictionAttributes.createLRUEntryAttributes((int)5, (EvictionAction)EvictionAction.OVERFLOW_TO_DISK));
        }
        return factory.create();
    }
}

