/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache30;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache30.MultiVMRegionTestCase;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableRunnable;
import dunit.VM;
import java.util.Properties;
import junit.framework.TestCase;

public class DistributedAckRegionTest
extends MultiVMRegionTestCase {
    public DistributedAckRegionTest(String name) {
        super(name);
    }

    @Override
    protected RegionAttributes getRegionAttributes() {
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        factory.setDataPolicy(DataPolicy.PRELOADED);
        factory.setEarlyAck(false);
        factory.setConcurrencyChecksEnabled(false);
        return factory.create();
    }

    @Override
    public Properties getDistributedSystemProperties() {
        Properties p = new Properties();
        p.put("statistic-sampling-enabled", "true");
        return p;
    }

    public void testIncompatibleSubregions() throws CacheException, InterruptedException {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        final String name = this.getUniqueName() + "-ACK";
        vm0.invoke(new SerializableRunnable("Create ACK Region"){

            @Override
            public void run() {
                try {
                    DistributedAckRegionTest.this.createRegion(name, "INCOMPATIBLE_ROOT", DistributedAckRegionTest.this.getRegionAttributes());
                }
                catch (CacheException ex) {
                    DistributedTestCase.fail("While creating ACK region", ex);
                }
            }
        });
        vm1.invoke(new SerializableRunnable("Create GLOBAL Region"){

            @Override
            public void run() {
                try {
                    AttributesFactory factory = new AttributesFactory(DistributedAckRegionTest.this.getRegionAttributes());
                    factory.setScope(Scope.GLOBAL);
                    try {
                        DistributedAckRegionTest.this.createRegion(name, "INCOMPATIBLE_ROOT", factory.create());
                        TestCase.fail((String)"Should have thrown an IllegalStateException");
                    }
                    catch (IllegalStateException illegalStateException) {}
                }
                catch (CacheException ex) {
                    DistributedTestCase.fail("While creating GLOBAL Region", ex);
                }
            }
        });
        vm1.invoke(new SerializableRunnable("Create NOACK Region"){

            @Override
            public void run() {
                try {
                    AttributesFactory factory = new AttributesFactory(DistributedAckRegionTest.this.getRegionAttributes());
                    factory.setScope(Scope.DISTRIBUTED_NO_ACK);
                    try {
                        DistributedAckRegionTest.this.createRegion(name, "INCOMPATIBLE_ROOT", factory.create());
                        TestCase.fail((String)"Should have thrown an IllegalStateException");
                    }
                    catch (IllegalStateException illegalStateException) {}
                }
                catch (CacheException ex) {
                    DistributedTestCase.fail("While creating NOACK Region", ex);
                }
            }
        });
    }
}

