/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache30;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.cache30.MultiVMRegionTestCase;
import dunit.AsyncInvocation;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableRunnable;
import dunit.VM;
import java.util.Arrays;
import junit.framework.TestCase;

public class DistributedNoAckRegionTest
extends MultiVMRegionTestCase {
    private static final int CHUNK_SIZE = 512000;
    private static final int NUM_ENTRIES_VM = 15000;
    private static final int VALUE_SIZE_VM = 5120;
    private static final int NUM_PUTS = 100000;
    protected static volatile boolean stopPutting = false;

    public DistributedNoAckRegionTest(String name) {
        super(name);
    }

    @Override
    protected RegionAttributes getRegionAttributes() {
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_NO_ACK);
        factory.setDataPolicy(DataPolicy.PRELOADED);
        factory.setConcurrencyChecksEnabled(false);
        return factory.create();
    }

    public void testDistSubregionOfLocalRegion() throws CacheException {
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.LOCAL);
        this.createRootRegion(factory.create());
        try {
            this.createRegion(this.getUniqueName());
            DistributedNoAckRegionTest.fail((String)"Should have thrown an IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testIncompatibleSubregions() throws CacheException, InterruptedException {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        final String name = this.getUniqueName() + "-NO_ACK";
        vm0.invoke(new SerializableRunnable("Create NO ACK Region"){

            @Override
            public void run() {
                try {
                    Region region = DistributedNoAckRegionTest.this.createRegion(name, "INCOMPATIBLE_ROOT", DistributedNoAckRegionTest.this.getRegionAttributes());
                    TestCase.assertTrue((boolean)DistributedNoAckRegionTest.this.getRootRegion("INCOMPATIBLE_ROOT").getAttributes().getScope().isDistributedNoAck());
                    TestCase.assertTrue((boolean)region.getAttributes().getScope().isDistributedNoAck());
                }
                catch (CacheException ex) {
                    DistributedTestCase.fail("While creating NO ACK region", ex);
                }
            }
        });
        vm1.invoke(new SerializableRunnable("Create GLOBAL Region"){

            @Override
            public void run() {
                try {
                    AttributesFactory factory = new AttributesFactory(DistributedNoAckRegionTest.this.getRegionAttributes());
                    factory.setScope(Scope.GLOBAL);
                    TestCase.assertNull((Object)DistributedNoAckRegionTest.this.getRootRegion("INCOMPATIBLE_ROOT"));
                    try {
                        DistributedNoAckRegionTest.this.createRootRegion("INCOMPATIBLE_ROOT", factory.create());
                        TestCase.fail((String)"Should have thrown an IllegalStateException");
                    }
                    catch (IllegalStateException illegalStateException) {}
                }
                catch (CacheException ex) {
                    DistributedTestCase.fail("While creating GLOBAL Region", ex);
                }
            }
        });
        vm1.invoke(new SerializableRunnable("Create ACK Region"){

            @Override
            public void run() {
                try {
                    AttributesFactory factory = new AttributesFactory(DistributedNoAckRegionTest.this.getRegionAttributes());
                    factory.setScope(Scope.DISTRIBUTED_ACK);
                    TestCase.assertNull((Object)DistributedNoAckRegionTest.this.getRootRegion("INCOMPATIBLE_ROOT"));
                    try {
                        DistributedNoAckRegionTest.this.createRootRegion("INCOMPATIBLE_ROOT", factory.create());
                        TestCase.fail((String)"Should have thrown an IllegalStateException");
                    }
                    catch (IllegalStateException illegalStateException) {}
                }
                catch (CacheException ex) {
                    DistributedTestCase.fail("While creating ACK Region", ex);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disabled_testBug30705() throws InterruptedException {
        final String name = this.getUniqueName();
        int numEntries = 15000;
        int valueSize = 5120;
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm2 = host.getVM(2);
        CacheSerializableRunnable create = new CacheSerializableRunnable("Create Mirrored Region"){

            @Override
            public void run2() throws CacheException {
                DistributedTestCase.getLogWriter().info("testBug30705: Start creating Mirrored Region");
                AttributesFactory factory = new AttributesFactory(DistributedNoAckRegionTest.this.getRegionAttributes());
                factory.setDataPolicy(DataPolicy.REPLICATE);
                DistributedNoAckRegionTest.this.createRegion(name, factory.create());
                DistributedTestCase.getLogWriter().info("testBug30705: Finished creating Mirrored Region");
            }
        };
        CacheSerializableRunnable put = new CacheSerializableRunnable("Distributed NoAck Puts"){

            @Override
            public void run2() throws CacheException {
                Region rgn = DistributedNoAckRegionTest.this.getCache().getRegion("/root/" + name);
                TestCase.assertNotNull((Object)rgn);
                Integer key = new Integer(66);
                byte[] value = new byte[]{};
                TestCase.assertNotNull((Object)value);
                DistributedTestCase.getLogWriter().info("testBug30705: Started Distributed NoAck Puts");
                for (int i = 0; i < 100000; ++i) {
                    if (stopPutting) {
                        DistributedTestCase.getLogWriter().info("testBug30705: Interrupted Distributed Ack Puts after " + i + " PUTS");
                        break;
                    }
                    if (i % 1000 == 0) {
                        DistributedTestCase.getLogWriter().info("testBug30705: modification #" + i);
                    }
                    rgn.put((Object)key, (Object)value);
                }
            }
        };
        vm0.invoke(create);
        vm0.invoke(new CacheSerializableRunnable("Put data"){

            @Override
            public void run2() throws CacheException {
                DistributedTestCase.getLogWriter().info("testBug30705: starting initial data load");
                Region region = DistributedNoAckRegionTest.this.getRootRegion().getSubregion(name);
                byte[] value = new byte[5120];
                Arrays.fill(value, (byte)66);
                for (int i = 0; i < 15000; ++i) {
                    if (i % 1000 == 0) {
                        DistributedTestCase.getLogWriter().info("testBug30705: initial put #" + i);
                    }
                    region.put((Object)new Integer(i), (Object)value);
                }
                DistributedTestCase.getLogWriter().info("testBug30705: finished initial data load");
            }
        });
        AsyncInvocation async = vm0.invokeAsync(put);
        try {
            DistributedNoAckRegionTest.getLogWriter().info("testBug30705: before the critical create");
            vm2.invoke(create);
            DistributedNoAckRegionTest.getLogWriter().info("testBug30705: after the critical create");
        }
        catch (Throwable throwable) {
            DistributedNoAckRegionTest.getLogWriter().info("testBug30705: INTERRUPTING Distributed NoAck Puts after GetInitialImage");
            vm0.invoke(new SerializableRunnable("Interrupt Puts"){

                @Override
                public void run() {
                    DistributedTestCase.getLogWriter().info("testBug30705: interrupting putter");
                    stopPutting = true;
                }
            });
            DistributedTestCase.join(async, 30000L, DistributedNoAckRegionTest.getLogWriter());
            vm2.invoke(new SerializableRunnable("Wait for Overflow Queue"){

                @Override
                public void run() {
                    DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

                        @Override
                        public boolean done() {
                            return DistributedNoAckRegionTest.this.getSystem().getDistributionManager().getStats().getOverflowQueueSize() == 0;
                        }

                        @Override
                        public String description() {
                            return "overflow queue remains nonempty";
                        }
                    };
                    DistributedTestCase.waitForCriterion(ev, 30000L, 200L, true);
                }
            });
            throw throwable;
        }
        DistributedNoAckRegionTest.getLogWriter().info("testBug30705: INTERRUPTING Distributed NoAck Puts after GetInitialImage");
        vm0.invoke(new /* invalid duplicate definition of identical inner class */);
        DistributedTestCase.join(async, 30000L, DistributedNoAckRegionTest.getLogWriter());
        vm2.invoke(new /* invalid duplicate definition of identical inner class */);
        DistributedNoAckRegionTest.getLogWriter().info("testBug30705: at end of test");
        if (async.exceptionOccurred()) {
            DistributedNoAckRegionTest.fail("Got exception", async.getException());
        }
    }

    @Override
    protected void pauseIfNecessary(int ms) {
        DistributedNoAckRegionTest.pause(ms);
    }

    @Override
    protected void pauseIfNecessary() {
        this.pause();
    }

    @Override
    protected long getRepeatTimeoutMs() {
        return 5000L;
    }
}

