/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache30;

import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.DiskStore;
import com.gemstone.gemfire.cache.DiskStoreFactory;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.TransactionEvent;
import com.gemstone.gemfire.cache.TransactionListener;
import com.gemstone.gemfire.cache.client.ServerConnectivityException;
import com.gemstone.gemfire.cache.util.CacheListenerAdapter;
import com.gemstone.gemfire.cache.util.Gateway;
import com.gemstone.gemfire.cache.util.GatewayHub;
import com.gemstone.gemfire.cache.util.GatewayQueueAttributes;
import com.gemstone.gemfire.cache.util.TransactionListenerAdapter;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalLocator;
import com.gemstone.gemfire.internal.AvailablePortHelper;
import com.gemstone.gemfire.internal.OSProcess;
import com.gemstone.gemfire.internal.SocketCreator;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableRunnable;
import dunit.VM;
import hydra.ProcessMgr;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import junit.framework.TestCase;

public class GatewayDUnitTest
extends CacheTestCase {
    private static final boolean IGNORE_BUG_35596 = true;
    private static final String WAN_REGION_NAME = "GatewayDUnitTest_WAN_Root";
    private static final String DS_REGION_NAME = "GatewayDUnitTest_DS_Root";
    protected static final TxControlListener wanTxListener = new TxControlListener();
    protected static final ControlListener wanRegionListener = new ControlListener();
    protected static final ControlListener dsRegionListener = new ControlListener();
    protected static InternalLocator locator;
    private VM[] vmsDS0 = new VM[0];
    private VM[] vmsDS1 = new VM[0];
    private static final String KEY_SLEEP = "KEY_SLEEP";
    private static final String KEY_WAIT = "KEY_WAIT";
    private static final String KEY_DISCONNECT = "KEY_DISCONNECT";
    protected static final int TYPE_CREATE = 0;
    protected static final int TYPE_UPDATE = 1;
    protected static final int TYPE_INVALIDATE = 2;
    protected static final int TYPE_DESTROY = 3;

    public GatewayDUnitTest(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUp() throws Exception {
        boolean failedSetUp = true;
        try {
            GatewayDUnitTest.disconnectAllFromDS();
            this.setUpSystems();
            failedSetUp = false;
        }
        finally {
            super.setUp();
            if (failedSetUp) {
                GatewayDUnitTest.disconnectAllFromDS();
                this.cleanupAllLocators();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tearDown2() throws Exception {
        try {
            GatewayDUnitTest.destroyWanQueues();
            for (int h = 0; h < Host.getHostCount(); ++h) {
                Host host = Host.getHost(h);
                for (int v = 0; v < host.getVMCount(); ++v) {
                    VM vm = host.getVM(v);
                    vm.invoke(GatewayDUnitTest.class, "destroyWanQueues");
                }
            }
            super.tearDown2();
        }
        finally {
            GatewayDUnitTest.disconnectAllFromDS();
            this.cleanupAllLocators();
        }
    }

    protected RegionAttributes getRegionAttributes() {
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        return factory.create();
    }

    public static void destroyWanQueues() {
        try {
            Cache cache = CacheFactory.getAnyInstance();
            for (GatewayHub hub : cache.getGatewayHubs()) {
                for (Gateway gateway : hub.getGateways()) {
                    String rq = new StringBuffer(gateway.getGatewayHubId()).append('_').append(gateway.getId()).append("_EVENT_QUEUE").toString();
                    Region wbcl = cache.getRegion(rq);
                    if (wbcl == null) continue;
                    wbcl.localDestroyRegion();
                }
            }
        }
        catch (CancelException cancelException) {
            // empty catch block
        }
    }

    private void cleanupAllLocators() {
        Host host = Host.getHost(0);
        for (int i = 0; i < host.getVMCount(); ++i) {
            host.getVM(i).invoke(new SerializableRunnable("Stop locator"){

                @Override
                public void run() {
                    if (locator != null) {
                        locator.stop();
                        locator = null;
                    }
                }
            });
        }
    }

    private void setUpSystems() throws Exception {
        String mcastAddr1;
        String mcastAddr0;
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        VM vm3 = host.getVM(3);
        this.vmsDS0 = new VM[]{vm0, vm1};
        this.vmsDS1 = new VM[]{vm2, vm3};
        String hostName = GatewayDUnitTest.getServerHostName(host);
        int[] freeUDPPorts = AvailablePortHelper.getRandomAvailableUDPPorts(2);
        int[] freeTCPPorts = AvailablePortHelper.getRandomAvailableTCPPorts(2);
        int dsPortDS0 = freeUDPPorts[0];
        int dsPortDS1 = freeUDPPorts[1];
        int hubPortDS0 = freeTCPPorts[0];
        int hubPortDS1 = freeTCPPorts[1];
        if (SocketCreator.preferIPv6Addresses()) {
            mcastAddr0 = "FF38::1234";
            mcastAddr1 = "FF38::1235";
        } else {
            mcastAddr0 = "239.192.81.1";
            mcastAddr1 = "239.192.81.2";
        }
        this.setUpDS("ds0", dsPortDS0, mcastAddr0, this.vmsDS0, hubPortDS0, "ds1", hostName, hubPortDS1);
        this.setUpDS("ds1", dsPortDS1, mcastAddr1, this.vmsDS1, hubPortDS1, "ds0", hostName, hubPortDS0);
    }

    private void setUpDS(final String dsName, final int dsPort, String mcastAddr, VM[] vms, final int hubPortLocal, final String dsNameRemote, final String hostNameRemote, final int hubPortRemote) throws Exception {
        final Properties propsDS = new Properties();
        propsDS.setProperty("mcast-address", mcastAddr);
        propsDS.setProperty("mcast-port", String.valueOf(dsPort));
        propsDS.setProperty("locators", "");
        int i = 0;
        while (i < vms.length) {
            final int whichvm = i++;
            VM vm = vms[whichvm];
            vm.invoke(new CacheSerializableRunnable("Set up " + dsName){

                @Override
                public void run2() throws CacheException {
                    String vmName = GatewayDUnitTest.this.getSimpleName() + "_" + dsName + "_vm" + whichvm;
                    propsDS.setProperty("name", vmName);
                    GatewayDUnitTest.this.getSystem(propsDS);
                    DistributedTestCase.getLogWriter().info("[GatewayDUnitTest] " + vmName + " has joined " + dsName + " with port " + String.valueOf(dsPort));
                    Cache cache = GatewayDUnitTest.this.getCache();
                    AttributesFactory factory = new AttributesFactory();
                    factory.setScope(Scope.DISTRIBUTED_ACK);
                    factory.setDataPolicy(DataPolicy.REPLICATE);
                    factory.setEnableWAN(true);
                    cache.getCacheTransactionManager().addListener((TransactionListener)wanTxListener);
                    factory.setCacheListener((CacheListener)wanRegionListener);
                    cache.createRegion(GatewayDUnitTest.WAN_REGION_NAME, factory.create());
                    factory.setEnableWAN(false);
                    factory.setCacheListener((CacheListener)dsRegionListener);
                    cache.createRegion(GatewayDUnitTest.DS_REGION_NAME, factory.create());
                    DistributedTestCase.getLogWriter().info("[GatewayDUnitTest] " + vmName + " has created both regions");
                }
            });
        }
        final int whichvm = vms.length - 1;
        VM vm = vms[whichvm];
        vm.invoke(new CacheSerializableRunnable("Set up gateway in " + dsName){

            @Override
            public void run2() throws CacheException {
                String vmName = GatewayDUnitTest.this.getSimpleName() + "_" + dsName + "_vm" + whichvm;
                String hubName = GatewayDUnitTest.this.getSimpleName() + "_" + dsName;
                String gatewayName = GatewayDUnitTest.this.getSimpleName() + "_" + dsNameRemote;
                DistributedTestCase.getLogWriter().info("[GatewayDUnitTest] " + vmName + " is creating " + hubName + " with gateway to " + gatewayName);
                Cache cache = GatewayDUnitTest.this.getCache();
                GatewayHub hub = cache.setGatewayHub(hubName, hubPortLocal);
                Gateway gateway = GatewayDUnitTest.this.addGateway(hub, gatewayName);
                DistributedTestCase.getLogWriter().info("[GatewayDUnitTest] " + vmName + " adding endpoint [" + gatewayName + ", " + hostNameRemote + ", " + hubPortRemote + "] to " + gatewayName);
                gateway.addEndpoint(gatewayName, hostNameRemote, hubPortRemote);
                File d = new File(gatewayName + "_overflow_" + ProcessMgr.getProcessId());
                DistributedTestCase.getLogWriter().info("[GatewayDUnitTest] " + vmName + " creating queue in " + d + " for " + gatewayName);
                GatewayQueueAttributes queueAttributes = new GatewayQueueAttributes(d.toString(), 100, 100, 1000, false, false, true, 0);
                queueAttributes.setEnablePersistence(true);
                queueAttributes.setDiskStoreName(GatewayDUnitTest.this.getUniqueName());
                File overflowDirectory = new File("overflow_dir_" + dsName + "_vm_" + whichvm);
                overflowDirectory.mkdir();
                DiskStoreFactory dsf = cache.createDiskStoreFactory();
                File[] dirs1 = new File[]{overflowDirectory};
                DiskStore ds1 = dsf.setDiskDirs(dirs1).create(GatewayDUnitTest.this.getUniqueName());
                gateway.setQueueAttributes(queueAttributes);
                try {
                    hub.start();
                }
                catch (IOException e) {
                    DistributedTestCase.getLogWriter().error("Start of hub " + hubName + " threw " + e, (Throwable)e);
                    DistributedTestCase.fail("Start of hub " + hubName + " threw " + e, e);
                }
                DistributedTestCase.getLogWriter().info("[GatewayDUnitTest] " + vmName + " has created " + hubName + " with gateway to " + gatewayName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGateway() throws Throwable {
        int testsCompleted = 0;
        int maxAttempts = 11;
        DistributedTestCase.ExpectedException expectedEx = null;
        block19: for (int i = 0; i < maxAttempts; ++i) {
            if (i > 0) {
                GatewayDUnitTest.getLogWriter().info("testGateway attempt " + i + " with " + testsCompleted + " doTests completed.");
                this.tearDown2();
                this.setUp();
            }
            try {
                switch (testsCompleted) {
                    case 0: {
                        GatewayDUnitTest.getLogWriter().info("testGateway doTestRegionContainment");
                        this.doTestRegionContainment();
                        ++testsCompleted;
                    }
                    case 1: {
                        GatewayDUnitTest.getLogWriter().info("testGateway doTestPutThenDestroy");
                        expectedEx = GatewayDUnitTest.addExpectedException(ServerConnectivityException.class.getName());
                        this.doTestPutThenDestroy();
                        ++testsCompleted;
                    }
                    case 2: {
                        GatewayDUnitTest.getLogWriter().info("testGateway doTestDestroyFromOther");
                        this.doTestDestroyFromOther();
                        ++testsCompleted;
                    }
                    case 3: {
                        GatewayDUnitTest.getLogWriter().info("testGateway doTestMultipleDestroy");
                        this.doTestMultipleDestroy();
                        ++testsCompleted;
                    }
                    case 4: {
                        GatewayDUnitTest.getLogWriter().info("testGateway doTestEarlyAckUnsupported");
                        this.doTestEarlyAckUnsupported();
                        ++testsCompleted;
                    }
                    case 5: {
                        GatewayDUnitTest.getLogWriter().info("testGateway doTestSetSocketReadTimeout");
                        this.doTestSetSocketReadTimeout();
                        ++testsCompleted;
                    }
                    case 6: {
                        GatewayDUnitTest.getLogWriter().info("testGateway doTestHubStopStart");
                        this.doTestHubStopStart();
                        ++testsCompleted;
                    }
                    case 7: {
                        GatewayDUnitTest.getLogWriter().info("testGateway doTestBatchWithException");
                        this.doTestBatchWithException();
                        ++testsCompleted;
                    }
                    case 8: {
                        GatewayDUnitTest.getLogWriter().info("testGateway doTestQueuePersistence");
                        this.doTestQueuePersistence();
                        ++testsCompleted;
                    }
                    case 9: {
                        GatewayDUnitTest.getLogWriter().info("testGateway doTestQueuePersistenceFailover");
                        this.doTestQueuePersistenceFailover();
                        ++testsCompleted;
                    }
                    case 10: {
                        GatewayDUnitTest.getLogWriter().info("testGateway doTestTxPut");
                        ++testsCompleted;
                    }
                    case 11: {
                        GatewayDUnitTest.getLogWriter().info("testGateway doRegionNotFound");
                        this.doRegionNotFound();
                        ++testsCompleted;
                    }
                }
                if (expectedEx != null) {
                    expectedEx.remove();
                }
                GatewayDUnitTest.getLogWriter().info("testGateway done");
                break;
            }
            catch (Throwable t) {
                boolean handledThrowable = false;
                try {
                    for (Throwable cause = t; cause != null; cause = cause.getCause()) {
                        if (cause.getMessage().indexOf("BindException") <= -1 && cause.getMessage().indexOf("IOException") <= -1) continue;
                        handledThrowable = true;
                        if (i >= maxAttempts) {
                            throw new Exception("Test failed after " + i + " attempts.", t);
                        }
                        GatewayDUnitTest.getLogWriter().info("testGateway about to repeat after attempt " + i + " threw IOException (see bugs 37480 and 37842).", t);
                        continue block19;
                    }
                    continue;
                }
                finally {
                    if (!handledThrowable) {
                        throw t;
                    }
                }
            }
        }
    }

    private void doTestRegionContainment() throws Exception {
        int i;
        GatewayDUnitTest.getLogWriter().info("[GatewayDUnitTest] doTestRegionContainment");
        this.clearAllListeners();
        String key = "KEY-doTestRegionContainment";
        String val = "VAL-doTestRegionContainment";
        String arg = "ARG-doTestRegionContainment";
        this.vmPut(this.vmsDS0[0], DS_REGION_NAME, "KEY-doTestRegionContainment", "VAL-doTestRegionContainment", "ARG-doTestRegionContainment");
        this.waitForGatewayQueuesToEmpty();
        for (i = 0; i < this.vmsDS0.length; ++i) {
            this.vmsDS0[i].invoke(new CacheSerializableRunnable("Assert DS Listener"){

                @Override
                public void run2() throws CacheException {
                    dsRegionListener.waitWhileNoEvents(60000L);
                    TestCase.assertTrue((!GatewayDUnitTest.dsRegionListener.events.isEmpty() ? 1 : 0) != 0);
                    EventWrapper wrapper = (EventWrapper)GatewayDUnitTest.dsRegionListener.events.removeFirst();
                    TestCase.assertNotNull((Object)wrapper.key);
                    TestCase.assertNotNull((Object)wrapper.val);
                    TestCase.assertNotNull((Object)wrapper.arg);
                    TestCase.assertEquals((Object)"KEY-doTestRegionContainment", (Object)wrapper.key);
                    TestCase.assertEquals((Object)"VAL-doTestRegionContainment", (Object)wrapper.val);
                    TestCase.assertEquals((Object)"ARG-doTestRegionContainment", (Object)wrapper.arg);
                    TestCase.assertEquals((int)0, (int)wrapper.type);
                }
            });
        }
        for (i = 0; i < this.vmsDS1.length; ++i) {
            VM vm = this.vmsDS1[i];
            vm.invoke(new CacheSerializableRunnable("Verify nothing received"){

                @Override
                public void run2() throws CacheException {
                    TestCase.assertTrue((boolean)GatewayDUnitTest.dsRegionListener.events.isEmpty());
                }
            });
        }
    }

    private void doTestPutThenDestroy() throws Exception {
        int i;
        GatewayDUnitTest.getLogWriter().info("[GatewayDUnitTest] doTestPutThenDestroy");
        this.clearAllListeners();
        String key = "KEY-doTestPutThenDestroy";
        String val = "VAL-doTestPutThenDestroy";
        String arg = "ARG-doTestPutThenDestroy";
        this.vmPut(this.vmsDS0[0], WAN_REGION_NAME, "KEY-doTestPutThenDestroy", "VAL-doTestPutThenDestroy", "ARG-doTestPutThenDestroy");
        for (i = 0; i < this.vmsDS0.length; ++i) {
            this.vmAssertWanListener(this.vmsDS0[i], "KEY-doTestPutThenDestroy", "VAL-doTestPutThenDestroy", "ARG-doTestPutThenDestroy", 0);
        }
        for (i = 0; i < this.vmsDS1.length; ++i) {
            this.vmAssertWanListener(this.vmsDS1[i], "KEY-doTestPutThenDestroy", "VAL-doTestPutThenDestroy", "ARG-doTestPutThenDestroy", 0);
        }
        this.vmDestroy(this.vmsDS0[0], WAN_REGION_NAME, "KEY-doTestPutThenDestroy");
        for (i = 0; i < this.vmsDS1.length; ++i) {
            this.vmAssertWanListener(this.vmsDS1[i], "KEY-doTestPutThenDestroy", 3);
        }
        for (i = 0; i < this.vmsDS0.length; ++i) {
            this.vmAssertWanListener(this.vmsDS0[i], "KEY-doTestPutThenDestroy", 3);
        }
        this.waitForGatewayQueuesToEmpty();
    }

    private void DISABLED_TILL_NEW_TX_IMPL_COMPLETE_doTestTxPut() throws Exception {
        int i;
        GatewayDUnitTest.getLogWriter().info("[GatewayDUnitTest] doTestTxPut");
        this.clearAllListeners();
        String key = "KEY-doTestTxPut";
        String val = "VAL-doTestTxPut";
        Object arg = null;
        this.vmTxPut(this.vmsDS0[0], WAN_REGION_NAME, "KEY-doTestTxPut", "VAL-doTestTxPut", arg);
        for (i = 1; i < this.vmsDS0.length; ++i) {
            this.vmAssertTxWanListener(this.vmsDS0[i], "KEY-doTestTxPut", "VAL-doTestTxPut", 0);
        }
        for (i = 0; i < this.vmsDS1.length; ++i) {
            this.vmAssertWanListener(this.vmsDS1[i], "KEY-doTestTxPut", "VAL-doTestTxPut", null, 0);
        }
        this.waitForGatewayQueuesToEmpty();
    }

    private void doTestDestroyFromOther() throws Exception {
        int i;
        GatewayDUnitTest.getLogWriter().info("[GatewayDUnitTest] doTestDestroyFromOther");
        this.clearAllListeners();
        String key = "KEY-doTestDestroyFromOther";
        String val = "VAL-doTestDestroyFromOther";
        String arg = "ARG-doTestDestroyFromOther";
        this.vmPut(this.vmsDS0[0], WAN_REGION_NAME, "KEY-doTestDestroyFromOther", "VAL-doTestDestroyFromOther", "ARG-doTestDestroyFromOther");
        for (i = 0; i < this.vmsDS0.length; ++i) {
            this.vmAssertWanListener(this.vmsDS0[i], "KEY-doTestDestroyFromOther", "VAL-doTestDestroyFromOther", "ARG-doTestDestroyFromOther", 0);
        }
        for (i = 0; i < this.vmsDS1.length; ++i) {
            this.vmAssertWanListener(this.vmsDS1[i], "KEY-doTestDestroyFromOther", "VAL-doTestDestroyFromOther", "ARG-doTestDestroyFromOther", 0);
        }
        this.vmDestroy(this.vmsDS1[0], WAN_REGION_NAME, "KEY-doTestDestroyFromOther");
        for (i = 0; i < this.vmsDS1.length; ++i) {
            this.vmAssertWanListener(this.vmsDS1[i], "KEY-doTestDestroyFromOther", 3);
        }
        for (i = 0; i < this.vmsDS0.length; ++i) {
            this.vmAssertWanListener(this.vmsDS0[i], "KEY-doTestDestroyFromOther", 3);
        }
        this.waitForGatewayQueuesToEmpty();
    }

    private void doTestMultipleDestroy() throws Exception {
        int i;
        int i2;
        GatewayDUnitTest.getLogWriter().info("[GatewayDUnitTest] doTestMultipleDestroy");
        this.clearAllListeners();
        String key = "KEY-doTestMultipleDestroy";
        String val = "VAL-doTestMultipleDestroy";
        String arg = "ARG-doTestMultipleDestroy";
        int entryCount = 100;
        VM vmPut = this.vmsDS0[0];
        vmPut.invoke(new CacheSerializableRunnable("Perform puts"){

            @Override
            public void run2() throws CacheException {
                Region dsRegion = GatewayDUnitTest.this.getCache().getRegion(GatewayDUnitTest.WAN_REGION_NAME);
                for (int i = 0; i < 100; ++i) {
                    dsRegion.put((Object)("KEY-doTestMultipleDestroy" + i), (Object)("VAL-doTestMultipleDestroy" + i), (Object)("ARG-doTestMultipleDestroy" + i));
                }
            }
        });
        CacheSerializableRunnable assertPuts = new CacheSerializableRunnable("Verify receipt of puts"){

            @Override
            public void run2() throws CacheException {
                for (int i = 0; i < 100; ++i) {
                    GatewayDUnitTest.assertWanListener("KEY-doTestMultipleDestroy" + i, "VAL-doTestMultipleDestroy" + i, "ARG-doTestMultipleDestroy" + i, 0);
                }
            }
        };
        for (i2 = 0; i2 < this.vmsDS0.length; ++i2) {
            this.vmsDS0[i2].invoke(assertPuts);
        }
        for (i2 = 0; i2 < this.vmsDS1.length; ++i2) {
            this.vmsDS1[i2].invoke(assertPuts);
        }
        this.clearAllListeners();
        VM vmDestroy0 = this.vmsDS0[0];
        vmDestroy0.invokeAsync(new CacheSerializableRunnable("Perform destroys forewards"){

            @Override
            public void run2() throws CacheException {
                Region dsRegion = GatewayDUnitTest.this.getCache().getRegion(GatewayDUnitTest.WAN_REGION_NAME);
                try {
                    for (int i = 0; i < 100; ++i) {
                        dsRegion.destroy((Object)("KEY-doTestMultipleDestroy" + i));
                    }
                }
                catch (EntryNotFoundException entryNotFoundException) {
                    // empty catch block
                }
            }
        });
        VM vmDestroy1 = this.vmsDS1[0];
        vmDestroy1.invokeAsync(new CacheSerializableRunnable("Perform destroys backwards"){

            @Override
            public void run2() throws CacheException {
                Region dsRegion = GatewayDUnitTest.this.getCache().getRegion(GatewayDUnitTest.WAN_REGION_NAME);
                try {
                    for (int i = 99; i > -1; --i) {
                        dsRegion.destroy((Object)("KEY-doTestMultipleDestroy" + i));
                    }
                }
                catch (EntryNotFoundException entryNotFoundException) {
                    // empty catch block
                }
            }
        });
        this.waitForGatewayQueuesToEmpty();
        CacheSerializableRunnable assertDestroys = new CacheSerializableRunnable("Verify receipt of destroys"){

            @Override
            public void run2() throws CacheException {
                int i;
                HashSet<String> allKeys = new HashSet<String>();
                for (i = 0; i < 100; ++i) {
                    allKeys.add("KEY-doTestMultipleDestroy" + i);
                }
                for (i = 0; i < 100; ++i) {
                    wanRegionListener.waitWhileNoEvents(60000L);
                    TestCase.assertTrue((!GatewayDUnitTest.wanRegionListener.events.isEmpty() ? 1 : 0) != 0);
                    EventWrapper wrapper = (EventWrapper)GatewayDUnitTest.wanRegionListener.events.removeFirst();
                    TestCase.assertNotNull((Object)wrapper.key);
                    TestCase.assertEquals((int)3, (int)wrapper.type);
                    allKeys.remove(wrapper.key);
                }
                TestCase.assertTrue((boolean)allKeys.isEmpty());
            }
        };
        for (i = 0; i < this.vmsDS1.length; ++i) {
            this.vmsDS1[i].invoke(assertDestroys);
        }
        for (i = 0; i < this.vmsDS0.length; ++i) {
            this.vmsDS0[i].invoke(assertDestroys);
        }
        this.waitForGatewayQueuesToEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTestBatchWithException() throws Exception {
        GatewayDUnitTest.getLogWriter().info("[GatewayDUnitTest] doTestBatchWithException");
        this.clearAllListeners();
        String key = "KEY-doTestBatchWithException";
        String val = "VAL-doTestBatchWithException";
        String arg = "ARG-doTestBatchWithException";
        int entryCount = 20;
        VM hubVMDS0 = this.vmsDS0[this.vmsDS0.length - 1];
        VM hubVMDS1 = this.vmsDS1[this.vmsDS1.length - 1];
        CacheSerializableRunnable configureGatewayBatching = new CacheSerializableRunnable("configureGatewayBatching"){

            @Override
            public void run2() throws CacheException {
                List hubs = GatewayDUnitTest.this.getCache().getGatewayHubs();
                GatewayHub hub = (GatewayHub)hubs.get(0);
                hub.stop();
                Gateway gateway = (Gateway)hub.getGateways().iterator().next();
                GatewayQueueAttributes queueAttributes = gateway.getQueueAttributes();
                queueAttributes.setBatchSize(20);
                queueAttributes.setBatchTimeInterval(Integer.MAX_VALUE);
                try {
                    hub.start();
                }
                catch (IOException e) {
                    DistributedTestCase.getLogWriter().error("Start of hub " + hub.getId() + " threw " + e, (Throwable)e);
                    DistributedTestCase.fail("Start of hub " + hub.getId() + " threw " + e, e);
                }
            }
        };
        CacheSerializableRunnable restoreGatewayDefaults = new CacheSerializableRunnable("restoreGatewayDefaults"){

            @Override
            public void run2() throws CacheException {
                List hubs = GatewayDUnitTest.this.getCache().getGatewayHubs();
                GatewayHub hub = (GatewayHub)hubs.get(0);
                hub.stop();
                Gateway gateway = (Gateway)hub.getGateways().iterator().next();
                GatewayQueueAttributes queueAttributes = gateway.getQueueAttributes();
                queueAttributes.setBatchSize(100);
                queueAttributes.setBatchTimeInterval(1000);
                try {
                    hub.start();
                }
                catch (IOException e) {
                    DistributedTestCase.getLogWriter().error("Start of hub " + hub.getId() + " threw " + e, (Throwable)e);
                    DistributedTestCase.fail("Start of hub " + hub.getId() + " threw " + e, e);
                }
            }
        };
        try {
            int i;
            int i2;
            hubVMDS0.invoke(configureGatewayBatching);
            hubVMDS1.invoke(configureGatewayBatching);
            this.vmsDS0[0].invoke(new CacheSerializableRunnable("Perform puts"){

                @Override
                public void run2() throws CacheException {
                    Region wanRegion = GatewayDUnitTest.this.getCache().getRegion(GatewayDUnitTest.WAN_REGION_NAME);
                    for (int i = 0; i < 19; ++i) {
                        wanRegion.put((Object)("KEY-doTestBatchWithException" + i), (Object)("VAL-doTestBatchWithException" + i), (Object)("ARG-doTestBatchWithException" + i));
                    }
                }
            });
            for (int i3 = 0; i3 < this.vmsDS1.length; ++i3) {
                this.vmsDS1[i3].invoke(new CacheSerializableRunnable("Verify no events yet"){

                    @Override
                    public void run2() throws CacheException {
                        wanRegionListener.waitWhileNoEvents(1000L);
                        TestCase.assertTrue((boolean)GatewayDUnitTest.wanRegionListener.events.isEmpty());
                    }
                });
            }
            this.vmsDS0[0].invoke(new CacheSerializableRunnable("Perform last put"){

                @Override
                public void run2() throws CacheException {
                    Region wanRegion = GatewayDUnitTest.this.getCache().getRegion(GatewayDUnitTest.WAN_REGION_NAME);
                    int i = 19;
                    wanRegion.put((Object)("KEY-doTestBatchWithException" + i), (Object)("VAL-doTestBatchWithException" + i), (Object)("ARG-doTestBatchWithException" + i));
                }
            });
            CacheSerializableRunnable assertPuts = new CacheSerializableRunnable("Verify receipt of puts"){

                @Override
                public void run2() throws CacheException {
                    for (int i = 0; i < 20; ++i) {
                        GatewayDUnitTest.assertWanListener("KEY-doTestBatchWithException" + i, "VAL-doTestBatchWithException" + i, "ARG-doTestBatchWithException" + i, 0);
                    }
                }
            };
            for (i2 = 0; i2 < this.vmsDS0.length; ++i2) {
                this.vmsDS0[i2].invoke(assertPuts);
            }
            for (i2 = 0; i2 < this.vmsDS1.length; ++i2) {
                this.vmsDS1[i2].invoke(assertPuts);
            }
            this.clearAllListeners();
            CacheSerializableRunnable destroyWanRegion = new CacheSerializableRunnable("Destroy WAN Region"){

                @Override
                public void run2() throws CacheException {
                    Region wanRegion = GatewayDUnitTest.this.getCache().getRegion(GatewayDUnitTest.WAN_REGION_NAME);
                    wanRegion.localDestroyRegion();
                    GatewayDUnitTest.clearListeners();
                }
            };
            CacheSerializableRunnable recreateWanRegion = new CacheSerializableRunnable("Recreate WAN Region"){

                @Override
                public void run2() throws CacheException {
                    AttributesFactory factory = new AttributesFactory();
                    factory.setScope(Scope.DISTRIBUTED_ACK);
                    factory.setDataPolicy(DataPolicy.REPLICATE);
                    factory.setEnableWAN(true);
                    GatewayDUnitTest.this.getCache().getCacheTransactionManager().addListener((TransactionListener)wanTxListener);
                    factory.setCacheListener((CacheListener)wanRegionListener);
                    GatewayDUnitTest.this.getCache().createRegion(GatewayDUnitTest.WAN_REGION_NAME, factory.create());
                    GatewayDUnitTest.clearListeners();
                }
            };
            hubVMDS1.invoke(new CacheSerializableRunnable("Stop GatewayHub"){

                @Override
                public void run2() throws CacheException {
                    List hubs = GatewayDUnitTest.this.getCache().getGatewayHubs();
                    GatewayHub hub = (GatewayHub)hubs.get(0);
                    hub.stop();
                }
            });
            for (i = 0; i < this.vmsDS1.length; ++i) {
                this.vmsDS1[i].invoke(destroyWanRegion);
            }
            for (i = 0; i < this.vmsDS1.length; ++i) {
                this.vmsDS1[i].invoke(recreateWanRegion);
            }
            for (i = 0; i < this.vmsDS1.length; ++i) {
                this.vmsDS1[i].invoke(new CacheSerializableRunnable("Assert WAN region empty"){

                    @Override
                    public void run2() throws CacheException {
                        Region wanRegion = GatewayDUnitTest.this.getCache().getRegion(GatewayDUnitTest.WAN_REGION_NAME);
                        TestCase.assertEquals((String)"WAN region size should be zero", (int)0, (int)wanRegion.keys().size());
                    }
                });
            }
            hubVMDS1.invoke(new CacheSerializableRunnable("Restart GatewayHub"){

                @Override
                public void run2() throws CacheException {
                    List hubs = GatewayDUnitTest.this.getCache().getGatewayHubs();
                    GatewayHub hub = (GatewayHub)hubs.get(0);
                    try {
                        hub.start();
                    }
                    catch (IOException e) {
                        DistributedTestCase.getLogWriter().error("Start of hub " + hub.getId() + " threw " + e, (Throwable)e);
                        DistributedTestCase.fail("Start of hub " + hub.getId() + " threw " + e, e);
                    }
                }
            });
            this.vmsDS0[0].invoke(new CacheSerializableRunnable("Perform puts"){

                @Override
                public void run2() throws CacheException {
                    Region wanRegion = GatewayDUnitTest.this.getCache().getRegion(GatewayDUnitTest.WAN_REGION_NAME);
                    wanRegion.destroy((Object)"KEY-doTestBatchWithException0");
                    for (int i = 1; i < 20; ++i) {
                        int j = i * 100;
                        wanRegion.put((Object)("KEY-doTestBatchWithException" + j), (Object)("VAL-doTestBatchWithException" + j), (Object)("ARG-doTestBatchWithException" + j));
                    }
                }
            });
            this.waitForGatewayQueuesToEmpty();
            CacheSerializableRunnable assertNewPuts = new CacheSerializableRunnable("Verify receipt of newer puts"){

                @Override
                public void run2() throws CacheException {
                    for (int i = 0; i < 20; ++i) {
                        int j = i * 100;
                        GatewayDUnitTest.assertWanListener("KEY-doTestBatchWithException" + j, "VAL-doTestBatchWithException" + j, "ARG-doTestBatchWithException" + j, i == 0 ? 3 : 0);
                    }
                }
            };
            for (int i4 = 0; i4 < this.vmsDS1.length; ++i4) {
                this.vmsDS1[i4].invoke(assertNewPuts);
            }
        }
        finally {
            hubVMDS0.invoke(restoreGatewayDefaults);
            hubVMDS1.invoke(restoreGatewayDefaults);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTestQueuePersistence() throws Exception {
        GatewayDUnitTest.getLogWriter().info("[GatewayDUnitTest] doTestQueuePersistence");
        this.clearAllListeners();
        String key = "KEY-doTestQueuePersistence";
        String val = "VAL-doTestQueuePersistence";
        String arg = "ARG-doTestQueuePersistence";
        int entryCount = 20;
        VM hubVMDS0 = this.vmsDS0[this.vmsDS0.length - 1];
        VM hubVMDS1 = this.vmsDS1[this.vmsDS1.length - 1];
        CacheSerializableRunnable configureGatewayBatching = new CacheSerializableRunnable("configureGatewayBatching"){

            @Override
            public void run2() throws CacheException {
                List hubs = GatewayDUnitTest.this.getCache().getGatewayHubs();
                GatewayHub hub = (GatewayHub)hubs.get(0);
                hub.stop();
                Gateway gateway = (Gateway)hub.getGateways().iterator().next();
                GatewayQueueAttributes queueAttributes = gateway.getQueueAttributes();
                queueAttributes.setBatchSize(20);
                queueAttributes.setBatchTimeInterval(Integer.MAX_VALUE);
                queueAttributes.setEnablePersistence(true);
                gateway.setQueueAttributes(queueAttributes);
                try {
                    hub.start();
                }
                catch (IOException e) {
                    DistributedTestCase.getLogWriter().error("Start of hub " + hub.getId() + " threw " + e, (Throwable)e);
                    DistributedTestCase.fail("Start of hub " + hub.getId() + " threw " + e, e);
                }
            }
        };
        CacheSerializableRunnable restoreGatewayDefaults = new CacheSerializableRunnable("restoreGatewayDefaults"){

            @Override
            public void run2() throws CacheException {
                List hubs = GatewayDUnitTest.this.getCache().getGatewayHubs();
                GatewayHub hub = (GatewayHub)hubs.get(0);
                hub.stop();
                Gateway gateway = (Gateway)hub.getGateways().iterator().next();
                GatewayQueueAttributes queueAttributes = gateway.getQueueAttributes();
                queueAttributes.setBatchSize(100);
                queueAttributes.setBatchTimeInterval(1000);
                queueAttributes.setEnablePersistence(false);
                gateway.setQueueAttributes(queueAttributes);
                try {
                    hub.start();
                }
                catch (IOException e) {
                    DistributedTestCase.getLogWriter().error("Start of hub " + hub.getId() + " threw " + e, (Throwable)e);
                    TestCase.fail((String)("Start of hub " + hub.getId() + " threw " + e));
                }
            }
        };
        try {
            int i;
            hubVMDS0.invoke(configureGatewayBatching);
            hubVMDS1.invoke(configureGatewayBatching);
            this.vmStopHub(hubVMDS1);
            this.vmsDS0[0].invoke(new CacheSerializableRunnable("Perform puts"){

                @Override
                public void run2() throws CacheException {
                    Region wanRegion = GatewayDUnitTest.this.getCache().getRegion(GatewayDUnitTest.WAN_REGION_NAME);
                    for (int i = 0; i < 20; ++i) {
                        wanRegion.put((Object)("KEY-doTestQueuePersistence" + i), (Object)("VAL-doTestQueuePersistence" + i), (Object)("ARG-doTestQueuePersistence" + i));
                    }
                }
            });
            for (int i2 = 0; i2 < this.vmsDS1.length; ++i2) {
                this.vmsDS1[i2].invoke(new CacheSerializableRunnable("Verify no events yet"){

                    @Override
                    public void run2() throws CacheException {
                        wanRegionListener.waitWhileNoEvents(1000L);
                        TestCase.assertTrue((boolean)GatewayDUnitTest.wanRegionListener.events.isEmpty());
                    }
                });
            }
            CacheSerializableRunnable assertPuts = new CacheSerializableRunnable("Verify receipt of puts"){

                @Override
                public void run2() throws CacheException {
                    for (int i = 0; i < 20; ++i) {
                        GatewayDUnitTest.assertWanListener("KEY-doTestQueuePersistence" + i, "VAL-doTestQueuePersistence" + i, "ARG-doTestQueuePersistence" + i, 0);
                    }
                }
            };
            for (i = 0; i < this.vmsDS0.length; ++i) {
                this.vmsDS0[i].invoke(assertPuts);
            }
            this.vmStopHub(hubVMDS0);
            this.vmStartHub(hubVMDS0);
            this.vmStartHub(hubVMDS1);
            this.waitForGatewayQueuesToEmpty();
            for (i = 0; i < this.vmsDS1.length; ++i) {
                this.vmsDS1[i].invoke(assertPuts);
            }
        }
        finally {
            hubVMDS0.invoke(restoreGatewayDefaults);
            hubVMDS1.invoke(restoreGatewayDefaults);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTestQueuePersistenceFailover() throws Exception {
        String expected = "com.gemstone.gemfire.cache.RegionDestroyedException";
        String addExpected = "<ExpectedException action=add>com.gemstone.gemfire.cache.RegionDestroyedException</ExpectedException>";
        String removeExpected = "<ExpectedException action=remove>com.gemstone.gemfire.cache.RegionDestroyedException</ExpectedException>";
        GatewayDUnitTest.getLogWriter().info("[GatewayDUnitTest] doTestQueuePersistenceFailover");
        this.clearAllListeners();
        GatewayDUnitTest.getLogWriter().info("[GatewayDUnitTest] after clear all listeners");
        String key = "KEY-doTestQueuePersistenceFailover";
        String val = "VAL-doTestQueuePersistenceFailover";
        String arg = "ARG-doTestQueuePersistenceFailover";
        int entryCount = 20;
        boolean hubVMDS0_Secondary_vmNumber = false;
        boolean hubVMDS1_Secondary_vmNumber = false;
        VM hubVMDS0 = this.vmsDS0[this.vmsDS0.length - 1];
        VM hubVMDS0_Secondary = this.vmsDS0[0];
        VM hubVMDS1 = this.vmsDS1[this.vmsDS1.length - 1];
        VM hubVMDS1_Secondary = this.vmsDS1[0];
        int[] freePorts = AvailablePortHelper.getRandomAvailableTCPPorts(2);
        int hubVMDS0_Secondary_port = freePorts[0];
        int hubVMDS1_Secondary_port = freePorts[1];
        CacheSerializableRunnable configureGatewayBatching = new CacheSerializableRunnable("configureGatewayBatching"){

            @Override
            public void run2() throws CacheException {
                List hubs = GatewayDUnitTest.this.getCache().getGatewayHubs();
                GatewayHub hub = (GatewayHub)hubs.get(0);
                hub.stop();
                Gateway gateway = (Gateway)hub.getGateways().iterator().next();
                GatewayQueueAttributes queueAttributes = gateway.getQueueAttributes();
                queueAttributes.setBatchSize(20);
                queueAttributes.setBatchTimeInterval(Integer.MAX_VALUE);
                queueAttributes.setEnablePersistence(true);
                gateway.setQueueAttributes(queueAttributes);
                try {
                    hub.start();
                }
                catch (IOException e) {
                    DistributedTestCase.getLogWriter().error("Start of hub " + hub.getId() + " threw " + e, (Throwable)e);
                    TestCase.fail((String)("Start of hub " + hub.getId() + " threw " + e));
                }
            }
        };
        CacheSerializableRunnable restoreGatewayDefaults = new CacheSerializableRunnable("restoreGatewayDefaults"){

            @Override
            public void run2() throws CacheException {
                List hubs = GatewayDUnitTest.this.getCache().getGatewayHubs();
                GatewayHub hub = (GatewayHub)hubs.get(0);
                hub.stop();
                Gateway gateway = (Gateway)hub.getGateways().iterator().next();
                GatewayQueueAttributes queueAttributes = gateway.getQueueAttributes();
                queueAttributes.setBatchSize(100);
                queueAttributes.setBatchTimeInterval(1000);
                queueAttributes.setEnablePersistence(false);
                gateway.setQueueAttributes(queueAttributes);
                try {
                    hub.start();
                }
                catch (IOException e) {
                    DistributedTestCase.getLogWriter().error("Start of hub " + hub.getId() + " threw " + e, (Throwable)e);
                    TestCase.fail((String)("Start of hub " + hub.getId() + " threw " + e));
                }
            }
        };
        CacheSerializableRunnable createSecondaryGateway = new CacheSerializableRunnable("createSecondaryGateway"){

            @Override
            public void run2() throws CacheException {
                List hubs = GatewayDUnitTest.this.getCache().getGatewayHubs();
                GatewayHub hub = (GatewayHub)hubs.get(0);
                hub.stop();
                Gateway gateway = (Gateway)hub.getGateways().iterator().next();
                GatewayQueueAttributes queueAttributes = gateway.getQueueAttributes();
                queueAttributes.setBatchSize(100);
                queueAttributes.setBatchTimeInterval(1000);
                queueAttributes.setEnablePersistence(true);
                gateway.setQueueAttributes(queueAttributes);
                try {
                    hub.start();
                }
                catch (IOException e) {
                    DistributedTestCase.getLogWriter().error("Start of hub " + hub.getId() + " threw " + e, (Throwable)e);
                    TestCase.fail((String)("Start of hub " + hub.getId() + " threw " + e));
                }
            }
        };
        VM gatewayDUnitTest_ds1_vm1 = Host.getHost(0).getVM(3);
        boolean done = false;
        try {
            int i;
            hubVMDS0.invoke(configureGatewayBatching);
            GatewayDUnitTest.getLogWriter().info("[GatewayDUnitTest] after hubVMDS0.invoke(configureGatewayBatching)");
            hubVMDS1.invoke(configureGatewayBatching);
            GatewayDUnitTest.getLogWriter().info("[GatewayDUnitTest] after hubVMDS1.invoke(configureGatewayBatching)");
            String nameDS1 = "ds1";
            String hostDS1 = (String)hubVMDS1.invoke(GatewayDUnitTest.class, "getHostName");
            GatewayDUnitTest.getLogWriter().info("[GatewayDUnitTest] after hubVMDS1 getHostName");
            int portDS1 = hubVMDS1.invokeInt(GatewayDUnitTest.class, "getHubPort");
            GatewayDUnitTest.getLogWriter().info("[GatewayDUnitTest] after hubVMDS1 getHubPort");
            this.vmCreateGateway(hubVMDS0_Secondary, "ds0", 0, hubVMDS0_Secondary_port, "ds1", hostDS1, new int[]{portDS1, hubVMDS1_Secondary_port}, true);
            GatewayDUnitTest.getLogWriter().info("[GatewayDUnitTest] after vmCreateGateway ds0");
            hubVMDS0_Secondary.invoke(configureGatewayBatching);
            GatewayDUnitTest.getLogWriter().info("[GatewayDUnitTest] after hubVMDS0_Secondary.invoke(configureGatewayBatching)");
            String nameDS0 = "ds0";
            String hostDS0 = (String)hubVMDS0.invoke(GatewayDUnitTest.class, "getHostName");
            int portDS0 = hubVMDS0.invokeInt(GatewayDUnitTest.class, "getHubPort");
            this.vmCreateGateway(hubVMDS1_Secondary, "ds1", 0, hubVMDS1_Secondary_port, "ds0", hostDS0, new int[]{portDS0, hubVMDS0_Secondary_port}, true);
            GatewayDUnitTest.getLogWriter().info("[GatewayDUnitTest] after vmCreateGateway ds1");
            hubVMDS1_Secondary.invoke(configureGatewayBatching);
            GatewayDUnitTest.getLogWriter().info("[GatewayDUnitTest] after hubVMDS1_Secondary.invoke(configureGatewayBatching)");
            this.vmStopHub(hubVMDS1);
            GatewayDUnitTest.getLogWriter().info("[GatewayDUnitTest] after vmStopHub(hubVMDS1)");
            this.vmStopHub(hubVMDS1_Secondary);
            GatewayDUnitTest.getLogWriter().info("[GatewayDUnitTest] after vmStopHub(hubVMDS1_Secondary)");
            this.vmsDS0[0].invoke(new CacheSerializableRunnable("Perform puts"){

                @Override
                public void run2() throws CacheException {
                    Region wanRegion = GatewayDUnitTest.this.getCache().getRegion(GatewayDUnitTest.WAN_REGION_NAME);
                    for (int i = 0; i < 20; ++i) {
                        wanRegion.put((Object)("KEY-doTestQueuePersistenceFailover" + i), (Object)("VAL-doTestQueuePersistenceFailover" + i), (Object)("ARG-doTestQueuePersistenceFailover" + i));
                    }
                }
            });
            GatewayDUnitTest.getLogWriter().info("[GatewayDUnitTest] after perform puts");
            for (int i2 = 0; i2 < this.vmsDS1.length; ++i2) {
                this.vmsDS1[i2].invoke(new CacheSerializableRunnable("Verify no events yet"){

                    @Override
                    public void run2() throws CacheException {
                        wanRegionListener.waitWhileNoEvents(1000L);
                        TestCase.assertTrue((boolean)GatewayDUnitTest.wanRegionListener.events.isEmpty());
                    }
                });
            }
            GatewayDUnitTest.getLogWriter().info("[GatewayDUnitTest] after verify");
            CacheSerializableRunnable assertPuts = new CacheSerializableRunnable("Verify receipt of puts"){

                @Override
                public void run2() throws CacheException {
                    wanRegionListener.waitWhileNotEnoughEvents(60000L, 20);
                    TestCase.assertEquals((int)20, (int)GatewayDUnitTest.wanRegionListener.events.size());
                    for (int i = 0; i < 20; ++i) {
                        GatewayDUnitTest.assertWanListenerNow("KEY-doTestQueuePersistenceFailover" + i, "VAL-doTestQueuePersistenceFailover" + i, "ARG-doTestQueuePersistenceFailover" + i, 0);
                    }
                }
            };
            for (i = 0; i < this.vmsDS0.length; ++i) {
                this.vmsDS0[i].invoke(assertPuts);
                GatewayDUnitTest.getLogWriter().info("[GatewayDUnitTest] after assertPuts#" + i);
            }
            this.vmStopHub(hubVMDS0);
            GatewayDUnitTest.getLogWriter().info("[GatewayDUnitTest] after vmStopHub(hubVMDS0)");
            this.vmStopHub(hubVMDS0_Secondary);
            GatewayDUnitTest.getLogWriter().info("[GatewayDUnitTest] after vmStopHub(hubVMDS0_Secondary)");
            this.vmStartHub(hubVMDS0_Secondary);
            GatewayDUnitTest.getLogWriter().info("[GatewayDUnitTest] after vmStartHub(hubVMDS0_Secondary)");
            this.addExpected(gatewayDUnitTest_ds1_vm1, "<ExpectedException action=add>com.gemstone.gemfire.cache.RegionDestroyedException</ExpectedException>");
            this.vmStartHub(hubVMDS1_Secondary);
            GatewayDUnitTest.getLogWriter().info("[GatewayDUnitTest] after vmStartHub(hubVMDS1_Secondary)");
            this.waitForGatewayQueuesToEmpty();
            for (i = 0; i < this.vmsDS1.length; ++i) {
                this.vmsDS1[i].invoke(assertPuts);
                GatewayDUnitTest.getLogWriter().info("[GatewayDUnitTest] after vmsDS1[" + i + "] assertPuts");
            }
            done = true;
        }
        finally {
            block11: {
                this.removeExpected(gatewayDUnitTest_ds1_vm1, "<ExpectedException action=remove>com.gemstone.gemfire.cache.RegionDestroyedException</ExpectedException>");
                try {
                    this.vmStopHub(hubVMDS0_Secondary);
                    GatewayDUnitTest.getLogWriter().info("[GatewayDUnitTest] after vmStopHub(hubVMDS0_Secondary)");
                    this.vmStopHub(hubVMDS1_Secondary);
                    GatewayDUnitTest.getLogWriter().info("[GatewayDUnitTest] after vmStopHub(hubVMDS1_Secondary)");
                    hubVMDS0.invoke(restoreGatewayDefaults);
                    GatewayDUnitTest.getLogWriter().info("[GatewayDUnitTest] after hubVMDS0.invoke(restoreGatewayDefaults)");
                    hubVMDS1.invoke(restoreGatewayDefaults);
                    GatewayDUnitTest.getLogWriter().info("[GatewayDUnitTest] after hubVMDS1.invoke(restoreGatewayDefaults)");
                }
                catch (Exception e) {
                    if (!done) break block11;
                    throw e;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRegionNotFound() throws Exception {
        int j;
        int i;
        int i2;
        int i3;
        GatewayDUnitTest.getLogWriter().info("[GatewayDUnitTest] doRegionNotFound");
        this.clearAllListeners();
        String key = "KEY-doRegionNotFound";
        String val = "VAL-doRegionNotFound";
        String arg = "ARG-doRegionNotFound";
        int entryCount = 10;
        CacheSerializableRunnable destroyWanRegion = new CacheSerializableRunnable("Destroy WAN Region"){

            @Override
            public void run2() throws CacheException {
                Region wanRegion = GatewayDUnitTest.this.getCache().getRegion(GatewayDUnitTest.WAN_REGION_NAME);
                wanRegion.localDestroyRegion();
                GatewayDUnitTest.clearListeners();
            }
        };
        CacheSerializableRunnable recreateWanRegion = new CacheSerializableRunnable("Recreate WAN Region"){

            @Override
            public void run2() throws CacheException {
                AttributesFactory factory = new AttributesFactory();
                factory.setScope(Scope.DISTRIBUTED_ACK);
                factory.setDataPolicy(DataPolicy.REPLICATE);
                factory.setEnableWAN(true);
                GatewayDUnitTest.this.getCache().getCacheTransactionManager().addListener((TransactionListener)wanTxListener);
                factory.setCacheListener((CacheListener)wanRegionListener);
                GatewayDUnitTest.this.getCache().createRegion(GatewayDUnitTest.WAN_REGION_NAME, factory.create());
                GatewayDUnitTest.clearListeners();
            }
        };
        for (i3 = 0; i3 < this.vmsDS0.length; ++i3) {
            this.vmsDS0[i3].invoke(destroyWanRegion);
        }
        for (i3 = 0; i3 < this.vmsDS1.length; ++i3) {
            this.vmsDS1[i3].invoke(destroyWanRegion);
        }
        for (i3 = 0; i3 < this.vmsDS0.length; ++i3) {
            this.vmsDS0[i3].invoke(recreateWanRegion);
        }
        for (i3 = 0; i3 < this.vmsDS1.length; ++i3) {
            this.vmsDS1[i3].invoke(recreateWanRegion);
        }
        CacheSerializableRunnable doPuts = new CacheSerializableRunnable("Perform puts"){

            @Override
            public void run2() throws CacheException {
                Region dsRegion = GatewayDUnitTest.this.getCache().getRegion(GatewayDUnitTest.WAN_REGION_NAME);
                for (int i = 0; i < 10; ++i) {
                    dsRegion.put((Object)("KEY-doRegionNotFound" + i), (Object)("VAL-doRegionNotFound" + i), (Object)("ARG-doRegionNotFound" + i));
                }
            }
        };
        this.vmsDS0[0].invoke(doPuts);
        CacheSerializableRunnable assertCreates = new CacheSerializableRunnable("Verify receipt of creates"){

            @Override
            public void run2() throws CacheException {
                for (int i = 0; i < 10; ++i) {
                    GatewayDUnitTest.assertWanListener("KEY-doRegionNotFound" + i, "VAL-doRegionNotFound" + i, "ARG-doRegionNotFound" + i, 0);
                }
            }
        };
        for (i2 = 0; i2 < this.vmsDS0.length; ++i2) {
            this.vmsDS0[i2].invoke(assertCreates);
        }
        for (i2 = 0; i2 < this.vmsDS1.length; ++i2) {
            this.vmsDS1[i2].invoke(assertCreates);
        }
        for (i2 = 0; i2 < this.vmsDS1.length; ++i2) {
            this.vmsDS1[i2].invoke(destroyWanRegion);
        }
        String[] expectedExceptions = new String[]{"com.gemstone.gemfire.cache.RegionDestroyedException", "com.gemstone.gemfire.internal.cache.tier.BatchException", "com.gemstone.gemfire.cache.client.ServerOperationException"};
        for (i = 0; i < this.vmsDS0.length; ++i) {
            for (j = 0; j < expectedExceptions.length; ++j) {
                this.addExpected(this.vmsDS0[i], "<ExpectedException action=add>" + expectedExceptions[j] + "</ExpectedException>");
            }
        }
        for (i = 0; i < this.vmsDS1.length; ++i) {
            for (j = 0; j < expectedExceptions.length; ++j) {
                this.addExpected(this.vmsDS1[i], "<ExpectedException action=add>" + expectedExceptions[j] + "</ExpectedException>");
            }
        }
        try {
            this.vmsDS0[0].invoke(doPuts);
            CacheSerializableRunnable assertUpdates = new CacheSerializableRunnable("Verify receipt of updates"){

                @Override
                public void run2() throws CacheException {
                    for (int i = 0; i < 10; ++i) {
                        GatewayDUnitTest.assertWanListener("KEY-doRegionNotFound" + i, "VAL-doRegionNotFound" + i, "ARG-doRegionNotFound" + i, 1);
                    }
                }
            };
            for (int i4 = 0; i4 < this.vmsDS0.length; ++i4) {
                this.vmsDS0[i4].invoke(assertUpdates);
            }
            this.waitForGatewayQueuesToEmpty();
        }
        finally {
            int i5;
            for (i5 = 0; i5 < this.vmsDS0.length; ++i5) {
                for (j = 0; j < expectedExceptions.length; ++j) {
                    this.addExpected(this.vmsDS0[i5], "<ExpectedException action=remove>" + expectedExceptions[j] + "</ExpectedException>");
                }
            }
            for (i5 = 0; i5 < this.vmsDS1.length; ++i5) {
                for (j = 0; j < expectedExceptions.length; ++j) {
                    this.addExpected(this.vmsDS1[i5], "<ExpectedException action=remove>" + expectedExceptions[j] + "</ExpectedException>");
                }
            }
        }
    }

    private void addExpected(VM vm, final String addExpected) {
        vm.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                GatewayDUnitTest.this.getCache().getLogger().info(addExpected);
            }
        });
    }

    private void removeExpected(VM vm, final String removeExpected) {
        vm.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                GatewayDUnitTest.this.getCache().getLogger().info(removeExpected);
            }
        });
    }

    private void waitForGatewayQueuesToEmpty() {
        CacheSerializableRunnable waitForQueueToDrain = new CacheSerializableRunnable("waitForQueueToDrain"){

            @Override
            public void run2() throws CacheException {
                List hubs = GatewayDUnitTest.this.getCache().getGatewayHubs();
                GatewayHub hub = (GatewayHub)hubs.get(0);
                for (final Gateway gateway : hub.getGateways()) {
                    DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

                        @Override
                        public boolean done() {
                            return !gateway.isRunning() || gateway.getQueueSize() == 0;
                        }

                        @Override
                        public String description() {
                            return "Waiting on gateway " + gateway;
                        }
                    };
                    DistributedTestCase.waitForCriterion(ev, 60000L, 200L, true);
                }
            }
        };
        VM hubVMDS0 = this.vmsDS0[this.vmsDS0.length - 1];
        VM hubVMDS1 = this.vmsDS1[this.vmsDS1.length - 1];
        hubVMDS0.invoke(waitForQueueToDrain);
        hubVMDS1.invoke(waitForQueueToDrain);
    }

    private void doTestEarlyAckUnsupported() throws Exception {
        GatewayDUnitTest.getLogWriter().info("[GatewayDUnitTest] doTestEarlyAckNotAllowed");
        VM hubVMDS0 = this.vmsDS0[this.vmsDS0.length - 1];
        VM hubVMDS1 = this.vmsDS1[this.vmsDS1.length - 1];
        CacheSerializableRunnable makeEarlyAck = new CacheSerializableRunnable("makeEarlyAck"){

            @Override
            public void run2() throws CacheException {
                List hubs = GatewayDUnitTest.this.getCache().getGatewayHubs();
                GatewayHub hub = (GatewayHub)hubs.get(0);
                hub.stop();
                Gateway gateway = (Gateway)hub.getGateways().iterator().next();
                try {
                    gateway.setEarlyAck(true);
                    TestCase.fail((String)"Gateway setEarlyAck(true) should throw UnsupportedOperationException");
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    // empty catch block
                }
                try {
                    hub.start();
                }
                catch (IOException e) {
                    DistributedTestCase.getLogWriter().error("Start of hub " + hub.getId() + " threw " + e, (Throwable)e);
                    TestCase.fail((String)("Start of hub " + hub.getId() + " threw " + e));
                }
            }
        };
        hubVMDS0.invoke(makeEarlyAck);
        hubVMDS1.invoke(makeEarlyAck);
    }

    private void doTestSetSocketReadTimeout() throws Exception {
        GatewayDUnitTest.getLogWriter().info("[GatewayDUnitTest] doTestSetSocketReadTimeout");
        VM hubVMDS0 = this.vmsDS0[this.vmsDS0.length - 1];
        VM hubVMDS1 = this.vmsDS1[this.vmsDS1.length - 1];
        CacheSerializableRunnable setSocketReadTimeout = new CacheSerializableRunnable("setSocketReadTimeout"){

            @Override
            public void run2() throws CacheException {
                List hubs = GatewayDUnitTest.this.getCache().getGatewayHubs();
                GatewayHub hub = (GatewayHub)hubs.get(0);
                hub.stop();
                Gateway gateway = (Gateway)hub.getGateways().iterator().next();
                gateway.setSocketReadTimeout(10000);
                TestCase.assertEquals((String)"Gateway setSocketReadTimeout should do nothing", (int)0, (int)gateway.getSocketReadTimeout());
                try {
                    hub.start();
                }
                catch (IOException e) {
                    DistributedTestCase.getLogWriter().error("Start of hub " + hub.getId() + " threw " + e, (Throwable)e);
                    DistributedTestCase.fail("Start of hub " + hub.getId() + " threw " + e, e);
                }
            }
        };
        hubVMDS0.invoke(setSocketReadTimeout);
        hubVMDS1.invoke(setSocketReadTimeout);
    }

    private void doTestHubStopStart() throws Exception {
        int i;
        GatewayDUnitTest.getLogWriter().info("[GatewayDUnitTest] doTestHubStopStart");
        this.clearAllListeners();
        String key = "KEY-doTestHubStopStart";
        String val = "VAL-doTestHubStopStart";
        String arg = "ARG-doTestHubStopStart";
        VM hubVMDS0 = this.vmsDS0[this.vmsDS0.length - 1];
        VM hubVMDS1 = this.vmsDS1[this.vmsDS1.length - 1];
        this.vmStopHub(hubVMDS0);
        this.vmStartHub(hubVMDS0);
        this.vmStopHub(hubVMDS1);
        this.vmPut(this.vmsDS0[0], WAN_REGION_NAME, "KEY-doTestHubStopStart", "VAL-doTestHubStopStart", "ARG-doTestHubStopStart");
        for (i = 0; i < this.vmsDS0.length; ++i) {
            this.vmAssertWanListener(this.vmsDS0[i], "KEY-doTestHubStopStart", "VAL-doTestHubStopStart", "ARG-doTestHubStopStart", 0);
        }
        for (i = 0; i < this.vmsDS1.length; ++i) {
            this.vmsDS1[i].invoke(new CacheSerializableRunnable("Verify no events yet"){

                @Override
                public void run2() throws CacheException {
                    wanRegionListener.waitWhileNoEvents(1000L);
                    TestCase.assertTrue((boolean)GatewayDUnitTest.wanRegionListener.events.isEmpty());
                }
            });
        }
        this.vmStartHub(hubVMDS1);
        this.waitForGatewayQueuesToEmpty();
        for (i = 0; i < this.vmsDS1.length; ++i) {
            this.vmsDS1[i].invoke(new CacheSerializableRunnable("Clear out events"){

                @Override
                public void run2() throws CacheException {
                    wanRegionListener.waitWhileNoEvents(60000L);
                    GatewayDUnitTest.clearListeners();
                }
            });
        }
    }

    private void vmPut(VM vm, final String regionName, final Object key, final Object val, final Object arg) throws Exception {
        vm.invoke(new CacheSerializableRunnable("vmPut"){

            @Override
            public void run2() throws CacheException {
                Region dsRegion = GatewayDUnitTest.this.getCache().getRegion(regionName);
                dsRegion.put(key, val, arg);
            }
        });
    }

    private void vmTxPut(VM vm, final String regionName, final Object key, final Object val, final Object arg) throws Exception {
        vm.invoke(new CacheSerializableRunnable("vmTxPut"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run2() throws CacheException {
                Region dsRegion = GatewayDUnitTest.this.getCache().getRegion(regionName);
                String dsName = dsRegion.getName();
                RegionAttributes ra = dsRegion.getAttributes();
                AttributesFactory af = new AttributesFactory(ra);
                af.setDataPolicy(DataPolicy.EMPTY);
                ra = af.create();
                Region parent = dsRegion.getParentRegion();
                dsRegion.localDestroyRegion();
                dsRegion = parent == null ? GatewayDUnitTest.this.getCache().createRegion(dsName, ra) : parent.createSubregion(dsName, ra);
                GatewayDUnitTest.this.getCache().getCacheTransactionManager().begin();
                try {
                    dsRegion.put(key, val, arg);
                }
                finally {
                    GatewayDUnitTest.this.getCache().getCacheTransactionManager().commit();
                }
            }
        });
    }

    private void vmDestroy(VM vm, final String regionName, final Object key) throws Exception {
        vm.invoke(new CacheSerializableRunnable("vmDestroy"){

            @Override
            public void run2() throws CacheException {
                Region dsRegion = GatewayDUnitTest.this.getCache().getRegion(regionName);
                dsRegion.destroy(key);
            }
        });
    }

    private void vmAssertWanListener(VM vm, final Object key, final Object val, final Object arg, final int type) throws Exception {
        vm.invoke(new CacheSerializableRunnable("vmAssertWanListener"){

            @Override
            public void run2() throws CacheException {
                GatewayDUnitTest.assertWanListener(key, val, arg, type);
            }
        });
    }

    private void vmAssertWanListener(VM vm, final Object key, final int type) throws Exception {
        vm.invoke(new CacheSerializableRunnable("vmAssertWanListener"){

            @Override
            public void run2() throws CacheException {
                GatewayDUnitTest.assertWanListener(key, type);
            }
        });
    }

    private void vmAssertTxWanListener(VM vm, final Object key, final Object val, final int type) throws Exception {
        vm.invoke(new CacheSerializableRunnable("vmAssertTxWanListener"){

            @Override
            public void run2() throws CacheException {
                GatewayDUnitTest.assertTxWanListener(key, val, type);
            }
        });
    }

    private static String getSystemName() throws Exception {
        return InternalDistributedSystem.getAnyInstance().getName();
    }

    private static String getHostName() throws Exception {
        String hostName = System.getProperty("gemfire.bind-address");
        if (hostName == null) {
            try {
                hostName = DistributedTestCase.getIPLiteral();
            }
            catch (Exception e) {
                GatewayDUnitTest.getLogWriter().error("InetAddress threw Exception", (Throwable)e);
                GatewayDUnitTest.fail((String)("InetAddress threw Exception" + e.getMessage()));
            }
        }
        return hostName;
    }

    private static int getHubPort() throws Exception {
        Cache c = CacheFactory.getAnyInstance();
        List hubs = c.getGatewayHubs();
        GatewayHub hub = (GatewayHub)hubs.get(0);
        return hub.getPort();
    }

    private void vmStopHub(VM vm) throws Exception {
        GatewayDUnitTest.assertNotNull((String)"vmStopHub called with null vm", (Object)vm);
        vm.invoke(new CacheSerializableRunnable("vmStopHub"){

            @Override
            public void run2() throws CacheException {
                Cache cache = GatewayDUnitTest.this.getCache();
                TestCase.assertNotNull((String)"getCache returned null for vmStopHub", (Object)cache);
                List hubs = GatewayDUnitTest.this.getCache().getGatewayHubs();
                TestCase.assertTrue((String)"no hubs for vmStopHub", (hubs.size() > 0 ? 1 : 0) != 0);
                GatewayHub hub = (GatewayHub)hubs.get(0);
                hub.stop();
            }
        });
    }

    private void vmStartHub(VM vm) throws Exception {
        vm.invoke(new CacheSerializableRunnable("vmStartHub"){

            @Override
            public void run2() throws CacheException {
                List hubs = GatewayDUnitTest.this.getCache().getGatewayHubs();
                GatewayHub hub = (GatewayHub)hubs.get(0);
                try {
                    hub.start();
                }
                catch (IOException e) {
                    DistributedTestCase.getLogWriter().error("Start of hub " + hub.getId() + " threw " + e, (Throwable)e);
                    DistributedTestCase.fail("Start of hub " + hub.getId() + " threw " + e, e);
                }
            }
        });
    }

    private void clearAllListeners() {
        GatewayDUnitTest.invokeInEveryVM(GatewayDUnitTest.class, "clearListeners");
    }

    protected static void clearListeners() {
        wanRegionListener.clear();
        wanTxListener.clear();
        dsRegionListener.clear();
    }

    private void vmCreateGateway(VM vm, final String dsName, final int whichvm, final int hubPortLocal, final String dsNameRemote, final String hostNameRemote, final int[] hubPortRemotes, final boolean enablePersistence) throws Exception {
        vm.invoke(new CacheSerializableRunnable("vmCreateGateway"){

            @Override
            public void run2() throws CacheException {
                String vmName = GatewayDUnitTest.this.getSimpleName() + "_" + dsName + "_vm" + whichvm;
                String hubName = GatewayDUnitTest.this.getSimpleName() + "_" + dsName;
                String gatewayName = GatewayDUnitTest.this.getSimpleName() + "_" + dsNameRemote;
                DistributedTestCase.getLogWriter().info("[GatewayDUnitTest] " + vmName + " is creating " + hubName + " with gateway to " + gatewayName);
                Cache cache = GatewayDUnitTest.this.getCache();
                GatewayHub hub = cache.setGatewayHub(hubName, hubPortLocal);
                Gateway gateway = GatewayDUnitTest.this.addGateway(hub, gatewayName);
                for (int i = 0; i < hubPortRemotes.length; ++i) {
                    DistributedTestCase.getLogWriter().info("[GatewayDUnitTest] " + vmName + " adding endpoint [" + gatewayName + ", " + hostNameRemote + ", " + hubPortRemotes[i] + "] to " + gatewayName);
                    gateway.addEndpoint(gatewayName + i, hostNameRemote, hubPortRemotes[i]);
                }
                File d = new File(gatewayName + "_overflow_" + OSProcess.getId());
                DistributedTestCase.getLogWriter().info("[GatewayDUnitTest] " + vmName + " creating queue in " + d + " for " + gatewayName);
                GatewayQueueAttributes queueAttributes = new GatewayQueueAttributes(d.toString(), 100, 100, 1000, false, enablePersistence, true, 0);
                gateway.setQueueAttributes(queueAttributes);
                try {
                    hub.start();
                }
                catch (IOException e) {
                    DistributedTestCase.getLogWriter().error("Start of hub " + hubName + " threw " + e, (Throwable)e);
                    DistributedTestCase.fail("Start of hub " + hubName + " threw " + e, e);
                }
                DistributedTestCase.getLogWriter().info("[GatewayDUnitTest] " + vmName + " has created " + hubName + " with gateway to " + gatewayName);
            }
        });
    }

    protected static void assertWanListener(Object key, int type) {
        wanRegionListener.waitWhileNoEvents(60000L);
        GatewayDUnitTest.assertTrue((!GatewayDUnitTest.wanRegionListener.events.isEmpty() ? 1 : 0) != 0);
        EventWrapper wrapper = (EventWrapper)GatewayDUnitTest.wanRegionListener.events.removeFirst();
        GatewayDUnitTest.assertNotNull((String)"Event key is null", (Object)wrapper.key);
        GatewayDUnitTest.assertEquals((String)"Event key not equal", (Object)key, (Object)wrapper.key);
        GatewayDUnitTest.assertEquals((String)"Event type not equal", (int)3, (int)wrapper.type);
    }

    protected static void assertWanListener(Object key, Object val, Object arg, int type) {
        wanRegionListener.waitWhileNoEvents(60000L);
        GatewayDUnitTest.assertTrue((!GatewayDUnitTest.wanRegionListener.events.isEmpty() ? 1 : 0) != 0);
        EventWrapper wrapper = (EventWrapper)GatewayDUnitTest.wanRegionListener.events.removeFirst();
        GatewayDUnitTest.getLogWriter().info("processing wrapper: " + wrapper);
        GatewayDUnitTest.assertNotNull((String)"Event key is null", (Object)wrapper.key);
        GatewayDUnitTest.assertEquals((String)"Event key not equal", (Object)key, (Object)wrapper.key);
        GatewayDUnitTest.assertEquals((String)"Event type not equal", (int)type, (int)wrapper.type);
        if (wrapper.type != 3) {
            GatewayDUnitTest.assertNotNull((String)"Event val is null", (Object)wrapper.val);
            GatewayDUnitTest.assertEquals((String)"Event val not equal", (Object)val, (Object)wrapper.val);
            GatewayDUnitTest.assertEquals((String)"Event arg not equal", (Object)arg, (Object)wrapper.arg);
        }
    }

    protected static void assertTxWanListener(Object key, Object val, int type) {
        wanTxListener.waitWhileNoEvents(60000L);
        GatewayDUnitTest.assertTrue((!GatewayDUnitTest.wanTxListener.events.isEmpty() ? 1 : 0) != 0);
        EventWrapper wrapper = (EventWrapper)GatewayDUnitTest.wanTxListener.events.removeFirst();
        GatewayDUnitTest.assertNotNull((String)"Event key is null", (Object)wrapper.key);
        GatewayDUnitTest.assertNotNull((String)"Event val is null", (Object)wrapper.val);
        GatewayDUnitTest.assertEquals((String)"Event key not equal", (Object)key, (Object)wrapper.key);
        GatewayDUnitTest.assertEquals((String)"Event val not equal", (Object)val, (Object)wrapper.val);
        GatewayDUnitTest.assertEquals((String)"Event arg not equal", null, (Object)wrapper.arg);
        GatewayDUnitTest.assertEquals((String)"Event type not equal", (int)type, (int)wrapper.type);
    }

    protected static void assertWanListenerNow(Object key, Object val, Object arg, int type) {
        GatewayDUnitTest.assertTrue((!GatewayDUnitTest.wanRegionListener.events.isEmpty() ? 1 : 0) != 0);
        EventWrapper wrapper = (EventWrapper)GatewayDUnitTest.wanRegionListener.events.removeFirst();
        GatewayDUnitTest.assertNotNull((String)"Event key is null", (Object)wrapper.key);
        GatewayDUnitTest.assertNotNull((String)"Event val is null", (Object)wrapper.val);
        GatewayDUnitTest.assertEquals((String)"Event key not equal", (Object)key, (Object)wrapper.key);
        GatewayDUnitTest.assertEquals((String)"Event val not equal", (Object)val, (Object)wrapper.val);
        GatewayDUnitTest.assertEquals((String)"Event arg not equal", (Object)arg, (Object)wrapper.arg);
        GatewayDUnitTest.assertEquals((String)"Event type not equal", (int)type, (int)wrapper.type);
    }

    protected Gateway addGateway(GatewayHub hub, String gatewayName) {
        return hub.addGateway(gatewayName);
    }

    private String getSimpleName() {
        return this.getClass().getSimpleName();
    }

    protected static class TxControlListener
    extends TransactionListenerAdapter {
        public final LinkedList events = new LinkedList();
        public final Object CONTROL_LOCK = new Object();

        protected TxControlListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear() {
            Object object = this.CONTROL_LOCK;
            synchronized (object) {
                this.events.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean waitWhileNoEvents(long sleepMs) {
            Object object = this.CONTROL_LOCK;
            synchronized (object) {
                try {
                    if (this.events.isEmpty()) {
                        this.CONTROL_LOCK.wait(sleepMs);
                    }
                }
                catch (InterruptedException abort) {
                    TestCase.fail((String)"interrupted");
                }
                return !this.events.isEmpty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean waitWhileNotEnoughEvents(long sleepMs, int eventCount) {
            long maxMillis = System.currentTimeMillis() + sleepMs;
            Object object = this.CONTROL_LOCK;
            synchronized (object) {
                try {
                    long waitMillis;
                    while (this.events.size() < eventCount && (waitMillis = maxMillis - System.currentTimeMillis()) >= 10L) {
                        this.CONTROL_LOCK.wait(waitMillis);
                    }
                }
                catch (InterruptedException abort) {
                    TestCase.fail((String)"interrupted");
                }
                return !this.events.isEmpty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void afterCommit(TransactionEvent event) {
            DistributedTestCase.getLogWriter().info("afterCommit event=" + event);
            for (EntryEvent ee : event.getEvents()) {
                Object object = this.CONTROL_LOCK;
                synchronized (object) {
                    int typeCode = 4;
                    if (ee.getOperation().isCreate()) {
                        typeCode = 0;
                    } else if (ee.getOperation().isUpdate()) {
                        typeCode = 1;
                    } else if (ee.getOperation().isInvalidate()) {
                        typeCode = 2;
                    } else if (ee.getOperation().isDestroy()) {
                        typeCode = 3;
                    }
                    this.events.add(new EventWrapper(ee.getKey(), ee.getNewValue(), ee.getCallbackArgument(), typeCode));
                    this.CONTROL_LOCK.notifyAll();
                }
                this.processEvent(ee);
            }
        }

        private void processEvent(EntryEvent event) {
            if (event.getKey().equals(GatewayDUnitTest.KEY_SLEEP)) {
                this.processSleep(event);
            } else if (event.getKey().equals(GatewayDUnitTest.KEY_WAIT)) {
                this.processWait(event);
            } else if (event.getKey().equals(GatewayDUnitTest.KEY_DISCONNECT)) {
                this.processDisconnect(event);
            }
        }

        private void processSleep(EntryEvent event) {
            int sleepMs = (Integer)event.getNewValue();
            DistributedTestCase.getLogWriter().info("[processSleep] sleeping for " + sleepMs);
            try {
                Thread.sleep(sleepMs);
            }
            catch (InterruptedException ignore) {
                TestCase.fail((String)"interrupted");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processWait(EntryEvent event) {
            int sleepMs = (Integer)event.getNewValue();
            DistributedTestCase.getLogWriter().info("[processWait] waiting for " + sleepMs);
            Object object = this.CONTROL_LOCK;
            synchronized (object) {
                try {
                    this.CONTROL_LOCK.wait(sleepMs);
                }
                catch (InterruptedException ignore) {
                    TestCase.fail((String)"interrupted");
                }
            }
        }

        private void processDisconnect(EntryEvent event) {
            DistributedTestCase.getLogWriter().info("[processDisconnect] disconnecting");
            CacheTestCase.disconnectFromDS();
        }
    }

    protected static class ControlListener
    extends CacheListenerAdapter {
        public final LinkedList events = new LinkedList();
        public final Object CONTROL_LOCK = new Object();

        protected ControlListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear() {
            Object object = this.CONTROL_LOCK;
            synchronized (object) {
                this.events.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean waitWhileNoEvents(long sleepMs) {
            Object object = this.CONTROL_LOCK;
            synchronized (object) {
                try {
                    if (this.events.isEmpty()) {
                        this.CONTROL_LOCK.wait(sleepMs);
                    }
                }
                catch (InterruptedException abort) {
                    TestCase.fail((String)"interrupted");
                }
                return !this.events.isEmpty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean waitWhileNotEnoughEvents(long sleepMs, int eventCount) {
            long maxMillis = System.currentTimeMillis() + sleepMs;
            Object object = this.CONTROL_LOCK;
            synchronized (object) {
                try {
                    long waitMillis;
                    while (this.events.size() < eventCount && (waitMillis = maxMillis - System.currentTimeMillis()) >= 10L) {
                        this.CONTROL_LOCK.wait(waitMillis);
                    }
                }
                catch (InterruptedException abort) {
                    TestCase.fail((String)"interrupted");
                }
                return !this.events.isEmpty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void afterCreate(EntryEvent event) {
            DistributedTestCase.getLogWriter().info(event.getRegion().getName() + " afterCreate " + event);
            Object object = this.CONTROL_LOCK;
            synchronized (object) {
                this.events.add(new EventWrapper(event.getKey(), event.getNewValue(), event.getCallbackArgument(), 0));
                this.CONTROL_LOCK.notifyAll();
            }
            this.processEvent(event);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void afterUpdate(EntryEvent event) {
            DistributedTestCase.getLogWriter().info(event.getRegion().getName() + " afterUpdate " + event);
            Object object = this.CONTROL_LOCK;
            synchronized (object) {
                this.events.add(new EventWrapper(event.getKey(), event.getNewValue(), event.getCallbackArgument(), 1));
                this.CONTROL_LOCK.notifyAll();
            }
            this.processEvent(event);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void afterInvalidate(EntryEvent event) {
            DistributedTestCase.getLogWriter().info(event.getRegion().getName() + " afterInvalidate " + event);
            Object object = this.CONTROL_LOCK;
            synchronized (object) {
                this.events.add(new EventWrapper(event.getKey(), event.getNewValue(), event.getCallbackArgument(), 2));
                this.CONTROL_LOCK.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void afterDestroy(EntryEvent event) {
            DistributedTestCase.getLogWriter().info(event.getRegion().getName() + " afterDestroy " + event);
            Object object = this.CONTROL_LOCK;
            synchronized (object) {
                this.events.add(new EventWrapper(event.getKey(), event.getNewValue(), event.getCallbackArgument(), 3));
                this.CONTROL_LOCK.notifyAll();
            }
        }

        private void processEvent(EntryEvent event) {
            if (event.getKey().equals(GatewayDUnitTest.KEY_SLEEP)) {
                this.processSleep(event);
            } else if (event.getKey().equals(GatewayDUnitTest.KEY_WAIT)) {
                this.processWait(event);
            } else if (event.getKey().equals(GatewayDUnitTest.KEY_DISCONNECT)) {
                this.processDisconnect(event);
            }
        }

        private void processSleep(EntryEvent event) {
            int sleepMs = (Integer)event.getNewValue();
            DistributedTestCase.getLogWriter().info("[processSleep] sleeping for " + sleepMs);
            try {
                Thread.sleep(sleepMs);
            }
            catch (InterruptedException ignore) {
                TestCase.fail((String)"interrupted");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processWait(EntryEvent event) {
            int sleepMs = (Integer)event.getNewValue();
            DistributedTestCase.getLogWriter().info("[processWait] waiting for " + sleepMs);
            Object object = this.CONTROL_LOCK;
            synchronized (object) {
                try {
                    this.CONTROL_LOCK.wait(sleepMs);
                }
                catch (InterruptedException ignore) {
                    TestCase.fail((String)"interrupted");
                }
            }
        }

        private void processDisconnect(EntryEvent event) {
            DistributedTestCase.getLogWriter().info("[processDisconnect] disconnecting");
            CacheTestCase.disconnectFromDS();
        }
    }

    private static class EventWrapper {
        public final Object key;
        public final Object val;
        public final Object arg;
        public final int type;

        public EventWrapper(Object key, Object val, Object arg, int type) {
            this.key = key;
            this.val = val;
            this.arg = arg;
            this.type = type;
        }

        public String toString() {
            return "EventWrapper: key=" + this.key + ", val=" + this.val + ", arg=" + this.arg + ", type=" + this.type;
        }
    }
}

