/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache30;

import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheLoader;
import com.gemstone.gemfire.cache.CacheLoaderException;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.LoaderHelper;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.TimeoutException;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.cache30.MultiVMRegionTestCase;
import com.gemstone.gemfire.cache30.RegionTestCase;
import com.gemstone.gemfire.cache30.TestCacheLoader;
import dunit.AsyncInvocation;
import dunit.DistributedTestCase;
import dunit.GemFireSystem;
import dunit.Host;
import dunit.SerializableRunnable;
import dunit.VM;
import java.util.HashSet;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import junit.framework.TestCase;

public class GlobalRegionTest
extends MultiVMRegionTestCase {
    public GlobalRegionTest(String name) {
        super(name);
    }

    @Override
    protected RegionAttributes getRegionAttributes() {
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.GLOBAL);
        factory.setConcurrencyChecksEnabled(false);
        factory.setDataPolicy(DataPolicy.PRELOADED);
        return factory.create();
    }

    public void testIncompatibleSubregions() throws CacheException, InterruptedException {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        final String name = this.getUniqueName() + "-GLOBAL";
        vm0.invoke(new SerializableRunnable("Create GLOBAL Region"){

            @Override
            public void run() {
                try {
                    GlobalRegionTest.this.createRegion(name, "INCOMPATIBLE_ROOT", GlobalRegionTest.this.getRegionAttributes());
                }
                catch (CacheException ex) {
                    DistributedTestCase.fail("While creating GLOBAL region", ex);
                }
                TestCase.assertTrue((boolean)GlobalRegionTest.this.getRootRegion("INCOMPATIBLE_ROOT").getAttributes().getScope().isGlobal());
            }
        });
        vm1.invoke(new SerializableRunnable("Create NO ACK Region"){

            @Override
            public void run() {
                try {
                    AttributesFactory factory = new AttributesFactory(GlobalRegionTest.this.getRegionAttributes());
                    factory.setScope(Scope.DISTRIBUTED_NO_ACK);
                    try {
                        TestCase.assertNull((Object)GlobalRegionTest.this.getRootRegion("INCOMPATIBLE_ROOT"));
                        GlobalRegionTest.this.createRegion(name, "INCOMPATIBLE_ROOT", factory.create());
                        TestCase.fail((String)"Should have thrown an IllegalStateException");
                    }
                    catch (IllegalStateException illegalStateException) {}
                }
                catch (CacheException ex) {
                    DistributedTestCase.fail("While creating GLOBAL Region", ex);
                }
            }
        });
        vm1.invoke(new SerializableRunnable("Create ACK Region"){

            @Override
            public void run() {
                try {
                    AttributesFactory factory = new AttributesFactory(GlobalRegionTest.this.getRegionAttributes());
                    factory.setScope(Scope.DISTRIBUTED_ACK);
                    try {
                        RegionAttributes attrs = factory.create();
                        GlobalRegionTest.this.createRootRegion("INCOMPATIBLE_ROOT", attrs);
                        TestCase.fail((String)"Should have thrown an IllegalStateException");
                        GlobalRegionTest.this.createRegion(name, "INCOMPATIBLE_ROOT", factory.create());
                        TestCase.fail((String)"Should have thrown an IllegalStateException");
                    }
                    catch (IllegalStateException ex) {
                        TestCase.assertNull((Object)GlobalRegionTest.this.getRootRegion());
                    }
                }
                catch (CacheException ex) {
                    DistributedTestCase.fail("While creating GLOBAL Region", ex);
                }
            }
        });
    }

    public void testRemoteFetch() throws CacheException {
        GlobalRegionTest.assertTrue((boolean)this.getRegionAttributes().getScope().isDistributed());
        final String name = this.getUniqueName();
        final String key = "KEY";
        final String value = "VALUE";
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        CacheSerializableRunnable create = new CacheSerializableRunnable("Create Region"){

            @Override
            public void run2() throws CacheException {
                Region region = GlobalRegionTest.this.createRegion(name);
                RegionTestCase.loader = new TestCacheLoader(){

                    @Override
                    public Object load2(LoaderHelper helper) throws CacheLoaderException {
                        TestCase.fail((String)"Should not be invoked");
                        return null;
                    }
                };
                region.getAttributesMutator().setCacheLoader((CacheLoader)RegionTestCase.loader);
            }
        };
        vm0.invoke(create);
        vm0.invoke(new CacheSerializableRunnable("Put"){

            @Override
            public void run2() throws CacheException {
                Region region = GlobalRegionTest.this.getRootRegion().getSubregion(name);
                region.put(key, value);
                TestCase.assertFalse((boolean)RegionTestCase.loader.wasInvoked());
            }
        });
        vm1.invoke(create);
        vm1.invoke(new CacheSerializableRunnable("Get"){

            @Override
            public void run2() throws CacheException {
                Region region = GlobalRegionTest.this.getRootRegion().getSubregion(name);
                TestCase.assertEquals((Object)value, (Object)region.get(key));
                TestCase.assertFalse((boolean)RegionTestCase.loader.wasInvoked());
            }
        });
    }

    public void testSynchronousIncrements() throws InterruptedException {
        int i;
        final String name = this.getUniqueName();
        final String key = "KEY";
        Host host = Host.getHost(0);
        final int vmCount = host.getVMCount();
        int threadsPerVM = 3;
        int incrementsPerThread = 10;
        CacheSerializableRunnable create = new CacheSerializableRunnable("Create region"){

            @Override
            public void run2() throws CacheException {
                GlobalRegionTest.this.createRegion(name);
                Region region = GlobalRegionTest.this.getRootRegion().getSubregion(name);
                region.put(key, (Object)new Integer(0));
            }
        };
        VM vm0 = host.getVM(0);
        vm0.invoke(create);
        HashSet<GemFireSystem> systems = new HashSet<GemFireSystem>();
        systems.add(vm0.getSystem());
        for (int i2 = 1; i2 < vmCount; ++i2) {
            VM vm = host.getVM(i2);
            vm.invoke(create);
            systems.add(vm.getSystem());
        }
        try {
            Thread.sleep(50L);
        }
        catch (InterruptedException e) {
            GlobalRegionTest.fail((String)"interrupted");
        }
        CacheSerializableRunnable increment = new CacheSerializableRunnable("Start Threads and increment"){

            @Override
            public void run2() throws CacheException {
                int i;
                ThreadGroup group = new ThreadGroup("Incrementors"){

                    @Override
                    public void uncaughtException(Thread t, Throwable e) {
                        if (e instanceof VirtualMachineError) {
                            SystemFailure.setFailure((Error)((VirtualMachineError)e));
                        }
                        String s = "Uncaught exception in thread " + t;
                        DistributedTestCase.fail(s, e);
                    }
                };
                Thread[] threads = new Thread[3];
                for (i = 0; i < 3; ++i) {
                    Thread thread;
                    threads[i] = thread = new Thread(group, new Runnable(){

                        @Override
                        public void run() {
                            try {
                                DistributedTestCase.getLogWriter().info("testSynchronousIncrements." + this);
                                Random rand = new Random(System.identityHashCode(this));
                                try {
                                    Region region = GlobalRegionTest.this.getRootRegion().getSubregion(name);
                                    for (int j = 0; j < 10; ++j) {
                                        Integer value;
                                        Thread.sleep(rand.nextInt(30) + 30);
                                        Lock lock = region.getDistributedLock(key);
                                        TestCase.assertTrue((boolean)lock.tryLock(-1L, TimeUnit.MILLISECONDS));
                                        Integer oldValue = value = (Integer)region.get(key);
                                        if (value == null) {
                                            value = new Integer(1);
                                        } else {
                                            Integer v = value;
                                            value = new Integer(v + 1);
                                        }
                                        TestCase.assertEquals((Object)oldValue, (Object)region.get(key));
                                        region.put(key, (Object)value);
                                        TestCase.assertEquals((Object)value, (Object)region.get(key));
                                        DistributedTestCase.getLogWriter().info("testSynchronousIncrements." + this + ": " + key + " -> " + value);
                                        lock.unlock();
                                    }
                                }
                                catch (InterruptedException ex) {
                                    DistributedTestCase.fail("While incrementing", ex);
                                }
                                catch (Exception ex) {
                                    DistributedTestCase.fail("While incrementing", ex);
                                }
                            }
                            catch (VirtualMachineError e) {
                                SystemFailure.initiateFailure((Error)e);
                                throw e;
                            }
                            catch (Throwable t) {
                                DistributedTestCase.getLogWriter().info("testSynchronousIncrements." + this + " caught Throwable", t);
                            }
                        }
                    }, "Incrementer " + i);
                    thread.start();
                }
                for (i = 0; i < threads.length; ++i) {
                    DistributedTestCase.join(threads[i], 30000L, DistributedTestCase.getLogWriter());
                }
            }
        };
        AsyncInvocation[] invokes = new AsyncInvocation[vmCount];
        for (i = 0; i < vmCount; ++i) {
            invokes[i] = host.getVM(i).invokeAsync(increment);
        }
        for (i = 0; i < vmCount; ++i) {
            DistributedTestCase.join(invokes[i], 300000L, GlobalRegionTest.getLogWriter());
            if (!invokes[i].exceptionOccurred()) continue;
            GlobalRegionTest.fail("invocation failed", invokes[i].getException());
        }
        vm0.invoke(new CacheSerializableRunnable("Verify final value"){

            @Override
            public void run2() throws CacheException {
                Region region = GlobalRegionTest.this.getRootRegion().getSubregion(name);
                Integer value = (Integer)region.get(key);
                TestCase.assertNotNull((Object)value);
                int expected = vmCount * 3 * 10;
                TestCase.assertEquals((int)expected, (int)value);
            }
        });
    }

    public void testPutGetTimeout() {
        GlobalRegionTest.assertEquals((Object)Scope.GLOBAL, (Object)this.getRegionAttributes().getScope());
        final String name = this.getUniqueName();
        final String key = "KEY";
        final String value = "VALUE";
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        CacheSerializableRunnable create = new CacheSerializableRunnable("Create Region"){

            @Override
            public void run2() throws CacheException {
                GlobalRegionTest.this.createRegion(name);
            }
        };
        vm0.invoke(create);
        vm1.invoke(create);
        vm0.invoke(new CacheSerializableRunnable("Lock entry"){

            @Override
            public void run2() throws CacheException {
                Region region = GlobalRegionTest.this.getRootRegion().getSubregion(name);
                Lock lock = region.getDistributedLock(key);
                lock.lock();
            }
        });
        vm1.invoke(new CacheSerializableRunnable("Attempt get/put"){

            @Override
            public void run2() throws CacheException {
                Cache cache = GlobalRegionTest.this.getCache();
                cache.setLockTimeout(1);
                cache.setSearchTimeout(1);
                Region region = GlobalRegionTest.this.getRootRegion().getSubregion(name);
                try {
                    region.put(key, value);
                    TestCase.fail((String)"Should have thrown a TimeoutException on put");
                }
                catch (TimeoutException timeoutException) {
                    // empty catch block
                }
                region.getAttributesMutator().setCacheLoader((CacheLoader)new TestCacheLoader(){

                    @Override
                    public Object load2(LoaderHelper helper) {
                        return null;
                    }
                });
                try {
                    region.get(key);
                    TestCase.fail((String)"Should have thrown a TimeoutException on get");
                }
                catch (TimeoutException timeoutException) {
                    // empty catch block
                }
                region.getAttributesMutator().setCacheLoader(null);
                region.get(key);
            }
        });
        vm0.invoke(new CacheSerializableRunnable("Unlock entry"){

            @Override
            public void run2() throws CacheException {
                Region region = GlobalRegionTest.this.getRootRegion().getSubregion(name);
                Lock lock = region.getDistributedLock(key);
                lock.unlock();
            }
        });
    }
}

